

CREATE TABLE `wpcf_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_commentmeta VALUES("1","2","_wxr_import_user","3");



CREATE TABLE `wpcf_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_comments VALUES("1","504","amiscorp | Massa sit amet arcu","","http://spaintc.ae/amiscorp/?p=7687","70.32.72.6","2014-06-11 09:03:08","2014-06-11 09:03:08","[&#8230;] Massa sit amet arcu [&#8230;]","0","1","","pingback","0","0");
INSERT INTO wpcf_comments VALUES("2","4518","Artbees Team","info@artbees.net","","141.101.104.70","2014-09-22 16:03:46","2014-09-22 16:03:46","Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque quis eros lobortis, vestibulum turpis ac, pulvinar odio.","0","1","","","0","0");



CREATE TABLE `wpcf_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT '0',
  `schedule_end` int(10) NOT NULL DEFAULT '0',
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `flag_popup` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_layerslider VALUES("1","1","Home Banner","","{\"properties\":{\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"title\":\"Home Banner\",\"slug\":\"\",\"width\":\"100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}\",\"height\":\"1080px\",\"responsive\":\"on\",\"maxwidth\":\"\",\"forceresponsive\":\"on\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"hideonmobile\":\"on\",\"hideunder\":\"0\",\"hideover\":\"100000\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"skin\":\"v5\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"sliderfadeinduration\":\"350\",\"sliderstyle\":\"margin-bottom: 0px;\",\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"imgpreload\":\"on\",\"lazyload\":\"on\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\"},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"20\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":232,\"background\":\"http:\\/\\/thelighthousefoundation.didone.nl\\/thelighthousefoundation\\/wp-content\\/uploads\\/layerslider\\/Home-Banner\\/home-slide-01.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"2000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Top\",\"media\":\"img\",\"type\":\"p\",\"imageId\":231,\"image\":\"http:\\/\\/thelighthousefoundation.didone.nl\\/thelighthousefoundation\\/wp-content\\/uploads\\/layerslider\\/Home-Banner\\/effect-top.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":false,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":false,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"width\\\":\\\"100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}\\\"}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Bottom\",\"media\":\"img\",\"type\":\"p\",\"imageId\":230,\"image\":\"http:\\/\\/thelighthousefoundation.didone.nl\\/thelighthousefoundation\\/wp-content\\/uploads\\/layerslider\\/Home-Banner\\/effect-bottom.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":false,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":false,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"width\\\":\\\"100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}\\\"}\",\"top\":\"1063px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Main Title\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"WILDERNESS WITHIN REACH\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"font-family\\\":\\\"Raleway\\\",\\\"font-size\\\":\\\"45\\\",\\\"color\\\":\\\"#ffffff\\\"}\",\"top\":\"332px\",\"left\":\"461px\",\"style\":\"font-weight: bold\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Subtitle\",\"media\":\"html\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Donec velit neque auctor sit amet aliquam vel ullam corper <br> donec rutrum congue leo eget misuada.\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"font-family\\\":\\\"Raleway\\\",\\\"font-size\\\":\\\"22\\\",\\\"color\\\":\\\"#ffffff\\\"}\",\"top\":\"405px\",\"left\":\"463px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Button\",\"media\":\"html\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"[mk_button dimension=\\\"outline\\\" corner_style=\\\"rounded\\\" size=\\\"large\\\" icon=\\\"mk-icon-play-circle-o\\\" url=\\\"https:\\/\\/vimeo.com\\/53949996\\\" target=\\\"_blank\\\" align=\\\"center\\\" outline_skin=\\\"custom\\\" outline_active_text_color=\\\"#ffffff\\\" outline_hover_bg_color=\\\"#e3530c\\\"]WATCH FULL VIDEO[\\/mk_button]\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"491px\",\"left\":\"464px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"20\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":233,\"background\":\"http:\\/\\/thelighthousefoundation.didone.nl\\/thelighthousefoundation\\/wp-content\\/uploads\\/layerslider\\/Home-Banner\\/home-slide-02.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"2000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Top\",\"media\":\"img\",\"type\":\"p\",\"imageId\":231,\"image\":\"http:\\/\\/thelighthousefoundation.didone.nl\\/thelighthousefoundation\\/wp-content\\/uploads\\/layerslider\\/Home-Banner\\/effect-top.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":false,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":false,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"width\\\":\\\"100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}\\\"}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Bottom\",\"media\":\"img\",\"type\":\"p\",\"imageId\":230,\"image\":\"http:\\/\\/thelighthousefoundation.didone.nl\\/thelighthousefoundation\\/wp-content\\/uploads\\/layerslider\\/Home-Banner\\/effect-bottom.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":false,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":false,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"width\\\":\\\"100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}\\\"}\",\"top\":\"1063px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Main Title\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"WILDERNESS WITHIN REACH\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"font-family\\\":\\\"Raleway\\\",\\\"font-size\\\":\\\"45\\\",\\\"color\\\":\\\"#ffffff\\\"}\",\"top\":\"332px\",\"left\":\"461px\",\"style\":\"font-weight: bold\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Subtitle\",\"media\":\"html\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Donec velit neque auctor sit amet aliquam vel ullam corper <br> donec rutrum congue leo eget misuada.\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"font-family\\\":\\\"Raleway\\\",\\\"font-size\\\":\\\"22\\\",\\\"color\\\":\\\"#ffffff\\\"}\",\"top\":\"405px\",\"left\":\"463px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Button\",\"media\":\"html\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"[mk_button dimension=\\\"outline\\\" corner_style=\\\"rounded\\\" size=\\\"large\\\" icon=\\\"mk-icon-play-circle-o\\\" url=\\\"https:\\/\\/vimeo.com\\/53949996\\\" target=\\\"_blank\\\" align=\\\"center\\\" outline_skin=\\\"custom\\\" outline_active_text_color=\\\"#ffffff\\\" outline_hover_bg_color=\\\"#e3530c\\\"]WATCH FULL VIDEO[\\/mk_button]\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"491px\",\"left\":\"464px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"20\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":234,\"background\":\"http:\\/\\/thelighthousefoundation.didone.nl\\/thelighthousefoundation\\/wp-content\\/uploads\\/layerslider\\/Home-Banner\\/home-slide-03.jpg\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"2000\",\"timeshift\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Top\",\"media\":\"img\",\"type\":\"p\",\"imageId\":231,\"image\":\"http:\\/\\/thelighthousefoundation.didone.nl\\/thelighthousefoundation\\/wp-content\\/uploads\\/layerslider\\/Home-Banner\\/effect-top.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":false,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":false,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"width\\\":\\\"100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}\\\"}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Bottom\",\"media\":\"img\",\"type\":\"p\",\"imageId\":230,\"image\":\"http:\\/\\/thelighthousefoundation.didone.nl\\/thelighthousefoundation\\/wp-content\\/uploads\\/layerslider\\/Home-Banner\\/effect-bottom.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":false,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":false,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"width\\\":\\\"100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}\\\"}\",\"top\":\"1063px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Main Title\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"WILDERNESS WITHIN REACH\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"font-family\\\":\\\"Raleway\\\",\\\"font-size\\\":\\\"45\\\",\\\"color\\\":\\\"#ffffff\\\"}\",\"top\":\"332px\",\"left\":\"461px\",\"style\":\"font-weight: bold\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Subtitle\",\"media\":\"html\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Donec velit neque auctor sit amet aliquam vel ullam corper <br> donec rutrum congue leo eget misuada.\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\"font-family\\\":\\\"Raleway\\\",\\\"font-size\\\":\\\"22\\\",\\\"color\\\":\\\"#ffffff\\\"}\",\"top\":\"405px\",\"left\":\"463px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Button\",\"media\":\"html\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"[mk_button dimension=\\\"outline\\\" corner_style=\\\"rounded\\\" size=\\\"large\\\" icon=\\\"mk-icon-play-circle-o\\\" url=\\\"https:\\/\\/vimeo.com\\/53949996\\\" target=\\\"_blank\\\" align=\\\"center\\\" outline_skin=\\\"custom\\\" outline_active_text_color=\\\"#ffffff\\\" outline_hover_bg_color=\\\"#e3530c\\\"]WATCH FULL VIDEO[\\/mk_button]\",\"post_text_length\":\"\",\"transition\":\"{\\\"offsetxin\\\":\\\"0\\\",\\\"offsetyin\\\":\\\"0\\\",\\\"durationin\\\":\\\"0\\\",\\\"delayin\\\":\\\"0\\\",\\\"easingin\\\":\\\"linear\\\",\\\"fadein\\\":true,\\\"rotatein\\\":\\\"0\\\",\\\"rotatexin\\\":\\\"0\\\",\\\"rotateyin\\\":\\\"0\\\",\\\"transformoriginin\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxin\\\":\\\"0\\\",\\\"skewyin\\\":\\\"0\\\",\\\"scalexin\\\":\\\"1\\\",\\\"scaleyin\\\":\\\"1\\\",\\\"offsetxout\\\":\\\"0\\\",\\\"offsetyout\\\":\\\"0\\\",\\\"durationout\\\":\\\"0\\\",\\\"showuntil\\\":\\\"0\\\",\\\"easingout\\\":\\\"linear\\\",\\\"fadeout\\\":true,\\\"rotateout\\\":\\\"0\\\",\\\"rotatexout\\\":\\\"0\\\",\\\"rotateyout\\\":\\\"0\\\",\\\"transformoriginout\\\":\\\"50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} 0\\\",\\\"skewxout\\\":\\\"0\\\",\\\"skewyout\\\":\\\"0\\\",\\\"scalexout\\\":\\\"1\\\",\\\"scaleyout\\\":\\\"1\\\",\\\"parallaxlevel\\\":\\\"0\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"491px\",\"left\":\"464px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1542380090","1542380090","0","0","0","0","0");



CREATE TABLE `wpcf_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `wpcf_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `wpcf_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=376 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_options VALUES("1","siteurl","http://thelighthousefoundation.didone.nl/thelighthousefoundation","yes");
INSERT INTO wpcf_options VALUES("2","home","http://thelighthousefoundation.didone.nl/thelighthousefoundation","yes");
INSERT INTO wpcf_options VALUES("3","blogname","The Lighthouse Foundation","yes");
INSERT INTO wpcf_options VALUES("4","blogdescription","The Lighthouse Foundation","yes");
INSERT INTO wpcf_options VALUES("5","users_can_register","0","yes");
INSERT INTO wpcf_options VALUES("6","admin_email","admin@thelighthousefoundation.didone.nl","yes");
INSERT INTO wpcf_options VALUES("7","start_of_week","1","yes");
INSERT INTO wpcf_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO wpcf_options VALUES("9","use_smilies","1","yes");
INSERT INTO wpcf_options VALUES("10","require_name_email","1","yes");
INSERT INTO wpcf_options VALUES("11","comments_notify","1","yes");
INSERT INTO wpcf_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO wpcf_options VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO wpcf_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO wpcf_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO wpcf_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO wpcf_options VALUES("17","mailserver_port","110","yes");
INSERT INTO wpcf_options VALUES("18","default_category","1","yes");
INSERT INTO wpcf_options VALUES("19","default_comment_status","open","yes");
INSERT INTO wpcf_options VALUES("20","default_ping_status","open","yes");
INSERT INTO wpcf_options VALUES("21","default_pingback_flag","1","yes");
INSERT INTO wpcf_options VALUES("22","posts_per_page","10","yes");
INSERT INTO wpcf_options VALUES("23","date_format","F j, Y","yes");
INSERT INTO wpcf_options VALUES("24","time_format","g:i a","yes");
INSERT INTO wpcf_options VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wpcf_options VALUES("26","comment_moderation","0","yes");
INSERT INTO wpcf_options VALUES("27","moderation_notify","1","yes");
INSERT INTO wpcf_options VALUES("28","permalink_structure","/{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}year{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}/{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}monthnum{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}/{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}day{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}/{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}postname{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}/","yes");
INSERT INTO wpcf_options VALUES("29","rewrite_rules","a:354:{s:7:\"team/?$\";s:29:\"index.php?post_type=employees\";s:37:\"team/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=employees&feed=$matches[1]\";s:32:\"team/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=employees&feed=$matches[1]\";s:24:\"team/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=employees&paged=$matches[1]\";s:12:\"faq-items/?$\";s:23:\"index.php?post_type=faq\";s:42:\"faq-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=faq&feed=$matches[1]\";s:37:\"faq-items/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=faq&feed=$matches[1]\";s:29:\"faq-items/page/([0-9]{1,})/?$\";s:41:\"index.php?post_type=faq&paged=$matches[1]\";s:13:\"news-posts/?$\";s:24:\"index.php?post_type=news\";s:43:\"news-posts/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=news&feed=$matches[1]\";s:38:\"news-posts/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=news&feed=$matches[1]\";s:30:\"news-posts/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=news&paged=$matches[1]\";s:18:\"portfolio-posts/?$\";s:29:\"index.php?post_type=portfolio\";s:48:\"portfolio-posts/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:43:\"portfolio-posts/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:35:\"portfolio-posts/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:9:\"albums/?$\";s:31:\"index.php?post_type=photo_album\";s:39:\"albums/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=photo_album&feed=$matches[1]\";s:34:\"albums/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=photo_album&feed=$matches[1]\";s:26:\"albums/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=photo_album&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:35:\"clients/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"clients/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"clients/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"clients/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"clients/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"clients/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"clients/([^/]+)/embed/?$\";s:40:\"index.php?clients=$matches[1]&embed=true\";s:28:\"clients/([^/]+)/trackback/?$\";s:34:\"index.php?clients=$matches[1]&tb=1\";s:36:\"clients/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?clients=$matches[1]&paged=$matches[2]\";s:43:\"clients/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?clients=$matches[1]&cpage=$matches[2]\";s:32:\"clients/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?clients=$matches[1]&page=$matches[2]\";s:24:\"clients/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"clients/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"clients/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"clients/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"clients/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"clients/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"animated-columns/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"animated-columns/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"animated-columns/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"animated-columns/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"animated-columns/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"animated-columns/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"animated-columns/([^/]+)/embed/?$\";s:49:\"index.php?animated-columns=$matches[1]&embed=true\";s:37:\"animated-columns/([^/]+)/trackback/?$\";s:43:\"index.php?animated-columns=$matches[1]&tb=1\";s:45:\"animated-columns/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?animated-columns=$matches[1]&paged=$matches[2]\";s:52:\"animated-columns/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?animated-columns=$matches[1]&cpage=$matches[2]\";s:41:\"animated-columns/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?animated-columns=$matches[1]&page=$matches[2]\";s:33:\"animated-columns/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"animated-columns/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"animated-columns/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"animated-columns/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"animated-columns/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"animated-columns/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"edge/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"edge/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"edge/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"edge/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"edge/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"edge/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"edge/([^/]+)/embed/?$\";s:37:\"index.php?edge=$matches[1]&embed=true\";s:25:\"edge/([^/]+)/trackback/?$\";s:31:\"index.php?edge=$matches[1]&tb=1\";s:33:\"edge/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?edge=$matches[1]&paged=$matches[2]\";s:40:\"edge/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?edge=$matches[1]&cpage=$matches[2]\";s:29:\"edge/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?edge=$matches[1]&page=$matches[2]\";s:21:\"edge/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"edge/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"edge/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"edge/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"edge/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"edge/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:42:\"index.php?employees=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:36:\"index.php?employees=$matches[1]&tb=1\";s:45:\"team/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?employees=$matches[1]&feed=$matches[2]\";s:40:\"team/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?employees=$matches[1]&feed=$matches[2]\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?employees=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?employees=$matches[1]&cpage=$matches[2]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?employees=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"employees_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?employees_category=$matches[1]&feed=$matches[2]\";s:54:\"employees_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?employees_category=$matches[1]&feed=$matches[2]\";s:35:\"employees_category/([^/]+)/embed/?$\";s:51:\"index.php?employees_category=$matches[1]&embed=true\";s:47:\"employees_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?employees_category=$matches[1]&paged=$matches[2]\";s:29:\"employees_category/([^/]+)/?$\";s:40:\"index.php?employees_category=$matches[1]\";s:37:\"faq-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"faq-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"faq-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"faq-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"faq-items/([^/]+)/embed/?$\";s:36:\"index.php?faq=$matches[1]&embed=true\";s:30:\"faq-items/([^/]+)/trackback/?$\";s:30:\"index.php?faq=$matches[1]&tb=1\";s:50:\"faq-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?faq=$matches[1]&feed=$matches[2]\";s:45:\"faq-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?faq=$matches[1]&feed=$matches[2]\";s:38:\"faq-items/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?faq=$matches[1]&paged=$matches[2]\";s:45:\"faq-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:43:\"index.php?faq=$matches[1]&cpage=$matches[2]\";s:34:\"faq-items/([^/]+)(?:/([0-9]+))?/?$\";s:42:\"index.php?faq=$matches[1]&page=$matches[2]\";s:26:\"faq-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"faq-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"faq-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"faq-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:48:\"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:29:\"faq_category/([^/]+)/embed/?$\";s:45:\"index.php?faq_category=$matches[1]&embed=true\";s:41:\"faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq_category=$matches[1]&paged=$matches[2]\";s:23:\"faq_category/([^/]+)/?$\";s:34:\"index.php?faq_category=$matches[1]\";s:38:\"news-posts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"news-posts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"news-posts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"news-posts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"news-posts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"news-posts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"news-posts/([^/]+)/embed/?$\";s:37:\"index.php?news=$matches[1]&embed=true\";s:31:\"news-posts/([^/]+)/trackback/?$\";s:31:\"index.php?news=$matches[1]&tb=1\";s:51:\"news-posts/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?news=$matches[1]&feed=$matches[2]\";s:46:\"news-posts/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?news=$matches[1]&feed=$matches[2]\";s:39:\"news-posts/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?news=$matches[1]&paged=$matches[2]\";s:46:\"news-posts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?news=$matches[1]&cpage=$matches[2]\";s:35:\"news-posts/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?news=$matches[1]&page=$matches[2]\";s:27:\"news-posts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"news-posts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"news-posts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"news-posts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"news-posts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"news-posts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"news_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?news_category=$matches[1]&feed=$matches[2]\";s:49:\"news_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?news_category=$matches[1]&feed=$matches[2]\";s:30:\"news_category/([^/]+)/embed/?$\";s:46:\"index.php?news_category=$matches[1]&embed=true\";s:42:\"news_category/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?news_category=$matches[1]&paged=$matches[2]\";s:24:\"news_category/([^/]+)/?$\";s:35:\"index.php?news_category=$matches[1]\";s:43:\"portfolio-posts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"portfolio-posts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"portfolio-posts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-posts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-posts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"portfolio-posts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"portfolio-posts/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:36:\"portfolio-posts/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:56:\"portfolio-posts/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-posts/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:44:\"portfolio-posts/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:51:\"portfolio-posts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:40:\"portfolio-posts/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:32:\"portfolio-posts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"portfolio-posts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"portfolio-posts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-posts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-posts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"portfolio-posts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:35:\"pricing/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"pricing/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"pricing/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"pricing/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"pricing/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"pricing/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"pricing/([^/]+)/embed/?$\";s:40:\"index.php?pricing=$matches[1]&embed=true\";s:28:\"pricing/([^/]+)/trackback/?$\";s:34:\"index.php?pricing=$matches[1]&tb=1\";s:36:\"pricing/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?pricing=$matches[1]&paged=$matches[2]\";s:43:\"pricing/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?pricing=$matches[1]&cpage=$matches[2]\";s:32:\"pricing/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?pricing=$matches[1]&page=$matches[2]\";s:24:\"pricing/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"pricing/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"pricing/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"pricing/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"pricing/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"pricing/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"tab_slider/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"tab_slider/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"tab_slider/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tab_slider/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tab_slider/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"tab_slider/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"tab_slider/([^/]+)/embed/?$\";s:43:\"index.php?tab_slider=$matches[1]&embed=true\";s:31:\"tab_slider/([^/]+)/trackback/?$\";s:37:\"index.php?tab_slider=$matches[1]&tb=1\";s:39:\"tab_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?tab_slider=$matches[1]&paged=$matches[2]\";s:46:\"tab_slider/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?tab_slider=$matches[1]&cpage=$matches[2]\";s:35:\"tab_slider/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?tab_slider=$matches[1]&page=$matches[2]\";s:27:\"tab_slider/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"tab_slider/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"tab_slider/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tab_slider/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tab_slider/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"tab_slider/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"testimonial_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial_category=$matches[1]&feed=$matches[2]\";s:56:\"testimonial_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial_category=$matches[1]&feed=$matches[2]\";s:37:\"testimonial_category/([^/]+)/embed/?$\";s:53:\"index.php?testimonial_category=$matches[1]&embed=true\";s:49:\"testimonial_category/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?testimonial_category=$matches[1]&paged=$matches[2]\";s:31:\"testimonial_category/([^/]+)/?$\";s:42:\"index.php?testimonial_category=$matches[1]\";s:34:\"albums/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"albums/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"albums/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"albums/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"albums/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"albums/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"albums/([^/]+)/embed/?$\";s:44:\"index.php?photo_album=$matches[1]&embed=true\";s:27:\"albums/([^/]+)/trackback/?$\";s:38:\"index.php?photo_album=$matches[1]&tb=1\";s:47:\"albums/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?photo_album=$matches[1]&feed=$matches[2]\";s:42:\"albums/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?photo_album=$matches[1]&feed=$matches[2]\";s:35:\"albums/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?photo_album=$matches[1]&paged=$matches[2]\";s:42:\"albums/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?photo_album=$matches[1]&cpage=$matches[2]\";s:31:\"albums/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?photo_album=$matches[1]&page=$matches[2]\";s:23:\"albums/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"albums/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"albums/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"albums/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"albums/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"albums/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"photo_album_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?photo_album_category=$matches[1]&feed=$matches[2]\";s:56:\"photo_album_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?photo_album_category=$matches[1]&feed=$matches[2]\";s:37:\"photo_album_category/([^/]+)/embed/?$\";s:53:\"index.php?photo_album_category=$matches[1]&embed=true\";s:49:\"photo_album_category/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?photo_album_category=$matches[1]&paged=$matches[2]\";s:31:\"photo_album_category/([^/]+)/?$\";s:42:\"index.php?photo_album_category=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:39:\"mkhb_header/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"mkhb_header/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"mkhb_header/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"mkhb_header/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"mkhb_header/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"mkhb_header/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"mkhb_header/([^/]+)/embed/?$\";s:44:\"index.php?mkhb_header=$matches[1]&embed=true\";s:32:\"mkhb_header/([^/]+)/trackback/?$\";s:38:\"index.php?mkhb_header=$matches[1]&tb=1\";s:40:\"mkhb_header/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?mkhb_header=$matches[1]&paged=$matches[2]\";s:47:\"mkhb_header/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?mkhb_header=$matches[1]&cpage=$matches[2]\";s:36:\"mkhb_header/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?mkhb_header=$matches[1]&page=$matches[2]\";s:28:\"mkhb_header/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"mkhb_header/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"mkhb_header/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"mkhb_header/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"mkhb_header/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"mkhb_header/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=7&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}","yes");
INSERT INTO wpcf_options VALUES("30","hack_file","0","yes");
INSERT INTO wpcf_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO wpcf_options VALUES("32","moderation_keys","","no");
INSERT INTO wpcf_options VALUES("33","active_plugins","a:4:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:27:\"artbees-captcha/captcha.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:33:\"js_composer_theme/js_composer.php\";}","yes");
INSERT INTO wpcf_options VALUES("34","category_base","","yes");
INSERT INTO wpcf_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wpcf_options VALUES("36","comment_max_links","2","yes");
INSERT INTO wpcf_options VALUES("37","gmt_offset","0","yes");
INSERT INTO wpcf_options VALUES("38","default_email_category","1","yes");
INSERT INTO wpcf_options VALUES("39","recently_edited","","no");
INSERT INTO wpcf_options VALUES("40","template","jupiter","yes");
INSERT INTO wpcf_options VALUES("41","stylesheet","jupiter","yes");
INSERT INTO wpcf_options VALUES("42","comment_whitelist","1","yes");
INSERT INTO wpcf_options VALUES("43","blacklist_keys","","no");
INSERT INTO wpcf_options VALUES("44","comment_registration","0","yes");
INSERT INTO wpcf_options VALUES("45","html_type","text/html","yes");
INSERT INTO wpcf_options VALUES("46","use_trackback","0","yes");
INSERT INTO wpcf_options VALUES("47","default_role","subscriber","yes");
INSERT INTO wpcf_options VALUES("48","db_version","38590","yes");
INSERT INTO wpcf_options VALUES("49","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wpcf_options VALUES("50","upload_path","","yes");
INSERT INTO wpcf_options VALUES("51","blog_public","1","yes");
INSERT INTO wpcf_options VALUES("52","default_link_category","2","yes");
INSERT INTO wpcf_options VALUES("54","tag_base","","yes");
INSERT INTO wpcf_options VALUES("55","show_avatars","1","yes");
INSERT INTO wpcf_options VALUES("56","avatar_rating","G","yes");
INSERT INTO wpcf_options VALUES("57","upload_url_path","","yes");
INSERT INTO wpcf_options VALUES("58","thumbnail_size_w","150","yes");
INSERT INTO wpcf_options VALUES("59","thumbnail_size_h","150","yes");
INSERT INTO wpcf_options VALUES("60","thumbnail_crop","1","yes");
INSERT INTO wpcf_options VALUES("61","medium_size_w","300","yes");
INSERT INTO wpcf_options VALUES("62","medium_size_h","300","yes");
INSERT INTO wpcf_options VALUES("63","avatar_default","mystery","yes");
INSERT INTO wpcf_options VALUES("64","large_size_w","1024","yes");
INSERT INTO wpcf_options VALUES("65","large_size_h","1024","yes");
INSERT INTO wpcf_options VALUES("66","image_default_link_type","none","yes");
INSERT INTO wpcf_options VALUES("67","image_default_size","","yes");
INSERT INTO wpcf_options VALUES("68","image_default_align","","yes");
INSERT INTO wpcf_options VALUES("69","close_comments_for_old_posts","0","yes");
INSERT INTO wpcf_options VALUES("70","close_comments_days_old","14","yes");
INSERT INTO wpcf_options VALUES("71","thread_comments","1","yes");
INSERT INTO wpcf_options VALUES("72","thread_comments_depth","5","yes");
INSERT INTO wpcf_options VALUES("73","page_comments","0","yes");
INSERT INTO wpcf_options VALUES("74","comments_per_page","50","yes");
INSERT INTO wpcf_options VALUES("75","default_comments_page","newest","yes");
INSERT INTO wpcf_options VALUES("76","comment_order","asc","yes");
INSERT INTO wpcf_options VALUES("77","sticky_posts","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("81","uninstall_plugins","a:1:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";}","no");
INSERT INTO wpcf_options VALUES("82","timezone_string","","yes");
INSERT INTO wpcf_options VALUES("83","page_for_posts","0","yes");
INSERT INTO wpcf_options VALUES("85","default_post_format","0","yes");
INSERT INTO wpcf_options VALUES("86","link_manager_enabled","0","yes");
INSERT INTO wpcf_options VALUES("87","finished_splitting_shared_terms","1","yes");
INSERT INTO wpcf_options VALUES("88","site_icon","0","yes");
INSERT INTO wpcf_options VALUES("89","medium_large_size_w","768","yes");
INSERT INTO wpcf_options VALUES("90","medium_large_size_h","0","yes");
INSERT INTO wpcf_options VALUES("91","wp_page_for_privacy_policy","3","yes");
INSERT INTO wpcf_options VALUES("92","show_comments_cookies_opt_in","0","yes");
INSERT INTO wpcf_options VALUES("93","initial_db_version","38590","yes");
INSERT INTO wpcf_options VALUES("94","wpcf_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO wpcf_options VALUES("95","fresh_site","0","yes");
INSERT INTO wpcf_options VALUES("243","widget_gmap","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("242","widget_contact_info","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("241","widget_contact_form","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("240","widget_layerslider_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("239","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("238","widget_nav_menu","a:2:{i:1;a:1:{s:8:\"nav_menu\";i:2;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("237","widget_tag_cloud","a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:8:\"taxonomy\";s:8:\"post_tag\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("236","widget_rss","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("111","cron","a:4:{i:1542394198;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1542419398;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1542462652;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wpcf_options VALUES("112","theme_mods_twentyseventeen","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1542379518;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO wpcf_options VALUES("130","_site_transient_timeout_community-events-6c859e3da379e62d6c7b623bf412e2d8","1542419454","no");
INSERT INTO wpcf_options VALUES("328","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/nl_NL/wordpress-4.9.8.zip\";s:6:\"locale\";s:5:\"nl_NL\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/nl_NL/wordpress-4.9.8.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.8\";s:7:\"version\";s:5:\"4.9.8\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1542384487;s:15:\"version_checked\";s:5:\"4.9.8\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO wpcf_options VALUES("148","_transient_timeout_plugin_slugs","1542465812","no");
INSERT INTO wpcf_options VALUES("127","_site_transient_timeout_browser_33aa4f9e9e7c043bc50ebd9a38c97fa8","1542981052","no");
INSERT INTO wpcf_options VALUES("128","_site_transient_browser_33aa4f9e9e7c043bc50ebd9a38c97fa8","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"70.0.3538.102\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no");
INSERT INTO wpcf_options VALUES("287","_site_transient_timeout_theme_roots","1542384629","no");
INSERT INTO wpcf_options VALUES("288","_site_transient_theme_roots","a:7:{s:8:\"__MACOSX\";s:7:\"/themes\";s:13:\"jupiter-child\";s:7:\"/themes\";s:7:\"jupiter\";s:7:\"/themes\";s:5:\"tiwaz\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}","no");
INSERT INTO wpcf_options VALUES("122","WPLANG","nl_NL","yes");
INSERT INTO wpcf_options VALUES("249","widget_flickr","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("250","widget_instagram","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("131","_site_transient_community-events-6c859e3da379e62d6c7b623bf412e2d8","a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"86.83.123.0\";}s:6:\"events\";a:5:{i:0;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:57:\"Meetup Haarlem - Voor iedereen die de naam WordPress kent\";s:3:\"url\";s:65:\"https://www.meetup.com/Haarlem-WordPress-Meetup/events/255163751/\";s:6:\"meetup\";s:24:\"Haarlem WordPress Meetup\";s:10:\"meetup_url\";s:48:\"https://www.meetup.com/Haarlem-WordPress-Meetup/\";s:4:\"date\";s:19:\"2018-11-19 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:20:\"Haarlem, Netherlands\";s:7:\"country\";s:2:\"nl\";s:8:\"latitude\";d:52.3968119999999970559656503610312938690185546875;s:9:\"longitude\";d:4.65691100000000002268052412546239793300628662109375;}}i:1;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:41:\"WordPress MeetUp Utrecht 22 november 2018\";s:3:\"url\";s:65:\"https://www.meetup.com/WordPress-Meetup-Utrecht/events/255479563/\";s:6:\"meetup\";s:24:\"WordPress Meetup Utrecht\";s:10:\"meetup_url\";s:48:\"https://www.meetup.com/WordPress-Meetup-Utrecht/\";s:4:\"date\";s:19:\"2018-11-22 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:20:\"Utrecht, Netherlands\";s:7:\"country\";s:2:\"nl\";s:8:\"latitude\";d:52.064255000000002837623469531536102294921875;s:9:\"longitude\";d:5.10852400000000006485834092018194496631622314453125;}}i:2;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:14:\"WordCamp Lille\";s:3:\"url\";s:31:\"https://2018.lille.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2018-12-07 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:5:\"Lille\";s:7:\"country\";s:2:\"FR\";s:8:\"latitude\";d:50.63747289999999878773451200686395168304443359375;s:9:\"longitude\";d:3.060204999999999841975295566953718662261962890625;}}i:3;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:80:\"Wij zijn op zoek naar interessante sprekers, ben / weet jij iemand, let us know!\";s:3:\"url\";s:71:\"https://www.meetup.com/WordPress-Meetup-Heerhugowaard/events/249416398/\";s:6:\"meetup\";s:30:\"WordPress Meetup Heerhugowaard\";s:10:\"meetup_url\";s:54:\"https://www.meetup.com/WordPress-Meetup-Heerhugowaard/\";s:4:\"date\";s:19:\"2018-12-12 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:26:\"Heerhugowaard, Netherlands\";s:7:\"country\";s:2:\"nl\";s:8:\"latitude\";d:52.6681439999999980727807269431650638580322265625;s:9:\"longitude\";d:4.82080600000000014659917724202387034893035888671875;}}i:4;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:77:\"Hoe maak je je website toegankelijk en hoe gebruik je Advanced Custom Fields?\";s:3:\"url\";s:64:\"https://www.meetup.com/Leiden-WordPress-Meetup/events/254812707/\";s:6:\"meetup\";s:23:\"Leiden WordPress Meetup\";s:10:\"meetup_url\";s:47:\"https://www.meetup.com/Leiden-WordPress-Meetup/\";s:4:\"date\";s:19:\"2018-12-12 19:15:00\";s:8:\"location\";a:4:{s:8:\"location\";s:23:\"Leiderdorp, Netherlands\";s:7:\"country\";s:2:\"nl\";s:8:\"latitude\";d:52.1651200000000017098500393331050872802734375;s:9:\"longitude\";d:4.517464000000000368117980542592704296112060546875;}}}}","no");
INSERT INTO wpcf_options VALUES("132","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1542419455","no");
INSERT INTO wpcf_options VALUES("133","_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Nov 2018 01:11:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-beta5-43907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/11/wordpress-5-0-beta-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Nov 2018 01:09:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6250\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"WordPress 5.0 Beta 5 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test this WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4738:\"\n<p>WordPress 5.0 Beta 5 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>There are two ways to test this WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta5.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p><strong>Reminder: the WordPress 5.0 release date has changed</strong>. It is now scheduled for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 27</a>, and we need your help to get there. Here are some of the big issues that we’ve fixed since Beta 4:</p>\n\n\n\n<h2>Block Editor</h2>\n\n\n\n<p>The block editor has been updated to match the <a href=\"https://make.wordpress.org/core/2018/11/15/whats-new-in-gutenberg-15th-november-2/\">Gutenberg 4.4 release</a>, the major changes  include:</p>\n\n\n\n<ul><li>&nbsp;A <a href=\"https://github.com/WordPress/gutenberg/pull/11874\">permalink panel has been added to the document sidebar</a> to make it easier to find.</li><li>Editor document panels can now be <a href=\"https://github.com/WordPress/gutenberg/pull/11802\">programmatically removed</a>.</li><li>The uploading indicator for images and galleries has been replaced with a&nbsp;<a href=\"https://github.com/WordPress/gutenberg/pull/11876\">spinner and faded out image</a>.</li><li>The text and code editing blocks will now <a href=\"https://github.com/WordPress/gutenberg/pull/11750\">use the full width of the editor</a>.</li><li>Image handling has been improved. Images now  take up the right amount of space for <a href=\"https://github.com/WordPress/gutenberg/pull/11846\">themes with wider editors</a> (like Twenty Nineteen).<br></li><li>Hover styles are now <a href=\"https://github.com/WordPress/gutenberg/pull/10333\">correctly disabled for mobile devices</a>.</li><li>The i18n module has been refactored to benefit from <a href=\"https://github.com/WordPress/gutenberg/pull/11493\">significant performance gains</a>.</li></ul>\n\n\n\n<p>Additionally, there have been some pesky bugs fixed:</p>\n\n\n\n<ul><li>Better handling for <a href=\"https://github.com/WordPress/gutenberg/pull/11590\">links without an href</a> attribute, which were showing as <code>undefined</code>.</li><li>Japanese text (double byte characters) are <a href=\"https://github.com/WordPress/gutenberg/pull/11908\">now usable in the list block</a>.</li><li>Better handling for different text encodings (e.g. emoji) within a block <a href=\"https://github.com/WordPress/gutenberg/pull/11771\">in block validation</a>.</li></ul>\n\n\n\n<p>A full list of changes can be found in the <a href=\"https://make.wordpress.org/core/2018/11/15/whats-new-in-gutenberg-15th-november-2/\">Gutenberg 4.4 release post</a>.<br></p>\n\n\n\n<h2>PHP 7.3 Support</h2>\n\n\n\n<p>The final known PHP 7.3 compatibility issue has been fixed. You can brush up on what you need to know about PHP 7.3 and WordPress by checking out the <a href=\"https://make.wordpress.org/core/2018/10/15/wordpress-and-php-7-3/\">developer note on the Make WordPress Core blog</a>.<br></p>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>Work on making Twenty Nineteen ready for prime time continues on its <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>. This update includes <a href=\"https://core.trac.wordpress.org/changeset/43904\">a host of tweaks and bug fixes</a>, including:</p>\n\n\n\n<ul><li>Add <code>.button</code> class support.</li><li>Fix editor font-weights for headings.</li><li>Improve support for sticky toolbars in the editor.</li><li>Improve text-selection custom colors for better contrast and legibility.</li><li>Fix editor to prevent Gutenberg&#8217;s meta boxes area from overlapping the content.</li></ul>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;</p>\n\n\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6250\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/11/wordpress-5-0-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Nov 2018 01:27:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6241\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"WordPress 5.0 Beta 4 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test the WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3700:\"\n<p>WordPress 5.0 Beta 4 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta4.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p><strong>The WordPress 5.0 release date has changed</strong>, it is now scheduled for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 27</a>, and we need your help to get there. Here are some of the big issues that we’ve fixed since Beta 3:</p>\n\n\n\n<h2>Block Editor</h2>\n\n\n\n<p>The block editor has been updated to match the <a href=\"https://make.wordpress.org/core/2018/11/12/whats-new-in-gutenberg-12th-november/\">Gutenberg 4.3 release</a>, the major changes  include:</p>\n\n\n\n<ul><li>An <a href=\"https://github.com/WordPress/gutenberg/pull/7718\">Annotations API</a>, allowing plugins to add  contextual data as you write.</li><li>More consistent keyboard navigation between blocks, as well as back-and-forth between different areas of the interface.</li><li>Improved accessibility, with additional  labelling and speech announcements.</li></ul>\n\n\n\n<p>Additionally, there have been some bugs fixed that popped up in beta 3:</p>\n\n\n\n<ul><li>Better support for plugins that have more advanced meta box usage.</li><li>Script concatenation is now supported.</li><li>Ajax calls could occasionally cause PHP errors.</li></ul>\n\n\n\n<h2>Internationalisation</h2>\n\n\n\n<p>We&#8217;ve added an API for translating your plugin and theme strings in JavaScript files! The block editor is now using this, and you can start using it, too. Check out the <a href=\"https://make.wordpress.org/core/2018/11/09/new-javascript-i18n-support-in-wordpress/\">developer note</a>&nbsp;to get started.</p>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>Twenty Nineteen is being polished over on its <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>. This update includes <a href=\"https://core.trac.wordpress.org/changeset/43892\">a host of tweaks and bug fixes</a>, including:</p>\n\n\n\n<ul><li>Menus now  properly support keyboard and touch interactions.</li><li>A footer menu has been added for secondary page links.</li><li>Improved backwards compatibility with older versions of WordPress.</li></ul>\n\n\n\n<h2>Default Themes</h2>\n\n\n\n<p>All of the older default themes—from Twenty Ten through to Twenty Seventeen—have polished  styling in the block editor.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;</p>\n\n\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>International-<br>isation is a word with<br>many syllables.</em></p>\n\n\n\n<p><em>Meta boxes are<br>the original style block.<br>Old is new again.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6241\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/11/wordpress-5-0-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 00:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6236\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"WordPress 5.0 Beta 3 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test the WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3198:\"\n<p>WordPress 5.0 Beta 3 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta3.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big issues that we&#8217;ve fixed since Beta 2:</p>\n\n\n\n<h2>Block Editor</h2>\n\n\n\n<p>The block editor has been updated to include all of the features and bug fixes from the upcoming <a href=\"https://make.wordpress.org/core/2018/10/31/whats-new-in-gutenberg-31st-october-2/\">Gutenberg 4.2 release</a>. Additionally, there are some newer bug fixes and features, such as:</p>\n\n\n\n<ul><li>Adding support for the &#8220;Custom Fields&#8221; meta box.</li><li>Improving the reliability of REST API requests.</li><li>A myriad of minor tweaks and improvements.</li></ul>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>Twenty Nineteen has been updated from its <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>, this version is full of new goodies to check out:</p>\n\n\n\n<ul><li>Adds support for Selective Refresh Widgets in the Customiser.</li><li>Adds support for Responsive Embeds.</li><li>Tweaks to improve readability and functionality on mobile devices.</li><li>Fixes nested blocks appearing wider than they should be.</li><li>Fixes some errors in older PHP versions, and in IE11.</li></ul>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> </p>\n\n\n\n<p>If you&#8217;re able to contribute with coding or testing changes, we have <a href=\"https://make.wordpress.org/core/2018/11/02/upcoming-5-0-bug-scrubs/\">a multitude of bug scrubs</a> scheduled this week, we&#8217;d love to have as many people as we can ensuring all bugs reported get the attention they deserve.</p>\n\n\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>WordPress Five Point Oh<br>is just two short weeks away.<br>Thank you for helping!</em> <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f496.png\" alt=\"💖\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><em><br></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6236\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Quarterly Updates | Q3 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/11/quarterly-updates-q3-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Nov 2018 16:46:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6206\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s listed representatives. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:14629:\"\n<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.</em></p>\n\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a>, <a href=\'https://profiles.wordpress.org/arush/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>arush</a></li>\n<li><strong>Priority</strong>: Work on authoring a manual for assistive technology users on Gutenberg, led by Claire Brotherton (<a href=\'https://profiles.wordpress.org/abrightclearweb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>abrightclearweb</a>). Continue to work on improving the overall user experience in Gutenberg. Update and organize the WP A11y handbook.</li>\n<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. Still over 100 outstanding issues, and developing the Gutenberg AT manual helps expose additional issues. The announcement of an accessibility focus on 4.9.9 derailed our planning for Gutenberg in September with minimal productivity, as that goal was quickly withdrawn from the schedule.</li>\n<li><strong>Big Win</strong>: Getting focus constraint implemented in popovers and similar components in Gutenberg.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: @danielbachhuber, <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a></li>\n<li><strong>Priority</strong>: Current priority is v2.1.0 of WP-CLI, to polish the major refactoring v2.0.0 introduced. You can <a href=\"https://make.wordpress.org/cli/good-first-issues/\">join in or follow progress</a> on their site.</li>\n<li><strong>Struggle</strong>: Getting enough contributors to make peer-review possible/manageable.</li>\n<li><strong>Big Win</strong>: The major refactoring of v2 was mostly without any negative impacts on existing installs. It provided substantial improvements to maintainability including: faster and more reliable testing, more straight-forward changes to individual packages, and simpler contributor on-boarding.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/hlashbrooke/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hlashbrooke</a></li>\n<li><strong>Priority</strong>: Supporting contributors of all levels via: monthly <a href=\"https://make.wordpress.org/community/2018/10/08/announcement-monthly-chat-for-wordcamp-organisers/\">WordCamp Organizers chat</a>, better onboarding with a translated <a href=\"https://make.wordpress.org/community/2017/08/11/global-community-team-welcome-pack/\">welcome pack</a>, and Contribution Drive documentation.</li>\n<li><strong>Struggle</strong>: Fewer contributors than usual.</li>\n<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/community/2018/09/21/meetup-application-vetting-sprint-26-27-september/\">Meetup Vetting Sprint</a>! </li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a></li>\n<li><strong>Priority</strong>: Continued preparation for the 5.0 release cycle and Gutenberg.</li>\n<li><strong>Struggle</strong>: Identifying tasks for first time contributors, as well as for new-to-JS contributors.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/boemedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>boemedia</a>, <a href=\'https://profiles.wordpress.org/joshuawold/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joshuawold</a>, <a href=\'https://profiles.wordpress.org/mizejewski/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mizejewski</a></li>\n<li><strong>Priority</strong>: Preparing for WordPress 5.0 and continuing to work on better onboarding practices.</li>\n<li><strong>Struggle</strong>: Identifying tasks for contributor days, especially for small- to medium-sized tasks that can be fit into a single day.</li>\n<li><strong>Big Win</strong>: Regular contributions are starting to build up.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/kenshino/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kenshino</a></li>\n<li><strong>Priority</strong>: Getting HelpHub out before WordPress 5.0&#8217;s launch to make sure Gutenberg User Docs have a permanent position to reside</li>\n<li><strong>Struggle</strong>: Getting the documentation from HelpHub into WordPress.org/support is more manual than initially anticipated.</li>\n<li><strong>Big Win</strong>: Had a good discussion with the Gutenberg team about their docs and how WordPress.org expects documentation to be distributed (via DevHub, Make and HelpHub). Getting past the code blocks to release HelpHub (soon)</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/mikeschroder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mikeschroder</a>, <a href=\'https://profiles.wordpress.org/jadonn/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jadonn</a></li>\n<li><strong>Priority</strong>: Helping Gutenberg land well at hosts for users in 5.0.</li>\n<li><strong>Struggle</strong>: Short time frame with few resources to accomplish priority items.</li>\n<li><strong>Big Win</strong>: Preparing Try Gutenberg support guide for hosts during the rollout and good reception from users following it.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bridgetwillard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bridgetwillard</a></li>\n<li><strong>Priority</strong>: Continuing to write and publish case studies from the community.</li>\n<li><strong>Big Win</strong>: Onboarding guide is going well and is currently being <a href=\"https://translate.wordpress.org/projects/meta/get-involved\">translated</a>.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/tellyworth/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tellyworth</a>, <a href=\'https://profiles.wordpress.org/coffee2code/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>coffee2code</a></li>\n<li><strong>Priority</strong>: Support for other teams in the lead up to, and the follow-up of, the release of WP 5.0. ETA is the WP 5.0 release date (Nov 19) and thereafter, unless it gets bumped to next quarter.</li>\n<li><strong>Struggle</strong>: Maintaining momentum on tickets (still).</li>\n<li><strong>Big Win</strong>: Launch of front-end demo of Gutenberg on https://wordpress.org/gutenberg/</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/elibud/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>elibud</a></li>\n<li><strong>Priority</strong>: Have an alpha version of Gutenberg in the WordPress apps, ETA end of year 2018.</li>\n<li><strong>Struggle</strong>: Unfamiliar tech stack and the goal of reusing as much of Gutenberg-web&#8217;s code as possible.</li>\n<li><strong>Big Win</strong>: Running mobile tests on web&#8217;s PRs.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/ipstenu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ipstenu</a></li>\n<li><strong>Priority</strong>: Cleaning up &#8216;inactive&#8217; users, which was supposed to be complete but some work preparing for 5.0 was necessary.</li>\n<li><strong>Struggles</strong>: Devnotes are lacking for the upcoming release which slows progress.</li>\n<li><strong>Big Win</strong>: No backlog even though a lot were out!</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/petya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>petya</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a>, <a href=\'https://profiles.wordpress.org/chantalc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chantalc</a>, <a href=\'https://profiles.wordpress.org/deconf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>deconf</a>, <a href=\'https://profiles.wordpress.org/casiepa/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>casiepa</a></li>\n<li><strong>Priority</strong>: Help re-activating inactive locale teams.</li>\n<li><strong>Struggle</strong>: Many GTEs are having a hard time keeping up with incoming translation <a href=\"https://make.wordpress.org/polyglots/?resolved=unresolved&amp;tags=editor-requests\">validation and PTE requests</a>.</li>\n<li><strong>Big Win</strong>: Made some progress in locale research and reassigning new GTEs.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/clorith/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clorith</a></li>\n<li><strong>Priority:</strong> Preparing for the upcoming 5.0 release</li>\n<li><strong>Struggle</strong>: Finding a good balance between how much we want to help people and how much we are able to help people. Also, contributor recruitment (always a crowd favorite!)</li>\n<li><strong>Big Win</strong>: How well the team, on a global level, has managed to maintain a good flow of user engagement through support.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/acosmin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>acosmin</a>, <a href=\'https://profiles.wordpress.org/rabmalin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rabmalin</a>, <a href=\'https://profiles.wordpress.org/thinkupthemes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thinkupthemes</a>, <a href=\'https://profiles.wordpress.org/williampatton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>williampatton</a></li>\n<li><strong>Priority</strong>: Implementing the Theme Sniffer plugin on WordPress.org which is one step forward towards automation. ETA early 2019</li>\n<li><strong>Struggle</strong>: Not having so many contributors/reviewers.</li>\n<li><strong>Big Win</strong>: Implementing <a href=\"https://make.wordpress.org/themes/2018/10/25/new-requirements/\">multiple requirements</a> into our review flow, like screenshots and readme.txt requirements.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bethsoderberg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bethsoderberg</a>, <a href=\'https://profiles.wordpress.org/juliek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>juliek</a></li>\n<li><strong>Priority:</strong> Getting the learn.wordpress.org site designed, developed, and being able to publish lesson plans to it.</li>\n<li><strong>Struggle:</strong> Getting contributors onboard and continually contributing. Part of that is related to the learn.wordpress.org site. People like to see their contributions.</li>\n<li><strong>Big Win</strong>: We have our new workflow and tools in place. We are also streamlining that process to help things go from idea to publication more quickly.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:paragraph --></p>\n<p><em>Interested in updates from the last quarter? You can find those here: <a href=\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\">https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/</a></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6206\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"The Month in WordPress: October 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/11/the-month-in-wordpress-october-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Nov 2018 08:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6230\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:331:\"Teams across the WordPress project are working hard to make sure everything is ready for the upcoming release of WordPress 5.0. Find out what’s going on and how you can get involved. The Plan for WordPress 5.0 Early this month, the planned release schedule was announced for WordPress 5.0, which was updated a few weeks [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8116:\"\n<p>Teams across the WordPress project are working hard to make sure everything is ready for the upcoming release of WordPress 5.0. Find out what’s going on and how you can get involved.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>The Plan for WordPress 5.0</h2>\n\n\n\n<p>Early this month, <a href=\"https://make.wordpress.org/core/2018/10/03/proposed-wordpress-5-0-scope-and-schedule/\">the planned release schedule was announced</a> for WordPress 5.0, which was <a href=\"https://make.wordpress.org/core/2018/10/31/wordpress-5-0-schedule-updates/\">updated</a> a few weeks later. WordPress 5.0 is a highly anticipated release, as it’s the official &nbsp;launch of Gutenberg &#8212; the new block editor for WordPress Core. For more detail, check out this <a href=\"https://make.wordpress.org/core/2018/10/12/granular-timeline/\">&nbsp;granular timeline</a>.<br></p>\n\n\n\n<p>Along with the planned release schedule, <a href=\'https://profiles.wordpress.org/matt/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>matt</a>, who is heading up this release, <a href=\"https://make.wordpress.org/core/2018/10/03/a-plan-for-5-0/\">announced leads for critical focuses on the project</a>, including <a href=\'https://profiles.wordpress.org/matveb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>matveb</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/laurelfulford/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurelfulford</a>, <a href=\'https://profiles.wordpress.org/allancole/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>allancole</a>, <a href=\'https://profiles.wordpress.org/lonelyvegan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lonelyvegan</a>, <a href=\'https://profiles.wordpress.org/omarreiss/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>omarreiss</a>, <a href=\'https://profiles.wordpress.org/antpb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>antpb</a>, <a href=\'https://profiles.wordpress.org/pento/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>pento</a>, <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, <a href=\'https://profiles.wordpress.org/danielbachhuber/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>danielbachhuber</a>, and <a href=\'https://profiles.wordpress.org/mcsf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mcsf</a>.<br></p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-2/\">WordPress 5.0 is currently in its second beta phase</a> and will soon move to the release candidate status. Help test this release right now by installing the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester plugin</a> on your site.<br></p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. You can also help out by <a href=\"https://make.wordpress.org/test/\">testing</a> or <a href=\"https://make.wordpress.org/polyglots/2018/10/24/wordpress-5-0-gutenberg-and-twenty-nineteen/\">translating</a> the release into a local language.</p>\n\n\n\n<h2>New Editor for WordPress Core</h2>\n\n\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/10/31/whats-new-in-gutenberg-31st-october-2/\">The latest release</a> is feature complete, meaning that all further development on it will be to improve existing features and fix outstanding bugs.<br></p>\n\n\n\n<p>Some have raised concerns about Gutenberg’s accessibility, prompting the development team <a href=\"https://make.wordpress.org/core/2018/10/18/regarding-accessibility-in-gutenberg/\">to detail some areas</a> in which the new editor is accessible. To help improve things further, the team has made <a href=\"https://make.wordpress.org/core/2018/10/19/call-for-testers-community-gutenberg-accessibility-tests/\">a public call for accessibility testers</a> to assist.<br></p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg\">the Gutenberg tag</a> on the Core team blog and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. Read <a href=\"https://make.wordpress.org/test/2018/10/19/gutenberg-needs-testing-areas/\">this guide</a> to find areas where you can have the most impact.</p>\n\n\n\n<h2>Migrating HelpHub to WordPress.org</h2>\n\n\n\n<p>HelpHub is an ongoing project to move all of WordPress’ user documentation from the <a href=\"https://codex.wordpress.org/\">Codex</a> to the <a href=\"https://wordpress.org/support/\">WordPress Support portal</a>.<br></p>\n\n\n\n<p>HelpHub has been developed on <a href=\"https://wp-helphub.com/\">a separate staging server</a> and it’s now time to migrate the new documentation to its home on WordPress.org. The plan is to have everything moved over &nbsp;before WordPress 5.0 is released, so that all the new documentation will be available on the new platform from the start.<br></p>\n\n\n\n<p>The HelpHub team has published <a href=\"https://make.wordpress.org/docs/2018/11/01/call-for-volunteers-helphub-migration/\">a call for volunteers</a> to help with the migration. If you would like to get involved, join the #docs channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>, and contact <a href=\'https://profiles.wordpress.org/atachibana/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>atachibana</a> to get started.</p>\n\n\n\n<h2>A New Default Theme for WordPress</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">A brand new default theme &#8212; Twenty Nineteen &#8212; has been announced</a>&nbsp;with development being led by <a href=\'https://profiles.wordpress.org/allancole/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>allancole</a>. The theme is packaged with WordPress 5.0, so it will be following the same release schedule as Core.<br></p>\n\n\n\n<p>The new theme is designed to integrate seamlessly with Gutenberg and showcase how you can build a theme alongside the new block editor and take advantage of the creative freedom that it offers.<br></p>\n\n\n\n<p>Want to help build Twenty Nineteen? Join in on <a href=\"https://github.com/WordPress/twentynineteen\">the theme’s GitHub repo</a> and join the #core-themes channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.<br></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>The Support team are putting together more formal <a href=\"https://github.com/Clorith/wporg-support-guidelines\">Support Guidelines</a> for the WordPress Support Forums.</li><li>The group focused on privacy tools in Core <a href=\"https://make.wordpress.org/core/2018/10/11/whats-new-in-core-privacy/\">has released some details</a> on the work they have been doing recently, with a roadmap for their plans over the next few months.</li><li>The Core team <a href=\"https://make.wordpress.org/core/2018/10/15/wordpress-and-php-7-3/\">released an update</a> about how WordPress will be compatible with PHP 7.3.</li><li>The Theme Review Team have published <a href=\"https://make.wordpress.org/themes/2018/10/25/new-requirements/\">some new requirements</a> regarding child themes, readme files and trusted authors in the Theme Directory.</li><li>The WordCamp Europe team <a href=\"https://make.wordpress.org/community/2018/10/23/progressive-web-app-for-wordcamps/\">are working on a PWA service</a> for all WordCamp websites.</li></ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6230\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Oct 2018 05:04:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6222\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"WordPress 5.0 Beta 2 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test the WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2228:\"\n<p>WordPress 5.0 Beta 2 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta2.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big issues that we fixed since Beta 1:</p>\n\n\n\n<h2>Block Editor</h2>\n\n\n\n<p>We&#8217;ve updated to the latest version of the block editor from the Gutenberg plugin, which includes the new <a href=\"https://github.com/WordPress/gutenberg/pull/10209\">Format API</a>, embedding improvements, and <a href=\"https://github.com/WordPress/gutenberg/milestone/71\">a variety of bug fixes</a>.</p>\n\n\n\n<p>Meta boxes had a few bugs, and they weren&#8217;t showing at all in the block editor, so we&#8217;ve fixed and polished there.</p>\n\n\n\n<h2>Internationalisation</h2>\n\n\n\n<p>We&#8217;ve added support for <a href=\"https://core.trac.wordpress.org/ticket/45103\">registering and loading JavaScript translation files</a>.</p>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/twentynineteen\">Twenty Nineteen repository</a> is a hive of activity, there have been a stack of minor bugs clean up, and some notable additions:</p>\n\n\n\n<ul><li>There&#8217;s now a widget area in the page footer.</li><li>Navigation submenus have been implemented for mobile devices.</li><li>Customiser options have been added for changing the theme colours and feature image filters.</li></ul>\n\n\n\n<h2>Everything Else</h2>\n\n\n\n<p>The REST API has a couple of bug fixes and performance improvements. PHP 7.3 compatibility has been improved.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>We&#8217;re fixing the bugs:<br>All the ones you&#8217;ve reported.<br>Some that we&#8217;ve found, too.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6222\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Oct 2018 21:59:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6209\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:312:\"WordPress 5.0 Beta 1 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version, and if you are using an existing test site be sure to update the Gutenberg plugin to v4.1. There are [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3734:\"\n<p>WordPress 5.0 Beta 1 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version, and if you are using an existing test site be sure to update the Gutenberg plugin to v4.1. </p>\n\n\n\n<p>There are two ways to test the WordPress 5.0 beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta1.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big items to test so we can find as many bugs as possible in the coming weeks.</p>\n\n\n\n<h2>The Block Editor</h2>\n\n\n\n<p>The new Gutenberg block editor is now the default post editor!</p>\n\n\n\n<p>The block editor provides a modern, media-rich editing experience. You can create flexible, beautiful content without writing a single line of code, or you can dive into the <a href=\"https://wordpress.org/gutenberg/handbook/\">modern programming APIs</a> that the block editor provides.</p>\n\n\n\n<p>Even before you install WordPress 5.0, you can <a href=\"https://wordpress.org/gutenberg/\">try the block editor here</a>.</p>\n\n\n\n<p>Of course, we recognise you might not be ready for this change quite yet. If that&#8217;s the case, you can install the <a href=\"https://wordpress.org/plugins/classic-editor/\">Classic Editor plugin</a> now, which will keep the editor you&#8217;re familiar with as the default, even after you upgrade to WordPress 5.0.</p>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>Along with the new block editor, we have a new default theme, called Twenty Nineteen, which takes advantage of the new features the block editor provides.</p>\n\n\n\n<p>You can read more about Twenty Nineteen in its <a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">introduction post</a>, and follow along with development over on the <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>.</p>\n\n\n\n<h2>Default Themes</h2>\n\n\n\n<p>Of course, we couldn&#8217;t release a beautiful new default theme, and leave all of our old ones behind. All the way back to Twenty Ten, we&#8217;ve updated every default them to look good in the new block editor.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> <strong>A known issue</strong>: the block autocompleter fails for blocks whose names contain  characters in non-Latin scripts. Adding blocks via the plus sign works, and this bug is fixed in the Gutenberg 4.1 plugin. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>Minor bug fixes<br>Add up one by one by one<br>Then you change the world</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6209\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"The Month in WordPress: September 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2018/10/the-month-in-wordpress-september-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 01 Oct 2018 12:01:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6203\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"The new WordPress editor continues to be a major focus for all WordPress contribution teams. Read on to find out some more about their work, as well as everything else that has been happening around the community this past month. Further Enhancements to the New WordPress Editor Active development continues on Gutenberg, the new editing [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4632:\"\n<p>The new WordPress editor continues to be a major focus for all WordPress contribution teams. Read on to find out some more about their work, as well as everything else that has been happening around the community this past month.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Enhancements to the New WordPress Editor</h2>\n\n\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/09/21/whats-new-in-gutenberg/\">The latest update for the editor</a> includes great new features, such as reusable content blocks, a dark editor style, export and import of templates, and much more. In addition, the Gutenberg team has published <a href=\"https://make.wordpress.org/core/2018/09/26/an-update-on-gutenberg-tasks/\">a comprehensive guide</a> to the features currently included in the editor.<br /></p>\n\n\n\n<p>Users can test Gutenberg right now by installing <a href=\"https://wordpress.org/plugins/gutenberg/\">the plugin</a>, which currently has over 450,000 active installs according to the new <a href=\"https://gutenstats.blog/\">Gutenberg in Numbers</a> site. Along with that, <a href=\"https://wordpress.org/gutenberg/handbook/reference/faq/\">the Gutenberg Handbook</a> has some very useful information about how to use and develop for the new editor.<br /></p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">the #gutenberg tag on the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Work Begins on WordPress 5.0</h2>\n\n\n\n<p>After initially announcing a minor v4.9.9 release, <a href=\"https://make.wordpress.org/core/2018/09/28/dev-chat-summary-september-26th-4-9-9-week-7/\">the Core team has shifted their focus to the next major release</a> — v5.0. One of the primary factors for this change is that Gutenberg is nearly ready to be considered for merging into Core, with the goal to complete the merge in v5.0.<br /></p>\n\n\n\n<p>To maintain flexibility in the development process the final timelines are not yet determined, allowing work already done for v4.9.9 to be moved to v5.0 if needed. Ensuring that WordPress is compatible with the upcoming PHP 7.3 release is a high priority for the Core team. Once a final decision is made, the details will be announced on <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>.<br /></p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow the Core team blog and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.<br /></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>The Community Team has some great updates on <a href=\"https://make.wordpress.org/community/2018/09/25/wordcamp-incubator-2018-update-thread-september-edition/\">the progress of the current WordCamp Incubator Program</a>.</li><li>A team inside the Drupal community <a href=\"https://drupalgutenberg.org/\">is working on integrating Gutenberg into their CMS</a>.</li><li>There is a current discussion among community organizers about <a href=\"https://make.wordpress.org/community/2018/09/17/proposal-to-increase-the-maximum-ticket-price-for-wordcamps/\">plans to increase the maximum ticket price for WordCamps</a>.</li><li>The Mobile Team <a href=\"https://make.wordpress.org/updates/2018/09/25/mobile-team-update-september-25th/\">is looking for people</a> to grow the beta program for testing the iOS and Android mobile apps.</li><li>The Diversity Outreach Speaker Training group <a href=\"https://make.wordpress.org/community/2018/09/13/input-requested-building-a-diverse-speaker-roster-document/\">is looking for feedback</a> on their document to assist WordPress Meetups and WordCamps in building diverse speaker rosters.</li><li>The Theme Team <a href=\"https://make.wordpress.org/themes/2018/09/26/new-requirement-regarding-affiliate-links/\">has updated their rules</a> regarding sponsored and affiliate links inside themes added to the Theme Directory.</li><li>Meetup organizers <a href=\"https://make.wordpress.org/community/2018/09/25/meetup-organiser-badge-assignments/\">are now able to receive a WordPress.org profile badge</a> for their community work.</li></ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em><br /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6203\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"The Month in WordPress: August 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2018/09/the-month-in-wordpress-august-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Sep 2018 11:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6191\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:355:\"Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August. WordPress 4.9.8 is Released WordPress 4.9.8 was [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5589:\"\n<p>Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 4.9.8 is Released</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\">WordPress 4.9.8 was released</a> at the beginning of the month. While this was a maintenance release fixing 46 bugs, it was significant for Core development because it made a point of highlighting Gutenberg — the new WordPress editor that is currently in development (more on that below).<br /></p>\n\n\n\n<p>This release also included some important updates to the privacy tools that were added to Core earlier this year.<br /></p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n\n\n<h2>New WordPress Editor Development Continues</h2>\n\n\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/08/31/whats-new-in-gutenberg-31st-august/\">The latest version</a> features a number of important user experience improvements, including a new unified toolbar and support for a more focussed writing mode.<br /></p>\n\n\n\n<p>Users can test Gutenberg right now by installing <a href=\"https://wordpress.org/plugins/gutenberg/\">the plugin</a>, which currently has nearly 300,000 active installs. Along with that, <a href=\"https://wordpress.org/gutenberg/handbook/reference/faq/\">the Gutenberg Handbook</a> has some very useful information about how to use and develop for the new editor.<br /></p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">the #gutenberg tag on the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Planning Begins for the Next Global WordPress Translation Day</h2>\n\n\n\n<p>The Global WordPress Translation Day is a 24-hour event held online and all across the world. It is designed to bring communities together to translate WordPress into their local languages, and to help them connect with other communities doing the same thing.<br /></p>\n\n\n\n<p>There have been three Translation Days since April 2016, and <a href=\"https://make.wordpress.org/polyglots/2018/08/29/global-wordpress-translation-day-4-preliminary-planning/\">the fourth edition is in the planning stages now</a>. The Polyglots team, who organizes these events, is currently looking for input on the date, format, and content for the event and would love some feedback from the community.<br /></p>\n\n\n\n<p>Want to get involved in translating WordPress into your own language? Follow <a href=\"https://make.wordpress.org/polyglots/\">the Polyglots team blog</a> and join the #polyglots channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.<br /></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.org/support/upgrade-php/\">The Update PHP page on WordPress.org</a> has been revised and improved to make the reasons for upgrading more clear.</li><li>The Mobile team is looking for people to help test the latest versions of the <a href=\"https://make.wordpress.org/mobile/2018/08/29/call-for-testing-wordpress-for-android-10-8/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2018/08/28/call-for-testing-wordpress-for-ios-10-8/\">iOS</a> apps for WordPress.</li><li><a href=\"https://wordbits.io/\">WordBits</a> is a innovative new platform for publishing WordPress-based code snippets with the ability to download each snippet as a working plugin.</li><li>The Community Team <a href=\"https://make.wordpress.org/community/2018/08/27/wordcamp-incubator-2018-update-thread-august-edition/\">has some updates</a> about how things are going with this year’s WordCamp Incubator program.</li><li>The WordPress Support Forums <a href=\"https://make.wordpress.org/support/2018/08/august-16th-support-team-meeting-summary/\">now include a feature</a> allowing forum volunteers to easily report a post to the moderators for a follow-up.</li><li>WordCamp Kochi, India <a href=\"https://2018.kochi.wordcamp.org/wordcamp-kochi-2018-is-postponed-to-november-3rd-2018-saturday/\">has unfortunately had to postpone their event</a> due to floods in the region.</li><li><a href=\"http://www.wpglossary.net/\">WP Glossary</a> is a new site that offers helpful definitions of words that you could encounter when using WordPress.</li><li>A few WordPress community members <a href=\"https://make.wordpress.org/community/2018/08/13/in-the-words-of-the/\">have started a working group</a> to tackle the idea of building diverse WordPress  communities all across the world.</li><li>A new <a href=\"https://editorblockswp.com/library/\">Gutenberg Block Library</a> is available, listing the details of the many blocks available for the new editor.</li></ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6191\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.9.8 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2018 21:25:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme. Following are the highlights of what is now available. “Try Gutenberg” callout Most users will now be presented with a notice in their WordPress dashboard. This “Try Gutenberg” [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Paul Biron\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10398:\"<p>We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme.</p>\n<p><span style=\"font-weight: 400\">Following are the highlights of what is now available.</span></p>\n<h2>“Try Gutenberg” callout</h2>\n<p><span style=\"font-weight: 400\">Most users will now be presented with a notice in their WordPress dashboard. This </span>“Try Gutenberg” is an opportunity for users to use the Gutenberg block editor before it is released in WordPress 5.0.</p>\n<p><img class=\"alignnone wp-image-6168 size-full\" src=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=632{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2C392&#038;ssl=1\" alt=\"\" width=\"632\" height=\"392\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=2528&amp;ssl=1 2528w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=300{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2C186&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=768{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2C476&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=1024{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2C634&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>In WordPress 4.9.8, the callout will be shown to the following users:</p>\n<ul>\n<li>If Gutenberg <em>is not</em> installed or activated, the callout will be shown to Admin users on single sites, and Super Admin users on multisites.</li>\n<li>If Gutenberg <em>is</em> installed and activated, the callout will be shown to Contributor users and above.</li>\n<li>If the Classic Editor plugin is installed and activated, the callout will be hidden for all users.</li>\n</ul>\n<p class=\"entry-title\"><span style=\"font-weight: 400\">You can learn more by reading  </span><a href=\"https://make.wordpress.org/core/2018/08/02/try-gutenberg-callout-in-wordpress-4-9-8/\">“Try Gutenberg” Callout in WordPress 4.9.8</a>.</p>\n<h2>Privacy fixes/enhancements</h2>\n<p>This release includes 18 Privacy fixes focused on ensuring consistency and flexibility in the new personal data tools <span style=\"font-weight: 400\">that were </span>added in 4.9.6, including:</p>\n<ul>\n<li>The type of request being confirmed is now included in the subject line for all privacy confirmation emails.</li>\n<li>Improved consistency with site name being used for privacy emails in multisite.</li>\n<li>Pagination for Privacy request admin screens can now be adjusted.</li>\n<li>Increased the test coverage for several core privacy functions.</li>\n</ul>\n<p><a href=\"https://make.wordpress.org/core/2018/08/02/wordpress-4-9-8/\">This post has more information about all of the issues fixed in 4.9.8 if you&#8217;d like to learn more</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.8</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n<p>Thank you to everyone who contributed to WordPress 4.9.8:</p>\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">Abdullah Ramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/allendav/\">Allen Snook</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewtaylor-1/\">Andrew Taylor</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chrislema/\">Chris Lema</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danieltj/\">Daniel James</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dontstealmyfish/\">dontstealmyfish</a>, <a href=\"https://profiles.wordpress.org/dyrer/\">dyrer</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/gm_alex/\">GM_Alex</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/joshuawold/\">JoshuaWold</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">kjellr</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/michelleweber/\">michelleweber</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/xpertone/\">Muhammad Kashif</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a>, <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/rafsuntaskin/\">Rafsun Chowdhury</a>, <a href=\"https://profiles.wordpress.org/redcastor/\">redcastor</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/pross/\">Simon Prosser</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/spyderbytes/\">spyderbytes</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/timbowesohft/\">timbowesohft</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/usmankhalid/\">Usman Khalid</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 16 Nov 2018 13:50:59 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Fri, 16 Nov 2018 01:11:43 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20130911073210\";}","no");
INSERT INTO wpcf_options VALUES("134","_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1542419455","no");
INSERT INTO wpcf_options VALUES("135","_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1542376255","no");
INSERT INTO wpcf_options VALUES("136","can_compress_scripts","1","no");
INSERT INTO wpcf_options VALUES("137","_transient_timeout_feed_26b0d8e18ed25a5313e8c7eb9c687d1b","1542419455","no");
INSERT INTO wpcf_options VALUES("138","_transient_feed_26b0d8e18ed25a5313e8c7eb9c687d1b","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Nederlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://nl.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jul 2018 08:05:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"nl\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-beta5-43907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"WordCamps in Nederland in 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://nl.wordpress.org/2018/01/10/wordcamps-in-nederland-in-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://nl.wordpress.org/2018/01/10/wordcamps-in-nederland-in-2018/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Jan 2018 10:11:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=854\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:415:\"Beste WordCamp Nederland liefhebber, Zoals je mogelijk hebt kunnen zien moesten wij, als organisatie achter WordCamp Nederland, eerst 3 andere WordCamps in Nederland &#8220;laten gebeuren&#8221; voordat we weer een WordCamp Nederland mochten organiseren. Als WordPress Community hebben we hier werk van gemaakt. WordCamp Nijmegen en WordCamp Utrecht staan ondertussen al als twee succesvolle WordCamps die [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2255:\"<p>Beste WordCamp Nederland liefhebber,</p>\n<p>Zoals je mogelijk hebt kunnen zien moesten wij, als organisatie achter WordCamp Nederland, eerst 3 andere WordCamps in Nederland &#8220;laten gebeuren&#8221; <a href=\"https://nl.wordpress.org/2017/06/15/toch-toekomst-voor-wordcamp-nederland/\" target=\"_blank\" rel=\"noopener noreferrer\">voordat we weer een WordCamp Nederland mochten organiseren</a>.</p>\n<p>Als WordPress Community hebben we hier werk van gemaakt. WordCamp Nijmegen en WordCamp Utrecht staan ondertussen al als twee succesvolle WordCamps die in de geschiedenisboeken.</p>\n<p>Maar daar stopt het niet. We hebben ook in 2018 al een aantal WordCamps op de planning staan. Dit zijn de twee die er op dit moment in de agenda staan:</p>\n<p><a href=\"https://2018.noordnederland.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">WordCamp Noord-Nederland</a> in Drachten, 9 en 10 feb. <a href=\"https://2018.noordnederland.wordcamp.org/tickets/\" target=\"_blank\" rel=\"noopener noreferrer\">Tickets koop je hier</a>.</p>\n<p><a href=\"https://rotterdam.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">WordCamp Rotterdam</a> in, je raadt het nooit, Rotterdam. 23 &amp; 24 maart. <a href=\"https://2018.rotterdam.wordcamp.org/tickets/\" target=\"_blank\" rel=\"noopener noreferrer\">Tickets vind je hier</a>.</p>\n<p>Daarnaast zijn <a href=\"https://utrecht.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">WordCamp Utrecht</a> en <a href=\"https://nijmegen.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">WordCamp Nijmegen</a> alweer voorzichtig bezig met een planning. En uiteraard moeten we onze zuiderburen niet vergeten: WordCamp Antwerp gaat voor de tweede keer alweer los <a href=\"https://antwerp.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">op 2 &amp; 3 maart 2018</a>.</p>\n<p>Al met al zul je de komende tijd steeds meer lokale WordCamps voorbij zien komen. Uiteraard komt er ook weer een WordCamp Nederland aan, maar we wachten nog even met het definitieve plannen hiervan.</p>\n<p>Zodra we meer weten laten we het jullie weten.</p>\n<p><strong>Update 6 juli 2018:</strong> <a href=\"https://nl.wordpress.org/team/2018/07/06/wordcamps-in-nederland-onze-ervaringen/\">WordCamps in Nederland &#8211; onze ervaringen</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://nl.wordpress.org/2018/01/10/wordcamps-in-nederland-in-2018/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Nederlanders krijgen commitrechten op WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://nl.wordpress.org/2017/12/12/nederlanders-krijgen-commitrechten-op-wordpress-core/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://nl.wordpress.org/2017/12/12/nederlanders-krijgen-commitrechten-op-wordpress-core/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Dec 2017 08:42:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Nieuws\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=833\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:416:\"WordPress is een Open Source software-project. Dat betekent dat iedereen de broncode van WordPress kan bekijken en suggesties voor verbetering kan aandragen. Gebruikers maken WordPress daarom niet alleen voor elkaar, maar vooral ook met elkaar. Hoewel iedereen verbeteringen kan aandragen, is het daadwerkelijk toevoegen van code aan WordPress voorbehouden aan een vrij selecte groep ervaren WordPressers. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Taco Verdonschot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2973:\"<p>WordPress is een Open Source software-project. Dat betekent dat iedereen de broncode van WordPress kan bekijken en suggesties voor verbetering kan aandragen. Gebruikers maken WordPress daarom niet alleen voor elkaar, maar vooral ook met elkaar.</p>\n<p>Hoewel iedereen verbeteringen kan aandragen, is het daadwerkelijk toevoegen van code aan WordPress voorbehouden aan een vrij selecte groep ervaren WordPressers. Om dit te kunnen doen heb je zogenaamde commitrechten nodig. Je krijgt deze rechten niet zomaar, want het betekent dat je WordPress voor alle gebruikers kan aanpassen. Het gebeurt dus niet vaak dat er nieuwe committers (mensen met commitrechten) worden toegevoegd aan het project.<span id=\"more-833\"></span></p>\n<p>Extra bijzonder is het daarom dat maar liefst twee Nederlanders commitrechten hebben gekregen in de afgelopen 10 dagen. We zetten ze daarom graag even in het zonnetje.</p>\n<h3>Juliette Reinders Folmer</h3>\n<p><a href=\"https://profiles.wordpress.org/jrf\">Juliette</a> is geen onbekende in de WordPress community. Ze werkt al sinds 2004 met PHP en al sinds 2010 met WordPress, en heeft zeer actief bijgedragen aan diverse plugins en aan WordPress zelf. De afgelopen periode heeft Juliette zich vooral ingezet om te zorgen dat WordPress voldoet aan de WordPress codestandaard. Dit is een set afspraken die WordPress-ontwikkelaars hebben gemaakt over wat goede code is. Haar project zorgt ervoor dat meer dan 60.000 foutmeldingen en waarschuwingen in één klap worden opgelost. Indrukwekkend feit, deze ene patch (verbetering aan de software) heeft meer dan 25{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} van alle regels code in WordPress gewijzigd!<br />\nMeer weten? Op <a href=\"https://nijmegen.wordcamp.org\">WordCamp Nijmegen</a> heeft Juliette over deze patch gesproken. Je kan haar presentatie terugkijken op <a href=\"https://wordpress.tv/2017/10/14/juliette-reinders-folmer-the-biggest-wp-core-patch-ever/\">wordpress.tv</a>.</p>\n<h3>Anton Timmermans</h3>\n<p>Ook <a href=\"https://profiles.wordpress.org/atimmer\">Anton</a> loopt al lange tijd rond in het WordPress-wereldje. In 2012 ontdekte Anton WordPress, en nog geen jaar later werd zijn eerste verbetering (patch) toegevoegd aan WordPress. De afgelopen tijd heeft zich, samen met zijn collega&#8217;s van <a href=\"https://yoast.com\">Yoast</a>, ingezet voor het verbeteren van de JavaScript documentatie in WordPress. Hierdoor is het voor andere ontwikkelaars makkelijker om de JavaScript-code van WordPress te begrijpen en er op in te haken.</p>\n<h3>Zelf ook bijdragen?</h3>\n<p>Wil je zelf ook bijdragen aan het verbeteren van WordPress? Dat kan! Op <a href=\"https://make.wordpress.org\">make.wordpress.org</a> vind je een overzicht van de gebieden waarin je kan bijdragen. Elk team heeft een eigen &#8216;Getting started&#8217; sectie in hun handboek. Voor WordPress core kan je deze bijvoorbeeld vinden op <a href=\"https://make.wordpress.org/core/handbook/about/getting-started-at-a-contributor-day/\">Getting started</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://nl.wordpress.org/2017/12/12/nederlanders-krijgen-commitrechten-op-wordpress-core/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 4.9 is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://nl.wordpress.org/2017/11/16/wordpress-4-9-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2017/11/16/wordpress-4-9-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Nov 2017 22:23:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=858\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:425:\"Met trots kunnen we melden dat WordPress 4.9 is vrijgegeven. WordPress 4.9 zal je ontwerp workflow vloeiend maken en je beschermen voor programmeerfouten. Belangrijke verbeteringen voor de Customizer, Foutcontrole en meer! 🎉 Welkom bij de verbeterde Customizer. Een verbeterde workflow met concept ontwerpen, ontwerpvergrendeling en voorbeeldlinks. En nog meer. Met syntaxmarkering en foutcontrole wordt het nog [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8185:\"<p>Met trots kunnen we melden dat WordPress 4.9 is vrijgegeven. WordPress 4.9 zal je ontwerp workflow vloeiend maken en je beschermen voor programmeerfouten.</p>\n<h2>Belangrijke verbeteringen voor de Customizer, Foutcontrole en meer! <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<p>Welkom bij de verbeterde Customizer. Een verbeterde workflow met concept ontwerpen, ontwerpvergrendeling en voorbeeldlinks. En nog meer. Met syntaxmarkering en foutcontrole wordt het nog makkelijk een site te ontwikkelen. En als klap op de vuurpijl is er een nieuwe galerij widget geïntroduceerd en zijn er diverse verbeteringen doorgevoerd aan themabeheer.<span id=\"more-858\"></span></p>\n<p><img class=\"alignnone size-full\" src=\"https://s.w.org/images/core/4.9/banner.svg\" width=\"1200\" height=\"600\" /></p>\n<h2>Verbeterde workflow Customizer</h2>\n<h3>Concept ontwerpaanpassingen inplannen</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/draft-and-schedule.svg\" alt=\"\" />Ja, je hebt het goed gelezen. Net zoals je concept berichten kunt opstellen, aanpassen en inplannen voor publicatie op een voor jou geschikt moment, kun je wijzigingen aan het ontwerp van je site nu zo plannen dat ze gepubliceerd worden wanneer jij dat wilt.</p>\n<h3>Samenwerken met conceptontwerp voorbeeldlinks</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/design-preview-links.svg\" alt=\"\" />Feedback nodig op voorgestelde site ontwerp wijzigingen? WordPress 4.9 geeft je een voorbeeld link die je naar je team en klanten kan sturen, zodat je feedback kan verzamelen en verwerken alvorens je je wijzigingen live zet. Dat is fijn samenwerken!</p>\n<h3>Ontwerpvergrendeling om wijzigingen te bewaken</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/locking.svg\" alt=\"\" />Heb je het ooit meegemaakt dat twee ontwikkelaars bij het project kwamen en elkaar verweten hun mooie aanpassingen te hebben overschreven? WordPress 4.9. ontwerpvergrendeling (vergelijkbaar met berichtvergrendeling) beschermd het concept ontwerp zodat niemand anders wijzigingen kan maken en alle het harde werk overschrijft.</p>\n<h3>Een melding om je werk te beschermen</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/prompt.svg\" alt=\"\" />Was je even niet bij je bureau voordat je het nieuwe concept ontwerp had opgeslagen? Geen zorgen, WordPress 4.9 zal je bij terugkeer vriendelijk vragen of je je wijzigingen wilt opslaan.</p>\n<h2>Codeverbeteringen</h2>\n<p>&nbsp;</p>\n<h3>Syntaxmarkering en foutcontrole? Ja, graag!</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/syntax-highlighting.svg\" alt=\"\" />Er is een weergaveprobleem, maar je kan maar niet vinden wat er fout is met de door jouw fantastisch geschreven CSS. Met syntaxmarkering en foutcontrole voor CSS en aangepaste HTML is het nog makkelijker geworden om fouten te vinden. Gegarandeerd eenvoudiger om fouten snel te verhelpen door eenvoudig de code te scannen.</p>\n<h3>Sandbox voor veiligheid</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/sandbox.svg\" alt=\"\" />Het gevreesde witte scherm. Je zal het kunnen voorkomen als je werkt met thema&#8217;s en plugin code, omdat WordPress 4.9 je zal waarschuwen alvorens een fout te bewaren. Je zal &#8217;s nachts beter slapen.</p>\n<h3>Waarschuwing: potentieel gevaar opkomst!</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/warning.svg\" alt=\"\" />Tijdens het direct bewerken van thema&#8217;s en plugins, zal WordPress 4.9 je vriendelijk waarschuwen dat dit een potentieel gevaar is. Een aanbeveling zal worden gegeven een backup te maken van je bestanden voordat je deze opslaat. Hierdoor worden wijzigingen niet overschreven bij een volgende update. Neem deze veilige route. Je toekomstige, je team en klanten zullen je dankbaar zijn voor deze beslissing.</p>\n<h2>Nog meer widget verbeteringen</h2>\n<h3>De nieuwe galerij widget</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/gallery-widget.svg\" alt=\"\" />Een extra verbetering aan de media aanpassingen die in WordPress 4.8 is uitgekomen. Nu is het mogelijk een galerij toe te voegen via widget. Fantastisch!</p>\n<h3>Druk op een knop, media toevoegen</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/media-button.svg\" alt=\"\" />Wil je media toevoegen aan je tekst-widget? Voeg afbeeldingen, video en audio direct in de widget met je tekst, met de simpele maar handige Voeg media toe knop.</p>\n<h2>Verbeteringen voor site-ontwikkeling</h2>\n<h3>Verbeterde themawisseling</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/theme-switching.svg\" alt=\"\" />Bij het wijzigen van een thema denken widgets soms dat ze zomaar van locatie kunnen verspringen. Verbeteringen in WordPress 4.9 zorgen er nu voor dat er een duidelijker menu en widget beheer wanneer je een nieuwe thema selecteert. Ook is mogelijk om eenvoudig een voorbeeld te tonen van geïnstalleerde thema&#8217;s of om een thema te downloaden, installeren en voorbeeld te tonen. Wel zo gemakkelijk om eerst een voorbeeld te bekijken voordat je deze activeert.</p>\n<h3>Betere menu instructies = Minder verwarring</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/menu-flow.svg\" alt=\"\" />Vond je de stappen om een nieuw menu te creëren verwarrend? Wellicht niet meer! We hebben de gebruikersinterface voor het maken van menu&#8217;s verbeterd zodat dit een stuk makkelijker gaat. Deze nieuwe update zal je hierin begeleiden.</p>\n<h2>Een handje meehelpen aan Gutenberg <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f91d.png\" alt=\"🤝\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<p><img class=\"alignnone size-full\" src=\"https://s.w.org/images/core/4.9/gutenberg.svg\" width=\"1200\" height=\"600\" /><br />\nWordPress werkt aan een nieuwe manier om je inhoud te creëren en beheren en we stellen je hulp op prijs. Geïnteresseerd om een <a href=\"https://wordpress.org/plugins/gutenberg/\">vroege tester</a> te zijn of meehelpen met het Gutenberg project? <a href=\"https://github.com/WordPress/gutenberg\">Bijdragen op GitHub</a>.</p>\n<h2>Ontwikkelaarsgeluk <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<h3><a href=\"https://make.wordpress.org/core/2017/11/01/improvements-to-the-customize-js-api-in-4-9/\">Customizer JS API verbeteringen</a></h3>\n<p>Er zijn diverse verbeteringen doorgevoerd aan de Customizer JS API in WordPress 4.9. Deze verbeteringen verwijderen diverse pijnpunten en maken het net zo makkelijk om mee te werken als de PHP API. Er zijn ook nieuwe standaarden, zoals: controle templates, een datum/tijd controle en een sectie/paneel notificatie toegevoegd. <a href=\"https://make.wordpress.org/core/2017/11/01/improvements-to-the-customize-js-api-in-4-9/\">Bekijk de hele lijst met verbeteringen.</a></p>\n<h3><a href=\"https://make.wordpress.org/core/2017/10/22/code-editing-improvements-in-wordpress-4-9/\">CodeMirror beschikbaar voor gebruik in je thema&#8217;s en plugins</a></h3>\n<p>We hebben een nieuwe codebewerkingsbibliotheek geïntroduceerd, CodeMirror, voor gebruik binnen WordPress. Gebruik het om iedere geschreven code, zoals CSS of JavaScript, binnen je plugins te verbeteren.</p>\n<h3><a href=\"https://make.wordpress.org/core/2017/10/30/mediaelement-upgrades-in-wordpress-4-9/\">MediaElement.js bijgewerkt naar 4.2.6</a></h3>\n<p>WordPress 4.9 bevat een bijgewerkte versie van MediaElement.js. Afhankelijkheden met jQuery zijn verwijderd, toegankelijkheid is verbeterd, gebruikersinterface is gemoderniseerd en veel bugs zijn gerepareerd.</p>\n<h3><a href=\"https://make.wordpress.org/core/2017/10/15/improvements-for-roles-and-capabilities-in-4-9/\">Verbeteringen aan rollen en rechten</a></h3>\n<p>Nieuwe eigenschappen zijn geïntroduceerd die het beheer van plugins en vertaalbestanden verfijnd mogelijk maken. Daarnaast is het siteschakelproces in multi-site nauwkeurig afgesteld om de beschikbare rollen en eigenschappen op een meer betrouwbare en coherente manier bij te werken.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://nl.wordpress.org/2017/11/16/wordpress-4-9-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Toch toekomst voor WordCamp Nederland!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://nl.wordpress.org/2017/06/15/toch-toekomst-voor-wordcamp-nederland/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://nl.wordpress.org/2017/06/15/toch-toekomst-voor-wordcamp-nederland/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Jun 2017 14:33:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Algemeen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=754\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:349:\"Terugblik Op 30 maart dit jaar publiceerden we een bericht over het einde van WordCamp Nederland. Zoals velen van jullie hebben gemerkt heeft dat online geleid tot een stevige discussie. Vanuit de hele wereld ontvingen we berichten dat mensen het oneens waren met de beslissingen van het Global Community Team. Nu, een aantal maanden later [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Taco Verdonschot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5484:\"<h2>Terugblik</h2>\n<p>Op 30 maart dit jaar publiceerden we een bericht over het einde van WordCamp Nederland. Zoals velen van jullie hebben gemerkt heeft dat online geleid tot een stevige discussie. Vanuit de hele wereld ontvingen we berichten dat mensen het oneens waren met de beslissingen van het Global Community Team. Nu, een aantal maanden later kijken we graag terug op wat er is gebeurd.<span id=\"more-754\"></span></p>\n<p>Als eerste willen we duidelijk maken dat er geen ‘wij’ en ‘zij’ is. We hebben altijd hetzelfde doel nagestreefd, namelijk de groei van de Nederlandse WordPress Community. Onze onenigheid ging slechts over juiste manier om dit te bereiken. Het Global Community Team was er van overtuigd dat het organiseren van meerdere lokale evenementen de juiste richting was, terwijl de WordCamp Nederland organisatie het laten groeien van de WordCamp Nederland zag als beste manier. Uiteindelijk besloot het Global Community Team dat WCNL 2017 niet door kon gaan.</p>\n<p>In de emotie van die beslissing hebben zowel de WCNL organisatie als het Global Community Team op het scherpst van de snede gecommuniceerd. Nu, een aantal maanden later, zijn we allemaal afgekoeld en hebben we een goed gesprek gehad over hoe we gezamenlijk verder kunnen.</p>\n<h2>Community Summit</h2>\n<p>Tijdens de Community Summit laaide het gesprek over regionale WordCamps opnieuw op. Ook hebben we hier gesproken over het verschil tussen regionale WordCamps en grote evenementen zoals WordCamp Europe. In een zeer open gesprek hebben we gesproken over de zorgen aan beide zijden, zoals geografie, het gevoel dat het niet laten doorgaan van WordCamp Nederland afbreuk deed aan de community, en ook dat de alternatieven niet duidelijk genoeg zijn gecommuniceerd.</p>\n<h2>De toekomst van WordCamps in Nederland</h2>\n<p>Het Global Community Team was erg duidelijk dat de huidige situatie (zonder WCNL) niet definitief is. Het nut van het verbieden van WCNL dit jaar is om een kans te creeren voor meer lokale teams om te proberen een evenement in hun eigen stad te organiseren. WordCamp Nederland kan absoluut weer opnieuw plaats gaan vinden. Om opnieuw toestemming te krijgen om WCNL te organiseren moeten we laten zien dat we gezonde lokale communities hebben. Dit wordt afgemeten aan het aantal Meetups en WordCamps.</p>\n<p>Kort gezegd, het Global Community Team heeft bevestigd dat we WordCamp Nederland opnieuw georganiseerd mag worden zodra we 3 verschillende, succesvolle WordCamps neerzetten in Nederland.</p>\n<p>Opmerking voor alle andere communities die dit bericht lezen: Omdat WordPress een wereldwijd project is worden deze richtlijnen opgesteld voor individuele situaties. Het aantal evenementen in een gebied kan verschillen, afhankelijk van de lokale situatie. Wil je ook een regionale WordCamp organiseren, neem dan contact op met het Global Community Team.</p>\n<p>&nbsp;</p>\n<hr />\n<p><em>[Below you&#8217;ll find the translation of the text above]</em></p>\n<h2>Looking back</h2>\n<p>On March 30th this year, we published a post about WordCamp The Netherlands not being organized anymore. As many of you know, it sparked quite a bit of discussion. From all over the world we received messages that people disagreed with the decisions made by Global Community Team. Now, a few months later we would like to look back on what happened.</p>\n<p>First of all, there’s no ‘us’ versus ‘them’. We’ve always had the same goals in mind, yet disagreed on the way to move the Dutch WordPress community forward. Global Community Team felt that we should move to more local WordCamps while the WCNL organization felt that WordCamp The Netherlands was the right way. In the end, Global Community Team decided WCNL 2017 wasn’t going to happen.</p>\n<p>In the emotion of that decision, both the WCNL organization and Global Community Team may have been a bit harsh in their communication. Now, a few months later things calmed down and we’ve been talking about a way forward together.</p>\n<h2>Community Summit</h2>\n<p>At the WordPress Community Summit, the conversation around regional WordCamps came up and we discussed the differences between regional events and large-scale events like WordCamp EU. We were able to communicate openly about the concerns on both sides including geography, the feeling that stopping WordCamp Netherlands was destructive, and also the fact that the alternatives communicated were not as clear as they could have been.</p>\n<h2>The future of WordCamps in The Netherlands</h2>\n<p>People from the Global Community Team were clear at the summit that this isn’t the final solution. The purpose of having no WordCamp Netherlands this year is to create the opportunity for more organizing teams to try having an event in their area. WordCamp The Netherlands can be organized again in the near future. To get permission again, we’ll have to show that we have healthy local communities. This is measured by the number of Meetups and WordCamps.</p>\n<p>Long story short, the Global Community Team confirmed that we have to have 3 different successful WordCamps in The Netherlands to qualify for a WordCamp The Netherlands again.</p>\n<p>Note for all other communities reading this post: Because WordPress is a global project, these guidelines are on a case by case basis. The number of events for any given area would depend on the local situation. Contact the Global Community Team if you’re interested in having your own regional WordCamp!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://nl.wordpress.org/2017/06/15/toch-toekomst-voor-wordcamp-nederland/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 4.8 is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://nl.wordpress.org/2017/06/08/wordpress-4-8-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2017/06/08/wordpress-4-8-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Jun 2017 16:22:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=749\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"Een update met jou in de hoofdrol WordPress 4.8 voegt enkele fantastische nieuwe eigenschappen toe. Stap snel over voor een nog intuïtievere versie van WordPress. Al lijken sommige vernieuwingen klein, ze zijn gemaakt door honderden mensen met jou in gedachten. Maak je klaar voor nieuwe features die je zult verwelkomen als een oude vriend: verbeteringen [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7352:\"<h2>Een update met jou in de hoofdrol</h2>\n<p class=\"lead-description\">WordPress 4.8 voegt enkele fantastische nieuwe eigenschappen toe. Stap snel over voor een nog intuïtievere versie van WordPress.</p>\n<p>Al lijken sommige vernieuwingen klein, ze zijn gemaakt door honderden mensen met <em>jou</em> in gedachten. Maak je klaar voor nieuwe features die je zult verwelkomen als een oude vriend: verbeteringen aan links, <em>drie</em> nieuwe mediawigets voor afbeeldingen, audio en video, een verbeterde tekst widget die visueel bewerken ondersteunt, en een verbeterde nieuwssectie in je dashboard met informatie over WordPress evenementen die binnenkort bij jou in de buurt plaatsvinden.</p>\n<hr />\n<h2>Fantastische widget vernieuwingen</h2>\n<div class=\"headline-feature one-col\">\n<div class=\"col\"><img src=\"https://s.w.org/images/core/4.8/widgets-with-all-four-mobile_w_685.png\" alt=\"\" /></div>\n</div>\n<div class=\"feature-section two-col\">\n<div class=\"col\">\n<h3>Afbeeldingswidget</h3>\n<p>Een afbeelding toevoegen aan een widget is nu een eenvoudige taak die te doen is zonder kennis van code voor elke WordPress gebruiker. Je afbeelding eenvoudig toevoegen vanuit de widget instellingen. Probeer eens een foto van jezelf of van je nieuwste avonturen in het weekend — en zie hem als vanzelf verschijnen.</p>\n</div>\n<div class=\"col\">\n<h3>Videowidget</h3>\n<p>Een welkomstvideo is een geweldige manier om je website een menselijk gezicht te geven. Je kunt nu een video uit de mediabibliotheek toevoegen aan een sidebar op je site met de nieuwe video widget. Gebruik de videowidget om in een welkomstvideo de website bij je bezoekers te introduceren of promoot je nieuwste en beste inhoud.</p>\n</div>\n<div class=\"col\">\n<h3>Audiowidget</h3>\n<p>Ben jij een podcaster, muzikant of fanatieke blogger? Het toevoegen van een widget met je audiobestand is nog nooit zo eenvoudig geweest. Upload je audiobestand naar de mediabibliotheek, ga naar de widgetinstellingen, selecteer je bestand en je bent klaar voor luisteraars. Dit is ook een fantastische oplossing om welkomstbericht te tonen.</p>\n</div>\n<div class=\"col\">\n<h3>Richtekst widget</h3>\n<p>Deze nieuwe eigenschap is een echt paradepaardje. Rich-tekst bewerken is nu standaard voor tekstwidgets. Voeg ergens een widget toe en maak de tekst op zoals je wilt. Maak lijsten, maak tekst italic en voeg eenvoudig en snel links toe. Veel plezier met je nieuwe opmaakmogelijkheden en zie wat je snel voor elkaar kunt krijgen.</p>\n</div>\n</div>\n<hr />\n<div class=\"feature-section two-col\">\n<div class=\"col\">\n<h3>Link verbeteringen</h3>\n<p>Heb je ooit geprobeerd om een link bij te werken of de tekst naast een link te wijzigen? En het lukte niet om het goed te krijgen? Wanneer je tekst volgend op de link bewerkt, krijgt de nieuwe tekst ook de link. Of als je de tekst in de link bewerkt eindig je met tekst die niet gelinkt is. Dit kan heel frustrerend zijn! Maar met de nieuwe eigenschap link afbakening wordt het proces gestroomlijnd en zullen je links goed werken. Je zult er blij mee zijn. We beloven het</p>\n</div>\n<div class=\"col\">\n<div class=\"wp-video\">\n<div id=\"mep_0\" class=\"mejs-container svg wp-video-shortcode mejs-video\" role=\"application\">\n<div class=\"mejs-inner\">\n<div class=\"mejs-controls\">\n<div class=\"mejs-button mejs-fullscreen-button\"></div>\n</div>\n<div class=\"mejs-clear\"></div>\n</div>\n</div>\n</div>\n</div>\n</div>\n<hr />\n<div class=\"feature-section two-col\">\n<div class=\"col\">\n<h3>Dichtstbijzijnde WordPress evenementen</h3>\n<p>Wist je dat WordPress een bloeiende offline community heeft met groepen die regelmatig bijeenkomen in meer dan 400 steden rond de wereld? WordPress vestigt nu je aandacht op de events die je helpen om door te gaan met verbeteren van je WordPress vaardigheden, vrienden te ontmoeten en natuurlijk om te publiceren!</p>\n<p>Dit is snel een van onze favoriete eigenschappen aan het worden. Terwijl je bezig bent in het dashboard (omdat je updates draait en berichten schrijft, toch?) worden alle WordCamps en WordPress Meetups getoond — bij jou in de buurt — die binnenkort plaatsvinden.</p>\n<p>Meedoen aan de community helpt je om je WordPress vaardigheden te verbeteren en te netwerken met personen die je anders niet zou tegenkomen. Je kunt eenvoudig lokale evenementen vinden door in te loggen op het dashboard en daar de nieuwe evenementen en nieuws widget bekijken.</p>\n</div>\n<div class=\"col\"><img class=\"size-full wp-image-751 aligncenter\" src=\"https://nl.wordpress.org/files/2017/06/WordPress-evenementen-nieuws-widget.png\" alt=\"\" width=\"618\" height=\"378\" srcset=\"https://nl.wordpress.org/files/2017/06/WordPress-evenementen-nieuws-widget.png 618w, https://nl.wordpress.org/files/2017/06/WordPress-evenementen-nieuws-widget-300x183.png 300w\" sizes=\"(max-width: 618px) 100vw, 618px\" /></div>\n</div>\n<hr />\n<div class=\"changelog\">\n<h2>Zelfs nog meer ontwikkelaarsgeluk <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<div class=\"under-the-hood three-col\">\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/17/cleaner-headings-in-the-admin-screens/\">Verbeterde toegankelijkheid admin paneel headings</a></h3>\n<p>Nieuwe CSS-regels betekent dat externe inhoud (zoals “Nieuwe toevoegen” links) niet meer toegevoegd moet worden in de admin headings. Deze panel-headings verbeteren de toegankelijkheid voor diegene die gebruik maken van hulpmiddelen.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/22/removal-of-core-embedding-support-for-wmv-and-wma-file-formats/\">Verwijderen van ondersteuning voor WMV en WMA bestanden</a></h3>\n<p>Omdat minder en minder browsers ondersteuning bieden voor Silverlight zijn bestandsformaten die de Silverlightplugin nodig hebben verwijderd. Bestanden worden nog steeds getoond als download link, maar worden niet meer automatisch ingevoegd.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/22/multisite-focused-changes-in-4-8/\">Multisite Updates</a></h3>\n<p>Nieuwe capabilities zijn geïntroduceerd in 4.8. met het oog op het verwijderen van aanroepen naar <code>is_super_admin()</code>. Verder zijn er nieuwe hooks en tweaks toegevoegd om precies het aantal sites en gebruikers per netwerk te controleren.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/23/addition-of-tinymce-to-the-text-widget/\">Text-Editor JavaScript API</a></h3>\n<p>Met het toevoegen van TinyMCE aan de tekstwidget in 4.8 komt een nieuwe JavaScript API die de editor activeert na het laden van de pagina. Dit kan worden gebruikt om de editor te activeren voor elk tekstvak waarbij je de knoppen en functies kan configureren. Geweldig voor pluginauteurs.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/26/media-widgets-for-images-video-and-audio/\">Mediawidgets API</a></h3>\n<p>De introductie van een nieuwe basis mediawidget REST API schema voor 4.8. biedt mogelijkheden voor meer mediawidgets (zoals galerijen of afspeellijsten) in de toekomst. De drie nieuwe mediawidgets worden ondersteund door een gedeelde class die zorg draagt voor de interactie met de mediamodel. Deze class maakt het ook eenvoudiger om nieuwe mediawidgets te maken and plaveit de weg voor nog meer.</p>\n</div>\n</div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://nl.wordpress.org/2017/06/08/wordpress-4-8-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Het einde van WordCamp The Netherlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://nl.wordpress.org/2017/03/30/het-einde-van-wordcamp-the-netherlands/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://nl.wordpress.org/2017/03/30/het-einde-van-wordcamp-the-netherlands/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Mar 2017 07:30:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=731\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:190:\"Op het WordPress NL teamblog wordt in een uitgebreide blog uitgelegd waarom er (voorlopig) geen WordCamp The Netherlands meer georganiseerd mag worden. Het einde van WordCamp The Netherlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcel Bootsman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:780:\"<p>Op het WordPress NL teamblog wordt in een uitgebreide blog uitgelegd waarom er (voorlopig) geen WordCamp The Netherlands meer georganiseerd mag worden.</p>\n<blockquote class=\"wp-embedded-content\" data-secret=\"w0H3F05tfB\"><p><a href=\"https://nl.wordpress.org/team/2017/03/30/het-einde-van-wordcamp-the-netherlands/\">Het einde van WordCamp The Netherlands</a></p></blockquote>\n<p><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" src=\"https://nl.wordpress.org/team/2017/03/30/het-einde-van-wordcamp-the-netherlands/embed/#?secret=w0H3F05tfB\" data-secret=\"w0H3F05tfB\" width=\"600\" height=\"338\" title=\"&#8220;Het einde van WordCamp The Netherlands&#8221; &#8212; Team NL\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://nl.wordpress.org/2017/03/30/het-einde-van-wordcamp-the-netherlands/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordCamp The Netherlands 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://nl.wordpress.org/2017/02/17/wordcamp-the-netherlands-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://nl.wordpress.org/2017/02/17/wordcamp-the-netherlands-2017/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Feb 2017 08:36:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=708\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:326:\"Op 14 februari was de kickoff meeting voor WordCamp The Netherlands 2017. Het nieuwe team We starten met een nieuw, groter team. Vorig jaar hebben we gemerkt dat er behoorlijk veel druk op het team lag, en dat er voor sommige aandachtsgebieden extra mensen nodig waren. We gaan dat aanpakken door naast de leads, ook [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcel Bootsman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3061:\"<p>Op 14 februari was de kickoff meeting voor WordCamp The Netherlands 2017.</p>\n<h2>Het nieuwe team</h2>\n<p>We starten met een nieuw, groter team. Vorig jaar hebben we gemerkt dat er behoorlijk veel druk op het team lag, en dat er voor sommige aandachtsgebieden extra mensen nodig waren. We gaan dat aanpakken door naast de leads, ook deputies aan te stellen (Nadat zij zich uiteraard bij ons hadden gemeld om mee te gaan helpen met de organisatie). Deze deputies helpen de leads waar nodig en worden actief betrokken bij beslissingen. Met de hulp van de deputies is ons team completer en kunnen we meer werk verzetten.</p>\n<h3>Leads:</h3>\n<ul>\n<li>Hoofdverantwoordelijke &#8211; Marcel Bootsman</li>\n<li>Design &amp; communicatie &#8211; Luc Princen</li>\n<li>Swag &amp; Goodies &#8211; Wendy Weel</li>\n<li>Sprekerselectie &#8211; Barry Kooij</li>\n<li>Sponsoring &#8211; Taco Verdonschot</li>\n<li>Vrijwilligers &#8211; Sjoerd Blom</li>\n<li>Locaties &#8211; Benoit Gütz</li>\n<li>Ervaringsdeskundige &#8211; Remkus de Vries</li>\n</ul>\n<h3>Deputies</h3>\n<ul>\n<li>DTP &#8211; Kelly Eekhof</li>\n<li>Webdesign &#8211; Thomas van der Westen</li>\n<li>Communicatie &#8211; Ines van Essen</li>\n<li>Goodies &#8211; Karin Bronwasser</li>\n<li>Sprekerselectie &#8211; Peter Luit</li>\n<li>Sponsoring &#8211; Mark Gruntjes</li>\n</ul>\n<h2>Wat hebben we besproken?</h2>\n<p>In de meeting hebben we, na een korte introductieronde, besproken welke rollen iedereen heeft en wat de verantwoordelijkheden zijn. Verder hebben we besproken dat de komende maanden elke twee weken een meeting zal plaatsvinden en dat de leads bij elke vergadering aanwezig zijn. Dit om de groep met aanwezigen tijdens de vergaderingen klein te houden, wat zorgt voor efficiënte vergaderingen. Vooraf maken we een planning waarbij vergaderingen een onderwerp krijgen, en daarbij worden dan ook de deputies uitgenodigd. Notulen van de vergaderingen zullen gemaakt worden door de leads, op rotatie-basis.</p>\n<h2>Tools</h2>\n<p>Om de vergaderingen soepel te laten verlopen gebruiken we Zoom. Met deze videoconferencedienst kunnen we met een gratis account 40 minuten vergaderen. Voldoende om alles te bespreken, en als er meer tijd nodig is, starten we gewoon een nieuwe.  Voor projectmanagement gebruiken we Trello. Met Trello heeft iedereen inzage in alles wat we besluiten/plannen. Slack wordt gebruikt voor groepschat en het stellen van vragen binnen het team</p>\n<h2>Locatie en datum</h2>\n<p>Op dit moment hebben we nog geen  locatie en datum. Na een hele mooie editie in de Jaarbeurs in 2016, willen we toch kijken of er misschien een andere locatie geschikt is. Zeker niet omdat we ontevreden zijn over de Jaarbeurs, integendeel zelfs.</p>\n<h2>Aantal bezoekers</h2>\n<p>Vorig jaar zijn we flink gegroeid qua aantal verkochte tickets. Dit jaar willen we weer een beetje groeien maar zo&#8217;n grote groei als vorig jaar is lastig te evenaren. Zodra we meer weten, laten we het hier weten.</p>\n<p>Mocht je naar aanleiding van dit bericht vragen of suggesties hebben, laat dan een reactie achter.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://nl.wordpress.org/2017/02/17/wordcamp-the-netherlands-2017/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"WordCamp Nijmegen zoekt organisatoren!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://nl.wordpress.org/2017/02/08/wordcamp-nijmegen-zoekt-organisatoren/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://nl.wordpress.org/2017/02/08/wordcamp-nijmegen-zoekt-organisatoren/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Feb 2017 08:29:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"WC024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=685\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:362:\"Beste WordPressers, In 2014 zijn Gijs Hovens (Savvii) en ondergetekende gestart met de WordPress Meetup in Nijmegen. Al snel sloot Linus Wiggers zich aan bij de organisatie en de laatste jaren hebben we gezamenlijk de 3-maandelijkse WordPress Meetup georganiseerd in Nijmegen. En dat zullen we blijven doen. WordCamp Nijmegen! Toch is het ook tijd voor [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Taco Verdonschot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3055:\"<p>Beste WordPressers,</p>\n<p>In 2014 zijn Gijs Hovens (Savvii) en ondergetekende gestart met de <a href=\"https://www.meetup.com/WordPress-Meetup-Nijmegen/\" target=\"_blank\">WordPress Meetup in Nijmegen</a>. Al snel sloot Linus Wiggers zich aan bij de organisatie en de laatste jaren hebben we gezamenlijk de 3-maandelijkse WordPress Meetup georganiseerd in Nijmegen. En dat zullen we blijven doen.</p>\n<p><strong>WordCamp Nijmegen!</strong><br />\nToch is het ook tijd voor een volgende stap. En als je al een succesvolle WordPress Meetup hebt, dan is de logische volgende stap een eigen WordCamp. Inderdaad. Een conferentie over alles rond WordPress in ons eigen Nijmegen.</p>\n<p>Je zal begrijpen dat het organiseren van een WordCamp nog meer tijd kost dan het organiseren van een meetup. Daarom is de eerste stap van de organisatie het vormen van een organisatieteam van 5 of 6 personen. Vervolgens gaan we op zoek naar een locatie en zodra dat rond is kan het échte plannen beginnen.</p>\n<p><strong>Organisatoren gezocht</strong><br />\nHet organisatieteam zal zich bezig houden met het zoeken van een geschikte locatie, het vinden van sponsoren, het vinden van sprekers en vrijwilligers, het (laten) maken van swag, het communiceren met bezoekers en media, en het maken van een prachtige WordCamp website. Kortom, er is veel te doen!</p>\n<p>Daarom wil ik je uitnodigen om je aan te melden als organisator. Dat kan via het contactformulier op <a href=\"https://2017.nijmegen.wordcamp.org/\" target=\"_blank\">https://2017.nijmegen.wordcamp.org/</a>. Een kort berichtje met je contactgegevens en een toelichting wat je zou willen doen en waarom je daar geschikt voor bent is genoeg.</p>\n<p>Je hebt <strong><em>tot en met 28 februari</em></strong> om je aan te melden, zodat we op 1 maart het team kunnen formeren.</p>\n<p>Ter informatie: omdat WordCamp Nijmegen een lokaal evenement is krijgen geïnteresseerden die in het 024-gebied wonen, bij gelijke geschiktheid, voorrang.</p>\n<p><strong>UPDATE: zie ook <a href=\"https://nl.wordpress.org/team/2017/02/13/wordcamp-nijmegen/\">https://nl.wordpress.org/team/2017/02/13/wordcamp-nijmegen/</a></strong></p>\n<p><strong>Geschatte tijdsinvestering</strong><br />\nDe organisatie van WordCamp Nijmegen kost natuurlijk tijd. Ik verwacht dat je in de aanloopfase ongeveer 1 uur per week kwijt bent. In de weken voor de conferentie zal dat oplopen en de laatste week ben je waarschijnlijk bijna full-time met WordCamp Nijmegen bezig.</p>\n<p>Mijn ervaring leert dat het erg prettig is als je werkgever achter je keuze staat en je toestaat om (een deel van) je werktijd te gebruiken voor de organisatie.</p>\n<p><strong>Vragen?</strong><br />\nVul het contactformulier op <a href=\"https://2017.nijmegen.wordcamp.org/\" target=\"_blank\">https://2017.nijmegen.wordcamp.org/</a> in, of stuur een e-mail naar <a href=\"mailto:nijmegen@wordcamp.org\">nijmegen@wordcamp.org</a></p>\n<p>Hopelijk tot binnenkort,<br />\nTaco Verdonschot</p>\n<p>E-mail: <a href=\"mailto:nijmegen@wordcamp.org\" target=\"_blank\">nijmegen@wordcamp.org</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://nl.wordpress.org/2017/02/08/wordcamp-nijmegen-zoekt-organisatoren/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n\n\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 4.7 is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://nl.wordpress.org/2016/12/06/wordpress-4-7-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2016/12/06/wordpress-4-7-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Dec 2016 21:22:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=661\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:411:\"Zojuist is WordPress 4.7 vrijgegeven. WordPress 4.7 zit bomvol verbeteringen van bestaande features en introduceert ook het nieuwe standaard thema voor 2017. We introduceren Twenty Seventeen Een volledig nieuw standaard thema brengt jouw site tot leven met uitgelichte afbeeldingen en video headers. Twenty Seventeen focust op bedrijfswebsites en heeft een aanpasbare hoofdpagina met meerdere secties. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:61:\"https://nl.wordpress.org/files/2016/12/starter-content-v1.mp4\";s:6:\"length\";s:7:\"1635917\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://nl.wordpress.org/files/2016/12/edit-shortcuts-v1.mp4\";s:6:\"length\";s:7:\"1195621\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://nl.wordpress.org/files/2016/12/header-video-v1.mp4\";s:6:\"length\";s:7:\"1546685\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9569:\"<p>Zojuist is WordPress 4.7 vrijgegeven. WordPress 4.7 zit bomvol verbeteringen van bestaande features en introduceert ook het nieuwe standaard thema voor 2017.</p>\n<h2>We introduceren Twenty Seventeen</h2>\n<p class=\"lead-description\">Een volledig nieuw standaard thema brengt jouw site tot leven met uitgelichte afbeeldingen en video headers.<img class=\"aligncenter size-full wp-image-662\" src=\"https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058.jpg\" alt=\"\" width=\"1058\" height=\"595\" srcset=\"https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058.jpg 1058w, https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058-300x169.jpg 300w, https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058-768x432.jpg 768w, https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058-1024x576.jpg 1024w\" sizes=\"(max-width: 1058px) 100vw, 1058px\" /></p>\n<p class=\"lead-description\">Twenty Seventeen focust op bedrijfswebsites en heeft een aanpasbare hoofdpagina met meerdere secties. Personaliseer met widgets, menu&#8217;s, social media menu&#8217;s, een logo, aangepaste kleuren en meer. Ons standaard thema voor 2017 werkt goed in veel talen, op elk apparaat en voor een breed spectrum aan gebruikers.</p>\n<h2>Jouw site, jouw manier</h2>\n<p class=\"lead-description\">WordPress 4.7 voegt nieuwe functies toe aan de customizer om je te helpen door de initiële setup van een thema te komen, met non-destructieve live voorbeelden van al je wijzigingen in één ononderbroken workflow.</p>\n<h3>Thema starter inhoud</h3>\n<p>Om je te helpen met het wijzigen van individuele thema&#8217;s, is er een solide basis beschikbaar via de start-inhoud bij het aanpassen van jouw site. Dit gaat van een eenvoudige bedrijfsinformatie widget tot het leveren van een voorbeeldmenu met sociale media iconen of het aanmaken van een statische pagina met mooie afbeeldingen. Maak je geen zorgen, niets zal worden getoond op je live site totdat jij klaar bent om je initiële thema aanpassingen te publiceren.</p>\n<div style=\"width: 612px;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-661-1\" width=\"612\" height=\"335\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://nl.wordpress.org/files/2016/12/starter-content-v1.mp4?_=1\" /><a href=\"https://nl.wordpress.org/files/2016/12/starter-content-v1.mp4\">https://nl.wordpress.org/files/2016/12/starter-content-v1.mp4</a></video></div>\n<h3>Bewerk snelkoppelingen</h3>\n<div style=\"width: 612px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-661-2\" width=\"612\" height=\"353\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://nl.wordpress.org/files/2016/12/edit-shortcuts-v1.mp4?_=2\" /><a href=\"https://nl.wordpress.org/files/2016/12/edit-shortcuts-v1.mp4\">https://nl.wordpress.org/files/2016/12/edit-shortcuts-v1.mp4</a></video></div>\n<p>Zichtbare iconen worden getoond om aan te geven welke delen van jouw site aangepast kunnen worden tijdens het live voorbeeld. Klik op de link om direct met bewerken te beginnen. Samen met de start-inhoud wordt het nog makkelijker om je site snel te wijzigen.</p>\n<h3>Video headers</h3>\n<div style=\"width: 612px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-661-3\" width=\"612\" height=\"353\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://nl.wordpress.org/files/2016/12/header-video-v1.mp4?_=3\" /><a href=\"https://nl.wordpress.org/files/2016/12/header-video-v1.mp4\">https://nl.wordpress.org/files/2016/12/header-video-v1.mp4</a></video></div>\n<p>Soms is een grote sfeervideo als bewegende kopafbeelding precies wat je nodig hebt om je producten te laten zien; ga je gang en probeer het uit met Twenty Seventeen. Heb je video-inspiratie nodig? Zoek maar eens naar sites die videoheaders beschikbaar hebben om te downloaden en gebruiken.</p>\n<h3>Makkelijker menu&#8217;s maken</h3>\n<p><img class=\"size-full wp-image-666 aligncenter\" src=\"https://nl.wordpress.org/files/2016/12/nav-menus-536.jpg\" alt=\"\" width=\"536\" height=\"282\" srcset=\"https://nl.wordpress.org/files/2016/12/nav-menus-536.jpg 536w, https://nl.wordpress.org/files/2016/12/nav-menus-536-300x158.jpg 300w\" sizes=\"(max-width: 536px) 100vw, 536px\" />Veel menu&#8217;s voor sites hebben links naar de pagina&#8217;s van je site, maar wat gebeurt er wanneer je er nog geen hebt? Nu kan je nieuwe pagina&#8217;s toevoegen terwijl je menu&#8217;s bouwt zonder dat je de customizer hoeft te verlaten en je de wijzigingen kwijt bent. Zodra je de wijzigingen hebt gepubliceerd staan de nieuwe pagina&#8217;s klaar om gevuld te worden.</p>\n<h3>Aangepaste CSS</h3>\n<p><img class=\"size-full wp-image-667 aligncenter\" src=\"https://nl.wordpress.org/files/2016/12/css-547.jpg\" alt=\"\" width=\"547\" height=\"288\" srcset=\"https://nl.wordpress.org/files/2016/12/css-547.jpg 547w, https://nl.wordpress.org/files/2016/12/css-547-300x158.jpg 300w\" sizes=\"(max-width: 547px) 100vw, 547px\" />Soms heb je een alleen een paar visuele veranderingen nodig om je site perfect te maken. WordPress 4.7 geeft je de mogelijkheid om aangepaste CSS toe te voegen en direct te zien wat voor effect deze aanpassingen op je site hebben. Het live voorbeeld laat je snel werken zonder steeds je pagina te moeten herladen.</p>\n<h3>PDF miniatuurvoorbeeld</h3>\n<p><img class=\"size-full wp-image-668 aligncenter\" src=\"https://nl.wordpress.org/files/2016/12/pdf-516.jpg\" alt=\"\" width=\"516\" height=\"272\" srcset=\"https://nl.wordpress.org/files/2016/12/pdf-516.jpg 516w, https://nl.wordpress.org/files/2016/12/pdf-516-300x158.jpg 300w\" sizes=\"(max-width: 516px) 100vw, 516px\" />Het beheren van jouw documenten is nog makkelijker geworden met WordPress 4.7. Na het uploaden van PDF&#8217;s wordt er ook een thumbnail gegenereerd zodat het eenvoudiger is om de documenten te onderscheiden.</p>\n<h3>Dashboard in jouw taal</h3>\n<p><img class=\"size-full wp-image-669 aligncenter\" src=\"https://nl.wordpress.org/files/2016/12/language-568.jpg\" alt=\"\" width=\"568\" height=\"299\" srcset=\"https://nl.wordpress.org/files/2016/12/language-568.jpg 568w, https://nl.wordpress.org/files/2016/12/language-568-300x158.jpg 300w\" sizes=\"(max-width: 568px) 100vw, 568px\" />Omdat jouw site in één taal is, betekent niet dat iedereen die helpt de site te beheren ook deze taal wil gebruiken in de admin. In de gebruikersprofielen zijn er meer talen beschikbaar gekomen om de gebruikerstaal in te stellen.</p>\n<h2>Introductie van REST API inhoud endpoints</h2>\n<p class=\"lead-description\">WordPress 4.7 komt met REST API endpoints voor berichten, reacties, termen, gebruikers, meta en instellingen.</p>\n<p><img class=\"aligncenter size-full wp-image-670\" src=\"https://nl.wordpress.org/files/2016/12/api-1559.jpg\" alt=\"\" width=\"1559\" height=\"505\" srcset=\"https://nl.wordpress.org/files/2016/12/api-1559.jpg 1559w, https://nl.wordpress.org/files/2016/12/api-1559-300x97.jpg 300w, https://nl.wordpress.org/files/2016/12/api-1559-768x249.jpg 768w, https://nl.wordpress.org/files/2016/12/api-1559-1024x332.jpg 1024w\" sizes=\"(max-width: 1559px) 100vw, 1559px\" /></p>\n<p>Inhoud endpoints leveren machine-leesbare externe toegang tot jouw WordPress site met een overzichtelijke, standaard-gedreven interface die ruimte biedt voor nieuwe en innovatieve methoden voor interacties van sites via plugins, thema&#8217;s, apps en nog meer. Klaar om te starten met het ontwikkelen? <a href=\"https://developer.wordpress.org/rest-api/reference/\">Bekijk en lees de REST API documentatie.</a></p>\n<div class=\"changelog\">\n<h2>Zelfs nog meer ontwikkelaars geluk <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<div class=\"under-the-hood three-col\">\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Berichttype templates</a></h3>\n<p>Door het openstellen van de pagina template eigenschappen voor alle berichttypes beschikken thema ontwikkelaars over nog meer flexibiliteit met de WordPress template hiërarchie.</p>\n</div>\n<div class=\"col\">\n<h3>Meer thema API hulpmiddelen</h3>\n<p>WordPress 4.7 bevat <a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">nieuwe functies, hooks en gedrag</a> voor thema ontwikkelaars.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\">Aangepaste bulk acties</a></h3>\n<p>Lijsttabellen, nu met meer dan alleen bulk bewerken en verwijderen.</p>\n</div>\n</div>\n<div class=\"under-the-hood three-col\">\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\"><code>WP_Hook</code></a></h3>\n<p>De code verantwoordelijk voor de acties en filters is aangepast en gemoderniseerd. Verder zijn er diverse bugs opgelost.</p>\n</div>\n<div class=\"col\">\n<h3>Registratie API instellingen</h3>\n<p><code>register_setting()</code> <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\">is verbeterd</a> door toevoeging van type, beschrijving en REST API zichtbaarheid.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-technical-design-decisions/\">Aangepaste changesets</a></h3>\n<p>Aangepaste changesets maken wijzigingen in de customizer robuust, net zoals automatisch opgeslagen concepten. Ook levert het nieuwe eigenschappen zoals inhoud om te starten.</p>\n</div>\n</div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://nl.wordpress.org/2016/12/06/wordpress-4-7-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Doe met ons mee op Global WordPress Translation Day!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://nl.wordpress.org/2016/10/26/doe-met-ons-mee-op-global-wordpress-translation-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://nl.wordpress.org/2016/10/26/doe-met-ons-mee-op-global-wordpress-translation-day/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Oct 2016 10:44:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Vertaling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"vertaling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=652\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:402:\"Het WordPress Polyglots team organiseert een tweede Global WordPress Translation Day op 12 november 2016. Iedereen is uitgenodigd om mee te doen – waar ook ter wereld! Vertalen is één van de makkelijkste manieren om bij te dragen aan WordPress. Global WordPress Translation Day is je kans om meer te weten te komen over het vertalen van WordPress, ontmoet mensen van over de hele [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chantal Coolsma\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3624:\"<p>Het WordPress Polyglots team organiseert een tweede <a href=\"https://wptranslationday.org/\">Global WordPress Translation Day</a> op 12 november 2016. Iedereen is uitgenodigd om mee te doen – waar ook ter wereld!</p>\n<p>Vertalen is één van de makkelijkste manieren om bij te dragen aan WordPress. Global WordPress Translation Day is je kans om meer te weten te komen over het vertalen van WordPress, ontmoet mensen van over de hele wereld en help <a href=\"https://make.wordpress.org/polyglots/teams\">WordPress vertalen in meer dan 160 talen</a>.</p>\n<h3>Doe met ons mee op 12 november waar ook ter wereld</h3>\n<p>De vertaaldag start op zaterdag 12 november 2016 om 0:00 UTC en duurt 24 uur. <a href=\"http://arewemeetingyet.com/UTC/2016-11-12/00:00/Global{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20WordPress{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20Translation{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20Day{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}202\">Bekijk welke tijd dat voor jou is!</a> Je kan meedoen vanaf het begin of op ieder moment dat jou het beste uitkomt die dag.</p>\n<h3>Wat doen we?</h3>\n<p>Locale contributor meetups worden over de hele wereld georganiseerd en zijn een goede manier om mee te doen. <a href=\"https://www.google.com/maps/d/viewer?mid=12Gni4JMfShyWHPqGNwh5-PMneMM&amp;usp=sharing\">Kijk op deze kaart</a> of er al een locale meetup bij jou in de buurt is. Kan je er geen vinden? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Organiseer een locale meetup!</a></p>\n<p>Doe op het zelfde moment mee met de <a href=\"https://www.crowdcast.io/e/gwtd2/register\">community voor 24 uur live-gestreamde, remote sessies</a> in verschillende talen. Sessies gaan over lokalisatie en bijdragen aan jouw taal.</p>\n<h3>Voor wie is het?</h3>\n<p>Of je nieuw bent als vertaler of een ervaren vertaalredacteur, de vertaaldag is er voor <i>jou</i>. Ontwikkelaars zullen ook genieten van de onderwerpen van ervaren contributors, of je nu leert over internationalisatie of meer vertalers voor je thema&#8217;s en plugins wilt vinden. Er is een sessie voor iedereen!</p>\n<h3>Doe mee</h3>\n<p>Mee doen is makkelijk! Op 12 november, in jouw tijdzone, <a href=\"https://translate.wordpress.org/\">vertaal WordPress</a> of je favoriete plugins en thema&#8217;s in je eigen taal, terwijl je gedurende de dag live-sessies volgt.</p>\n<p>Wil je meer doen? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Meld je locale meetup</a> en nodig je locale community uit om samen te vertalen op 12 november. Meetups kunnen formeel of informeel zijn – pak je laptop, neem een paar vrienden mee en ga naar een café in de buurt, om een uurtje of twee te vertalen.</p>\n<p>En als je heel veel zin hebt, help WordPress vertalen naar emoji! Jazeker, we hebben een vertaling van WordPress in emoji! <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f30e.png\" alt=\"🌎\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f30d.png\" alt=\"🌍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f30f.png\" alt=\"🌏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n<h3>Vragen?</h3>\n<p>Als je vragen hebt, het polyglots team en de meetup organizers zijn te vinden in het <a href=\"http://wordpress.slack.com/messages/polyglots/\">#polyglots kanaal op Slack</a> en helpen je graag! (Meld je aan voor Slack via <a href=\"https://chat.wordpress.org/\">chat.wordpress.org</a>.)</p>\n<p>Via de <a href=\"https://wptranslationday.org/\">officiële website</a> kun je je aanmelden voor het evenement.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://nl.wordpress.org/2016/10/26/doe-met-ons-mee-op-global-wordpress-translation-day/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:30:\"https://nl.wordpress.org/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 16 Nov 2018 13:50:59 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Thu, 19 Jul 2018 08:05:41 GMT\";s:4:\"link\";s:61:\"<https://nl.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20130911073210\";}","no");
INSERT INTO wpcf_options VALUES("139","_transient_timeout_feed_mod_26b0d8e18ed25a5313e8c7eb9c687d1b","1542419455","no");
INSERT INTO wpcf_options VALUES("140","_transient_feed_mod_26b0d8e18ed25a5313e8c7eb9c687d1b","1542376255","no");
INSERT INTO wpcf_options VALUES("141","_transient_timeout_dash_v2_12fb51b99c5dfec05835445e04f970a4","1542419455","no");
INSERT INTO wpcf_options VALUES("142","_transient_dash_v2_12fb51b99c5dfec05835445e04f970a4","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2018/11/wordpress-5-0-beta-5/\'>WordPress 5.0 Beta 5</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://nl.wordpress.org/2018/01/10/wordcamps-in-nederland-in-2018/\'>WordCamps in Nederland in 2018</a></li><li><a class=\'rsswidget\' href=\'https://nl.wordpress.org/2017/12/12/nederlanders-krijgen-commitrechten-op-wordpress-core/\'>Nederlanders krijgen commitrechten op WordPress</a></li><li><a class=\'rsswidget\' href=\'https://nl.wordpress.org/2017/11/16/wordpress-4-9-is-vrijgegeven/\'>WordPress 4.9 is vrijgegeven</a></li></ul></div>","no");
INSERT INTO wpcf_options VALUES("149","_transient_plugin_slugs","a:2:{i:0;s:19:\"akismet/akismet.php\";i:1;s:9:\"hello.php\";}","no");
INSERT INTO wpcf_options VALUES("150","recently_activated","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("153","current_theme","Jupiter","yes");
INSERT INTO wpcf_options VALUES("154","theme_mods_jupiter","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:14:{s:12:\"primary-menu\";i:15;s:11:\"second-menu\";i:0;s:10:\"third-menu\";i:0;s:11:\"fourth-menu\";i:0;s:10:\"fifth-menu\";i:0;s:10:\"sixth-menu\";i:0;s:12:\"seventh-menu\";i:0;s:11:\"eighth-menu\";i:0;s:10:\"ninth-menu\";i:0;s:10:\"tenth-menu\";i:0;s:11:\"footer-menu\";i:0;s:12:\"toolbar-menu\";i:0;s:19:\"side-dashboard-menu\";i:0;s:15:\"fullscreen-menu\";i:0;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1542379820;s:4:\"data\";a:18:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}s:9:\"sidebar-9\";a:0:{}s:10:\"sidebar-10\";a:0:{}s:10:\"sidebar-11\";a:0:{}s:10:\"sidebar-12\";a:0:{}s:10:\"sidebar-13\";a:0:{}s:10:\"sidebar-14\";a:0:{}s:10:\"sidebar-15\";a:0:{}s:10:\"sidebar-16\";a:0:{}s:10:\"sidebar-17\";a:0:{}}}s:18:\"custom_css_post_id\";i:-1;}","yes");
INSERT INTO wpcf_options VALUES("155","theme_switched","","yes");
INSERT INTO wpcf_options VALUES("156","mk_jupiter_theme_current_version","6.1.6","yes");
INSERT INTO wpcf_options VALUES("157","jupiter-data-tracking-hash","b4ef74e7ae3d285eaf39698d42891861","yes");
INSERT INTO wpcf_options VALUES("158","Jupiter_options_build","5beeec2b2d97f","yes");
INSERT INTO wpcf_options VALUES("159","mk_tour","a:1:{s:4:\"list\";a:1:{s:5:\"intro\";a:1:{s:5:\"state\";b:0;}}}","yes");
INSERT INTO wpcf_options VALUES("160","artbees_header_builder_db_version","2","yes");
INSERT INTO wpcf_options VALUES("235","widget_categories","a:3:{i:1;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("234","widget_text","a:2:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:113:\"<img src=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/jueves_logo_light.svg\" />\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("233","widget_search","a:2:{i:1;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("232","widget_meta","a:2:{i:1;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("231","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("230","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("229","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("228","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("227","widget_archives","a:2:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("226","widget_calendar","a:2:{i:1;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("251","widget_news_feed_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("252","widget_mini_slidshow_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("196","ls-plugin-version","6.7.6","yes");
INSERT INTO wpcf_options VALUES("197","ls-db-version","6.5.5","yes");
INSERT INTO wpcf_options VALUES("198","ls-installed","1","yes");
INSERT INTO wpcf_options VALUES("199","ls-date-installed","1542380038","yes");
INSERT INTO wpcf_options VALUES("225","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("201","vc_version","5.5.2","yes");
INSERT INTO wpcf_options VALUES("255","category_children","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("256","employees_category_children","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("257","faq_category_children","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("258","news_category_children","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("259","portfolio_category_children","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("260","testimonial_category_children","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("261","photo_album_category_children","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("193","_transient_mk_jupiter_theme_version","","yes");
INSERT INTO wpcf_options VALUES("174","_transient_timeout_mk_jupiter_theme_version","1542470794","no");
INSERT INTO wpcf_options VALUES("175","jupiter-data-tracking","no","yes");
INSERT INTO wpcf_options VALUES("176","artbees_api_key","1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d","yes");
INSERT INTO wpcf_options VALUES("177","mk_last_survey_check","2018-11-16 14:47:09","yes");
INSERT INTO wpcf_options VALUES("360","_transient_timeout_mk_request_user_info_1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d","1542390611","no");
INSERT INTO wpcf_options VALUES("361","_transient_mk_request_user_info_1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d","a:3:{s:6:\"status\";b:0;s:7:\"message\";s:40:\"API key verified but not VIP and master.\";s:19:\"purchase_key_object\";a:19:{s:2:\"id\";s:6:\"131108\";s:7:\"user_id\";s:5:\"66306\";s:12:\"purchase_key\";s:36:\"2f02bc61-695b-4ca9-a0ab-fff462d11df9\";s:7:\"api_key\";s:64:\"1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d\";s:10:\"product_id\";s:7:\"5177775\";s:8:\"validity\";s:1:\"0\";s:5:\"buyer\";s:15:\"MH1990Amsterdam\";s:9:\"is_active\";s:1:\"1\";s:6:\"domain\";s:33:\"thelighthousefoundation.didone.nl\";s:10:\"alexa_rank\";s:1:\"0\";s:11:\"create_date\";s:19:\"2018-04-08 09:12:30\";s:10:\"added_date\";s:19:\"2018-04-09 18:41:26\";s:12:\"last_checked\";s:19:\"2018-04-09 18:41:26\";s:11:\"is_verified\";s:1:\"0\";s:15:\"supported_until\";s:19:\"2018-10-08 00:12:30\";s:16:\"extended_support\";s:1:\"0\";s:20:\"generated_by_user_id\";N;s:9:\"is_master\";s:1:\"0\";s:4:\"user\";a:11:{s:2:\"ID\";s:5:\"66306\";s:10:\"user_login\";s:24:\"misjahermans90@gmail.com\";s:9:\"user_pass\";s:34:\"$P$BUUT43RRCWhoz/nKiUlb8k13TDftEa.\";s:13:\"user_nicename\";s:23:\"misjahermans90gmail-com\";s:10:\"user_email\";s:24:\"misjahermans90@gmail.com\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-04-09 15:39:35\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:13:\"Misja Hermans\";s:12:\"purchasekeys\";a:1:{i:0;a:18:{s:2:\"id\";s:6:\"131108\";s:7:\"user_id\";s:5:\"66306\";s:12:\"purchase_key\";s:36:\"2f02bc61-695b-4ca9-a0ab-fff462d11df9\";s:7:\"api_key\";s:64:\"1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d\";s:10:\"product_id\";s:7:\"5177775\";s:8:\"validity\";s:1:\"0\";s:5:\"buyer\";s:15:\"MH1990Amsterdam\";s:9:\"is_active\";s:1:\"1\";s:6:\"domain\";s:33:\"thelighthousefoundation.didone.nl\";s:10:\"alexa_rank\";s:1:\"0\";s:11:\"create_date\";s:19:\"2018-04-08 09:12:30\";s:10:\"added_date\";s:19:\"2018-04-09 18:41:26\";s:12:\"last_checked\";s:19:\"2018-04-09 18:41:26\";s:11:\"is_verified\";s:1:\"0\";s:15:\"supported_until\";s:19:\"2018-10-08 00:12:30\";s:16:\"extended_support\";s:1:\"0\";s:20:\"generated_by_user_id\";N;s:9:\"is_master\";s:1:\"0\";}}}}}","no");
INSERT INTO wpcf_options VALUES("181","mk_atp_user","1","yes");
INSERT INTO wpcf_options VALUES("349","theme-options-production-1542384686.css_sha1","a702594dc597d26f46bb1dd95cc09b34f98f6081","yes");
INSERT INTO wpcf_options VALUES("319","Jupiter_options_revision_1542384314","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","yes");
INSERT INTO wpcf_options VALUES("184","global_assets_timestamp","1542384683","yes");
INSERT INTO wpcf_options VALUES("185","mk_theme_options_css_file","theme-options-production-1542384686.css","yes");
INSERT INTO wpcf_options VALUES("186","jupiter_theme_version","6.1.6","yes");
INSERT INTO wpcf_options VALUES("187","Jupiter_options_imported","false","yes");
INSERT INTO wpcf_options VALUES("191","theme_mods_jupiter-child","a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:14:{s:15:\"fullscreen-menu\";i:0;s:12:\"primary-menu\";i:15;s:11:\"second-menu\";i:0;s:10:\"third-menu\";i:0;s:11:\"fourth-menu\";i:0;s:10:\"fifth-menu\";i:0;s:10:\"sixth-menu\";i:0;s:12:\"seventh-menu\";i:0;s:11:\"eighth-menu\";i:0;s:10:\"ninth-menu\";i:0;s:10:\"tenth-menu\";i:0;s:11:\"footer-menu\";i:0;s:12:\"toolbar-menu\";i:0;s:19:\"side-dashboard-menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1542384488;s:4:\"data\";a:4:{s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-1\";i:1;s:14:\"recent-posts-1\";i:2;s:17:\"recent-comments-1\";i:3;s:10:\"archives-1\";i:4;s:12:\"categories-1\";i:5;s:6:\"meta-1\";}s:9:\"sidebar-2\";a:5:{i:0;s:15:\"popular_posts-1\";i:1;s:12:\"categories-2\";i:2;s:10:\"calendar-1\";i:3;s:8:\"social-1\";i:4;s:11:\"tag_cloud-1\";}s:10:\"sidebar-10\";a:2:{i:0;s:6:\"text-1\";i:1;s:8:\"social-2\";}s:10:\"sidebar-11\";a:1:{i:0;s:10:\"nav_menu-1\";}}}}","yes");
INSERT INTO wpcf_options VALUES("247","widget_twitter","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("248","widget_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("244","widget_social","a:3:{i:1;a:17:{s:5:\"title\";s:0:\"\";s:3:\"alt\";s:12:\"Follow Us on\";s:4:\"size\";s:5:\"large\";s:5:\"align\";s:6:\"center\";s:4:\"skin\";s:6:\"custom\";s:10:\"icon_color\";s:7:\"#7ed321\";s:16:\"icon_hover_color\";s:7:\"#eeeeee\";s:17:\"icon_border_color\";s:0:\"\";s:18:\"icon_bg_main_color\";s:0:\"\";s:13:\"icon_bg_color\";s:0:\"\";s:12:\"icons_margin\";s:0:\"\";s:5:\"style\";s:14:\"square-rounded\";s:12:\"enable_sites\";a:3:{i:0;s:8:\"facebook\";i:1;s:9:\"instagram\";i:2;s:7:\"twitter\";}s:12:\"custom_count\";i:0;s:8:\"facebook\";s:32:\"https://www.facebook.com/artbees\";s:9:\"instagram\";s:30:\"https://instagram.com/artbees/\";s:7:\"twitter\";s:34:\"https://twitter.com/artbees_design\";}i:2;a:22:{s:5:\"title\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:4:\"size\";s:6:\"medium\";s:5:\"align\";s:4:\"left\";s:4:\"skin\";s:6:\"custom\";s:10:\"icon_color\";s:7:\"#7c7c7c\";s:16:\"icon_hover_color\";s:7:\"#efefef\";s:17:\"icon_border_color\";s:7:\"#ffffff\";s:18:\"icon_bg_main_color\";s:0:\"\";s:13:\"icon_bg_color\";s:0:\"\";s:12:\"icons_margin\";s:3:\"5px\";s:5:\"style\";s:6:\"circle\";s:12:\"enable_sites\";a:6:{i:0;s:8:\"facebook\";i:1;s:10:\"googleplus\";i:2;s:9:\"instagram\";i:3;s:9:\"pinterest\";i:4;s:6:\"tumblr\";i:5;s:7:\"twitter\";}s:12:\"custom_count\";i:0;s:8:\"facebook\";s:32:\"https://www.facebook.com/artbees\";s:10:\"googleplus\";s:51:\"https://plus.google.com/116884307097169354056/posts\";s:8:\"linkedin\";s:1:\"#\";s:3:\"rss\";s:1:\"#\";s:7:\"twitter\";s:34:\"https://twitter.com/artbees_design\";s:9:\"instagram\";s:31:\" https://instagram.com/artbees/\";s:9:\"pinterest\";s:34:\"https://www.pinterest.com/artbees/\";s:6:\"tumblr\";s:32:\"http://artbeesdesign.tumblr.com/\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("245","widget_subnav","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("246","widget_testimonial_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("220","layerslider_update_info","O:8:\"stdClass\":4:{s:5:\"basic\";O:8:\"stdClass\":9:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:27:\"LayerSlider/layerslider.php\";s:7:\"version\";s:5:\"6.7.6\";s:5:\"icons\";a:3:{s:2:\"1x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png\";s:2:\"2x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";s:7:\"default\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";}s:7:\"banners\";a:3:{s:3:\"low\";s:84:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png\";s:4:\"high\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";s:7:\"default\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";}s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:7:\"package\";s:0:\"\";s:6:\"tested\";s:5:\"4.9.6\";s:14:\"upgrade_notice\";s:62:\"This update contains new privacy settings for GDPR compliance.\";}s:4:\"full\";O:8:\"stdClass\":19:{s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"homepage\";s:72:\"http://kreaturamedia.com/layerslider-responsive-wordpress-slider-plugin/\";s:7:\"version\";s:5:\"6.7.6\";s:12:\"last_updated\";s:10:\"2018-05-22\";s:8:\"requires\";s:3:\"3.5\";s:6:\"tested\";s:5:\"4.9.6\";s:6:\"rating\";s:2:\"95\";s:11:\"num_ratings\";i:2806;s:14:\"upgrade_notice\";a:3:{s:6:\"stable\";s:62:\"This update contains new privacy settings for GDPR compliance.\";s:4:\"beta\";s:62:\"This update contains new privacy settings for GDPR compliance.\";s:4:\"edge\";s:62:\"This update contains new privacy settings for GDPR compliance.\";}s:6:\"author\";s:80:\"<a href=\"http://codecanyon.net/user/kreatura\" target=\"_blank\">Kreatura Media</a>\";s:3:\"url\";s:79:\"http://codecanyon.net/item/layerslider-wp-the-wordpress-parallax-slider/1362246\";s:8:\"external\";b:1;s:9:\"file_name\";s:10:\"plugin.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png\";s:2:\"2x\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";s:7:\"default\";s:79:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png\";}s:7:\"banners\";a:3:{s:3:\"low\";s:84:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png\";s:4:\"high\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";s:7:\"default\";s:85:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png\";}s:8:\"sections\";a:3:{s:9:\"changelog\";s:130:\"<p style=\"text-align: justify;\">\n	See the release log in the \'LayerSlider News\' section at the bottom of its main admin page.\n</p>\";s:12:\"installation\";s:456:\"<p style=\"text-align: justify;\">\n	Updating the plugin won\'t touch your sliders and settings and the new version always has backward compatibility,\n	so you don\'t have to worry about losing your work. Depending of the default settings, you may\n	have to adjust some options to get the new features. If you are experience unwanted behavior changes, it is always a\n	good idea to check your settings, there are probably new options to control these changes.\n</p>\";s:3:\"faq\";s:595:\"<p style=\"text-align: justify;\">\n	Before contacting us, please read our <a href=\"http://support.kreaturamedia.com/faq/4/layerslider-for-wordpress/\" target=\"_blank\">online FAQs</a>, or check the built-in documentation in the contextual Help menu on the top-right corner of the page. Please note, these Help menus are contextual, they will show you different content on different pages.\n</p>\n\n<p style=\"text-align: justify;\">\n	If you couldn\'t find an answer for your question, you can write us a comment at the Item\'s page on CodeCanyon, or send us an email from our CodeCanyon profile page.\n</p>\n\";}s:4:\"slug\";s:11:\"LayerSlider\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";}s:15:\"_latest_version\";s:5:\"6.7.6\";s:7:\"checked\";i:1542391869;}","yes");
INSERT INTO wpcf_options VALUES("213","ls-google-fonts","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("214","jupiter_template_installed","jueves","yes");
INSERT INTO wpcf_options VALUES("215","jupiter_template_installed_id","15681","yes");
INSERT INTO wpcf_options VALUES("216","contact-email-2342-15","admin@thelighthousefoundation.didone.nl","yes");
INSERT INTO wpcf_options VALUES("253","ls-latest-version","6.7.6","yes");
INSERT INTO wpcf_options VALUES("222","wpb_js_composer_license_activation_notified","yes","yes");
INSERT INTO wpcf_options VALUES("254","wpcf7","a:1:{s:7:\"version\";s:5:\"5.0.5\";}","yes");
INSERT INTO wpcf_options VALUES("264","show_on_front","page","yes");
INSERT INTO wpcf_options VALUES("263","page_on_front","7","yes");
INSERT INTO wpcf_options VALUES("265","sidebars_widgets","a:19:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-1\";i:1;s:14:\"recent-posts-1\";i:2;s:17:\"recent-comments-1\";i:3;s:10:\"archives-1\";i:4;s:12:\"categories-1\";i:5;s:6:\"meta-1\";}s:9:\"sidebar-2\";a:5:{i:0;s:15:\"popular_posts-1\";i:1;s:12:\"categories-2\";i:2;s:10:\"calendar-1\";i:3;s:8:\"social-1\";i:4;s:11:\"tag_cloud-1\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}s:9:\"sidebar-9\";a:0:{}s:10:\"sidebar-10\";a:2:{i:0;s:6:\"text-1\";i:1;s:8:\"social-2\";}s:10:\"sidebar-11\";a:1:{i:0;s:10:\"nav_menu-1\";}s:10:\"sidebar-12\";a:0:{}s:10:\"sidebar-13\";a:0:{}s:10:\"sidebar-14\";a:0:{}s:10:\"sidebar-15\";a:0:{}s:10:\"sidebar-16\";a:0:{}s:10:\"sidebar-17\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO wpcf_options VALUES("266","widget_recent-posts","a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("267","widget_recent-comments","a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("268","widget_popular_posts","a:2:{i:1;a:4:{s:5:\"title\";s:0:\"\";s:12:\"posts_number\";i:5;s:12:\"disable_time\";i:1;s:4:\"cats\";N;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("290","Jupiter_options_revision_1542382907","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","yes");
INSERT INTO wpcf_options VALUES("375","_transient_mk_getimagesize_f66466e6a5f77403a7b8a26d5338206ffc46ac33","a:3:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";}","no");
INSERT INTO wpcf_options VALUES("372","_transient_timeout_mk_critical_path_css","1542392685","no");
INSERT INTO wpcf_options VALUES("373","_transient_mk_critical_path_css","body,html{width:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};height:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};margin:0;padding:0}.page-preloader{top:0;left:0;z-index:999;position:fixed;height:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};width:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};text-align:center}.preloader-preview-area{-webkit-animation-delay:-.2s;animation-delay:-.2s;top:50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};-webkit-transform:translateY(100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9});-ms-transform:translateY(100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9});transform:translateY(100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9});margin-top:10px;max-height:calc(50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} - 20px);opacity:1;width:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};text-align:center;position:absolute}.preloader-logo{max-width:90{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};top:50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};-webkit-transform:translateY(-100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9});-ms-transform:translateY(-100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9});transform:translateY(-100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9});margin:-10px auto 0 auto;max-height:calc(50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9} - 20px);opacity:1;position:relative}.ball-pulse>div{width:15px;height:15px;border-radius:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};margin:2px;-webkit-animation-fill-mode:both;animation-fill-mode:both;display:inline-block;-webkit-animation:ball-pulse .75s infinite cubic-bezier(.2,.68,.18,1.08);animation:ball-pulse .75s infinite cubic-bezier(.2,.68,.18,1.08)}.ball-pulse>div:nth-child(1){-webkit-animation-delay:-.36s;animation-delay:-.36s}.ball-pulse>div:nth-child(2){-webkit-animation-delay:-.24s;animation-delay:-.24s}.ball-pulse>div:nth-child(3){-webkit-animation-delay:-.12s;animation-delay:-.12s}@-webkit-keyframes ball-pulse{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1);opacity:1}45{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(.1);transform:scale(.1);opacity:.7}80{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1);opacity:1}}@keyframes ball-pulse{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1);opacity:1}45{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(.1);transform:scale(.1);opacity:.7}80{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1);opacity:1}}.ball-clip-rotate-pulse{position:relative;-webkit-transform:translateY(-15px) translateX(-10px);-ms-transform:translateY(-15px) translateX(-10px);transform:translateY(-15px) translateX(-10px);display:inline-block}.ball-clip-rotate-pulse>div{-webkit-animation-fill-mode:both;animation-fill-mode:both;position:absolute;top:0;left:0;border-radius:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}}.ball-clip-rotate-pulse>div:first-child{height:36px;width:36px;top:7px;left:-7px;-webkit-animation:ball-clip-rotate-pulse-scale 1s 0s cubic-bezier(.09,.57,.49,.9) infinite;animation:ball-clip-rotate-pulse-scale 1s 0s cubic-bezier(.09,.57,.49,.9) infinite}.ball-clip-rotate-pulse>div:last-child{position:absolute;width:50px;height:50px;left:-16px;top:-2px;background:0 0;border:2px solid;-webkit-animation:ball-clip-rotate-pulse-rotate 1s 0s cubic-bezier(.09,.57,.49,.9) infinite;animation:ball-clip-rotate-pulse-rotate 1s 0s cubic-bezier(.09,.57,.49,.9) infinite;-webkit-animation-duration:1s;animation-duration:1s}@-webkit-keyframes ball-clip-rotate-pulse-rotate{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(0) scale(1);transform:rotate(0) scale(1)}50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(180deg) scale(.6);transform:rotate(180deg) scale(.6)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(360deg) scale(1);transform:rotate(360deg) scale(1)}}@keyframes ball-clip-rotate-pulse-rotate{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(0) scale(1);transform:rotate(0) scale(1)}50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(180deg) scale(.6);transform:rotate(180deg) scale(.6)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(360deg) scale(1);transform:rotate(360deg) scale(1)}}@-webkit-keyframes ball-clip-rotate-pulse-scale{30{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(.3);transform:scale(.3)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1)}}@keyframes ball-clip-rotate-pulse-scale{30{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(.3);transform:scale(.3)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1)}}@-webkit-keyframes square-spin{25{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:perspective(100px) rotateX(180deg) rotateY(0);transform:perspective(100px) rotateX(180deg) rotateY(0)}50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:perspective(100px) rotateX(180deg) rotateY(180deg);transform:perspective(100px) rotateX(180deg) rotateY(180deg)}75{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:perspective(100px) rotateX(0) rotateY(180deg);transform:perspective(100px) rotateX(0) rotateY(180deg)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:perspective(100px) rotateX(0) rotateY(0);transform:perspective(100px) rotateX(0) rotateY(0)}}@keyframes square-spin{25{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:perspective(100px) rotateX(180deg) rotateY(0);transform:perspective(100px) rotateX(180deg) rotateY(0)}50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:perspective(100px) rotateX(180deg) rotateY(180deg);transform:perspective(100px) rotateX(180deg) rotateY(180deg)}75{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:perspective(100px) rotateX(0) rotateY(180deg);transform:perspective(100px) rotateX(0) rotateY(180deg)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:perspective(100px) rotateX(0) rotateY(0);transform:perspective(100px) rotateX(0) rotateY(0)}}.square-spin{display:inline-block}.square-spin>div{-webkit-animation-fill-mode:both;animation-fill-mode:both;width:50px;height:50px;-webkit-animation:square-spin 3s 0s cubic-bezier(.09,.57,.49,.9) infinite;animation:square-spin 3s 0s cubic-bezier(.09,.57,.49,.9) infinite}.cube-transition{position:relative;-webkit-transform:translate(-25px,-25px);-ms-transform:translate(-25px,-25px);transform:translate(-25px,-25px);display:inline-block}.cube-transition>div{-webkit-animation-fill-mode:both;animation-fill-mode:both;width:15px;height:15px;position:absolute;top:-5px;left:-5px;-webkit-animation:cube-transition 1.6s 0s infinite ease-in-out;animation:cube-transition 1.6s 0s infinite ease-in-out}.cube-transition>div:last-child{-webkit-animation-delay:-.8s;animation-delay:-.8s}@-webkit-keyframes cube-transition{25{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateX(50px) scale(.5) rotate(-90deg);transform:translateX(50px) scale(.5) rotate(-90deg)}50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translate(50px,50px) rotate(-180deg);transform:translate(50px,50px) rotate(-180deg)}75{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateY(50px) scale(.5) rotate(-270deg);transform:translateY(50px) scale(.5) rotate(-270deg)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(-360deg);transform:rotate(-360deg)}}@keyframes cube-transition{25{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateX(50px) scale(.5) rotate(-90deg);transform:translateX(50px) scale(.5) rotate(-90deg)}50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translate(50px,50px) rotate(-180deg);transform:translate(50px,50px) rotate(-180deg)}75{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateY(50px) scale(.5) rotate(-270deg);transform:translateY(50px) scale(.5) rotate(-270deg)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(-360deg);transform:rotate(-360deg)}}.ball-scale>div{border-radius:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};margin:2px;-webkit-animation-fill-mode:both;animation-fill-mode:both;display:inline-block;height:60px;width:60px;-webkit-animation:ball-scale 1s 0s ease-in-out infinite;animation:ball-scale 1s 0s ease-in-out infinite}@-webkit-keyframes ball-scale{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(0);transform:scale(0)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1);opacity:0}}@keyframes ball-scale{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(0);transform:scale(0)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1);opacity:0}}.line-scale>div{-webkit-animation-fill-mode:both;animation-fill-mode:both;display:inline-block;width:5px;height:50px;border-radius:2px;margin:2px}.line-scale>div:nth-child(1){-webkit-animation:line-scale 1s -.5s infinite cubic-bezier(.2,.68,.18,1.08);animation:line-scale 1s -.5s infinite cubic-bezier(.2,.68,.18,1.08)}.line-scale>div:nth-child(2){-webkit-animation:line-scale 1s -.4s infinite cubic-bezier(.2,.68,.18,1.08);animation:line-scale 1s -.4s infinite cubic-bezier(.2,.68,.18,1.08)}.line-scale>div:nth-child(3){-webkit-animation:line-scale 1s -.3s infinite cubic-bezier(.2,.68,.18,1.08);animation:line-scale 1s -.3s infinite cubic-bezier(.2,.68,.18,1.08)}.line-scale>div:nth-child(4){-webkit-animation:line-scale 1s -.2s infinite cubic-bezier(.2,.68,.18,1.08);animation:line-scale 1s -.2s infinite cubic-bezier(.2,.68,.18,1.08)}.line-scale>div:nth-child(5){-webkit-animation:line-scale 1s -.1s infinite cubic-bezier(.2,.68,.18,1.08);animation:line-scale 1s -.1s infinite cubic-bezier(.2,.68,.18,1.08)}@-webkit-keyframes line-scale{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scaley(1);transform:scaley(1)}50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scaley(.4);transform:scaley(.4)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scaley(1);transform:scaley(1)}}@keyframes line-scale{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scaley(1);transform:scaley(1)}50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scaley(.4);transform:scaley(.4)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scaley(1);transform:scaley(1)}}.ball-scale-multiple{position:relative;-webkit-transform:translateY(30px);-ms-transform:translateY(30px);transform:translateY(30px);display:inline-block}.ball-scale-multiple>div{border-radius:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};-webkit-animation-fill-mode:both;animation-fill-mode:both;margin:2px;position:absolute;left:-30px;top:0;opacity:0;margin:0;width:50px;height:50px;-webkit-animation:ball-scale-multiple 1s 0s linear infinite;animation:ball-scale-multiple 1s 0s linear infinite}.ball-scale-multiple>div:nth-child(2){-webkit-animation-delay:-.2s;animation-delay:-.2s}.ball-scale-multiple>div:nth-child(3){-webkit-animation-delay:-.2s;animation-delay:-.2s}@-webkit-keyframes ball-scale-multiple{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(0);transform:scale(0);opacity:0}5{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{opacity:1}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1);opacity:0}}@keyframes ball-scale-multiple{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(0);transform:scale(0);opacity:0}5{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{opacity:1}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:scale(1);transform:scale(1);opacity:0}}.ball-pulse-sync{display:inline-block}.ball-pulse-sync>div{width:15px;height:15px;border-radius:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};margin:2px;-webkit-animation-fill-mode:both;animation-fill-mode:both;display:inline-block}.ball-pulse-sync>div:nth-child(1){-webkit-animation:ball-pulse-sync .6s -.21s infinite ease-in-out;animation:ball-pulse-sync .6s -.21s infinite ease-in-out}.ball-pulse-sync>div:nth-child(2){-webkit-animation:ball-pulse-sync .6s -.14s infinite ease-in-out;animation:ball-pulse-sync .6s -.14s infinite ease-in-out}.ball-pulse-sync>div:nth-child(3){-webkit-animation:ball-pulse-sync .6s -70ms infinite ease-in-out;animation:ball-pulse-sync .6s -70ms infinite ease-in-out}@-webkit-keyframes ball-pulse-sync{33{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateY(10px);transform:translateY(10px)}66{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateY(-10px);transform:translateY(-10px)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateY(0);transform:translateY(0)}}@keyframes ball-pulse-sync{33{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateY(10px);transform:translateY(10px)}66{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateY(-10px);transform:translateY(-10px)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:translateY(0);transform:translateY(0)}}.transparent-circle{display:inline-block;border-top:.5em solid rgba(255,255,255,.2);border-right:.5em solid rgba(255,255,255,.2);border-bottom:.5em solid rgba(255,255,255,.2);border-left:.5em solid #fff;-webkit-transform:translateZ(0);transform:translateZ(0);-webkit-animation:transparent-circle 1.1s infinite linear;animation:transparent-circle 1.1s infinite linear;width:50px;height:50px;border-radius:50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}}.transparent-circle:after{border-radius:50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};width:10em;height:10em}@-webkit-keyframes transparent-circle{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(0);transform:rotate(0)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes transparent-circle{0{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(0);transform:rotate(0)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}.ball-spin-fade-loader{position:relative;top:-10px;left:-10px;display:inline-block}.ball-spin-fade-loader>div{width:15px;height:15px;border-radius:100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9};margin:2px;-webkit-animation-fill-mode:both;animation-fill-mode:both;position:absolute;-webkit-animation:ball-spin-fade-loader 1s infinite linear;animation:ball-spin-fade-loader 1s infinite linear}.ball-spin-fade-loader>div:nth-child(1){top:25px;left:0;animation-delay:-.84s;-webkit-animation-delay:-.84s}.ball-spin-fade-loader>div:nth-child(2){top:17.05px;left:17.05px;animation-delay:-.72s;-webkit-animation-delay:-.72s}.ball-spin-fade-loader>div:nth-child(3){top:0;left:25px;animation-delay:-.6s;-webkit-animation-delay:-.6s}.ball-spin-fade-loader>div:nth-child(4){top:-17.05px;left:17.05px;animation-delay:-.48s;-webkit-animation-delay:-.48s}.ball-spin-fade-loader>div:nth-child(5){top:-25px;left:0;animation-delay:-.36s;-webkit-animation-delay:-.36s}.ball-spin-fade-loader>div:nth-child(6){top:-17.05px;left:-17.05px;animation-delay:-.24s;-webkit-animation-delay:-.24s}.ball-spin-fade-loader>div:nth-child(7){top:0;left:-25px;animation-delay:-.12s;-webkit-animation-delay:-.12s}.ball-spin-fade-loader>div:nth-child(8){top:17.05px;left:-17.05px;animation-delay:0s;-webkit-animation-delay:0s}@-webkit-keyframes ball-spin-fade-loader{50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{opacity:.3;-webkit-transform:scale(.4);transform:scale(.4)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{opacity:1;-webkit-transform:scale(1);transform:scale(1)}}@keyframes ball-spin-fade-loader{50{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{opacity:.3;-webkit-transform:scale(.4);transform:scale(.4)}100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}{opacity:1;-webkit-transform:scale(1);transform:scale(1)}}","no");
INSERT INTO wpcf_options VALUES("374","_transient_timeout_mk_getimagesize_f66466e6a5f77403a7b8a26d5338206ffc46ac33","1542392686","no");
INSERT INTO wpcf_options VALUES("330","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1542384488;s:7:\"checked\";a:5:{s:13:\"jupiter-child\";s:0:\"\";s:7:\"jupiter\";s:5:\"6.1.6\";s:13:\"twentyfifteen\";s:3:\"2.0\";s:15:\"twentyseventeen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","no");
INSERT INTO wpcf_options VALUES("278","Jupiter_options_revision_1542382778","YTo0NTY6e3M6MTA6InNraW5fY29sb3IiO3M6NzoiIzdlZDMyMSI7czoxMjoic21vb3Roc2Nyb2xsIjtzOjQ6InRydWUiO3M6MTQ6InBhZ2VzX2NvbW1lbnRzIjtzOjU6ImZhbHNlIjtzOjk6ImdvX3RvX3RvcCI7czo0OiJ0cnVlIjtzOjEzOiJyZXRpbmFfaW1hZ2VzIjtzOjQ6InRydWUiO3M6MTc6InJlc3BvbnNpdmVfaW1hZ2VzIjtzOjQ6InRydWUiO3M6MjA6ImltYWdlX3Jlc2l6ZV9xdWFsaXR5IjtzOjM6IjEwMCI7czoxMToic3ZnX3N1cHBvcnQiO3M6NToiZmFsc2UiO3M6MjY6ImZ1bGxzY3JlZW5fbmF2X2xvZ29fbWFyZ2luIjtzOjM6IjEyNSI7czo0OiJsb2dvIjtzOjk4OiJodHRwOi8vZGVtb3MuYXJ0YmVlcy5uZXQvanVwaXRlcjUvanVldmVzL3dwLWNvbnRlbnQvdXBsb2Fkcy9zaXRlcy8xMTIvMjAxNi8wNS9qdWV2ZXNfbG9nb19kYXJrLnN2ZyI7czoxNzoibGlnaHRfaGVhZGVyX2xvZ28iO3M6OTk6Imh0dHA6Ly9kZW1vcy5hcnRiZWVzLm5ldC9qdXBpdGVyNS9qdWV2ZXMvd3AtY29udGVudC91cGxvYWRzL3NpdGVzLzExMi8yMDE2LzA1L2p1ZXZlc19sb2dvX2xpZ2h0LnN2ZyI7czoxODoic3RpY2t5X2hlYWRlcl9sb2dvIjtzOjA6IiI7czoxNToicmVzcG9uc2l2ZV9sb2dvIjtzOjA6IiI7czoxMToiZm9vdGVyX2xvZ28iO3M6MDoiIjtzOjE0OiJjdXN0b21fZmF2aWNvbiI7czo5NjoiaHR0cDovL2RlbW9zLmFydGJlZXMubmV0L2p1cGl0ZXI1L2p1ZXZlcy93cC1jb250ZW50L3VwbG9hZHMvc2l0ZXMvMTEyLzIwMTYvMDUvZmF2aWNvbi1qdWV2ZXMucG5nIjtzOjExOiJpcGhvbmVfaWNvbiI7czowOiIiO3M6MTg6ImlwaG9uZV9pY29uX3JldGluYSI7czowOiIiO3M6OToiaXBhZF9pY29uIjtzOjA6IiI7czoxNjoiaXBhZF9pY29uX3JldGluYSI7czowOiIiO3M6OToicHJlbG9hZGVyIjtzOjQ6InRydWUiO3M6MTY6InJldGluYV9wcmVsb2FkZXIiO3M6NToiZmFsc2UiO3M6MTQ6InByZWxvYWRlcl9sb2dvIjtzOjEwMToiaHR0cDovL2RlbW9zLmFydGJlZXMubmV0L2p1cGl0ZXI1L2p1ZXZlcy93cC1jb250ZW50L3VwbG9hZHMvc2l0ZXMvMTEyLzIwMTYvMDUvanVldmVzX2xvZ29fbGlnaHQtMS5zdmciO3M6MjA6InByZWxvYWRlcl9pY29uX2NvbG9yIjtzOjc6IiNmZmZmZmYiO3M6MTg6InByZWxvYWRlcl9iZ19jb2xvciI7czo3OiIjMDAwMDAwIjtzOjIzOiJzZWN0aW9uX3ByZWxvYWRlcl9jb2xvciI7czo3OiIjZmZmZmZmIjtzOjE5OiJwcmVsb2FkZXJfYW5pbWF0aW9uIjtzOjEwOiJsaW5lX3NjYWxlIjtzOjIxOiJkaXNhYmxlX3F1aWNrX2NvbnRhY3QiO3M6NDoidHJ1ZSI7czoyMzoicXVpY2tfY29udGFjdF9vbl9zaW5nbGUiO3M6NDoidHJ1ZSI7czoyMToiY2FwdGNoYV9xdWlja19jb250YWN0IjtzOjQ6InRydWUiO3M6MTk6InF1aWNrX2NvbnRhY3RfZW1haWwiO3M6Mzk6ImFkbWluQHRoZWxpZ2h0aG91c2Vmb3VuZGF0aW9uLmRpZG9uZS5ubCI7czoxOToicXVpY2tfY29udGFjdF90aXRsZSI7czoxMDoiQ29udGFjdCBVcyI7czoxODoicXVpY2tfY29udGFjdF9kZXNjIjtzOjg5OiJXZSdyZSBub3QgYXJvdW5kIHJpZ2h0IG5vdy4gQnV0IHlvdSBjYW4gc2VuZCB1cyBhbiBlbWFpbCBhbmQgd2UnbGwgZ2V0IGJhY2sgdG8geW91LCBhc2FwLiI7czoyMDoidHdpdHRlcl9jb25zdW1lcl9rZXkiO3M6MDoiIjtzOjIzOiJ0d2l0dGVyX2NvbnN1bWVyX3NlY3JldCI7czowOiIiO3M6MjA6InR3aXR0ZXJfYWNjZXNzX3Rva2VuIjtzOjA6IiI7czoyNzoidHdpdHRlcl9hY2Nlc3NfdG9rZW5fc2VjcmV0IjtzOjA6IiI7czoxNzoibWFpbGNoaW1wX2FwaV9rZXkiO3M6MDoiIjtzOjE3OiJtYWlsY2hpbXBfbGlzdF9pZCI7czowOiIiO3M6MTU6Im1haWxjaGltcF9vcHRpbiI7czo1OiJmYWxzZSI7czoxOToiZ29vZ2xlX21hcHNfYXBpX2tleSI7czowOiIiO3M6OToiYW5hbHl0aWNzIjtzOjA6IiI7czoxMDoidHlwZWtpdF9pZCI7czowOiIiO3M6MzE6ImJhY2tncm91bmRfc2VsZWN0b3Jfb3JpZW50YXRpb24iO3M6MTc6ImZ1bGxfd2lkdGhfbGF5b3V0IjtzOjEwOiJncmlkX3dpZHRoIjtzOjQ6IjExNDAiO3M6MTM6ImNvbnRlbnRfd2lkdGgiO3M6MjoiNzMiO3M6MTg6ImNvbnRlbnRfcmVzcG9uc2l2ZSI7czozOiI5NjAiO3M6MjA6InJlc3BvbnNpdmVfbmF2X3dpZHRoIjtzOjQ6IjExNDAiO3M6MTk6InN0aWNrX3RlbXBsYXRlX3BhZ2UiO3M6NToiZmFsc2UiO3M6MTE6ImJvZHlfYm9yZGVyIjtzOjU6ImZhbHNlIjtzOjIxOiJib2R5X2JvcmRlcl90aGlja25lc3MiO3M6MjoiNTAiO3M6MTc6ImJvZHlfYm9yZGVyX2NvbG9yIjtzOjQ6IiNmZmYiO3M6Mjk6ImJvZHlfYm9yZGVyX29uX21vYmlsZV9kZXZpY2VzIjtzOjU6ImZhbHNlIjtzOjI0OiJwYWdlX3RpdGxlX2V4cGFuZF9oZWFkZXIiO3M6NDoidHJ1ZSI7czoyNDoiYm94ZWRfbGF5b3V0X3NoYWRvd19zaXplIjtzOjE6IjAiO3M6Mjk6ImJveGVkX2xheW91dF9zaGFkb3dfaW50ZW5zaXR5IjtzOjE6IjAiO3M6MTg6ImdlbmVyYWxfYmFja2dvdW5kcyI7czowOiIiO3M6MjA6ImJnX3BhbmVsX2ltYWdlX3N0eWxlIjtzOjg6Im5vLWltYWdlIjtzOjE1OiJiZ19wYW5lbF91cGxvYWQiO3M6MDoiIjtzOjIwOiJiZ19wYW5lbF9jb2xvcl9zdHlsZSI7czo2OiJzaW5nbGUiO3M6MTQ6ImJnX3BhbmVsX2NvbG9yIjtzOjA6IiI7czoxNjoiYmdfcGFuZWxfY29sb3JfMiI7czowOiIiO3M6MjE6ImdyYW5kaWVudF9jb2xvcl9zdHlsZSI7czo2OiJsaW5lYXIiO3M6MjE6ImdyYW5kaWVudF9jb2xvcl9hbmdsZSI7czo4OiJ2ZXJ0aWNhbCI7czoxNToiYmdfcGFuZWxfcmVwZWF0IjtzOjA6IiI7czoxOToiYmdfcGFuZWxfYXR0YWNobWVudCI7czowOiIiO3M6MTc6ImJnX3BhbmVsX3Bvc2l0aW9uIjtzOjA6IiI7czoxMzoiYmdfcGFuZWxfc2l6ZSI7czo1OiJmYWxzZSI7czoxMDoiYm9keV9jb2xvciI7czo0OiIjZmZmIjtzOjE5OiJib2R5X2NvbG9yX2dyYWRpZW50IjtzOjY6InNpbmdsZSI7czoxMjoiYm9keV9jb2xvcl8yIjtzOjA6IiI7czoyNToiYm9keV9jb2xvcl9ncmFkaWVudF9zdHlsZSI7czo2OiJsaW5lYXIiO3M6MjU6ImJvZHlfY29sb3JfZ3JhZGllbnRfYW5nbGUiO3M6ODoidmVydGljYWwiO3M6MTA6ImJvZHlfaW1hZ2UiO3M6MDoiIjtzOjk6ImJvZHlfc2l6ZSI7czo1OiJmYWxzZSI7czoxMzoiYm9keV9wb3NpdGlvbiI7czowOiIiO3M6MTU6ImJvZHlfYXR0YWNobWVudCI7czowOiIiO3M6MTE6ImJvZHlfcmVwZWF0IjtzOjA6IiI7czoxMToiYm9keV9zb3VyY2UiO3M6ODoibm8taW1hZ2UiO3M6MTA6InBhZ2VfY29sb3IiO3M6NDoiI2ZmZiI7czoxOToicGFnZV9jb2xvcl9ncmFkaWVudCI7czo2OiJzaW5nbGUiO3M6MTI6InBhZ2VfY29sb3JfMiI7czowOiIiO3M6MjU6InBhZ2VfY29sb3JfZ3JhZGllbnRfc3R5bGUiO3M6NjoibGluZWFyIjtzOjI1OiJwYWdlX2NvbG9yX2dyYWRpZW50X2FuZ2xlIjtzOjg6InZlcnRpY2FsIjtzOjEwOiJwYWdlX2ltYWdlIjtzOjA6IiI7czo5OiJwYWdlX3NpemUiO3M6NToiZmFsc2UiO3M6MTM6InBhZ2VfcG9zaXRpb24iO3M6MDoiIjtzOjE1OiJwYWdlX2F0dGFjaG1lbnQiO3M6MDoiIjtzOjExOiJwYWdlX3JlcGVhdCI7czowOiIiO3M6MTE6InBhZ2Vfc291cmNlIjtzOjg6Im5vLWltYWdlIjtzOjEyOiJoZWFkZXJfY29sb3IiO3M6NDoiI2ZmZiI7czoyMToiaGVhZGVyX2NvbG9yX2dyYWRpZW50IjtzOjY6InNpbmdsZSI7czoxNDoiaGVhZGVyX2NvbG9yXzIiO3M6MDoiIjtzOjI3OiJoZWFkZXJfY29sb3JfZ3JhZGllbnRfc3R5bGUiO3M6NjoibGluZWFyIjtzOjI3OiJoZWFkZXJfY29sb3JfZ3JhZGllbnRfYW5nbGUiO3M6ODoidmVydGljYWwiO3M6MTI6ImhlYWRlcl9pbWFnZSI7czowOiIiO3M6MTE6ImhlYWRlcl9zaXplIjtzOjU6ImZhbHNlIjtzOjE1OiJoZWFkZXJfcG9zaXRpb24iO3M6MDoiIjtzOjE3OiJoZWFkZXJfYXR0YWNobWVudCI7czowOiIiO3M6MTM6ImhlYWRlcl9yZXBlYXQiO3M6MDoiIjtzOjEzOiJoZWFkZXJfc291cmNlIjtzOjg6Im5vLWltYWdlIjtzOjEyOiJiYW5uZXJfY29sb3IiO3M6NzoiI2ZmZmZmZiI7czoyMToiYmFubmVyX2NvbG9yX2dyYWRpZW50IjtzOjY6InNpbmdsZSI7czoxNDoiYmFubmVyX2NvbG9yXzIiO3M6MDoiIjtzOjI3OiJiYW5uZXJfY29sb3JfZ3JhZGllbnRfc3R5bGUiO3M6NjoibGluZWFyIjtzOjI3OiJiYW5uZXJfY29sb3JfZ3JhZGllbnRfYW5nbGUiO3M6ODoidmVydGljYWwiO3M6MTI6ImJhbm5lcl9pbWFnZSI7czowOiIiO3M6MTE6ImJhbm5lcl9zaXplIjtzOjQ6InRydWUiO3M6MTU6ImJhbm5lcl9wb3NpdGlvbiI7czowOiIiO3M6MTc6ImJhbm5lcl9hdHRhY2htZW50IjtzOjA6IiI7czoxMzoiYmFubmVyX3JlcGVhdCI7czowOiIiO3M6MTM6ImJhbm5lcl9zb3VyY2UiO3M6ODoibm8taW1hZ2UiO3M6MTI6ImZvb3Rlcl9jb2xvciI7czo3OiIjM2Q0MDQ1IjtzOjIxOiJmb290ZXJfY29sb3JfZ3JhZGllbnQiO3M6Njoic2luZ2xlIjtzOjE0OiJmb290ZXJfY29sb3JfMiI7czowOiIiO3M6Mjc6ImZvb3Rlcl9jb2xvcl9ncmFkaWVudF9zdHlsZSI7czo2OiJsaW5lYXIiO3M6Mjc6ImZvb3Rlcl9jb2xvcl9ncmFkaWVudF9hbmdsZSI7czo4OiJ2ZXJ0aWNhbCI7czoxMjoiZm9vdGVyX2ltYWdlIjtzOjA6IiI7czoxMToiZm9vdGVyX3NpemUiO3M6NToiZmFsc2UiO3M6MTU6ImZvb3Rlcl9wb3NpdGlvbiI7czowOiIiO3M6MTc6ImZvb3Rlcl9hdHRhY2htZW50IjtzOjA6IiI7czoxMzoiZm9vdGVyX3JlcGVhdCI7czowOiIiO3M6MTM6ImZvb3Rlcl9zb3VyY2UiO3M6ODoibm8taW1hZ2UiO3M6MTE6ImJvZHlfd2VpZ2h0IjtzOjM6IjQwMCI7czoxNDoiYm9keV9mb250X3NpemUiO3M6MjoiMTQiO3M6MTY6ImJvZHlfbGluZV9oZWlnaHQiO3M6NDoiMS42NiI7czoxNToiYm9keV90ZXh0X2NvbG9yIjtzOjc6IiM3Nzc3NzciO3M6NzoiYV9jb2xvciI7czo3OiIjMmUyZTJlIjtzOjEzOiJhX2NvbG9yX2hvdmVyIjtzOjc6IiM3ZWQzMjEiO3M6MTI6InN0cm9uZ19jb2xvciI7czo3OiIjN2VkMzIxIjtzOjY6InBfc2l6ZSI7czoyOiIxOCI7czoxMzoicF9saW5lX2hlaWdodCI7czo0OiIxLjY2IjtzOjc6InBfY29sb3IiO3M6MTU6InJnYmEoMCwwLDAsMC44KSI7czoyMDoiaGVhZGluZ3NfbGluZV9oZWlnaHQiO3M6MzoiMS4zIjtzOjk6ImgxX3dlaWdodCI7czozOiI2MDAiO3M6MTI6ImgxX3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6NzoiaDFfc2l6ZSI7czoyOiIzNiI7czo4OiJoMV9jb2xvciI7czo3OiIjNDA0MDQwIjtzOjk6ImgyX3dlaWdodCI7czozOiI2MDAiO3M6MTI6ImgyX3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6NzoiaDJfc2l6ZSI7czoyOiIzMCI7czo4OiJoMl9jb2xvciI7czo3OiIjNDA0MDQwIjtzOjk6ImgzX3dlaWdodCI7czozOiI2MDAiO3M6MTI6ImgzX3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6NzoiaDNfc2l6ZSI7czoyOiIyNCI7czo4OiJoM19jb2xvciI7czo3OiIjNDA0MDQwIjtzOjk6Img0X3dlaWdodCI7czozOiI2MDAiO3M6MTI6Img0X3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6NzoiaDRfc2l6ZSI7czoyOiIxOCI7czo4OiJoNF9jb2xvciI7czo3OiIjNDA0MDQwIjtzOjk6Img1X3dlaWdodCI7czozOiI2MDAiO3M6MTI6Img1X3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6NzoiaDVfc2l6ZSI7czoyOiIxNiI7czo4OiJoNV9jb2xvciI7czo3OiIjNDA0MDQwIjtzOjk6Img2X3dlaWdodCI7czozOiI2MDAiO3M6MTI6Img2X3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6NzoiaDZfc2l6ZSI7czoyOiIxNCI7czo4OiJoNl9jb2xvciI7czo3OiIjNDA0MDQwIjtzOjIxOiJoZWFkZXJfbGF5b3V0X2J1aWxkZXIiO3M6MTY6InByZV9idWlsdF9oZWFkZXIiO3M6MTg6InRoZW1lX2hlYWRlcl9zdHlsZSI7czoxOiIxIjtzOjE0OiJzZWNvbmRhcnlfbWVudSI7czoxMDoiZnVsbHNjcmVlbiI7czoxODoiaGVhZGVyX2J1cmdlcl9zaXplIjtzOjU6InNtYWxsIjtzOjIzOiJzZW9uZGFyeV9oZWFkZXJfZm9yX2FsbCI7czo1OiJmYWxzZSI7czoxODoidmVydGljYWxfbWVudV9hbmltIjtzOjE6IjEiO3M6MjY6InZlcnRpY2FsX2hlYWRlcl9sb2dvX2FsaWduIjtzOjY6ImNlbnRlciI7czoyODoidmVydGljYWxfaGVhZGVyX2xvZ29fcGFkZGluZyI7czoyOiIxMCI7czoyMToidmVydGljYWxfaGVhZGVyX2FsaWduIjtzOjQ6ImxlZnQiO3M6MjM6InZlcnRpY2FsX21lbnVfY29weXJpZ2h0IjtzOjM3OiJDb3B5cmlnaHQgQWxsIFJpZ2h0cyBSZXNlcnZlZCDCqSAyMDE1IjtzOjExOiJoZWFkZXJfZ3JpZCI7czo0OiJ0cnVlIjtzOjE2OiJoaWRlX2hlYWRlcl9sb2dvIjtzOjQ6InRydWUiO3M6MTQ6ImxvZ29faW5fbWlkZGxlIjtzOjU6ImZhbHNlIjtzOjE1OiJoaWRlX2hlYWRlcl9uYXYiO3M6NDoidHJ1ZSI7czoyMjoiaGVhZGVyX3NlYXJjaF9sb2NhdGlvbiI7czoxNzoiZnVsbHNjcmVlbl9zZWFyY2giO3M6MjI6ImhlYWRlcl9zdGFydF90b3VyX3RleHQiO3M6MDoiIjtzOjIyOiJoZWFkZXJfc3RhcnRfdG91cl9wYWdlIjtzOjA6IiI7czoxNToic3RhcnRfdG91cl9zaXplIjtzOjI6IjE0IjtzOjEzOiJsb2dnZWRpbl9tZW51IjtzOjEyOiJwcmltYXJ5LW1lbnUiO3M6MTM6ImhlYWRlcl9oZWlnaHQiO3M6MzoiMTIwIjtzOjE3OiJyZXNfaGVhZGVyX2hlaWdodCI7czoyOiI5MCI7czoxNDoiaGVhZGVyX29wYWNpdHkiO3M6MToiMSI7czoyNzoiaGVhZGVyX2J0bl9ib3JkZXJfdGhpY2tuZXNzIjtzOjE6IjEiO3M6MTk6ImhlYWRlcl9ib3JkZXJfY29sb3IiO3M6NzoiI2VkZWRlZCI7czoxNjoic3RhcnRfdG91cl9jb2xvciI7czo3OiIjMzMzMzMzIjtzOjE5OiJoZWFkZXJfYnVyZ2VyX2NvbG9yIjtzOjA6IiI7czoxNzoibWFpbl9uYXZfYmdfY29sb3IiO3M6MDoiIjtzOjE0OiJtYWluX25hdl9ob3ZlciI7czoxOiI1IjtzOjE5OiJtYWluX25hdl90b3Bfd2VpZ2h0IjtzOjM6IjYwMCI7czoxOToibWFpbl9tZW51X3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6MTc6Im1haW5fbmF2X3RvcF9zaXplIjtzOjI6IjEzIjtzOjI3OiJtYWluX25hdl90b3BfbGV0dGVyX3NwYWNpbmciO3M6MToiMCI7czoxOToibWFpbl9uYXZfaXRlbV9zcGFjZSI7czoyOiIyMCI7czoyMzoibWFpbl9uYXZfdG9wX3RleHRfY29sb3IiO3M6NzoiIzQ0NDQ0NCI7czoyMzoibWFpbl9uYXZfdG9wX2hvdmVyX3NraW4iO3M6NzoiI2Y5NzM1MiI7czoyODoibWFpbl9uYXZfdG9wX2hvdmVyX3R4dF9jb2xvciI7czo3OiIjZmZmZmZmIjtzOjE5OiJtYWluX25hdl9zdWJfd2VpZ2h0IjtzOjM6IjQwMCI7czoyMjoibWFpbl9uYXZfc3ViX3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6MTc6Im1haW5fbmF2X3N1Yl9zaXplIjtzOjI6IjEyIjtzOjI3OiJtYWluX25hdl9zdWJfbGV0dGVyX3NwYWNpbmciO3M6MToiMSI7czoyMzoibWFpbl9uYXZfc3ViX3RleHRfY29sb3IiO3M6NzoiI2IzYjNiMyI7czoyOToibWFpbl9uYXZfc3ViX3RleHRfY29sb3JfaG92ZXIiO3M6NzoiI2ZmZmZmZiI7czoyNzoibWFpbl9uYXZfc3ViX2hvdmVyX2JnX2NvbG9yIjtzOjA6IiI7czoyOToibWFpbl9uYXZfc3ViX2JvcmRlcl90b3BfY29sb3IiO3M6NzoiI2Y5NzM1MiI7czoyMToibWFpbl9uYXZfc3ViX2JnX2NvbG9yIjtzOjc6IiMzMzMzMzMiO3M6MjM6Im1haW5fbmF2X3N1Yl9pY29uX2NvbG9yIjtzOjc6IiNlMGUwZTAiO3M6MTQ6Im5hdl9zdWJfc2hhZG93IjtzOjU6ImZhbHNlIjtzOjI2OiJzdWJfbGV2ZWxfYm94X2JvcmRlcl9jb2xvciI7czowOiIiO3M6MTg6Im1haW5fbmF2X3N1Yl93aWR0aCI7czozOiIyMzAiO3M6MjU6Im1haW5fbmF2X21lZ2FfdGl0bGVfY29sb3IiO3M6NzoiI2ZmZmZmZiI7czoyMzoibWVnYV9tZW51X2RpdmlkZXJfY29sb3IiO3M6MDoiIjtzOjIyOiJoZWFkZXJfc29jaWFsX2xvY2F0aW9uIjtzOjc6InRvb2xiYXIiO3M6Mjc6ImhlYWRlcl9zb2NpYWxfbmV0d29ya3Nfc2l0ZSI7czowOiIiO3M6MjY6ImhlYWRlcl9zb2NpYWxfbmV0d29ya3NfdXJsIjtzOjA6IiI7czoyODoiaGVhZGVyX3NvY2lhbF9uZXR3b3Jrc19zdHlsZSI7czo2OiJjaXJjbGUiO3M6MTY6ImhlYWRlcl9pY29uX3NpemUiO3M6NToic21hbGwiO3M6MTk6ImhlYWRlcl9zb2NpYWxfY29sb3IiO3M6NzoiIzk5OTk5OSI7czoyNToiaGVhZGVyX3NvY2lhbF9ob3Zlcl9jb2xvciI7czo3OiIjY2NjY2NjIjtzOjI3OiJoZWFkZXJfc29jaWFsX2JnX21haW5fY29sb3IiO3M6NzoiIzIzMjMyMyI7czoyMjoiaGVhZGVyX3NvY2lhbF9iZ19jb2xvciI7czo3OiIjMjMyMzIzIjtzOjI2OiJoZWFkZXJfc29jaWFsX2JvcmRlcl9jb2xvciI7czo3OiIjOTk5OTk5IjtzOjE2OiJoZWFkZXJfbW9iaWxlX2JnIjtzOjA6IiI7czoyMDoicmVzcG9uc2l2ZV9uYXZfY29sb3IiO3M6NzoiI2ZmZmZmZiI7czoyOToiaGVhZGVyX21vYmlsZV9zZWFyY2hfaW5wdXRfYmciO3M6MDoiIjtzOjMyOiJoZWFkZXJfbW9iaWxlX3NlYXJjaF9pbnB1dF9jb2xvciI7czowOiIiO3M6MjQ6InJlc3BvbnNpdmVfbmF2X3R4dF9jb2xvciI7czo3OiIjNDQ0NDQ0IjtzOjE5OiJoZWFkZXJfc3RpY2t5X3N0eWxlIjtzOjU6ImZpeGVkIjtzOjIwOiJzdGlja3lfaGVhZGVyX29mZnNldCI7czo2OiJoZWFkZXIiO3M6MjA6ImhlYWRlcl9zY3JvbGxfaGVpZ2h0IjtzOjI6IjU1IjtzOjIxOiJoZWFkZXJfc3RpY2t5X29wYWNpdHkiO3M6MToiMSI7czoyNjoic3RpY2t5X2hlYWRlcl9ib3JkZXJfY29sb3IiO3M6MDoiIjtzOjEzOiJkYXNoX2JnX2NvbG9yIjtzOjc6IiM0NDQ0NDQiO3M6MjU6ImRhc2hfdG9wX21lbnVfdGV4dF93ZWlnaHQiO3M6MzoiNjAwIjtzOjIzOiJkYXNoX3RvcF9tZW51X3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6MjM6ImRhc2hfdG9wX21lbnVfdGV4dF9zaXplIjtzOjI6IjEzIjtzOjE5OiJkYXNoX25hdl9saW5rX2NvbG9yIjtzOjc6IiNmZmZmZmYiO3M6MjU6ImRhc2hfbmF2X2xpbmtfaG92ZXJfY29sb3IiO3M6NzoiI2ZmZmZmZiI7czoyMzoiZGFzaF9uYXZfYmdfaG92ZXJfY29sb3IiO3M6MDoiIjtzOjI1OiJkYXNoX3N1Yl9tZW51X3RleHRfd2VpZ2h0IjtzOjM6IjQwMCI7czoyMzoiZGFzaF9zdWJfbWVudV90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjIzOiJkYXNoX3N1Yl9tZW51X3RleHRfc2l6ZSI7czoyOiIxMiI7czoxNzoiZGFzaF90aXRsZV93ZWlnaHQiO3M6NjoiYm9sZGVyIjtzOjIwOiJkYXNoX3RpdGxlX3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6MTU6ImRhc2hfdGl0bGVfc2l6ZSI7czoyOiIxNCI7czoxNjoiZGFzaF90aXRsZV9jb2xvciI7czo3OiIjZmZmZmZmIjtzOjE2OiJkYXNoX3RleHRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxNDoiZGFzaF90ZXh0X3NpemUiO3M6MjoiMTIiO3M6MTU6ImRhc2hfdGV4dF9jb2xvciI7czo3OiIjZWVlZWVlIjtzOjE2OiJkYXNoX2xpbmtzX2NvbG9yIjtzOjc6IiNmYWZhZmEiO3M6MjI6ImRhc2hfbGlua3NfaG92ZXJfY29sb3IiO3M6MDoiIjtzOjE5OiJmdWxsc2NyZWVuX25hdl9sb2dvIjtzOjQ6ImRhcmsiO3M6MjY6ImZ1bGxzY3JlZW5fbmF2X21vYmlsZV9sb2dvIjtzOjQ6ImRhcmsiO3M6MzM6ImZ1bGxzY3JlZW5fbmF2X21vYmlsZV9sb2dvX2N1c3RvbSI7czowOiIiO3M6MjM6ImZ1bGxzY3JlZW5fbmF2X2JnX2NvbG9yIjtzOjc6IiNmZmZmZmYiO3M6MjU6ImZ1bGxzY3JlZW5fY2xvc2VfYnRuX3NraW4iO3M6NDoiZGFyayI7czozMToiZnVsbHNjcmVlbl9uYXZfbWVudV9mb250X3dlaWdodCI7czo2OiJib2xkZXIiO3M6MzQ6ImZ1bGxzY3JlZW5fbmF2X21lbnVfdGV4dF90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjI5OiJmdWxsc2NyZWVuX25hdl9tZW51X2ZvbnRfc2l6ZSI7czoyOiIxNiI7czozNDoiZnVsbHNjcmVlbl9uYXZfbWVudV9sZXR0ZXJfc3BhY2luZyI7czoxOiIwIjtzOjI2OiJmdWxsc2NyZWVuX25hdl9tZW51X2d1dHRlciI7czoyOiIyNSI7czoyNToiZnVsbHNjcmVlbl9uYXZfbGlua19jb2xvciI7czo3OiIjMGEwYTBhIjtzOjI5OiJmdWxsc2NyZWVuX25hdl9saW5rX2hvdl9jb2xvciI7czoxODoicmdiYSg2OCw2OCw2OCwwLjUpIjtzOjMyOiJmdWxsc2NyZWVuX25hdl9saW5rX2hvdl9iZ19jb2xvciI7czo3OiIjZjRmNGY0IjtzOjE4OiJlbmFibGVfaGVhZGVyX2RhdGUiO3M6NToiZmFsc2UiO3M6MjI6ImhlYWRlcl90b29sYmFyX3RhZ2xpbmUiO3M6MDoiIjtzOjIwOiJoZWFkZXJfdG9vbGJhcl9sb2dpbiI7czo0OiJ0cnVlIjtzOjI0OiJoZWFkZXJfdG9vbGJhcl9zdWJzY3JpYmUiO3M6NToiZmFsc2UiO3M6MjA6ImhlYWRlcl90b29sYmFyX2VtYWlsIjtzOjA6IiI7czoyMDoiaGVhZGVyX3Rvb2xiYXJfcGhvbmUiO3M6MDoiIjtzOjE3OiJoZWFkZXJfdG9vbGJhcl9iZyI7czo3OiIjZmZmZmZmIjtzOjI0OiJoZWFkZXJfbW9iaWxlX3Rvb2xiYXJfYmciO3M6MDoiIjtzOjI3OiJoZWFkZXJfdG9vbGJhcl9ib3JkZXJfY29sb3IiO3M6MDoiIjtzOjMwOiJoZWFkZXJfdG9vbGJhcl9zZWFyY2hfaW5wdXRfYmciO3M6MDoiIjtzOjI0OiJoZWFkZXJfdG9vbGJhcl90eHRfY29sb3IiO3M6NzoiIzk5OTk5OSI7czoyNToiaGVhZGVyX3Rvb2xiYXJfbGlua19jb2xvciI7czo3OiIjOTk5OTk5IjtzOjMxOiJoZWFkZXJfdG9vbGJhcl9zZWFyY2hfaW5wdXRfdHh0IjtzOjc6IiNjN2M3YzciO3M6Mjc6ImhlYWRlcl9tb2JpbGVfdG9vbGJhcl9jb2xvciI7czowOiIiO3M6MzI6ImhlYWRlcl9tb2JpbGVfdG9vbGJhcl9saW5rX2NvbG9yIjtzOjA6IiI7czozNToiaGVhZGVyX3Rvb2xiYXJfc29jaWFsX25ldHdvcmtfY29sb3IiO3M6NzoiIzk5OTk5OSI7czozNDoiaGVhZGVyX21vYmlsZV90b29sYmFyX3NvY2lhbF9jb2xvciI7czowOiIiO3M6MTc6InBhZ2VfdGl0bGVfZ2xvYmFsIjtzOjQ6InRydWUiO3M6MTk6ImJhbm5lcl9ib3JkZXJfY29sb3IiO3M6NzoiI2VkZWRlZCI7czoyMToicGFnZV9pbnRyb2R1Y2Vfd2VpZ2h0IjtzOjM6IjQwMCI7czoyMDoicGFnZV90aXRsZV90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjI1OiJwYWdlX2ludHJvZHVjZV90aXRsZV9zaXplIjtzOjI6IjIwIjtzOjM1OiJwYWdlX2ludHJvZHVjZV90aXRsZV9sZXR0ZXJfc3BhY2luZyI7czoxOiIyIjtzOjE2OiJwYWdlX3RpdGxlX2NvbG9yIjtzOjc6IiM0ZDRkNGQiO3M6MTc6InBhZ2VfdGl0bGVfc2hhZG93IjtzOjU6ImZhbHNlIjtzOjI4OiJwYWdlX2ludHJvZHVjZV9zdWJ0aXRsZV9zaXplIjtzOjI6IjE0IjtzOjMzOiJwYWdlX2ludHJvZHVjZV9zdWJ0aXRsZV90cmFuc2Zvcm0iO3M6NDoibm9uZSI7czoxOToicGFnZV9zdWJ0aXRsZV9jb2xvciI7czo3OiIjYTNhM2EzIjtzOjE4OiJkaXNhYmxlX2JyZWFkY3J1bWIiO3M6NDoidHJ1ZSI7czoxNToiYnJlYWRjcnVtYl9za2luIjtzOjQ6ImRhcmsiO3M6NToiZm9udHMiO2E6Mzp7aTowO2E6Njp7czo0OiJ0eXBlIjtzOjM6ImFsbCI7czoxMDoiZm9udEZhbWlseSI7czoxMDI6IkhlbHZldGljYU5ldWUtTGlnaHQsIEhlbHZldGljYSBOZXVlIExpZ2h0LCBIZWx2ZXRpY2EgTmV1ZSwgSGVsdmV0aWNhLCBBcmlhbCwgTHVjaWRhIEdyYW5kZSwgc2Fucy1zZXJpZiI7czo4OiJlbGVtZW50cyI7YToxOntpOjA7czo0OiJib2R5Ijt9czo2OiJzdWJzZXQiO3M6MDoiIjtzOjEyOiJjdXJyZW50RmllbGQiO3M6MTA6ImZvbnQtYWxlcnQiO3M6NzoiZGVmYXVsdCI7czo0OiJ0cnVlIjt9aToxO2E6NTp7czo0OiJ0eXBlIjtzOjY6Imdvb2dsZSI7czoxMDoiZm9udEZhbWlseSI7czoxMDoiTW9udHNlcnJhdCI7czo4OiJlbGVtZW50cyI7YToxNjp7aTowO3M6MjoiaDEiO2k6MTtzOjI6ImgyIjtpOjI7czoyOiJoMyI7aTozO3M6MjoiaDQiO2k6NDtzOjI6Img1IjtpOjU7czoyOiJoNiI7aTo2O3M6MTg6IiNtay1wYWdlLWludHJvZHVjZSI7aTo3O3M6MTA6Ii50aGUtdGl0bGUiO2k6ODtzOjI3OiIubWstZWRnZS10aXRsZSwgLmVkZ2UtdGl0bGUiO2k6OTtzOjM5OiIubWFpbi1uYXZpZ2F0aW9uLXVsLCAubWstdm0tbWVudXdyYXBwZXIiO2k6MTA7czoyOToiI21rLWZvb3Rlci1uYXZpZ2F0aW9uIHVsIGxpIGEiO2k6MTE7czoxMDoiLm1rLWJ1dHRvbiI7aToxMjtzOjEwNjoiLm1rLXByaWNpbmctdGFibGUgLm1rLW9mZmVyLXRpdGxlLCAubWstcHJpY2luZy10YWJsZSAubWstcHJpY2luZy1wbGFuLCAubWstcHJpY2luZy10YWJsZSAubWstcHJpY2luZy1wcmljZSI7aToxMztzOjE0OiIubWstY3VzdG9tLWJveCI7aToxNDtzOjE2MDoiLm1rLWJsb2ctY29udGFpbmVyIC5tay1ibG9nLW1ldGEgLnRoZS10aXRsZSwgLnBvc3QgLmJsb2ctc2luZ2xlLXRpdGxlLCAubWstYmxvZy1oZXJvIC5jb250ZW50LWhvbGRlciAudGhlLXRpdGxlLCAuYmxvZy1ibG9ja3F1b3RlLWNvbnRlbnQsIC5ibG9nLXR3aXR0ZXItY29udGVudCI7aToxNTtzOjY4OiIubWstZW1wbG95ZWVzIC5tay1lbXBsb3llZS1pdGVtIC50ZWFtLWluZm8td3JhcHBlciAudGVhbS1tZW1iZXItbmFtZSI7fXM6Njoic3Vic2V0IjtzOjA6IiI7czoxMjoiY3VycmVudEZpZWxkIjtzOjIwOiJmb250LXNlbGVjdC1lbGVtZW50cyI7fWk6MjthOjU6e3M6NDoidHlwZSI7czo2OiJnb29nbGUiO3M6MTA6ImZvbnRGYW1pbHkiO3M6NDoiTGF0byI7czo4OiJlbGVtZW50cyI7YToyOntpOjA7czoxOiJwIjtpOjE7czo2OToiLm1rLWJsb2ctY29udGFpbmVyIC5tay1ibG9nLW1ldGEgLnRoZS1leGNlcnB0IHAsIC5tay1zaW5nbGUtY29udGVudCBwIjt9czo2OiJzdWJzZXQiO3M6OToibGF0aW4tZXh0IjtzOjEyOiJjdXJyZW50RmllbGQiO3M6MjA6ImZvbnQtc2VsZWN0LWVsZW1lbnRzIjt9fXM6MTQ6ImRpc2FibGVfZm9vdGVyIjtzOjQ6InRydWUiO3M6MjE6ImZvb3Rlcl9kaXNhYmxlX21vYmlsZSI7czo1OiJmYWxzZSI7czoxMjoiYm94ZWRfZm9vdGVyIjtzOjQ6InRydWUiO3M6MTE6ImZvb3Rlcl90eXBlIjtzOjE6IjEiO3M6MTQ6ImZvb3Rlcl9jb2x1bW5zIjtzOjE6IjIiO3M6MjA6ImZvb3Rlcl90b3BfdGhpY2tuZXNzIjtzOjE6IjAiO3M6MjM6ImZvb3Rlcl90b3BfYm9yZGVyX2NvbG9yIjtzOjA6IiI7czoxMzoiZm9vdGVyX2d1dHRlciI7czoxOiIyIjtzOjIyOiJmb290ZXJfd3JhcHBlcl9wYWRkaW5nIjtzOjI6IjMwIjtzOjI3OiJmb290ZXJfd2lkZ2V0X21hcmdpbl9ib3R0b20iO3M6MjoiMTAiO3M6MTk6ImZvb3Rlcl90aXRsZV93ZWlnaHQiO3M6NjoiYm9sZGVyIjtzOjIyOiJmb290ZXJfdGl0bGVfdHJhbnNmb3JtIjtzOjk6InVwcGVyY2FzZSI7czoxNzoiZm9vdGVyX3RpdGxlX3NpemUiO3M6MjoiMTQiO3M6MTg6ImZvb3Rlcl90aXRsZV9jb2xvciI7czo3OiIjZmZmZmZmIjtzOjE4OiJmb290ZXJfdGV4dF93ZWlnaHQiO3M6MzoiNDAwIjtzOjE2OiJmb290ZXJfdGV4dF9zaXplIjtzOjI6IjE0IjtzOjE3OiJmb290ZXJfdGV4dF9jb2xvciI7czo3OiIjODA4MDgwIjtzOjE4OiJmb290ZXJfbGlua3NfY29sb3IiO3M6NzoiIzk5OTk5OSI7czoyNDoiZm9vdGVyX2xpbmtzX2hvdmVyX2NvbG9yIjtzOjA6IiI7czoxODoiZGlzYWJsZV9zdWJfZm9vdGVyIjtzOjU6ImZhbHNlIjtzOjE3OiJlbmFibGVfZm9vdGVyX25hdiI7czo1OiJmYWxzZSI7czo5OiJjb3B5cmlnaHQiO3M6Mzc6IkNvcHlyaWdodCBBbGwgUmlnaHRzIFJlc2VydmVkIMKpIDIwMTUiO3M6MTk6InN1Yl9mb290ZXJfYmdfY29sb3IiO3M6NzoiIzQzNDc0ZCI7czoxNDoiY29weXJpZ2h0X3NpemUiO3M6MjoiMTEiO3M6MjQ6ImNvcHlyaWdodF9sZXR0ZXJfc3BhY2luZyI7czoxOiIxIjtzOjI1OiJzdWJfZm9vdGVyX25hdl9jb3B5X2NvbG9yIjtzOjc6IiM4YzhlOTEiO3M6MTU6ImN1c3RvbV9zaWRlYmFycyI7czowOiIiO3M6MjA6InNpZGViYXJfdGl0bGVfd2VpZ2h0IjtzOjY6ImJvbGRlciI7czoyMzoic2lkZWJhcl90aXRsZV90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjE4OiJzaWRlYmFyX3RpdGxlX3NpemUiO3M6MjoiMTQiO3M6MTk6InNpZGViYXJfdGl0bGVfY29sb3IiO3M6NzoiIzMzMzMzMyI7czoxOToic2lkZWJhcl90ZXh0X3dlaWdodCI7czozOiI0MDAiO3M6MTc6InNpZGViYXJfdGV4dF9zaXplIjtzOjI6IjE0IjtzOjE4OiJzaWRlYmFyX3RleHRfY29sb3IiO3M6NzoiIzk5OTk5OSI7czoxOToic2lkZWJhcl9saW5rc19jb2xvciI7czo3OiIjOTk5OTk5IjtzOjI1OiJzaWRlYmFyX2xpbmtzX2hvdmVyX2NvbG9yIjtzOjA6IiI7czoxODoic2VhcmNoX3BhZ2VfbGF5b3V0IjtzOjU6InJpZ2h0IjtzOjE3OiJzZWFyY2hfcGFnZV90aXRsZSI7czo2OiJTZWFyY2giO3M6MjM6InNlYXJjaF9kaXNhYmxlX3N1YnRpdGxlIjtzOjQ6InRydWUiO3M6MTM6InNpbmdsZV9sYXlvdXQiO3M6NDoiZnVsbCI7czoxNzoic2luZ2xlX2Jsb2dfc3R5bGUiO3M6NzoiY29tcGFjdCI7czoyODoic2luZ2xlX2JvbGRfaGVyb19mdWxsX2hlaWdodCI7czo0OiJ0cnVlIjtzOjI5OiJzaW5nbGVfZGlzYWJsZV9mZWF0dXJlZF9pbWFnZSI7czo0OiJ0cnVlIjtzOjIzOiJib2xkX3NpbmdsZV9oZXJvX2hlaWdodCI7czozOiI4MDAiO3M6Mjg6InNpbmdsZV9mZWF0dXJlZF9pbWFnZV9oZWlnaHQiO3M6MzoiNTAwIjtzOjIwOiJibG9nX3NpbmdsZV9pbWdfY3JvcCI7czo0OiJ0cnVlIjtzOjE3OiJibG9nX3NpbmdsZV90aXRsZSI7czo0OiJ0cnVlIjtzOjE0OiJibG9nX3ByZXZfbmV4dCI7czo0OiJ0cnVlIjtzOjI4OiJibG9nX3ByZXZfbmV4dF9zYW1lX2NhdGVnb3J5IjtzOjQ6InRydWUiO3M6Mjc6ImVuYWJsZV9zaW5nbGVfcmVsYXRlZF9wb3N0cyI7czo0OiJ0cnVlIjtzOjIwOiJibG9nX3NpbmdsZV9jb21tZW50cyI7czo0OiJ0cnVlIjtzOjE4OiJlbmFibGVfYmxvZ19hdXRob3IiO3M6NDoidHJ1ZSI7czoxODoic2luZ2xlX2Jsb2dfc29jaWFsIjtzOjQ6InRydWUiO3M6MTk6ImJsb2dfaGVhZGluZ193ZWlnaHQiO3M6MzoiNjAwIjtzOjIyOiJibG9nX2hlYWRpbmdfdHJhbnNmb3JtIjtzOjA6IiI7czoxNzoiYmxvZ19oZWFkaW5nX3NpemUiO3M6MjoiNDAiO3M6MTg6ImJsb2dfaGVhZGluZ19jb2xvciI7czowOiIiO3M6MTg6ImJsb2dfYm9keV9oMV9jb2xvciI7czowOiIiO3M6MTg6ImJsb2dfYm9keV9oMl9jb2xvciI7czowOiIiO3M6MTg6ImJsb2dfYm9keV9oM19jb2xvciI7czowOiIiO3M6MTg6ImJsb2dfYm9keV9oNF9jb2xvciI7czowOiIiO3M6MTg6ImJsb2dfYm9keV9oNV9jb2xvciI7czowOiIiO3M6MTg6ImJsb2dfYm9keV9oNl9jb2xvciI7czowOiIiO3M6MTY6ImJsb2dfYm9keV93ZWlnaHQiO3M6MzoiNDAwIjtzOjE5OiJibG9nX2JvZHlfZm9udF9zaXplIjtzOjI6IjE0IjtzOjIxOiJibG9nX2JvZHlfbGluZV9oZWlnaHQiO3M6MToiMCI7czoxNToiYmxvZ19ib2R5X2NvbG9yIjtzOjA6IiI7czoxNzoiYmxvZ19ib2R5X2FfY29sb3IiO3M6MDoiIjtzOjIzOiJibG9nX2JvZHlfYV9jb2xvcl9ob3ZlciI7czowOiIiO3M6MjY6ImJsb2dfYm9keV9zdHJvbmdfdGFnX2NvbG9yIjtzOjA6IiI7czoxOToic2luZ2xlX21ldGFfc2VjdGlvbiI7czo0OiJ0cnVlIjtzOjE4OiJkaWFibGVfc2luZ2xlX3RhZ3MiO3M6NDoidHJ1ZSI7czoxOToiYXJjaGl2ZV9wYWdlX2xheW91dCI7czo1OiJyaWdodCI7czoxODoiYXJjaGl2ZV9sb29wX3N0eWxlIjtzOjY6Im1vZGVybiI7czoxODoiYXJjaGl2ZV9wYWdlX3RpdGxlIjtzOjg6IkFyY2hpdmVzIjtzOjI0OiJhcmNoaXZlX2Rpc2FibGVfc3VidGl0bGUiO3M6NDoidHJ1ZSI7czoyNToiYXJjaGl2ZV9ibG9nX2ltYWdlX2hlaWdodCI7czozOiIzNTAiO3M6MTc6ImFyY2hpdmVfYmxvZ19tZXRhIjtzOjQ6InRydWUiO3M6MjQ6ImFyY2hpdmVfcGFnaW5hdGlvbl9zdHlsZSI7czoxOiIxIjtzOjI3OiJuZXdzX2Rpc2FibGVfZmVhdHVyZWRfaW1hZ2UiO3M6NDoidHJ1ZSI7czoyNjoibmV3c19mZWF0dXJlZF9pbWFnZV9oZWlnaHQiO3M6MzoiMzQwIjtzOjk6Im5ld3Nfc2x1ZyI7czoxMDoibmV3cy1wb3N0cyI7czoyMzoicG9ydGZvbGlvX3NpbmdsZV9sYXlvdXQiO3M6NDoiZnVsbCI7czoyOToiUG9ydGZvbGlvX3NpbmdsZV9pbWFnZV9oZWlnaHQiO3M6MzoiNTAwIjtzOjIxOiJzaW5nbGVfcG9ydGZvbGlvX2NhdHMiO3M6NToiZmFsc2UiO3M6MzA6ImVuYWJsZV9wb3J0Zm9saW9fc2ltaWxhcl9wb3N0cyI7czo0OiJ0cnVlIjtzOjE5OiJwb3J0Zm9saW9fbmV4dF9wcmV2IjtzOjQ6InRydWUiO3M6MzM6InBvcnRmb2xpb19wcmV2X25leHRfc2FtZV9jYXRlZ29yeSI7czo0OiJ0cnVlIjtzOjI0OiJlbmFibGVfcG9ydGZvbGlvX2NvbW1lbnQiO3M6NToiZmFsc2UiO3M6MjM6InNpbmdsZV9wb3J0Zm9saW9fc29jaWFsIjtzOjQ6InRydWUiO3M6MTQ6InBvcnRmb2xpb19zbHVnIjtzOjE1OiJwb3J0Zm9saW8tcG9zdHMiO3M6MTg6InBvcnRmb2xpb19jYXRfc2x1ZyI7czoxODoicG9ydGZvbGlvX2NhdGVnb3J5IjtzOjI0OiJzdGlja190ZW1wbGF0ZV9wb3J0Zm9saW8iO3M6NToiZmFsc2UiO3M6MjQ6ImFyY2hpdmVfcG9ydGZvbGlvX2xheW91dCI7czo1OiJyaWdodCI7czoyMzoiYXJjaGl2ZV9wb3J0Zm9saW9fc3R5bGUiO3M6NzoiY2xhc3NpYyI7czozMDoiYXJjaGl2ZV9wb3J0Zm9saW9faW1hZ2VfaGVpZ2h0IjtzOjM6IjQwMCI7czoyNDoiYXJjaGl2ZV9wb3J0Zm9saW9fY29sdW1uIjtzOjE6IjMiO3M6MzQ6ImFyY2hpdmVfcG9ydGZvbGlvX3BhZ2luYXRpb25fc3R5bGUiO3M6MToiMSI7czoxNToic2hvcF9jdXN0b21pemVyIjtzOjU6ImZhbHNlIjtzOjIwOiJzaG9wX2FyY2hpdmVfY29sdW1ucyI7czo3OiJkZWZhdWx0IjtzOjE5OiJ3b29jb21tZXJjZV9jYXRhbG9nIjtzOjU6ImZhbHNlIjtzOjIzOiJ3b29fY2F0ZWdvcnlfaW1hZ2Vfc2l6ZSI7czo0OiJjcm9wIjtzOjMxOiJ3b29jb21tZXJjZV9jYXRlZ29yeV9wYWdlX3RpdGxlIjtzOjQ6IlNob3AiO3M6Mjk6Indvb2NvbW1lcmNlX3VzZV9wcm9kdWN0X3RpdGxlIjtzOjU6ImZhbHNlIjtzOjMwOiJ3b29jb21tZXJjZV91c2VfY2F0ZWdvcnlfdGl0bGUiO3M6NToiZmFsc2UiO3M6Mzc6Indvb2NvbW1lcmNlX3VzZV9jYXRlZ29yeV9maWx0ZXJfdGl0bGUiO3M6NToiZmFsc2UiO3M6MTM6InNob3BwaW5nX2NhcnQiO3M6NDoidHJ1ZSI7czoxOToiYWRkX2NhcnRfcmVzcG9uc2l2ZSI7czo0OiJ0cnVlIjtzOjE5OiJ3b29fbG9vcF9pbWFnZV9zaXplIjtzOjQ6ImNyb3AiO3M6MTk6Indvb19sb29wX2ltZ19oZWlnaHQiO3M6MzoiMzAwIjtzOjI2OiJ3b29jb21tZXJjZV9sb29wX3Nob3dfZGVzYyI7czo1OiJmYWxzZSI7czozNToid29vY29tbWVyY2VfbG9vcF9lbmFibGVfbG92ZV9idXR0b24iO3M6NDoidHJ1ZSI7czoyNToid29vY29tbWVyY2Vfc2luZ2xlX2xheW91dCI7czo0OiJmdWxsIjtzOjMyOiJ3b29jb21tZXJjZV9zaW5nbGVfcHJvZHVjdF90aXRsZSI7czo0OiJ0cnVlIjtzOjIwOiJ3b29fc2luZ2xlX3ByZXZfbmV4dCI7czo0OiJ0cnVlIjtzOjI3OiJ3b29fcHJldl9uZXh0X3NhbWVfY2F0ZWdvcnkiO3M6NDoidHJ1ZSI7czozMzoid29vY29tbWVyY2Vfc2luZ2xlX3NvY2lhbF9uZXR3b3JrIjtzOjQ6InRydWUiO3M6OToibWluaWZ5LWpzIjtzOjQ6InRydWUiO3M6MTA6Im1pbmlmeS1jc3MiO3M6NDoidHJ1ZSI7czoyNToibW92ZS1zaG9ydGNvZGUtY3NzLWZvb3RlciI7czo0OiJ0cnVlIjtzOjE3OiJyZW1vdmUtanMtY3NzLXZlciI7czo0OiJ0cnVlIjtzOjE1OiJnbG9iYWxfbGF6eWxvYWQiO3M6NDoidHJ1ZSI7czoxOToicG9ydGZvbGlvLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjE0OiJuZXdzLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjEzOiJmYXEtcG9zdC10eXBlIjtzOjQ6InRydWUiO3M6MjE6InBob3RvX2FsYnVtLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjE3OiJwcmljaW5nLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjE3OiJjbGllbnRzLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjE5OiJlbXBsb3llZXMtcG9zdC10eXBlIjtzOjQ6InRydWUiO3M6MjE6InRlc3RpbW9uaWFsLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjI2OiJhbmltYXRlZC1jb2x1bW5zLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjE0OiJlZGdlLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjIwOiJ0YWJfc2xpZGVyLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjE5OiJzbGlkZXNob3ctcG9zdC10eXBlIjtzOjU6ImZhbHNlIjtzOjI0OiJiYW5uZXJfYnVpbGRlci1wb3N0LXR5cGUiO3M6NToiZmFsc2UiO3M6MTA6ImN1c3RvbV9jc3MiO3M6MzE1MToiLmN1c3RvbS1qdWV2ZXMtZ3JhZGllbnQtYmcgLm1rLXZpZGVvLWNvbG9yLW1hc2sgew0KYmFja2dyb3VuZC1jb2xvcjogdHJhbnNwYXJlbnQhaW1wb3J0YW50Ow0KfQ0KDQouY3VzdG9tLWp1ZXZlcy1ncmFkaWVudC1iZyAubWstYW5pbWF0ZS1lbGVtZW50IHsNCi13ZWJraXQtYW5pbWF0aW9uLWR1cmF0aW9uOiAycyFpbXBvcnRhbnQ7DQphbmltYXRpb24tZHVyYXRpb246IDJzIWltcG9ydGFudDsNCn0NCg0KLmN1c3RvbS1jb250YWN0LXBhZCB7DQpwYWRkaW5nLWxlZnQ6OTBweDsNCn0NCg0KLmN1c3RvbS1qdWV2ZXMtaGVhZGluZyBlbSB7DQpmb250LXN0eWxlOiBub3JtYWw7DQp0ZXh0LWRlY29yYXRpb246IGxpbmUtdGhyb3VnaDsNCmNvbG9yOiAjQkFCQUJBOw0KZm9udC13ZWlnaHQ6IDMwMDsNCn0NCg0KLmN1c3RvbS1qdWV2ZXMtaWNvbi1ib3ggew0KcGFkZGluZzogODVweCAzNXB4Ow0KLW1vei1ib3gtc2hhZG93OiAwcHggMHB4IDE1cHggcmdiYSgwLCAwLCAwLCAwLjA5KTsNCi13ZWJraXQtYm94LXNoYWRvdzogMHB4IDBweCAxNXB4IHJnYmEoMCwgMCwgMCwgMC4wOSk7DQpib3gtc2hhZG93OiAwcHggMHB4IDE1cHggcmdiYSgwLCAwLCAwLCAwLjA5KTsNCmJvcmRlci1yYWRpdXM6IDRweDsNCnRyYW5zaXRpb246QWxsIDAuNHMgZWFzZTsNCi13ZWJraXQtdHJhbnNpdGlvbjpBbGwgMC40cyBlYXNlOw0KLW1vei10cmFuc2l0aW9uOkFsbCAwLjRzIGVhc2U7DQotby10cmFuc2l0aW9uOkFsbCAwLjRzIGVhc2U7DQp9DQoNCi5jdXN0b20tanVldmVzLWljb24tYm94OmhvdmVyIHsNCi1tb3otYm94LXNoYWRvdzogMHB4IDBweCAyOXB4IHJnYmEoMCwgMCwgMCwgMC4yNCk7DQotd2Via2l0LWJveC1zaGFkb3c6IDBweCAwcHggMjlweCByZ2JhKDAsIDAsIDAsIDAuMjQpOw0KYm94LXNoYWRvdzogMHB4IDBweCAyOXB4IHJnYmEoMCwgMCwgMCwgMC4yNCk7DQp0cmFuc2l0aW9uOkFsbCAwLjRzIGVhc2U7DQotd2Via2l0LXRyYW5zaXRpb246QWxsIDAuNHMgZWFzZTsNCi1tb3otdHJhbnNpdGlvbjpBbGwgMC40cyBlYXNlOw0KLW8tdHJhbnNpdGlvbjpBbGwgMC40cyBlYXNlOw0KfQ0KDQouY3VzdG9tLWp1ZXZlcy1pY29uLWJveCAubWstYm94LWljb24tMi1jb250ZW50IHsNCmZvbnQtc2l6ZTogMTRweDsNCn0NCg0KLmN1c3RvbS1qdWV2ZXMtYnRuIGF7DQpwYWRkaW5nLWxlZnQ6MDsNCmxldHRlci1zcGFjaW5nOiA1cHg7DQp9DQoNCi53aWRnZXRfbmF2X21lbnUgdWwgbGl7DQpkaXNwbGF5OiBpbmxpbmUtYmxvY2s7DQpmbG9hdDogbGVmdDsNCm1hcmdpbi1sZWZ0OiAzMHB4Ow0KZm9udC1mYW1pbHk6ICJNb250c2VycmF0IjsNCmxldHRlci1zcGFjaW5nOiAycHg7DQp0ZXh0LXRyYW5zZm9ybTogdXBwZXJjYXNlOw0KZm9udC1zaXplOiAxMnB4Ow0KfQ0KDQoud2lkZ2V0X25hdl9tZW51IHVsIGxpIHN2ZyB7DQpkaXNwbGF5OiBub25lOw0KfQ0KDQoud2lkZ2V0X3NvY2lhbF9uZXR3b3JrcyBhLnNtYWxsIGkgew0KZm9udC1zaXplOiAxMnB4Ow0KfQ0KDQoubWstdGFicyAubWstdGFicy10YWJzIGxpOmZpcnN0LWNoaWxkIGF7DQpwYWRkaW5nLWxlZnQ6MCFpbXBvcnRhbnQ7DQp9DQoNCi5tay10YWJzIC5tay10YWJzLXRhYnMgbGkgYSB7DQpjb2xvcjogI2NjYyFpbXBvcnRhbnQ7DQpmb250LXNpemU6IDE1cHghaW1wb3J0YW50Ow0KfQ0KDQoubWstdGFicyAubWstdGFicy10YWJzIGxpLmlzLWFjdGl2ZSBhIHsNCmNvbG9yOiAjMDAwIWltcG9ydGFudDsNCn0NCg0KLm5ldy1zdHlsZS5wcmljaW5nLXRhYmxlIC5wcmljaW5nLWNvbHMgLnByaWNpbmctaGVhZGluZyB7DQpmb250LWZhbWlseTogIk1vbnRzZXJyYXQiOw0KfQ0KDQoubmV3LXN0eWxlLnByaWNpbmctdGFibGUgLnByaWNpbmctY29scyAucHJpY2luZy1wbGFuIHsNCmxldHRlci1zcGFjaW5nOiA0cHg7DQp9DQoNCi5uZXctc3R5bGUucHJpY2luZy10YWJsZSAucHJpY2luZy1jb2xzIC5wcmljaW5nLXByaWNlew0KaGVpZ2h0OiAxMTVweCFpbXBvcnRhbnQ7DQp9DQoNCi5mdWxsIHNwYW4gaW5wdXQsDQouZnVsbCBzcGFuIHRleHRhcmVhIHsNCndpZHRoOiAxMDAlIWltcG9ydGFudDsNCn0NCg0KLndwY2Y3LWZvcm0tY29udHJvbCB7DQpiYWNrZ3JvdW5kLWNvbG9yOiAjZmZmOw0KYm9yZGVyLXJhZGl1czogNHB4Ow0KbWluLWhlaWdodDogNTBweDsNCnBhZGRpbmctbGVmdDogMjVweCFpbXBvcnRhbnQ7DQp9DQoNCi5kb3VibGUgc3BhbiBpbnB1dCB7DQp3aWR0aDogNDklOw0KfQ0KDQouZG91YmxlIHNwYW46Zmlyc3QtY2hpbGQgaW5wdXQgew0KbWFyZ2luLXJpZ2h0OiAxJTsNCn0NCg0KLmRvdWJsZSBzcGFuOmxhc3QtY2hpbGQgaW5wdXQgew0KZmxvYXQ6IHJpZ2h0Ow0KfQ0KDQoud3BjZjctc3VibWl0ew0Kd2lkdGg6IDEwMCU7DQpkaXNwbGF5OiBibG9jazsNCnBhZGRpbmc6IDEzcHggNTBweCFpbXBvcnRhbnQ7DQp9DQoNCi53aWRnZXRfbmF2X21lbnUgdWwgbGk6Zmlyc3QtY2hpbGQgew0KbWFyZ2luLWxlZnQ6IDA7DQp9DQoNCi53aWRnZXRfbmF2X21lbnUgdWwgbGk6bGFzdC1jaGlsZHsNCm1hcmdpbi1yaWdodDogMDsNCn0NCg0KLmZvb3Rlci13cmFwcGVyIC5tay1jb2wtMS0yIHsNCndpZHRoOiA2MCU7DQp9DQoNCi5mb290ZXItd3JhcHBlciAubWstY29sLTEtMjpmaXJzdC1jaGlsZCB7DQp3aWR0aDogNDAlOw0KfQ0KDQoud2lkZ2V0X25hdl9tZW51IHVsIHsNCmZsb2F0OiByaWdodDsNCn0NCg0KQG1lZGlhIGhhbmRoZWxkLCBvbmx5IHNjcmVlbiBhbmQgKG1heC13aWR0aDogODYwcHgpIHsNCi53aWRnZXRfbmF2X21lbnUgdWwgew0KdGV4dC1hbGlnbjogY2VudGVyOw0KZmxvYXQ6IG5vbmUhaW1wb3J0YW50Ow0KZGlzcGxheTogaW5saW5lLWJsb2NrOw0KfQ0KDQouZm9vdGVyLXdyYXBwZXIgLm1rLWNvbC0xLTIgew0Kd2lkdGg6IDEwMCUhaW1wb3J0YW50Ow0KfQ0KDQouZm9vdGVyLXdyYXBwZXIgLm1rLWNvbC0xLTIsDQoud2lkZ2V0X3NvY2lhbF9uZXR3b3JrcyAuYWxpZ24tbGVmdCB7DQp0ZXh0LWFsaWduOiBjZW50ZXI7DQp9DQoNCi53aWRnZXRfbmF2X21lbnUgdWwgbGkgew0KICAgIGRpc3BsYXk6IGJsb2NrOw0KICAgIGZsb2F0OiBub25lOw0KICAgIG1hcmdpbi1sZWZ0OiAwOw0KfQ0KDQouY3VzdG9tLWNvbnRhY3QtcGFkIHsNCnBhZGRpbmc6MCFpbXBvcnRhbnQ7DQp9DQp9DQoNCiI7czo5OiJjdXN0b21fanMiO3M6MDoiIjtzOjIwOiJ0aGVtZV9pbXBvcnRfb3B0aW9ucyI7czowOiIiO3M6MjA6Im1haWxjaGltcF9hY3Rpb25fdXJsIjtzOjA6IiI7czoxODoidGhlbWVfaGVhZGVyX2FsaWduIjtzOjQ6ImxlZnQiO3M6MjA6InRoZW1lX3Rvb2xiYXJfdG9nZ2xlIjtzOjU6ImZhbHNlIjtzOjg6InNpZGViYXJzIjtzOjA6IiI7czoyNjoicmVzcG9uc2l2ZV9pY29uX3RleHRfY29sb3IiO3M6MDoiIjtzOjExOiJmb250X2ZhbWlseSI7czoxMDI6IkhlbHZldGljYU5ldWUtTGlnaHQsIEhlbHZldGljYSBOZXVlIExpZ2h0LCBIZWx2ZXRpY2EgTmV1ZSwgSGVsdmV0aWNhLCBBcmlhbCwgTHVjaWRhIEdyYW5kZSwgc2Fucy1zZXJpZiI7czoyMDoic3BlY2lhbF9mb250c19saXN0XzEiO3M6MTA6Ik1vbnRzZXJyYXQiO3M6MjA6InNwZWNpYWxfZm9udHNfdHlwZV8xIjtzOjY6Imdvb2dsZSI7czoyMDoiZ29vZ2xlX2ZvbnRfc3Vic2V0XzEiO3M6MDoiIjtzOjE4OiJzcGVjaWFsX2VsZW1lbnRzXzEiO2E6MTY6e2k6MDtzOjI6ImgxIjtpOjE7czoyOiJoMiI7aToyO3M6MjoiaDMiO2k6MztzOjI6Img0IjtpOjQ7czoyOiJoNSI7aTo1O3M6MjoiaDYiO2k6NjtzOjE4OiIjbWstcGFnZS1pbnRyb2R1Y2UiO2k6NztzOjEwOiIudGhlLXRpdGxlIjtpOjg7czoyNzoiLm1rLWVkZ2UtdGl0bGUsIC5lZGdlLXRpdGxlIjtpOjk7czozOToiLm1haW4tbmF2aWdhdGlvbi11bCwgLm1rLXZtLW1lbnV3cmFwcGVyIjtpOjEwO3M6Mjk6IiNtay1mb290ZXItbmF2aWdhdGlvbiB1bCBsaSBhIjtpOjExO3M6MTA6Ii5tay1idXR0b24iO2k6MTI7czoxMDY6Ii5tay1wcmljaW5nLXRhYmxlIC5tay1vZmZlci10aXRsZSwgLm1rLXByaWNpbmctdGFibGUgLm1rLXByaWNpbmctcGxhbiwgLm1rLXByaWNpbmctdGFibGUgLm1rLXByaWNpbmctcHJpY2UiO2k6MTM7czoxNDoiLm1rLWN1c3RvbS1ib3giO2k6MTQ7czoxNjA6Ii5tay1ibG9nLWNvbnRhaW5lciAubWstYmxvZy1tZXRhIC50aGUtdGl0bGUsIC5wb3N0IC5ibG9nLXNpbmdsZS10aXRsZSwgLm1rLWJsb2ctaGVybyAuY29udGVudC1ob2xkZXIgLnRoZS10aXRsZSwgLmJsb2ctYmxvY2txdW90ZS1jb250ZW50LCAuYmxvZy10d2l0dGVyLWNvbnRlbnQiO2k6MTU7czo2ODoiLm1rLWVtcGxveWVlcyAubWstZW1wbG95ZWUtaXRlbSAudGVhbS1pbmZvLXdyYXBwZXIgLnRlYW0tbWVtYmVyLW5hbWUiO31zOjIwOiJzcGVjaWFsX2ZvbnRzX2xpc3RfMiI7czo0OiJMYXRvIjtzOjIwOiJzcGVjaWFsX2ZvbnRzX3R5cGVfMiI7czo2OiJnb29nbGUiO3M6MjA6Imdvb2dsZV9mb250X3N1YnNldF8yIjtzOjk6ImxhdGluLWV4dCI7czoxODoic3BlY2lhbF9lbGVtZW50c18yIjthOjI6e2k6MDtzOjE6InAiO2k6MTtzOjY5OiIubWstYmxvZy1jb250YWluZXIgLm1rLWJsb2ctbWV0YSAudGhlLWV4Y2VycHQgcCwgLm1rLXNpbmdsZS1jb250ZW50IHAiO31zOjIxOiJ0eXBla2l0X2ZvbnRfZmFtaWx5XzEiO3M6MDoiIjtzOjIxOiJ0eXBla2l0X2ZvbnRfZmFtaWx5XzIiO3M6MDoiIjtzOjIyOiJwYWdlc3BlZWQtb3B0aW1pemF0aW9uIjtzOjU6ImZhbHNlIjtzOjI4OiJwYWdlc3BlZWQtZGVmZXItb3B0aW1pemF0aW9uIjtzOjU6ImZhbHNlIjtzOjE0OiJkeW5hbWljLWFzc2V0cyI7czo0OiJ0cnVlIjtzOjIzOiJyZXNwb25zaXZlX2J1cmdlcl9hbGlnbiI7czo1OiJyaWdodCI7czoyNjoiaGVhZGVyX3NvY2lhbF9zaXRlc19zZWxlY3QiO3M6MDoiIjtzOjE3OiJoZWFkZXJfc29jaWFsX3VybCI7czowOiIiO3M6NToiYWxwaGEiO3M6MzoiMTAwIjtzOjExOiJhZGRfc2lkZWJhciI7czowOiIiO3M6MTY6ImJnX3BhbmVsX3N0cmV0Y2giO3M6NToiZmFsc2UiO3M6MTY6Il93cF9odHRwX3JlZmVyZXIiO3M6NTQ6Ii9qdXBpdGVyNS9qdWV2ZXMvd3AtYWRtaW4vYWRtaW4ucGhwP3BhZ2U9dGhlbWVfb3B0aW9ucyI7czoxNDoiYnV0dG9uX2NsaWNrZWQiO3M6MjI6InNhdmVfdGhlbWVfb3B0aW9uc190b3AiO30=","yes");
INSERT INTO wpcf_options VALUES("279","Jupiter_options_backup","a:447:{s:10:\"skin_color\";s:7:\"#f97352\";s:12:\"smoothscroll\";s:4:\"true\";s:14:\"pages_comments\";s:5:\"false\";s:9:\"go_to_top\";s:4:\"true\";s:13:\"retina_images\";s:4:\"true\";s:17:\"responsive_images\";s:4:\"true\";s:20:\"image_resize_quality\";s:3:\"100\";s:11:\"svg_support\";s:5:\"false\";s:26:\"fullscreen_nav_logo_margin\";s:3:\"125\";s:4:\"logo\";s:0:\"\";s:17:\"light_header_logo\";s:0:\"\";s:18:\"sticky_header_logo\";s:0:\"\";s:15:\"responsive_logo\";s:0:\"\";s:11:\"footer_logo\";s:0:\"\";s:14:\"custom_favicon\";s:0:\"\";s:11:\"iphone_icon\";s:0:\"\";s:18:\"iphone_icon_retina\";s:0:\"\";s:9:\"ipad_icon\";s:0:\"\";s:16:\"ipad_icon_retina\";s:0:\"\";s:9:\"preloader\";s:5:\"false\";s:16:\"retina_preloader\";s:5:\"false\";s:14:\"preloader_logo\";s:0:\"\";s:20:\"preloader_icon_color\";s:7:\"#7c7c7c\";s:18:\"preloader_bg_color\";s:4:\"#fff\";s:23:\"section_preloader_color\";s:4:\"#fff\";s:19:\"preloader_animation\";s:10:\"ball_pulse\";s:21:\"disable_quick_contact\";s:4:\"true\";s:23:\"quick_contact_on_single\";s:4:\"true\";s:21:\"captcha_quick_contact\";s:4:\"true\";s:19:\"quick_contact_email\";s:39:\"admin@thelighthousefoundation.didone.nl\";s:19:\"quick_contact_title\";s:10:\"Contact Us\";s:18:\"quick_contact_desc\";s:89:\"We\'re not around right now. But you can send us an email and we\'ll get back to you, asap.\";s:26:\"quick_contact_gdpr_consent\";s:4:\"true\";s:31:\"quick_contact_gdpr_consent_text\";s:79:\"I consent to The Lighthouse Foundation collecting my details through this form.\";s:20:\"twitter_consumer_key\";s:0:\"\";s:23:\"twitter_consumer_secret\";s:0:\"\";s:20:\"twitter_access_token\";s:0:\"\";s:27:\"twitter_access_token_secret\";s:0:\"\";s:17:\"mailchimp_api_key\";s:0:\"\";s:17:\"mailchimp_list_id\";s:0:\"\";s:15:\"mailchimp_optin\";s:5:\"false\";s:19:\"google_maps_api_key\";s:0:\"\";s:9:\"analytics\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:16:\"third_party_gdpr\";s:5:\"false\";s:31:\"background_selector_orientation\";s:17:\"full_width_layout\";s:10:\"grid_width\";s:4:\"1140\";s:13:\"content_width\";s:2:\"73\";s:18:\"content_responsive\";s:3:\"960\";s:20:\"responsive_nav_width\";s:4:\"1140\";s:19:\"stick_template_page\";s:5:\"false\";s:11:\"body_border\";s:5:\"false\";s:21:\"body_border_thickness\";s:2:\"50\";s:17:\"body_border_color\";s:4:\"#fff\";s:29:\"body_border_on_mobile_devices\";s:5:\"false\";s:24:\"page_title_expand_header\";s:5:\"false\";s:24:\"boxed_layout_shadow_size\";s:1:\"0\";s:29:\"boxed_layout_shadow_intensity\";s:1:\"0\";s:18:\"general_backgounds\";s:5:\"false\";s:20:\"bg_panel_image_style\";s:0:\"\";s:15:\"bg_panel_upload\";s:0:\"\";s:20:\"bg_panel_color_style\";s:0:\"\";s:14:\"bg_panel_color\";s:0:\"\";s:16:\"bg_panel_color_2\";s:0:\"\";s:21:\"grandient_color_style\";s:0:\"\";s:21:\"grandient_color_angle\";s:0:\"\";s:15:\"bg_panel_repeat\";s:0:\"\";s:19:\"bg_panel_attachment\";s:0:\"\";s:17:\"bg_panel_position\";s:0:\"\";s:13:\"bg_panel_size\";s:0:\"\";s:10:\"body_color\";s:4:\"#fff\";s:19:\"body_color_gradient\";s:6:\"single\";s:12:\"body_color_2\";s:0:\"\";s:25:\"body_color_gradient_style\";s:6:\"linear\";s:25:\"body_color_gradient_angle\";s:8:\"vertical\";s:10:\"body_image\";s:0:\"\";s:9:\"body_size\";s:5:\"false\";s:13:\"body_position\";s:0:\"\";s:15:\"body_attachment\";s:0:\"\";s:11:\"body_repeat\";s:0:\"\";s:11:\"body_source\";s:8:\"no-image\";s:10:\"page_color\";s:4:\"#fff\";s:19:\"page_color_gradient\";s:6:\"single\";s:12:\"page_color_2\";s:0:\"\";s:25:\"page_color_gradient_style\";s:6:\"linear\";s:25:\"page_color_gradient_angle\";s:8:\"vertical\";s:10:\"page_image\";s:0:\"\";s:9:\"page_size\";s:5:\"false\";s:13:\"page_position\";s:0:\"\";s:15:\"page_attachment\";s:0:\"\";s:11:\"page_repeat\";s:0:\"\";s:11:\"page_source\";s:8:\"no-image\";s:12:\"header_color\";s:4:\"#fff\";s:21:\"header_color_gradient\";s:6:\"single\";s:14:\"header_color_2\";s:0:\"\";s:27:\"header_color_gradient_style\";s:6:\"linear\";s:27:\"header_color_gradient_angle\";s:8:\"vertical\";s:12:\"header_image\";s:0:\"\";s:11:\"header_size\";s:5:\"false\";s:15:\"header_position\";s:0:\"\";s:17:\"header_attachment\";s:0:\"\";s:13:\"header_repeat\";s:0:\"\";s:13:\"header_source\";s:8:\"no-image\";s:12:\"banner_color\";s:7:\"#f7f7f7\";s:21:\"banner_color_gradient\";s:6:\"single\";s:14:\"banner_color_2\";s:0:\"\";s:27:\"banner_color_gradient_style\";s:6:\"linear\";s:27:\"banner_color_gradient_angle\";s:8:\"vertical\";s:12:\"banner_image\";s:0:\"\";s:11:\"banner_size\";s:4:\"true\";s:15:\"banner_position\";s:0:\"\";s:17:\"banner_attachment\";s:0:\"\";s:13:\"banner_repeat\";s:0:\"\";s:13:\"banner_source\";s:8:\"no-image\";s:12:\"footer_color\";s:7:\"#3d4045\";s:21:\"footer_color_gradient\";s:6:\"single\";s:14:\"footer_color_2\";s:0:\"\";s:27:\"footer_color_gradient_style\";s:6:\"linear\";s:27:\"footer_color_gradient_angle\";s:8:\"vertical\";s:12:\"footer_image\";s:0:\"\";s:11:\"footer_size\";s:5:\"false\";s:15:\"footer_position\";s:0:\"\";s:17:\"footer_attachment\";s:0:\"\";s:13:\"footer_repeat\";s:0:\"\";s:13:\"footer_source\";s:8:\"no-image\";s:11:\"body_weight\";s:3:\"400\";s:14:\"body_font_size\";s:2:\"14\";s:16:\"body_line_height\";s:4:\"1.66\";s:15:\"body_text_color\";s:7:\"#777777\";s:7:\"a_color\";s:7:\"#2e2e2e\";s:13:\"a_color_hover\";s:7:\"#f97352\";s:12:\"strong_color\";s:7:\"#f97352\";s:6:\"p_size\";s:2:\"16\";s:13:\"p_line_height\";s:4:\"1.66\";s:7:\"p_color\";s:7:\"#777777\";s:20:\"headings_line_height\";s:3:\"1.3\";s:9:\"h1_weight\";s:3:\"600\";s:12:\"h1_transform\";s:9:\"uppercase\";s:7:\"h1_size\";s:2:\"36\";s:8:\"h1_color\";s:7:\"#404040\";s:9:\"h2_weight\";s:3:\"600\";s:12:\"h2_transform\";s:9:\"uppercase\";s:7:\"h2_size\";s:2:\"30\";s:8:\"h2_color\";s:7:\"#404040\";s:9:\"h3_weight\";s:3:\"600\";s:12:\"h3_transform\";s:9:\"uppercase\";s:7:\"h3_size\";s:2:\"24\";s:8:\"h3_color\";s:7:\"#404040\";s:9:\"h4_weight\";s:3:\"600\";s:12:\"h4_transform\";s:9:\"uppercase\";s:7:\"h4_size\";s:2:\"18\";s:8:\"h4_color\";s:7:\"#404040\";s:9:\"h5_weight\";s:3:\"600\";s:12:\"h5_transform\";s:9:\"uppercase\";s:7:\"h5_size\";s:2:\"16\";s:8:\"h5_color\";s:7:\"#404040\";s:9:\"h6_weight\";s:3:\"600\";s:12:\"h6_transform\";s:9:\"uppercase\";s:7:\"h6_size\";s:2:\"14\";s:8:\"h6_color\";s:7:\"#404040\";s:21:\"header_layout_builder\";s:16:\"pre_built_header\";s:18:\"theme_header_style\";s:1:\"1\";s:14:\"secondary_menu\";s:10:\"fullscreen\";s:18:\"header_burger_size\";s:5:\"small\";s:23:\"seondary_header_for_all\";s:5:\"false\";s:18:\"vertical_menu_anim\";s:1:\"1\";s:26:\"vertical_header_logo_align\";s:6:\"center\";s:28:\"vertical_header_logo_padding\";s:2:\"10\";s:21:\"vertical_header_align\";s:4:\"left\";s:23:\"vertical_menu_copyright\";s:41:\"Copyright All Rights Reserved &copy; 2017\";s:11:\"header_grid\";s:4:\"true\";s:16:\"hide_header_logo\";s:4:\"true\";s:14:\"logo_in_middle\";s:5:\"false\";s:15:\"hide_header_nav\";s:4:\"true\";s:22:\"header_search_location\";s:17:\"fullscreen_search\";s:22:\"header_start_tour_text\";s:0:\"\";s:22:\"header_start_tour_page\";s:0:\"\";s:15:\"start_tour_size\";s:2:\"14\";s:13:\"loggedin_menu\";s:11:\"fourth-menu\";s:13:\"header_height\";s:2:\"90\";s:17:\"res_header_height\";s:2:\"90\";s:14:\"header_opacity\";s:1:\"1\";s:27:\"header_btn_border_thickness\";s:1:\"1\";s:19:\"header_border_color\";s:7:\"#ededed\";s:16:\"start_tour_color\";s:4:\"#333\";s:19:\"header_burger_color\";s:0:\"\";s:17:\"main_nav_bg_color\";s:0:\"\";s:14:\"main_nav_hover\";s:1:\"1\";s:19:\"main_nav_top_weight\";s:3:\"600\";s:19:\"main_menu_transform\";s:9:\"uppercase\";s:17:\"main_nav_top_size\";s:2:\"13\";s:27:\"main_nav_top_letter_spacing\";s:1:\"0\";s:19:\"main_nav_item_space\";s:2:\"20\";s:23:\"main_nav_top_text_color\";s:7:\"#444444\";s:23:\"main_nav_top_hover_skin\";s:7:\"#f97352\";s:28:\"main_nav_top_hover_txt_color\";s:4:\"#fff\";s:19:\"main_nav_sub_weight\";s:3:\"400\";s:22:\"main_nav_sub_transform\";s:9:\"uppercase\";s:17:\"main_nav_sub_size\";s:2:\"12\";s:27:\"main_nav_sub_letter_spacing\";s:1:\"1\";s:23:\"main_nav_sub_text_color\";s:7:\"#b3b3b3\";s:29:\"main_nav_sub_text_color_hover\";s:7:\"#ffffff\";s:27:\"main_nav_sub_hover_bg_color\";s:0:\"\";s:29:\"main_nav_sub_border_top_color\";s:7:\"#f97352\";s:21:\"main_nav_sub_bg_color\";s:7:\"#333333\";s:23:\"main_nav_sub_icon_color\";s:7:\"#e0e0e0\";s:14:\"nav_sub_shadow\";s:5:\"false\";s:26:\"sub_level_box_border_color\";s:0:\"\";s:18:\"main_nav_sub_width\";s:3:\"230\";s:25:\"main_nav_mega_title_color\";s:7:\"#ffffff\";s:23:\"mega_menu_divider_color\";s:0:\"\";s:22:\"header_social_location\";s:0:\"\";s:27:\"header_social_networks_site\";s:0:\"\";s:26:\"header_social_networks_url\";s:0:\"\";s:28:\"header_social_networks_style\";s:6:\"circle\";s:16:\"header_icon_size\";s:5:\"small\";s:19:\"header_social_color\";s:7:\"#999999\";s:25:\"header_social_hover_color\";s:4:\"#ccc\";s:27:\"header_social_bg_main_color\";s:7:\"#232323\";s:22:\"header_social_bg_color\";s:7:\"#232323\";s:26:\"header_social_border_color\";s:7:\"#999999\";s:16:\"header_mobile_bg\";s:0:\"\";s:20:\"responsive_nav_color\";s:4:\"#fff\";s:29:\"header_mobile_search_input_bg\";s:0:\"\";s:32:\"header_mobile_search_input_color\";s:0:\"\";s:24:\"responsive_nav_txt_color\";s:7:\"#444444\";s:19:\"header_sticky_style\";s:5:\"fixed\";s:20:\"sticky_header_offset\";s:6:\"header\";s:20:\"header_scroll_height\";s:2:\"55\";s:21:\"header_sticky_opacity\";s:1:\"1\";s:26:\"sticky_header_border_color\";s:0:\"\";s:13:\"dash_bg_color\";s:4:\"#444\";s:25:\"dash_top_menu_text_weight\";s:3:\"600\";s:23:\"dash_top_menu_transform\";s:9:\"uppercase\";s:23:\"dash_top_menu_text_size\";s:2:\"13\";s:19:\"dash_nav_link_color\";s:4:\"#fff\";s:25:\"dash_nav_link_hover_color\";s:4:\"#fff\";s:23:\"dash_nav_bg_hover_color\";s:0:\"\";s:25:\"dash_sub_menu_text_weight\";s:3:\"400\";s:23:\"dash_sub_menu_transform\";s:9:\"uppercase\";s:23:\"dash_sub_menu_text_size\";s:2:\"12\";s:17:\"dash_title_weight\";s:6:\"bolder\";s:20:\"dash_title_transform\";s:9:\"uppercase\";s:15:\"dash_title_size\";s:2:\"14\";s:16:\"dash_title_color\";s:4:\"#fff\";s:16:\"dash_text_weight\";s:3:\"400\";s:14:\"dash_text_size\";s:2:\"12\";s:15:\"dash_text_color\";s:4:\"#eee\";s:16:\"dash_links_color\";s:7:\"#fafafa\";s:22:\"dash_links_hover_color\";s:0:\"\";s:19:\"fullscreen_nav_logo\";s:4:\"dark\";s:26:\"fullscreen_nav_mobile_logo\";s:4:\"dark\";s:33:\"fullscreen_nav_mobile_logo_custom\";s:0:\"\";s:23:\"fullscreen_nav_bg_color\";s:4:\"#444\";s:25:\"fullscreen_close_btn_skin\";s:5:\"light\";s:31:\"fullscreen_nav_menu_font_weight\";s:6:\"bolder\";s:34:\"fullscreen_nav_menu_text_transform\";s:9:\"uppercase\";s:29:\"fullscreen_nav_menu_font_size\";s:2:\"16\";s:34:\"fullscreen_nav_menu_letter_spacing\";s:1:\"0\";s:26:\"fullscreen_nav_menu_gutter\";s:2:\"25\";s:25:\"fullscreen_nav_link_color\";s:4:\"#fff\";s:29:\"fullscreen_nav_link_hov_color\";s:4:\"#444\";s:32:\"fullscreen_nav_link_hov_bg_color\";s:4:\"#fff\";s:18:\"enable_header_date\";s:5:\"false\";s:22:\"header_toolbar_tagline\";s:0:\"\";s:20:\"header_toolbar_login\";s:4:\"true\";s:24:\"header_toolbar_subscribe\";s:5:\"false\";s:20:\"header_toolbar_email\";s:0:\"\";s:20:\"header_toolbar_phone\";s:0:\"\";s:17:\"header_toolbar_bg\";s:7:\"#ffffff\";s:24:\"header_mobile_toolbar_bg\";s:0:\"\";s:27:\"header_toolbar_border_color\";s:0:\"\";s:30:\"header_toolbar_search_input_bg\";s:0:\"\";s:24:\"header_toolbar_txt_color\";s:7:\"#999999\";s:25:\"header_toolbar_link_color\";s:7:\"#999999\";s:31:\"header_toolbar_search_input_txt\";s:7:\"#c7c7c7\";s:27:\"header_mobile_toolbar_color\";s:0:\"\";s:32:\"header_mobile_toolbar_link_color\";s:0:\"\";s:35:\"header_toolbar_social_network_color\";s:7:\"#999999\";s:34:\"header_mobile_toolbar_social_color\";s:0:\"\";s:17:\"page_title_global\";s:4:\"true\";s:19:\"banner_border_color\";s:7:\"#ededed\";s:21:\"page_introduce_weight\";s:3:\"400\";s:20:\"page_title_transform\";s:9:\"uppercase\";s:25:\"page_introduce_title_size\";s:2:\"20\";s:35:\"page_introduce_title_letter_spacing\";s:1:\"2\";s:16:\"page_title_color\";s:7:\"#4d4d4d\";s:17:\"page_title_shadow\";s:5:\"false\";s:28:\"page_introduce_subtitle_size\";s:2:\"14\";s:33:\"page_introduce_subtitle_transform\";s:4:\"none\";s:19:\"page_subtitle_color\";s:7:\"#a3a3a3\";s:18:\"disable_breadcrumb\";s:4:\"true\";s:15:\"breadcrumb_skin\";s:4:\"dark\";s:5:\"fonts\";a:1:{i:0;a:6:{s:4:\"type\";s:4:\"safe\";s:10:\"fontFamily\";s:28:\"Arial, Helvetica, sans-serif\";s:8:\"elements\";a:1:{i:0;s:4:\"body\";}s:6:\"subset\";s:0:\"\";s:12:\"currentField\";s:10:\"font-alert\";s:7:\"default\";s:4:\"true\";}}s:14:\"disable_footer\";s:4:\"true\";s:21:\"footer_disable_mobile\";s:5:\"false\";s:12:\"boxed_footer\";s:4:\"true\";s:11:\"footer_type\";s:1:\"1\";s:14:\"footer_columns\";s:1:\"4\";s:20:\"footer_top_thickness\";s:1:\"0\";s:23:\"footer_top_border_color\";s:0:\"\";s:13:\"footer_gutter\";s:1:\"2\";s:22:\"footer_wrapper_padding\";s:2:\"30\";s:27:\"footer_widget_margin_bottom\";s:2:\"40\";s:19:\"footer_title_weight\";s:6:\"bolder\";s:22:\"footer_title_transform\";s:9:\"uppercase\";s:17:\"footer_title_size\";s:2:\"14\";s:18:\"footer_title_color\";s:4:\"#fff\";s:18:\"footer_text_weight\";s:3:\"400\";s:16:\"footer_text_size\";s:2:\"14\";s:17:\"footer_text_color\";s:7:\"#808080\";s:18:\"footer_links_color\";s:7:\"#999999\";s:24:\"footer_links_hover_color\";s:0:\"\";s:18:\"disable_sub_footer\";s:4:\"true\";s:17:\"enable_footer_nav\";s:4:\"true\";s:9:\"copyright\";s:41:\"Copyright All Rights Reserved &copy; 2017\";s:19:\"sub_footer_bg_color\";s:7:\"#43474d\";s:14:\"copyright_size\";s:2:\"11\";s:24:\"copyright_letter_spacing\";s:1:\"1\";s:25:\"sub_footer_nav_copy_color\";s:7:\"#8c8e91\";s:15:\"custom_sidebars\";s:0:\"\";s:20:\"sidebar_title_weight\";s:6:\"bolder\";s:23:\"sidebar_title_transform\";s:9:\"uppercase\";s:18:\"sidebar_title_size\";s:2:\"14\";s:19:\"sidebar_title_color\";s:7:\"#333333\";s:19:\"sidebar_text_weight\";s:3:\"400\";s:17:\"sidebar_text_size\";s:2:\"14\";s:18:\"sidebar_text_color\";s:7:\"#999999\";s:19:\"sidebar_links_color\";s:7:\"#999999\";s:25:\"sidebar_links_hover_color\";s:0:\"\";s:18:\"search_page_layout\";s:5:\"right\";s:17:\"search_page_title\";s:6:\"Search\";s:23:\"search_disable_subtitle\";s:4:\"true\";s:13:\"single_layout\";s:4:\"full\";s:17:\"single_blog_style\";s:7:\"compact\";s:28:\"single_bold_hero_full_height\";s:4:\"true\";s:29:\"single_disable_featured_image\";s:4:\"true\";s:23:\"bold_single_hero_height\";s:3:\"800\";s:28:\"single_featured_image_height\";s:3:\"300\";s:20:\"blog_single_img_crop\";s:4:\"true\";s:17:\"blog_single_title\";s:4:\"true\";s:14:\"blog_prev_next\";s:4:\"true\";s:28:\"blog_prev_next_same_category\";s:4:\"true\";s:27:\"enable_single_related_posts\";s:4:\"true\";s:20:\"blog_single_comments\";s:4:\"true\";s:18:\"enable_blog_author\";s:4:\"true\";s:18:\"single_blog_social\";s:4:\"true\";s:19:\"blog_heading_weight\";s:3:\"600\";s:22:\"blog_heading_transform\";s:0:\"\";s:17:\"blog_heading_size\";s:1:\"0\";s:18:\"blog_heading_color\";s:0:\"\";s:18:\"blog_body_h1_color\";s:0:\"\";s:18:\"blog_body_h2_color\";s:0:\"\";s:18:\"blog_body_h3_color\";s:0:\"\";s:18:\"blog_body_h4_color\";s:0:\"\";s:18:\"blog_body_h5_color\";s:0:\"\";s:18:\"blog_body_h6_color\";s:0:\"\";s:16:\"blog_body_weight\";s:3:\"400\";s:19:\"blog_body_font_size\";s:1:\"0\";s:21:\"blog_body_line_height\";s:1:\"0\";s:15:\"blog_body_color\";s:0:\"\";s:17:\"blog_body_a_color\";s:0:\"\";s:23:\"blog_body_a_color_hover\";s:0:\"\";s:26:\"blog_body_strong_tag_color\";s:0:\"\";s:19:\"single_meta_section\";s:4:\"true\";s:18:\"diable_single_tags\";s:4:\"true\";s:19:\"archive_page_layout\";s:5:\"right\";s:18:\"archive_loop_style\";s:6:\"modern\";s:18:\"archive_page_title\";s:8:\"Archives\";s:24:\"archive_disable_subtitle\";s:4:\"true\";s:25:\"archive_blog_image_height\";s:3:\"350\";s:17:\"archive_blog_meta\";s:4:\"true\";s:24:\"archive_pagination_style\";s:1:\"1\";s:27:\"news_disable_featured_image\";s:4:\"true\";s:26:\"news_featured_image_height\";s:3:\"340\";s:9:\"news_slug\";s:10:\"news-posts\";s:23:\"portfolio_single_layout\";s:4:\"full\";s:29:\"Portfolio_single_image_height\";s:3:\"500\";s:21:\"single_portfolio_cats\";s:5:\"false\";s:30:\"enable_portfolio_similar_posts\";s:4:\"true\";s:19:\"portfolio_next_prev\";s:4:\"true\";s:33:\"portfolio_prev_next_same_category\";s:4:\"true\";s:24:\"enable_portfolio_comment\";s:5:\"false\";s:23:\"single_portfolio_social\";s:4:\"true\";s:14:\"portfolio_slug\";s:15:\"portfolio-posts\";s:18:\"portfolio_cat_slug\";s:18:\"portfolio_category\";s:24:\"stick_template_portfolio\";s:5:\"false\";s:24:\"archive_portfolio_layout\";s:5:\"right\";s:23:\"archive_portfolio_style\";s:7:\"classic\";s:30:\"archive_portfolio_image_height\";s:3:\"400\";s:24:\"archive_portfolio_column\";s:1:\"3\";s:34:\"archive_portfolio_pagination_style\";s:1:\"1\";s:15:\"shop_customizer\";s:5:\"false\";s:20:\"shop_archive_columns\";s:7:\"default\";s:19:\"woocommerce_catalog\";s:5:\"false\";s:23:\"woo_category_image_size\";s:4:\"crop\";s:31:\"woocommerce_category_page_title\";s:4:\"Shop\";s:29:\"woocommerce_use_product_title\";s:5:\"false\";s:30:\"woocommerce_use_category_title\";s:5:\"false\";s:37:\"woocommerce_use_category_filter_title\";s:5:\"false\";s:13:\"shopping_cart\";s:4:\"true\";s:19:\"add_cart_responsive\";s:4:\"true\";s:19:\"woo_loop_image_size\";s:4:\"crop\";s:19:\"woo_loop_img_height\";s:3:\"300\";s:26:\"woocommerce_loop_show_desc\";s:5:\"false\";s:25:\"woocommerce_single_layout\";s:4:\"full\";s:32:\"woocommerce_single_product_title\";s:4:\"true\";s:20:\"woo_single_prev_next\";s:4:\"true\";s:27:\"woo_prev_next_same_category\";s:4:\"true\";s:33:\"woocommerce_single_social_network\";s:4:\"true\";s:9:\"minify-js\";s:4:\"true\";s:10:\"minify-css\";s:4:\"true\";s:25:\"move-shortcode-css-footer\";s:4:\"true\";s:17:\"remove-js-css-ver\";s:4:\"true\";s:15:\"global_lazyload\";s:4:\"true\";s:19:\"portfolio-post-type\";s:4:\"true\";s:14:\"news-post-type\";s:4:\"true\";s:13:\"faq-post-type\";s:4:\"true\";s:21:\"photo_album-post-type\";s:4:\"true\";s:17:\"pricing-post-type\";s:4:\"true\";s:17:\"clients-post-type\";s:4:\"true\";s:19:\"employees-post-type\";s:4:\"true\";s:21:\"testimonial-post-type\";s:4:\"true\";s:26:\"animated-columns-post-type\";s:4:\"true\";s:14:\"edge-post-type\";s:4:\"true\";s:20:\"tab_slider-post-type\";s:4:\"true\";s:19:\"slideshow-post-type\";s:5:\"false\";s:24:\"banner_builder-post-type\";s:5:\"false\";s:10:\"custom_css\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:20:\"theme_import_options\";s:0:\"\";s:13:\"object_Object\";s:0:\"\";s:35:\"woocommerce_loop_enable_love_button\";s:4:\"true\";s:7:\"_source\";s:0:\"\";s:6:\"_image\";s:0:\"\";s:15:\"_color_gradient\";s:0:\"\";s:6:\"_color\";s:0:\"\";s:8:\"_color_2\";s:0:\"\";s:21:\"_color_gradient_style\";s:0:\"\";s:21:\"_color_gradient_angle\";s:0:\"\";s:5:\"_size\";s:0:\"\";s:9:\"_position\";s:0:\"\";s:11:\"_attachment\";s:0:\"\";s:7:\"_repeat\";s:0:\"\";s:14:\"button_clicked\";s:22:\"save_theme_options_top\";s:18:\"theme_header_align\";s:4:\"left\";s:20:\"theme_toolbar_toggle\";s:4:\"true\";}","yes");
INSERT INTO wpcf_options VALUES("339","Jupiter_options_revision_1542384667","YTo0NDc6e3M6MTA6InNraW5fY29sb3IiO3M6NzoiI2Y5NzM1MiI7czoxMjoic21vb3Roc2Nyb2xsIjtzOjQ6InRydWUiO3M6MTQ6InBhZ2VzX2NvbW1lbnRzIjtzOjU6ImZhbHNlIjtzOjk6ImdvX3RvX3RvcCI7czo0OiJ0cnVlIjtzOjEzOiJyZXRpbmFfaW1hZ2VzIjtzOjQ6InRydWUiO3M6MTc6InJlc3BvbnNpdmVfaW1hZ2VzIjtzOjQ6InRydWUiO3M6MjA6ImltYWdlX3Jlc2l6ZV9xdWFsaXR5IjtzOjM6IjEwMCI7czoxMToic3ZnX3N1cHBvcnQiO3M6NToiZmFsc2UiO3M6MjY6ImZ1bGxzY3JlZW5fbmF2X2xvZ29fbWFyZ2luIjtzOjM6IjEyNSI7czo0OiJsb2dvIjtzOjA6IiI7czoxNzoibGlnaHRfaGVhZGVyX2xvZ28iO3M6MDoiIjtzOjE4OiJzdGlja3lfaGVhZGVyX2xvZ28iO3M6MDoiIjtzOjE1OiJyZXNwb25zaXZlX2xvZ28iO3M6MDoiIjtzOjExOiJmb290ZXJfbG9nbyI7czowOiIiO3M6MTQ6ImN1c3RvbV9mYXZpY29uIjtzOjA6IiI7czoxMToiaXBob25lX2ljb24iO3M6MDoiIjtzOjE4OiJpcGhvbmVfaWNvbl9yZXRpbmEiO3M6MDoiIjtzOjk6ImlwYWRfaWNvbiI7czowOiIiO3M6MTY6ImlwYWRfaWNvbl9yZXRpbmEiO3M6MDoiIjtzOjk6InByZWxvYWRlciI7czo1OiJmYWxzZSI7czoxNjoicmV0aW5hX3ByZWxvYWRlciI7czo1OiJmYWxzZSI7czoxNDoicHJlbG9hZGVyX2xvZ28iO3M6MDoiIjtzOjIwOiJwcmVsb2FkZXJfaWNvbl9jb2xvciI7czo3OiIjN2M3YzdjIjtzOjE4OiJwcmVsb2FkZXJfYmdfY29sb3IiO3M6NDoiI2ZmZiI7czoyMzoic2VjdGlvbl9wcmVsb2FkZXJfY29sb3IiO3M6NDoiI2ZmZiI7czoxOToicHJlbG9hZGVyX2FuaW1hdGlvbiI7czoxMDoiYmFsbF9wdWxzZSI7czoyMToiZGlzYWJsZV9xdWlja19jb250YWN0IjtzOjQ6InRydWUiO3M6MjM6InF1aWNrX2NvbnRhY3Rfb25fc2luZ2xlIjtzOjQ6InRydWUiO3M6MjE6ImNhcHRjaGFfcXVpY2tfY29udGFjdCI7czo0OiJ0cnVlIjtzOjE5OiJxdWlja19jb250YWN0X2VtYWlsIjtzOjM5OiJhZG1pbkB0aGVsaWdodGhvdXNlZm91bmRhdGlvbi5kaWRvbmUubmwiO3M6MTk6InF1aWNrX2NvbnRhY3RfdGl0bGUiO3M6MTA6IkNvbnRhY3QgVXMiO3M6MTg6InF1aWNrX2NvbnRhY3RfZGVzYyI7czo4OToiV2UncmUgbm90IGFyb3VuZCByaWdodCBub3cuIEJ1dCB5b3UgY2FuIHNlbmQgdXMgYW4gZW1haWwgYW5kIHdlJ2xsIGdldCBiYWNrIHRvIHlvdSwgYXNhcC4iO3M6MjY6InF1aWNrX2NvbnRhY3RfZ2Rwcl9jb25zZW50IjtzOjQ6InRydWUiO3M6MzE6InF1aWNrX2NvbnRhY3RfZ2Rwcl9jb25zZW50X3RleHQiO3M6Nzk6IkkgY29uc2VudCB0byBUaGUgTGlnaHRob3VzZSBGb3VuZGF0aW9uIGNvbGxlY3RpbmcgbXkgZGV0YWlscyB0aHJvdWdoIHRoaXMgZm9ybS4iO3M6MjA6InR3aXR0ZXJfY29uc3VtZXJfa2V5IjtzOjA6IiI7czoyMzoidHdpdHRlcl9jb25zdW1lcl9zZWNyZXQiO3M6MDoiIjtzOjIwOiJ0d2l0dGVyX2FjY2Vzc190b2tlbiI7czowOiIiO3M6Mjc6InR3aXR0ZXJfYWNjZXNzX3Rva2VuX3NlY3JldCI7czowOiIiO3M6MTc6Im1haWxjaGltcF9hcGlfa2V5IjtzOjA6IiI7czoxNzoibWFpbGNoaW1wX2xpc3RfaWQiO3M6MDoiIjtzOjE1OiJtYWlsY2hpbXBfb3B0aW4iO3M6NToiZmFsc2UiO3M6MTk6Imdvb2dsZV9tYXBzX2FwaV9rZXkiO3M6MDoiIjtzOjk6ImFuYWx5dGljcyI7czowOiIiO3M6MTA6InR5cGVraXRfaWQiO3M6MDoiIjtzOjE2OiJ0aGlyZF9wYXJ0eV9nZHByIjtzOjU6ImZhbHNlIjtzOjMxOiJiYWNrZ3JvdW5kX3NlbGVjdG9yX29yaWVudGF0aW9uIjtzOjE3OiJmdWxsX3dpZHRoX2xheW91dCI7czoxMDoiZ3JpZF93aWR0aCI7czo0OiIxMTQwIjtzOjEzOiJjb250ZW50X3dpZHRoIjtzOjI6IjczIjtzOjE4OiJjb250ZW50X3Jlc3BvbnNpdmUiO3M6MzoiOTYwIjtzOjIwOiJyZXNwb25zaXZlX25hdl93aWR0aCI7czo0OiIxMTQwIjtzOjE5OiJzdGlja190ZW1wbGF0ZV9wYWdlIjtzOjU6ImZhbHNlIjtzOjExOiJib2R5X2JvcmRlciI7czo1OiJmYWxzZSI7czoyMToiYm9keV9ib3JkZXJfdGhpY2tuZXNzIjtzOjI6IjUwIjtzOjE3OiJib2R5X2JvcmRlcl9jb2xvciI7czo0OiIjZmZmIjtzOjI5OiJib2R5X2JvcmRlcl9vbl9tb2JpbGVfZGV2aWNlcyI7czo1OiJmYWxzZSI7czoyNDoicGFnZV90aXRsZV9leHBhbmRfaGVhZGVyIjtzOjU6ImZhbHNlIjtzOjI0OiJib3hlZF9sYXlvdXRfc2hhZG93X3NpemUiO3M6MToiMCI7czoyOToiYm94ZWRfbGF5b3V0X3NoYWRvd19pbnRlbnNpdHkiO3M6MToiMCI7czoxODoiZ2VuZXJhbF9iYWNrZ291bmRzIjtzOjU6ImZhbHNlIjtzOjIwOiJiZ19wYW5lbF9pbWFnZV9zdHlsZSI7czowOiIiO3M6MTU6ImJnX3BhbmVsX3VwbG9hZCI7czowOiIiO3M6MjA6ImJnX3BhbmVsX2NvbG9yX3N0eWxlIjtzOjA6IiI7czoxNDoiYmdfcGFuZWxfY29sb3IiO3M6MDoiIjtzOjE2OiJiZ19wYW5lbF9jb2xvcl8yIjtzOjA6IiI7czoyMToiZ3JhbmRpZW50X2NvbG9yX3N0eWxlIjtzOjA6IiI7czoyMToiZ3JhbmRpZW50X2NvbG9yX2FuZ2xlIjtzOjA6IiI7czoxNToiYmdfcGFuZWxfcmVwZWF0IjtzOjA6IiI7czoxOToiYmdfcGFuZWxfYXR0YWNobWVudCI7czowOiIiO3M6MTc6ImJnX3BhbmVsX3Bvc2l0aW9uIjtzOjA6IiI7czoxMzoiYmdfcGFuZWxfc2l6ZSI7czowOiIiO3M6MTA6ImJvZHlfY29sb3IiO3M6NDoiI2ZmZiI7czoxOToiYm9keV9jb2xvcl9ncmFkaWVudCI7czo2OiJzaW5nbGUiO3M6MTI6ImJvZHlfY29sb3JfMiI7czowOiIiO3M6MjU6ImJvZHlfY29sb3JfZ3JhZGllbnRfc3R5bGUiO3M6NjoibGluZWFyIjtzOjI1OiJib2R5X2NvbG9yX2dyYWRpZW50X2FuZ2xlIjtzOjg6InZlcnRpY2FsIjtzOjEwOiJib2R5X2ltYWdlIjtzOjA6IiI7czo5OiJib2R5X3NpemUiO3M6NToiZmFsc2UiO3M6MTM6ImJvZHlfcG9zaXRpb24iO3M6MDoiIjtzOjE1OiJib2R5X2F0dGFjaG1lbnQiO3M6MDoiIjtzOjExOiJib2R5X3JlcGVhdCI7czowOiIiO3M6MTE6ImJvZHlfc291cmNlIjtzOjg6Im5vLWltYWdlIjtzOjEwOiJwYWdlX2NvbG9yIjtzOjQ6IiNmZmYiO3M6MTk6InBhZ2VfY29sb3JfZ3JhZGllbnQiO3M6Njoic2luZ2xlIjtzOjEyOiJwYWdlX2NvbG9yXzIiO3M6MDoiIjtzOjI1OiJwYWdlX2NvbG9yX2dyYWRpZW50X3N0eWxlIjtzOjY6ImxpbmVhciI7czoyNToicGFnZV9jb2xvcl9ncmFkaWVudF9hbmdsZSI7czo4OiJ2ZXJ0aWNhbCI7czoxMDoicGFnZV9pbWFnZSI7czowOiIiO3M6OToicGFnZV9zaXplIjtzOjU6ImZhbHNlIjtzOjEzOiJwYWdlX3Bvc2l0aW9uIjtzOjA6IiI7czoxNToicGFnZV9hdHRhY2htZW50IjtzOjA6IiI7czoxMToicGFnZV9yZXBlYXQiO3M6MDoiIjtzOjExOiJwYWdlX3NvdXJjZSI7czo4OiJuby1pbWFnZSI7czoxMjoiaGVhZGVyX2NvbG9yIjtzOjQ6IiNmZmYiO3M6MjE6ImhlYWRlcl9jb2xvcl9ncmFkaWVudCI7czo2OiJzaW5nbGUiO3M6MTQ6ImhlYWRlcl9jb2xvcl8yIjtzOjA6IiI7czoyNzoiaGVhZGVyX2NvbG9yX2dyYWRpZW50X3N0eWxlIjtzOjY6ImxpbmVhciI7czoyNzoiaGVhZGVyX2NvbG9yX2dyYWRpZW50X2FuZ2xlIjtzOjg6InZlcnRpY2FsIjtzOjEyOiJoZWFkZXJfaW1hZ2UiO3M6MDoiIjtzOjExOiJoZWFkZXJfc2l6ZSI7czo1OiJmYWxzZSI7czoxNToiaGVhZGVyX3Bvc2l0aW9uIjtzOjA6IiI7czoxNzoiaGVhZGVyX2F0dGFjaG1lbnQiO3M6MDoiIjtzOjEzOiJoZWFkZXJfcmVwZWF0IjtzOjA6IiI7czoxMzoiaGVhZGVyX3NvdXJjZSI7czo4OiJuby1pbWFnZSI7czoxMjoiYmFubmVyX2NvbG9yIjtzOjc6IiNmN2Y3ZjciO3M6MjE6ImJhbm5lcl9jb2xvcl9ncmFkaWVudCI7czo2OiJzaW5nbGUiO3M6MTQ6ImJhbm5lcl9jb2xvcl8yIjtzOjA6IiI7czoyNzoiYmFubmVyX2NvbG9yX2dyYWRpZW50X3N0eWxlIjtzOjY6ImxpbmVhciI7czoyNzoiYmFubmVyX2NvbG9yX2dyYWRpZW50X2FuZ2xlIjtzOjg6InZlcnRpY2FsIjtzOjEyOiJiYW5uZXJfaW1hZ2UiO3M6MDoiIjtzOjExOiJiYW5uZXJfc2l6ZSI7czo0OiJ0cnVlIjtzOjE1OiJiYW5uZXJfcG9zaXRpb24iO3M6MDoiIjtzOjE3OiJiYW5uZXJfYXR0YWNobWVudCI7czowOiIiO3M6MTM6ImJhbm5lcl9yZXBlYXQiO3M6MDoiIjtzOjEzOiJiYW5uZXJfc291cmNlIjtzOjg6Im5vLWltYWdlIjtzOjEyOiJmb290ZXJfY29sb3IiO3M6NzoiIzNkNDA0NSI7czoyMToiZm9vdGVyX2NvbG9yX2dyYWRpZW50IjtzOjY6InNpbmdsZSI7czoxNDoiZm9vdGVyX2NvbG9yXzIiO3M6MDoiIjtzOjI3OiJmb290ZXJfY29sb3JfZ3JhZGllbnRfc3R5bGUiO3M6NjoibGluZWFyIjtzOjI3OiJmb290ZXJfY29sb3JfZ3JhZGllbnRfYW5nbGUiO3M6ODoidmVydGljYWwiO3M6MTI6ImZvb3Rlcl9pbWFnZSI7czowOiIiO3M6MTE6ImZvb3Rlcl9zaXplIjtzOjU6ImZhbHNlIjtzOjE1OiJmb290ZXJfcG9zaXRpb24iO3M6MDoiIjtzOjE3OiJmb290ZXJfYXR0YWNobWVudCI7czowOiIiO3M6MTM6ImZvb3Rlcl9yZXBlYXQiO3M6MDoiIjtzOjEzOiJmb290ZXJfc291cmNlIjtzOjg6Im5vLWltYWdlIjtzOjExOiJib2R5X3dlaWdodCI7czozOiI0MDAiO3M6MTQ6ImJvZHlfZm9udF9zaXplIjtzOjI6IjE0IjtzOjE2OiJib2R5X2xpbmVfaGVpZ2h0IjtzOjQ6IjEuNjYiO3M6MTU6ImJvZHlfdGV4dF9jb2xvciI7czo3OiIjNzc3Nzc3IjtzOjc6ImFfY29sb3IiO3M6NzoiIzJlMmUyZSI7czoxMzoiYV9jb2xvcl9ob3ZlciI7czo3OiIjZjk3MzUyIjtzOjEyOiJzdHJvbmdfY29sb3IiO3M6NzoiI2Y5NzM1MiI7czo2OiJwX3NpemUiO3M6MjoiMTYiO3M6MTM6InBfbGluZV9oZWlnaHQiO3M6NDoiMS42NiI7czo3OiJwX2NvbG9yIjtzOjc6IiM3Nzc3NzciO3M6MjA6ImhlYWRpbmdzX2xpbmVfaGVpZ2h0IjtzOjM6IjEuMyI7czo5OiJoMV93ZWlnaHQiO3M6MzoiNjAwIjtzOjEyOiJoMV90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjc6ImgxX3NpemUiO3M6MjoiMzYiO3M6ODoiaDFfY29sb3IiO3M6NzoiIzQwNDA0MCI7czo5OiJoMl93ZWlnaHQiO3M6MzoiNjAwIjtzOjEyOiJoMl90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjc6ImgyX3NpemUiO3M6MjoiMzAiO3M6ODoiaDJfY29sb3IiO3M6NzoiIzQwNDA0MCI7czo5OiJoM193ZWlnaHQiO3M6MzoiNjAwIjtzOjEyOiJoM190cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjc6ImgzX3NpemUiO3M6MjoiMjQiO3M6ODoiaDNfY29sb3IiO3M6NzoiIzQwNDA0MCI7czo5OiJoNF93ZWlnaHQiO3M6MzoiNjAwIjtzOjEyOiJoNF90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjc6Img0X3NpemUiO3M6MjoiMTgiO3M6ODoiaDRfY29sb3IiO3M6NzoiIzQwNDA0MCI7czo5OiJoNV93ZWlnaHQiO3M6MzoiNjAwIjtzOjEyOiJoNV90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjc6Img1X3NpemUiO3M6MjoiMTYiO3M6ODoiaDVfY29sb3IiO3M6NzoiIzQwNDA0MCI7czo5OiJoNl93ZWlnaHQiO3M6MzoiNjAwIjtzOjEyOiJoNl90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjc6Img2X3NpemUiO3M6MjoiMTQiO3M6ODoiaDZfY29sb3IiO3M6NzoiIzQwNDA0MCI7czoyMToiaGVhZGVyX2xheW91dF9idWlsZGVyIjtzOjE2OiJwcmVfYnVpbHRfaGVhZGVyIjtzOjE4OiJ0aGVtZV9oZWFkZXJfc3R5bGUiO3M6MToiMSI7czoxNDoic2Vjb25kYXJ5X21lbnUiO3M6MTA6ImZ1bGxzY3JlZW4iO3M6MTg6ImhlYWRlcl9idXJnZXJfc2l6ZSI7czo1OiJzbWFsbCI7czoyMzoic2VvbmRhcnlfaGVhZGVyX2Zvcl9hbGwiO3M6NToiZmFsc2UiO3M6MTg6InZlcnRpY2FsX21lbnVfYW5pbSI7czoxOiIxIjtzOjI2OiJ2ZXJ0aWNhbF9oZWFkZXJfbG9nb19hbGlnbiI7czo2OiJjZW50ZXIiO3M6Mjg6InZlcnRpY2FsX2hlYWRlcl9sb2dvX3BhZGRpbmciO3M6MjoiMTAiO3M6MjE6InZlcnRpY2FsX2hlYWRlcl9hbGlnbiI7czo0OiJsZWZ0IjtzOjIzOiJ2ZXJ0aWNhbF9tZW51X2NvcHlyaWdodCI7czo0MToiQ29weXJpZ2h0IEFsbCBSaWdodHMgUmVzZXJ2ZWQgJmNvcHk7IDIwMTciO3M6MTE6ImhlYWRlcl9ncmlkIjtzOjQ6InRydWUiO3M6MTY6ImhpZGVfaGVhZGVyX2xvZ28iO3M6NDoidHJ1ZSI7czoxNDoibG9nb19pbl9taWRkbGUiO3M6NToiZmFsc2UiO3M6MTU6ImhpZGVfaGVhZGVyX25hdiI7czo0OiJ0cnVlIjtzOjIyOiJoZWFkZXJfc2VhcmNoX2xvY2F0aW9uIjtzOjE3OiJmdWxsc2NyZWVuX3NlYXJjaCI7czoyMjoiaGVhZGVyX3N0YXJ0X3RvdXJfdGV4dCI7czowOiIiO3M6MjI6ImhlYWRlcl9zdGFydF90b3VyX3BhZ2UiO3M6MDoiIjtzOjE1OiJzdGFydF90b3VyX3NpemUiO3M6MjoiMTQiO3M6MTM6ImxvZ2dlZGluX21lbnUiO3M6MTE6ImZvdXJ0aC1tZW51IjtzOjEzOiJoZWFkZXJfaGVpZ2h0IjtzOjI6IjkwIjtzOjE3OiJyZXNfaGVhZGVyX2hlaWdodCI7czoyOiI5MCI7czoxNDoiaGVhZGVyX29wYWNpdHkiO3M6MToiMSI7czoyNzoiaGVhZGVyX2J0bl9ib3JkZXJfdGhpY2tuZXNzIjtzOjE6IjEiO3M6MTk6ImhlYWRlcl9ib3JkZXJfY29sb3IiO3M6NzoiI2VkZWRlZCI7czoxNjoic3RhcnRfdG91cl9jb2xvciI7czo0OiIjMzMzIjtzOjE5OiJoZWFkZXJfYnVyZ2VyX2NvbG9yIjtzOjA6IiI7czoxNzoibWFpbl9uYXZfYmdfY29sb3IiO3M6MDoiIjtzOjE0OiJtYWluX25hdl9ob3ZlciI7czoxOiI1IjtzOjE5OiJtYWluX25hdl90b3Bfd2VpZ2h0IjtzOjM6IjYwMCI7czoxOToibWFpbl9tZW51X3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6MTc6Im1haW5fbmF2X3RvcF9zaXplIjtzOjI6IjEzIjtzOjI3OiJtYWluX25hdl90b3BfbGV0dGVyX3NwYWNpbmciO3M6MToiMCI7czoxOToibWFpbl9uYXZfaXRlbV9zcGFjZSI7czoyOiIyMCI7czoyMzoibWFpbl9uYXZfdG9wX3RleHRfY29sb3IiO3M6NzoiIzQ0NDQ0NCI7czoyMzoibWFpbl9uYXZfdG9wX2hvdmVyX3NraW4iO3M6NzoiI2Y5NzM1MiI7czoyODoibWFpbl9uYXZfdG9wX2hvdmVyX3R4dF9jb2xvciI7czo0OiIjZmZmIjtzOjE5OiJtYWluX25hdl9zdWJfd2VpZ2h0IjtzOjM6IjQwMCI7czoyMjoibWFpbl9uYXZfc3ViX3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6MTc6Im1haW5fbmF2X3N1Yl9zaXplIjtzOjI6IjEyIjtzOjI3OiJtYWluX25hdl9zdWJfbGV0dGVyX3NwYWNpbmciO3M6MToiMSI7czoyMzoibWFpbl9uYXZfc3ViX3RleHRfY29sb3IiO3M6NzoiI2IzYjNiMyI7czoyOToibWFpbl9uYXZfc3ViX3RleHRfY29sb3JfaG92ZXIiO3M6NzoiI2ZmZmZmZiI7czoyNzoibWFpbl9uYXZfc3ViX2hvdmVyX2JnX2NvbG9yIjtzOjA6IiI7czoyOToibWFpbl9uYXZfc3ViX2JvcmRlcl90b3BfY29sb3IiO3M6NzoiI2Y5NzM1MiI7czoyMToibWFpbl9uYXZfc3ViX2JnX2NvbG9yIjtzOjc6IiMzMzMzMzMiO3M6MjM6Im1haW5fbmF2X3N1Yl9pY29uX2NvbG9yIjtzOjc6IiNlMGUwZTAiO3M6MTQ6Im5hdl9zdWJfc2hhZG93IjtzOjU6ImZhbHNlIjtzOjI2OiJzdWJfbGV2ZWxfYm94X2JvcmRlcl9jb2xvciI7czowOiIiO3M6MTg6Im1haW5fbmF2X3N1Yl93aWR0aCI7czozOiIyMzAiO3M6MjU6Im1haW5fbmF2X21lZ2FfdGl0bGVfY29sb3IiO3M6NzoiI2ZmZmZmZiI7czoyMzoibWVnYV9tZW51X2RpdmlkZXJfY29sb3IiO3M6MDoiIjtzOjIyOiJoZWFkZXJfc29jaWFsX2xvY2F0aW9uIjtzOjA6IiI7czoyNzoiaGVhZGVyX3NvY2lhbF9uZXR3b3Jrc19zaXRlIjtzOjA6IiI7czoyNjoiaGVhZGVyX3NvY2lhbF9uZXR3b3Jrc191cmwiO3M6MDoiIjtzOjI4OiJoZWFkZXJfc29jaWFsX25ldHdvcmtzX3N0eWxlIjtzOjY6ImNpcmNsZSI7czoxNjoiaGVhZGVyX2ljb25fc2l6ZSI7czo1OiJzbWFsbCI7czoxOToiaGVhZGVyX3NvY2lhbF9jb2xvciI7czo3OiIjOTk5OTk5IjtzOjI1OiJoZWFkZXJfc29jaWFsX2hvdmVyX2NvbG9yIjtzOjQ6IiNjY2MiO3M6Mjc6ImhlYWRlcl9zb2NpYWxfYmdfbWFpbl9jb2xvciI7czo3OiIjMjMyMzIzIjtzOjIyOiJoZWFkZXJfc29jaWFsX2JnX2NvbG9yIjtzOjc6IiMyMzIzMjMiO3M6MjY6ImhlYWRlcl9zb2NpYWxfYm9yZGVyX2NvbG9yIjtzOjc6IiM5OTk5OTkiO3M6MTY6ImhlYWRlcl9tb2JpbGVfYmciO3M6MDoiIjtzOjIwOiJyZXNwb25zaXZlX25hdl9jb2xvciI7czo0OiIjZmZmIjtzOjI5OiJoZWFkZXJfbW9iaWxlX3NlYXJjaF9pbnB1dF9iZyI7czowOiIiO3M6MzI6ImhlYWRlcl9tb2JpbGVfc2VhcmNoX2lucHV0X2NvbG9yIjtzOjA6IiI7czoyNDoicmVzcG9uc2l2ZV9uYXZfdHh0X2NvbG9yIjtzOjc6IiM0NDQ0NDQiO3M6MTk6ImhlYWRlcl9zdGlja3lfc3R5bGUiO3M6NToiZml4ZWQiO3M6MjA6InN0aWNreV9oZWFkZXJfb2Zmc2V0IjtzOjY6ImhlYWRlciI7czoyMDoiaGVhZGVyX3Njcm9sbF9oZWlnaHQiO3M6MjoiNTUiO3M6MjE6ImhlYWRlcl9zdGlja3lfb3BhY2l0eSI7czoxOiIxIjtzOjI2OiJzdGlja3lfaGVhZGVyX2JvcmRlcl9jb2xvciI7czowOiIiO3M6MTM6ImRhc2hfYmdfY29sb3IiO3M6NDoiIzQ0NCI7czoyNToiZGFzaF90b3BfbWVudV90ZXh0X3dlaWdodCI7czozOiI2MDAiO3M6MjM6ImRhc2hfdG9wX21lbnVfdHJhbnNmb3JtIjtzOjk6InVwcGVyY2FzZSI7czoyMzoiZGFzaF90b3BfbWVudV90ZXh0X3NpemUiO3M6MjoiMTMiO3M6MTk6ImRhc2hfbmF2X2xpbmtfY29sb3IiO3M6NDoiI2ZmZiI7czoyNToiZGFzaF9uYXZfbGlua19ob3Zlcl9jb2xvciI7czo0OiIjZmZmIjtzOjIzOiJkYXNoX25hdl9iZ19ob3Zlcl9jb2xvciI7czowOiIiO3M6MjU6ImRhc2hfc3ViX21lbnVfdGV4dF93ZWlnaHQiO3M6MzoiNDAwIjtzOjIzOiJkYXNoX3N1Yl9tZW51X3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6MjM6ImRhc2hfc3ViX21lbnVfdGV4dF9zaXplIjtzOjI6IjEyIjtzOjE3OiJkYXNoX3RpdGxlX3dlaWdodCI7czo2OiJib2xkZXIiO3M6MjA6ImRhc2hfdGl0bGVfdHJhbnNmb3JtIjtzOjk6InVwcGVyY2FzZSI7czoxNToiZGFzaF90aXRsZV9zaXplIjtzOjI6IjE0IjtzOjE2OiJkYXNoX3RpdGxlX2NvbG9yIjtzOjQ6IiNmZmYiO3M6MTY6ImRhc2hfdGV4dF93ZWlnaHQiO3M6MzoiNDAwIjtzOjE0OiJkYXNoX3RleHRfc2l6ZSI7czoyOiIxMiI7czoxNToiZGFzaF90ZXh0X2NvbG9yIjtzOjQ6IiNlZWUiO3M6MTY6ImRhc2hfbGlua3NfY29sb3IiO3M6NzoiI2ZhZmFmYSI7czoyMjoiZGFzaF9saW5rc19ob3Zlcl9jb2xvciI7czowOiIiO3M6MTk6ImZ1bGxzY3JlZW5fbmF2X2xvZ28iO3M6NDoiZGFyayI7czoyNjoiZnVsbHNjcmVlbl9uYXZfbW9iaWxlX2xvZ28iO3M6NDoiZGFyayI7czozMzoiZnVsbHNjcmVlbl9uYXZfbW9iaWxlX2xvZ29fY3VzdG9tIjtzOjA6IiI7czoyMzoiZnVsbHNjcmVlbl9uYXZfYmdfY29sb3IiO3M6NDoiIzQ0NCI7czoyNToiZnVsbHNjcmVlbl9jbG9zZV9idG5fc2tpbiI7czo1OiJsaWdodCI7czozMToiZnVsbHNjcmVlbl9uYXZfbWVudV9mb250X3dlaWdodCI7czo2OiJib2xkZXIiO3M6MzQ6ImZ1bGxzY3JlZW5fbmF2X21lbnVfdGV4dF90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjI5OiJmdWxsc2NyZWVuX25hdl9tZW51X2ZvbnRfc2l6ZSI7czoyOiIxNiI7czozNDoiZnVsbHNjcmVlbl9uYXZfbWVudV9sZXR0ZXJfc3BhY2luZyI7czoxOiIwIjtzOjI2OiJmdWxsc2NyZWVuX25hdl9tZW51X2d1dHRlciI7czoyOiIyNSI7czoyNToiZnVsbHNjcmVlbl9uYXZfbGlua19jb2xvciI7czo0OiIjZmZmIjtzOjI5OiJmdWxsc2NyZWVuX25hdl9saW5rX2hvdl9jb2xvciI7czo0OiIjNDQ0IjtzOjMyOiJmdWxsc2NyZWVuX25hdl9saW5rX2hvdl9iZ19jb2xvciI7czo0OiIjZmZmIjtzOjE4OiJlbmFibGVfaGVhZGVyX2RhdGUiO3M6NToiZmFsc2UiO3M6MjI6ImhlYWRlcl90b29sYmFyX3RhZ2xpbmUiO3M6MDoiIjtzOjIwOiJoZWFkZXJfdG9vbGJhcl9sb2dpbiI7czo0OiJ0cnVlIjtzOjI0OiJoZWFkZXJfdG9vbGJhcl9zdWJzY3JpYmUiO3M6NToiZmFsc2UiO3M6MjA6ImhlYWRlcl90b29sYmFyX2VtYWlsIjtzOjA6IiI7czoyMDoiaGVhZGVyX3Rvb2xiYXJfcGhvbmUiO3M6MDoiIjtzOjE3OiJoZWFkZXJfdG9vbGJhcl9iZyI7czo3OiIjZmZmZmZmIjtzOjI0OiJoZWFkZXJfbW9iaWxlX3Rvb2xiYXJfYmciO3M6MDoiIjtzOjI3OiJoZWFkZXJfdG9vbGJhcl9ib3JkZXJfY29sb3IiO3M6MDoiIjtzOjMwOiJoZWFkZXJfdG9vbGJhcl9zZWFyY2hfaW5wdXRfYmciO3M6MDoiIjtzOjI0OiJoZWFkZXJfdG9vbGJhcl90eHRfY29sb3IiO3M6NzoiIzk5OTk5OSI7czoyNToiaGVhZGVyX3Rvb2xiYXJfbGlua19jb2xvciI7czo3OiIjOTk5OTk5IjtzOjMxOiJoZWFkZXJfdG9vbGJhcl9zZWFyY2hfaW5wdXRfdHh0IjtzOjc6IiNjN2M3YzciO3M6Mjc6ImhlYWRlcl9tb2JpbGVfdG9vbGJhcl9jb2xvciI7czowOiIiO3M6MzI6ImhlYWRlcl9tb2JpbGVfdG9vbGJhcl9saW5rX2NvbG9yIjtzOjA6IiI7czozNToiaGVhZGVyX3Rvb2xiYXJfc29jaWFsX25ldHdvcmtfY29sb3IiO3M6NzoiIzk5OTk5OSI7czozNDoiaGVhZGVyX21vYmlsZV90b29sYmFyX3NvY2lhbF9jb2xvciI7czowOiIiO3M6MTc6InBhZ2VfdGl0bGVfZ2xvYmFsIjtzOjQ6InRydWUiO3M6MTk6ImJhbm5lcl9ib3JkZXJfY29sb3IiO3M6NzoiI2VkZWRlZCI7czoyMToicGFnZV9pbnRyb2R1Y2Vfd2VpZ2h0IjtzOjM6IjQwMCI7czoyMDoicGFnZV90aXRsZV90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjI1OiJwYWdlX2ludHJvZHVjZV90aXRsZV9zaXplIjtzOjI6IjIwIjtzOjM1OiJwYWdlX2ludHJvZHVjZV90aXRsZV9sZXR0ZXJfc3BhY2luZyI7czoxOiIyIjtzOjE2OiJwYWdlX3RpdGxlX2NvbG9yIjtzOjc6IiM0ZDRkNGQiO3M6MTc6InBhZ2VfdGl0bGVfc2hhZG93IjtzOjU6ImZhbHNlIjtzOjI4OiJwYWdlX2ludHJvZHVjZV9zdWJ0aXRsZV9zaXplIjtzOjI6IjE0IjtzOjMzOiJwYWdlX2ludHJvZHVjZV9zdWJ0aXRsZV90cmFuc2Zvcm0iO3M6NDoibm9uZSI7czoxOToicGFnZV9zdWJ0aXRsZV9jb2xvciI7czo3OiIjYTNhM2EzIjtzOjE4OiJkaXNhYmxlX2JyZWFkY3J1bWIiO3M6NDoidHJ1ZSI7czoxNToiYnJlYWRjcnVtYl9za2luIjtzOjQ6ImRhcmsiO3M6NToiZm9udHMiO2E6MTp7aTowO2E6Njp7czo0OiJ0eXBlIjtzOjQ6InNhZmUiO3M6MTA6ImZvbnRGYW1pbHkiO3M6Mjg6IkFyaWFsLCBIZWx2ZXRpY2EsIHNhbnMtc2VyaWYiO3M6ODoiZWxlbWVudHMiO2E6MTp7aTowO3M6NDoiYm9keSI7fXM6Njoic3Vic2V0IjtzOjA6IiI7czoxMjoiY3VycmVudEZpZWxkIjtzOjEwOiJmb250LWFsZXJ0IjtzOjc6ImRlZmF1bHQiO3M6NDoidHJ1ZSI7fX1zOjE0OiJkaXNhYmxlX2Zvb3RlciI7czo0OiJ0cnVlIjtzOjIxOiJmb290ZXJfZGlzYWJsZV9tb2JpbGUiO3M6NToiZmFsc2UiO3M6MTI6ImJveGVkX2Zvb3RlciI7czo0OiJ0cnVlIjtzOjExOiJmb290ZXJfdHlwZSI7czoxOiIxIjtzOjE0OiJmb290ZXJfY29sdW1ucyI7czoxOiI0IjtzOjIwOiJmb290ZXJfdG9wX3RoaWNrbmVzcyI7czoxOiIwIjtzOjIzOiJmb290ZXJfdG9wX2JvcmRlcl9jb2xvciI7czowOiIiO3M6MTM6ImZvb3Rlcl9ndXR0ZXIiO3M6MToiMiI7czoyMjoiZm9vdGVyX3dyYXBwZXJfcGFkZGluZyI7czoyOiIzMCI7czoyNzoiZm9vdGVyX3dpZGdldF9tYXJnaW5fYm90dG9tIjtzOjI6IjQwIjtzOjE5OiJmb290ZXJfdGl0bGVfd2VpZ2h0IjtzOjY6ImJvbGRlciI7czoyMjoiZm9vdGVyX3RpdGxlX3RyYW5zZm9ybSI7czo5OiJ1cHBlcmNhc2UiO3M6MTc6ImZvb3Rlcl90aXRsZV9zaXplIjtzOjI6IjE0IjtzOjE4OiJmb290ZXJfdGl0bGVfY29sb3IiO3M6NDoiI2ZmZiI7czoxODoiZm9vdGVyX3RleHRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxNjoiZm9vdGVyX3RleHRfc2l6ZSI7czoyOiIxNCI7czoxNzoiZm9vdGVyX3RleHRfY29sb3IiO3M6NzoiIzgwODA4MCI7czoxODoiZm9vdGVyX2xpbmtzX2NvbG9yIjtzOjc6IiM5OTk5OTkiO3M6MjQ6ImZvb3Rlcl9saW5rc19ob3Zlcl9jb2xvciI7czowOiIiO3M6MTg6ImRpc2FibGVfc3ViX2Zvb3RlciI7czo0OiJ0cnVlIjtzOjE3OiJlbmFibGVfZm9vdGVyX25hdiI7czo0OiJ0cnVlIjtzOjk6ImNvcHlyaWdodCI7czo0MToiQ29weXJpZ2h0IEFsbCBSaWdodHMgUmVzZXJ2ZWQgJmNvcHk7IDIwMTciO3M6MTk6InN1Yl9mb290ZXJfYmdfY29sb3IiO3M6NzoiIzQzNDc0ZCI7czoxNDoiY29weXJpZ2h0X3NpemUiO3M6MjoiMTEiO3M6MjQ6ImNvcHlyaWdodF9sZXR0ZXJfc3BhY2luZyI7czoxOiIxIjtzOjI1OiJzdWJfZm9vdGVyX25hdl9jb3B5X2NvbG9yIjtzOjc6IiM4YzhlOTEiO3M6MTU6ImN1c3RvbV9zaWRlYmFycyI7czowOiIiO3M6MjA6InNpZGViYXJfdGl0bGVfd2VpZ2h0IjtzOjY6ImJvbGRlciI7czoyMzoic2lkZWJhcl90aXRsZV90cmFuc2Zvcm0iO3M6OToidXBwZXJjYXNlIjtzOjE4OiJzaWRlYmFyX3RpdGxlX3NpemUiO3M6MjoiMTQiO3M6MTk6InNpZGViYXJfdGl0bGVfY29sb3IiO3M6NzoiIzMzMzMzMyI7czoxOToic2lkZWJhcl90ZXh0X3dlaWdodCI7czozOiI0MDAiO3M6MTc6InNpZGViYXJfdGV4dF9zaXplIjtzOjI6IjE0IjtzOjE4OiJzaWRlYmFyX3RleHRfY29sb3IiO3M6NzoiIzk5OTk5OSI7czoxOToic2lkZWJhcl9saW5rc19jb2xvciI7czo3OiIjOTk5OTk5IjtzOjI1OiJzaWRlYmFyX2xpbmtzX2hvdmVyX2NvbG9yIjtzOjA6IiI7czoxODoic2VhcmNoX3BhZ2VfbGF5b3V0IjtzOjU6InJpZ2h0IjtzOjE3OiJzZWFyY2hfcGFnZV90aXRsZSI7czo2OiJTZWFyY2giO3M6MjM6InNlYXJjaF9kaXNhYmxlX3N1YnRpdGxlIjtzOjQ6InRydWUiO3M6MTM6InNpbmdsZV9sYXlvdXQiO3M6NDoiZnVsbCI7czoxNzoic2luZ2xlX2Jsb2dfc3R5bGUiO3M6NzoiY29tcGFjdCI7czoyODoic2luZ2xlX2JvbGRfaGVyb19mdWxsX2hlaWdodCI7czo0OiJ0cnVlIjtzOjI5OiJzaW5nbGVfZGlzYWJsZV9mZWF0dXJlZF9pbWFnZSI7czo0OiJ0cnVlIjtzOjIzOiJib2xkX3NpbmdsZV9oZXJvX2hlaWdodCI7czozOiI4MDAiO3M6Mjg6InNpbmdsZV9mZWF0dXJlZF9pbWFnZV9oZWlnaHQiO3M6MzoiMzAwIjtzOjIwOiJibG9nX3NpbmdsZV9pbWdfY3JvcCI7czo0OiJ0cnVlIjtzOjE3OiJibG9nX3NpbmdsZV90aXRsZSI7czo0OiJ0cnVlIjtzOjE0OiJibG9nX3ByZXZfbmV4dCI7czo0OiJ0cnVlIjtzOjI4OiJibG9nX3ByZXZfbmV4dF9zYW1lX2NhdGVnb3J5IjtzOjQ6InRydWUiO3M6Mjc6ImVuYWJsZV9zaW5nbGVfcmVsYXRlZF9wb3N0cyI7czo0OiJ0cnVlIjtzOjIwOiJibG9nX3NpbmdsZV9jb21tZW50cyI7czo0OiJ0cnVlIjtzOjE4OiJlbmFibGVfYmxvZ19hdXRob3IiO3M6NDoidHJ1ZSI7czoxODoic2luZ2xlX2Jsb2dfc29jaWFsIjtzOjQ6InRydWUiO3M6MTk6ImJsb2dfaGVhZGluZ193ZWlnaHQiO3M6MzoiNjAwIjtzOjIyOiJibG9nX2hlYWRpbmdfdHJhbnNmb3JtIjtzOjA6IiI7czoxNzoiYmxvZ19oZWFkaW5nX3NpemUiO3M6MToiMCI7czoxODoiYmxvZ19oZWFkaW5nX2NvbG9yIjtzOjA6IiI7czoxODoiYmxvZ19ib2R5X2gxX2NvbG9yIjtzOjA6IiI7czoxODoiYmxvZ19ib2R5X2gyX2NvbG9yIjtzOjA6IiI7czoxODoiYmxvZ19ib2R5X2gzX2NvbG9yIjtzOjA6IiI7czoxODoiYmxvZ19ib2R5X2g0X2NvbG9yIjtzOjA6IiI7czoxODoiYmxvZ19ib2R5X2g1X2NvbG9yIjtzOjA6IiI7czoxODoiYmxvZ19ib2R5X2g2X2NvbG9yIjtzOjA6IiI7czoxNjoiYmxvZ19ib2R5X3dlaWdodCI7czozOiI0MDAiO3M6MTk6ImJsb2dfYm9keV9mb250X3NpemUiO3M6MToiMCI7czoyMToiYmxvZ19ib2R5X2xpbmVfaGVpZ2h0IjtzOjE6IjAiO3M6MTU6ImJsb2dfYm9keV9jb2xvciI7czowOiIiO3M6MTc6ImJsb2dfYm9keV9hX2NvbG9yIjtzOjA6IiI7czoyMzoiYmxvZ19ib2R5X2FfY29sb3JfaG92ZXIiO3M6MDoiIjtzOjI2OiJibG9nX2JvZHlfc3Ryb25nX3RhZ19jb2xvciI7czowOiIiO3M6MTk6InNpbmdsZV9tZXRhX3NlY3Rpb24iO3M6NDoidHJ1ZSI7czoxODoiZGlhYmxlX3NpbmdsZV90YWdzIjtzOjQ6InRydWUiO3M6MTk6ImFyY2hpdmVfcGFnZV9sYXlvdXQiO3M6NToicmlnaHQiO3M6MTg6ImFyY2hpdmVfbG9vcF9zdHlsZSI7czo2OiJtb2Rlcm4iO3M6MTg6ImFyY2hpdmVfcGFnZV90aXRsZSI7czo4OiJBcmNoaXZlcyI7czoyNDoiYXJjaGl2ZV9kaXNhYmxlX3N1YnRpdGxlIjtzOjQ6InRydWUiO3M6MjU6ImFyY2hpdmVfYmxvZ19pbWFnZV9oZWlnaHQiO3M6MzoiMzUwIjtzOjE3OiJhcmNoaXZlX2Jsb2dfbWV0YSI7czo0OiJ0cnVlIjtzOjI0OiJhcmNoaXZlX3BhZ2luYXRpb25fc3R5bGUiO3M6MToiMSI7czoyNzoibmV3c19kaXNhYmxlX2ZlYXR1cmVkX2ltYWdlIjtzOjQ6InRydWUiO3M6MjY6Im5ld3NfZmVhdHVyZWRfaW1hZ2VfaGVpZ2h0IjtzOjM6IjM0MCI7czo5OiJuZXdzX3NsdWciO3M6MTA6Im5ld3MtcG9zdHMiO3M6MjM6InBvcnRmb2xpb19zaW5nbGVfbGF5b3V0IjtzOjQ6ImZ1bGwiO3M6Mjk6IlBvcnRmb2xpb19zaW5nbGVfaW1hZ2VfaGVpZ2h0IjtzOjM6IjUwMCI7czoyMToic2luZ2xlX3BvcnRmb2xpb19jYXRzIjtzOjU6ImZhbHNlIjtzOjMwOiJlbmFibGVfcG9ydGZvbGlvX3NpbWlsYXJfcG9zdHMiO3M6NDoidHJ1ZSI7czoxOToicG9ydGZvbGlvX25leHRfcHJldiI7czo0OiJ0cnVlIjtzOjMzOiJwb3J0Zm9saW9fcHJldl9uZXh0X3NhbWVfY2F0ZWdvcnkiO3M6NDoidHJ1ZSI7czoyNDoiZW5hYmxlX3BvcnRmb2xpb19jb21tZW50IjtzOjU6ImZhbHNlIjtzOjIzOiJzaW5nbGVfcG9ydGZvbGlvX3NvY2lhbCI7czo0OiJ0cnVlIjtzOjE0OiJwb3J0Zm9saW9fc2x1ZyI7czoxNToicG9ydGZvbGlvLXBvc3RzIjtzOjE4OiJwb3J0Zm9saW9fY2F0X3NsdWciO3M6MTg6InBvcnRmb2xpb19jYXRlZ29yeSI7czoyNDoic3RpY2tfdGVtcGxhdGVfcG9ydGZvbGlvIjtzOjU6ImZhbHNlIjtzOjI0OiJhcmNoaXZlX3BvcnRmb2xpb19sYXlvdXQiO3M6NToicmlnaHQiO3M6MjM6ImFyY2hpdmVfcG9ydGZvbGlvX3N0eWxlIjtzOjc6ImNsYXNzaWMiO3M6MzA6ImFyY2hpdmVfcG9ydGZvbGlvX2ltYWdlX2hlaWdodCI7czozOiI0MDAiO3M6MjQ6ImFyY2hpdmVfcG9ydGZvbGlvX2NvbHVtbiI7czoxOiIzIjtzOjM0OiJhcmNoaXZlX3BvcnRmb2xpb19wYWdpbmF0aW9uX3N0eWxlIjtzOjE6IjEiO3M6MTU6InNob3BfY3VzdG9taXplciI7czo1OiJmYWxzZSI7czoyMDoic2hvcF9hcmNoaXZlX2NvbHVtbnMiO3M6NzoiZGVmYXVsdCI7czoxOToid29vY29tbWVyY2VfY2F0YWxvZyI7czo1OiJmYWxzZSI7czoyMzoid29vX2NhdGVnb3J5X2ltYWdlX3NpemUiO3M6NDoiY3JvcCI7czozMToid29vY29tbWVyY2VfY2F0ZWdvcnlfcGFnZV90aXRsZSI7czo0OiJTaG9wIjtzOjI5OiJ3b29jb21tZXJjZV91c2VfcHJvZHVjdF90aXRsZSI7czo1OiJmYWxzZSI7czozMDoid29vY29tbWVyY2VfdXNlX2NhdGVnb3J5X3RpdGxlIjtzOjU6ImZhbHNlIjtzOjM3OiJ3b29jb21tZXJjZV91c2VfY2F0ZWdvcnlfZmlsdGVyX3RpdGxlIjtzOjU6ImZhbHNlIjtzOjEzOiJzaG9wcGluZ19jYXJ0IjtzOjQ6InRydWUiO3M6MTk6ImFkZF9jYXJ0X3Jlc3BvbnNpdmUiO3M6NDoidHJ1ZSI7czoxOToid29vX2xvb3BfaW1hZ2Vfc2l6ZSI7czo0OiJjcm9wIjtzOjE5OiJ3b29fbG9vcF9pbWdfaGVpZ2h0IjtzOjM6IjMwMCI7czoyNjoid29vY29tbWVyY2VfbG9vcF9zaG93X2Rlc2MiO3M6NToiZmFsc2UiO3M6MjU6Indvb2NvbW1lcmNlX3NpbmdsZV9sYXlvdXQiO3M6NDoiZnVsbCI7czozMjoid29vY29tbWVyY2Vfc2luZ2xlX3Byb2R1Y3RfdGl0bGUiO3M6NDoidHJ1ZSI7czoyMDoid29vX3NpbmdsZV9wcmV2X25leHQiO3M6NDoidHJ1ZSI7czoyNzoid29vX3ByZXZfbmV4dF9zYW1lX2NhdGVnb3J5IjtzOjQ6InRydWUiO3M6MzM6Indvb2NvbW1lcmNlX3NpbmdsZV9zb2NpYWxfbmV0d29yayI7czo0OiJ0cnVlIjtzOjk6Im1pbmlmeS1qcyI7czo0OiJ0cnVlIjtzOjEwOiJtaW5pZnktY3NzIjtzOjQ6InRydWUiO3M6MjU6Im1vdmUtc2hvcnRjb2RlLWNzcy1mb290ZXIiO3M6NDoidHJ1ZSI7czoxNzoicmVtb3ZlLWpzLWNzcy12ZXIiO3M6NDoidHJ1ZSI7czoxNToiZ2xvYmFsX2xhenlsb2FkIjtzOjQ6InRydWUiO3M6MTk6InBvcnRmb2xpby1wb3N0LXR5cGUiO3M6NDoidHJ1ZSI7czoxNDoibmV3cy1wb3N0LXR5cGUiO3M6NDoidHJ1ZSI7czoxMzoiZmFxLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjIxOiJwaG90b19hbGJ1bS1wb3N0LXR5cGUiO3M6NDoidHJ1ZSI7czoxNzoicHJpY2luZy1wb3N0LXR5cGUiO3M6NDoidHJ1ZSI7czoxNzoiY2xpZW50cy1wb3N0LXR5cGUiO3M6NDoidHJ1ZSI7czoxOToiZW1wbG95ZWVzLXBvc3QtdHlwZSI7czo0OiJ0cnVlIjtzOjIxOiJ0ZXN0aW1vbmlhbC1wb3N0LXR5cGUiO3M6NDoidHJ1ZSI7czoyNjoiYW5pbWF0ZWQtY29sdW1ucy1wb3N0LXR5cGUiO3M6NDoidHJ1ZSI7czoxNDoiZWRnZS1wb3N0LXR5cGUiO3M6NDoidHJ1ZSI7czoyMDoidGFiX3NsaWRlci1wb3N0LXR5cGUiO3M6NDoidHJ1ZSI7czoxOToic2xpZGVzaG93LXBvc3QtdHlwZSI7czo1OiJmYWxzZSI7czoyNDoiYmFubmVyX2J1aWxkZXItcG9zdC10eXBlIjtzOjU6ImZhbHNlIjtzOjEwOiJjdXN0b21fY3NzIjtzOjA6IiI7czo5OiJjdXN0b21fanMiO3M6MDoiIjtzOjIwOiJ0aGVtZV9pbXBvcnRfb3B0aW9ucyI7czowOiIiO3M6MTM6Im9iamVjdF9PYmplY3QiO3M6MDoiIjtzOjM1OiJ3b29jb21tZXJjZV9sb29wX2VuYWJsZV9sb3ZlX2J1dHRvbiI7czo0OiJ0cnVlIjtzOjc6Il9zb3VyY2UiO3M6MDoiIjtzOjY6Il9pbWFnZSI7czowOiIiO3M6MTU6Il9jb2xvcl9ncmFkaWVudCI7czowOiIiO3M6NjoiX2NvbG9yIjtzOjA6IiI7czo4OiJfY29sb3JfMiI7czowOiIiO3M6MjE6Il9jb2xvcl9ncmFkaWVudF9zdHlsZSI7czowOiIiO3M6MjE6Il9jb2xvcl9ncmFkaWVudF9hbmdsZSI7czowOiIiO3M6NToiX3NpemUiO3M6MDoiIjtzOjk6Il9wb3NpdGlvbiI7czowOiIiO3M6MTE6Il9hdHRhY2htZW50IjtzOjA6IiI7czo3OiJfcmVwZWF0IjtzOjA6IiI7czoxNDoiYnV0dG9uX2NsaWNrZWQiO3M6MjI6InNhdmVfdGhlbWVfb3B0aW9uc190b3AiO3M6MTg6InRoZW1lX2hlYWRlcl9hbGlnbiI7czo0OiJsZWZ0IjtzOjIwOiJ0aGVtZV90b29sYmFyX3RvZ2dsZSI7czo0OiJ0cnVlIjt9","yes");
INSERT INTO wpcf_options VALUES("312","Jupiter_options","a:447:{s:10:\"skin_color\";s:7:\"#f97352\";s:12:\"smoothscroll\";s:4:\"true\";s:14:\"pages_comments\";s:5:\"false\";s:9:\"go_to_top\";s:4:\"true\";s:13:\"retina_images\";s:4:\"true\";s:17:\"responsive_images\";s:4:\"true\";s:20:\"image_resize_quality\";s:3:\"100\";s:11:\"svg_support\";s:5:\"false\";s:26:\"fullscreen_nav_logo_margin\";s:3:\"125\";s:4:\"logo\";s:0:\"\";s:17:\"light_header_logo\";s:0:\"\";s:18:\"sticky_header_logo\";s:0:\"\";s:15:\"responsive_logo\";s:0:\"\";s:11:\"footer_logo\";s:0:\"\";s:14:\"custom_favicon\";s:0:\"\";s:11:\"iphone_icon\";s:0:\"\";s:18:\"iphone_icon_retina\";s:0:\"\";s:9:\"ipad_icon\";s:0:\"\";s:16:\"ipad_icon_retina\";s:0:\"\";s:9:\"preloader\";s:5:\"false\";s:16:\"retina_preloader\";s:5:\"false\";s:14:\"preloader_logo\";s:0:\"\";s:20:\"preloader_icon_color\";s:7:\"#7c7c7c\";s:18:\"preloader_bg_color\";s:4:\"#fff\";s:23:\"section_preloader_color\";s:4:\"#fff\";s:19:\"preloader_animation\";s:10:\"ball_pulse\";s:21:\"disable_quick_contact\";s:4:\"true\";s:23:\"quick_contact_on_single\";s:4:\"true\";s:21:\"captcha_quick_contact\";s:4:\"true\";s:19:\"quick_contact_email\";s:39:\"admin@thelighthousefoundation.didone.nl\";s:19:\"quick_contact_title\";s:10:\"Contact Us\";s:18:\"quick_contact_desc\";s:89:\"We\'re not around right now. But you can send us an email and we\'ll get back to you, asap.\";s:26:\"quick_contact_gdpr_consent\";s:4:\"true\";s:31:\"quick_contact_gdpr_consent_text\";s:79:\"I consent to The Lighthouse Foundation collecting my details through this form.\";s:20:\"twitter_consumer_key\";s:0:\"\";s:23:\"twitter_consumer_secret\";s:0:\"\";s:20:\"twitter_access_token\";s:0:\"\";s:27:\"twitter_access_token_secret\";s:0:\"\";s:17:\"mailchimp_api_key\";s:0:\"\";s:17:\"mailchimp_list_id\";s:0:\"\";s:15:\"mailchimp_optin\";s:5:\"false\";s:19:\"google_maps_api_key\";s:0:\"\";s:9:\"analytics\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:16:\"third_party_gdpr\";s:5:\"false\";s:31:\"background_selector_orientation\";s:17:\"full_width_layout\";s:10:\"grid_width\";s:4:\"1140\";s:13:\"content_width\";s:2:\"73\";s:18:\"content_responsive\";s:3:\"960\";s:20:\"responsive_nav_width\";s:4:\"1140\";s:19:\"stick_template_page\";s:5:\"false\";s:11:\"body_border\";s:5:\"false\";s:21:\"body_border_thickness\";s:2:\"50\";s:17:\"body_border_color\";s:4:\"#fff\";s:29:\"body_border_on_mobile_devices\";s:5:\"false\";s:24:\"page_title_expand_header\";s:5:\"false\";s:24:\"boxed_layout_shadow_size\";s:1:\"0\";s:29:\"boxed_layout_shadow_intensity\";s:1:\"0\";s:18:\"general_backgounds\";s:5:\"false\";s:20:\"bg_panel_image_style\";s:0:\"\";s:15:\"bg_panel_upload\";s:0:\"\";s:20:\"bg_panel_color_style\";s:0:\"\";s:14:\"bg_panel_color\";s:0:\"\";s:16:\"bg_panel_color_2\";s:0:\"\";s:21:\"grandient_color_style\";s:0:\"\";s:21:\"grandient_color_angle\";s:0:\"\";s:15:\"bg_panel_repeat\";s:0:\"\";s:19:\"bg_panel_attachment\";s:0:\"\";s:17:\"bg_panel_position\";s:0:\"\";s:13:\"bg_panel_size\";s:0:\"\";s:10:\"body_color\";s:4:\"#fff\";s:19:\"body_color_gradient\";s:6:\"single\";s:12:\"body_color_2\";s:0:\"\";s:25:\"body_color_gradient_style\";s:6:\"linear\";s:25:\"body_color_gradient_angle\";s:8:\"vertical\";s:10:\"body_image\";s:0:\"\";s:9:\"body_size\";s:5:\"false\";s:13:\"body_position\";s:0:\"\";s:15:\"body_attachment\";s:0:\"\";s:11:\"body_repeat\";s:0:\"\";s:11:\"body_source\";s:8:\"no-image\";s:10:\"page_color\";s:4:\"#fff\";s:19:\"page_color_gradient\";s:6:\"single\";s:12:\"page_color_2\";s:0:\"\";s:25:\"page_color_gradient_style\";s:6:\"linear\";s:25:\"page_color_gradient_angle\";s:8:\"vertical\";s:10:\"page_image\";s:0:\"\";s:9:\"page_size\";s:5:\"false\";s:13:\"page_position\";s:0:\"\";s:15:\"page_attachment\";s:0:\"\";s:11:\"page_repeat\";s:0:\"\";s:11:\"page_source\";s:8:\"no-image\";s:12:\"header_color\";s:4:\"#fff\";s:21:\"header_color_gradient\";s:6:\"single\";s:14:\"header_color_2\";s:0:\"\";s:27:\"header_color_gradient_style\";s:6:\"linear\";s:27:\"header_color_gradient_angle\";s:8:\"vertical\";s:12:\"header_image\";s:0:\"\";s:11:\"header_size\";s:5:\"false\";s:15:\"header_position\";s:0:\"\";s:17:\"header_attachment\";s:0:\"\";s:13:\"header_repeat\";s:0:\"\";s:13:\"header_source\";s:8:\"no-image\";s:12:\"banner_color\";s:7:\"#f7f7f7\";s:21:\"banner_color_gradient\";s:6:\"single\";s:14:\"banner_color_2\";s:0:\"\";s:27:\"banner_color_gradient_style\";s:6:\"linear\";s:27:\"banner_color_gradient_angle\";s:8:\"vertical\";s:12:\"banner_image\";s:0:\"\";s:11:\"banner_size\";s:4:\"true\";s:15:\"banner_position\";s:0:\"\";s:17:\"banner_attachment\";s:0:\"\";s:13:\"banner_repeat\";s:0:\"\";s:13:\"banner_source\";s:8:\"no-image\";s:12:\"footer_color\";s:7:\"#3d4045\";s:21:\"footer_color_gradient\";s:6:\"single\";s:14:\"footer_color_2\";s:0:\"\";s:27:\"footer_color_gradient_style\";s:6:\"linear\";s:27:\"footer_color_gradient_angle\";s:8:\"vertical\";s:12:\"footer_image\";s:0:\"\";s:11:\"footer_size\";s:5:\"false\";s:15:\"footer_position\";s:0:\"\";s:17:\"footer_attachment\";s:0:\"\";s:13:\"footer_repeat\";s:0:\"\";s:13:\"footer_source\";s:8:\"no-image\";s:11:\"body_weight\";s:3:\"400\";s:14:\"body_font_size\";s:2:\"14\";s:16:\"body_line_height\";s:4:\"1.66\";s:15:\"body_text_color\";s:7:\"#777777\";s:7:\"a_color\";s:7:\"#2e2e2e\";s:13:\"a_color_hover\";s:7:\"#f97352\";s:12:\"strong_color\";s:7:\"#f97352\";s:6:\"p_size\";s:2:\"16\";s:13:\"p_line_height\";s:4:\"1.66\";s:7:\"p_color\";s:7:\"#777777\";s:20:\"headings_line_height\";s:3:\"1.3\";s:9:\"h1_weight\";s:3:\"600\";s:12:\"h1_transform\";s:9:\"uppercase\";s:7:\"h1_size\";s:2:\"36\";s:8:\"h1_color\";s:7:\"#404040\";s:9:\"h2_weight\";s:3:\"600\";s:12:\"h2_transform\";s:9:\"uppercase\";s:7:\"h2_size\";s:2:\"30\";s:8:\"h2_color\";s:7:\"#404040\";s:9:\"h3_weight\";s:3:\"600\";s:12:\"h3_transform\";s:9:\"uppercase\";s:7:\"h3_size\";s:2:\"24\";s:8:\"h3_color\";s:7:\"#404040\";s:9:\"h4_weight\";s:3:\"600\";s:12:\"h4_transform\";s:9:\"uppercase\";s:7:\"h4_size\";s:2:\"18\";s:8:\"h4_color\";s:7:\"#404040\";s:9:\"h5_weight\";s:3:\"600\";s:12:\"h5_transform\";s:9:\"uppercase\";s:7:\"h5_size\";s:2:\"16\";s:8:\"h5_color\";s:7:\"#404040\";s:9:\"h6_weight\";s:3:\"600\";s:12:\"h6_transform\";s:9:\"uppercase\";s:7:\"h6_size\";s:2:\"14\";s:8:\"h6_color\";s:7:\"#404040\";s:21:\"header_layout_builder\";s:16:\"pre_built_header\";s:18:\"theme_header_style\";s:1:\"1\";s:14:\"secondary_menu\";s:10:\"fullscreen\";s:18:\"header_burger_size\";s:5:\"small\";s:23:\"seondary_header_for_all\";s:5:\"false\";s:18:\"vertical_menu_anim\";s:1:\"1\";s:26:\"vertical_header_logo_align\";s:6:\"center\";s:28:\"vertical_header_logo_padding\";s:2:\"10\";s:21:\"vertical_header_align\";s:4:\"left\";s:23:\"vertical_menu_copyright\";s:41:\"Copyright All Rights Reserved &copy; 2017\";s:11:\"header_grid\";s:4:\"true\";s:16:\"hide_header_logo\";s:4:\"true\";s:14:\"logo_in_middle\";s:5:\"false\";s:15:\"hide_header_nav\";s:4:\"true\";s:22:\"header_search_location\";s:17:\"fullscreen_search\";s:22:\"header_start_tour_text\";s:0:\"\";s:22:\"header_start_tour_page\";s:0:\"\";s:15:\"start_tour_size\";s:2:\"14\";s:13:\"loggedin_menu\";s:11:\"fourth-menu\";s:13:\"header_height\";s:2:\"90\";s:17:\"res_header_height\";s:2:\"90\";s:14:\"header_opacity\";s:1:\"1\";s:27:\"header_btn_border_thickness\";s:1:\"1\";s:19:\"header_border_color\";s:7:\"#ededed\";s:16:\"start_tour_color\";s:4:\"#333\";s:19:\"header_burger_color\";s:0:\"\";s:17:\"main_nav_bg_color\";s:0:\"\";s:14:\"main_nav_hover\";s:1:\"1\";s:19:\"main_nav_top_weight\";s:3:\"600\";s:19:\"main_menu_transform\";s:9:\"uppercase\";s:17:\"main_nav_top_size\";s:2:\"13\";s:27:\"main_nav_top_letter_spacing\";s:1:\"0\";s:19:\"main_nav_item_space\";s:2:\"20\";s:23:\"main_nav_top_text_color\";s:7:\"#444444\";s:23:\"main_nav_top_hover_skin\";s:7:\"#f97352\";s:28:\"main_nav_top_hover_txt_color\";s:4:\"#fff\";s:19:\"main_nav_sub_weight\";s:3:\"400\";s:22:\"main_nav_sub_transform\";s:9:\"uppercase\";s:17:\"main_nav_sub_size\";s:2:\"12\";s:27:\"main_nav_sub_letter_spacing\";s:1:\"1\";s:23:\"main_nav_sub_text_color\";s:7:\"#b3b3b3\";s:29:\"main_nav_sub_text_color_hover\";s:7:\"#ffffff\";s:27:\"main_nav_sub_hover_bg_color\";s:0:\"\";s:29:\"main_nav_sub_border_top_color\";s:7:\"#f97352\";s:21:\"main_nav_sub_bg_color\";s:7:\"#333333\";s:23:\"main_nav_sub_icon_color\";s:7:\"#e0e0e0\";s:14:\"nav_sub_shadow\";s:5:\"false\";s:26:\"sub_level_box_border_color\";s:0:\"\";s:18:\"main_nav_sub_width\";s:3:\"230\";s:25:\"main_nav_mega_title_color\";s:7:\"#ffffff\";s:23:\"mega_menu_divider_color\";s:0:\"\";s:22:\"header_social_location\";s:0:\"\";s:27:\"header_social_networks_site\";s:0:\"\";s:26:\"header_social_networks_url\";s:0:\"\";s:28:\"header_social_networks_style\";s:6:\"circle\";s:16:\"header_icon_size\";s:5:\"small\";s:19:\"header_social_color\";s:7:\"#999999\";s:25:\"header_social_hover_color\";s:4:\"#ccc\";s:27:\"header_social_bg_main_color\";s:7:\"#232323\";s:22:\"header_social_bg_color\";s:7:\"#232323\";s:26:\"header_social_border_color\";s:7:\"#999999\";s:16:\"header_mobile_bg\";s:0:\"\";s:20:\"responsive_nav_color\";s:4:\"#fff\";s:29:\"header_mobile_search_input_bg\";s:0:\"\";s:32:\"header_mobile_search_input_color\";s:0:\"\";s:24:\"responsive_nav_txt_color\";s:7:\"#444444\";s:19:\"header_sticky_style\";s:5:\"fixed\";s:20:\"sticky_header_offset\";s:6:\"header\";s:20:\"header_scroll_height\";s:2:\"55\";s:21:\"header_sticky_opacity\";s:1:\"1\";s:26:\"sticky_header_border_color\";s:0:\"\";s:13:\"dash_bg_color\";s:4:\"#444\";s:25:\"dash_top_menu_text_weight\";s:3:\"600\";s:23:\"dash_top_menu_transform\";s:9:\"uppercase\";s:23:\"dash_top_menu_text_size\";s:2:\"13\";s:19:\"dash_nav_link_color\";s:4:\"#fff\";s:25:\"dash_nav_link_hover_color\";s:4:\"#fff\";s:23:\"dash_nav_bg_hover_color\";s:0:\"\";s:25:\"dash_sub_menu_text_weight\";s:3:\"400\";s:23:\"dash_sub_menu_transform\";s:9:\"uppercase\";s:23:\"dash_sub_menu_text_size\";s:2:\"12\";s:17:\"dash_title_weight\";s:6:\"bolder\";s:20:\"dash_title_transform\";s:9:\"uppercase\";s:15:\"dash_title_size\";s:2:\"14\";s:16:\"dash_title_color\";s:4:\"#fff\";s:16:\"dash_text_weight\";s:3:\"400\";s:14:\"dash_text_size\";s:2:\"12\";s:15:\"dash_text_color\";s:4:\"#eee\";s:16:\"dash_links_color\";s:7:\"#fafafa\";s:22:\"dash_links_hover_color\";s:0:\"\";s:19:\"fullscreen_nav_logo\";s:4:\"dark\";s:26:\"fullscreen_nav_mobile_logo\";s:4:\"dark\";s:33:\"fullscreen_nav_mobile_logo_custom\";s:0:\"\";s:23:\"fullscreen_nav_bg_color\";s:4:\"#444\";s:25:\"fullscreen_close_btn_skin\";s:5:\"light\";s:31:\"fullscreen_nav_menu_font_weight\";s:6:\"bolder\";s:34:\"fullscreen_nav_menu_text_transform\";s:9:\"uppercase\";s:29:\"fullscreen_nav_menu_font_size\";s:2:\"16\";s:34:\"fullscreen_nav_menu_letter_spacing\";s:1:\"0\";s:26:\"fullscreen_nav_menu_gutter\";s:2:\"25\";s:25:\"fullscreen_nav_link_color\";s:4:\"#fff\";s:29:\"fullscreen_nav_link_hov_color\";s:4:\"#444\";s:32:\"fullscreen_nav_link_hov_bg_color\";s:4:\"#fff\";s:18:\"enable_header_date\";s:5:\"false\";s:22:\"header_toolbar_tagline\";s:0:\"\";s:20:\"header_toolbar_login\";s:4:\"true\";s:24:\"header_toolbar_subscribe\";s:5:\"false\";s:20:\"header_toolbar_email\";s:0:\"\";s:20:\"header_toolbar_phone\";s:0:\"\";s:17:\"header_toolbar_bg\";s:7:\"#ffffff\";s:24:\"header_mobile_toolbar_bg\";s:0:\"\";s:27:\"header_toolbar_border_color\";s:0:\"\";s:30:\"header_toolbar_search_input_bg\";s:0:\"\";s:24:\"header_toolbar_txt_color\";s:7:\"#999999\";s:25:\"header_toolbar_link_color\";s:7:\"#999999\";s:31:\"header_toolbar_search_input_txt\";s:7:\"#c7c7c7\";s:27:\"header_mobile_toolbar_color\";s:0:\"\";s:32:\"header_mobile_toolbar_link_color\";s:0:\"\";s:35:\"header_toolbar_social_network_color\";s:7:\"#999999\";s:34:\"header_mobile_toolbar_social_color\";s:0:\"\";s:17:\"page_title_global\";s:4:\"true\";s:19:\"banner_border_color\";s:7:\"#ededed\";s:21:\"page_introduce_weight\";s:3:\"400\";s:20:\"page_title_transform\";s:9:\"uppercase\";s:25:\"page_introduce_title_size\";s:2:\"20\";s:35:\"page_introduce_title_letter_spacing\";s:1:\"2\";s:16:\"page_title_color\";s:7:\"#4d4d4d\";s:17:\"page_title_shadow\";s:5:\"false\";s:28:\"page_introduce_subtitle_size\";s:2:\"14\";s:33:\"page_introduce_subtitle_transform\";s:4:\"none\";s:19:\"page_subtitle_color\";s:7:\"#a3a3a3\";s:18:\"disable_breadcrumb\";s:4:\"true\";s:15:\"breadcrumb_skin\";s:4:\"dark\";s:5:\"fonts\";a:1:{i:0;a:6:{s:4:\"type\";s:4:\"safe\";s:10:\"fontFamily\";s:28:\"Arial, Helvetica, sans-serif\";s:8:\"elements\";a:1:{i:0;s:4:\"body\";}s:6:\"subset\";s:0:\"\";s:12:\"currentField\";s:10:\"font-alert\";s:7:\"default\";s:4:\"true\";}}s:14:\"disable_footer\";s:4:\"true\";s:21:\"footer_disable_mobile\";s:5:\"false\";s:12:\"boxed_footer\";s:4:\"true\";s:11:\"footer_type\";s:1:\"1\";s:14:\"footer_columns\";s:1:\"4\";s:20:\"footer_top_thickness\";s:1:\"0\";s:23:\"footer_top_border_color\";s:0:\"\";s:13:\"footer_gutter\";s:1:\"2\";s:22:\"footer_wrapper_padding\";s:2:\"30\";s:27:\"footer_widget_margin_bottom\";s:2:\"40\";s:19:\"footer_title_weight\";s:6:\"bolder\";s:22:\"footer_title_transform\";s:9:\"uppercase\";s:17:\"footer_title_size\";s:2:\"14\";s:18:\"footer_title_color\";s:4:\"#fff\";s:18:\"footer_text_weight\";s:3:\"400\";s:16:\"footer_text_size\";s:2:\"14\";s:17:\"footer_text_color\";s:7:\"#808080\";s:18:\"footer_links_color\";s:7:\"#999999\";s:24:\"footer_links_hover_color\";s:0:\"\";s:18:\"disable_sub_footer\";s:4:\"true\";s:17:\"enable_footer_nav\";s:4:\"true\";s:9:\"copyright\";s:41:\"Copyright All Rights Reserved &copy; 2017\";s:19:\"sub_footer_bg_color\";s:7:\"#43474d\";s:14:\"copyright_size\";s:2:\"11\";s:24:\"copyright_letter_spacing\";s:1:\"1\";s:25:\"sub_footer_nav_copy_color\";s:7:\"#8c8e91\";s:15:\"custom_sidebars\";s:0:\"\";s:20:\"sidebar_title_weight\";s:6:\"bolder\";s:23:\"sidebar_title_transform\";s:9:\"uppercase\";s:18:\"sidebar_title_size\";s:2:\"14\";s:19:\"sidebar_title_color\";s:7:\"#333333\";s:19:\"sidebar_text_weight\";s:3:\"400\";s:17:\"sidebar_text_size\";s:2:\"14\";s:18:\"sidebar_text_color\";s:7:\"#999999\";s:19:\"sidebar_links_color\";s:7:\"#999999\";s:25:\"sidebar_links_hover_color\";s:0:\"\";s:18:\"search_page_layout\";s:5:\"right\";s:17:\"search_page_title\";s:6:\"Search\";s:23:\"search_disable_subtitle\";s:4:\"true\";s:13:\"single_layout\";s:4:\"full\";s:17:\"single_blog_style\";s:7:\"compact\";s:28:\"single_bold_hero_full_height\";s:4:\"true\";s:29:\"single_disable_featured_image\";s:4:\"true\";s:23:\"bold_single_hero_height\";s:3:\"800\";s:28:\"single_featured_image_height\";s:3:\"300\";s:20:\"blog_single_img_crop\";s:4:\"true\";s:17:\"blog_single_title\";s:4:\"true\";s:14:\"blog_prev_next\";s:4:\"true\";s:28:\"blog_prev_next_same_category\";s:4:\"true\";s:27:\"enable_single_related_posts\";s:4:\"true\";s:20:\"blog_single_comments\";s:4:\"true\";s:18:\"enable_blog_author\";s:4:\"true\";s:18:\"single_blog_social\";s:4:\"true\";s:19:\"blog_heading_weight\";s:3:\"600\";s:22:\"blog_heading_transform\";s:0:\"\";s:17:\"blog_heading_size\";s:1:\"0\";s:18:\"blog_heading_color\";s:0:\"\";s:18:\"blog_body_h1_color\";s:0:\"\";s:18:\"blog_body_h2_color\";s:0:\"\";s:18:\"blog_body_h3_color\";s:0:\"\";s:18:\"blog_body_h4_color\";s:0:\"\";s:18:\"blog_body_h5_color\";s:0:\"\";s:18:\"blog_body_h6_color\";s:0:\"\";s:16:\"blog_body_weight\";s:3:\"400\";s:19:\"blog_body_font_size\";s:1:\"0\";s:21:\"blog_body_line_height\";s:1:\"0\";s:15:\"blog_body_color\";s:0:\"\";s:17:\"blog_body_a_color\";s:0:\"\";s:23:\"blog_body_a_color_hover\";s:0:\"\";s:26:\"blog_body_strong_tag_color\";s:0:\"\";s:19:\"single_meta_section\";s:4:\"true\";s:18:\"diable_single_tags\";s:4:\"true\";s:19:\"archive_page_layout\";s:5:\"right\";s:18:\"archive_loop_style\";s:6:\"modern\";s:18:\"archive_page_title\";s:8:\"Archives\";s:24:\"archive_disable_subtitle\";s:4:\"true\";s:25:\"archive_blog_image_height\";s:3:\"350\";s:17:\"archive_blog_meta\";s:4:\"true\";s:24:\"archive_pagination_style\";s:1:\"1\";s:27:\"news_disable_featured_image\";s:4:\"true\";s:26:\"news_featured_image_height\";s:3:\"340\";s:9:\"news_slug\";s:10:\"news-posts\";s:23:\"portfolio_single_layout\";s:4:\"full\";s:29:\"Portfolio_single_image_height\";s:3:\"500\";s:21:\"single_portfolio_cats\";s:5:\"false\";s:30:\"enable_portfolio_similar_posts\";s:4:\"true\";s:19:\"portfolio_next_prev\";s:4:\"true\";s:33:\"portfolio_prev_next_same_category\";s:4:\"true\";s:24:\"enable_portfolio_comment\";s:5:\"false\";s:23:\"single_portfolio_social\";s:4:\"true\";s:14:\"portfolio_slug\";s:15:\"portfolio-posts\";s:18:\"portfolio_cat_slug\";s:18:\"portfolio_category\";s:24:\"stick_template_portfolio\";s:5:\"false\";s:24:\"archive_portfolio_layout\";s:5:\"right\";s:23:\"archive_portfolio_style\";s:7:\"classic\";s:30:\"archive_portfolio_image_height\";s:3:\"400\";s:24:\"archive_portfolio_column\";s:1:\"3\";s:34:\"archive_portfolio_pagination_style\";s:1:\"1\";s:15:\"shop_customizer\";s:5:\"false\";s:20:\"shop_archive_columns\";s:7:\"default\";s:19:\"woocommerce_catalog\";s:5:\"false\";s:23:\"woo_category_image_size\";s:4:\"crop\";s:31:\"woocommerce_category_page_title\";s:4:\"Shop\";s:29:\"woocommerce_use_product_title\";s:5:\"false\";s:30:\"woocommerce_use_category_title\";s:5:\"false\";s:37:\"woocommerce_use_category_filter_title\";s:5:\"false\";s:13:\"shopping_cart\";s:4:\"true\";s:19:\"add_cart_responsive\";s:4:\"true\";s:19:\"woo_loop_image_size\";s:4:\"crop\";s:19:\"woo_loop_img_height\";s:3:\"300\";s:26:\"woocommerce_loop_show_desc\";s:5:\"false\";s:25:\"woocommerce_single_layout\";s:4:\"full\";s:32:\"woocommerce_single_product_title\";s:4:\"true\";s:20:\"woo_single_prev_next\";s:4:\"true\";s:27:\"woo_prev_next_same_category\";s:4:\"true\";s:33:\"woocommerce_single_social_network\";s:4:\"true\";s:9:\"minify-js\";s:4:\"true\";s:10:\"minify-css\";s:4:\"true\";s:25:\"move-shortcode-css-footer\";s:4:\"true\";s:17:\"remove-js-css-ver\";s:4:\"true\";s:15:\"global_lazyload\";s:4:\"true\";s:19:\"portfolio-post-type\";s:4:\"true\";s:14:\"news-post-type\";s:4:\"true\";s:13:\"faq-post-type\";s:4:\"true\";s:21:\"photo_album-post-type\";s:4:\"true\";s:17:\"pricing-post-type\";s:4:\"true\";s:17:\"clients-post-type\";s:4:\"true\";s:19:\"employees-post-type\";s:4:\"true\";s:21:\"testimonial-post-type\";s:4:\"true\";s:26:\"animated-columns-post-type\";s:4:\"true\";s:14:\"edge-post-type\";s:4:\"true\";s:20:\"tab_slider-post-type\";s:4:\"true\";s:19:\"slideshow-post-type\";s:5:\"false\";s:24:\"banner_builder-post-type\";s:5:\"false\";s:10:\"custom_css\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:20:\"theme_import_options\";s:0:\"\";s:13:\"object_Object\";s:0:\"\";s:35:\"woocommerce_loop_enable_love_button\";s:4:\"true\";s:7:\"_source\";s:0:\"\";s:6:\"_image\";s:0:\"\";s:15:\"_color_gradient\";s:0:\"\";s:6:\"_color\";s:0:\"\";s:8:\"_color_2\";s:0:\"\";s:21:\"_color_gradient_style\";s:0:\"\";s:21:\"_color_gradient_angle\";s:0:\"\";s:5:\"_size\";s:0:\"\";s:9:\"_position\";s:0:\"\";s:11:\"_attachment\";s:0:\"\";s:7:\"_repeat\";s:0:\"\";s:14:\"button_clicked\";s:22:\"save_theme_options_top\";s:18:\"theme_header_align\";s:4:\"left\";s:20:\"theme_toolbar_toggle\";s:4:\"true\";}","yes");
INSERT INTO wpcf_options VALUES("301","widget_recent_portfolio","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("302","widget_recent_posts","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("303","widget_related_posts","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("311","mkhb_global_header","7887","yes");
INSERT INTO wpcf_options VALUES("346","Jupiter_options_revision_1542384683","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","yes");



CREATE TABLE `wpcf_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1944 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_postmeta VALUES("1","87","_wp_attached_file","2016/05/juevers_homepage_header.jpg");
INSERT INTO wpcf_postmeta VALUES("2","87","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1440;s:6:\"height\";i:960;s:4:\"file\";s:35:\"2016/05/juevers_homepage_header.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"juevers_homepage_header-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:35:\"juevers_homepage_header-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:35:\"juevers_homepage_header-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:36:\"juevers_homepage_header-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"landscape-tablet\";a:6:{s:4:\"file\";s:36:\"juevers_homepage_header-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:1024;s:12:\"height_query\";i:768;}s:16:\"landscape-mobile\";a:6:{s:4:\"file\";s:35:\"juevers_homepage_header-736x414.jpg\";s:5:\"width\";i:736;s:6:\"height\";i:414;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:736;s:12:\"height_query\";i:414;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("3","87","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:94.2900000000000062527760746888816356658935546875;s:5:\"bytes\";i:116152;s:11:\"size_before\";i:2023306;s:10:\"size_after\";i:115596;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.70000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:345;s:11:\"size_before\";i:7339;s:10:\"size_after\";i:6994;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.279999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:1122;s:11:\"size_before\";i:17115;s:10:\"size_after\";i:16554;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.61000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:4447;s:11:\"size_before\";i:79199;s:10:\"size_after\";i:74752;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.730000000000000426325641456060111522674560546875;s:5:\"bytes\";i:14042;s:11:\"size_before\";i:122617;s:10:\"size_after\";i:115596;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6994;s:10:\"size_after\";i:6994;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.089999999999999857891452847979962825775146484375;s:5:\"bytes\";i:2988;s:11:\"size_before\";i:58733;s:10:\"size_after\";i:55745;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.2599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:8075;s:11:\"size_before\";i:153656;s:10:\"size_after\";i:145581;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.3300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:283;s:11:\"size_before\";i:5312;s:10:\"size_after\";i:5029;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.089999999999999857891452847979962825775146484375;s:5:\"bytes\";i:2610;s:11:\"size_before\";i:51297;s:10:\"size_after\";i:48687;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:48687;s:10:\"size_after\";i:48687;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.62999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:528;s:11:\"size_before\";i:14543;s:10:\"size_after\";i:14015;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.470000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:406;s:11:\"size_before\";i:11704;s:10:\"size_after\";i:11298;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.9900000000000002131628207280300557613372802734375;s:5:\"bytes\";i:1786;s:11:\"size_before\";i:35819;s:10:\"size_after\";i:34033;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.479999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:711;s:11:\"size_before\";i:20458;s:10:\"size_after\";i:19747;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.470000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:455;s:11:\"size_before\";i:13110;s:10:\"size_after\";i:12655;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.94000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:2021;s:11:\"size_before\";i:40894;s:10:\"size_after\";i:38873;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.5;s:5:\"bytes\";i:488;s:11:\"size_before\";i:13951;s:10:\"size_after\";i:13463;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.04000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:2207;s:11:\"size_before\";i:43789;s:10:\"size_after\";i:41582;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.519999999999999573674358543939888477325439453125;s:5:\"bytes\";i:1040;s:11:\"size_before\";i:23016;s:10:\"size_after\";i:21976;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.37000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:2218;s:11:\"size_before\";i:41305;s:10:\"size_after\";i:39087;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.1500000000000003552713678800500929355621337890625;s:5:\"bytes\";i:2743;s:11:\"size_before\";i:53300;s:10:\"size_after\";i:50557;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.9000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:2214;s:11:\"size_before\";i:37508;s:10:\"size_after\";i:35294;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.17999999999999971578290569595992565155029296875;s:5:\"bytes\";i:3458;s:11:\"size_before\";i:66704;s:10:\"size_after\";i:63246;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.80999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:5920;s:11:\"size_before\";i:101852;s:10:\"size_after\";i:95932;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.4199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:2693;s:11:\"size_before\";i:49686;s:10:\"size_after\";i:46993;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.660000000000000142108547152020037174224853515625;s:5:\"bytes\";i:6518;s:11:\"size_before\";i:115073;s:10:\"size_after\";i:108555;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:63246;s:10:\"size_after\";i:63246;s:4:\"time\";d:0.1499999999999999944488848768742172978818416595458984375;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:108555;s:10:\"size_after\";i:108555;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.730000000000000426325641456060111522674560546875;s:5:\"bytes\";i:7362;s:11:\"size_before\";i:128384;s:10:\"size_after\";i:121022;s:4:\"time\";d:0.179999999999999993338661852249060757458209991455078125;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6;s:5:\"bytes\";i:5670;s:11:\"size_before\";i:94472;s:10:\"size_after\";i:88802;s:4:\"time\";d:0.200000000000000011102230246251565404236316680908203125;}s:25:\"portfolio-two_x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.4000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:9253;s:11:\"size_before\";i:171219;s:10:\"size_after\";i:161966;s:4:\"time\";d:0.25;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:121022;s:10:\"size_after\";i:121022;s:4:\"time\";d:0.2099999999999999922284388276239042170345783233642578125;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.0099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1318;s:11:\"size_before\";i:26333;s:10:\"size_after\";i:25015;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.20999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1919;s:11:\"size_before\";i:36825;s:10:\"size_after\";i:34906;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.4199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:4071;s:11:\"size_before\";i:75104;s:10:\"size_after\";i:71033;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.54000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:3105;s:11:\"size_before\";i:56058;s:10:\"size_after\";i:52953;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:115596;s:10:\"size_after\";i:115596;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.410000000000000142108547152020037174224853515625;s:5:\"bytes\";i:3121;s:11:\"size_before\";i:57716;s:10:\"size_after\";i:54595;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:16:\"portrait-desktop\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.70000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:9643;s:11:\"size_before\";i:169146;s:10:\"size_after\";i:159503;s:4:\"time\";d:0.2399999999999999911182158029987476766109466552734375;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:74752;s:10:\"size_after\";i:74752;s:4:\"time\";d:0.1700000000000000122124532708767219446599483489990234375;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.55999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:1372;s:11:\"size_before\";i:30069;s:10:\"size_after\";i:28697;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}}}");
INSERT INTO wpcf_postmeta VALUES("4","97","_wp_attached_file","2016/05/home_layout_left.jpg");
INSERT INTO wpcf_postmeta VALUES("5","97","_wp_attachment_metadata","a:5:{s:5:\"width\";i:720;s:6:\"height\";i:698;s:4:\"file\";s:28:\"2016/05/home_layout_left.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"home_layout_left-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"home_layout_left-300x291.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:291;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("6","97","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:98;s:5:\"bytes\";i:25556;s:11:\"size_before\";i:731175;s:10:\"size_after\";i:14589;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:35:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.430000000000000159872115546022541821002960205078125;s:5:\"bytes\";i:181;s:11:\"size_before\";i:5277;s:10:\"size_after\";i:5096;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.149999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:950;s:11:\"size_before\";i:15064;s:10:\"size_after\";i:14589;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5096;s:10:\"size_after\";i:5096;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.399999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:1432;s:11:\"size_before\";i:42068;s:10:\"size_after\";i:40636;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:165;s:11:\"size_before\";i:4254;s:10:\"size_after\";i:4089;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.2400000000000002131628207280300557613372802734375;s:5:\"bytes\";i:1172;s:11:\"size_before\";i:36137;s:10:\"size_after\";i:34965;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:34965;s:10:\"size_after\";i:34965;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:372;s:11:\"size_before\";i:9902;s:10:\"size_after\";i:9530;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.62000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:291;s:11:\"size_before\";i:8041;s:10:\"size_after\";i:7750;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.520000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:870;s:11:\"size_before\";i:24710;s:10:\"size_after\";i:23840;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.5099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:444;s:11:\"size_before\";i:12640;s:10:\"size_after\";i:12196;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.75;s:5:\"bytes\";i:355;s:11:\"size_before\";i:9478;s:10:\"size_after\";i:9123;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.279999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:962;s:11:\"size_before\";i:29343;s:10:\"size_after\";i:28381;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.819999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:378;s:11:\"size_before\";i:9901;s:10:\"size_after\";i:9523;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.2599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1000;s:11:\"size_before\";i:30699;s:10:\"size_after\";i:29699;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.479999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:537;s:11:\"size_before\";i:15446;s:10:\"size_after\";i:14909;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.279999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:987;s:11:\"size_before\";i:30124;s:10:\"size_after\";i:29137;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.62999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:1414;s:11:\"size_before\";i:38914;s:10:\"size_after\";i:37500;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.70999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:611;s:11:\"size_before\";i:22551;s:10:\"size_after\";i:21940;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.29000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:1589;s:11:\"size_before\";i:48277;s:10:\"size_after\";i:46688;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.339999999999999857891452847979962825775146484375;s:5:\"bytes\";i:2212;s:11:\"size_before\";i:66184;s:10:\"size_after\";i:63972;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:37500;s:10:\"size_after\";i:37500;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:63972;s:10:\"size_after\";i:63972;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:46688;s:10:\"size_after\";i:46688;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:63972;s:10:\"size_after\";i:63972;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:63972;s:10:\"size_after\";i:63972;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.149999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:1826;s:11:\"size_before\";i:57961;s:10:\"size_after\";i:56135;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:63972;s:10:\"size_after\";i:63972;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.939999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:934;s:11:\"size_before\";i:23713;s:10:\"size_after\";i:22779;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.8300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1219;s:11:\"size_before\";i:31860;s:10:\"size_after\";i:30641;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:2340;s:11:\"size_before\";i:60435;s:10:\"size_after\";i:58095;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.310000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:1501;s:11:\"size_before\";i:45355;s:10:\"size_after\";i:43854;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.430000000000000159872115546022541821002960205078125;s:5:\"bytes\";i:926;s:11:\"size_before\";i:27017;s:10:\"size_after\";i:26091;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.439999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:888;s:11:\"size_before\";i:25824;s:10:\"size_after\";i:24936;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:87441;s:10:\"size_after\";i:87441;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}}}");
INSERT INTO wpcf_postmeta VALUES("8","110","_wp_attached_file","2016/05/josh-wolf-testimonial-150x150.jpg");
INSERT INTO wpcf_postmeta VALUES("9","110","_wp_attachment_metadata","a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:41:\"2016/05/josh-wolf-testimonial-150x150.jpg\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("10","110","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:51.1400000000000005684341886080801486968994140625;s:5:\"bytes\";i:2274;s:11:\"size_before\";i:13882;s:10:\"size_after\";i:6783;s:4:\"time\";i:0;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:4:{s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:332;s:11:\"size_before\";i:4835;s:10:\"size_after\";i:4503;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.87999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:1160;s:11:\"size_before\";i:7363;s:10:\"size_after\";i:6783;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6783;s:10:\"size_after\";i:6783;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.6400000000000005684341886080801486968994140625;s:5:\"bytes\";i:782;s:11:\"size_before\";i:9047;s:10:\"size_after\";i:8265;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}}}");
INSERT INTO wpcf_postmeta VALUES("12","113","_wp_attached_file","2016/05/mucahit-gayiran-testimonial-150x150.png");
INSERT INTO wpcf_postmeta VALUES("13","113","_wp_attachment_metadata","a:5:{s:5:\"width\";i:150;s:6:\"height\";i:150;s:4:\"file\";s:47:\"2016/05/mucahit-gayiran-testimonial-150x150.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("14","113","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:1.399999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:582;s:11:\"size_before\";i:20743;s:10:\"size_after\";i:20452;s:4:\"time\";i:0;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:4:{s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:17164;s:10:\"size_after\";i:17164;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.399999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:582;s:11:\"size_before\";i:20743;s:10:\"size_after\";i:20452;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:20452;s:10:\"size_after\";i:20452;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:13179;s:10:\"size_after\";i:13179;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}}}");
INSERT INTO wpcf_postmeta VALUES("16","119","_wp_attached_file","2016/05/ask_question_bg.jpg");
INSERT INTO wpcf_postmeta VALUES("17","119","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1440;s:6:\"height\";i:960;s:4:\"file\";s:27:\"2016/05/ask_question_bg.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"ask_question_bg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"ask_question_bg-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:27:\"ask_question_bg-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:28:\"ask_question_bg-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"landscape-tablet\";a:6:{s:4:\"file\";s:28:\"ask_question_bg-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:1024;s:12:\"height_query\";i:768;}s:16:\"landscape-mobile\";a:6:{s:4:\"file\";s:27:\"ask_question_bg-736x414.jpg\";s:5:\"width\";i:736;s:6:\"height\";i:414;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:736;s:12:\"height_query\";i:414;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("18","119","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:2.383080613786670909348686109296977519989013671875;s:5:\"bytes\";i:36765;s:11:\"size_before\";i:1542751;s:10:\"size_after\";i:1505986;s:4:\"time\";d:2.5800000000000000710542735760100185871124267578125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.5999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:307;s:11:\"size_before\";i:6674;s:10:\"size_after\";i:6367;s:4:\"time\";d:0.429999999999999993338661852249060757458209991455078125;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.05999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:563;s:11:\"size_before\";i:13861;s:10:\"size_after\";i:13298;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.9699999999999999733546474089962430298328399658203125;s:5:\"bytes\";i:1098;s:11:\"size_before\";i:55714;s:10:\"size_after\";i:54616;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.8899999999999999023003738329862244427204132080078125;s:5:\"bytes\";i:1637;s:11:\"size_before\";i:86596;s:10:\"size_after\";i:84959;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6367;s:10:\"size_after\";i:6367;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.220000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:944;s:11:\"size_before\";i:42465;s:10:\"size_after\";i:41521;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.8200000000000000621724893790087662637233734130859375;s:5:\"bytes\";i:2089;s:11:\"size_before\";i:114890;s:10:\"size_after\";i:112801;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.57000000000000028421709430404007434844970703125;s:5:\"bytes\";i:240;s:11:\"size_before\";i:5252;s:10:\"size_after\";i:5012;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.470000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:908;s:11:\"size_before\";i:36780;s:10:\"size_after\";i:35872;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:35872;s:10:\"size_after\";i:35872;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.42999999999999971578290569595992565155029296875;s:5:\"bytes\";i:528;s:11:\"size_before\";i:11907;s:10:\"size_after\";i:11379;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.089999999999999857891452847979962825775146484375;s:5:\"bytes\";i:395;s:11:\"size_before\";i:9651;s:10:\"size_after\";i:9256;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.529999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:658;s:11:\"size_before\";i:26030;s:10:\"size_after\";i:25372;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.70999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:608;s:11:\"size_before\";i:16370;s:10:\"size_after\";i:15762;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.12000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:458;s:11:\"size_before\";i:11113;s:10:\"size_after\";i:10655;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.79999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:855;s:11:\"size_before\";i:30575;s:10:\"size_after\";i:29720;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.1500000000000003552713678800500929355621337890625;s:5:\"bytes\";i:490;s:11:\"size_before\";i:11821;s:10:\"size_after\";i:11331;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.970000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:963;s:11:\"size_before\";i:32386;s:10:\"size_after\";i:31423;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.220000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:563;s:11:\"size_before\";i:17472;s:10:\"size_after\";i:16909;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.100000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:988;s:11:\"size_before\";i:31827;s:10:\"size_after\";i:30839;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.359999999999999875655021241982467472553253173828125;s:5:\"bytes\";i:1294;s:11:\"size_before\";i:54815;s:10:\"size_after\";i:53521;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.5800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:669;s:11:\"size_before\";i:25903;s:10:\"size_after\";i:25234;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.100000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:1008;s:11:\"size_before\";i:47918;s:10:\"size_after\";i:46910;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.04999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1480;s:11:\"size_before\";i:72227;s:10:\"size_after\";i:70747;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.12999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:1488;s:11:\"size_before\";i:47557;s:10:\"size_after\";i:46069;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.12000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1872;s:11:\"size_before\";i:88447;s:10:\"size_after\";i:86575;s:4:\"time\";d:0.1700000000000000122124532708767219446599483489990234375;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:46910;s:10:\"size_after\";i:46910;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:86575;s:10:\"size_after\";i:86575;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.4199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:2672;s:11:\"size_before\";i:110392;s:10:\"size_after\";i:107720;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.9099999999999999200639422269887290894985198974609375;s:5:\"bytes\";i:1275;s:11:\"size_before\";i:66891;s:10:\"size_after\";i:65616;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:25:\"portfolio-two_x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.7600000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:2235;s:11:\"size_before\";i:126758;s:10:\"size_after\";i:124523;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:107720;s:10:\"size_after\";i:107720;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.5099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:942;s:11:\"size_before\";i:26874;s:10:\"size_after\";i:25932;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.4199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:1201;s:11:\"size_before\";i:35102;s:10:\"size_after\";i:33901;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.390000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:1269;s:11:\"size_before\";i:53110;s:10:\"size_after\";i:51841;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.729999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1165;s:11:\"size_before\";i:42737;s:10:\"size_after\";i:41572;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:84959;s:10:\"size_after\";i:84959;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.37999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:979;s:11:\"size_before\";i:41183;s:10:\"size_after\";i:40204;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:16:\"portrait-desktop\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.8600000000000000976996261670137755572795867919921875;s:5:\"bytes\";i:2213;s:11:\"size_before\";i:118944;s:10:\"size_after\";i:116731;s:4:\"time\";d:0.34999999999999997779553950749686919152736663818359375;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:54616;s:10:\"size_after\";i:54616;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.160000000000000142108547152020037174224853515625;s:5:\"bytes\";i:711;s:11:\"size_before\";i:22509;s:10:\"size_after\";i:21798;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}}}");
INSERT INTO wpcf_postmeta VALUES("19","151","_wp_attached_file","2016/05/jueves_about_header.jpg");
INSERT INTO wpcf_postmeta VALUES("20","151","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1440;s:6:\"height\";i:960;s:4:\"file\";s:31:\"2016/05/jueves_about_header.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"jueves_about_header-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:31:\"jueves_about_header-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:31:\"jueves_about_header-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:32:\"jueves_about_header-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"landscape-tablet\";a:6:{s:4:\"file\";s:32:\"jueves_about_header-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:1024;s:12:\"height_query\";i:768;}s:16:\"landscape-mobile\";a:6:{s:4:\"file\";s:31:\"jueves_about_header-736x414.jpg\";s:5:\"width\";i:736;s:6:\"height\";i:414;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:736;s:12:\"height_query\";i:414;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("21","151","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:94.340000000000003410605131648480892181396484375;s:5:\"bytes\";i:58420;s:11:\"size_before\";i:1711701;s:10:\"size_after\";i:96804;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.480000000000000426325641456060111522674560546875;s:5:\"bytes\";i:373;s:11:\"size_before\";i:6806;s:10:\"size_after\";i:6433;s:4:\"time\";d:1.0100000000000000088817841970012523233890533447265625;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.95000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1492;s:11:\"size_before\";i:15076;s:10:\"size_after\";i:14330;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.189999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:2054;s:11:\"size_before\";i:64432;s:10:\"size_after\";i:62378;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:5486;s:11:\"size_before\";i:99547;s:10:\"size_after\";i:96804;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6433;s:10:\"size_after\";i:6433;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.37000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1666;s:11:\"size_before\";i:49408;s:10:\"size_after\";i:47742;s:4:\"time\";d:1.0500000000000000444089209850062616169452667236328125;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.87999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:3853;s:11:\"size_before\";i:133713;s:10:\"size_after\";i:129860;s:4:\"time\";d:1.1799999999999999378275106209912337362766265869140625;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.339999999999999857891452847979962825775146484375;s:5:\"bytes\";i:277;s:11:\"size_before\";i:5186;s:10:\"size_after\";i:4909;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.4900000000000002131628207280300557613372802734375;s:5:\"bytes\";i:1501;s:11:\"size_before\";i:42978;s:10:\"size_after\";i:41477;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:41477;s:10:\"size_after\";i:41477;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.13999999999999968025576890795491635799407958984375;s:5:\"bytes\";i:661;s:11:\"size_before\";i:12865;s:10:\"size_after\";i:12204;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.07000000000000028421709430404007434844970703125;s:5:\"bytes\";i:528;s:11:\"size_before\";i:10408;s:10:\"size_after\";i:9880;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.70000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1124;s:11:\"size_before\";i:30386;s:10:\"size_after\";i:29262;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.44000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:785;s:11:\"size_before\";i:17677;s:10:\"size_after\";i:16892;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.12000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:605;s:11:\"size_before\";i:11827;s:10:\"size_after\";i:11222;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.0099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1389;s:11:\"size_before\";i:34677;s:10:\"size_after\";i:33288;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.96999999999999975131004248396493494510650634765625;s:5:\"bytes\";i:620;s:11:\"size_before\";i:12466;s:10:\"size_after\";i:11846;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.9199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:1431;s:11:\"size_before\";i:36551;s:10:\"size_after\";i:35120;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.36000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:859;s:11:\"size_before\";i:19709;s:10:\"size_after\";i:18850;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1311;s:11:\"size_before\";i:34842;s:10:\"size_after\";i:33531;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.029999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:1596;s:11:\"size_before\";i:52640;s:10:\"size_after\";i:51044;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.970000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:860;s:11:\"size_before\";i:28912;s:10:\"size_after\";i:28052;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.29000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:1848;s:11:\"size_before\";i:56117;s:10:\"size_after\";i:54269;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.060000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:2528;s:11:\"size_before\";i:82742;s:10:\"size_after\";i:80214;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.350000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:1495;s:11:\"size_before\";i:44588;s:10:\"size_after\";i:43093;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.70999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:2589;s:11:\"size_before\";i:95434;s:10:\"size_after\";i:92845;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:54269;s:10:\"size_after\";i:54269;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:92845;s:10:\"size_after\";i:92845;s:4:\"time\";d:0.299999999999999988897769753748434595763683319091796875;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.649999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:2953;s:11:\"size_before\";i:111405;s:10:\"size_after\";i:108452;s:4:\"time\";d:0.299999999999999988897769753748434595763683319091796875;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.529999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:1855;s:11:\"size_before\";i:73301;s:10:\"size_after\";i:71446;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:25:\"portfolio-two_x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3;s:5:\"bytes\";i:4536;s:11:\"size_before\";i:151261;s:10:\"size_after\";i:146725;s:4:\"time\";d:0.2300000000000000099920072216264088638126850128173828125;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:108452;s:10:\"size_after\";i:108452;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:1005;s:11:\"size_before\";i:25877;s:10:\"size_after\";i:24872;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.62000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1200;s:11:\"size_before\";i:33145;s:10:\"size_after\";i:31945;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.180000000000000159872115546022541821002960205078125;s:5:\"bytes\";i:1939;s:11:\"size_before\";i:60950;s:10:\"size_after\";i:59011;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.430000000000000159872115546022541821002960205078125;s:5:\"bytes\";i:1598;s:11:\"size_before\";i:46548;s:10:\"size_after\";i:44950;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:96804;s:10:\"size_after\";i:96804;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.569999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:1676;s:11:\"size_before\";i:46924;s:10:\"size_after\";i:45248;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:16:\"portrait-desktop\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.62999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:3638;s:11:\"size_before\";i:138168;s:10:\"size_after\";i:134530;s:4:\"time\";d:1.5800000000000000710542735760100185871124267578125;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:62378;s:10:\"size_after\";i:62378;s:4:\"time\";d:1.0800000000000000710542735760100185871124267578125;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.3300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1089;s:11:\"size_before\";i:25135;s:10:\"size_after\";i:24046;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}}}");
INSERT INTO wpcf_postmeta VALUES("22","165","_wp_attached_file","2016/05/employee-carl.jpg");
INSERT INTO wpcf_postmeta VALUES("23","165","_wp_attachment_metadata","a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:25:\"2016/05/employee-carl.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"employee-carl-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"employee-carl-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"employees-large\";a:6:{s:4:\"file\";s:25:\"employee-carl-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:500;s:12:\"height_query\";i:500;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("24","165","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:86.7900000000000062527760746888816356658935546875;s:5:\"bytes\";i:17418;s:11:\"size_before\";i:305361;s:10:\"size_after\";i:40346;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:26:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.720000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:196;s:11:\"size_before\";i:5263;s:10:\"size_after\";i:5067;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.269999999999999573674358543939888477325439453125;s:5:\"bytes\";i:645;s:11:\"size_before\";i:15100;s:10:\"size_after\";i:14455;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5067;s:10:\"size_after\";i:5067;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.03000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:151;s:11:\"size_before\";i:3745;s:10:\"size_after\";i:3594;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.20000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:407;s:11:\"size_before\";i:9683;s:10:\"size_after\";i:9276;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.11000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:325;s:11:\"size_before\";i:7914;s:10:\"size_after\";i:7589;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.19000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:969;s:11:\"size_before\";i:23107;s:10:\"size_after\";i:22138;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.1500000000000003552713678800500929355621337890625;s:5:\"bytes\";i:499;s:11:\"size_before\";i:12010;s:10:\"size_after\";i:11511;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.910000000000000142108547152020037174224853515625;s:5:\"bytes\";i:316;s:11:\"size_before\";i:8078;s:10:\"size_after\";i:7762;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.21999999999999975131004248396493494510650634765625;s:5:\"bytes\";i:958;s:11:\"size_before\";i:22699;s:10:\"size_after\";i:21741;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.11000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:340;s:11:\"size_before\";i:8278;s:10:\"size_after\";i:7938;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1238;s:11:\"size_before\";i:25440;s:10:\"size_after\";i:24202;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:14455;s:10:\"size_after\";i:14455;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.4900000000000002131628207280300557613372802734375;s:5:\"bytes\";i:935;s:11:\"size_before\";i:20809;s:10:\"size_after\";i:19874;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:19874;s:10:\"size_after\";i:19874;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.53000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:1269;s:11:\"size_before\";i:28035;s:10:\"size_after\";i:26766;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:19874;s:10:\"size_after\";i:19874;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.839999999999999857891452847979962825775146484375;s:5:\"bytes\";i:547;s:11:\"size_before\";i:11290;s:10:\"size_after\";i:10743;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.05999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:842;s:11:\"size_before\";i:16638;s:10:\"size_after\";i:15796;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.82000000000000028421709430404007434844970703125;s:5:\"bytes\";i:1761;s:11:\"size_before\";i:36557;s:10:\"size_after\";i:34796;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.79999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1259;s:11:\"size_before\";i:26206;s:10:\"size_after\";i:24947;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.44000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:1087;s:11:\"size_before\";i:24509;s:10:\"size_after\";i:23422;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:23422;s:10:\"size_after\";i:23422;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.019999999999999573674358543939888477325439453125;s:5:\"bytes\";i:496;s:11:\"size_before\";i:12342;s:10:\"size_after\";i:11846;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.29999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:3178;s:11:\"size_before\";i:43524;s:10:\"size_after\";i:40346;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:49011;s:10:\"size_after\";i:49011;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}}}");
INSERT INTO wpcf_postmeta VALUES("26","167","_wp_attached_file","2016/05/employee-lisa.jpg");
INSERT INTO wpcf_postmeta VALUES("27","167","_wp_attachment_metadata","a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:25:\"2016/05/employee-lisa.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"employee-lisa-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"employee-lisa-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"employees-large\";a:6:{s:4:\"file\";s:25:\"employee-lisa-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:500;s:12:\"height_query\";i:500;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("28","167","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:86.7900000000000062527760746888816356658935546875;s:5:\"bytes\";i:15927;s:11:\"size_before\";i:311893;s:10:\"size_after\";i:41198;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:25:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.8499999999999996447286321199499070644378662109375;s:5:\"bytes\";i:264;s:11:\"size_before\";i:5439;s:10:\"size_after\";i:5175;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.62999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:564;s:11:\"size_before\";i:15525;s:10:\"size_after\";i:14961;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5175;s:10:\"size_after\";i:5175;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.939999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:151;s:11:\"size_before\";i:3837;s:10:\"size_after\";i:3686;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.8300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:383;s:11:\"size_before\";i:9994;s:10:\"size_after\";i:9611;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.819999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:308;s:11:\"size_before\";i:8059;s:10:\"size_after\";i:7751;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.839999999999999857891452847979962825775146484375;s:5:\"bytes\";i:921;s:11:\"size_before\";i:24012;s:10:\"size_after\";i:23091;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.529999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:437;s:11:\"size_before\";i:12391;s:10:\"size_after\";i:11954;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.70999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:308;s:11:\"size_before\";i:8296;s:10:\"size_after\";i:7988;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.04000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:937;s:11:\"size_before\";i:23205;s:10:\"size_after\";i:22268;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.70000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:315;s:11:\"size_before\";i:8510;s:10:\"size_after\";i:8195;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.5800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1188;s:11:\"size_before\";i:25921;s:10:\"size_after\";i:24733;s:4:\"time\";d:1.0300000000000000266453525910037569701671600341796875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:14961;s:10:\"size_after\";i:14961;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.70999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:993;s:11:\"size_before\";i:21076;s:10:\"size_after\";i:20083;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:20083;s:10:\"size_after\";i:20083;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.640000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:985;s:11:\"size_before\";i:27071;s:10:\"size_after\";i:26086;s:4:\"time\";d:0.200000000000000011102230246251565404236316680908203125;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:20083;s:10:\"size_after\";i:20083;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.17999999999999971578290569595992565155029296875;s:5:\"bytes\";i:629;s:11:\"size_before\";i:12154;s:10:\"size_after\";i:11525;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.37999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:909;s:11:\"size_before\";i:16896;s:10:\"size_after\";i:15987;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.37999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:1639;s:11:\"size_before\";i:37438;s:10:\"size_after\";i:35799;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.660000000000000142108547152020037174224853515625;s:5:\"bytes\";i:1239;s:11:\"size_before\";i:26614;s:10:\"size_after\";i:25375;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.62999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:925;s:11:\"size_before\";i:25455;s:10:\"size_after\";i:24530;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:24530;s:10:\"size_after\";i:24530;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.42999999999999971578290569595992565155029296875;s:5:\"bytes\";i:2832;s:11:\"size_before\";i:44030;s:10:\"size_after\";i:41198;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:50613;s:10:\"size_after\";i:50613;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}}}");
INSERT INTO wpcf_postmeta VALUES("30","172","_wp_attached_file","2016/05/employee-catherine.jpg");
INSERT INTO wpcf_postmeta VALUES("31","172","_wp_attachment_metadata","a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:30:\"2016/05/employee-catherine.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:30:\"employee-catherine-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:30:\"employee-catherine-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"employees-large\";a:6:{s:4:\"file\";s:30:\"employee-catherine-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:500;s:12:\"height_query\";i:500;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("32","172","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:88.43000000000000682121026329696178436279296875;s:5:\"bytes\";i:18900;s:11:\"size_before\";i:341734;s:10:\"size_after\";i:39531;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:26:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.730000000000000426325641456060111522674560546875;s:5:\"bytes\";i:278;s:11:\"size_before\";i:5880;s:10:\"size_after\";i:5602;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.25;s:5:\"bytes\";i:679;s:11:\"size_before\";i:15976;s:10:\"size_after\";i:15297;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5602;s:10:\"size_after\";i:5602;s:4:\"time\";d:1.45999999999999996447286321199499070644378662109375;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.589999999999999857891452847979962825775146484375;s:5:\"bytes\";i:259;s:11:\"size_before\";i:4631;s:10:\"size_after\";i:4372;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.45999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:471;s:11:\"size_before\";i:10549;s:10:\"size_after\";i:10078;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.54000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:396;s:11:\"size_before\";i:8723;s:10:\"size_after\";i:8327;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.0800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:973;s:11:\"size_before\";i:23855;s:10:\"size_after\";i:22882;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.12000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:531;s:11:\"size_before\";i:12885;s:10:\"size_after\";i:12354;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.87999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:475;s:11:\"size_before\";i:9737;s:10:\"size_after\";i:9262;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.0099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1055;s:11:\"size_before\";i:26298;s:10:\"size_after\";i:25243;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.62999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:473;s:11:\"size_before\";i:10214;s:10:\"size_after\";i:9741;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.79999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1423;s:11:\"size_before\";i:29622;s:10:\"size_after\";i:28199;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:15297;s:10:\"size_after\";i:15297;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1200;s:11:\"size_before\";i:25200;s:10:\"size_after\";i:24000;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:24000;s:10:\"size_after\";i:24000;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.2599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1247;s:11:\"size_before\";i:29296;s:10:\"size_after\";i:28049;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:24000;s:10:\"size_after\";i:24000;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.12999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:829;s:11:\"size_before\";i:16167;s:10:\"size_after\";i:15338;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.20999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1093;s:11:\"size_before\";i:20972;s:10:\"size_after\";i:19879;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.5999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1683;s:11:\"size_before\";i:36587;s:10:\"size_after\";i:34904;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1424;s:11:\"size_before\";i:29898;s:10:\"size_after\";i:28474;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.859999999999999875655021241982467472553253173828125;s:5:\"bytes\";i:975;s:11:\"size_before\";i:25244;s:10:\"size_after\";i:24269;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:24269;s:10:\"size_after\";i:24269;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.30999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:572;s:11:\"size_before\";i:13277;s:10:\"size_after\";i:12705;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:2864;s:11:\"size_before\";i:42395;s:10:\"size_after\";i:39531;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:48470;s:10:\"size_after\";i:48470;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}}}");
INSERT INTO wpcf_postmeta VALUES("34","175","_wp_attached_file","2016/05/employee-willie.jpg");
INSERT INTO wpcf_postmeta VALUES("35","175","_wp_attachment_metadata","a:5:{s:5:\"width\";i:500;s:6:\"height\";i:500;s:4:\"file\";s:27:\"2016/05/employee-willie.jpg\";s:5:\"sizes\";a:3:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:27:\"employee-willie-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"employee-willie-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"employees-large\";a:6:{s:4:\"file\";s:27:\"employee-willie-500x500.jpg\";s:5:\"width\";i:500;s:6:\"height\";i:500;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:500;s:12:\"height_query\";i:500;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("36","175","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:87;s:5:\"bytes\";i:15527;s:11:\"size_before\";i:286239;s:10:\"size_after\";i:37204;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:25:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.75;s:5:\"bytes\";i:187;s:11:\"size_before\";i:4987;s:10:\"size_after\";i:4800;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.779999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:525;s:11:\"size_before\";i:13872;s:10:\"size_after\";i:13347;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:4800;s:10:\"size_after\";i:4800;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.28000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:155;s:11:\"size_before\";i:3622;s:10:\"size_after\";i:3467;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.12000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:278;s:11:\"size_before\";i:8915;s:10:\"size_after\";i:8637;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.4199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:250;s:11:\"size_before\";i:7302;s:10:\"size_after\";i:7052;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.12999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:873;s:11:\"size_before\";i:21142;s:10:\"size_after\";i:20269;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.29999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:368;s:11:\"size_before\";i:11136;s:10:\"size_after\";i:10768;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.5800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:275;s:11:\"size_before\";i:7676;s:10:\"size_after\";i:7401;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.160000000000000142108547152020037174224853515625;s:5:\"bytes\";i:902;s:11:\"size_before\";i:21657;s:10:\"size_after\";i:20755;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.0800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:244;s:11:\"size_before\";i:7934;s:10:\"size_after\";i:7690;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.839999999999999857891452847979962825775146484375;s:5:\"bytes\";i:1182;s:11:\"size_before\";i:24409;s:10:\"size_after\";i:23227;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:13347;s:10:\"size_after\";i:13347;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:981;s:11:\"size_before\";i:20137;s:10:\"size_after\";i:19156;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:19156;s:10:\"size_after\";i:19156;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.54999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1134;s:11:\"size_before\";i:24941;s:10:\"size_after\";i:23807;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:19156;s:10:\"size_after\";i:19156;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.160000000000000142108547152020037174224853515625;s:5:\"bytes\";i:581;s:11:\"size_before\";i:11257;s:10:\"size_after\";i:10676;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.04000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:814;s:11:\"size_before\";i:16154;s:10:\"size_after\";i:15340;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.019999999999999573674358543939888477325439453125;s:5:\"bytes\";i:1685;s:11:\"size_before\";i:33572;s:10:\"size_after\";i:31887;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.79000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:1197;s:11:\"size_before\";i:24979;s:10:\"size_after\";i:23782;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.839999999999999857891452847979962825775146484375;s:5:\"bytes\";i:865;s:11:\"size_before\";i:22547;s:10:\"size_after\";i:21682;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:21682;s:10:\"size_after\";i:21682;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.53000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:3031;s:11:\"size_before\";i:40235;s:10:\"size_after\";i:37204;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:45450;s:10:\"size_after\";i:45450;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}}}");
INSERT INTO wpcf_postmeta VALUES("38","182","_wp_attached_file","2016/05/favicon-jueves.png");
INSERT INTO wpcf_postmeta VALUES("39","182","_wp_attachment_metadata","a:5:{s:5:\"width\";i:48;s:6:\"height\";i:48;s:4:\"file\";s:26:\"2016/05/favicon-jueves.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("40","182","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:46.7489711934156417783015058375895023345947265625;s:5:\"bytes\";i:568;s:11:\"size_before\";i:1215;s:10:\"size_after\";i:647;s:4:\"time\";d:1.020000000000000017763568394002504646778106689453125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:46.75;s:5:\"bytes\";i:568;s:11:\"size_before\";i:1215;s:10:\"size_after\";i:647;s:4:\"time\";d:1.020000000000000017763568394002504646778106689453125;}}}");
INSERT INTO wpcf_postmeta VALUES("41","194","_wp_attached_file","2016/05/jueves_consultation_header.jpg");
INSERT INTO wpcf_postmeta VALUES("42","194","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1440;s:6:\"height\";i:960;s:4:\"file\";s:38:\"2016/05/jueves_consultation_header.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"jueves_consultation_header-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"jueves_consultation_header-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:38:\"jueves_consultation_header-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:39:\"jueves_consultation_header-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("43","194","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:94.7600000000000051159076974727213382720947265625;s:5:\"bytes\";i:60539;s:11:\"size_before\";i:1567776;s:10:\"size_after\";i:82113;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.13999999999999968025576890795491635799407958984375;s:5:\"bytes\";i:454;s:11:\"size_before\";i:7393;s:10:\"size_after\";i:6939;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.9900000000000002131628207280300557613372802734375;s:5:\"bytes\";i:1388;s:11:\"size_before\";i:13915;s:10:\"size_after\";i:13221;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.439999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:1877;s:11:\"size_before\";i:54537;s:10:\"size_after\";i:52660;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.25;s:5:\"bytes\";i:5514;s:11:\"size_before\";i:84870;s:10:\"size_after\";i:82113;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6939;s:10:\"size_after\";i:6939;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.5800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1705;s:11:\"size_before\";i:47682;s:10:\"size_after\";i:45977;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.4199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:4406;s:11:\"size_before\";i:128957;s:10:\"size_after\";i:124551;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.13999999999999968025576890795491635799407958984375;s:5:\"bytes\";i:337;s:11:\"size_before\";i:5488;s:10:\"size_after\";i:5151;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1566;s:11:\"size_before\";i:41609;s:10:\"size_after\";i:40043;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:40043;s:10:\"size_after\";i:40043;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.1500000000000003552713678800500929355621337890625;s:5:\"bytes\";i:680;s:11:\"size_before\";i:13214;s:10:\"size_after\";i:12534;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.62999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:612;s:11:\"size_before\";i:10874;s:10:\"size_after\";i:10262;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4;s:5:\"bytes\";i:1184;s:11:\"size_before\";i:29572;s:10:\"size_after\";i:28388;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.63999999999999968025576890795491635799407958984375;s:5:\"bytes\";i:751;s:11:\"size_before\";i:16175;s:10:\"size_after\";i:15424;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.839999999999999857891452847979962825775146484375;s:5:\"bytes\";i:554;s:11:\"size_before\";i:11454;s:10:\"size_after\";i:10900;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.12000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1283;s:11:\"size_before\";i:31107;s:10:\"size_after\";i:29824;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.86000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:579;s:11:\"size_before\";i:11908;s:10:\"size_after\";i:11329;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.1699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:1342;s:11:\"size_before\";i:32187;s:10:\"size_after\";i:30845;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.67999999999999971578290569595992565155029296875;s:5:\"bytes\";i:924;s:11:\"size_before\";i:19747;s:10:\"size_after\";i:18823;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.70000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1114;s:11:\"size_before\";i:30135;s:10:\"size_after\";i:29021;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1354;s:11:\"size_before\";i:47133;s:10:\"size_after\";i:45779;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.850000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:1185;s:11:\"size_before\";i:30756;s:10:\"size_after\";i:29571;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.310000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:1788;s:11:\"size_before\";i:54073;s:10:\"size_after\";i:52285;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.479999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:2431;s:11:\"size_before\";i:69873;s:10:\"size_after\";i:67442;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.279999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:1266;s:11:\"size_before\";i:38616;s:10:\"size_after\";i:37350;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.939999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:2478;s:11:\"size_before\";i:84200;s:10:\"size_after\";i:81722;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:52285;s:10:\"size_after\";i:52285;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:81722;s:10:\"size_after\";i:81722;s:4:\"time\";d:0.2099999999999999922284388276239042170345783233642578125;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.189999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:3253;s:11:\"size_before\";i:101980;s:10:\"size_after\";i:98727;s:4:\"time\";d:0.1499999999999999944488848768742172978818416595458984375;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.350000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:2707;s:11:\"size_before\";i:80758;s:10:\"size_after\";i:78051;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:25:\"portfolio-two_x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.339999999999999857891452847979962825775146484375;s:5:\"bytes\";i:6318;s:11:\"size_before\";i:145641;s:10:\"size_after\";i:139323;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:98727;s:10:\"size_after\";i:98727;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.54000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:799;s:11:\"size_before\";i:22550;s:10:\"size_after\";i:21751;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.270000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:932;s:11:\"size_before\";i:28493;s:10:\"size_after\";i:27561;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.529999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:1827;s:11:\"size_before\";i:51715;s:10:\"size_after\";i:49888;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.569999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:1434;s:11:\"size_before\";i:40209;s:10:\"size_after\";i:38775;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:82113;s:10:\"size_after\";i:82113;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.859999999999999875655021241982467472553253173828125;s:5:\"bytes\";i:1556;s:11:\"size_before\";i:40266;s:10:\"size_after\";i:38710;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:16:\"portrait-desktop\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.339999999999999857891452847979962825775146484375;s:5:\"bytes\";i:3948;s:11:\"size_before\";i:118331;s:10:\"size_after\";i:114383;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:52660;s:10:\"size_after\";i:52660;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.44000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:993;s:11:\"size_before\";i:22358;s:10:\"size_after\";i:21365;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}}}");
INSERT INTO wpcf_postmeta VALUES("45","202","_wp_attached_file","2016/05/jueves_consultation_side.jpg");
INSERT INTO wpcf_postmeta VALUES("46","202","_wp_attachment_metadata","a:5:{s:5:\"width\";i:558;s:6:\"height\";i:604;s:4:\"file\";s:36:\"2016/05/jueves_consultation_side.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:36:\"jueves_consultation_side-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:36:\"jueves_consultation_side-277x300.jpg\";s:5:\"width\";i:277;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("47","202","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:96.9899999999999948840923025272786617279052734375;s:5:\"bytes\";i:27046;s:11:\"size_before\";i:678862;s:10:\"size_after\";i:20436;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:34:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.03000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:485;s:11:\"size_before\";i:8044;s:10:\"size_after\";i:7559;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.8300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:2076;s:11:\"size_before\";i:21474;s:10:\"size_after\";i:20436;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7559;s:10:\"size_after\";i:7559;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.1699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:1707;s:11:\"size_before\";i:53834;s:10:\"size_after\";i:52127;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.17999999999999971578290569595992565155029296875;s:5:\"bytes\";i:372;s:11:\"size_before\";i:6023;s:10:\"size_after\";i:5651;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.4199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:1614;s:11:\"size_before\";i:47251;s:10:\"size_after\";i:45637;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:45637;s:10:\"size_after\";i:45637;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.57000000000000028421709430404007434844970703125;s:5:\"bytes\";i:825;s:11:\"size_before\";i:14816;s:10:\"size_after\";i:13991;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.8300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:709;s:11:\"size_before\";i:12161;s:10:\"size_after\";i:11452;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.95999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1334;s:11:\"size_before\";i:33678;s:10:\"size_after\";i:32344;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.20000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:893;s:11:\"size_before\";i:17183;s:10:\"size_after\";i:16290;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.07000000000000028421709430404007434844970703125;s:5:\"bytes\";i:649;s:11:\"size_before\";i:12808;s:10:\"size_after\";i:12159;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.410000000000000142108547152020037174224853515625;s:5:\"bytes\";i:1169;s:11:\"size_before\";i:34235;s:10:\"size_after\";i:33066;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.86000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:653;s:11:\"size_before\";i:13431;s:10:\"size_after\";i:12778;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.310000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:1164;s:11:\"size_before\";i:35176;s:10:\"size_after\";i:34012;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.69000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:1050;s:11:\"size_before\";i:22377;s:10:\"size_after\";i:21327;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.569999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:1235;s:11:\"size_before\";i:34603;s:10:\"size_after\";i:33368;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:33368;s:10:\"size_after\";i:33368;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.279999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:1133;s:11:\"size_before\";i:34499;s:10:\"size_after\";i:33366;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.359999999999999875655021241982467472553253173828125;s:5:\"bytes\";i:2114;s:11:\"size_before\";i:62854;s:10:\"size_after\";i:60740;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:60740;s:10:\"size_after\";i:60740;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:33368;s:10:\"size_after\";i:33368;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:60740;s:10:\"size_after\";i:60740;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:60740;s:10:\"size_after\";i:60740;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:60740;s:10:\"size_after\";i:60740;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:60740;s:10:\"size_after\";i:60740;s:4:\"time\";d:1.5;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:60740;s:10:\"size_after\";i:60740;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:865;s:11:\"size_before\";i:22365;s:10:\"size_after\";i:21500;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.470000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:986;s:11:\"size_before\";i:28401;s:10:\"size_after\";i:27415;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.3300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1723;s:11:\"size_before\";i:51688;s:10:\"size_after\";i:49965;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.45999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1366;s:11:\"size_before\";i:39507;s:10:\"size_after\";i:38141;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.21999999999999975131004248396493494510650634765625;s:5:\"bytes\";i:1443;s:11:\"size_before\";i:34176;s:10:\"size_after\";i:32733;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1481;s:11:\"size_before\";i:38278;s:10:\"size_after\";i:36797;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:79504;s:10:\"size_after\";i:79504;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}}}");
INSERT INTO wpcf_postmeta VALUES("48","7818","_wp_attached_file","2015/12/blog-01.jpg");
INSERT INTO wpcf_postmeta VALUES("49","7818","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1140;s:6:\"height\";i:750;s:4:\"file\";s:19:\"2015/12/blog-01.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"blog-01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"blog-01-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"blog-01-768x505.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:505;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"blog-01-1024x674.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("50","7818","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:1.142909390143549419605051298276521265506744384765625;s:5:\"bytes\";i:16500;s:11:\"size_before\";i:1443684;s:10:\"size_after\";i:1427184;s:4:\"time\";d:2.350000000000000088817841970012523233890533447265625;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.519999999999999573674358543939888477325439453125;s:5:\"bytes\";i:190;s:11:\"size_before\";i:5550;s:10:\"size_after\";i:5299;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.430000000000000159872115546022541821002960205078125;s:5:\"bytes\";i:646;s:11:\"size_before\";i:11188;s:10:\"size_after\";i:10804;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.25;s:5:\"bytes\";i:526;s:11:\"size_before\";i:46851;s:10:\"size_after\";i:46264;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.3300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1810;s:11:\"size_before\";i:72704;s:10:\"size_after\";i:71738;s:4:\"time\";d:0.179999999999999993338661852249060757458209991455078125;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.1399999999999999023003738329862244427204132080078125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5360;s:10:\"size_after\";i:5299;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.100000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:352;s:11:\"size_before\";i:37404;s:10:\"size_after\";i:36991;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.3400000000000000799360577730112709105014801025390625;s:5:\"bytes\";i:1096;s:11:\"size_before\";i:86052;s:10:\"size_after\";i:84895;s:4:\"time\";d:0.200000000000000011102230246251565404236316680908203125;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.5999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:176;s:11:\"size_before\";i:4231;s:10:\"size_after\";i:3994;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.20999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:335;s:11:\"size_before\";i:32827;s:10:\"size_after\";i:32431;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.190000000000000002220446049250313080847263336181640625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:32492;s:10:\"size_after\";i:32431;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.520000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:290;s:11:\"size_before\";i:9977;s:10:\"size_after\";i:9626;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.62000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:233;s:11:\"size_before\";i:8125;s:10:\"size_after\";i:7831;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.4699999999999999733546474089962430298328399658203125;s:5:\"bytes\";i:274;s:11:\"size_before\";i:22744;s:10:\"size_after\";i:22409;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.310000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:374;s:11:\"size_before\";i:13139;s:10:\"size_after\";i:12704;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.13999999999999968025576890795491635799407958984375;s:5:\"bytes\";i:316;s:11:\"size_before\";i:9109;s:10:\"size_after\";i:8732;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.95999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:442;s:11:\"size_before\";i:25651;s:10:\"size_after\";i:25148;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.19000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:338;s:11:\"size_before\";i:9534;s:10:\"size_after\";i:9135;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.9499999999999999555910790149937383830547332763671875;s:5:\"bytes\";i:461;s:11:\"size_before\";i:26752;s:10:\"size_after\";i:26230;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.20000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:270;s:11:\"size_before\";i:15068;s:10:\"size_after\";i:14737;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.7800000000000000266453525910037569701671600341796875;s:5:\"bytes\";i:408;s:11:\"size_before\";i:26309;s:10:\"size_after\";i:25840;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.62000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:600;s:11:\"size_before\";i:40907;s:10:\"size_after\";i:40246;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.060000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:173;s:11:\"size_before\";i:22143;s:10:\"size_after\";i:21909;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.12000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:410;s:11:\"size_before\";i:42122;s:10:\"size_after\";i:41651;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.3300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:737;s:11:\"size_before\";i:59960;s:10:\"size_after\";i:59162;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.6399999999999999023003738329862244427204132080078125;s:5:\"bytes\";i:505;s:11:\"size_before\";i:34552;s:10:\"size_after\";i:33986;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.5800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1120;s:11:\"size_before\";i:74590;s:10:\"size_after\";i:73409;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1499999999999999944488848768742172978818416595458984375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:41712;s:10:\"size_after\";i:41651;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.08000000000000000166533453693773481063544750213623046875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:73470;s:10:\"size_after\";i:73409;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.08000000000000000166533453693773481063544750213623046875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:73470;s:10:\"size_after\";i:73409;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.1599999999999999200639422269887290894985198974609375;s:5:\"bytes\";i:29804;s:11:\"size_before\";i:49308;s:10:\"size_after\";i:48738;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.08000000000000000166533453693773481063544750213623046875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:73470;s:10:\"size_after\";i:73409;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.939999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:320;s:11:\"size_before\";i:19607;s:10:\"size_after\";i:19226;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.6599999999999999200639422269887290894985198974609375;s:5:\"bytes\";i:364;s:11:\"size_before\";i:25610;s:10:\"size_after\";i:25185;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.2199999999999999733546474089962430298328399658203125;s:5:\"bytes\";i:480;s:11:\"size_before\";i:44223;s:10:\"size_after\";i:43682;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.1799999999999999378275106209912337362766265869140625;s:5:\"bytes\";i:356;s:11:\"size_before\";i:35489;s:10:\"size_after\";i:35072;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.08000000000000000166533453693773481063544750213623046875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:71799;s:10:\"size_after\";i:71738;s:4:\"time\";d:0.1499999999999999944488848768742172978818416595458984375;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.439999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:436;s:11:\"size_before\";i:34437;s:10:\"size_after\";i:33940;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.13000000000000000444089209850062616169452667236328125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:46325;s:10:\"size_after\";i:46264;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.4900000000000002131628207280300557613372802734375;s:5:\"bytes\";i:387;s:11:\"size_before\";i:17978;s:10:\"size_after\";i:17530;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.79999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:293;s:11:\"size_before\";i:12646;s:10:\"size_after\";i:12292;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:9:\"600x99999\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.13000000000000000444089209850062616169452667236328125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:48799;s:10:\"size_after\";i:48738;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}}}");
INSERT INTO wpcf_postmeta VALUES("53","7819","_wp_attached_file","2015/12/blog-02.jpg");
INSERT INTO wpcf_postmeta VALUES("54","7819","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1140;s:6:\"height\";i:750;s:4:\"file\";s:19:\"2015/12/blog-02.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"blog-02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"blog-02-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"blog-02-768x505.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:505;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"blog-02-1024x674.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("55","7819","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:2.419457984566629082934241523616947233676910400390625;s:5:\"bytes\";i:44265;s:11:\"size_before\";i:1829542;s:10:\"size_after\";i:1785277;s:4:\"time\";d:2.380000000000000337507799486047588288784027099609375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.6500000000000003552713678800500929355621337890625;s:5:\"bytes\";i:262;s:11:\"size_before\";i:6950;s:10:\"size_after\";i:6627;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.9199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:1352;s:11:\"size_before\";i:14993;s:10:\"size_after\";i:14256;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.470000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:2010;s:11:\"size_before\";i:59714;s:10:\"size_after\";i:57643;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.939999999999999946709294817992486059665679931640625;s:5:\"bytes\";i:5244;s:11:\"size_before\";i:91107;s:10:\"size_after\";i:88424;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.91000000000000003108624468950438313186168670654296875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6688;s:10:\"size_after\";i:6627;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.45000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1592;s:11:\"size_before\";i:47885;s:10:\"size_after\";i:46232;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.79000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:2925;s:11:\"size_before\";i:107036;s:10:\"size_after\";i:104050;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.04999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:275;s:11:\"size_before\";i:5551;s:10:\"size_after\";i:5215;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.600000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:1440;s:11:\"size_before\";i:41648;s:10:\"size_after\";i:40147;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1499999999999999944488848768742172978818416595458984375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:40208;s:10:\"size_after\";i:40147;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.519999999999999573674358543939888477325439453125;s:5:\"bytes\";i:519;s:11:\"size_before\";i:12824;s:10:\"size_after\";i:12244;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.9199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:457;s:11:\"size_before\";i:10527;s:10:\"size_after\";i:10009;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.890000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:1088;s:11:\"size_before\";i:29529;s:10:\"size_after\";i:28380;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.67999999999999971578290569595992565155029296875;s:5:\"bytes\";i:747;s:11:\"size_before\";i:17278;s:10:\"size_after\";i:16470;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.589999999999999857891452847979962825775146484375;s:5:\"bytes\";i:488;s:11:\"size_before\";i:11955;s:10:\"size_after\";i:11406;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.890000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:1238;s:11:\"size_before\";i:33361;s:10:\"size_after\";i:32062;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.67999999999999971578290569595992565155029296875;s:5:\"bytes\";i:530;s:11:\"size_before\";i:12615;s:10:\"size_after\";i:12024;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.79999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1263;s:11:\"size_before\";i:34823;s:10:\"size_after\";i:33499;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.03000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:722;s:11:\"size_before\";i:19447;s:10:\"size_after\";i:18664;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.089999999999999857891452847979962825775146484375;s:5:\"bytes\";i:1325;s:11:\"size_before\";i:33905;s:10:\"size_after\";i:32519;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.359999999999999875655021241982467472553253173828125;s:5:\"bytes\";i:1756;s:11:\"size_before\";i:54149;s:10:\"size_after\";i:52332;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.20999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:828;s:11:\"size_before\";i:27657;s:10:\"size_after\";i:26768;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.12000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1608;s:11:\"size_before\";i:53525;s:10:\"size_after\";i:51856;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.180000000000000159872115546022541821002960205078125;s:5:\"bytes\";i:2340;s:11:\"size_before\";i:75447;s:10:\"size_after\";i:73046;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.569999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:1535;s:11:\"size_before\";i:44752;s:10:\"size_after\";i:43156;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.95999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:2725;s:11:\"size_before\";i:94067;s:10:\"size_after\";i:91281;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.11999999999999999555910790149937383830547332763671875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:51917;s:10:\"size_after\";i:51856;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.070000000000000006661338147750939242541790008544921875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:91342;s:10:\"size_after\";i:91281;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.070000000000000006661338147750939242541790008544921875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:91342;s:10:\"size_after\";i:91281;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3;s:5:\"bytes\";i:103408;s:11:\"size_before\";i:63368;s:10:\"size_after\";i:61469;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.070000000000000006661338147750939242541790008544921875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:91342;s:10:\"size_after\";i:91281;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.05999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:959;s:11:\"size_before\";i:25149;s:10:\"size_after\";i:24129;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:1223;s:11:\"size_before\";i:33108;s:10:\"size_after\";i:31824;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.529999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:1937;s:11:\"size_before\";i:56576;s:10:\"size_after\";i:54578;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.70000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1617;s:11:\"size_before\";i:45323;s:10:\"size_after\";i:43645;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.070000000000000006661338147750939242541790008544921875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:88485;s:10:\"size_after\";i:88424;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1620;s:11:\"size_before\";i:44664;s:10:\"size_after\";i:42983;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.11000000000000000055511151231257827021181583404541015625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:57704;s:10:\"size_after\";i:57643;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.3300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:965;s:11:\"size_before\";i:23722;s:10:\"size_after\";i:22696;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.2599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:634;s:11:\"size_before\";i:16329;s:10:\"size_after\";i:15634;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:9:\"600x99999\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1000000000000000055511151231257827021181583404541015625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:61530;s:10:\"size_after\";i:61469;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}}}");
INSERT INTO wpcf_postmeta VALUES("58","7820","_wp_attached_file","2015/12/blog-03.jpg");
INSERT INTO wpcf_postmeta VALUES("59","7820","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1140;s:6:\"height\";i:750;s:4:\"file\";s:19:\"2015/12/blog-03.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"blog-03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"blog-03-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"blog-03-768x505.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:505;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"blog-03-1024x674.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("60","7820","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:5.06477321520206924532203629496507346630096435546875;s:5:\"bytes\";i:48362;s:11:\"size_before\";i:954870;s:10:\"size_after\";i:906508;s:4:\"time\";d:2.709999999999999520383653361932374536991119384765625;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.67999999999999971578290569595992565155029296875;s:5:\"bytes\";i:170;s:11:\"size_before\";i:4935;s:10:\"size_after\";i:4704;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.80999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:836;s:11:\"size_before\";i:8249;s:10:\"size_after\";i:7770;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.53999999999999914734871708787977695465087890625;s:5:\"bytes\";i:2456;s:11:\"size_before\";i:29481;s:10:\"size_after\";i:26964;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.92999999999999971578290569595992565155029296875;s:5:\"bytes\";i:8816;s:11:\"size_before\";i:45012;s:10:\"size_after\";i:40543;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.2800000000000000266453525910037569701671600341796875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:4765;s:10:\"size_after\";i:4704;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.0800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1572;s:11:\"size_before\";i:26868;s:10:\"size_after\";i:25235;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.589999999999999857891452847979962825775146484375;s:5:\"bytes\";i:5212;s:11:\"size_before\";i:54989;s:10:\"size_after\";i:49716;s:4:\"time\";d:0.179999999999999993338661852249060757458209991455078125;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.92999999999999971578290569595992565155029296875;s:5:\"bytes\";i:155;s:11:\"size_before\";i:3642;s:10:\"size_after\";i:3426;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.730000000000000426325641456060111522674560546875;s:5:\"bytes\";i:1289;s:11:\"size_before\";i:23570;s:10:\"size_after\";i:22220;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.270000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:22281;s:10:\"size_after\";i:22220;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.07000000000000028421709430404007434844970703125;s:5:\"bytes\";i:356;s:11:\"size_before\";i:8217;s:10:\"size_after\";i:7800;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.67999999999999971578290569595992565155029296875;s:5:\"bytes\";i:261;s:11:\"size_before\";i:6874;s:10:\"size_after\";i:6552;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.730000000000000426325641456060111522674560546875;s:5:\"bytes\";i:738;s:11:\"size_before\";i:16893;s:10:\"size_after\";i:16094;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.2400000000000002131628207280300557613372802734375;s:5:\"bytes\";i:513;s:11:\"size_before\";i:9194;s:10:\"size_after\";i:8620;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:339;s:11:\"size_before\";i:6942;s:10:\"size_after\";i:6542;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.6500000000000003552713678800500929355621337890625;s:5:\"bytes\";i:1097;s:11:\"size_before\";i:17404;s:10:\"size_after\";i:16246;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.9900000000000002131628207280300557613372802734375;s:5:\"bytes\";i:368;s:11:\"size_before\";i:7158;s:10:\"size_after\";i:6729;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.20000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1233;s:11:\"size_before\";i:17965;s:10:\"size_after\";i:16671;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.70000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:486;s:11:\"size_before\";i:11629;s:10:\"size_after\";i:11082;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.839999999999999857891452847979962825775146484375;s:5:\"bytes\";i:1142;s:11:\"size_before\";i:17591;s:10:\"size_after\";i:16388;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.78000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:1681;s:11:\"size_before\";i:25686;s:10:\"size_after\";i:23944;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.04999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:693;s:11:\"size_before\";i:18605;s:10:\"size_after\";i:17851;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.96999999999999975131004248396493494510650634765625;s:5:\"bytes\";i:1725;s:11:\"size_before\";i:29933;s:10:\"size_after\";i:28147;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.230000000000000426325641456060111522674560546875;s:5:\"bytes\";i:3413;s:11:\"size_before\";i:37629;s:10:\"size_after\";i:34155;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.37999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:1361;s:11:\"size_before\";i:22283;s:10:\"size_after\";i:20861;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.9199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:4323;s:11:\"size_before\";i:49161;s:10:\"size_after\";i:44777;s:4:\"time\";d:0.2099999999999999922284388276239042170345783233642578125;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.2200000000000000011102230246251565404236316680908203125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:28208;s:10:\"size_after\";i:28147;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.14000000000000001332267629550187848508358001708984375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:44838;s:10:\"size_after\";i:44777;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.14000000000000001332267629550187848508358001708984375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:44838;s:10:\"size_after\";i:44777;s:4:\"time\";d:0.2200000000000000011102230246251565404236316680908203125;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.87999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:114148;s:11:\"size_before\";i:36944;s:10:\"size_after\";i:34773;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.14000000000000001332267629550187848508358001708984375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:44838;s:10:\"size_after\";i:44777;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.61000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:654;s:11:\"size_before\";i:12742;s:10:\"size_after\";i:12027;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.12000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:967;s:11:\"size_before\";i:16789;s:10:\"size_after\";i:15761;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.269999999999999573674358543939888477325439453125;s:5:\"bytes\";i:2282;s:11:\"size_before\";i:28346;s:10:\"size_after\";i:26003;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.1699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:1598;s:11:\"size_before\";i:23152;s:10:\"size_after\";i:21493;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1499999999999999944488848768742172978818416595458984375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:40604;s:10:\"size_after\";i:40543;s:4:\"time\";d:0.1700000000000000122124532708767219446599483489990234375;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.94000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:1704;s:11:\"size_before\";i:22228;s:10:\"size_after\";i:20463;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.2300000000000000099920072216264088638126850128173828125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:27025;s:10:\"size_after\";i:26964;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.37999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:732;s:11:\"size_before\";i:12424;s:10:\"size_after\";i:11631;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.61000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:405;s:11:\"size_before\";i:10104;s:10:\"size_after\";i:9638;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:9:\"600x99999\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.179999999999999993338661852249060757458209991455078125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:34834;s:10:\"size_after\";i:34773;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}}}");
INSERT INTO wpcf_postmeta VALUES("63","7821","_wp_attached_file","2015/12/blog-04.jpg");
INSERT INTO wpcf_postmeta VALUES("64","7821","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1140;s:6:\"height\";i:750;s:4:\"file\";s:19:\"2015/12/blog-04.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"blog-04-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"blog-04-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"blog-04-768x505.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:505;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"blog-04-1024x674.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("65","7821","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:1.732191962567862564270626535289920866489410400390625;s:5:\"bytes\";i:20302;s:11:\"size_before\";i:1172041;s:10:\"size_after\";i:1151739;s:4:\"time\";d:2.270000000000000905941988094127736985683441162109375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.29999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:179;s:11:\"size_before\";i:5578;s:10:\"size_after\";i:5338;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.13999999999999968025576890795491635799407958984375;s:5:\"bytes\";i:694;s:11:\"size_before\";i:9855;s:10:\"size_after\";i:9447;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.6699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:956;s:11:\"size_before\";i:38063;s:10:\"size_after\";i:37046;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.060000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:3434;s:11:\"size_before\";i:58184;s:10:\"size_after\";i:56406;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.12999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5399;s:10:\"size_after\";i:5338;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.3200000000000000621724893790087662637233734130859375;s:5:\"bytes\";i:398;s:11:\"size_before\";i:34710;s:10:\"size_after\";i:34251;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.79000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:1844;s:11:\"size_before\";i:68281;s:10:\"size_after\";i:66376;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.82000000000000028421709430404007434844970703125;s:5:\"bytes\";i:133;s:11:\"size_before\";i:4025;s:10:\"size_after\";i:3831;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.75;s:5:\"bytes\";i:474;s:11:\"size_before\";i:30544;s:10:\"size_after\";i:30009;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.200000000000000011102230246251565404236316680908203125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:30070;s:10:\"size_after\";i:30009;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.589999999999999857891452847979962825775146484375;s:5:\"bytes\";i:290;s:11:\"size_before\";i:9787;s:10:\"size_after\";i:9436;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.529999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:225;s:11:\"size_before\";i:8099;s:10:\"size_after\";i:7813;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.140000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:408;s:11:\"size_before\";i:21918;s:10:\"size_after\";i:21449;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.819999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:255;s:11:\"size_before\";i:11192;s:10:\"size_after\";i:10876;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.29999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:296;s:11:\"size_before\";i:8308;s:10:\"size_after\";i:7951;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.70000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:533;s:11:\"size_before\";i:22020;s:10:\"size_after\";i:21426;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.46999999999999975131004248396493494510650634765625;s:5:\"bytes\";i:318;s:11:\"size_before\";i:8478;s:10:\"size_after\";i:8099;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.979999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:613;s:11:\"size_before\";i:22592;s:10:\"size_after\";i:21918;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.339999999999999857891452847979962825775146484375;s:5:\"bytes\";i:425;s:11:\"size_before\";i:14531;s:10:\"size_after\";i:14045;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.140000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:365;s:11:\"size_before\";i:19876;s:10:\"size_after\";i:19450;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.859999999999999875655021241982467472553253173828125;s:5:\"bytes\";i:676;s:11:\"size_before\";i:19088;s:10:\"size_after\";i:18351;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.62999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:321;s:11:\"size_before\";i:23460;s:10:\"size_after\";i:23078;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.4499999999999999555910790149937383830547332763671875;s:5:\"bytes\";i:501;s:11:\"size_before\";i:38771;s:10:\"size_after\";i:38209;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.5800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1180;s:11:\"size_before\";i:48025;s:10:\"size_after\";i:46784;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.37999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:397;s:11:\"size_before\";i:19231;s:10:\"size_after\";i:18773;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.569999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:1389;s:11:\"size_before\";i:56408;s:10:\"size_after\";i:54958;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1600000000000000033306690738754696212708950042724609375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:38270;s:10:\"size_after\";i:38209;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.11000000000000000055511151231257827021181583404541015625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:55019;s:10:\"size_after\";i:54958;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.11000000000000000055511151231257827021181583404541015625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:55019;s:10:\"size_after\";i:54958;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.520000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:38244;s:11:\"size_before\";i:48633;s:10:\"size_after\";i:47893;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.11000000000000000055511151231257827021181583404541015625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:55019;s:10:\"size_after\";i:54958;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:200;s:11:\"size_before\";i:9466;s:10:\"size_after\";i:9205;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.8300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:203;s:11:\"size_before\";i:14418;s:10:\"size_after\";i:14154;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.12999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:707;s:11:\"size_before\";i:35985;s:10:\"size_after\";i:35217;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.020000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:470;s:11:\"size_before\";i:26297;s:10:\"size_after\";i:25766;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.11000000000000000055511151231257827021181583404541015625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:56467;s:10:\"size_after\";i:56406;s:4:\"time\";d:0.179999999999999993338661852249060757458209991455078125;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.45999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:639;s:11:\"size_before\";i:28503;s:10:\"size_after\";i:27803;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1600000000000000033306690738754696212708950042724609375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:37107;s:10:\"size_after\";i:37046;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.390000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:303;s:11:\"size_before\";i:15244;s:10:\"size_after\";i:14880;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.470000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:360;s:11:\"size_before\";i:12147;s:10:\"size_after\";i:11726;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:9:\"600x99999\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.13000000000000000444089209850062616169452667236328125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:47954;s:10:\"size_after\";i:47893;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}}}");
INSERT INTO wpcf_postmeta VALUES("68","7","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("69","7","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("70","7","_wp_page_template","default");
INSERT INTO wpcf_postmeta VALUES("71","7","_wpb_vc_js_status","true");
INSERT INTO wpcf_postmeta VALUES("72","7","_layout","full");
INSERT INTO wpcf_postmeta VALUES("73","7","_padding","true");
INSERT INTO wpcf_postmeta VALUES("74","7","page_preloader","true");
INSERT INTO wpcf_postmeta VALUES("75","7","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("76","7","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("77","7","_enable_local_backgrounds","true");
INSERT INTO wpcf_postmeta VALUES("78","7","theme_header_style","3");
INSERT INTO wpcf_postmeta VALUES("79","7","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("80","7","theme_toolbar_toggle","false");
INSERT INTO wpcf_postmeta VALUES("81","7","_transparent_header","true");
INSERT INTO wpcf_postmeta VALUES("82","7","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("83","7","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("84","7","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("85","7","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("86","7","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("87","7","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("88","7","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("89","7","body_size","false");
INSERT INTO wpcf_postmeta VALUES("90","7","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("91","7","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("92","7","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("93","7","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("94","7","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("95","7","page_size","false");
INSERT INTO wpcf_postmeta VALUES("96","7","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("97","7","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("98","7","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("99","7","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("100","7","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("101","7","header_size","false");
INSERT INTO wpcf_postmeta VALUES("102","7","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("103","7","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("104","7","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("105","7","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("106","7","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("107","7","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("108","7","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("109","7","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("110","7","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("111","7","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("112","7","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("113","7","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("114","7","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("115","7","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("116","7","_theme_options_build","5beeec2b2d97f");
INSERT INTO wpcf_postmeta VALUES("117","7","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("118","7","_dynamic_styles","Tjs=");
INSERT INTO wpcf_postmeta VALUES("1903","10","_dynamic_styles","Tjs=");
INSERT INTO wpcf_postmeta VALUES("1904","7886","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1905","7","_edit_lock","1542383673:1");
INSERT INTO wpcf_postmeta VALUES("1906","7887","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1907","7888","_mkhb_content_normal_header_desktop","[mkhb_row id=\"ciyk0megh00073j5lbaqqngk4\" device=\"desktop\" workspace=\"normal\" layout=\"6,6\" width=\"fixed\"][mkhb_col id=\"cj67b4wnt000b3h5ok7lpivzj\" device=\"desktop\" workspace=\"normal\" width=\"6\"][mkhb_logo id=\"cj6m476if000e3e5ojut0zwww\" device=\"desktop\" workspace=\"normal\" width=\"200px\" link-homepage=\"true\" display=\"inline\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000e3h5ojv9jqeqs\" device=\"desktop\" workspace=\"normal\" width=\"6\"][mkhb_navigation id=\"cj6m47a35000h3e5oalpl0ixp\" device=\"desktop\" workspace=\"normal\" margin=\"30px 20px 0 0\" hover-style=\"4\" alignment=\"right\" display=\"inline\" font-family=\"Roboto\" font-type=\"google\" font-subsets=\"cyrillic-ext,greek,latin-ext,latin,cyrillic,vietnamese,greek-ext\" font-variants=\"100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,900,900italic\" text-size=\"14px\" text-color=\"rgba(136,136,136,1)\" text-hover-color=\"rgba(34,34,34,1)\"][mkhb_search id=\"cj6m5rxl3000n3e5o5k3yr6xm\" device=\"desktop\" workspace=\"normal\" margin=\"40px 0 0 0\" icon-type=\"4\" icon-color=\"rgba(136,136,136,1)\" icon-hover-color=\"rgba(34,34,34,1)\" alignment=\"right\" display=\"inline\" visibility=\"desktop\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000h3h5ohqc6vvyq\" device=\"desktop\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000k3h5ozq2hl2iz\" device=\"desktop\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000n3h5o9d65yxru\" device=\"desktop\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000q3h5ohtuq4o22\" device=\"desktop\" workspace=\"normal\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1908","7888","_mkhb_content_normal_header_tablet","[mkhb_row id=\"ciyk0megi000e3j5lkmn1osno\" device=\"tablet\" workspace=\"normal\" layout=\"6,6\" width=\"fixed\"][mkhb_col id=\"cj67b4wnt000a3h5oqn8izoh1\" device=\"tablet\" workspace=\"normal\" width=\"6\"][mkhb_logo id=\"cj6m476if000d3e5oglr1z9ue\" device=\"tablet\" workspace=\"normal\" width=\"200px\" link-homepage=\"true\" display=\"inline\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000d3h5oy9q2vedj\" device=\"tablet\" workspace=\"normal\" width=\"6\"][mkhb_navigation id=\"cj6m47a35000g3e5oa1e9igga\" device=\"tablet\" workspace=\"normal\" margin=\"30px 10px 0 0\" hover-style=\"4\" alignment=\"right\" display=\"inline\" font-family=\"Roboto\" font-type=\"google\" font-subsets=\"cyrillic-ext,greek,latin-ext,latin,cyrillic,vietnamese,greek-ext\" font-variants=\"100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,900,900italic\" text-size=\"14px\" text-color=\"rgba(136,136,136,1)\" text-hover-color=\"rgba(34,34,34,1)\"][mkhb_search id=\"cj6m5rxl3000m3e5omyxggz06\" device=\"tablet\" workspace=\"normal\" margin=\"40px 20px 0 0\" icon-type=\"4\" icon-color=\"rgba(136,136,136,1)\" icon-hover-color=\"rgba(34,34,34,1)\" alignment=\"right\" display=\"inline\" visibility=\"desktop\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000g3h5oqu704a9a\" device=\"tablet\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000j3h5osdety0u5\" device=\"tablet\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000m3h5o7zkbtdz6\" device=\"tablet\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000p3h5oe5fmhqit\" device=\"tablet\" workspace=\"normal\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1909","7888","_mkhb_content_normal_header_mobile","[mkhb_row id=\"ciyk0megi000i3j5l2ik0dom2\" device=\"mobile\" workspace=\"normal\" layout=\"6,6\" width=\"fixed\"][mkhb_col id=\"cj67b4wnt00093h5o8pm8pntw\" device=\"mobile\" workspace=\"normal\" width=\"6\"][mkhb_logo id=\"cj6m476if000c3e5ofkm3zszw\" device=\"mobile\" workspace=\"normal\" width=\"200px\" link-homepage=\"true\" display=\"inline\"][mkhb_search id=\"cj6m5rxl3000l3e5odjnl05l9\" device=\"mobile\" workspace=\"normal\" margin=\"35px 0 0 0\" icon-type=\"4\" icon-color=\"rgba(136,136,136,1)\" icon-hover-color=\"rgba(34,34,34,1)\" alignment=\"right\" display=\"inline\" visibility=\"desktop\"][mkhb_navigation id=\"cj6m47a35000f3e5oonub0flw\" device=\"mobile\" workspace=\"normal\" nav-style=\"burger\" margin=\"25px 0 0 0\" hover-style=\"4\" alignment=\"right\" display=\"inline\" bar-color=\"rgba(136,136,136,1)\" box-color=\"rgba(255,255,255,1)\" font-family=\"Roboto\" font-type=\"google\" font-subsets=\"cyrillic-ext,greek,latin-ext,latin,cyrillic,vietnamese,greek-ext\" font-variants=\"100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,900,900italic\" text-size=\"14px\" text-color=\"rgba(136,136,136,1)\" text-hover-color=\"rgba(34,34,34,1)\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000c3h5o99tzkhmv\" device=\"mobile\" workspace=\"normal\" width=\"6\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000f3h5oia0rygma\" device=\"mobile\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000i3h5oode0cc48\" device=\"mobile\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000l3h5oda98thw4\" device=\"mobile\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000o3h5omu55sugr\" device=\"mobile\" workspace=\"normal\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1910","7888","_mkhb_content_sticky_header_desktop","[mkhb_row id=\"cj6f1n2qd00063h5o2w2ejryb\" device=\"desktop\" workspace=\"sticky\" layout=\"12\"][mkhb_col id=\"cj6f1iph300063h5ocbedhqh2\" device=\"desktop\" workspace=\"sticky\" width=\"12\"][/mkhb_col][mkhb_col id=\"cj6f1iph300093h5o0lib30g9\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000c3h5oq63yqucn\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000f3h5oxzp3thh2\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000i3h5o00qf6zys\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000l3h5o76j1o6sz\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1911","7888","_mkhb_content_sticky_header_tablet","[mkhb_row id=\"cj6f1n2qd00053h5o786pg9t0\" device=\"tablet\" workspace=\"sticky\" layout=\"12\"][mkhb_col id=\"cj6f1iph300053h5oqdoerx9p\" device=\"tablet\" workspace=\"sticky\" width=\"12\"][/mkhb_col][mkhb_col id=\"cj6f1iph300083h5ooeh6eef3\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000b3h5o6u6g5ey4\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000e3h5o23ubn3w1\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000h3h5o88fjcc2w\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000k3h5op4mnsblf\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1912","7888","_mkhb_content_sticky_header_mobile","[mkhb_row id=\"cj6f1n2qd00043h5okuylqd8q\" device=\"mobile\" workspace=\"sticky\" layout=\"12\"][mkhb_col id=\"cj6f1iph300043h5or780gdf4\" device=\"mobile\" workspace=\"sticky\" width=\"12\"][/mkhb_col][mkhb_col id=\"cj6f1iph300073h5orfomt3kt\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000a3h5ojy22bkxr\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000d3h5o1ljiz2vj\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000g3h5o0j5hr4yp\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000j3h5oil6klflj\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1913","7888","_mkhb_chains","a:6:{s:25:\"ciyk0megh00073j5lbaqqngk4\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}}s:25:\"ciyk0megi000e3j5lkmn1osno\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}}s:25:\"ciyk0megi000i3j5l2ik0dom2\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}}s:25:\"cj6f1n2qd00063h5o2w2ejryb\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}}s:25:\"cj6f1n2qd00053h5o786pg9t0\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}}s:25:\"cj6f1n2qd00043h5okuylqd8q\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}}}");
INSERT INTO wpcf_postmeta VALUES("1914","7888","_mkhb_chain","a:51:{s:25:\"ciyk0megh00073j5lbaqqngk4\";a:4:{s:6:\"source\";s:7:\"desktop\";s:7:\"desktop\";s:25:\"ciyk0megh00073j5lbaqqngk4\";s:6:\"tablet\";s:25:\"ciyk0megi000e3j5lkmn1osno\";s:6:\"mobile\";s:25:\"ciyk0megi000i3j5l2ik0dom2\";}s:25:\"cj67b4wnt000b3h5ok7lpivzj\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}s:25:\"cj6m476if000e3e5ojut0zwww\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m476if000c3e5ofkm3zszw\";s:6:\"tablet\";s:25:\"cj6m476if000d3e5oglr1z9ue\";s:7:\"desktop\";s:25:\"cj6m476if000e3e5ojut0zwww\";}s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}s:25:\"cj6m47a35000h3e5oalpl0ixp\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m47a35000f3e5oonub0flw\";s:6:\"tablet\";s:25:\"cj6m47a35000g3e5oa1e9igga\";s:7:\"desktop\";s:25:\"cj6m47a35000h3e5oalpl0ixp\";}s:25:\"cj6m5rxl3000n3e5o5k3yr6xm\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m5rxl3000l3e5odjnl05l9\";s:6:\"tablet\";s:25:\"cj6m5rxl3000m3e5omyxggz06\";s:7:\"desktop\";s:25:\"cj6m5rxl3000n3e5o5k3yr6xm\";}s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}s:25:\"cj67b4wnt000n3h5o9d65yxru\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}s:25:\"cj67b4wnt000q3h5ohtuq4o22\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}s:25:\"ciyk0megi000e3j5lkmn1osno\";a:4:{s:6:\"source\";s:7:\"desktop\";s:7:\"desktop\";s:25:\"ciyk0megh00073j5lbaqqngk4\";s:6:\"tablet\";s:25:\"ciyk0megi000e3j5lkmn1osno\";s:6:\"mobile\";s:25:\"ciyk0megi000i3j5l2ik0dom2\";}s:25:\"cj67b4wnt000a3h5oqn8izoh1\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}s:25:\"cj6m476if000d3e5oglr1z9ue\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m476if000c3e5ofkm3zszw\";s:6:\"tablet\";s:25:\"cj6m476if000d3e5oglr1z9ue\";s:7:\"desktop\";s:25:\"cj6m476if000e3e5ojut0zwww\";}s:25:\"cj67b4wnt000d3h5oy9q2vedj\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}s:25:\"cj6m47a35000g3e5oa1e9igga\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m47a35000f3e5oonub0flw\";s:6:\"tablet\";s:25:\"cj6m47a35000g3e5oa1e9igga\";s:7:\"desktop\";s:25:\"cj6m47a35000h3e5oalpl0ixp\";}s:25:\"cj6m5rxl3000m3e5omyxggz06\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m5rxl3000l3e5odjnl05l9\";s:6:\"tablet\";s:25:\"cj6m5rxl3000m3e5omyxggz06\";s:7:\"desktop\";s:25:\"cj6m5rxl3000n3e5o5k3yr6xm\";}s:25:\"cj67b4wnt000g3h5oqu704a9a\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}s:25:\"cj67b4wnt000j3h5osdety0u5\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}s:25:\"cj67b4wnt000p3h5oe5fmhqit\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}s:25:\"ciyk0megi000i3j5l2ik0dom2\";a:4:{s:6:\"source\";s:7:\"desktop\";s:7:\"desktop\";s:25:\"ciyk0megh00073j5lbaqqngk4\";s:6:\"tablet\";s:25:\"ciyk0megi000e3j5lkmn1osno\";s:6:\"mobile\";s:25:\"ciyk0megi000i3j5l2ik0dom2\";}s:25:\"cj67b4wnt00093h5o8pm8pntw\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}s:25:\"cj6m476if000c3e5ofkm3zszw\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m476if000c3e5ofkm3zszw\";s:6:\"tablet\";s:25:\"cj6m476if000d3e5oglr1z9ue\";s:7:\"desktop\";s:25:\"cj6m476if000e3e5ojut0zwww\";}s:25:\"cj6m5rxl3000l3e5odjnl05l9\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m5rxl3000l3e5odjnl05l9\";s:6:\"tablet\";s:25:\"cj6m5rxl3000m3e5omyxggz06\";s:7:\"desktop\";s:25:\"cj6m5rxl3000n3e5o5k3yr6xm\";}s:25:\"cj6m47a35000f3e5oonub0flw\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m47a35000f3e5oonub0flw\";s:6:\"tablet\";s:25:\"cj6m47a35000g3e5oa1e9igga\";s:7:\"desktop\";s:25:\"cj6m47a35000h3e5oalpl0ixp\";}s:25:\"cj67b4wnt000c3h5o99tzkhmv\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}s:25:\"cj67b4wnt000f3h5oia0rygma\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}s:25:\"cj67b4wnt000i3h5oode0cc48\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}s:25:\"cj67b4wnt000l3h5oda98thw4\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}s:25:\"cj67b4wnt000o3h5omu55sugr\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}s:25:\"cj6f1n2qd00063h5o2w2ejryb\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1n2qd00043h5okuylqd8q\";s:6:\"tablet\";s:25:\"cj6f1n2qd00053h5o786pg9t0\";s:7:\"desktop\";s:25:\"cj6f1n2qd00063h5o2w2ejryb\";}s:25:\"cj6f1iph300063h5ocbedhqh2\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}s:25:\"cj6f1iph300093h5o0lib30g9\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}s:25:\"cj6f1iph3000c3h5oq63yqucn\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}s:25:\"cj6f1iph3000f3h5oxzp3thh2\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}s:25:\"cj6f1iph3000i3h5o00qf6zys\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}s:25:\"cj6f1iph3000l3h5o76j1o6sz\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}s:25:\"cj6f1n2qd00053h5o786pg9t0\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1n2qd00043h5okuylqd8q\";s:6:\"tablet\";s:25:\"cj6f1n2qd00053h5o786pg9t0\";s:7:\"desktop\";s:25:\"cj6f1n2qd00063h5o2w2ejryb\";}s:25:\"cj6f1iph300053h5oqdoerx9p\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}s:25:\"cj6f1iph300083h5ooeh6eef3\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}s:25:\"cj6f1iph3000e3h5o23ubn3w1\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}s:25:\"cj6f1iph3000h3h5o88fjcc2w\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}s:25:\"cj6f1iph3000k3h5op4mnsblf\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}s:25:\"cj6f1n2qd00043h5okuylqd8q\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1n2qd00043h5okuylqd8q\";s:6:\"tablet\";s:25:\"cj6f1n2qd00053h5o786pg9t0\";s:7:\"desktop\";s:25:\"cj6f1n2qd00063h5o2w2ejryb\";}s:25:\"cj6f1iph300043h5or780gdf4\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}s:25:\"cj6f1iph300073h5orfomt3kt\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}s:25:\"cj6f1iph3000a3h5ojy22bkxr\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}s:25:\"cj6f1iph3000j3h5oil6klflj\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}}");
INSERT INTO wpcf_postmeta VALUES("121","9","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("122","9","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("123","9","_menu_item_type","post_type");
INSERT INTO wpcf_postmeta VALUES("124","9","_menu_item_object_id","7");
INSERT INTO wpcf_postmeta VALUES("125","9","_menu_item_object","page");
INSERT INTO wpcf_postmeta VALUES("126","9","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("127","18","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("128","18","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("129","18","_menu_item_type","post_type");
INSERT INTO wpcf_postmeta VALUES("130","18","_menu_item_object_id","16");
INSERT INTO wpcf_postmeta VALUES("131","18","_menu_item_object","page");
INSERT INTO wpcf_postmeta VALUES("132","18","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("134","20","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("135","20","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("136","20","_menu_item_type","post_type");
INSERT INTO wpcf_postmeta VALUES("137","20","_menu_item_object_id","12");
INSERT INTO wpcf_postmeta VALUES("138","20","_menu_item_object","page");
INSERT INTO wpcf_postmeta VALUES("139","20","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("141","21","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("142","21","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("143","21","_menu_item_type","post_type");
INSERT INTO wpcf_postmeta VALUES("144","21","_menu_item_object_id","10");
INSERT INTO wpcf_postmeta VALUES("145","21","_menu_item_object","page");
INSERT INTO wpcf_postmeta VALUES("146","21","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("147","21","_menu_item_megamenu","enabled");
INSERT INTO wpcf_postmeta VALUES("149","163","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("150","163","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("151","163","_single_post","false");
INSERT INTO wpcf_postmeta VALUES("152","163","_employees_single_layout","style1");
INSERT INTO wpcf_postmeta VALUES("153","163","_header_hero_bg_color","#636667");
INSERT INTO wpcf_postmeta VALUES("154","163","_header_hero_skin","light");
INSERT INTO wpcf_postmeta VALUES("155","163","_position","CEO");
INSERT INTO wpcf_postmeta VALUES("156","163","_desc","Donec sit amet lorem pretium neque fringilla imperdiet eu augue morbi non magna.");
INSERT INTO wpcf_postmeta VALUES("157","163","_email","#");
INSERT INTO wpcf_postmeta VALUES("158","163","_facebook","#");
INSERT INTO wpcf_postmeta VALUES("159","163","_twitter","#");
INSERT INTO wpcf_postmeta VALUES("160","163","_googleplus","#");
INSERT INTO wpcf_postmeta VALUES("161","163","_linkedin","#");
INSERT INTO wpcf_postmeta VALUES("162","163","featured","-1");
INSERT INTO wpcf_postmeta VALUES("163","163","_featured_plan","-1");
INSERT INTO wpcf_postmeta VALUES("164","163","_drop_shadow","-1");
INSERT INTO wpcf_postmeta VALUES("165","163","_column_bigger","-1");
INSERT INTO wpcf_postmeta VALUES("166","163","_share_button","-1");
INSERT INTO wpcf_postmeta VALUES("167","163","_thumbnail_id","165");
INSERT INTO wpcf_postmeta VALUES("168","163","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("169","166","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("170","166","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("171","166","_thumbnail_id","167");
INSERT INTO wpcf_postmeta VALUES("172","166","_single_post","false");
INSERT INTO wpcf_postmeta VALUES("173","166","_employees_single_layout","style1");
INSERT INTO wpcf_postmeta VALUES("174","166","_header_hero_bg_color","#636667");
INSERT INTO wpcf_postmeta VALUES("175","166","_header_hero_skin","light");
INSERT INTO wpcf_postmeta VALUES("176","166","_position","Nutritionist");
INSERT INTO wpcf_postmeta VALUES("177","166","_desc","Donec sit amet lorem pretium neque fringilla imperdiet eu augue morbi non magna.");
INSERT INTO wpcf_postmeta VALUES("178","166","_facebook","#");
INSERT INTO wpcf_postmeta VALUES("179","166","_twitter","#");
INSERT INTO wpcf_postmeta VALUES("180","166","_instagram","#");
INSERT INTO wpcf_postmeta VALUES("181","166","featured","-1");
INSERT INTO wpcf_postmeta VALUES("182","166","_featured_plan","-1");
INSERT INTO wpcf_postmeta VALUES("183","166","_drop_shadow","-1");
INSERT INTO wpcf_postmeta VALUES("184","166","_column_bigger","-1");
INSERT INTO wpcf_postmeta VALUES("185","166","_share_button","-1");
INSERT INTO wpcf_postmeta VALUES("186","166","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("187","166","_googleplus","#");
INSERT INTO wpcf_postmeta VALUES("188","166","_linkedin","#");
INSERT INTO wpcf_postmeta VALUES("189","171","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("190","171","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("191","171","_thumbnail_id","172");
INSERT INTO wpcf_postmeta VALUES("192","171","_single_post","false");
INSERT INTO wpcf_postmeta VALUES("193","171","_employees_single_layout","style1");
INSERT INTO wpcf_postmeta VALUES("194","171","_header_hero_bg_color","#636667");
INSERT INTO wpcf_postmeta VALUES("195","171","_header_hero_skin","light");
INSERT INTO wpcf_postmeta VALUES("196","171","_position","Nutritionist");
INSERT INTO wpcf_postmeta VALUES("197","171","_desc","Donec sit amet lorem pretium neque fringilla imperdiet eu augue morbi non magna.");
INSERT INTO wpcf_postmeta VALUES("198","171","_email","#");
INSERT INTO wpcf_postmeta VALUES("199","171","_facebook","#");
INSERT INTO wpcf_postmeta VALUES("200","171","featured","-1");
INSERT INTO wpcf_postmeta VALUES("201","171","_featured_plan","-1");
INSERT INTO wpcf_postmeta VALUES("202","171","_drop_shadow","-1");
INSERT INTO wpcf_postmeta VALUES("203","171","_column_bigger","-1");
INSERT INTO wpcf_postmeta VALUES("204","171","_share_button","-1");
INSERT INTO wpcf_postmeta VALUES("205","171","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("206","171","_googleplus","#");
INSERT INTO wpcf_postmeta VALUES("207","171","_linkedin","#");
INSERT INTO wpcf_postmeta VALUES("208","171","_instagram","#");
INSERT INTO wpcf_postmeta VALUES("209","174","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("210","174","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("211","174","_thumbnail_id","175");
INSERT INTO wpcf_postmeta VALUES("212","174","_single_post","false");
INSERT INTO wpcf_postmeta VALUES("213","174","_employees_single_layout","style1");
INSERT INTO wpcf_postmeta VALUES("214","174","_header_hero_bg_color","#636667");
INSERT INTO wpcf_postmeta VALUES("215","174","_header_hero_skin","light");
INSERT INTO wpcf_postmeta VALUES("216","174","_position","Nutritionist");
INSERT INTO wpcf_postmeta VALUES("217","174","_desc","Donec sit amet lorem pretium neque fringilla imperdiet eu augue morbi non magna.");
INSERT INTO wpcf_postmeta VALUES("218","174","_twitter","#");
INSERT INTO wpcf_postmeta VALUES("219","174","featured","-1");
INSERT INTO wpcf_postmeta VALUES("220","174","_featured_plan","-1");
INSERT INTO wpcf_postmeta VALUES("221","174","_drop_shadow","-1");
INSERT INTO wpcf_postmeta VALUES("222","174","_column_bigger","-1");
INSERT INTO wpcf_postmeta VALUES("223","174","_share_button","-1");
INSERT INTO wpcf_postmeta VALUES("224","174","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("225","174","_email","#");
INSERT INTO wpcf_postmeta VALUES("226","174","_facebook","#");
INSERT INTO wpcf_postmeta VALUES("227","174","_googleplus","#");
INSERT INTO wpcf_postmeta VALUES("228","174","_linkedin","#");
INSERT INTO wpcf_postmeta VALUES("229","174","_theme_options_build","575ec8889e17c");
INSERT INTO wpcf_postmeta VALUES("230","242","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("231","242","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("232","242","_menu_item_type","post_type");
INSERT INTO wpcf_postmeta VALUES("233","242","_menu_item_object_id","235");
INSERT INTO wpcf_postmeta VALUES("234","242","_menu_item_object","page");
INSERT INTO wpcf_postmeta VALUES("235","242","_menu_item_classes","a:1:{i:0;s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("236","242","_menu_item_megamenu","enabled");
INSERT INTO wpcf_postmeta VALUES("238","7822","_wp_attached_file","2015/12/blog-05.jpg");
INSERT INTO wpcf_postmeta VALUES("239","7822","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1140;s:6:\"height\";i:750;s:4:\"file\";s:19:\"2015/12/blog-05.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"blog-05-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"blog-05-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"blog-05-768x505.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:505;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"blog-05-1024x674.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("240","7822","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:1.66147770653244020166994232567958533763885498046875;s:5:\"bytes\";i:24116;s:11:\"size_before\";i:1451479;s:10:\"size_after\";i:1427363;s:4:\"time\";d:2.440000000000000834887714518117718398571014404296875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.11000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:248;s:11:\"size_before\";i:6048;s:10:\"size_after\";i:5739;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.890000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:790;s:11:\"size_before\";i:11729;s:10:\"size_after\";i:11273;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2;s:5:\"bytes\";i:879;s:11:\"size_before\";i:47001;s:10:\"size_after\";i:46061;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.060000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:2840;s:11:\"size_before\";i:71906;s:10:\"size_after\";i:70425;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.0500000000000000444089209850062616169452667236328125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:5800;s:10:\"size_after\";i:5739;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.9099999999999999200639422269887290894985198974609375;s:5:\"bytes\";i:672;s:11:\"size_before\";i:38428;s:10:\"size_after\";i:37695;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.9499999999999999555910790149937383830547332763671875;s:5:\"bytes\";i:1585;s:11:\"size_before\";i:84253;s:10:\"size_after\";i:82607;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.96999999999999975131004248396493494510650634765625;s:5:\"bytes\";i:216;s:11:\"size_before\";i:4640;s:10:\"size_after\";i:4363;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.899999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:581;s:11:\"size_before\";i:33757;s:10:\"size_after\";i:33115;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.179999999999999993338661852249060757458209991455078125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:33176;s:10:\"size_after\";i:33115;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.770000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:344;s:11:\"size_before\";i:10751;s:10:\"size_after\";i:10346;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.4199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:334;s:11:\"size_before\";i:8928;s:10:\"size_after\";i:8533;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.359999999999999875655021241982467472553253173828125;s:5:\"bytes\";i:507;s:11:\"size_before\";i:24069;s:10:\"size_after\";i:23501;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.75;s:5:\"bytes\";i:445;s:11:\"size_before\";i:13489;s:10:\"size_after\";i:12983;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.3499999999999996447286321199499070644378662109375;s:5:\"bytes\";i:365;s:11:\"size_before\";i:9785;s:10:\"size_after\";i:9359;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.600000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:633;s:11:\"size_before\";i:26715;s:10:\"size_after\";i:26021;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.28000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:374;s:11:\"size_before\";i:10163;s:10:\"size_after\";i:9728;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.680000000000000159872115546022541821002960205078125;s:5:\"bytes\";i:676;s:11:\"size_before\";i:27521;s:10:\"size_after\";i:26784;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.140000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:446;s:11:\"size_before\";i:16130;s:10:\"size_after\";i:15623;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.899999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:724;s:11:\"size_before\";i:27097;s:10:\"size_after\";i:26312;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.339999999999999857891452847979962825775146484375;s:5:\"bytes\";i:970;s:11:\"size_before\";i:44075;s:10:\"size_after\";i:43044;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2;s:5:\"bytes\";i:262;s:11:\"size_before\";i:16160;s:10:\"size_after\";i:15837;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.6699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:654;s:11:\"size_before\";i:42719;s:10:\"size_after\";i:42004;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.9199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:1085;s:11:\"size_before\";i:59552;s:10:\"size_after\";i:58406;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.45999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:833;s:11:\"size_before\";i:36412;s:10:\"size_after\";i:35518;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.180000000000000159872115546022541821002960205078125;s:5:\"bytes\";i:1576;s:11:\"size_before\";i:75079;s:10:\"size_after\";i:73442;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1499999999999999944488848768742172978818416595458984375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:42065;s:10:\"size_after\";i:42004;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.08000000000000000166533453693773481063544750213623046875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:73503;s:10:\"size_after\";i:73442;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.08000000000000000166533453693773481063544750213623046875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:73503;s:10:\"size_after\";i:73442;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.729999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:40321;s:11:\"size_before\";i:45724;s:10:\"size_after\";i:44931;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.08000000000000000166533453693773481063544750213623046875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:73503;s:10:\"size_after\";i:73442;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.319999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:640;s:11:\"size_before\";i:21145;s:10:\"size_after\";i:20444;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.890000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:717;s:11:\"size_before\";i:26940;s:10:\"size_after\";i:26162;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.9199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:792;s:11:\"size_before\";i:44467;s:10:\"size_after\";i:43614;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.37000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:805;s:11:\"size_before\";i:36492;s:10:\"size_after\";i:35626;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.0899999999999999966693309261245303787291049957275390625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:70486;s:10:\"size_after\";i:70425;s:4:\"time\";d:0.200000000000000011102230246251565404236316680908203125;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.310000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:745;s:11:\"size_before\";i:34928;s:10:\"size_after\";i:34122;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.13000000000000000444089209850062616169452667236328125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:46122;s:10:\"size_after\";i:46061;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.339999999999999857891452847979962825775146484375;s:5:\"bytes\";i:562;s:11:\"size_before\";i:18649;s:10:\"size_after\";i:18026;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.37999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:398;s:11:\"size_before\";i:13577;s:10:\"size_after\";i:13118;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:9:\"600x99999\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.14000000000000001332267629550187848508358001708984375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:44992;s:10:\"size_after\";i:44931;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}}}");
INSERT INTO wpcf_postmeta VALUES("243","7823","_wp_attached_file","2015/12/blog-06.jpg");
INSERT INTO wpcf_postmeta VALUES("244","7823","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1140;s:6:\"height\";i:750;s:4:\"file\";s:19:\"2015/12/blog-06.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"blog-06-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"blog-06-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"blog-06-768x505.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:505;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"blog-06-1024x674.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("245","7823","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:3.610918132139363745380933323758654296398162841796875;s:5:\"bytes\";i:131448;s:11:\"size_before\";i:3640293;s:10:\"size_after\";i:3508845;s:4:\"time\";d:3.3300000000000000710542735760100185871124267578125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.5099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:673;s:11:\"size_before\";i:9778;s:10:\"size_after\";i:9044;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.4900000000000002131628207280300557613372802734375;s:5:\"bytes\";i:2704;s:11:\"size_before\";i:21758;s:10:\"size_after\";i:20345;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.29999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:6290;s:11:\"size_before\";i:119824;s:10:\"size_after\";i:113473;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.6699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:18040;s:11:\"size_before\";i:194480;s:10:\"size_after\";i:185399;s:4:\"time\";d:0.270000000000000017763568394002504646778106689453125;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.67000000000000003996802888650563545525074005126953125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:9105;s:10:\"size_after\";i:9044;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.480000000000000426325641456060111522674560546875;s:5:\"bytes\";i:5217;s:11:\"size_before\";i:96336;s:10:\"size_after\";i:91058;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.910000000000000142108547152020037174224853515625;s:5:\"bytes\";i:12289;s:11:\"size_before\";i:251557;s:10:\"size_after\";i:239207;s:4:\"time\";d:0.25;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.519999999999999573674358543939888477325439453125;s:5:\"bytes\";i:444;s:11:\"size_before\";i:6717;s:10:\"size_after\";i:6212;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.62000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:4665;s:11:\"size_before\";i:84061;s:10:\"size_after\";i:79335;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.08000000000000000166533453693773481063544750213623046875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:79396;s:10:\"size_after\";i:79335;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.94000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:1332;s:11:\"size_before\";i:20066;s:10:\"size_after\";i:18673;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.0999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1055;s:11:\"size_before\";i:15729;s:10:\"size_after\";i:14613;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6;s:5:\"bytes\";i:3220;s:11:\"size_before\";i:54706;s:10:\"size_after\";i:51425;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.5;s:5:\"bytes\";i:1630;s:11:\"size_before\";i:25998;s:10:\"size_after\";i:24307;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.12999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:1175;s:11:\"size_before\";i:17327;s:10:\"size_after\";i:16091;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.9900000000000002131628207280300557613372802734375;s:5:\"bytes\";i:3578;s:11:\"size_before\";i:60797;s:10:\"size_after\";i:57158;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.29999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1267;s:11:\"size_before\";i:18191;s:10:\"size_after\";i:16863;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.82000000000000028421709430404007434844970703125;s:5:\"bytes\";i:3603;s:11:\"size_before\";i:62969;s:10:\"size_after\";i:59305;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.730000000000000426325641456060111522674560546875;s:5:\"bytes\";i:2211;s:11:\"size_before\";i:33736;s:10:\"size_after\";i:31464;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.8300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:3369;s:11:\"size_before\";i:58855;s:10:\"size_after\";i:55425;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.9000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:4838;s:11:\"size_before\";i:99909;s:10:\"size_after\";i:95010;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.12999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:2708;s:11:\"size_before\";i:53930;s:10:\"size_after\";i:51161;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.3499999999999996447286321199499070644378662109375;s:5:\"bytes\";i:5854;s:11:\"size_before\";i:110530;s:10:\"size_after\";i:104615;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.019999999999999573674358543939888477325439453125;s:5:\"bytes\";i:7889;s:11:\"size_before\";i:158453;s:10:\"size_after\";i:150503;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.20999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:4013;s:11:\"size_before\";i:78201;s:10:\"size_after\";i:74127;s:4:\"time\";d:0.200000000000000011102230246251565404236316680908203125;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.769999999999999573674358543939888477325439453125;s:5:\"bytes\";i:9604;s:11:\"size_before\";i:202464;s:10:\"size_after\";i:192799;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.059999999999999997779553950749686919152736663818359375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:104676;s:10:\"size_after\";i:104615;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.0299999999999999988897769753748434595763683319091796875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:192860;s:10:\"size_after\";i:192799;s:4:\"time\";d:0.1700000000000000122124532708767219446599483489990234375;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.0299999999999999988897769753748434595763683319091796875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:192860;s:10:\"size_after\";i:192799;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.0099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:364459;s:11:\"size_before\";i:137761;s:10:\"size_after\";i:130866;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.0299999999999999988897769753748434595763683319091796875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:192860;s:10:\"size_after\";i:192799;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.8300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:2373;s:11:\"size_before\";i:41782;s:10:\"size_after\";i:39348;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.67999999999999971578290569595992565155029296875;s:5:\"bytes\";i:3121;s:11:\"size_before\";i:55999;s:10:\"size_after\";i:52817;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.36000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:6006;s:11:\"size_before\";i:113105;s:10:\"size_after\";i:107038;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.5099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:4525;s:11:\"size_before\";i:83235;s:10:\"size_after\";i:78649;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.0299999999999999988897769753748434595763683319091796875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:185460;s:10:\"size_after\";i:185399;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.67999999999999971578290569595992565155029296875;s:5:\"bytes\";i:4748;s:11:\"size_before\";i:84595;s:10:\"size_after\";i:79786;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.05000000000000000277555756156289135105907917022705078125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:113534;s:10:\"size_after\";i:113473;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.1699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:2331;s:11:\"size_before\";i:38756;s:10:\"size_after\";i:36364;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.57000000000000028421709430404007434844970703125;s:5:\"bytes\";i:1713;s:11:\"size_before\";i:27010;s:10:\"size_after\";i:25236;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:9:\"600x99999\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.05000000000000000277555756156289135105907917022705078125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:130927;s:10:\"size_after\";i:130866;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}}}");
INSERT INTO wpcf_postmeta VALUES("248","7824","_wp_attached_file","2015/12/blog-07.jpg");
INSERT INTO wpcf_postmeta VALUES("249","7824","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1140;s:6:\"height\";i:750;s:4:\"file\";s:19:\"2015/12/blog-07.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"blog-07-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"blog-07-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"blog-07-768x505.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:505;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"blog-07-1024x674.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("250","7824","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:4.9076591951182262363317931885831058025360107421875;s:5:\"bytes\";i:201157;s:11:\"size_before\";i:4098838;s:10:\"size_after\";i:3897681;s:4:\"time\";d:4.49999999999999911182158029987476766109466552734375;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.9000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:732;s:11:\"size_before\";i:10039;s:10:\"size_after\";i:9246;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8;s:5:\"bytes\";i:3918;s:11:\"size_before\";i:25244;s:10:\"size_after\";i:23224;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.6699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:10525;s:11:\"size_before\";i:138047;s:10:\"size_after\";i:127461;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.980000000000000426325641456060111522674560546875;s:5:\"bytes\";i:30782;s:11:\"size_before\";i:221516;s:10:\"size_after\";i:206064;s:4:\"time\";d:0.320000000000000006661338147750939242541790008544921875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.66000000000000003108624468950438313186168670654296875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:9307;s:10:\"size_after\";i:9246;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.089999999999999857891452847979962825775146484375;s:5:\"bytes\";i:6921;s:11:\"size_before\";i:98417;s:10:\"size_after\";i:91435;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.94000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:19554;s:11:\"size_before\";i:282638;s:10:\"size_after\";i:263023;s:4:\"time\";d:0.200000000000000011102230246251565404236316680908203125;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.45999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:494;s:11:\"size_before\";i:7440;s:10:\"size_after\";i:6885;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.20000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:6105;s:11:\"size_before\";i:85692;s:10:\"size_after\";i:79526;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.08000000000000000166533453693773481063544750213623046875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:79587;s:10:\"size_after\";i:79526;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1568;s:11:\"size_before\";i:20709;s:10:\"size_after\";i:19080;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.730000000000000426325641456060111522674560546875;s:5:\"bytes\";i:1189;s:11:\"size_before\";i:16161;s:10:\"size_after\";i:14911;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.410000000000000142108547152020037174224853515625;s:5:\"bytes\";i:4078;s:11:\"size_before\";i:55855;s:10:\"size_after\";i:51716;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.9199999999999999289457264239899814128875732421875;s:5:\"bytes\";i:2324;s:11:\"size_before\";i:30129;s:10:\"size_after\";i:27744;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.03999999999999914734871708787977695465087890625;s:5:\"bytes\";i:1485;s:11:\"size_before\";i:19218;s:10:\"size_after\";i:17672;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.63999999999999968025576890795491635799407958984375;s:5:\"bytes\";i:5076;s:11:\"size_before\";i:67230;s:10:\"size_after\";i:62093;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.050000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1587;s:11:\"size_before\";i:20462;s:10:\"size_after\";i:18814;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.79000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:5488;s:11:\"size_before\";i:71207;s:10:\"size_after\";i:65658;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.519999999999999573674358543939888477325439453125;s:5:\"bytes\";i:2521;s:11:\"size_before\";i:34335;s:10:\"size_after\";i:31753;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.80999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:5461;s:11:\"size_before\";i:70664;s:10:\"size_after\";i:65142;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.80999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:8949;s:11:\"size_before\";i:132389;s:10:\"size_after\";i:123379;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.910000000000000142108547152020037174224853515625;s:5:\"bytes\";i:3928;s:11:\"size_before\";i:57732;s:10:\"size_after\";i:53743;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.95999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:7778;s:11:\"size_before\";i:112609;s:10:\"size_after\";i:104770;s:4:\"time\";d:0.330000000000000015543122344752191565930843353271484375;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.29000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:13161;s:11:\"size_before\";i:181390;s:10:\"size_after\";i:168168;s:4:\"time\";d:0.179999999999999993338661852249060757458209991455078125;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.19000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:7048;s:11:\"size_before\";i:98871;s:10:\"size_after\";i:91762;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.92999999999999971578290569595992565155029296875;s:5:\"bytes\";i:16681;s:11:\"size_before\";i:241720;s:10:\"size_after\";i:224978;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.059999999999999997779553950749686919152736663818359375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:104831;s:10:\"size_after\";i:104770;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.0299999999999999988897769753748434595763683319091796875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:225039;s:10:\"size_after\";i:224978;s:4:\"time\";d:0.270000000000000017763568394002504646778106689453125;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.0299999999999999988897769753748434595763683319091796875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:225039;s:10:\"size_after\";i:224978;s:4:\"time\";d:0.299999999999999988897769753748434595763683319091796875;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.4000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:387182;s:11:\"size_before\";i:140945;s:10:\"size_after\";i:131928;s:4:\"time\";d:0.1700000000000000122124532708767219446599483489990234375;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.0299999999999999988897769753748434595763683319091796875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:225039;s:10:\"size_after\";i:224978;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.5999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:4059;s:11:\"size_before\";i:54224;s:10:\"size_after\";i:50104;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.5;s:5:\"bytes\";i:5174;s:11:\"size_before\";i:69759;s:10:\"size_after\";i:64524;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.57000000000000028421709430404007434844970703125;s:5:\"bytes\";i:9741;s:11:\"size_before\";i:129422;s:10:\"size_after\";i:119620;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.69000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:7646;s:11:\"size_before\";i:100191;s:10:\"size_after\";i:92484;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.0299999999999999988897769753748434595763683319091796875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:206125;s:10:\"size_after\";i:206064;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:7519;s:11:\"size_before\";i:97641;s:10:\"size_after\";i:90061;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.05000000000000000277555756156289135105907917022705078125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:127522;s:10:\"size_after\";i:127461;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.1099999999999994315658113919198513031005859375;s:5:\"bytes\";i:3570;s:11:\"size_before\";i:44775;s:10:\"size_after\";i:41144;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.4000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:1988;s:11:\"size_before\";i:27689;s:10:\"size_after\";i:25640;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:9:\"600x99999\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.05000000000000000277555756156289135105907917022705078125;s:5:\"bytes\";i:0;s:11:\"size_before\";i:131989;s:10:\"size_after\";i:131928;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}}}");
INSERT INTO wpcf_postmeta VALUES("1928","7887","_mkhb_content_normal_header_tablet","[mkhb_row id=\"ciyk0megi000e3j5lkmn1osno\" device=\"tablet\" workspace=\"normal\" layout=\"6,6\" width=\"fixed\"][mkhb_col id=\"cj67b4wnt000a3h5oqn8izoh1\" device=\"tablet\" workspace=\"normal\" width=\"6\"][mkhb_logo id=\"cj6m476if000d3e5oglr1z9ue\" device=\"tablet\" workspace=\"normal\" width=\"200px\" link-homepage=\"true\" display=\"inline\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000d3h5oy9q2vedj\" device=\"tablet\" workspace=\"normal\" width=\"6\"][mkhb_navigation id=\"cj6m47a35000g3e5oa1e9igga\" device=\"tablet\" workspace=\"normal\" margin=\"30px 10px 0 0\" hover-style=\"4\" alignment=\"right\" display=\"inline\" font-family=\"Roboto\" font-type=\"google\" font-subsets=\"cyrillic-ext,greek,latin-ext,latin,cyrillic,vietnamese,greek-ext\" font-variants=\"100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,900,900italic\" text-size=\"14px\" text-color=\"rgba(136,136,136,1)\" text-hover-color=\"rgba(34,34,34,1)\"][mkhb_search id=\"cj6m5rxl3000m3e5omyxggz06\" device=\"tablet\" workspace=\"normal\" margin=\"40px 20px 0 0\" icon-type=\"4\" icon-color=\"rgba(136,136,136,1)\" icon-hover-color=\"rgba(34,34,34,1)\" alignment=\"right\" display=\"inline\" visibility=\"desktop\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000g3h5oqu704a9a\" device=\"tablet\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000j3h5osdety0u5\" device=\"tablet\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000m3h5o7zkbtdz6\" device=\"tablet\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000p3h5oe5fmhqit\" device=\"tablet\" workspace=\"normal\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("253","7825","_wp_attached_file","2015/12/blog-08.jpg");
INSERT INTO wpcf_postmeta VALUES("254","7825","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1140;s:6:\"height\";i:750;s:4:\"file\";s:19:\"2015/12/blog-08.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"blog-08-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"blog-08-300x197.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:197;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"blog-08-768x505.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:505;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"blog-08-1024x674.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:674;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("255","7825","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:2.484868022706748558192657583276741206645965576171875;s:5:\"bytes\";i:48098;s:11:\"size_before\";i:1935636;s:10:\"size_after\";i:1887538;s:4:\"time\";d:2.750000000000000444089209850062616169452667236328125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.13999999999999968025576890795491635799407958984375;s:5:\"bytes\";i:516;s:11:\"size_before\";i:8084;s:10:\"size_after\";i:7507;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.78000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:1876;s:11:\"size_before\";i:17289;s:10:\"size_after\";i:16290;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.149999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:1952;s:11:\"size_before\";i:63804;s:10:\"size_after\";i:61791;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.62000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:4846;s:11:\"size_before\";i:94649;s:10:\"size_after\";i:92165;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.810000000000000053290705182007513940334320068359375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7568;s:10:\"size_after\";i:7507;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.140000000000000124344978758017532527446746826171875;s:5:\"bytes\";i:1458;s:11:\"size_before\";i:48342;s:10:\"size_after\";i:46823;s:4:\"time\";d:0.1499999999999999944488848768742172978818416595458984375;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.220000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:2346;s:11:\"size_before\";i:108632;s:10:\"size_after\";i:106225;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.589999999999999857891452847979962825775146484375;s:5:\"bytes\";i:429;s:11:\"size_before\";i:6456;s:10:\"size_after\";i:5966;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.29999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1343;s:11:\"size_before\";i:42520;s:10:\"size_after\";i:41116;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1499999999999999944488848768742172978818416595458984375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:41177;s:10:\"size_after\";i:41116;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.07000000000000028421709430404007434844970703125;s:5:\"bytes\";i:802;s:11:\"size_before\";i:14209;s:10:\"size_after\";i:13346;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.04999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:653;s:11:\"size_before\";i:11801;s:10:\"size_after\";i:11087;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.019999999999999573674358543939888477325439453125;s:5:\"bytes\";i:1180;s:11:\"size_before\";i:30870;s:10:\"size_after\";i:29629;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.5800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1044;s:11:\"size_before\";i:19791;s:10:\"size_after\";i:18686;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.0999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:769;s:11:\"size_before\";i:13612;s:10:\"size_after\";i:12782;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.20999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1461;s:11:\"size_before\";i:36127;s:10:\"size_after\";i:34605;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.05999999999999960920149533194489777088165283203125;s:5:\"bytes\";i:813;s:11:\"size_before\";i:14419;s:10:\"size_after\";i:13545;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.46999999999999975131004248396493494510650634765625;s:5:\"bytes\";i:1650;s:11:\"size_before\";i:38262;s:10:\"size_after\";i:36551;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.17999999999999971578290569595992565155029296875;s:5:\"bytes\";i:1034;s:11:\"size_before\";i:21124;s:10:\"size_after\";i:20029;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.53000000000000024868995751603506505489349365234375;s:5:\"bytes\";i:1717;s:11:\"size_before\";i:39279;s:10:\"size_after\";i:37501;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.20000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1721;s:11:\"size_before\";i:55638;s:10:\"size_after\";i:53856;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.2400000000000002131628207280300557613372802734375;s:5:\"bytes\";i:862;s:11:\"size_before\";i:28522;s:10:\"size_after\";i:27599;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.069999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:1598;s:11:\"size_before\";i:53979;s:10:\"size_after\";i:52320;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.899999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:2253;s:11:\"size_before\";i:79815;s:10:\"size_after\";i:77501;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.979999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1907;s:11:\"size_before\";i:49501;s:10:\"size_after\";i:47533;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.62999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:2554;s:11:\"size_before\";i:99303;s:10:\"size_after\";i:96688;s:4:\"time\";d:0.1700000000000000122124532708767219446599483489990234375;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.11999999999999999555910790149937383830547332763671875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:52381;s:10:\"size_after\";i:52320;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.059999999999999997779553950749686919152736663818359375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:96749;s:10:\"size_after\";i:96688;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.059999999999999997779553950749686919152736663818359375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:96749;s:10:\"size_after\";i:96688;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.589999999999999857891452847979962825775146484375;s:5:\"bytes\";i:75657;s:11:\"size_before\";i:62627;s:10:\"size_after\";i:61003;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.059999999999999997779553950749686919152736663818359375;s:5:\"bytes\";i:0;s:11:\"size_before\";i:96749;s:10:\"size_after\";i:96688;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.54000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:1198;s:11:\"size_before\";i:27738;s:10:\"size_after\";i:26479;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.480000000000000426325641456060111522674560546875;s:5:\"bytes\";i:1615;s:11:\"size_before\";i:37445;s:10:\"size_after\";i:35769;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.270000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1904;s:11:\"size_before\";i:60103;s:10:\"size_after\";i:58138;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1937;s:11:\"size_before\";i:51620;s:10:\"size_after\";i:49622;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.070000000000000006661338147750939242541790008544921875;s:5:\"bytes\";i:0;s:11:\"size_before\";i:92226;s:10:\"size_after\";i:92165;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:1821;s:11:\"size_before\";i:48658;s:10:\"size_after\";i:46776;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1000000000000000055511151231257827021181583404541015625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:61852;s:10:\"size_after\";i:61791;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.9900000000000002131628207280300557613372802734375;s:5:\"bytes\";i:1287;s:11:\"size_before\";i:27014;s:10:\"size_after\";i:25666;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:7:\"266x266\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.089999999999999857891452847979962825775146484375;s:5:\"bytes\";i:849;s:11:\"size_before\";i:17888;s:10:\"size_after\";i:16978;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:9:\"600x99999\";O:8:\"stdClass\":5:{s:7:\"percent\";d:0.1000000000000000055511151231257827021181583404541015625;s:5:\"bytes\";i:0;s:11:\"size_before\";i:61064;s:10:\"size_after\";i:61003;s:4:\"time\";d:0.200000000000000011102230246251565404236316680908203125;}}}");
INSERT INTO wpcf_postmeta VALUES("258","7864","_wp_attached_file","2016/06/map-marker.png");
INSERT INTO wpcf_postmeta VALUES("259","7864","_wp_attachment_metadata","a:5:{s:5:\"width\";i:36;s:6:\"height\";i:50;s:4:\"file\";s:22:\"2016/06/map-marker.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("260","7864","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:41.265276779295476217157556675374507904052734375;s:5:\"bytes\";i:574;s:11:\"size_before\";i:1391;s:10:\"size_after\";i:817;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:1:{s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:41.27000000000000312638803734444081783294677734375;s:5:\"bytes\";i:574;s:11:\"size_before\";i:1391;s:10:\"size_after\";i:817;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}}}");
INSERT INTO wpcf_postmeta VALUES("261","7874","_wp_attached_file","2016/06/home-layout-r.jpg");
INSERT INTO wpcf_postmeta VALUES("262","7874","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1440;s:6:\"height\";i:960;s:4:\"file\";s:25:\"2016/06/home-layout-r.jpg\";s:5:\"sizes\";a:6:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"home-layout-r-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"home-layout-r-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"home-layout-r-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"home-layout-r-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:16:\"landscape-tablet\";a:6:{s:4:\"file\";s:26:\"home-layout-r-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:1024;s:12:\"height_query\";i:768;}s:16:\"landscape-mobile\";a:6:{s:4:\"file\";s:25:\"home-layout-r-736x414.jpg\";s:5:\"width\";i:736;s:6:\"height\";i:414;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:736;s:12:\"height_query\";i:414;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("263","7874","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:94.5199999999999960209606797434389591217041015625;s:5:\"bytes\";i:58714;s:11:\"size_before\";i:1667704;s:10:\"size_after\";i:91409;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.7400000000000002131628207280300557613372802734375;s:5:\"bytes\";i:442;s:11:\"size_before\";i:7699;s:10:\"size_after\";i:7257;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.92999999999999971578290569595992565155029296875;s:5:\"bytes\";i:1610;s:11:\"size_before\";i:16334;s:10:\"size_after\";i:15529;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.149999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:1937;s:11:\"size_before\";i:61462;s:10:\"size_after\";i:59525;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.70999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:5094;s:11:\"size_before\";i:93956;s:10:\"size_after\";i:91409;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:7257;s:10:\"size_after\";i:7257;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.1699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:1506;s:11:\"size_before\";i:47504;s:10:\"size_after\";i:45998;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3;s:5:\"bytes\";i:3830;s:11:\"size_before\";i:127766;s:10:\"size_after\";i:123936;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.0099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:381;s:11:\"size_before\";i:6344;s:10:\"size_after\";i:5963;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.45000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1443;s:11:\"size_before\";i:41843;s:10:\"size_after\";i:40400;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:40400;s:10:\"size_after\";i:40400;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.82000000000000028421709430404007434844970703125;s:5:\"bytes\";i:654;s:11:\"size_before\";i:13559;s:10:\"size_after\";i:12905;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.2599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:599;s:11:\"size_before\";i:11382;s:10:\"size_after\";i:10783;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.609999999999999875655021241982467472553253173828125;s:5:\"bytes\";i:1085;s:11:\"size_before\";i:30086;s:10:\"size_after\";i:29001;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.660000000000000142108547152020037174224853515625;s:5:\"bytes\";i:879;s:11:\"size_before\";i:18881;s:10:\"size_after\";i:18002;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.20999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:686;s:11:\"size_before\";i:13177;s:10:\"size_after\";i:12491;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.8300000000000000710542735760100185871124267578125;s:5:\"bytes\";i:1328;s:11:\"size_before\";i:34660;s:10:\"size_after\";i:33332;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.20000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:720;s:11:\"size_before\";i:13846;s:10:\"size_after\";i:13126;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.95000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1435;s:11:\"size_before\";i:36372;s:10:\"size_after\";i:34937;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.13999999999999968025576890795491635799407958984375;s:5:\"bytes\";i:832;s:11:\"size_before\";i:20095;s:10:\"size_after\";i:19263;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.0999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1481;s:11:\"size_before\";i:36121;s:10:\"size_after\";i:34640;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.160000000000000142108547152020037174224853515625;s:5:\"bytes\";i:1617;s:11:\"size_before\";i:51186;s:10:\"size_after\";i:49569;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.5800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:642;s:11:\"size_before\";i:24913;s:10:\"size_after\";i:24271;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.089999999999999857891452847979962825775146484375;s:5:\"bytes\";i:1662;s:11:\"size_before\";i:53758;s:10:\"size_after\";i:52096;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.04000000000000003552713678800500929355621337890625;s:5:\"bytes\";i:2385;s:11:\"size_before\";i:78358;s:10:\"size_after\";i:75973;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.5;s:5:\"bytes\";i:1580;s:11:\"size_before\";i:45175;s:10:\"size_after\";i:43595;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.899999999999999911182158029987476766109466552734375;s:5:\"bytes\";i:2850;s:11:\"size_before\";i:98436;s:10:\"size_after\";i:95586;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:52096;s:10:\"size_after\";i:52096;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:95586;s:10:\"size_after\";i:95586;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.12999999999999989341858963598497211933135986328125;s:5:\"bytes\";i:3630;s:11:\"size_before\";i:116109;s:10:\"size_after\";i:112479;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.979999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1946;s:11:\"size_before\";i:65257;s:10:\"size_after\";i:63311;s:4:\"time\";d:0.13000000000000000444089209850062616169452667236328125;}s:25:\"portfolio-two_x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.020000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:4163;s:11:\"size_before\";i:137625;s:10:\"size_after\";i:133462;s:4:\"time\";d:0.330000000000000015543122344752191565930843353271484375;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:112479;s:10:\"size_after\";i:112479;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.95000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:989;s:11:\"size_before\";i:25044;s:10:\"size_after\";i:24055;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.75;s:5:\"bytes\";i:1260;s:11:\"size_before\";i:33563;s:10:\"size_after\";i:32303;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.279999999999999804600747665972448885440826416015625;s:5:\"bytes\";i:1910;s:11:\"size_before\";i:58287;s:10:\"size_after\";i:56377;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.79999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:1829;s:11:\"size_before\";i:48136;s:10:\"size_after\";i:46307;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:91409;s:10:\"size_after\";i:91409;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.600000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:1640;s:11:\"size_before\";i:45581;s:10:\"size_after\";i:43941;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:16:\"portrait-desktop\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.7400000000000002131628207280300557613372802734375;s:5:\"bytes\";i:3549;s:11:\"size_before\";i:129426;s:10:\"size_after\";i:125877;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:59525;s:10:\"size_after\";i:59525;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.3499999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1120;s:11:\"size_before\";i:25763;s:10:\"size_after\";i:24643;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}}}");
INSERT INTO wpcf_postmeta VALUES("264","7878","_wp_attached_file","2016/06/blog_bg.jpg");
INSERT INTO wpcf_postmeta VALUES("265","7878","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1440;s:6:\"height\";i:961;s:4:\"file\";s:19:\"2016/06/blog_bg.jpg\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"blog_bg-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"blog_bg-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"blog_bg-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"blog_bg-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("266","7878","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:95.030000000000001136868377216160297393798828125;s:5:\"bytes\";i:74424;s:11:\"size_before\";i:1146027;s:10:\"size_after\";i:56985;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:41:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.600000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:166;s:11:\"size_before\";i:4607;s:10:\"size_after\";i:4441;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:6:\"medium\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.1699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:376;s:11:\"size_before\";i:8659;s:10:\"size_after\";i:8471;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:12:\"medium_large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.5099999999999997868371792719699442386627197265625;s:5:\"bytes\";i:1231;s:11:\"size_before\";i:35041;s:10:\"size_after\";i:33810;s:4:\"time\";d:0.0899999999999999966693309261245303787291049957275390625;}s:5:\"large\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.0800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:7380;s:11:\"size_before\";i:60675;s:10:\"size_after\";i:56985;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:4441;s:10:\"size_after\";i:4441;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:18:\"image-size-550x550\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.770000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:1082;s:11:\"size_before\";i:28720;s:10:\"size_after\";i:27638;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:22:\"image-size-550x550-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.17999999999999971578290569595992565155029296875;s:5:\"bytes\";i:10211;s:11:\"size_before\";i:111254;s:10:\"size_after\";i:101043;s:4:\"time\";d:0.1700000000000000122124532708767219446599483489990234375;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.29999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:124;s:11:\"size_before\";i:3762;s:10:\"size_after\";i:3638;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:28:\"photo-album-thumbnail-square\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.37000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:823;s:11:\"size_before\";i:24447;s:10:\"size_after\";i:23624;s:4:\"time\";d:0.11999999999999999555910790149937383830547332763671875;}s:15:\"employees-large\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:23624;s:10:\"size_after\";i:23624;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:15:\"employees-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.54999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:199;s:11:\"size_before\";i:7800;s:10:\"size_after\";i:7601;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:23:\"blog-magazine-thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.6699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:172;s:11:\"size_before\";i:6443;s:10:\"size_after\";i:6271;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:27:\"blog-magazine-thumbnail-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.220000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:371;s:11:\"size_before\";i:16737;s:10:\"size_after\";i:16366;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:27:\"woocommerce-recent-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.220000000000000195399252334027551114559173583984375;s:5:\"bytes\";i:221;s:11:\"size_before\";i:9935;s:10:\"size_after\";i:9714;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.660000000000000142108547152020037174224853515625;s:5:\"bytes\";i:193;s:11:\"size_before\";i:7252;s:10:\"size_after\";i:7059;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:17:\"blog-carousel-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.87000000000000010658141036401502788066864013671875;s:5:\"bytes\";i:342;s:11:\"size_before\";i:18315;s:10:\"size_after\";i:17973;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.569999999999999840127884453977458178997039794921875;s:5:\"bytes\";i:194;s:11:\"size_before\";i:7557;s:10:\"size_after\";i:7363;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:17:\"blog-showcase-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:1.9099999999999999200639422269887290894985198974609375;s:5:\"bytes\";i:364;s:11:\"size_before\";i:19095;s:10:\"size_after\";i:18731;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:13:\"portfolio-x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.0800000000000000710542735760100185871124267578125;s:5:\"bytes\";i:232;s:11:\"size_before\";i:11163;s:10:\"size_after\";i:10931;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:17:\"portfolio-two_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.350000000000000088817841970012523233890533447265625;s:5:\"bytes\";i:451;s:11:\"size_before\";i:19208;s:10:\"size_after\";i:18757;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:18:\"portfolio-four_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.480000000000000426325641456060111522674560546875;s:5:\"bytes\";i:2017;s:11:\"size_before\";i:36822;s:10:\"size_after\";i:34805;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:17:\"portfolio-x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.86000000000000031974423109204508364200592041015625;s:5:\"bytes\";i:813;s:11:\"size_before\";i:16727;s:10:\"size_after\";i:15914;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:21:\"portfolio-two_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.410000000000000142108547152020037174224853515625;s:5:\"bytes\";i:1478;s:11:\"size_before\";i:33515;s:10:\"size_after\";i:32037;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:23:\"portfolio-three_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:5.019999999999999573674358543939888477325439453125;s:5:\"bytes\";i:2375;s:11:\"size_before\";i:47299;s:10:\"size_after\";i:44924;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:19:\"portfolio-three_x_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.230000000000000426325641456060111522674560546875;s:5:\"bytes\";i:1168;s:11:\"size_before\";i:27614;s:10:\"size_after\";i:26446;s:4:\"time\";d:0.08000000000000000166533453693773481063544750213623046875;}s:22:\"portfolio-four_x_two_x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:6.839999999999999857891452847979962825775146484375;s:5:\"bytes\";i:4599;s:11:\"size_before\";i:67239;s:10:\"size_after\";i:62640;s:4:\"time\";d:0.1600000000000000033306690738754696212708950042724609375;}s:17:\"portfolio-x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:32037;s:10:\"size_after\";i:32037;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:21:\"portfolio-two_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:62640;s:10:\"size_after\";i:62640;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:22:\"portfolio-four_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.3499999999999996447286321199499070644378662109375;s:5:\"bytes\";i:7670;s:11:\"size_before\";i:91842;s:10:\"size_after\";i:84172;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:21:\"portfolio-x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:8.6400000000000005684341886080801486968994140625;s:5:\"bytes\";i:5257;s:11:\"size_before\";i:60836;s:10:\"size_after\";i:55579;s:4:\"time\";d:0.14000000000000001332267629550187848508358001708984375;}s:25:\"portfolio-two_x_two_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";d:9.9700000000000006394884621840901672840118408203125;s:5:\"bytes\";i:13527;s:11:\"size_before\";i:135723;s:10:\"size_after\";i:122196;s:4:\"time\";d:0.419999999999999984456877655247808434069156646728515625;}s:23:\"portfolio-three_x_x-@2x\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:84172;s:10:\"size_after\";i:84172;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.7599999999999997868371792719699442386627197265625;s:5:\"bytes\";i:429;s:11:\"size_before\";i:15543;s:10:\"size_after\";i:15114;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:27:\"portfolio-three_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.270000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:631;s:11:\"size_before\";i:19270;s:10:\"size_after\";i:18639;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:31:\"portfolio-three_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.20999999999999996447286321199499070644378662109375;s:5:\"bytes\";i:1036;s:11:\"size_before\";i:32250;s:10:\"size_after\";i:31214;s:4:\"time\";d:0.11000000000000000055511151231257827021181583404541015625;}s:30:\"portfolio-four_x_two_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.910000000000000142108547152020037174224853515625;s:5:\"bytes\";i:763;s:11:\"size_before\";i:26260;s:10:\"size_after\";i:25497;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:16:\"landscape-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:56985;s:10:\"size_after\";i:56985;s:4:\"time\";d:0.1000000000000000055511151231257827021181583404541015625;}s:16:\"landscape-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2.410000000000000142108547152020037174224853515625;s:5:\"bytes\";i:587;s:11:\"size_before\";i:24323;s:10:\"size_after\";i:23736;s:4:\"time\";d:0.070000000000000006661338147750939242541790008544921875;}s:16:\"portrait-desktop\";O:8:\"stdClass\":5:{s:7:\"percent\";d:7.95000000000000017763568394002504646778106689453125;s:5:\"bytes\";i:7672;s:11:\"size_before\";i:96563;s:10:\"size_after\";i:88891;s:4:\"time\";d:0.330000000000000015543122344752191565930843353271484375;}s:15:\"portrait-tablet\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:33810;s:10:\"size_after\";i:33810;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:15:\"portrait-mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:2;s:5:\"bytes\";i:270;s:11:\"size_before\";i:13531;s:10:\"size_after\";i:13261;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}}}");
INSERT INTO wpcf_postmeta VALUES("267","7881","_wp_attached_file","2016/05/shutterstock_85451623-1.jpg");
INSERT INTO wpcf_postmeta VALUES("268","7881","_wp_attachment_metadata","a:5:{s:5:\"width\";i:200;s:6:\"height\";i:200;s:4:\"file\";s:35:\"2016/05/shutterstock_85451623-1.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"shutterstock_85451623-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"image-size-150x150\";a:6:{s:4:\"file\";s:35:\"shutterstock_85451623-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:150;s:12:\"height_query\";i:150;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("269","7881","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:26.85313383518133178995412890799343585968017578125;s:5:\"bytes\";i:23080;s:11:\"size_before\";i:85949;s:10:\"size_after\";i:62869;s:4:\"time\";d:0.179999999999999993338661852249060757458209991455078125;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:7:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.17999999999999971578290569595992565155029296875;s:5:\"bytes\";i:193;s:11:\"size_before\";i:4620;s:10:\"size_after\";i:4427;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:4427;s:10:\"size_after\";i:4427;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.29999999999999982236431605997495353221893310546875;s:5:\"bytes\";i:147;s:11:\"size_before\";i:3419;s:10:\"size_after\";i:3272;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:3.6699999999999999289457264239899814128875732421875;s:5:\"bytes\";i:250;s:11:\"size_before\";i:6803;s:10:\"size_after\";i:6553;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6553;s:10:\"size_after\";i:6553;s:4:\"time\";d:0.05000000000000000277555756156289135105907917022705078125;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.44000000000000039079850466805510222911834716796875;s:5:\"bytes\";i:303;s:11:\"size_before\";i:6832;s:10:\"size_after\";i:6529;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:41.63000000000000255795384873636066913604736328125;s:5:\"bytes\";i:22187;s:11:\"size_before\";i:53295;s:10:\"size_after\";i:31108;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}}}");
INSERT INTO wpcf_postmeta VALUES("271","7882","_wp_attached_file","2016/05/shutterstock_85451623-2.jpg");
INSERT INTO wpcf_postmeta VALUES("272","7882","_wp_attachment_metadata","a:5:{s:5:\"width\";i:200;s:6:\"height\";i:200;s:4:\"file\";s:35:\"2016/05/shutterstock_85451623-2.jpg\";s:5:\"sizes\";a:2:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:35:\"shutterstock_85451623-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:18:\"image-size-150x150\";a:6:{s:4:\"file\";s:35:\"shutterstock_85451623-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:11:\"width_query\";i:150;s:12:\"height_query\";i:150;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO wpcf_postmeta VALUES("273","7882","wp-smpro-smush-data","a:2:{s:5:\"stats\";a:8:{s:7:\"percent\";d:28.726772033469455180920704151503741741180419921875;s:5:\"bytes\";i:24410;s:11:\"size_before\";i:84973;s:10:\"size_after\";i:60563;s:4:\"time\";d:0.190000000000000002220446049250313080847263336181640625;s:11:\"api_version\";s:3:\"1.0\";s:5:\"lossy\";b:0;s:9:\"keep_exif\";i:0;}s:5:\"sizes\";a:7:{s:9:\"thumbnail\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.57000000000000028421709430404007434844970703125;s:5:\"bytes\";i:221;s:11:\"size_before\";i:4841;s:10:\"size_after\";i:4620;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:18:\"image-size-150x150\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:4620;s:10:\"size_after\";i:4620;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:27:\"photo-album-thumbnail-small\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.96999999999999975131004248396493494510650634765625;s:5:\"bytes\";i:182;s:11:\"size_before\";i:3662;s:10:\"size_after\";i:3480;s:4:\"time\";d:0.01000000000000000020816681711721685132943093776702880859375;}s:13:\"blog-carousel\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.339999999999999857891452847979962825775146484375;s:5:\"bytes\";i:306;s:11:\"size_before\";i:7051;s:10:\"size_after\";i:6745;s:4:\"time\";d:0.040000000000000000832667268468867405317723751068115234375;}s:13:\"blog-showcase\";O:8:\"stdClass\":5:{s:7:\"percent\";i:0;s:5:\"bytes\";i:0;s:11:\"size_before\";i:6745;s:10:\"size_after\";i:6745;s:4:\"time\";d:0.0299999999999999988897769753748434595763683319091796875;}s:26:\"portfolio-four_x_x-@mobile\";O:8:\"stdClass\":5:{s:7:\"percent\";d:4.589999999999999857891452847979962825775146484375;s:5:\"bytes\";i:324;s:11:\"size_before\";i:7053;s:10:\"size_after\";i:6729;s:4:\"time\";d:0.0200000000000000004163336342344337026588618755340576171875;}s:4:\"full\";O:8:\"stdClass\":5:{s:7:\"percent\";d:45.840000000000003410605131648480892181396484375;s:5:\"bytes\";i:23377;s:11:\"size_before\";i:51001;s:10:\"size_after\";i:27624;s:4:\"time\";d:0.059999999999999997779553950749686919152736663818359375;}}}");
INSERT INTO wpcf_postmeta VALUES("275","10","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("276","10","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("277","10","_wp_page_template","default");
INSERT INTO wpcf_postmeta VALUES("278","10","_wpb_vc_js_status","true");
INSERT INTO wpcf_postmeta VALUES("279","10","_layout","full");
INSERT INTO wpcf_postmeta VALUES("280","10","_padding","true");
INSERT INTO wpcf_postmeta VALUES("281","10","page_preloader","true");
INSERT INTO wpcf_postmeta VALUES("282","10","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("283","10","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("284","10","_enable_local_backgrounds","true");
INSERT INTO wpcf_postmeta VALUES("285","10","theme_header_style","3");
INSERT INTO wpcf_postmeta VALUES("286","10","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("287","10","theme_toolbar_toggle","false");
INSERT INTO wpcf_postmeta VALUES("288","10","_transparent_header","true");
INSERT INTO wpcf_postmeta VALUES("289","10","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("290","10","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("291","10","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("292","10","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("293","10","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("294","10","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("295","10","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("296","10","body_size","false");
INSERT INTO wpcf_postmeta VALUES("297","10","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("298","10","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("299","10","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("300","10","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("301","10","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("302","10","page_size","false");
INSERT INTO wpcf_postmeta VALUES("303","10","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("304","10","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("305","10","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("306","10","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("307","10","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("308","10","header_size","false");
INSERT INTO wpcf_postmeta VALUES("309","10","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("310","10","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("311","10","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("312","10","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("313","10","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("314","10","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("315","10","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("316","10","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("317","10","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("318","10","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("319","10","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("320","10","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("321","10","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("322","10","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("323","10","_theme_options_build","5beeec2b2d97f");
INSERT INTO wpcf_postmeta VALUES("324","10","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("327","12","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("328","12","_wpb_shortcodes_custom_css",".vc_custom_1464696761315{padding-right: 20px !important;}");
INSERT INTO wpcf_postmeta VALUES("329","12","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("330","12","_wp_page_template","default");
INSERT INTO wpcf_postmeta VALUES("331","12","_wpb_vc_js_status","true");
INSERT INTO wpcf_postmeta VALUES("332","12","_layout","full");
INSERT INTO wpcf_postmeta VALUES("333","12","_padding","true");
INSERT INTO wpcf_postmeta VALUES("334","12","page_preloader","true");
INSERT INTO wpcf_postmeta VALUES("335","12","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("336","12","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("337","12","_enable_local_backgrounds","true");
INSERT INTO wpcf_postmeta VALUES("338","12","theme_header_style","3");
INSERT INTO wpcf_postmeta VALUES("339","12","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("340","12","theme_toolbar_toggle","false");
INSERT INTO wpcf_postmeta VALUES("341","12","_transparent_header","true");
INSERT INTO wpcf_postmeta VALUES("342","12","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("343","12","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("344","12","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("345","12","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("346","12","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("347","12","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("348","12","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("349","12","body_size","false");
INSERT INTO wpcf_postmeta VALUES("350","12","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("351","12","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("352","12","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("353","12","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("354","12","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("355","12","page_size","false");
INSERT INTO wpcf_postmeta VALUES("356","12","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("357","12","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("358","12","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("359","12","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("360","12","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("361","12","header_size","false");
INSERT INTO wpcf_postmeta VALUES("362","12","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("363","12","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("364","12","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("365","12","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("366","12","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("367","12","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("368","12","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("369","12","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("370","12","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("371","12","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("372","12","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("373","12","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("374","12","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("375","12","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("376","12","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("377","12","_wpb_shortcodes_custom_css",".vc_custom_1464696761315{padding-right: 20px !important;}");
INSERT INTO wpcf_postmeta VALUES("378","12","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("381","16","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("382","16","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("383","16","_wp_page_template","default");
INSERT INTO wpcf_postmeta VALUES("384","16","_wpb_vc_js_status","true");
INSERT INTO wpcf_postmeta VALUES("385","16","_layout","full");
INSERT INTO wpcf_postmeta VALUES("386","16","_padding","true");
INSERT INTO wpcf_postmeta VALUES("387","16","page_preloader","false");
INSERT INTO wpcf_postmeta VALUES("388","16","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("389","16","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("390","16","_enable_local_backgrounds","true");
INSERT INTO wpcf_postmeta VALUES("391","16","theme_header_style","3");
INSERT INTO wpcf_postmeta VALUES("392","16","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("393","16","theme_toolbar_toggle","false");
INSERT INTO wpcf_postmeta VALUES("394","16","_transparent_header","true");
INSERT INTO wpcf_postmeta VALUES("395","16","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("396","16","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("397","16","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("398","16","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("399","16","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("400","16","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("401","16","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("402","16","body_size","false");
INSERT INTO wpcf_postmeta VALUES("403","16","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("404","16","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("405","16","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("406","16","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("407","16","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("408","16","page_size","false");
INSERT INTO wpcf_postmeta VALUES("409","16","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("410","16","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("411","16","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("412","16","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("413","16","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("414","16","header_size","false");
INSERT INTO wpcf_postmeta VALUES("415","16","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("416","16","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("417","16","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("418","16","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("419","16","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("420","16","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("421","16","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("422","16","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("423","16","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("424","16","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("425","16","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("426","16","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("427","16","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("428","16","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("429","16","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("430","16","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("431","16","_dynamic_styles","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");
INSERT INTO wpcf_postmeta VALUES("432","16","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("433","109","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("434","109","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("435","109","_url","#");
INSERT INTO wpcf_postmeta VALUES("436","109","_desc","“<span class=\"s1\">Lorem ipsum dolor sit amet cons ectetur adipiscing elit donec metus nibh sceler isque et suscipit id auctor vitae magna nam sollicitudin velit tortor ut efficitur velit sagittis id nulla eleifend vulputate accumsan aliquam erat volutpat vestibulum leo turpis mollis id tristique nec vehicula volutpat augue proin blandit mauris sit amet erat.</span>”");
INSERT INTO wpcf_postmeta VALUES("437","109","featured","-1");
INSERT INTO wpcf_postmeta VALUES("438","109","_featured_plan","-1");
INSERT INTO wpcf_postmeta VALUES("439","109","_drop_shadow","-1");
INSERT INTO wpcf_postmeta VALUES("440","109","_column_bigger","-1");
INSERT INTO wpcf_postmeta VALUES("441","109","_share_button","-1");
INSERT INTO wpcf_postmeta VALUES("442","109","_author","JOSH WOLF");
INSERT INTO wpcf_postmeta VALUES("443","109","_company","Nutritionist");
INSERT INTO wpcf_postmeta VALUES("444","109","_thumbnail_id","7882");
INSERT INTO wpcf_postmeta VALUES("445","109","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("446","109","_wp_old_slug","josh-wolfs-testimonial");
INSERT INTO wpcf_postmeta VALUES("447","112","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("448","112","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("449","112","_url","#");
INSERT INTO wpcf_postmeta VALUES("450","112","_desc","“D<span class=\"s1\">olor sit amet cons ectetur adipiscing elit donec metus nibh sceler isque et suscipit id auctor vitae magna nam sollicitudin velit tortor ut efficitur velit sagittis id nulla eleifend vulputate accumsan aliquam erat volutpat vestibulum leo turpis mollis id tristique nec vehicula volutpat augue.</span>”");
INSERT INTO wpcf_postmeta VALUES("451","112","featured","-1");
INSERT INTO wpcf_postmeta VALUES("452","112","_featured_plan","-1");
INSERT INTO wpcf_postmeta VALUES("453","112","_drop_shadow","-1");
INSERT INTO wpcf_postmeta VALUES("454","112","_column_bigger","-1");
INSERT INTO wpcf_postmeta VALUES("455","112","_share_button","-1");
INSERT INTO wpcf_postmeta VALUES("456","112","_author","Amanda Clark");
INSERT INTO wpcf_postmeta VALUES("457","112","_company","Dietitian");
INSERT INTO wpcf_postmeta VALUES("458","112","_thumbnail_id","7881");
INSERT INTO wpcf_postmeta VALUES("459","112","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("460","112","_wp_old_slug","john-does-testiomonial");
INSERT INTO wpcf_postmeta VALUES("461","216","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("462","216","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("463","216","_pricing_table_style","builder");
INSERT INTO wpcf_postmeta VALUES("464","216","skin","#25ae8d");
INSERT INTO wpcf_postmeta VALUES("465","216","featured","true");
INSERT INTO wpcf_postmeta VALUES("466","216","_ribbon_txt","FEATURED");
INSERT INTO wpcf_postmeta VALUES("467","216","_plan","Test");
INSERT INTO wpcf_postmeta VALUES("468","216","_price","9.99");
INSERT INTO wpcf_postmeta VALUES("469","216","_currency","€");
INSERT INTO wpcf_postmeta VALUES("470","216","_period","monthly");
INSERT INTO wpcf_postmeta VALUES("471","216","_features","<ul>\r\n 	<li>10 Projects</li>\r\n 	<li>32 GB Storage</li>\r\n 	<li>Unlimited Users</li>\r\n 	<li>15 GB Bandwidth</li>\r\n 	<li><i class=\"mk-icon-ok\"></i></li>\r\n 	<li>Enhanced Security</li>\r\n 	<li>Retina Display Ready</li>\r\n 	<li><i class=\"mk-icon-ok\"></i></li>\r\n 	<li><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i></li>\r\n</ul>");
INSERT INTO wpcf_postmeta VALUES("472","216","_featured_plan","false");
INSERT INTO wpcf_postmeta VALUES("473","216","_specifications_text","<ul>\r\n 	<li>Diet Plan</li>\r\n 	<li>Personal Coach</li>\r\n 	<li>Training App</li>\r\n 	<li>Custom Plans</li>\r\n</ul>");
INSERT INTO wpcf_postmeta VALUES("474","216","_title_price_text","light");
INSERT INTO wpcf_postmeta VALUES("475","216","_specifications_text_color","light");
INSERT INTO wpcf_postmeta VALUES("476","216","_featured_badge_text_color","light");
INSERT INTO wpcf_postmeta VALUES("477","216","_button_text_color","light");
INSERT INTO wpcf_postmeta VALUES("478","216","_drop_shadow","true");
INSERT INTO wpcf_postmeta VALUES("479","216","_column_bigger","true");
INSERT INTO wpcf_postmeta VALUES("480","216","_btn_text","Purchase");
INSERT INTO wpcf_postmeta VALUES("481","216","_button_style","flat");
INSERT INTO wpcf_postmeta VALUES("482","216","_share_button","-1");
INSERT INTO wpcf_postmeta VALUES("483","216","_title_background","#72b82b");
INSERT INTO wpcf_postmeta VALUES("484","216","_price_background","#72b82b");
INSERT INTO wpcf_postmeta VALUES("485","216","_btn_url","#");
INSERT INTO wpcf_postmeta VALUES("486","216","_specifications_background","#86c446");
INSERT INTO wpcf_postmeta VALUES("487","216","_featured_badge_background","#98d658");
INSERT INTO wpcf_postmeta VALUES("488","216","_plan_name","Medium");
INSERT INTO wpcf_postmeta VALUES("489","216","_featured_plan_text","Featured");
INSERT INTO wpcf_postmeta VALUES("490","216","_button_bg_color","#72b82b");
INSERT INTO wpcf_postmeta VALUES("491","216","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("492","219","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("493","219","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("494","219","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("495","219","_pricing_table_style","builder");
INSERT INTO wpcf_postmeta VALUES("496","219","skin","#25ae8d");
INSERT INTO wpcf_postmeta VALUES("497","219","featured","true");
INSERT INTO wpcf_postmeta VALUES("498","219","_ribbon_txt","FEATURED");
INSERT INTO wpcf_postmeta VALUES("499","219","_plan","Test");
INSERT INTO wpcf_postmeta VALUES("500","219","_price","1.99");
INSERT INTO wpcf_postmeta VALUES("501","219","_currency","€");
INSERT INTO wpcf_postmeta VALUES("502","219","_period","monthly");
INSERT INTO wpcf_postmeta VALUES("503","219","_features","<ul>\r\n 	<li>10 Projects</li>\r\n 	<li>32 GB Storage</li>\r\n 	<li>Unlimited Users</li>\r\n 	<li>15 GB Bandwidth</li>\r\n 	<li><i class=\"mk-icon-ok\"></i></li>\r\n 	<li>Enhanced Security</li>\r\n 	<li>Retina Display Ready</li>\r\n 	<li><i class=\"mk-icon-ok\"></i></li>\r\n 	<li><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i></li>\r\n</ul>");
INSERT INTO wpcf_postmeta VALUES("504","219","_featured_plan","false");
INSERT INTO wpcf_postmeta VALUES("505","219","_featured_plan_text","Featured");
INSERT INTO wpcf_postmeta VALUES("506","219","_specifications_text","<ul>\r\n 	<li>Diet Plan</li>\r\n 	<li>Personal Coach</li>\r\n 	<li>Training App</li>\r\n 	<li>Custom Plans</li>\r\n</ul>");
INSERT INTO wpcf_postmeta VALUES("507","219","_title_price_text","dark");
INSERT INTO wpcf_postmeta VALUES("508","219","_specifications_text_color","dark");
INSERT INTO wpcf_postmeta VALUES("509","219","_featured_badge_text_color","dark");
INSERT INTO wpcf_postmeta VALUES("510","219","_button_text_color","dark");
INSERT INTO wpcf_postmeta VALUES("511","219","_drop_shadow","false");
INSERT INTO wpcf_postmeta VALUES("512","219","_column_bigger","false");
INSERT INTO wpcf_postmeta VALUES("513","219","_btn_text","Purchase");
INSERT INTO wpcf_postmeta VALUES("514","219","_button_style","flat");
INSERT INTO wpcf_postmeta VALUES("515","219","_share_button","-1");
INSERT INTO wpcf_postmeta VALUES("516","219","_title_background","#ffffff");
INSERT INTO wpcf_postmeta VALUES("517","219","_price_background","#ffffff");
INSERT INTO wpcf_postmeta VALUES("518","219","_btn_url","#");
INSERT INTO wpcf_postmeta VALUES("519","219","_specifications_background","#ffffff");
INSERT INTO wpcf_postmeta VALUES("520","219","_featured_badge_background","#b8e986");
INSERT INTO wpcf_postmeta VALUES("521","219","_dp_original","216");
INSERT INTO wpcf_postmeta VALUES("522","219","_button_bg_color","#ebebeb");
INSERT INTO wpcf_postmeta VALUES("523","219","_plan_name","Starter");
INSERT INTO wpcf_postmeta VALUES("524","223","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("525","223","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("526","223","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("527","223","_pricing_table_style","builder");
INSERT INTO wpcf_postmeta VALUES("528","223","skin","#25ae8d");
INSERT INTO wpcf_postmeta VALUES("529","223","featured","true");
INSERT INTO wpcf_postmeta VALUES("530","223","_ribbon_txt","FEATURED");
INSERT INTO wpcf_postmeta VALUES("531","223","_plan","Test");
INSERT INTO wpcf_postmeta VALUES("532","223","_price","19.99");
INSERT INTO wpcf_postmeta VALUES("533","223","_currency","€");
INSERT INTO wpcf_postmeta VALUES("534","223","_period","monthly");
INSERT INTO wpcf_postmeta VALUES("535","223","_features","<ul>\r\n 	<li>10 Projects</li>\r\n 	<li>32 GB Storage</li>\r\n 	<li>Unlimited Users</li>\r\n 	<li>15 GB Bandwidth</li>\r\n 	<li><i class=\"mk-icon-ok\"></i></li>\r\n 	<li>Enhanced Security</li>\r\n 	<li>Retina Display Ready</li>\r\n 	<li><i class=\"mk-icon-ok\"></i></li>\r\n 	<li><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i><i class=\"mk-icon-star\"></i></li>\r\n</ul>");
INSERT INTO wpcf_postmeta VALUES("536","223","_featured_plan","false");
INSERT INTO wpcf_postmeta VALUES("537","223","_featured_plan_text","Featured");
INSERT INTO wpcf_postmeta VALUES("538","223","_specifications_text","<ul>\r\n 	<li>Diet Plan</li>\r\n 	<li>Personal Coach</li>\r\n 	<li>Training App</li>\r\n 	<li>Custom Plans</li>\r\n</ul>");
INSERT INTO wpcf_postmeta VALUES("539","223","_title_price_text","dark");
INSERT INTO wpcf_postmeta VALUES("540","223","_specifications_text_color","dark");
INSERT INTO wpcf_postmeta VALUES("541","223","_featured_badge_text_color","dark");
INSERT INTO wpcf_postmeta VALUES("542","223","_button_text_color","dark");
INSERT INTO wpcf_postmeta VALUES("543","223","_drop_shadow","false");
INSERT INTO wpcf_postmeta VALUES("544","223","_column_bigger","false");
INSERT INTO wpcf_postmeta VALUES("545","223","_btn_text","Purchase");
INSERT INTO wpcf_postmeta VALUES("546","223","_button_style","flat");
INSERT INTO wpcf_postmeta VALUES("547","223","_share_button","-1");
INSERT INTO wpcf_postmeta VALUES("548","223","_title_background","#ffffff");
INSERT INTO wpcf_postmeta VALUES("549","223","_price_background","#ffffff");
INSERT INTO wpcf_postmeta VALUES("550","223","_btn_url","#");
INSERT INTO wpcf_postmeta VALUES("551","223","_specifications_background","#ffffff");
INSERT INTO wpcf_postmeta VALUES("552","223","_featured_badge_background","#b8e986");
INSERT INTO wpcf_postmeta VALUES("553","223","_dp_original","216");
INSERT INTO wpcf_postmeta VALUES("554","223","_plan_name","PRO");
INSERT INTO wpcf_postmeta VALUES("555","223","_button_bg_color","#ebebeb");
INSERT INTO wpcf_postmeta VALUES("556","235","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("557","235","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("558","235","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("559","235","_wp_page_template","default");
INSERT INTO wpcf_postmeta VALUES("560","235","_wpb_vc_js_status","true");
INSERT INTO wpcf_postmeta VALUES("561","235","_layout","full");
INSERT INTO wpcf_postmeta VALUES("562","235","_padding","true");
INSERT INTO wpcf_postmeta VALUES("563","235","page_preloader","true");
INSERT INTO wpcf_postmeta VALUES("564","235","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("565","235","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("566","235","_enable_local_backgrounds","true");
INSERT INTO wpcf_postmeta VALUES("567","235","theme_header_style","3");
INSERT INTO wpcf_postmeta VALUES("568","235","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("569","235","theme_toolbar_toggle","false");
INSERT INTO wpcf_postmeta VALUES("570","235","_transparent_header","true");
INSERT INTO wpcf_postmeta VALUES("571","235","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("572","235","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("573","235","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("574","235","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("575","235","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("576","235","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("577","235","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("578","235","body_size","false");
INSERT INTO wpcf_postmeta VALUES("579","235","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("580","235","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("581","235","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("582","235","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("583","235","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("584","235","page_size","false");
INSERT INTO wpcf_postmeta VALUES("585","235","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("586","235","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("587","235","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("588","235","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("589","235","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("590","235","header_size","false");
INSERT INTO wpcf_postmeta VALUES("591","235","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("592","235","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("593","235","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("594","235","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("595","235","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("596","235","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("597","235","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("598","235","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("599","235","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("600","235","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("601","235","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("602","235","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("603","235","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("604","235","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("605","235","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("606","235","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("607","235","_dp_original","10");
INSERT INTO wpcf_postmeta VALUES("608","235","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("609","258","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("610","258","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("611","258","_form","<p class=\"double\">[text* your-name placeholder \"FIRST NAME & LAST NAME\"] [email* your-email placeholder \"EMAIL ADDRESS\"]</p>\n\n<p class=\"full\">[text your-subject placeholder \"SUBJECT\"] </p>\n\n<p class=\"full\">[textarea your-message placeholder \"MESSAGE\"] </p>\n\n<p>[submit \"Send\"]</p>");
INSERT INTO wpcf_postmeta VALUES("612","258","_mail","a:8:{s:7:\"subject\";s:23:\"Jueves \"[your-subject]\"\";s:6:\"sender\";s:41:\"[your-name] <wordpress@demos.artbees.net>\";s:4:\"body\";s:184:\"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Jueves (http://demos.artbees.net/jupiter5/jueves)\";s:9:\"recipient\";s:16:\"info@artbees.net\";s:18:\"additional_headers\";s:22:\"Reply-To: [your-email]\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO wpcf_postmeta VALUES("613","258","_mail_2","a:9:{s:6:\"active\";b:0;s:7:\"subject\";s:23:\"Jueves \"[your-subject]\"\";s:6:\"sender\";s:36:\"Jueves <wordpress@demos.artbees.net>\";s:4:\"body\";s:126:\"Message Body:\n[your-message]\n\n--\nThis e-mail was sent from a contact form on Jueves (http://demos.artbees.net/jupiter5/jueves)\";s:9:\"recipient\";s:12:\"[your-email]\";s:18:\"additional_headers\";s:26:\"Reply-To: info@artbees.net\";s:11:\"attachments\";s:0:\"\";s:8:\"use_html\";b:0;s:13:\"exclude_blank\";b:0;}");
INSERT INTO wpcf_postmeta VALUES("614","258","_messages","a:23:{s:12:\"mail_sent_ok\";s:45:\"Thank you for your message. It has been sent.\";s:12:\"mail_sent_ng\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:12:\"accept_terms\";s:69:\"You must accept the terms and conditions before sending your message.\";s:16:\"invalid_required\";s:22:\"The field is required.\";s:16:\"invalid_too_long\";s:22:\"The field is too long.\";s:17:\"invalid_too_short\";s:23:\"The field is too short.\";s:12:\"invalid_date\";s:29:\"The date format is incorrect.\";s:14:\"date_too_early\";s:44:\"The date is before the earliest one allowed.\";s:13:\"date_too_late\";s:41:\"The date is after the latest one allowed.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:14:\"invalid_number\";s:29:\"The number format is invalid.\";s:16:\"number_too_small\";s:47:\"The number is smaller than the minimum allowed.\";s:16:\"number_too_large\";s:46:\"The number is larger than the maximum allowed.\";s:23:\"quiz_answer_not_correct\";s:36:\"The answer to the quiz is incorrect.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:13:\"invalid_email\";s:38:\"The e-mail address entered is invalid.\";s:11:\"invalid_url\";s:19:\"The URL is invalid.\";s:11:\"invalid_tel\";s:32:\"The telephone number is invalid.\";}");
INSERT INTO wpcf_postmeta VALUES("615","258","_locale","en_US");
INSERT INTO wpcf_postmeta VALUES("618","501","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("619","501","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("620","501","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("621","501","enable_noti_bar","-1");
INSERT INTO wpcf_postmeta VALUES("622","501","_layout","right");
INSERT INTO wpcf_postmeta VALUES("623","501","_page_disable_title","-1");
INSERT INTO wpcf_postmeta VALUES("624","501","_enable_slidehsow","-1");
INSERT INTO wpcf_postmeta VALUES("625","501","_icarousel_autoplay","-1");
INSERT INTO wpcf_postmeta VALUES("626","501","_icarousel_3d","-1");
INSERT INTO wpcf_postmeta VALUES("627","501","_icarousel_pause_on_hover","-1");
INSERT INTO wpcf_postmeta VALUES("628","501","_icarousel_direction_nav","-1");
INSERT INTO wpcf_postmeta VALUES("629","501","_flexslider_disableCaption","-1");
INSERT INTO wpcf_postmeta VALUES("630","501","_flexslider_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("631","501","_flexslider_pauseOnHover","-1");
INSERT INTO wpcf_postmeta VALUES("632","501","_enable_page_gmap","-1");
INSERT INTO wpcf_postmeta VALUES("633","501","_enable_panControl","-1");
INSERT INTO wpcf_postmeta VALUES("634","501","_enable_draggable","-1");
INSERT INTO wpcf_postmeta VALUES("635","501","_enable_scrollwheel","-1");
INSERT INTO wpcf_postmeta VALUES("636","501","_enable_zoomControl","-1");
INSERT INTO wpcf_postmeta VALUES("637","501","_enable_mapTypeControl","-1");
INSERT INTO wpcf_postmeta VALUES("638","501","_enable_scaleControl","-1");
INSERT INTO wpcf_postmeta VALUES("639","501","_gmap_marker","-1");
INSERT INTO wpcf_postmeta VALUES("640","501","_disable_coloring","-1");
INSERT INTO wpcf_postmeta VALUES("641","501","_single_post_type","portfolio");
INSERT INTO wpcf_postmeta VALUES("642","501","_classic_orientation","landscape");
INSERT INTO wpcf_postmeta VALUES("643","501","_single_video_site","youtube");
INSERT INTO wpcf_postmeta VALUES("644","501","_post_newspaper_image_height","500");
INSERT INTO wpcf_postmeta VALUES("645","501","_newspaper_title_position","top");
INSERT INTO wpcf_postmeta VALUES("646","501","_disable_featured_image","true");
INSERT INTO wpcf_postmeta VALUES("647","501","_disable_meta","true");
INSERT INTO wpcf_postmeta VALUES("648","501","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("649","501","_disable_social_share","true");
INSERT INTO wpcf_postmeta VALUES("650","501","_disable_tags","true");
INSERT INTO wpcf_postmeta VALUES("651","501","_disable_related_posts","true");
INSERT INTO wpcf_postmeta VALUES("652","501","_disable_about_author","true");
INSERT INTO wpcf_postmeta VALUES("653","501","_enable_custom_bg","-1");
INSERT INTO wpcf_postmeta VALUES("654","501","_banner_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("655","501","_disable_news_slider","-1");
INSERT INTO wpcf_postmeta VALUES("656","501","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("657","501","_wp_old_slug","suspendisse-egestas-luctus-urna-vitae-dapibus-turpis-ultrices-in");
INSERT INTO wpcf_postmeta VALUES("658","501","_wpb_vc_js_interface_version","2");
INSERT INTO wpcf_postmeta VALUES("659","501","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("660","501","_enable_local_backgrounds","false");
INSERT INTO wpcf_postmeta VALUES("661","501","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("662","501","body_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("663","501","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("664","501","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("665","501","page_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("666","501","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("667","501","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("668","501","header_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("669","501","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("670","501","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("671","501","banner_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("672","501","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("673","501","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("674","501","footer_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("675","501","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("676","501","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("677","501","_slideshow_source","layerslider");
INSERT INTO wpcf_postmeta VALUES("678","501","_edge_full_height","true");
INSERT INTO wpcf_postmeta VALUES("679","501","_icarousel_count","3");
INSERT INTO wpcf_postmeta VALUES("680","501","_icarousel_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("681","501","_icarousel_order","ASC");
INSERT INTO wpcf_postmeta VALUES("682","501","_icarousel_perspective","35");
INSERT INTO wpcf_postmeta VALUES("683","501","_icarousel_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("684","501","_icarousel_animation_speed","500");
INSERT INTO wpcf_postmeta VALUES("685","501","_icarousel_pause_time","5000");
INSERT INTO wpcf_postmeta VALUES("686","501","_flexslider_height","400");
INSERT INTO wpcf_postmeta VALUES("687","501","_flexslider_pagination","circle");
INSERT INTO wpcf_postmeta VALUES("688","501","_flexslider_count","10");
INSERT INTO wpcf_postmeta VALUES("689","501","_flexslider_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("690","501","_flexslider_order","ASC");
INSERT INTO wpcf_postmeta VALUES("691","501","_flexslider_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("692","501","_flexslider_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("693","501","_flexslider_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("694","501","_banner_minHeight","200");
INSERT INTO wpcf_postmeta VALUES("695","501","_banner_padding","30");
INSERT INTO wpcf_postmeta VALUES("696","501","_banner_animation","fade");
INSERT INTO wpcf_postmeta VALUES("697","501","_banner_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("698","501","_banner_order","ASC");
INSERT INTO wpcf_postmeta VALUES("699","501","_banner_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("700","501","_banner_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("701","501","_enable_banner_video","-1");
INSERT INTO wpcf_postmeta VALUES("702","501","_banner_video_pattern","-1");
INSERT INTO wpcf_postmeta VALUES("703","501","_enable_footer_twitter","-1");
INSERT INTO wpcf_postmeta VALUES("704","501","_disable_post_lightbox","true");
INSERT INTO wpcf_postmeta VALUES("705","501","_portfolio_featured_image","-1");
INSERT INTO wpcf_postmeta VALUES("706","501","_portfolio_similar","-1");
INSERT INTO wpcf_postmeta VALUES("707","501","_mk_post_love","218");
INSERT INTO wpcf_postmeta VALUES("708","501","_padding","false");
INSERT INTO wpcf_postmeta VALUES("709","501","_disable_comments","true");
INSERT INTO wpcf_postmeta VALUES("710","501","_edge_height","700");
INSERT INTO wpcf_postmeta VALUES("711","501","_edge_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("712","501","_edge_order","ASC");
INSERT INTO wpcf_postmeta VALUES("713","501","_edge_animation_speed","600");
INSERT INTO wpcf_postmeta VALUES("714","501","_edge_pause_time","15000");
INSERT INTO wpcf_postmeta VALUES("715","501","_edge_direction_nav","true");
INSERT INTO wpcf_postmeta VALUES("716","501","page_preloader","false");
INSERT INTO wpcf_postmeta VALUES("717","501","theme_header_style","1");
INSERT INTO wpcf_postmeta VALUES("718","501","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("719","501","theme_toolbar_toggle","true");
INSERT INTO wpcf_postmeta VALUES("720","501","_transparent_header","false");
INSERT INTO wpcf_postmeta VALUES("721","501","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("722","501","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("723","501","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("724","501","vc_teaser","a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("725","501","_single_video_id","akVHQfb85eQ");
INSERT INTO wpcf_postmeta VALUES("726","501","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("727","501","_single_blog_style","default");
INSERT INTO wpcf_postmeta VALUES("728","501","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("729","501","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("730","501","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("731","501","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("732","501","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("733","501","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("734","501","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("735","501","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("736","501","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("737","501","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("738","501","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("739","501","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("740","501","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("741","501","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("742","501","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1921","7888","_mkhb_options_sticky_header","false");
INSERT INTO wpcf_postmeta VALUES("745","501","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1920","7888","_mkhb_options_overlapping_content","false");
INSERT INTO wpcf_postmeta VALUES("1919","7888","_mkhb_options_mobile","false");
INSERT INTO wpcf_postmeta VALUES("1918","7888","_mkhb_options_laptop","true");
INSERT INTO wpcf_postmeta VALUES("1917","7888","_mkhb_active_header","normal");
INSERT INTO wpcf_postmeta VALUES("1916","7888","_mkhb_active_device","desktop");
INSERT INTO wpcf_postmeta VALUES("758","501","body_size","false");
INSERT INTO wpcf_postmeta VALUES("759","501","page_size","false");
INSERT INTO wpcf_postmeta VALUES("760","501","header_size","false");
INSERT INTO wpcf_postmeta VALUES("761","501","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("762","501","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("769","501","_wp_old_slug","egestas-luctus-urna-vitae-dapibus");
INSERT INTO wpcf_postmeta VALUES("772","501","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("773","501","_gallery_images","7819,7821");
INSERT INTO wpcf_postmeta VALUES("774","501","_thumbnail_id","7824");
INSERT INTO wpcf_postmeta VALUES("781","501","_sidebar","sidebar-2");
INSERT INTO wpcf_postmeta VALUES("782","501","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("785","504","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("786","504","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("787","504","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("788","504","enable_noti_bar","-1");
INSERT INTO wpcf_postmeta VALUES("789","504","_layout","right");
INSERT INTO wpcf_postmeta VALUES("790","504","_page_disable_title","-1");
INSERT INTO wpcf_postmeta VALUES("791","504","_enable_slidehsow","-1");
INSERT INTO wpcf_postmeta VALUES("792","504","_icarousel_autoplay","-1");
INSERT INTO wpcf_postmeta VALUES("793","504","_icarousel_3d","-1");
INSERT INTO wpcf_postmeta VALUES("794","504","_icarousel_pause_on_hover","-1");
INSERT INTO wpcf_postmeta VALUES("795","504","_icarousel_direction_nav","-1");
INSERT INTO wpcf_postmeta VALUES("796","504","_flexslider_disableCaption","-1");
INSERT INTO wpcf_postmeta VALUES("797","504","_flexslider_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("798","504","_flexslider_pauseOnHover","-1");
INSERT INTO wpcf_postmeta VALUES("799","504","_enable_page_gmap","-1");
INSERT INTO wpcf_postmeta VALUES("800","504","_enable_panControl","-1");
INSERT INTO wpcf_postmeta VALUES("801","504","_enable_draggable","-1");
INSERT INTO wpcf_postmeta VALUES("802","504","_enable_scrollwheel","-1");
INSERT INTO wpcf_postmeta VALUES("803","504","_enable_zoomControl","-1");
INSERT INTO wpcf_postmeta VALUES("804","504","_enable_mapTypeControl","-1");
INSERT INTO wpcf_postmeta VALUES("805","504","_enable_scaleControl","-1");
INSERT INTO wpcf_postmeta VALUES("806","504","_gmap_marker","-1");
INSERT INTO wpcf_postmeta VALUES("807","504","_disable_coloring","-1");
INSERT INTO wpcf_postmeta VALUES("808","504","_single_post_type","image");
INSERT INTO wpcf_postmeta VALUES("809","504","_classic_orientation","landscape");
INSERT INTO wpcf_postmeta VALUES("810","504","_single_video_site","vimeo");
INSERT INTO wpcf_postmeta VALUES("811","504","_post_newspaper_image_height","500");
INSERT INTO wpcf_postmeta VALUES("812","504","_newspaper_title_position","top");
INSERT INTO wpcf_postmeta VALUES("813","504","_disable_featured_image","true");
INSERT INTO wpcf_postmeta VALUES("814","504","_disable_meta","true");
INSERT INTO wpcf_postmeta VALUES("815","504","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("816","504","_disable_social_share","true");
INSERT INTO wpcf_postmeta VALUES("817","504","_disable_tags","true");
INSERT INTO wpcf_postmeta VALUES("818","504","_disable_related_posts","true");
INSERT INTO wpcf_postmeta VALUES("819","504","_disable_about_author","true");
INSERT INTO wpcf_postmeta VALUES("820","504","_wp_old_slug","massa-sit-amet-arcu-auctor-imperdiet");
INSERT INTO wpcf_postmeta VALUES("821","504","_enable_custom_bg","-1");
INSERT INTO wpcf_postmeta VALUES("822","504","_banner_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("823","504","_disable_news_slider","-1");
INSERT INTO wpcf_postmeta VALUES("824","504","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("825","504","_wp_old_slug","nullam-laoreet-massa-sit-amet-arcu-auctor-imperdiet");
INSERT INTO wpcf_postmeta VALUES("826","504","body_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("827","504","_enable_local_backgrounds","false");
INSERT INTO wpcf_postmeta VALUES("828","504","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("829","504","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("830","504","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("831","504","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("832","504","page_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("833","504","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("834","504","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("835","504","header_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("836","504","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("837","504","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("838","504","banner_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("839","504","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("840","504","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("841","504","footer_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("842","504","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("843","504","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("844","504","_slideshow_source","layerslider");
INSERT INTO wpcf_postmeta VALUES("845","504","_icarousel_count","3");
INSERT INTO wpcf_postmeta VALUES("846","504","_icarousel_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("847","504","_icarousel_order","ASC");
INSERT INTO wpcf_postmeta VALUES("848","504","_icarousel_perspective","35");
INSERT INTO wpcf_postmeta VALUES("849","504","_icarousel_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("850","504","_icarousel_animation_speed","500");
INSERT INTO wpcf_postmeta VALUES("851","504","_icarousel_pause_time","5000");
INSERT INTO wpcf_postmeta VALUES("852","504","_flexslider_height","400");
INSERT INTO wpcf_postmeta VALUES("853","504","_flexslider_pagination","circle");
INSERT INTO wpcf_postmeta VALUES("854","504","_flexslider_count","10");
INSERT INTO wpcf_postmeta VALUES("855","504","_flexslider_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("856","504","_flexslider_order","ASC");
INSERT INTO wpcf_postmeta VALUES("857","504","_flexslider_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("858","504","_flexslider_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("859","504","_flexslider_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("860","504","_banner_minHeight","200");
INSERT INTO wpcf_postmeta VALUES("861","504","_banner_padding","30");
INSERT INTO wpcf_postmeta VALUES("862","504","_banner_animation","fade");
INSERT INTO wpcf_postmeta VALUES("863","504","_banner_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("864","504","_banner_order","ASC");
INSERT INTO wpcf_postmeta VALUES("865","504","_banner_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("866","504","_banner_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("867","504","_enable_banner_video","-1");
INSERT INTO wpcf_postmeta VALUES("868","504","_banner_video_pattern","-1");
INSERT INTO wpcf_postmeta VALUES("869","504","_enable_footer_twitter","-1");
INSERT INTO wpcf_postmeta VALUES("870","504","_disable_post_lightbox","true");
INSERT INTO wpcf_postmeta VALUES("871","504","_portfolio_featured_image","-1");
INSERT INTO wpcf_postmeta VALUES("872","504","_portfolio_similar","-1");
INSERT INTO wpcf_postmeta VALUES("873","504","_mk_post_love","116");
INSERT INTO wpcf_postmeta VALUES("874","504","_padding","false");
INSERT INTO wpcf_postmeta VALUES("875","504","page_preloader","false");
INSERT INTO wpcf_postmeta VALUES("876","504","_disable_comments","true");
INSERT INTO wpcf_postmeta VALUES("877","504","_edge_full_height","true");
INSERT INTO wpcf_postmeta VALUES("878","504","_edge_height","700");
INSERT INTO wpcf_postmeta VALUES("879","504","_edge_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("880","504","_edge_order","ASC");
INSERT INTO wpcf_postmeta VALUES("881","504","_edge_animation_speed","600");
INSERT INTO wpcf_postmeta VALUES("882","504","_edge_pause_time","15000");
INSERT INTO wpcf_postmeta VALUES("883","504","_edge_direction_nav","true");
INSERT INTO wpcf_postmeta VALUES("884","504","theme_header_style","1");
INSERT INTO wpcf_postmeta VALUES("885","504","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("886","504","theme_toolbar_toggle","true");
INSERT INTO wpcf_postmeta VALUES("887","504","_transparent_header","false");
INSERT INTO wpcf_postmeta VALUES("888","504","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("889","504","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("890","504","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("891","504","vc_teaser","a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("892","504","_single_video_id","159521311");
INSERT INTO wpcf_postmeta VALUES("893","504","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("894","504","_single_blog_style","default");
INSERT INTO wpcf_postmeta VALUES("895","504","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("896","504","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("897","504","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("898","504","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("899","504","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("900","504","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("901","504","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("902","504","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("903","504","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("904","504","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("905","504","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("906","504","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("907","504","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("908","504","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("909","504","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("912","504","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("925","504","body_size","false");
INSERT INTO wpcf_postmeta VALUES("926","504","page_size","false");
INSERT INTO wpcf_postmeta VALUES("927","504","header_size","false");
INSERT INTO wpcf_postmeta VALUES("928","504","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("929","504","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("936","504","_wp_old_slug","massa-sit-amet-arcu");
INSERT INTO wpcf_postmeta VALUES("939","504","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("940","504","_thumbnail_id","7823");
INSERT INTO wpcf_postmeta VALUES("1915","7888","_mkhb_specificities","a:5:{s:25:\"cj6m47a35000g3e5oa1e9igga\";a:1:{s:6:\"margin\";a:1:{s:5:\"right\";a:1:{i:0;s:7:\"desktop\";}}}s:25:\"cj6m5rxl3000m3e5omyxggz06\";a:1:{s:6:\"margin\";a:1:{s:5:\"right\";a:1:{i:0;s:7:\"desktop\";}}}s:25:\"cj6m476if000c3e5ofkm3zszw\";a:2:{s:10:\"cssDisplay\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}s:9:\"alignment\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}}s:25:\"cj6m5rxl3000l3e5odjnl05l9\";a:1:{s:6:\"margin\";a:2:{s:3:\"top\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}s:5:\"right\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}}s:25:\"cj6m47a35000f3e5oonub0flw\";a:4:{s:8:\"boxColor\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}s:8:\"barColor\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}s:6:\"margin\";a:2:{s:3:\"top\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}s:5:\"right\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}s:8:\"navStyle\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}}}");
INSERT INTO wpcf_postmeta VALUES("945","504","_sidebar","sidebar-2");
INSERT INTO wpcf_postmeta VALUES("946","504","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("949","507","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("950","507","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("951","507","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("952","507","enable_noti_bar","-1");
INSERT INTO wpcf_postmeta VALUES("953","507","_layout","right");
INSERT INTO wpcf_postmeta VALUES("954","507","_page_disable_title","-1");
INSERT INTO wpcf_postmeta VALUES("955","507","_enable_slidehsow","-1");
INSERT INTO wpcf_postmeta VALUES("956","507","_icarousel_autoplay","-1");
INSERT INTO wpcf_postmeta VALUES("957","507","_icarousel_3d","-1");
INSERT INTO wpcf_postmeta VALUES("958","507","_icarousel_pause_on_hover","-1");
INSERT INTO wpcf_postmeta VALUES("959","507","_icarousel_direction_nav","-1");
INSERT INTO wpcf_postmeta VALUES("960","507","_flexslider_disableCaption","-1");
INSERT INTO wpcf_postmeta VALUES("961","507","_flexslider_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("962","507","_flexslider_pauseOnHover","-1");
INSERT INTO wpcf_postmeta VALUES("963","507","_enable_page_gmap","-1");
INSERT INTO wpcf_postmeta VALUES("964","507","_enable_panControl","-1");
INSERT INTO wpcf_postmeta VALUES("965","507","_enable_draggable","-1");
INSERT INTO wpcf_postmeta VALUES("966","507","_enable_scrollwheel","-1");
INSERT INTO wpcf_postmeta VALUES("967","507","_enable_zoomControl","-1");
INSERT INTO wpcf_postmeta VALUES("968","507","_enable_mapTypeControl","-1");
INSERT INTO wpcf_postmeta VALUES("969","507","_enable_scaleControl","-1");
INSERT INTO wpcf_postmeta VALUES("970","507","_gmap_marker","-1");
INSERT INTO wpcf_postmeta VALUES("971","507","_disable_coloring","-1");
INSERT INTO wpcf_postmeta VALUES("972","507","_single_post_type","image");
INSERT INTO wpcf_postmeta VALUES("973","507","_classic_orientation","landscape");
INSERT INTO wpcf_postmeta VALUES("974","507","_single_video_site","vimeo");
INSERT INTO wpcf_postmeta VALUES("975","507","_post_newspaper_image_height","500");
INSERT INTO wpcf_postmeta VALUES("976","507","_newspaper_title_position","top");
INSERT INTO wpcf_postmeta VALUES("977","507","_disable_featured_image","true");
INSERT INTO wpcf_postmeta VALUES("978","507","_disable_meta","true");
INSERT INTO wpcf_postmeta VALUES("979","507","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("980","507","_disable_social_share","true");
INSERT INTO wpcf_postmeta VALUES("981","507","_disable_tags","true");
INSERT INTO wpcf_postmeta VALUES("982","507","_disable_related_posts","true");
INSERT INTO wpcf_postmeta VALUES("983","507","_disable_about_author","true");
INSERT INTO wpcf_postmeta VALUES("984","507","_wp_old_slug","proin-urna-enim-semper-at-egestas-2");
INSERT INTO wpcf_postmeta VALUES("985","507","_enable_custom_bg","-1");
INSERT INTO wpcf_postmeta VALUES("986","507","_banner_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("987","507","_disable_news_slider","-1");
INSERT INTO wpcf_postmeta VALUES("988","507","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("989","507","_wp_old_slug","proin-urna-enim-semper-at-egestas-sed-elementum-in-justo-3");
INSERT INTO wpcf_postmeta VALUES("990","507","_wp_old_slug","proin-urna-enim-semper-at-egestas-sed-elementum");
INSERT INTO wpcf_postmeta VALUES("991","507","_wpb_vc_js_interface_version","2");
INSERT INTO wpcf_postmeta VALUES("992","507","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("993","507","_enable_local_backgrounds","false");
INSERT INTO wpcf_postmeta VALUES("994","507","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("995","507","body_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("996","507","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("997","507","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("998","507","page_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("999","507","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1000","507","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1001","507","header_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1002","507","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1003","507","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1004","507","banner_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1005","507","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1006","507","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1007","507","footer_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1008","507","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1009","507","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1010","507","_slideshow_source","layerslider");
INSERT INTO wpcf_postmeta VALUES("1011","507","_icarousel_count","3");
INSERT INTO wpcf_postmeta VALUES("1012","507","_icarousel_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1013","507","_icarousel_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1014","507","_icarousel_perspective","35");
INSERT INTO wpcf_postmeta VALUES("1015","507","_icarousel_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("1016","507","_icarousel_animation_speed","500");
INSERT INTO wpcf_postmeta VALUES("1017","507","_icarousel_pause_time","5000");
INSERT INTO wpcf_postmeta VALUES("1018","507","_flexslider_height","400");
INSERT INTO wpcf_postmeta VALUES("1019","507","_flexslider_pagination","circle");
INSERT INTO wpcf_postmeta VALUES("1020","507","_flexslider_count","10");
INSERT INTO wpcf_postmeta VALUES("1021","507","_flexslider_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1022","507","_flexslider_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1023","507","_flexslider_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("1024","507","_flexslider_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("1025","507","_flexslider_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("1026","507","_banner_minHeight","200");
INSERT INTO wpcf_postmeta VALUES("1027","507","_banner_padding","30");
INSERT INTO wpcf_postmeta VALUES("1028","507","_banner_animation","fade");
INSERT INTO wpcf_postmeta VALUES("1029","507","_banner_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1030","507","_banner_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1031","507","_banner_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("1032","507","_banner_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("1033","507","_enable_banner_video","-1");
INSERT INTO wpcf_postmeta VALUES("1034","507","_banner_video_pattern","-1");
INSERT INTO wpcf_postmeta VALUES("1035","507","_enable_footer_twitter","-1");
INSERT INTO wpcf_postmeta VALUES("1036","507","_disable_post_lightbox","true");
INSERT INTO wpcf_postmeta VALUES("1037","507","_portfolio_featured_image","-1");
INSERT INTO wpcf_postmeta VALUES("1038","507","_portfolio_similar","-1");
INSERT INTO wpcf_postmeta VALUES("1039","507","_mk_post_love","154");
INSERT INTO wpcf_postmeta VALUES("1040","507","_padding","false");
INSERT INTO wpcf_postmeta VALUES("1041","507","page_preloader","false");
INSERT INTO wpcf_postmeta VALUES("1042","507","_disable_comments","true");
INSERT INTO wpcf_postmeta VALUES("1043","507","_edge_full_height","true");
INSERT INTO wpcf_postmeta VALUES("1044","507","_edge_height","700");
INSERT INTO wpcf_postmeta VALUES("1045","507","_edge_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1046","507","_edge_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1047","507","_edge_animation_speed","600");
INSERT INTO wpcf_postmeta VALUES("1048","507","_edge_pause_time","15000");
INSERT INTO wpcf_postmeta VALUES("1049","507","_edge_direction_nav","true");
INSERT INTO wpcf_postmeta VALUES("1050","507","theme_header_style","1");
INSERT INTO wpcf_postmeta VALUES("1051","507","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("1052","507","theme_toolbar_toggle","true");
INSERT INTO wpcf_postmeta VALUES("1053","507","_transparent_header","false");
INSERT INTO wpcf_postmeta VALUES("1054","507","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("1055","507","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("1056","507","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("1057","507","vc_teaser","a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("1058","507","_audio_iframe","<iframe width=\"100{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}\" height=\"166\" scrolling=\"no\" frameborder=\"no\" src=\"https://w.soundcloud.com/player/?url=https{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}3A//api.soundcloud.com/tracks/137693578&color=ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false\"></iframe>");
INSERT INTO wpcf_postmeta VALUES("1059","507","_layer_slider_source","1");
INSERT INTO wpcf_postmeta VALUES("1060","507","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1061","507","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("1062","507","_single_blog_style","default");
INSERT INTO wpcf_postmeta VALUES("1063","507","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1064","507","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1065","507","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1066","507","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1067","507","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1068","507","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1069","507","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1070","507","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1071","507","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1072","507","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1073","507","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1074","507","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1075","507","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1076","507","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1077","507","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1100","507","body_size","false");
INSERT INTO wpcf_postmeta VALUES("1101","507","page_size","false");
INSERT INTO wpcf_postmeta VALUES("1102","507","header_size","false");
INSERT INTO wpcf_postmeta VALUES("1103","507","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("1104","507","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("1107","507","_single_video_id","81836814");
INSERT INTO wpcf_postmeta VALUES("1114","507","_thumbnail_id","7821");
INSERT INTO wpcf_postmeta VALUES("1117","507","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("1122","507","_sidebar","sidebar-2");
INSERT INTO wpcf_postmeta VALUES("1123","507","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("1126","508","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1127","508","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1128","508","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1129","508","enable_noti_bar","-1");
INSERT INTO wpcf_postmeta VALUES("1130","508","_layout","right");
INSERT INTO wpcf_postmeta VALUES("1131","508","_page_disable_title","-1");
INSERT INTO wpcf_postmeta VALUES("1132","508","_enable_slidehsow","-1");
INSERT INTO wpcf_postmeta VALUES("1133","508","_icarousel_autoplay","-1");
INSERT INTO wpcf_postmeta VALUES("1134","508","_icarousel_3d","-1");
INSERT INTO wpcf_postmeta VALUES("1135","508","_icarousel_pause_on_hover","-1");
INSERT INTO wpcf_postmeta VALUES("1136","508","_icarousel_direction_nav","-1");
INSERT INTO wpcf_postmeta VALUES("1137","508","_flexslider_disableCaption","-1");
INSERT INTO wpcf_postmeta VALUES("1138","508","_flexslider_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("1139","508","_flexslider_pauseOnHover","-1");
INSERT INTO wpcf_postmeta VALUES("1140","508","_enable_page_gmap","-1");
INSERT INTO wpcf_postmeta VALUES("1141","508","_enable_panControl","-1");
INSERT INTO wpcf_postmeta VALUES("1142","508","_enable_draggable","-1");
INSERT INTO wpcf_postmeta VALUES("1143","508","_enable_scrollwheel","-1");
INSERT INTO wpcf_postmeta VALUES("1144","508","_enable_zoomControl","-1");
INSERT INTO wpcf_postmeta VALUES("1145","508","_enable_mapTypeControl","-1");
INSERT INTO wpcf_postmeta VALUES("1146","508","_enable_scaleControl","-1");
INSERT INTO wpcf_postmeta VALUES("1147","508","_gmap_marker","-1");
INSERT INTO wpcf_postmeta VALUES("1148","508","_disable_coloring","-1");
INSERT INTO wpcf_postmeta VALUES("1149","508","_single_post_type","portfolio");
INSERT INTO wpcf_postmeta VALUES("1150","508","_classic_orientation","landscape");
INSERT INTO wpcf_postmeta VALUES("1151","508","_single_video_site","youtube");
INSERT INTO wpcf_postmeta VALUES("1152","508","_post_newspaper_image_height","500");
INSERT INTO wpcf_postmeta VALUES("1153","508","_newspaper_title_position","top");
INSERT INTO wpcf_postmeta VALUES("1154","508","_disable_featured_image","true");
INSERT INTO wpcf_postmeta VALUES("1155","508","_disable_meta","true");
INSERT INTO wpcf_postmeta VALUES("1156","508","_disable_breadcrumb","-1");
INSERT INTO wpcf_postmeta VALUES("1157","508","_disable_social_share","true");
INSERT INTO wpcf_postmeta VALUES("1158","508","_disable_tags","true");
INSERT INTO wpcf_postmeta VALUES("1159","508","_disable_related_posts","true");
INSERT INTO wpcf_postmeta VALUES("1160","508","_disable_about_author","true");
INSERT INTO wpcf_postmeta VALUES("1161","508","_single_video_id","pY1_HrhwaXU");
INSERT INTO wpcf_postmeta VALUES("1162","508","_wp_old_slug","proin-vel-mauris-diam-tempus-scelerisque-2");
INSERT INTO wpcf_postmeta VALUES("1163","508","_enable_custom_bg","-1");
INSERT INTO wpcf_postmeta VALUES("1164","508","_banner_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("1165","508","_disable_news_slider","-1");
INSERT INTO wpcf_postmeta VALUES("1166","508","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("1167","508","_enable_local_backgrounds","-1");
INSERT INTO wpcf_postmeta VALUES("1168","508","_portfolio_featured_image","-1");
INSERT INTO wpcf_postmeta VALUES("1169","508","_portfolio_similar","-1");
INSERT INTO wpcf_postmeta VALUES("1170","508","_wp_old_slug","proin-vel-mauris-diam-tempus-scelerisque-enim-2");
INSERT INTO wpcf_postmeta VALUES("1171","508","_wpb_vc_js_interface_version","2");
INSERT INTO wpcf_postmeta VALUES("1172","508","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("1173","508","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("1174","508","body_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1175","508","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1176","508","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1177","508","page_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1178","508","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1179","508","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1180","508","header_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1181","508","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1182","508","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1183","508","banner_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1184","508","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1185","508","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1186","508","footer_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1187","508","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1188","508","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1189","508","_slideshow_source","layerslider");
INSERT INTO wpcf_postmeta VALUES("1190","508","_icarousel_count","3");
INSERT INTO wpcf_postmeta VALUES("1191","508","_icarousel_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1192","508","_icarousel_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1193","508","_icarousel_perspective","35");
INSERT INTO wpcf_postmeta VALUES("1194","508","_icarousel_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("1195","508","_icarousel_animation_speed","500");
INSERT INTO wpcf_postmeta VALUES("1196","508","_icarousel_pause_time","5000");
INSERT INTO wpcf_postmeta VALUES("1197","508","_flexslider_height","400");
INSERT INTO wpcf_postmeta VALUES("1198","508","_flexslider_pagination","circle");
INSERT INTO wpcf_postmeta VALUES("1199","508","_flexslider_count","10");
INSERT INTO wpcf_postmeta VALUES("1200","508","_flexslider_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1201","508","_flexslider_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1202","508","_flexslider_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("1203","508","_flexslider_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("1204","508","_flexslider_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("1205","508","_banner_minHeight","200");
INSERT INTO wpcf_postmeta VALUES("1206","508","_banner_padding","30");
INSERT INTO wpcf_postmeta VALUES("1207","508","_banner_animation","fade");
INSERT INTO wpcf_postmeta VALUES("1208","508","_banner_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1209","508","_banner_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1210","508","_banner_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("1211","508","_banner_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("1212","508","_enable_banner_video","-1");
INSERT INTO wpcf_postmeta VALUES("1213","508","_banner_video_pattern","-1");
INSERT INTO wpcf_postmeta VALUES("1214","508","_enable_footer_twitter","-1");
INSERT INTO wpcf_postmeta VALUES("1215","508","_disable_post_lightbox","true");
INSERT INTO wpcf_postmeta VALUES("1216","508","_mk_post_love","223");
INSERT INTO wpcf_postmeta VALUES("1217","508","_padding","false");
INSERT INTO wpcf_postmeta VALUES("1218","508","page_preloader","false");
INSERT INTO wpcf_postmeta VALUES("1219","508","_disable_comments","true");
INSERT INTO wpcf_postmeta VALUES("1220","508","_edge_full_height","true");
INSERT INTO wpcf_postmeta VALUES("1221","508","_edge_height","700");
INSERT INTO wpcf_postmeta VALUES("1222","508","_edge_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1223","508","_edge_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1224","508","_edge_animation_speed","600");
INSERT INTO wpcf_postmeta VALUES("1225","508","_edge_pause_time","15000");
INSERT INTO wpcf_postmeta VALUES("1226","508","_edge_direction_nav","true");
INSERT INTO wpcf_postmeta VALUES("1227","508","theme_header_style","1");
INSERT INTO wpcf_postmeta VALUES("1228","508","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("1229","508","theme_toolbar_toggle","true");
INSERT INTO wpcf_postmeta VALUES("1230","508","_transparent_header","false");
INSERT INTO wpcf_postmeta VALUES("1231","508","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("1232","508","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("1233","508","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("1234","508","vc_teaser","a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("1235","508","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1236","508","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("1237","508","_single_blog_style","default");
INSERT INTO wpcf_postmeta VALUES("1238","508","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1239","508","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1240","508","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1241","508","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1242","508","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1243","508","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1244","508","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1245","508","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1246","508","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1247","508","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1248","508","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1249","508","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1250","508","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1251","508","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1252","508","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1269","508","_sidebar","sidebar-2");
INSERT INTO wpcf_postmeta VALUES("1276","508","body_size","false");
INSERT INTO wpcf_postmeta VALUES("1277","508","page_size","false");
INSERT INTO wpcf_postmeta VALUES("1278","508","header_size","false");
INSERT INTO wpcf_postmeta VALUES("1279","508","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("1280","508","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("1291","508","_wp_old_slug","proin-vel-mauris-diam");
INSERT INTO wpcf_postmeta VALUES("1292","508","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("1297","508","_thumbnail_id","7819");
INSERT INTO wpcf_postmeta VALUES("1304","508","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("1307","4518","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1308","4518","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1309","4518","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1310","4518","enable_noti_bar","-1");
INSERT INTO wpcf_postmeta VALUES("1311","4518","_layout","right");
INSERT INTO wpcf_postmeta VALUES("1312","4518","_page_disable_title","-1");
INSERT INTO wpcf_postmeta VALUES("1313","4518","_enable_slidehsow","-1");
INSERT INTO wpcf_postmeta VALUES("1314","4518","_icarousel_autoplay","-1");
INSERT INTO wpcf_postmeta VALUES("1315","4518","_icarousel_3d","-1");
INSERT INTO wpcf_postmeta VALUES("1316","4518","_icarousel_pause_on_hover","-1");
INSERT INTO wpcf_postmeta VALUES("1317","4518","_icarousel_direction_nav","-1");
INSERT INTO wpcf_postmeta VALUES("1318","4518","_flexslider_disableCaption","-1");
INSERT INTO wpcf_postmeta VALUES("1319","4518","_flexslider_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("1320","4518","_flexslider_pauseOnHover","-1");
INSERT INTO wpcf_postmeta VALUES("1321","4518","_enable_page_gmap","-1");
INSERT INTO wpcf_postmeta VALUES("1322","4518","_enable_panControl","-1");
INSERT INTO wpcf_postmeta VALUES("1323","4518","_enable_draggable","-1");
INSERT INTO wpcf_postmeta VALUES("1324","4518","_enable_scrollwheel","-1");
INSERT INTO wpcf_postmeta VALUES("1325","4518","_enable_zoomControl","-1");
INSERT INTO wpcf_postmeta VALUES("1326","4518","_enable_mapTypeControl","-1");
INSERT INTO wpcf_postmeta VALUES("1327","4518","_enable_scaleControl","-1");
INSERT INTO wpcf_postmeta VALUES("1328","4518","_gmap_marker","-1");
INSERT INTO wpcf_postmeta VALUES("1329","4518","_disable_coloring","-1");
INSERT INTO wpcf_postmeta VALUES("1330","4518","_single_post_type","portfolio");
INSERT INTO wpcf_postmeta VALUES("1331","4518","_classic_orientation","landscape");
INSERT INTO wpcf_postmeta VALUES("1332","4518","_single_video_site","youtube");
INSERT INTO wpcf_postmeta VALUES("1333","4518","_post_newspaper_image_height","500");
INSERT INTO wpcf_postmeta VALUES("1334","4518","_newspaper_title_position","top");
INSERT INTO wpcf_postmeta VALUES("1335","4518","_disable_featured_image","true");
INSERT INTO wpcf_postmeta VALUES("1336","4518","_disable_meta","true");
INSERT INTO wpcf_postmeta VALUES("1337","4518","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("1338","4518","_disable_social_share","true");
INSERT INTO wpcf_postmeta VALUES("1339","4518","_disable_tags","true");
INSERT INTO wpcf_postmeta VALUES("1340","4518","_disable_related_posts","true");
INSERT INTO wpcf_postmeta VALUES("1341","4518","_disable_about_author","true");
INSERT INTO wpcf_postmeta VALUES("1342","4518","_wp_old_slug","nunc-adipiscing-semper-nisl-in-tempor");
INSERT INTO wpcf_postmeta VALUES("1343","4518","_enable_custom_bg","-1");
INSERT INTO wpcf_postmeta VALUES("1344","4518","_banner_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("1345","4518","_disable_news_slider","-1");
INSERT INTO wpcf_postmeta VALUES("1346","4518","_wpb_vc_js_status","true");
INSERT INTO wpcf_postmeta VALUES("1347","4518","_wpb_vc_js_interface_version","2");
INSERT INTO wpcf_postmeta VALUES("1348","4518","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("1349","4518","_enable_local_backgrounds","false");
INSERT INTO wpcf_postmeta VALUES("1350","4518","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("1351","4518","body_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1352","4518","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1353","4518","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1354","4518","page_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1355","4518","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1356","4518","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1357","4518","header_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1358","4518","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1359","4518","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1360","4518","banner_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1361","4518","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1362","4518","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1363","4518","footer_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1364","4518","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1365","4518","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1366","4518","_slideshow_source","layerslider");
INSERT INTO wpcf_postmeta VALUES("1367","4518","_icarousel_count","3");
INSERT INTO wpcf_postmeta VALUES("1368","4518","_icarousel_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1369","4518","_icarousel_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1370","4518","_icarousel_perspective","35");
INSERT INTO wpcf_postmeta VALUES("1371","4518","_icarousel_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("1372","4518","_icarousel_animation_speed","500");
INSERT INTO wpcf_postmeta VALUES("1373","4518","_icarousel_pause_time","5000");
INSERT INTO wpcf_postmeta VALUES("1374","4518","_flexslider_height","400");
INSERT INTO wpcf_postmeta VALUES("1375","4518","_flexslider_pagination","circle");
INSERT INTO wpcf_postmeta VALUES("1376","4518","_flexslider_count","10");
INSERT INTO wpcf_postmeta VALUES("1377","4518","_flexslider_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1378","4518","_flexslider_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1379","4518","_flexslider_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("1380","4518","_flexslider_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("1381","4518","_flexslider_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("1382","4518","_banner_minHeight","200");
INSERT INTO wpcf_postmeta VALUES("1383","4518","_banner_padding","30");
INSERT INTO wpcf_postmeta VALUES("1384","4518","_banner_animation","fade");
INSERT INTO wpcf_postmeta VALUES("1385","4518","_banner_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1386","4518","_banner_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1387","4518","_banner_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("1388","4518","_banner_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("1389","4518","_enable_banner_video","-1");
INSERT INTO wpcf_postmeta VALUES("1390","4518","_banner_video_pattern","-1");
INSERT INTO wpcf_postmeta VALUES("1391","4518","_enable_footer_twitter","-1");
INSERT INTO wpcf_postmeta VALUES("1392","4518","_disable_post_lightbox","true");
INSERT INTO wpcf_postmeta VALUES("1393","4518","_portfolio_featured_image","-1");
INSERT INTO wpcf_postmeta VALUES("1394","4518","_portfolio_similar","-1");
INSERT INTO wpcf_postmeta VALUES("1395","4518","_mk_post_love","49");
INSERT INTO wpcf_postmeta VALUES("1396","4518","_padding","false");
INSERT INTO wpcf_postmeta VALUES("1397","4518","page_preloader","false");
INSERT INTO wpcf_postmeta VALUES("1398","4518","_disable_comments","true");
INSERT INTO wpcf_postmeta VALUES("1399","4518","_edge_full_height","true");
INSERT INTO wpcf_postmeta VALUES("1400","4518","_edge_height","700");
INSERT INTO wpcf_postmeta VALUES("1401","4518","_edge_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1402","4518","_edge_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1403","4518","_edge_animation_speed","600");
INSERT INTO wpcf_postmeta VALUES("1404","4518","_edge_pause_time","15000");
INSERT INTO wpcf_postmeta VALUES("1405","4518","_edge_direction_nav","true");
INSERT INTO wpcf_postmeta VALUES("1406","4518","theme_header_style","1");
INSERT INTO wpcf_postmeta VALUES("1407","4518","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("1408","4518","theme_toolbar_toggle","true");
INSERT INTO wpcf_postmeta VALUES("1409","4518","_transparent_header","false");
INSERT INTO wpcf_postmeta VALUES("1410","4518","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("1411","4518","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("1412","4518","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("1413","4518","vc_teaser","a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("1414","4518","_dp_original","506");
INSERT INTO wpcf_postmeta VALUES("1415","4518","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1416","4518","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("1421","4518","_single_blog_style","default");
INSERT INTO wpcf_postmeta VALUES("1422","4518","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1423","4518","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1424","4518","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1425","4518","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1426","4518","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1427","4518","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1428","4518","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1429","4518","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1430","4518","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1431","4518","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1432","4518","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1433","4518","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1434","4518","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1435","4518","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1436","4518","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1455","4518","body_size","false");
INSERT INTO wpcf_postmeta VALUES("1456","4518","page_size","false");
INSERT INTO wpcf_postmeta VALUES("1457","4518","header_size","false");
INSERT INTO wpcf_postmeta VALUES("1458","4518","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("1459","4518","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("1468","4518","_wp_old_slug","adipiscing-semper-nislo");
INSERT INTO wpcf_postmeta VALUES("1469","4518","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("1476","4518","_thumbnail_id","7820");
INSERT INTO wpcf_postmeta VALUES("1479","4518","_gallery_images","7824,7825");
INSERT INTO wpcf_postmeta VALUES("1482","4518","_sidebar","sidebar-2");
INSERT INTO wpcf_postmeta VALUES("1483","4518","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("1486","7600","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1487","7600","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1488","7600","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1491","7600","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("1492","7600","_wp_old_slug","instagram-post-1");
INSERT INTO wpcf_postmeta VALUES("1497","7600","_wp_old_slug","a1-instagram-post");
INSERT INTO wpcf_postmeta VALUES("1498","7600","_instagram_url","https://www.instagram.com/p/_9eSTWRTn6");
INSERT INTO wpcf_postmeta VALUES("1499","7600","_single_video_site","youtube");
INSERT INTO wpcf_postmeta VALUES("1500","7600","_disable_featured_image","true");
INSERT INTO wpcf_postmeta VALUES("1501","7600","_disable_meta","true");
INSERT INTO wpcf_postmeta VALUES("1502","7600","_disable_tags","true");
INSERT INTO wpcf_postmeta VALUES("1503","7600","_disable_related_posts","true");
INSERT INTO wpcf_postmeta VALUES("1504","7600","_disable_about_author","true");
INSERT INTO wpcf_postmeta VALUES("1505","7600","_disable_comments","true");
INSERT INTO wpcf_postmeta VALUES("1506","7600","_enable_local_backgrounds","false");
INSERT INTO wpcf_postmeta VALUES("1507","7600","theme_header_style","1");
INSERT INTO wpcf_postmeta VALUES("1508","7600","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("1509","7600","theme_toolbar_toggle","true");
INSERT INTO wpcf_postmeta VALUES("1510","7600","_transparent_header","false");
INSERT INTO wpcf_postmeta VALUES("1511","7600","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("1512","7600","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("1513","7600","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("1514","7600","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("1515","7600","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1516","7600","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1517","7600","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1518","7600","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1519","7600","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1520","7600","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1521","7600","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1522","7600","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1523","7600","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1524","7600","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1525","7600","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1526","7600","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1527","7600","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1528","7600","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1529","7600","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1530","7600","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1531","7600","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1532","7600","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1533","7600","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1534","7600","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1535","7600","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1536","7600","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1537","7600","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1538","7600","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1539","7600","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1542","7600","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("1543","7600","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1544","7600","_layout","right");
INSERT INTO wpcf_postmeta VALUES("1545","7600","_padding","false");
INSERT INTO wpcf_postmeta VALUES("1546","7600","page_preloader","false");
INSERT INTO wpcf_postmeta VALUES("1547","7600","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("1548","7600","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("1549","7600","_single_blog_style","default");
INSERT INTO wpcf_postmeta VALUES("1550","7600","_single_post_type","image");
INSERT INTO wpcf_postmeta VALUES("1551","7600","_classic_orientation","landscape");
INSERT INTO wpcf_postmeta VALUES("1562","7600","_wp_old_slug","artbees-office");
INSERT INTO wpcf_postmeta VALUES("1567","7600","_wp_old_slug","diesel");
INSERT INTO wpcf_postmeta VALUES("1570","7600","body_size","false");
INSERT INTO wpcf_postmeta VALUES("1571","7600","page_size","false");
INSERT INTO wpcf_postmeta VALUES("1572","7600","header_size","false");
INSERT INTO wpcf_postmeta VALUES("1573","7600","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("1574","7600","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("1575","7600","_blog_post_tweet_text","What goes behind Artbees vigilant #Support team? Our Ninjas are sharing insights... https://t.co/kY8g3x0eGY https://t.co/P9EVUurFiD");
INSERT INTO wpcf_postmeta VALUES("1576","7600","_blog_post_tweet_screen_name","artbees_design");
INSERT INTO wpcf_postmeta VALUES("1577","7600","_blog_post_tweet_name","Artbees");
INSERT INTO wpcf_postmeta VALUES("1584","7600","_thumbnail_id","7822");
INSERT INTO wpcf_postmeta VALUES("1585","7600","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("1590","7600","_sidebar","sidebar-2");
INSERT INTO wpcf_postmeta VALUES("1593","7600","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("1596","7616","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1597","7616","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1598","7616","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1601","7616","_wp_old_slug","instagram-post-2");
INSERT INTO wpcf_postmeta VALUES("1604","7616","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("1609","7616","_wpb_vc_js_status","false");
INSERT INTO wpcf_postmeta VALUES("1610","7616","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1611","7616","_layout","right");
INSERT INTO wpcf_postmeta VALUES("1612","7616","_padding","false");
INSERT INTO wpcf_postmeta VALUES("1613","7616","page_preloader","false");
INSERT INTO wpcf_postmeta VALUES("1614","7616","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("1615","7616","_disable_breadcrumb","true");
INSERT INTO wpcf_postmeta VALUES("1616","7616","_single_blog_style","default");
INSERT INTO wpcf_postmeta VALUES("1617","7616","_single_post_type","image");
INSERT INTO wpcf_postmeta VALUES("1618","7616","_classic_orientation","landscape");
INSERT INTO wpcf_postmeta VALUES("1619","7616","_instagram_url","https://www.instagram.com/p/-rn0BVxTkV");
INSERT INTO wpcf_postmeta VALUES("1620","7616","_single_video_site","youtube");
INSERT INTO wpcf_postmeta VALUES("1621","7616","_disable_featured_image","true");
INSERT INTO wpcf_postmeta VALUES("1622","7616","_disable_meta","true");
INSERT INTO wpcf_postmeta VALUES("1623","7616","_disable_tags","true");
INSERT INTO wpcf_postmeta VALUES("1624","7616","_disable_related_posts","true");
INSERT INTO wpcf_postmeta VALUES("1625","7616","_disable_about_author","true");
INSERT INTO wpcf_postmeta VALUES("1626","7616","_disable_comments","true");
INSERT INTO wpcf_postmeta VALUES("1627","7616","_enable_local_backgrounds","false");
INSERT INTO wpcf_postmeta VALUES("1628","7616","theme_header_style","1");
INSERT INTO wpcf_postmeta VALUES("1629","7616","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("1630","7616","theme_toolbar_toggle","true");
INSERT INTO wpcf_postmeta VALUES("1631","7616","_transparent_header","false");
INSERT INTO wpcf_postmeta VALUES("1632","7616","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("1633","7616","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("1634","7616","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("1635","7616","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("1636","7616","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1637","7616","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1638","7616","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1639","7616","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1640","7616","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1641","7616","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1642","7616","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1643","7616","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1644","7616","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1645","7616","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1646","7616","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1647","7616","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1648","7616","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1649","7616","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1650","7616","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1651","7616","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1652","7616","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1653","7616","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1654","7616","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1655","7616","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1656","7616","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1657","7616","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1658","7616","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1659","7616","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1660","7616","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1661","7616","_dp_original","7600");
INSERT INTO wpcf_postmeta VALUES("1678","7616","_wp_old_slug","artbees-mascot");
INSERT INTO wpcf_postmeta VALUES("1681","7616","body_size","false");
INSERT INTO wpcf_postmeta VALUES("1682","7616","page_size","false");
INSERT INTO wpcf_postmeta VALUES("1683","7616","header_size","false");
INSERT INTO wpcf_postmeta VALUES("1684","7616","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("1685","7616","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("1692","7616","_wp_old_slug","diesel-denim");
INSERT INTO wpcf_postmeta VALUES("1693","7616","_thumbnail_id","7825");
INSERT INTO wpcf_postmeta VALUES("1694","7616","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("1699","7616","_sidebar","sidebar-2");
INSERT INTO wpcf_postmeta VALUES("1702","7616","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("1927","7887","_mkhb_content_normal_header_desktop","[mkhb_row id=\"ciyk0megh00073j5lbaqqngk4\" device=\"desktop\" workspace=\"normal\" layout=\"6,6\" width=\"fixed\"][mkhb_col id=\"cj67b4wnt000b3h5ok7lpivzj\" device=\"desktop\" workspace=\"normal\" width=\"6\"][mkhb_logo id=\"cj6m476if000e3e5ojut0zwww\" device=\"desktop\" workspace=\"normal\" width=\"200px\" link-homepage=\"true\" display=\"inline\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000e3h5ojv9jqeqs\" device=\"desktop\" workspace=\"normal\" width=\"6\"][mkhb_navigation id=\"cj6m47a35000h3e5oalpl0ixp\" device=\"desktop\" workspace=\"normal\" margin=\"30px 20px 0 0\" hover-style=\"4\" alignment=\"right\" display=\"inline\" font-family=\"Roboto\" font-type=\"google\" font-subsets=\"cyrillic-ext,greek,latin-ext,latin,cyrillic,vietnamese,greek-ext\" font-variants=\"100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,900,900italic\" text-size=\"14px\" text-color=\"rgba(136,136,136,1)\" text-hover-color=\"rgba(34,34,34,1)\"][mkhb_search id=\"cj6m5rxl3000n3e5o5k3yr6xm\" device=\"desktop\" workspace=\"normal\" margin=\"40px 0 0 0\" icon-type=\"4\" icon-color=\"rgba(136,136,136,1)\" icon-hover-color=\"rgba(34,34,34,1)\" alignment=\"right\" display=\"inline\" visibility=\"desktop\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000h3h5ohqc6vvyq\" device=\"desktop\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000k3h5ozq2hl2iz\" device=\"desktop\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000n3h5o9d65yxru\" device=\"desktop\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000q3h5ohtuq4o22\" device=\"desktop\" workspace=\"normal\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1705","7790","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1706","7790","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1707","7790","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1710","7790","_introduce_align","left");
INSERT INTO wpcf_postmeta VALUES("1711","7790","background_selector_orientation","full_width_layout");
INSERT INTO wpcf_postmeta VALUES("1926","7616","_mk_post_love","0");
INSERT INTO wpcf_postmeta VALUES("1714","7790","_disable_breadcrumb","-1");
INSERT INTO wpcf_postmeta VALUES("1715","7790","_disable_social_share","true");
INSERT INTO wpcf_postmeta VALUES("1716","7790","_disable_tags","true");
INSERT INTO wpcf_postmeta VALUES("1717","7790","_disable_related_posts","true");
INSERT INTO wpcf_postmeta VALUES("1718","7790","_disable_about_author","true");
INSERT INTO wpcf_postmeta VALUES("1719","7790","_enable_custom_bg","-1");
INSERT INTO wpcf_postmeta VALUES("1720","7790","_banner_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("1721","7790","_disable_news_slider","-1");
INSERT INTO wpcf_postmeta VALUES("1722","7790","_wpb_vc_js_status","true");
INSERT INTO wpcf_postmeta VALUES("1723","7790","_wp_old_slug","curabitur-ac-neque-at-arcu-consectetur-auctor-eget-id-elit");
INSERT INTO wpcf_postmeta VALUES("1724","7790","_enable_local_backgrounds","-1");
INSERT INTO wpcf_postmeta VALUES("1725","7790","enable_noti_bar","-1");
INSERT INTO wpcf_postmeta VALUES("1726","7790","_mp3_file","http://demos.artbees.net/jupiter5-demo/wp-content/uploads/2013/05/adg3com_cloudlessdays.mp3");
INSERT INTO wpcf_postmeta VALUES("1727","7790","_ogg_file","http://demos.artbees.net/jupiter5-demo/wp-content/uploads/2013/05/misc-5.jpg");
INSERT INTO wpcf_postmeta VALUES("1728","7790","_single_audio_author","Cloudless days");
INSERT INTO wpcf_postmeta VALUES("1729","7790","_portfolio_featured_image","-1");
INSERT INTO wpcf_postmeta VALUES("1730","7790","_portfolio_similar","-1");
INSERT INTO wpcf_postmeta VALUES("1731","7790","_wpb_vc_js_interface_version","2");
INSERT INTO wpcf_postmeta VALUES("1736","7790","body_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1737","7790","body_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1738","7790","body_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1739","7790","page_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1740","7790","page_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1741","7790","page_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1742","7790","header_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1743","7790","header_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1744","7790","header_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1745","7790","banner_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1746","7790","banner_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1747","7790","banner_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1748","7790","footer_color_rgba","1");
INSERT INTO wpcf_postmeta VALUES("1749","7790","footer_source","no-image");
INSERT INTO wpcf_postmeta VALUES("1750","7790","footer_parallax","false");
INSERT INTO wpcf_postmeta VALUES("1751","7790","_slideshow_source","layerslider");
INSERT INTO wpcf_postmeta VALUES("1752","7790","_icarousel_count","3");
INSERT INTO wpcf_postmeta VALUES("1753","7790","_icarousel_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1754","7790","_icarousel_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1755","7790","_icarousel_perspective","35");
INSERT INTO wpcf_postmeta VALUES("1756","7790","_icarousel_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("1757","7790","_icarousel_animation_speed","500");
INSERT INTO wpcf_postmeta VALUES("1758","7790","_icarousel_pause_time","5000");
INSERT INTO wpcf_postmeta VALUES("1759","7790","_flexslider_height","400");
INSERT INTO wpcf_postmeta VALUES("1760","7790","_flexslider_pagination","circle");
INSERT INTO wpcf_postmeta VALUES("1761","7790","_flexslider_count","10");
INSERT INTO wpcf_postmeta VALUES("1762","7790","_flexslider_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1763","7790","_flexslider_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1764","7790","_flexslider_easing","easeOutCubic");
INSERT INTO wpcf_postmeta VALUES("1765","7790","_flexslider_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("1766","7790","_flexslider_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("1767","7790","_banner_minHeight","200");
INSERT INTO wpcf_postmeta VALUES("1768","7790","_banner_padding","30");
INSERT INTO wpcf_postmeta VALUES("1769","7790","_banner_animation","fade");
INSERT INTO wpcf_postmeta VALUES("1770","7790","_banner_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1771","7790","_banner_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1772","7790","_banner_slideshowSpeed","5000");
INSERT INTO wpcf_postmeta VALUES("1773","7790","_banner_animationDuration","600");
INSERT INTO wpcf_postmeta VALUES("1774","7790","_enable_banner_video","-1");
INSERT INTO wpcf_postmeta VALUES("1775","7790","_banner_video_pattern","-1");
INSERT INTO wpcf_postmeta VALUES("1776","7790","_enable_footer_twitter","-1");
INSERT INTO wpcf_postmeta VALUES("1777","7790","_disable_post_lightbox","true");
INSERT INTO wpcf_postmeta VALUES("1778","7790","_mk_post_love","665");
INSERT INTO wpcf_postmeta VALUES("1779","7790","_padding","false");
INSERT INTO wpcf_postmeta VALUES("1780","7790","page_preloader","false");
INSERT INTO wpcf_postmeta VALUES("1781","7790","_disable_comments","true");
INSERT INTO wpcf_postmeta VALUES("1782","7790","_edge_full_height","true");
INSERT INTO wpcf_postmeta VALUES("1783","7790","_edge_height","700");
INSERT INTO wpcf_postmeta VALUES("1784","7790","_edge_orderby","menu_order");
INSERT INTO wpcf_postmeta VALUES("1785","7790","_edge_order","ASC");
INSERT INTO wpcf_postmeta VALUES("1786","7790","_edge_animation_speed","600");
INSERT INTO wpcf_postmeta VALUES("1787","7790","_edge_pause_time","15000");
INSERT INTO wpcf_postmeta VALUES("1788","7790","_edge_direction_nav","true");
INSERT INTO wpcf_postmeta VALUES("1789","7790","theme_header_style","1");
INSERT INTO wpcf_postmeta VALUES("1790","7790","theme_header_align","left");
INSERT INTO wpcf_postmeta VALUES("1791","7790","theme_toolbar_toggle","true");
INSERT INTO wpcf_postmeta VALUES("1792","7790","_transparent_header","false");
INSERT INTO wpcf_postmeta VALUES("1793","7790","_transparent_header_skin","light");
INSERT INTO wpcf_postmeta VALUES("1794","7790","_trans_header_remove_bg","true");
INSERT INTO wpcf_postmeta VALUES("1795","7790","_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("1796","7790","vc_teaser","a:2:{s:4:\"data\";s:115:\"[{\"name\":\"title\",\"link\":\"post\"},{\"name\":\"image\",\"image\":\"featured\",\"link\":\"none\"},{\"name\":\"text\",\"mode\":\"excerpt\"}]\";s:7:\"bgcolor\";s:0:\"\";}");
INSERT INTO wpcf_postmeta VALUES("1797","7790","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1798","7790","_theme_options_build","57f4b8c7a6251");
INSERT INTO wpcf_postmeta VALUES("1925","7600","_mk_post_love","0");
INSERT INTO wpcf_postmeta VALUES("1801","7790","_single_blog_style","default");
INSERT INTO wpcf_postmeta VALUES("1802","7790","body_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1803","7790","body_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1804","7790","body_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1805","7790","page_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1806","7790","page_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1807","7790","page_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1808","7790","header_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1809","7790","header_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1810","7790","header_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1811","7790","banner_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1812","7790","banner_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1813","7790","banner_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1814","7790","footer_color_gradient","single");
INSERT INTO wpcf_postmeta VALUES("1815","7790","footer_color_gradient_style","linear");
INSERT INTO wpcf_postmeta VALUES("1816","7790","footer_color_gradient_angle","vertical");
INSERT INTO wpcf_postmeta VALUES("1817","7790","_dp_original","509");
INSERT INTO wpcf_postmeta VALUES("1822","7790","_layout","right");
INSERT INTO wpcf_postmeta VALUES("1823","7790","_page_disable_title","-1");
INSERT INTO wpcf_postmeta VALUES("1824","7790","_enable_slidehsow","-1");
INSERT INTO wpcf_postmeta VALUES("1825","7790","_icarousel_autoplay","-1");
INSERT INTO wpcf_postmeta VALUES("1826","7790","_icarousel_3d","-1");
INSERT INTO wpcf_postmeta VALUES("1827","7790","_icarousel_pause_on_hover","-1");
INSERT INTO wpcf_postmeta VALUES("1828","7790","_icarousel_direction_nav","-1");
INSERT INTO wpcf_postmeta VALUES("1829","7790","_flexslider_disableCaption","-1");
INSERT INTO wpcf_postmeta VALUES("1830","7790","_flexslider_slideshow","-1");
INSERT INTO wpcf_postmeta VALUES("1831","7790","_flexslider_pauseOnHover","-1");
INSERT INTO wpcf_postmeta VALUES("1832","7790","_enable_page_gmap","-1");
INSERT INTO wpcf_postmeta VALUES("1833","7790","_enable_panControl","-1");
INSERT INTO wpcf_postmeta VALUES("1834","7790","_enable_draggable","-1");
INSERT INTO wpcf_postmeta VALUES("1835","7790","_enable_scrollwheel","-1");
INSERT INTO wpcf_postmeta VALUES("1836","7790","_enable_zoomControl","-1");
INSERT INTO wpcf_postmeta VALUES("1837","7790","_enable_mapTypeControl","-1");
INSERT INTO wpcf_postmeta VALUES("1838","7790","_enable_scaleControl","-1");
INSERT INTO wpcf_postmeta VALUES("1839","7790","_gmap_marker","-1");
INSERT INTO wpcf_postmeta VALUES("1840","7790","_disable_coloring","-1");
INSERT INTO wpcf_postmeta VALUES("1841","7790","_single_post_type","image");
INSERT INTO wpcf_postmeta VALUES("1842","7790","_classic_orientation","landscape");
INSERT INTO wpcf_postmeta VALUES("1843","7790","_single_video_site","youtube");
INSERT INTO wpcf_postmeta VALUES("1844","7790","_post_newspaper_image_height","500");
INSERT INTO wpcf_postmeta VALUES("1845","7790","_newspaper_title_position","top");
INSERT INTO wpcf_postmeta VALUES("1846","7790","_disable_featured_image","true");
INSERT INTO wpcf_postmeta VALUES("1847","7790","_disable_meta","true");
INSERT INTO wpcf_postmeta VALUES("1852","7790","_wp_old_slug","medium-post");
INSERT INTO wpcf_postmeta VALUES("1853","7790","_wp_old_slug","the-new-clear-and-bold-blog-post");
INSERT INTO wpcf_postmeta VALUES("1924","7888","_vc_post_settings","a:1:{s:10:\"vc_grid_id\";a:0:{}}");
INSERT INTO wpcf_postmeta VALUES("1864","7790","_sidebar","sidebar-2");
INSERT INTO wpcf_postmeta VALUES("1871","7790","_wp_old_slug","the-new-clear-and-bold-blog");
INSERT INTO wpcf_postmeta VALUES("1874","7790","body_size","false");
INSERT INTO wpcf_postmeta VALUES("1875","7790","page_size","false");
INSERT INTO wpcf_postmeta VALUES("1876","7790","header_size","false");
INSERT INTO wpcf_postmeta VALUES("1877","7790","banner_size","false");
INSERT INTO wpcf_postmeta VALUES("1878","7790","footer_size","false");
INSERT INTO wpcf_postmeta VALUES("1923","7888","_mkhb_options_sticky_header_behaviour","slide-down");
INSERT INTO wpcf_postmeta VALUES("1887","7790","_wp_old_slug","vestibulum-commodo-posuere");
INSERT INTO wpcf_postmeta VALUES("1892","7790","_template","no-title");
INSERT INTO wpcf_postmeta VALUES("1895","7790","_thumbnail_id","7818");
INSERT INTO wpcf_postmeta VALUES("1922","7888","_mkhb_options_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("1902","7790","_wxr_import_user_slug","alex");
INSERT INTO wpcf_postmeta VALUES("1929","7887","_mkhb_content_normal_header_mobile","[mkhb_row id=\"ciyk0megi000i3j5l2ik0dom2\" device=\"mobile\" workspace=\"normal\" layout=\"6,6\" width=\"fixed\"][mkhb_col id=\"cj67b4wnt00093h5o8pm8pntw\" device=\"mobile\" workspace=\"normal\" width=\"6\"][mkhb_logo id=\"cj6m476if000c3e5ofkm3zszw\" device=\"mobile\" workspace=\"normal\" width=\"200px\" link-homepage=\"true\" display=\"inline\"][mkhb_search id=\"cj6m5rxl3000l3e5odjnl05l9\" device=\"mobile\" workspace=\"normal\" margin=\"35px 0 0 0\" icon-type=\"4\" icon-color=\"rgba(136,136,136,1)\" icon-hover-color=\"rgba(34,34,34,1)\" alignment=\"right\" display=\"inline\" visibility=\"desktop\"][mkhb_navigation id=\"cj6m47a35000f3e5oonub0flw\" device=\"mobile\" workspace=\"normal\" nav-style=\"burger\" margin=\"25px 0 0 0\" hover-style=\"4\" alignment=\"right\" display=\"inline\" bar-color=\"rgba(136,136,136,1)\" box-color=\"rgba(255,255,255,1)\" font-family=\"Roboto\" font-type=\"google\" font-subsets=\"cyrillic-ext,greek,latin-ext,latin,cyrillic,vietnamese,greek-ext\" font-variants=\"100,100italic,300,300italic,regular,italic,500,500italic,700,700italic,900,900italic\" text-size=\"14px\" text-color=\"rgba(136,136,136,1)\" text-hover-color=\"rgba(34,34,34,1)\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000c3h5o99tzkhmv\" device=\"mobile\" workspace=\"normal\" width=\"6\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000f3h5oia0rygma\" device=\"mobile\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000i3h5oode0cc48\" device=\"mobile\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000l3h5oda98thw4\" device=\"mobile\" workspace=\"normal\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj67b4wnt000o3h5omu55sugr\" device=\"mobile\" workspace=\"normal\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1930","7887","_mkhb_content_sticky_header_desktop","[mkhb_row id=\"cj6f1n2qd00063h5o2w2ejryb\" device=\"desktop\" workspace=\"sticky\" layout=\"12\"][mkhb_col id=\"cj6f1iph300063h5ocbedhqh2\" device=\"desktop\" workspace=\"sticky\" width=\"12\"][/mkhb_col][mkhb_col id=\"cj6f1iph300093h5o0lib30g9\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000c3h5oq63yqucn\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000f3h5oxzp3thh2\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000i3h5o00qf6zys\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000l3h5o76j1o6sz\" device=\"desktop\" workspace=\"sticky\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1931","7887","_mkhb_content_sticky_header_tablet","[mkhb_row id=\"cj6f1n2qd00053h5o786pg9t0\" device=\"tablet\" workspace=\"sticky\" layout=\"12\"][mkhb_col id=\"cj6f1iph300053h5oqdoerx9p\" device=\"tablet\" workspace=\"sticky\" width=\"12\"][/mkhb_col][mkhb_col id=\"cj6f1iph300083h5ooeh6eef3\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000b3h5o6u6g5ey4\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000e3h5o23ubn3w1\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000h3h5o88fjcc2w\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000k3h5op4mnsblf\" device=\"tablet\" workspace=\"sticky\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1932","7887","_mkhb_content_sticky_header_mobile","[mkhb_row id=\"cj6f1n2qd00043h5okuylqd8q\" device=\"mobile\" workspace=\"sticky\" layout=\"12\"][mkhb_col id=\"cj6f1iph300043h5or780gdf4\" device=\"mobile\" workspace=\"sticky\" width=\"12\"][/mkhb_col][mkhb_col id=\"cj6f1iph300073h5orfomt3kt\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000a3h5ojy22bkxr\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000d3h5o1ljiz2vj\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000g3h5o0j5hr4yp\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][mkhb_col id=\"cj6f1iph3000j3h5oil6klflj\" device=\"mobile\" workspace=\"sticky\" width=\"0\"][/mkhb_col][/mkhb_row]");
INSERT INTO wpcf_postmeta VALUES("1933","7887","_mkhb_chains","a:6:{s:25:\"ciyk0megh00073j5lbaqqngk4\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}}s:25:\"ciyk0megi000e3j5lkmn1osno\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}}s:25:\"ciyk0megi000i3j5l2ik0dom2\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}}s:25:\"cj6f1n2qd00063h5o2w2ejryb\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}}s:25:\"cj6f1n2qd00053h5o786pg9t0\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}}s:25:\"cj6f1n2qd00043h5okuylqd8q\";a:6:{i:0;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}i:1;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}i:2;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}i:3;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}i:4;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}i:5;a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}}}");
INSERT INTO wpcf_postmeta VALUES("1934","7887","_mkhb_chain","a:51:{s:25:\"ciyk0megh00073j5lbaqqngk4\";a:4:{s:6:\"source\";s:7:\"desktop\";s:7:\"desktop\";s:25:\"ciyk0megh00073j5lbaqqngk4\";s:6:\"tablet\";s:25:\"ciyk0megi000e3j5lkmn1osno\";s:6:\"mobile\";s:25:\"ciyk0megi000i3j5l2ik0dom2\";}s:25:\"cj67b4wnt000b3h5ok7lpivzj\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}s:25:\"cj6m476if000e3e5ojut0zwww\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m476if000c3e5ofkm3zszw\";s:6:\"tablet\";s:25:\"cj6m476if000d3e5oglr1z9ue\";s:7:\"desktop\";s:25:\"cj6m476if000e3e5ojut0zwww\";}s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}s:25:\"cj6m47a35000h3e5oalpl0ixp\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m47a35000f3e5oonub0flw\";s:6:\"tablet\";s:25:\"cj6m47a35000g3e5oa1e9igga\";s:7:\"desktop\";s:25:\"cj6m47a35000h3e5oalpl0ixp\";}s:25:\"cj6m5rxl3000n3e5o5k3yr6xm\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m5rxl3000l3e5odjnl05l9\";s:6:\"tablet\";s:25:\"cj6m5rxl3000m3e5omyxggz06\";s:7:\"desktop\";s:25:\"cj6m5rxl3000n3e5o5k3yr6xm\";}s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}s:25:\"cj67b4wnt000n3h5o9d65yxru\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}s:25:\"cj67b4wnt000q3h5ohtuq4o22\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}s:25:\"ciyk0megi000e3j5lkmn1osno\";a:4:{s:6:\"source\";s:7:\"desktop\";s:7:\"desktop\";s:25:\"ciyk0megh00073j5lbaqqngk4\";s:6:\"tablet\";s:25:\"ciyk0megi000e3j5lkmn1osno\";s:6:\"mobile\";s:25:\"ciyk0megi000i3j5l2ik0dom2\";}s:25:\"cj67b4wnt000a3h5oqn8izoh1\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}s:25:\"cj6m476if000d3e5oglr1z9ue\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m476if000c3e5ofkm3zszw\";s:6:\"tablet\";s:25:\"cj6m476if000d3e5oglr1z9ue\";s:7:\"desktop\";s:25:\"cj6m476if000e3e5ojut0zwww\";}s:25:\"cj67b4wnt000d3h5oy9q2vedj\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}s:25:\"cj6m47a35000g3e5oa1e9igga\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m47a35000f3e5oonub0flw\";s:6:\"tablet\";s:25:\"cj6m47a35000g3e5oa1e9igga\";s:7:\"desktop\";s:25:\"cj6m47a35000h3e5oalpl0ixp\";}s:25:\"cj6m5rxl3000m3e5omyxggz06\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m5rxl3000l3e5odjnl05l9\";s:6:\"tablet\";s:25:\"cj6m5rxl3000m3e5omyxggz06\";s:7:\"desktop\";s:25:\"cj6m5rxl3000n3e5o5k3yr6xm\";}s:25:\"cj67b4wnt000g3h5oqu704a9a\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}s:25:\"cj67b4wnt000j3h5osdety0u5\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}s:25:\"cj67b4wnt000p3h5oe5fmhqit\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}s:25:\"ciyk0megi000i3j5l2ik0dom2\";a:4:{s:6:\"source\";s:7:\"desktop\";s:7:\"desktop\";s:25:\"ciyk0megh00073j5lbaqqngk4\";s:6:\"tablet\";s:25:\"ciyk0megi000e3j5lkmn1osno\";s:6:\"mobile\";s:25:\"ciyk0megi000i3j5l2ik0dom2\";}s:25:\"cj67b4wnt00093h5o8pm8pntw\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt00093h5o8pm8pntw\";s:6:\"tablet\";s:25:\"cj67b4wnt000a3h5oqn8izoh1\";s:7:\"desktop\";s:25:\"cj67b4wnt000b3h5ok7lpivzj\";}s:25:\"cj6m476if000c3e5ofkm3zszw\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m476if000c3e5ofkm3zszw\";s:6:\"tablet\";s:25:\"cj6m476if000d3e5oglr1z9ue\";s:7:\"desktop\";s:25:\"cj6m476if000e3e5ojut0zwww\";}s:25:\"cj6m5rxl3000l3e5odjnl05l9\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m5rxl3000l3e5odjnl05l9\";s:6:\"tablet\";s:25:\"cj6m5rxl3000m3e5omyxggz06\";s:7:\"desktop\";s:25:\"cj6m5rxl3000n3e5o5k3yr6xm\";}s:25:\"cj6m47a35000f3e5oonub0flw\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6m47a35000f3e5oonub0flw\";s:6:\"tablet\";s:25:\"cj6m47a35000g3e5oa1e9igga\";s:7:\"desktop\";s:25:\"cj6m47a35000h3e5oalpl0ixp\";}s:25:\"cj67b4wnt000c3h5o99tzkhmv\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000c3h5o99tzkhmv\";s:6:\"tablet\";s:25:\"cj67b4wnt000d3h5oy9q2vedj\";s:7:\"desktop\";s:25:\"cj67b4wnt000e3h5ojv9jqeqs\";}s:25:\"cj67b4wnt000f3h5oia0rygma\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000f3h5oia0rygma\";s:6:\"tablet\";s:25:\"cj67b4wnt000g3h5oqu704a9a\";s:7:\"desktop\";s:25:\"cj67b4wnt000h3h5ohqc6vvyq\";}s:25:\"cj67b4wnt000i3h5oode0cc48\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000i3h5oode0cc48\";s:6:\"tablet\";s:25:\"cj67b4wnt000j3h5osdety0u5\";s:7:\"desktop\";s:25:\"cj67b4wnt000k3h5ozq2hl2iz\";}s:25:\"cj67b4wnt000l3h5oda98thw4\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000l3h5oda98thw4\";s:6:\"tablet\";s:25:\"cj67b4wnt000m3h5o7zkbtdz6\";s:7:\"desktop\";s:25:\"cj67b4wnt000n3h5o9d65yxru\";}s:25:\"cj67b4wnt000o3h5omu55sugr\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj67b4wnt000o3h5omu55sugr\";s:6:\"tablet\";s:25:\"cj67b4wnt000p3h5oe5fmhqit\";s:7:\"desktop\";s:25:\"cj67b4wnt000q3h5ohtuq4o22\";}s:25:\"cj6f1n2qd00063h5o2w2ejryb\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1n2qd00043h5okuylqd8q\";s:6:\"tablet\";s:25:\"cj6f1n2qd00053h5o786pg9t0\";s:7:\"desktop\";s:25:\"cj6f1n2qd00063h5o2w2ejryb\";}s:25:\"cj6f1iph300063h5ocbedhqh2\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}s:25:\"cj6f1iph300093h5o0lib30g9\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}s:25:\"cj6f1iph3000c3h5oq63yqucn\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}s:25:\"cj6f1iph3000f3h5oxzp3thh2\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}s:25:\"cj6f1iph3000i3h5o00qf6zys\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}s:25:\"cj6f1iph3000l3h5o76j1o6sz\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}s:25:\"cj6f1n2qd00053h5o786pg9t0\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1n2qd00043h5okuylqd8q\";s:6:\"tablet\";s:25:\"cj6f1n2qd00053h5o786pg9t0\";s:7:\"desktop\";s:25:\"cj6f1n2qd00063h5o2w2ejryb\";}s:25:\"cj6f1iph300053h5oqdoerx9p\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}s:25:\"cj6f1iph300083h5ooeh6eef3\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}s:25:\"cj6f1iph3000e3h5o23ubn3w1\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}s:25:\"cj6f1iph3000h3h5o88fjcc2w\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}s:25:\"cj6f1iph3000k3h5op4mnsblf\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}s:25:\"cj6f1n2qd00043h5okuylqd8q\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1n2qd00043h5okuylqd8q\";s:6:\"tablet\";s:25:\"cj6f1n2qd00053h5o786pg9t0\";s:7:\"desktop\";s:25:\"cj6f1n2qd00063h5o2w2ejryb\";}s:25:\"cj6f1iph300043h5or780gdf4\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300043h5or780gdf4\";s:6:\"tablet\";s:25:\"cj6f1iph300053h5oqdoerx9p\";s:7:\"desktop\";s:25:\"cj6f1iph300063h5ocbedhqh2\";}s:25:\"cj6f1iph300073h5orfomt3kt\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph300073h5orfomt3kt\";s:6:\"tablet\";s:25:\"cj6f1iph300083h5ooeh6eef3\";s:7:\"desktop\";s:25:\"cj6f1iph300093h5o0lib30g9\";}s:25:\"cj6f1iph3000a3h5ojy22bkxr\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000a3h5ojy22bkxr\";s:6:\"tablet\";s:25:\"cj6f1iph3000b3h5o6u6g5ey4\";s:7:\"desktop\";s:25:\"cj6f1iph3000c3h5oq63yqucn\";}s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000d3h5o1ljiz2vj\";s:6:\"tablet\";s:25:\"cj6f1iph3000e3h5o23ubn3w1\";s:7:\"desktop\";s:25:\"cj6f1iph3000f3h5oxzp3thh2\";}s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000g3h5o0j5hr4yp\";s:6:\"tablet\";s:25:\"cj6f1iph3000h3h5o88fjcc2w\";s:7:\"desktop\";s:25:\"cj6f1iph3000i3h5o00qf6zys\";}s:25:\"cj6f1iph3000j3h5oil6klflj\";a:4:{s:6:\"source\";s:7:\"desktop\";s:6:\"mobile\";s:25:\"cj6f1iph3000j3h5oil6klflj\";s:6:\"tablet\";s:25:\"cj6f1iph3000k3h5op4mnsblf\";s:7:\"desktop\";s:25:\"cj6f1iph3000l3h5o76j1o6sz\";}}");
INSERT INTO wpcf_postmeta VALUES("1935","7887","_mkhb_specificities","a:5:{s:25:\"cj6m47a35000g3e5oa1e9igga\";a:1:{s:6:\"margin\";a:1:{s:5:\"right\";a:1:{i:0;s:7:\"desktop\";}}}s:25:\"cj6m5rxl3000m3e5omyxggz06\";a:1:{s:6:\"margin\";a:1:{s:5:\"right\";a:1:{i:0;s:7:\"desktop\";}}}s:25:\"cj6m476if000c3e5ofkm3zszw\";a:2:{s:10:\"cssDisplay\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}s:9:\"alignment\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}}s:25:\"cj6m5rxl3000l3e5odjnl05l9\";a:1:{s:6:\"margin\";a:2:{s:3:\"top\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}s:5:\"right\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}}s:25:\"cj6m47a35000f3e5oonub0flw\";a:4:{s:8:\"boxColor\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}s:8:\"barColor\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}s:6:\"margin\";a:2:{s:3:\"top\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}s:5:\"right\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}s:8:\"navStyle\";a:1:{s:5:\"value\";a:2:{i:0;s:7:\"desktop\";i:1;s:6:\"tablet\";}}}}");
INSERT INTO wpcf_postmeta VALUES("1936","7887","_mkhb_active_device","desktop");
INSERT INTO wpcf_postmeta VALUES("1937","7887","_mkhb_active_header","normal");
INSERT INTO wpcf_postmeta VALUES("1938","7887","_mkhb_options_laptop","true");
INSERT INTO wpcf_postmeta VALUES("1939","7887","_mkhb_options_mobile","false");
INSERT INTO wpcf_postmeta VALUES("1940","7887","_mkhb_options_overlapping_content","false");
INSERT INTO wpcf_postmeta VALUES("1941","7887","_mkhb_options_sticky_header","false");
INSERT INTO wpcf_postmeta VALUES("1942","7887","_mkhb_options_sticky_header_offset","header");
INSERT INTO wpcf_postmeta VALUES("1943","7887","_mkhb_options_sticky_header_behaviour","slide-down");



CREATE TABLE `wpcf_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=7889 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_posts VALUES("87","1","2016-05-26 14:20:25","2016-05-26 14:20:25","","juevers_homepage_header","","inherit","open","closed","","juevers_homepage_header","","","2016-05-26 14:20:25","2016-05-26 14:20:25","","0","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/juevers_homepage_header.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("97","1","2016-05-26 14:31:53","2016-05-26 14:31:53","","home_layout_left","","inherit","open","closed","","home_layout_left","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","7","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/home_layout_left.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("110","1","2016-05-26 14:55:51","2016-05-26 14:55:51","","josh-wolf-testimonial-150x150","","inherit","open","closed","","josh-wolf-testimonial-150x150","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","109","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/josh-wolf-testimonial-150x150.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("113","1","2016-05-26 14:57:32","2016-05-26 14:57:32","","mucahit-gayiran-testimonial-150x150","","inherit","open","closed","","mucahit-gayiran-testimonial-150x150","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","112","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/mucahit-gayiran-testimonial-150x150.png","0","attachment","image/png","0");
INSERT INTO wpcf_posts VALUES("119","1","2016-05-27 07:54:03","2016-05-27 07:54:03","","ask_question_bg","","inherit","open","closed","","ask_question_bg","","","2016-05-27 07:54:03","2016-05-27 07:54:03","","0","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/ask_question_bg.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("151","1","2016-05-27 09:16:44","2016-05-27 09:16:44","","jueves_about_header","","inherit","open","closed","","jueves_about_header","","","2016-05-27 09:16:44","2016-05-27 09:16:44","","0","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/jueves_about_header.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("165","1","2016-05-27 11:12:09","2016-05-27 11:12:09","","employee-carl","","inherit","open","closed","","employee-carl","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","163","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/employee-carl.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("167","1","2016-05-27 11:27:23","2016-05-27 11:27:23","","employee-lisa","","inherit","open","closed","","employee-lisa","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","166","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/employee-lisa.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("172","1","2016-05-27 11:29:40","2016-05-27 11:29:40","","employee-catherine","","inherit","open","closed","","employee-catherine","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","171","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/employee-catherine.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("175","1","2016-05-27 11:32:00","2016-05-27 11:32:00","","employee-willie","","inherit","open","closed","","employee-willie","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","174","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/employee-willie.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("182","1","2016-05-27 12:02:06","2016-05-27 12:02:06","","favicon-jueves","","inherit","open","closed","","favicon-jueves","","","2016-05-27 12:02:06","2016-05-27 12:02:06","","0","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/favicon-jueves.png","0","attachment","image/png","0");
INSERT INTO wpcf_posts VALUES("194","1","2016-05-31 11:17:09","2016-05-31 11:17:09","","jueves_consultation_header","","inherit","open","closed","","jueves_consultation_header","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","12","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/jueves_consultation_header.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("202","1","2016-05-31 11:25:01","2016-05-31 11:25:01","","jueves_consultation_side","","inherit","open","closed","","jueves_consultation_side","","","2016-05-31 11:25:01","2016-05-31 11:25:01","","0","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/jueves_consultation_side.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7818","1","2016-06-10 08:57:54","2016-06-10 08:57:54","","blog-01","","inherit","open","closed","","blog-01-2","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","7790","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2015/12/blog-01.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7819","1","2016-06-10 08:58:22","2016-06-10 08:58:22","","blog-02","","inherit","open","closed","","blog-02-2","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","7790","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2015/12/blog-02.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7820","1","2016-06-10 08:58:46","2016-06-10 08:58:46","","blog-03","","inherit","open","closed","","blog-03-2","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","7790","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2015/12/blog-03.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7821","1","2016-06-10 08:59:13","2016-06-10 08:59:13","","blog-04","","inherit","open","closed","","blog-04","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","7790","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2015/12/blog-04.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7","1","2016-05-26 12:15:29","2016-05-26 12:15:29","[mk_page_section bg_image=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2016/05/juevers_homepage_header.jpg\" bg_color=\"rgba(10,10,10,0.01)\" bg_position=\"right center\" bg_repeat=\"no-repeat\" bg_stretch=\"true\" enable_3d=\"true\" bg_gradient=\"left_top\" video_color_mask=\"#000000\" gr_end=\"rgba(0,0,0,0.55)\" video_opacity=\"1\" full_height=\"true\" skip_arrow=\"true\" top_shape_color=\"#ffffff\" bottom_shape_color=\"#ffffff\" el_class=\"custom-jueves-gradient-bg\" sidebar=\"sidebar-1\"][vc_column width=\"1/2\"][mk_padding_divider visibility=\"visible-sm\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_tablet=\"15\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]weight loss[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h1\" color=\"#ffffff\" size=\"56\" force_font_size=\"true\" size_tablet=\"40\" size_phone=\"30\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"12.6\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]tips &amp; ideas[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"one_fourth\" align=\"left\" thin_single_color=\"#a7fd51\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"15\" visibility=\"hidden-sm\"][vc_column_text disable_pattern=\"false\" animation=\"bottom-to-top\"]<span style=\"color: #e2e2e2;\">Lorem ipsum dolor sit amet conse ctetur suspen disse efficitur sollic itudin nibh solli citudin quis mattis.</span>[/vc_column_text][mk_padding_divider size=\"60\" visibility=\"visible-sm\"][/vc_column][vc_column width=\"1/2\"][/vc_column][/mk_page_section][vc_row fullwidth=\"true\" fullwidth_content=\"false\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title color=\"#000000\" size=\"42\" force_font_size=\"true\" size_tablet=\"35\" size_phone=\"25\" font_weight=\"bold\" font_style=\"normal\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" align=\"center\" el_class=\"custom-jueves-heading\"]This is a <em>Diet</em> Lifestyle.[/mk_fancy_title][vc_column_text disable_pattern=\"false\" align=\"center\" animation=\"left-to-right\"]<span style=\"color: #999999;\">Lorem ipsum dolor sit amet.</span>[/vc_column_text][mk_padding_divider][vc_row_inner animation=\"bottom-to-top\"][vc_column_inner width=\"1/3\"][mk_icon_box2 icon_size=\"48\" icon=\"mk-li-like\" icon_color=\"#ffffff\" icon_background_color=\"#e3e3e3\" icon_hover_color=\"#ffffff\" icon_hover_background_color=\"#7ed321\" title=\"Exercise\" title_weight=\"bold\" title_color=\"#0a0a0a\" title_top_padding=\"25\" title_bottom_padding=\"15\" description_color=\"rgba(0,0,0,0.6)\" read_more_url=\"#\" el_class=\"custom-jueves-icon-box\"]Lorem ipsum dolor sit amet consec tetur adipi scing elitomo suspeno endisse efficitur sollici tudin nibh euismod tempor turpis ferm entum vitae fusce convallis aliquam.[/mk_icon_box2][mk_padding_divider visibility=\"visible-sm\"][/vc_column_inner][vc_column_inner width=\"1/3\"][mk_icon_box2 icon_size=\"48\" icon=\"mk-moon-heart-broken\" icon_color=\"#ffffff\" icon_background_color=\"#e3e3e3\" icon_hover_color=\"#ffffff\" icon_hover_background_color=\"#7ed321\" title=\"Heart Risks\" title_weight=\"bold\" title_color=\"#0a0a0a\" title_top_padding=\"25\" title_bottom_padding=\"15\" description_color=\"rgba(0,0,0,0.6)\" read_more_url=\"#\" el_class=\"custom-jueves-icon-box\"]Lorem ipsum dolor sit amet consec tetur adipi scing elitomo suspeno endisse efficitur sollici tudin nibh euismod tempor turpis ferm entum vitae fusce convallis aliquam.[/mk_icon_box2][mk_padding_divider visibility=\"visible-sm\"][/vc_column_inner][vc_column_inner width=\"1/3\"][mk_icon_box2 icon_size=\"48\" icon=\"mk-li-food\" icon_color=\"#ffffff\" icon_background_color=\"#e3e3e3\" icon_hover_color=\"#ffffff\" icon_hover_background_color=\"#7ed321\" title=\"Meal Plan\" title_weight=\"bold\" title_color=\"#0a0a0a\" title_top_padding=\"25\" title_bottom_padding=\"15\" description_color=\"rgba(0,0,0,0.6)\" read_more_url=\"#\" el_class=\"custom-jueves-icon-box\"]Lorem ipsum dolor sit amet consec tetur adipi scing elitomo suspeno endisse efficitur sollici tudin nibh euismod tempor turpis ferm entum vitae fusce convallis aliquam.[/mk_icon_box2][/vc_column_inner][/vc_row_inner][mk_padding_divider][mk_button dimension=\"outline\" corner_style=\"full_rounded\" size=\"medium\" url=\"#\" align=\"center\" button_custom_width=\"250\" el_class=\"custom-jueves-btn\" outline_skin=\"custom\" outline_active_text_color=\"#000000\" outline_hover_bg_color=\"#000000\" outline_hover_color=\"#ffffff\"]DISCOVER MORE[/mk_button][mk_padding_divider size=\"140\"][/vc_column][/vc_row][mk_page_section layout_structure=\"half_right\" bg_image=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2016/06/home-layout-r.jpg\" bg_color=\"#9cd361\" bg_stretch=\"true\" full_width=\"true\"][vc_column][mk_padding_divider size=\"200\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_tablet=\"15\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]Summer is[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h3\" color=\"#ffffff\" size=\"56\" force_font_size=\"true\" size_tablet=\"30\" size_phone=\"25\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"12.6\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]Coming[/mk_fancy_title][vc_column_text disable_pattern=\"false\" animation=\"left-to-right\"]<span style=\"color: #ffffff;\">Lorem ipsum dolor sit amet conse adipiscing elitomo susdisse efficitur sollicitudin nibhon euismod derico.</span>[/vc_column_text][mk_button dimension=\"flat\" size=\"medium\" url=\"#\" margin_bottom=\"0\" animation=\"bottom-to-top\" el_class=\"custom-jueves-btn\" bg_color=\"#9cd361\" btn_hover_bg=\"#9cd361\" btn_hover_txt_color=\"rgba(255,255,255,0.8)\"]LEARN MORE[/mk_button][mk_padding_divider size=\"200\"][/vc_column][/mk_page_section][mk_page_section layout_structure=\"half_left\" bg_image=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2016/05/home_layout_left.jpg\" bg_color=\"#f4f4f4\" bg_stretch=\"true\" full_width=\"true\"][vc_column][mk_padding_divider size=\"200\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#0a0a0a\" size=\"30\" force_font_size=\"true\" size_tablet=\"20\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"right-to-left\"]Refresh[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h3\" color=\"#000000\" size=\"56\" force_font_size=\"true\" size_tablet=\"30\" size_phone=\"25\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"12.6\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"right-to-left\"]Yourself[/mk_fancy_title][vc_column_text disable_pattern=\"false\" animation=\"left-to-right\"]<span style=\"color: #222222;\">Lorem ipsum dolor sit amet conse adipiscing elitomo susdisse efficitur sollicitudin nibhon euismod derico.</span>[/vc_column_text][mk_button dimension=\"flat\" size=\"medium\" url=\"#\" margin_bottom=\"0\" animation=\"bottom-to-top\" el_class=\"custom-jueves-btn\" bg_color=\"#f4f4f4\" btn_hover_bg=\"#f4f4f4\" text_color=\"dark\" btn_hover_txt_color=\"rgba(0,0,0,0.6)\"]LEARN MORE[/mk_button][mk_padding_divider size=\"200\"][/vc_column][/mk_page_section][mk_page_section sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title tag_name=\"h4\" color=\"#0a0a0a\" size=\"30\" force_font_size=\"true\" size_tablet=\"20\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"60\" font_family=\"Montserrat\" font_type=\"google\" align=\"center\" animation=\"bottom-to-top\"]testimonials[/mk_fancy_title][mk_testimonials][mk_padding_divider size=\"140\"][/vc_column][/mk_page_section][mk_page_section bg_image=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2016/05/ask_question_bg.jpg\" bg_stretch=\"true\" enable_3d=\"true\" video_color_mask=\"#9cd361\" video_opacity=\"0.9\" padding_top=\"80\" padding_bottom=\"80\" sidebar=\"sidebar-1\"][vc_column width=\"2/3\"][mk_fancy_title tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_phone=\"20\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_top=\"20\" margin_bottom=\"10\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]questions?[/mk_fancy_title][vc_column_text disable_pattern=\"false\"]<span style=\"color: #ffffff;\">For more information about our services, please visit contact page.</span>[/vc_column_text][/vc_column][vc_column width=\"1/3\"][mk_padding_divider size=\"15\"][mk_image src=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/arrow-go.svg\" image_size=\"full\" link=\"http://demos.artbees.net/jupiter5/jueves/contact/\" target=\"_blank\" align=\"center\" margin_bottom=\"5\"][/vc_column][/mk_page_section]","Home","","publish","closed","closed","","home","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","0","http://demos.artbees.net/jupiter5/jueves/?page_id=7","0","page","","0");
INSERT INTO wpcf_posts VALUES("9","1","2016-05-26 12:16:45","2016-05-26 12:16:45"," ","","","publish","closed","closed","","9","","","2016-05-26 12:16:45","2016-05-26 12:16:45","","0","http://demos.artbees.net/jupiter5/jueves/?p=9","1","nav_menu_item","","0");
INSERT INTO wpcf_posts VALUES("18","1","2016-05-26 12:19:41","2016-05-26 12:19:41"," ","","","publish","closed","closed","","18","","","2016-05-26 12:19:41","2016-05-26 12:19:41","","0","http://demos.artbees.net/jupiter5/jueves/?p=18","5","nav_menu_item","","0");
INSERT INTO wpcf_posts VALUES("20","1","2016-05-26 12:19:37","2016-05-26 12:19:37"," ","","","publish","closed","closed","","20","","","2016-05-26 12:19:37","2016-05-26 12:19:37","","0","http://demos.artbees.net/jupiter5/jueves/?p=20","3","nav_menu_item","","0");
INSERT INTO wpcf_posts VALUES("21","1","2016-05-26 12:19:34","2016-05-26 12:19:34"," ","","","publish","closed","closed","","21","","","2016-05-26 12:19:34","2016-05-26 12:19:34","","0","http://demos.artbees.net/jupiter5/jueves/?p=21","2","nav_menu_item","","0");
INSERT INTO wpcf_posts VALUES("163","1","2016-05-27 11:11:05","2016-05-27 11:11:05","","CARL PAXTON","","publish","closed","closed","","carl-paxton","","","2016-05-27 11:11:05","2016-05-27 11:11:05","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=employees&amp;p=163","0","employees","","0");
INSERT INTO wpcf_posts VALUES("166","1","2016-05-27 11:27:56","2016-05-27 11:27:56","","LISA BAIN","","publish","closed","closed","","lisa-bain","","","2016-05-27 11:27:56","2016-05-27 11:27:56","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=employees&amp;p=166","0","employees","","0");
INSERT INTO wpcf_posts VALUES("171","1","2016-05-27 11:30:02","2016-05-27 11:30:02","","CATHERINE FICK","","publish","closed","closed","","catherine-fick","","","2016-05-27 11:30:02","2016-05-27 11:30:02","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=employees&amp;p=171","0","employees","","0");
INSERT INTO wpcf_posts VALUES("174","1","2016-05-27 11:32:09","2016-05-27 11:32:09","","WILLIE DRAGO","","publish","closed","closed","","willie-drago","","","2016-05-27 11:32:09","2016-05-27 11:32:09","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=employees&amp;p=174","0","employees","","0");
INSERT INTO wpcf_posts VALUES("242","1","2016-06-02 12:06:11","2016-06-02 12:06:11"," ","","","publish","closed","closed","","242","","","2016-06-02 12:06:11","2016-06-02 12:06:11","","0","http://demos.artbees.net/jupiter5/jueves/?p=242","4","nav_menu_item","","0");
INSERT INTO wpcf_posts VALUES("7822","1","2016-06-10 08:59:39","2016-06-10 08:59:39","","blog-05","","inherit","open","closed","","blog-05","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","7790","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2015/12/blog-05.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7823","1","2016-06-10 09:00:10","2016-06-10 09:00:10","","blog-06","","inherit","open","closed","","blog-06-2","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","7790","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2015/12/blog-06.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7824","1","2016-06-10 09:00:43","2016-06-10 09:00:43","","blog-07","","inherit","open","closed","","blog-07-2","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","7790","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2015/12/blog-07.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7825","1","2016-06-10 09:01:20","2016-06-10 09:01:20","","blog-08","","inherit","open","closed","","blog-08-2","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","7790","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2015/12/blog-08.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7864","1","2016-06-13 12:33:07","2016-06-13 12:33:07","","map-marker","","inherit","open","closed","","map-marker","","","2016-06-13 12:33:07","2016-06-13 12:33:07","","0","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/map-marker.png","0","attachment","image/png","0");
INSERT INTO wpcf_posts VALUES("7874","1","2016-06-13 12:52:07","2016-06-13 12:52:07","","home-layout-r","","inherit","open","closed","","home-layout-r","","","2016-06-13 12:52:07","2016-06-13 12:52:07","","0","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/home-layout-r.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7878","1","2016-06-13 12:57:33","2016-06-13 12:57:33","","blog_bg","","inherit","open","closed","","blog_bg","","","2016-06-13 12:57:33","2016-06-13 12:57:33","","0","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/blog_bg.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7881","1","2016-06-13 12:59:32","2016-06-13 12:59:32","","shutterstock_85451623-1","","inherit","open","closed","","shutterstock_85451623-1","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","112","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/shutterstock_85451623-1.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("7882","1","2016-06-13 12:59:46","2016-06-13 12:59:46","","shutterstock_85451623-2","","inherit","open","closed","","shutterstock_85451623-2","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","109","http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/shutterstock_85451623-2.jpg","0","attachment","image/jpeg","0");
INSERT INTO wpcf_posts VALUES("10","1","2016-05-26 12:16:58","2016-05-26 12:16:58","[mk_page_section bg_image=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2016/05/jueves_about_header.jpg\" bg_color=\"rgba(10,10,10,0.01)\" bg_position=\"left center\" bg_stretch=\"true\" enable_3d=\"true\" bg_gradient=\"left_top\" video_color_mask=\"rgba(0,0,0,0.8)\" gr_end=\"rgba(0,0,0,0.35)\" video_opacity=\"1\" top_shape_color=\"#ffffff\" has_bottom_shape_divider=\"true\" bottom_shape_size=\"small\" bottom_shape_color=\"#ffffff\" el_class=\"custom-jueves-gradient-bg\" sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\" visibility=\"hidden-sm\"][mk_padding_divider size=\"100\"][mk_fancy_title tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_tablet=\"15\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]\r\n<p class=\"p1\"><span class=\"s1\">For sake of your</span></p>\r\n[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h1\" color=\"#ffffff\" size=\"56\" force_font_size=\"true\" size_tablet=\"40\" size_phone=\"30\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"12.6\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]fitness[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"one_fourth\" align=\"left\" thin_single_color=\"#a7fd51\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"120\" visibility=\"hidden-sm\"][/vc_column][/mk_page_section][mk_page_section][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title tag_name=\"h3\" color=\"#000000\" size=\"22\" font_weight=\"400\" txt_transform=\"uppercase\" letter_spacing=\"2.4\" margin_bottom=\"0\" font_family=\"none\" responsive_align=\"left\"]About Us[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"custom_width\" custom_width=\"70\" align=\"left\" thin_single_color=\"#a9a9a9\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"40\"][vc_column_text]Lorem ipsum dolor sit amet conse ctetur adipiscing elit sed eget fringilla lacus phasellus eget elit cursus elementum ligula vitae cursus libero non lorem posuere viverra enim eget pretium felis aenean tristique mollis lorem ut tempus proin finibus massa et metus sagittis pharetra proin facilisis efficitur dictum suspen disse et gravida diam nam velit luctus vel nulla sit amet dictum euismod urna duis ultrices quis leo vel rhoncus aenean cursus aliquam ultricies integer.[/vc_column_text][mk_padding_divider size=\"120\"][/vc_column][/mk_page_section][mk_page_section bg_color=\"#f9f9f9\" sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title tag_name=\"h3\" color=\"#000000\" size=\"22\" font_weight=\"400\" txt_transform=\"uppercase\" letter_spacing=\"2.4\" margin_bottom=\"0\" font_family=\"none\" responsive_align=\"left\"]Our Team[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"custom_width\" custom_width=\"70\" align=\"left\" thin_single_color=\"#a9a9a9\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"40\"][mk_employees column=\"4\" rounded_image=\"false\" count=\"4\"][mk_padding_divider size=\"80\"][/vc_column][/mk_page_section][mk_page_section sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#0a0a0a\" size=\"30\" force_font_size=\"true\" size_tablet=\"20\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"60\" font_family=\"Montserrat\" font_type=\"google\" align=\"center\" animation=\"bottom-to-top\"]testimonials[/mk_fancy_title][mk_testimonials][mk_padding_divider size=\"140\"][/vc_column][/mk_page_section][mk_page_section bg_image=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2016/05/ask_question_bg.jpg\" bg_stretch=\"true\" enable_3d=\"true\" video_color_mask=\"#9cd361\" video_opacity=\"0.9\" padding_top=\"80\" padding_bottom=\"80\" sidebar=\"sidebar-1\"][vc_column width=\"2/3\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_phone=\"20\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_top=\"20\" margin_bottom=\"10\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]questions?[/mk_fancy_title][vc_column_text disable_pattern=\"false\"]<span style=\"color: #ffffff;\">For more information about our services, please visit contact page.</span>[/vc_column_text][/vc_column][vc_column width=\"1/3\"][mk_padding_divider size=\"15\"][mk_image src=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/arrow-go.svg\" image_size=\"full\" link=\"http://demos.artbees.net/jupiter5/jueves/contact/\" target=\"_blank\" align=\"center\"][/vc_column][/mk_page_section]","About","","publish","closed","closed","","about","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","0","http://demos.artbees.net/jupiter5/jueves/?page_id=10","0","page","","0");
INSERT INTO wpcf_posts VALUES("12","1","2016-05-26 12:17:14","2016-05-26 12:17:14","[mk_page_section bg_image=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2016/05/jueves_consultation_header.jpg\" bg_color=\"rgba(10,10,10,0.01)\" bg_position=\"left center\" bg_stretch=\"true\" enable_3d=\"true\" bg_gradient=\"left_top\" video_color_mask=\"rgba(0,0,0,0.8)\" gr_end=\"rgba(0,0,0,0.35)\" video_opacity=\"1\" top_shape_color=\"#ffffff\" has_bottom_shape_divider=\"true\" bottom_shape_size=\"small\" bottom_shape_color=\"#ffffff\" el_class=\"custom-jueves-gradient-bg\" sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\" visibility=\"hidden-sm\"][mk_padding_divider size=\"100\"][mk_fancy_title tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_tablet=\"15\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]\r\n<p class=\"p1\"><span class=\"s1\">solutions &amp;</span></p>\r\n[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h1\" color=\"#ffffff\" size=\"56\" force_font_size=\"true\" size_tablet=\"40\" size_phone=\"30\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"10\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]support[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"one_fourth\" align=\"left\" thin_single_color=\"#a7fd51\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"120\" visibility=\"hidden-sm\"][/vc_column][/mk_page_section][mk_page_section][vc_column width=\"1/2\" css=\".vc_custom_1464696761315{padding-right: 20px !important;}\"][mk_padding_divider size=\"140\"][mk_fancy_title color=\"#000000\" size=\"28\" force_font_size=\"true\" size_tablet=\"20\" size_phone=\"20\" font_weight=\"400\" txt_transform=\"uppercase\" letter_spacing=\"2.4\" margin_bottom=\"0\" font_family=\"none\" responsive_align=\"left\"]What We Provide[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"custom_width\" custom_width=\"70\" align=\"left\" thin_single_color=\"#a9a9a9\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"40\"][vc_column_text]<span style=\"color: #999999;\">Lorem ipsum dolor sit amet conse ctetur adipiscing elit sed eget fringilla lacus phasellus eget elit cursus elementum ligula vitae cursus libero non lorem posuere viverra enim.</span>[/vc_column_text][vc_tabs style=\"simple\" container_bg_color=\"#ffffff\"][vc_tab title=\"WEIGHT LOSS\" tab_id=\"1464694018-1-43\"][vc_column_text]<span style=\"color: #999999;\">Lorem ipsum dolor amet conse ctetur adipiscing elit eget fringilla lacus phasellus eget elit cursus.</span>\r\n\r\n<span style=\"color: #999999;\">Tristique mollis lorem ut tempus proin finibus massa et metus sagittis pharetra proin facilisis efficitur disse et gravida.</span>[/vc_column_text][/vc_tab][vc_tab title=\"GAIN MASS\" tab_id=\"1464694018-2-70\"][vc_column_text]<span style=\"color: #999999;\">Lorem ipsum dolor sit amet conse ctetur adipiscing elit sed eget fringilla lacus phasellus eget elit cursus.</span>\r\n\r\n<span style=\"color: #999999;\">Tristique mollis lorem ut tempus proin finibus massa et metus sagittis pharetra proin facilisis efficitur dictum suspen disse et gravida.</span>[/vc_column_text][/vc_tab][vc_tab title=\"HEALTHY LIVING\" tab_id=\"1464694073659-2-4\"][vc_column_text]<span style=\"color: #999999;\">Bisum dolor sit amet conse ctetur adipiscing elit sed eget fringilla lacus phasellus eget elit cursus.</span>\r\n\r\n<span style=\"color: #999999;\">Tristique mollis lorem ut tempus proin finibus massa et metus sagittis pharetra proin facilisis efficitur dictum suspen disse.</span>[/vc_column_text][/vc_tab][/vc_tabs][mk_padding_divider size=\"120\" visibility=\"hidden-sm\"][/vc_column][vc_column width=\"1/2\"][mk_padding_divider size=\"110\" visibility=\"hidden-sm\"][mk_image src=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2016/05/jueves_consultation_side.jpg\" image_size=\"full\"][mk_padding_divider size=\"120\"][/vc_column][/mk_page_section][mk_page_section bg_color=\"#f9f9f9\" sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title tag_name=\"h4\" color=\"#000000\" size=\"22\" font_weight=\"400\" txt_transform=\"uppercase\" letter_spacing=\"2.4\" font_family=\"none\" align=\"center\"]plans fee[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"custom_width\" custom_width=\"70\" thin_single_color=\"#b8e986\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"40\"][mk_pricing_table_2 table_number=\"3\" order=\"ASC\" orderby=\"menu_order\"][/mk_pricing_table_2][mk_padding_divider size=\"70\"][mk_padding_divider size=\"70\" visibility=\"hidden-sm\"][/vc_column][/mk_page_section][mk_page_section sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h3\" color=\"#0a0a0a\" size=\"30\" force_font_size=\"true\" size_tablet=\"20\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"60\" font_family=\"Montserrat\" font_type=\"google\" align=\"center\" animation=\"bottom-to-top\"]testimonial[/mk_fancy_title][mk_testimonials][mk_padding_divider size=\"140\"][/vc_column][/mk_page_section][mk_page_section bg_image=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2016/05/ask_question_bg.jpg\" bg_stretch=\"true\" enable_3d=\"true\" video_color_mask=\"#9cd361\" video_opacity=\"0.9\" padding_top=\"80\" padding_bottom=\"80\" sidebar=\"sidebar-1\"][vc_column width=\"2/3\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_phone=\"20\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_top=\"20\" margin_bottom=\"10\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]any questions?[/mk_fancy_title][vc_column_text disable_pattern=\"false\"]<span style=\"color: #ffffff;\">For more information about our services, please visit contact page.</span>[/vc_column_text][/vc_column][vc_column width=\"1/3\"][mk_padding_divider size=\"15\"][mk_image src=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/arrow-go.svg\" image_size=\"full\" link=\"http://demos.artbees.net/jupiter5/jueves/contact/\" target=\"_blank\" align=\"center\"][/vc_column][/mk_page_section]","Consulting","","publish","closed","closed","","consulting","","","2018-11-16 15:35:42","2018-11-16 15:35:42","","0","http://demos.artbees.net/jupiter5/jueves/?page_id=12","0","page","","0");
INSERT INTO wpcf_posts VALUES("16","1","2016-05-26 12:18:05","2016-05-26 12:18:05","[mk_page_section bg_image=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/ask_question_bg.jpg\" bg_color=\"rgba(10,10,10,0.01)\" bg_position=\"left center\" bg_stretch=\"true\" enable_3d=\"true\" bg_gradient=\"left_top\" video_color_mask=\"rgba(0,0,0,0.8)\" gr_end=\"rgba(0,0,0,0.35)\" video_opacity=\"1\" top_shape_color=\"#ffffff\" has_bottom_shape_divider=\"true\" bottom_shape_size=\"small\" bottom_shape_color=\"#ffffff\" el_class=\"custom-jueves-gradient-bg\" sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\" visibility=\"hidden-sm\"][mk_padding_divider size=\"100\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_tablet=\"15\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]\r\n<p class=\"p1\"><span class=\"s1\">for details</span></p>\r\n[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h1\" color=\"#ffffff\" size=\"56\" force_font_size=\"true\" size_tablet=\"40\" size_phone=\"30\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"8\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]Contact[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"one_fourth\" align=\"left\" thin_single_color=\"#a7fd51\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"120\" visibility=\"hidden-sm\"][/vc_column][/mk_page_section][mk_page_section][vc_column width=\"4/12\"][mk_padding_divider size=\"140\"][mk_fancy_title tag_name=\"h4\" color=\"#0c0c0c\" size=\"18\" font_weight=\"bold\" txt_transform=\"uppercase\" letter_spacing=\"3.5\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" responsive_align=\"left\"]\r\n<p class=\"p1\"><span class=\"s1\">opening hours</span></p>\r\n[/mk_fancy_title][vc_column_text]Lorem ipsum dolor sit amet cons etetur adipi scing elit aliquam sed.[/vc_column_text][mk_fancy_title color=\"rgba(12,12,12,0.6)\" size=\"15\" line_height=\"150\" font_weight=\"bold\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\"]\r\n<p class=\"p1\"><span class=\"s1\">09:00AM - 05:00PM</span></p>\r\n<p class=\"p1\"><span class=\"s1\">09-00AM - 05:00PM</span></p>\r\n[/mk_fancy_title][mk_fancy_title tag_name=\"h4\" color=\"#0c0c0c\" size=\"18\" font_weight=\"bold\" txt_transform=\"uppercase\" letter_spacing=\"3.5\" margin_top=\"30\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" responsive_align=\"left\"]\r\n<p class=\"p1\"><span class=\"s1\">location</span></p>\r\n[/mk_fancy_title][vc_column_text]Lorem ipsum dolor sit amet cons etetur adipi scing elit aliquam sed.[/vc_column_text][mk_padding_divider size=\"140\" visibility=\"hidden-sm\"][/vc_column][vc_column width=\"8/12\" el_class=\"custom-contact-pad\"][mk_padding_divider size=\"60\" visibility=\"hidden-sm\"][mk_padding_divider size=\"60\"][contact-form-7 id=\"258\"][/vc_column][/mk_page_section][vc_row fullwidth=\"true\"][vc_column][mk_advanced_gmaps latitude=\"40.741246\" longitude=\"-73.966285\" address=\"Patricia Street Grapevine Nashville, TX 76500\" latitude_2=\"40.741781\" longitude_2=\"-74.018816\" address_2=\"Waldeck Street Grapevine Nashville, TX 760\" latitude_3=\"40.687802\" longitude_3=\" -74.018816\" address_3=\"Patricia Waldeck Street Grapevine Nashville, TX 76051\" pin_icon=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/map-marker.png\" additional_markers=\"{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}5B{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}7B{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22uniqid{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}3A{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}221465824387557{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2C{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22latitude{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}3A{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2240.710666{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2C{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22longitude{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}3A{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22-74.039783{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2C{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22address{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}3A{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22Patricia{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20C.{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20Amedee{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}204401{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20Waldeck{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20Street{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20Grapevine{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20Nashville{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2C{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}20TX{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2076051{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}2C{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22marker_icon{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}3A{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22http{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}3A//demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/map-marker.png{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}22{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}7D{2b361e6ecfc345283a7e2cc09c97b08ba79665caa7670008e4e4943db7c3ece9}5D\" content_font_color=\"#ffffff\" height=\"500\" map_zoom=\"12\" modify_json=\"true\" map_json=\"JTVCJTdCJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjJhbGwlMjIlMkMlMjJlbGVtZW50VHlwZSUyMiUzQSUyMmxhYmVscy50ZXh0LmZpbGwlMjIlMkMlMjJzdHlsZXJzJTIyJTNBJTVCJTdCJTIyc2F0dXJhdGlvbiUyMiUzQTM2JTdEJTJDJTdCJTIyY29sb3IlMjIlM0ElMjIlMjMwMDAwMDAlMjIlN0QlMkMlN0IlMjJsaWdodG5lc3MlMjIlM0E0MCU3RCU1RCU3RCUyQyU3QiUyMmZlYXR1cmVUeXBlJTIyJTNBJTIyYWxsJTIyJTJDJTIyZWxlbWVudFR5cGUlMjIlM0ElMjJsYWJlbHMudGV4dC5zdHJva2UlMjIlMkMlMjJzdHlsZXJzJTIyJTNBJTVCJTdCJTIydmlzaWJpbGl0eSUyMiUzQSUyMm9uJTIyJTdEJTJDJTdCJTIyY29sb3IlMjIlM0ElMjIlMjMwMDAwMDAlMjIlN0QlMkMlN0IlMjJsaWdodG5lc3MlMjIlM0ExNiU3RCU1RCU3RCUyQyU3QiUyMmZlYXR1cmVUeXBlJTIyJTNBJTIyYWxsJTIyJTJDJTIyZWxlbWVudFR5cGUlMjIlM0ElMjJsYWJlbHMuaWNvbiUyMiUyQyUyMnN0eWxlcnMlMjIlM0ElNUIlN0IlMjJ2aXNpYmlsaXR5JTIyJTNBJTIyb2ZmJTIyJTdEJTVEJTdEJTJDJTdCJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjJhZG1pbmlzdHJhdGl2ZSUyMiUyQyUyMmVsZW1lbnRUeXBlJTIyJTNBJTIyZ2VvbWV0cnkuZmlsbCUyMiUyQyUyMnN0eWxlcnMlMjIlM0ElNUIlN0IlMjJjb2xvciUyMiUzQSUyMiUyMzAwMDAwMCUyMiU3RCUyQyU3QiUyMmxpZ2h0bmVzcyUyMiUzQTIwJTdEJTVEJTdEJTJDJTdCJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjJhZG1pbmlzdHJhdGl2ZSUyMiUyQyUyMmVsZW1lbnRUeXBlJTIyJTNBJTIyZ2VvbWV0cnkuc3Ryb2tlJTIyJTJDJTIyc3R5bGVycyUyMiUzQSU1QiU3QiUyMmNvbG9yJTIyJTNBJTIyJTIzMDAwMDAwJTIyJTdEJTJDJTdCJTIybGlnaHRuZXNzJTIyJTNBMTclN0QlMkMlN0IlMjJ3ZWlnaHQlMjIlM0ExLjIlN0QlNUQlN0QlMkMlN0IlMjJmZWF0dXJlVHlwZSUyMiUzQSUyMmxhbmRzY2FwZSUyMiUyQyUyMmVsZW1lbnRUeXBlJTIyJTNBJTIyZ2VvbWV0cnklMjIlMkMlMjJzdHlsZXJzJTIyJTNBJTVCJTdCJTIyY29sb3IlMjIlM0ElMjIlMjMwMDAwMDAlMjIlN0QlMkMlN0IlMjJsaWdodG5lc3MlMjIlM0EyMCU3RCU1RCU3RCUyQyU3QiUyMmZlYXR1cmVUeXBlJTIyJTNBJTIycG9pJTIyJTJDJTIyZWxlbWVudFR5cGUlMjIlM0ElMjJnZW9tZXRyeSUyMiUyQyUyMnN0eWxlcnMlMjIlM0ElNUIlN0IlMjJjb2xvciUyMiUzQSUyMiUyMzAwMDAwMCUyMiU3RCUyQyU3QiUyMmxpZ2h0bmVzcyUyMiUzQTIxJTdEJTVEJTdEJTJDJTdCJTIyZmVhdHVyZVR5cGUlMjIlM0ElMjJyb2FkLmhpZ2h3YXklMjIlMkMlMjJlbGVtZW50VHlwZSUyMiUzQSUyMmdlb21ldHJ5LmZpbGwlMjIlMkMlMjJzdHlsZXJzJTIyJTNBJTVCJTdCJTIyY29sb3IlMjIlM0ElMjIlMjMwMDAwMDAlMjIlN0QlMkMlN0IlMjJsaWdodG5lc3MlMjIlM0ExNyU3RCU1RCU3RCUyQyU3QiUyMmZlYXR1cmVUeXBlJTIyJTNBJTIycm9hZC5oaWdod2F5JTIyJTJDJTIyZWxlbWVudFR5cGUlMjIlM0ElMjJnZW9tZXRyeS5zdHJva2UlMjIlMkMlMjJzdHlsZXJzJTIyJTNBJTVCJTdCJTIyY29sb3IlMjIlM0ElMjIlMjMwMDAwMDAlMjIlN0QlMkMlN0IlMjJsaWdodG5lc3MlMjIlM0EyOSU3RCUyQyU3QiUyMndlaWdodCUyMiUzQTAuMiU3RCU1RCU3RCUyQyU3QiUyMmZlYXR1cmVUeXBlJTIyJTNBJTIycm9hZC5hcnRlcmlhbCUyMiUyQyUyMmVsZW1lbnRUeXBlJTIyJTNBJTIyZ2VvbWV0cnklMjIlMkMlMjJzdHlsZXJzJTIyJTNBJTVCJTdCJTIyY29sb3IlMjIlM0ElMjIlMjMwMDAwMDAlMjIlN0QlMkMlN0IlMjJsaWdodG5lc3MlMjIlM0ExOCU3RCU1RCU3RCUyQyU3QiUyMmZlYXR1cmVUeXBlJTIyJTNBJTIycm9hZC5sb2NhbCUyMiUyQyUyMmVsZW1lbnRUeXBlJTIyJTNBJTIyZ2VvbWV0cnklMjIlMkMlMjJzdHlsZXJzJTIyJTNBJTVCJTdCJTIyY29sb3IlMjIlM0ElMjIlMjMwMDAwMDAlMjIlN0QlMkMlN0IlMjJsaWdodG5lc3MlMjIlM0ExNiU3RCU1RCU3RCUyQyU3QiUyMmZlYXR1cmVUeXBlJTIyJTNBJTIydHJhbnNpdCUyMiUyQyUyMmVsZW1lbnRUeXBlJTIyJTNBJTIyZ2VvbWV0cnklMjIlMkMlMjJzdHlsZXJzJTIyJTNBJTVCJTdCJTIyY29sb3IlMjIlM0ElMjIlMjMwMDAwMDAlMjIlN0QlMkMlN0IlMjJsaWdodG5lc3MlMjIlM0ExOSU3RCU1RCU3RCUyQyU3QiUyMmZlYXR1cmVUeXBlJTIyJTNBJTIyd2F0ZXIlMjIlMkMlMjJlbGVtZW50VHlwZSUyMiUzQSUyMmdlb21ldHJ5JTIyJTJDJTIyc3R5bGVycyUyMiUzQSU1QiU3QiUyMmNvbG9yJTIyJTNBJTIyJTIzMDAwMDAwJTIyJTdEJTJDJTdCJTIybGlnaHRuZXNzJTIyJTNBMTclN0QlNUQlN0QlNUQ=\"][/vc_column][/vc_row]","Contact","","publish","closed","closed","","contact","","","2016-05-26 12:18:05","2016-05-26 12:18:05","","0","http://demos.artbees.net/jupiter5/jueves/?page_id=16","0","page","","0");
INSERT INTO wpcf_posts VALUES("109","1","2016-05-26 14:55:59","2016-05-26 14:55:59","","testimonial-02","","publish","closed","closed","","testimonial-02","","","2016-05-26 14:55:59","2016-05-26 14:55:59","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=testimonial&amp;p=109","0","testimonial","","0");
INSERT INTO wpcf_posts VALUES("112","1","2016-05-26 14:57:40","2016-05-26 14:57:40","","testimonial-01","","publish","closed","closed","","testimonial-01","","","2016-05-26 14:57:40","2016-05-26 14:57:40","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=testimonial&amp;p=112","0","testimonial","","0");
INSERT INTO wpcf_posts VALUES("216","1","2016-05-31 14:00:19","2016-05-31 14:00:19","","Medium Plan","","publish","closed","closed","","test","","","2016-05-31 14:00:19","2016-05-31 14:00:19","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=pricing&amp;p=216","2","pricing","","0");
INSERT INTO wpcf_posts VALUES("219","1","2016-05-31 14:17:14","2016-05-31 14:17:14","","Small Plan","","publish","closed","closed","","small-plan","","","2016-05-31 14:17:14","2016-05-31 14:17:14","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=pricing&amp;p=219","1","pricing","","0");
INSERT INTO wpcf_posts VALUES("223","1","2016-05-31 14:17:56","2016-05-31 14:17:56","","Pro Plan","","publish","closed","closed","","pro-plan","","","2016-05-31 14:17:56","2016-05-31 14:17:56","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=pricing&amp;p=223","3","pricing","","0");
INSERT INTO wpcf_posts VALUES("235","1","2016-06-02 11:41:34","2016-06-02 11:41:34","[mk_page_section bg_image=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/blog_bg.jpg\" bg_color=\"rgba(10,10,10,0.01)\" bg_position=\"left center\" bg_stretch=\"true\" enable_3d=\"true\" bg_gradient=\"left_top\" video_color_mask=\"rgba(0,0,0,0.8)\" gr_end=\"rgba(0,0,0,0.35)\" video_opacity=\"1\" top_shape_color=\"#ffffff\" has_bottom_shape_divider=\"true\" bottom_shape_size=\"small\" bottom_shape_color=\"#ffffff\" el_class=\"custom-jueves-gradient-bg\" sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\" visibility=\"hidden-sm\"][mk_padding_divider size=\"100\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_tablet=\"15\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]\r\n<p class=\"p1\"><span class=\"s1\">tab into our</span></p>\r\n[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h1\" color=\"#ffffff\" size=\"56\" force_font_size=\"true\" size_tablet=\"40\" size_phone=\"30\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"8\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]blog[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"one_fourth\" align=\"left\" thin_single_color=\"#a7fd51\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"120\" visibility=\"hidden-sm\"][/vc_column][/mk_page_section][mk_page_section][vc_column][mk_padding_divider size=\"140\"][mk_blog style=\"thumbnail\" image_size=\"full\" post_count=\"6\" excerpt_length=\"70\" pagination_style=\"2\"][mk_padding_divider size=\"140\"][/vc_column][/mk_page_section]","Blog","","publish","closed","closed","","blog","","","2016-06-02 11:41:34","2016-06-02 11:41:34","","0","http://demos.artbees.net/jupiter5/jueves/?page_id=235","0","page","","0");
INSERT INTO wpcf_posts VALUES("258","1","2016-06-02 12:52:59","2016-06-02 12:52:59","<p class=\"double\">[text* your-name placeholder \"FIRST NAME &amp; LAST NAME\"] [email* your-email placeholder \"EMAIL ADDRESS\"]</p>\r\n\r\n<p class=\"full\">[text your-subject placeholder \"SUBJECT\"] </p>\r\n\r\n<p class=\"full\">[textarea your-message placeholder \"MESSAGE\"] </p>\r\n\r\n<p>[submit \"Send\"]</p>\nJueves \"[your-subject]\"\n[your-name] \nFrom: [your-name] \r\nSubject: [your-subject]\r\n\r\nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Jueves (http://demos.artbees.net/jupiter5/jueves)\ninfo@artbees.net\nReply-To: [your-email]\n\n\n\n\nJueves \"[your-subject]\"\nJueves \nMessage Body:\r\n[your-message]\r\n\r\n--\r\nThis e-mail was sent from a contact form on Jueves (http://demos.artbees.net/jupiter5/jueves)\n[your-email]\nReply-To: info@artbees.net\n\n\n\nThank you for your message. It has been sent.\nThere was an error trying to send your message. Please try again later.\nOne or more fields have an error. Please check and try again.\nThere was an error trying to send your message. Please try again later.\nYou must accept the terms and conditions before sending your message.\nThe field is required.\nThe field is too long.\nThe field is too short.\nThe date format is incorrect.\nThe date is before the earliest one allowed.\nThe date is after the latest one allowed.\nThere was an unknown error uploading the file.\nYou are not allowed to upload files of this type.\nThe file is too big.\nThere was an error uploading the file.\nThe number format is invalid.\nThe number is smaller than the minimum allowed.\nThe number is larger than the maximum allowed.\nThe answer to the quiz is incorrect.\nYour entered code is incorrect.\nThe e-mail address entered is invalid.\nThe URL is invalid.\nThe telephone number is invalid.","Contact Form (Jueves Demo)","","publish","closed","closed","","contact-form-1","","","2016-06-02 12:52:59","2016-06-02 12:52:59","","0","http://demos.artbees.net/jupiter5/jueves/?post_type=wpcf7_contact_form&amp;p=258","0","wpcf7_contact_form","","0");
INSERT INTO wpcf_posts VALUES("501","1","2015-11-11 14:36:34","2015-11-11 14:36:34","[vc_row][vc_column][mk_dropcaps style=\"fancy-style\" size=\"50\" padding=\"20\" background_color=\"#7ed321\" text_color=\"#ffffff\"]S[/mk_dropcaps][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\n[/vc_column_text][mk_blockquote font_family=\"none\" font_size_combat=\"true\" text_size=\"16\" animation=\"left-to-right\" align=\"left\" width=\"1/1\" el_position=\"first last\"]<strong>Suspendisse blandit</strong> ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum.[/mk_blockquote][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque quis eros lobortis, vestibulum turpis ac, pulvinar odio. Praesent vulputate a elit ac mollis. In sit amet ipsum turpis. Pellentesque venenatis, libero vel euismod lobortis, mi metus luctus augue, eget dapibus elit nisi eu massa. Phasellus sollicitudin nisl posuere nibh ultricies, et fringilla dui gravida. Donec iaculis adipiscing neque, non congue massa euismod quis. Etiam interdum dolor sit amet justo vulputate, non mollis velit venenatis. Morbi eu nunc nunc. Phasellus lacus magna, dapibus vitae pellentesque sit amet, venenatis ac purus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Donec volutpat bibendum diam eget posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam adipiscing pretium tortor, eget pretium nulla ullamcorper id. Nullam ac nunc at lectus elementum vestibulum sit amet vitae dui. Donec ut gravida lorem.\r\n\r\nCras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus. Quisque gravida luctus volutpat. Mauris interdum, lectus in dapibus molestie, quam felis sollicitudin mauris, sit amet tempus velit lectus nec lorem. Nullam vel mollis neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam vel enim dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed tincidunt accumsan massa id viverra. Sed sagittis, nisl sit amet imperdiet convallis, nunc tortor consequat tellus, vel molestie neque nulla non ligula. Proin tincidunt tellus ac porta volutpat. Cras mattis congue lacus id bibendum. Mauris ut sodales libero. Maecenas feugiat sit amet enim in accumsan.[/vc_column_text][/vc_column][/vc_row]","blog-07","Pendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. ","publish","open","closed","","blog-07","","","2015-11-11 14:36:34","2015-11-11 14:36:34","","0","http://moozpaper.com/jupiter/?p=17","0","post","","0");
INSERT INTO wpcf_posts VALUES("504","1","2015-11-11 14:39:02","2015-11-11 14:39:02","[vc_row][vc_column][mk_dropcaps style=\"fancy-style\" size=\"50\" padding=\"20\" background_color=\"#7ed321\" text_color=\"#ffffff\"]S[/mk_dropcaps][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\n[/vc_column_text][mk_blockquote font_family=\"none\" font_size_combat=\"true\" text_size=\"16\" animation=\"left-to-right\" align=\"left\" width=\"1/1\" el_position=\"first last\"]<strong>Suspendisse blandit</strong> ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum.[/mk_blockquote][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque quis eros lobortis, vestibulum turpis ac, pulvinar odio. Praesent vulputate a elit ac mollis. In sit amet ipsum turpis. Pellentesque venenatis, libero vel euismod lobortis, mi metus luctus augue, eget dapibus elit nisi eu massa. Phasellus sollicitudin nisl posuere nibh ultricies, et fringilla dui gravida. Donec iaculis adipiscing neque, non congue massa euismod quis. Etiam interdum dolor sit amet justo vulputate, non mollis velit venenatis. Morbi eu nunc nunc. Phasellus lacus magna, dapibus vitae pellentesque sit amet, venenatis ac purus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Donec volutpat bibendum diam eget posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam adipiscing pretium tortor, eget pretium nulla ullamcorper id. Nullam ac nunc at lectus elementum vestibulum sit amet vitae dui. Donec ut gravida lorem.\r\n\r\nCras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus. Quisque gravida luctus volutpat. Mauris interdum, lectus in dapibus molestie, quam felis sollicitudin mauris, sit amet tempus velit lectus nec lorem. Nullam vel mollis neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam vel enim dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed tincidunt accumsan massa id viverra. Sed sagittis, nisl sit amet imperdiet convallis, nunc tortor consequat tellus, vel molestie neque nulla non ligula. Proin tincidunt tellus ac porta volutpat. Cras mattis congue lacus id bibendum. Mauris ut sodales libero. Maecenas feugiat sit amet enim in accumsan.[/vc_column_text][/vc_column][/vc_row]","blog-06","Pendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget.\r\n","publish","open","closed","","blog-06","","","2015-11-11 14:39:02","2015-11-11 14:39:02","","0","http://moozpaper.com/jupiter/?p=20","0","post","","1");
INSERT INTO wpcf_posts VALUES("507","1","2015-12-11 14:39:35","2015-12-11 14:39:35","[vc_row][vc_column][mk_dropcaps style=\"fancy-style\" size=\"50\" padding=\"20\" background_color=\"#7ed321\" text_color=\"#ffffff\"]S[/mk_dropcaps][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\n[/vc_column_text][mk_blockquote font_family=\"none\" font_size_combat=\"true\" text_size=\"16\" animation=\"left-to-right\" align=\"left\" width=\"1/1\" el_position=\"first last\"]<strong>Suspendisse blandit</strong> ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum.[/mk_blockquote][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque quis eros lobortis, vestibulum turpis ac, pulvinar odio. Praesent vulputate a elit ac mollis. In sit amet ipsum turpis. Pellentesque venenatis, libero vel euismod lobortis, mi metus luctus augue, eget dapibus elit nisi eu massa. Phasellus sollicitudin nisl posuere nibh ultricies, et fringilla dui gravida. Donec iaculis adipiscing neque, non congue massa euismod quis. Etiam interdum dolor sit amet justo vulputate, non mollis velit venenatis. Morbi eu nunc nunc. Phasellus lacus magna, dapibus vitae pellentesque sit amet, venenatis ac purus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Donec volutpat bibendum diam eget posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam adipiscing pretium tortor, eget pretium nulla ullamcorper id. Nullam ac nunc at lectus elementum vestibulum sit amet vitae dui. Donec ut gravida lorem.\r\n\r\nCras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus. Quisque gravida luctus volutpat. Mauris interdum, lectus in dapibus molestie, quam felis sollicitudin mauris, sit amet tempus velit lectus nec lorem. Nullam vel mollis neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam vel enim dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed tincidunt accumsan massa id viverra. Sed sagittis, nisl sit amet imperdiet convallis, nunc tortor consequat tellus, vel molestie neque nulla non ligula. Proin tincidunt tellus ac porta volutpat. Cras mattis congue lacus id bibendum. Mauris ut sodales libero. Maecenas feugiat sit amet enim in accumsan.[/vc_column_text][/vc_column][/vc_row]","blog-04","Pendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget.\r\n","publish","open","closed","","proin-urna-enim-semper","","","2015-12-11 14:39:35","2015-12-11 14:39:35","","0","http://moozpaper.com/jupiter/?p=23","0","post","","0");
INSERT INTO wpcf_posts VALUES("508","1","2015-12-11 14:41:45","2015-12-11 14:41:45","[vc_row][vc_column][mk_dropcaps style=\"fancy-style\" size=\"50\" padding=\"20\" background_color=\"#7ed321\" text_color=\"#ffffff\"]S[/mk_dropcaps][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\n[/vc_column_text][mk_blockquote font_family=\"none\" font_size_combat=\"true\" text_size=\"16\" animation=\"left-to-right\" align=\"left\" width=\"1/1\" el_position=\"first last\"]<strong>Suspendisse blandit</strong> ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum.[/mk_blockquote][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque quis eros lobortis, vestibulum turpis ac, pulvinar odio. Praesent vulputate a elit ac mollis. In sit amet ipsum turpis. Pellentesque venenatis, libero vel euismod lobortis, mi metus luctus augue, eget dapibus elit nisi eu massa. Phasellus sollicitudin nisl posuere nibh ultricies, et fringilla dui gravida. Donec iaculis adipiscing neque, non congue massa euismod quis. Etiam interdum dolor sit amet justo vulputate, non mollis velit venenatis. Morbi eu nunc nunc. Phasellus lacus magna, dapibus vitae pellentesque sit amet, venenatis ac purus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Donec volutpat bibendum diam eget posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam adipiscing pretium tortor, eget pretium nulla ullamcorper id. Nullam ac nunc at lectus elementum vestibulum sit amet vitae dui. Donec ut gravida lorem.\r\n\r\nCras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus. Quisque gravida luctus volutpat. Mauris interdum, lectus in dapibus molestie, quam felis sollicitudin mauris, sit amet tempus velit lectus nec lorem. Nullam vel mollis neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam vel enim dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed tincidunt accumsan massa id viverra. Sed sagittis, nisl sit amet imperdiet convallis, nunc tortor consequat tellus, vel molestie neque nulla non ligula. Proin tincidunt tellus ac porta volutpat. Cras mattis congue lacus id bibendum. Mauris ut sodales libero. Maecenas feugiat sit amet enim in accumsan.[/vc_column_text][/vc_column][/vc_row]","blog-02","Pendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget.\r\n","publish","open","open","","blog-02","","","2015-12-11 14:41:45","2015-12-11 14:41:45","","0","http://moozpaper.com/jupiter/?p=24","0","post","","0");
INSERT INTO wpcf_posts VALUES("4518","1","2015-12-11 14:40:44","2015-12-11 14:40:44","[vc_row][vc_column][mk_dropcaps style=\"fancy-style\" size=\"50\" padding=\"20\" background_color=\"#7ed321\" text_color=\"#ffffff\"]S[/mk_dropcaps][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\n[/vc_column_text][mk_blockquote font_family=\"none\" font_size_combat=\"true\" text_size=\"16\" animation=\"left-to-right\" align=\"left\" width=\"1/1\" el_position=\"first last\"]<strong>Suspendisse blandit</strong> ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum.[/mk_blockquote][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque quis eros lobortis, vestibulum turpis ac, pulvinar odio. Praesent vulputate a elit ac mollis. In sit amet ipsum turpis. Pellentesque venenatis, libero vel euismod lobortis, mi metus luctus augue, eget dapibus elit nisi eu massa. Phasellus sollicitudin nisl posuere nibh ultricies, et fringilla dui gravida. Donec iaculis adipiscing neque, non congue massa euismod quis. Etiam interdum dolor sit amet justo vulputate, non mollis velit venenatis. Morbi eu nunc nunc. Phasellus lacus magna, dapibus vitae pellentesque sit amet, venenatis ac purus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Donec volutpat bibendum diam eget posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam adipiscing pretium tortor, eget pretium nulla ullamcorper id. Nullam ac nunc at lectus elementum vestibulum sit amet vitae dui. Donec ut gravida lorem.\r\n\r\nCras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus. Quisque gravida luctus volutpat. Mauris interdum, lectus in dapibus molestie, quam felis sollicitudin mauris, sit amet tempus velit lectus nec lorem. Nullam vel mollis neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam vel enim dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed tincidunt accumsan massa id viverra. Sed sagittis, nisl sit amet imperdiet convallis, nunc tortor consequat tellus, vel molestie neque nulla non ligula. Proin tincidunt tellus ac porta volutpat. Cras mattis congue lacus id bibendum. Mauris ut sodales libero. Maecenas feugiat sit amet enim in accumsan.[/vc_column_text][/vc_column][/vc_row]","blog-03","Pendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget.\r\n","publish","open","closed","","blog-03","","","2015-12-11 14:40:44","2015-12-11 14:40:44","","0","http://demos.artbees.net/jupiter5/?p=4518","0","post","","1");
INSERT INTO wpcf_posts VALUES("7600","1","2015-12-11 14:13:11","2015-12-11 14:13:11","[vc_row][vc_column][mk_dropcaps style=\"fancy-style\" size=\"50\" padding=\"20\" background_color=\"#7ed321\" text_color=\"#ffffff\"]S[/mk_dropcaps][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\n[/vc_column_text][mk_blockquote font_family=\"none\" font_size_combat=\"true\" text_size=\"16\" animation=\"left-to-right\" align=\"left\" width=\"1/1\" el_position=\"first last\"]<strong>Suspendisse blandit</strong> ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum.[/mk_blockquote][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque quis eros lobortis, vestibulum turpis ac, pulvinar odio. Praesent vulputate a elit ac mollis. In sit amet ipsum turpis. Pellentesque venenatis, libero vel euismod lobortis, mi metus luctus augue, eget dapibus elit nisi eu massa. Phasellus sollicitudin nisl posuere nibh ultricies, et fringilla dui gravida. Donec iaculis adipiscing neque, non congue massa euismod quis. Etiam interdum dolor sit amet justo vulputate, non mollis velit venenatis. Morbi eu nunc nunc. Phasellus lacus magna, dapibus vitae pellentesque sit amet, venenatis ac purus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Donec volutpat bibendum diam eget posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam adipiscing pretium tortor, eget pretium nulla ullamcorper id. Nullam ac nunc at lectus elementum vestibulum sit amet vitae dui. Donec ut gravida lorem.\r\n\r\nCras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus. Quisque gravida luctus volutpat. Mauris interdum, lectus in dapibus molestie, quam felis sollicitudin mauris, sit amet tempus velit lectus nec lorem. Nullam vel mollis neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam vel enim dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed tincidunt accumsan massa id viverra. Sed sagittis, nisl sit amet imperdiet convallis, nunc tortor consequat tellus, vel molestie neque nulla non ligula. Proin tincidunt tellus ac porta volutpat. Cras mattis congue lacus id bibendum. Mauris ut sodales libero. Maecenas feugiat sit amet enim in accumsan.[/vc_column_text][/vc_column][/vc_row]","blog-05","Pendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget.\r\n","publish","open","open","","diesel-bibendum","","","2015-12-11 14:13:11","2015-12-11 14:13:11","","0","http://demos.artbees.net/jupiter5/?p=7600","0","post","","0");
INSERT INTO wpcf_posts VALUES("7616","1","2015-11-11 14:34:07","2015-11-11 14:34:07","[vc_row][vc_column][mk_dropcaps style=\"fancy-style\" size=\"50\" padding=\"20\" background_color=\"#7ed321\" text_color=\"#ffffff\"]S[/mk_dropcaps][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\n[/vc_column_text][mk_blockquote font_family=\"none\" font_size_combat=\"true\" text_size=\"16\" animation=\"left-to-right\" align=\"left\" width=\"1/1\" el_position=\"first last\"]<strong>Suspendisse blandit</strong> ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum.[/mk_blockquote][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque quis eros lobortis, vestibulum turpis ac, pulvinar odio. Praesent vulputate a elit ac mollis. In sit amet ipsum turpis. Pellentesque venenatis, libero vel euismod lobortis, mi metus luctus augue, eget dapibus elit nisi eu massa. Phasellus sollicitudin nisl posuere nibh ultricies, et fringilla dui gravida. Donec iaculis adipiscing neque, non congue massa euismod quis. Etiam interdum dolor sit amet justo vulputate, non mollis velit venenatis. Morbi eu nunc nunc. Phasellus lacus magna, dapibus vitae pellentesque sit amet, venenatis ac purus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Donec volutpat bibendum diam eget posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam adipiscing pretium tortor, eget pretium nulla ullamcorper id. Nullam ac nunc at lectus elementum vestibulum sit amet vitae dui. Donec ut gravida lorem.\r\n\r\nCras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus. Quisque gravida luctus volutpat. Mauris interdum, lectus in dapibus molestie, quam felis sollicitudin mauris, sit amet tempus velit lectus nec lorem. Nullam vel mollis neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam vel enim dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed tincidunt accumsan massa id viverra. Sed sagittis, nisl sit amet imperdiet convallis, nunc tortor consequat tellus, vel molestie neque nulla non ligula. Proin tincidunt tellus ac porta volutpat. Cras mattis congue lacus id bibendum. Mauris ut sodales libero. Maecenas feugiat sit amet enim in accumsan.[/vc_column_text][/vc_column][/vc_row]","blog-08","Pendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget.\r\n","publish","open","open","","blog-08","","","2015-11-11 14:34:07","2015-11-11 14:34:07","","0","http://demos.artbees.net/jupiter5/?p=7616","0","post","","0");
INSERT INTO wpcf_posts VALUES("7790","1","2015-12-12 10:54:51","2015-12-12 10:54:51","[vc_row][vc_column][mk_dropcaps style=\"fancy-style\" size=\"50\" padding=\"20\" background_color=\"#7ed321\" text_color=\"#ffffff\"]S[/mk_dropcaps][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\nSuspendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel. Phasellus tristique cursus erat, a placerat tellus laoreet eget. Fusce vitae dui sit amet lacus rutrum convallis. Vivamus sit amet lectus venenatis est rhoncus interdum a vitae velit.\r\n\r\n[/vc_column_text][mk_blockquote font_family=\"none\" font_size_combat=\"true\" text_size=\"16\" animation=\"left-to-right\" align=\"left\" width=\"1/1\" el_position=\"first last\"]<strong>Suspendisse blandit</strong> ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum.[/mk_blockquote][vc_column_text p_margin_bottom=\"20\" width=\"1/1\" el_position=\"first last\"]Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque quis eros lobortis, vestibulum turpis ac, pulvinar odio. Praesent vulputate a elit ac mollis. In sit amet ipsum turpis. Pellentesque venenatis, libero vel euismod lobortis, mi metus luctus augue, eget dapibus elit nisi eu massa. Phasellus sollicitudin nisl posuere nibh ultricies, et fringilla dui gravida. Donec iaculis adipiscing neque, non congue massa euismod quis. Etiam interdum dolor sit amet justo vulputate, non mollis velit venenatis. Morbi eu nunc nunc. Phasellus lacus magna, dapibus vitae pellentesque sit amet, venenatis ac purus. Interdum et malesuada fames ac ante ipsum primis in faucibus. Donec volutpat bibendum diam eget posuere. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Aliquam adipiscing pretium tortor, eget pretium nulla ullamcorper id. Nullam ac nunc at lectus elementum vestibulum sit amet vitae dui. Donec ut gravida lorem.\r\n\r\nCras tristique turpis justo, eu consequat sem adipiscing ut. Donec posuere bibendum metus. Quisque gravida luctus volutpat. Mauris interdum, lectus in dapibus molestie, quam felis sollicitudin mauris, sit amet tempus velit lectus nec lorem. Nullam vel mollis neque. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam vel enim dui. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed tincidunt accumsan massa id viverra. Sed sagittis, nisl sit amet imperdiet convallis, nunc tortor consequat tellus, vel molestie neque nulla non ligula. Proin tincidunt tellus ac porta volutpat. Cras mattis congue lacus id bibendum. Mauris ut sodales libero. Maecenas feugiat sit amet enim in accumsan.[/vc_column_text][/vc_column][/vc_row]","blog-01","Mauris sed mauris bibendum est imperdiet porttitor tincidunt at lorem. Pendisse blandit ligula turpis, ac convallis risus fermentum non. Duis vestibulum quis quam vel accumsan. Nunc a vulputate lectus. Vestibulum eleifend nisl sed massa sagittis vestibulum. Vestibulum pretium blandit tellus, sodales volutpat sapien varius vel.","publish","open","closed","","blog-01","","","2015-12-12 10:54:51","2015-12-12 10:54:51","","0","http://demos.artbees.net/jupiter5/?p=7790","0","post","","0");
INSERT INTO wpcf_posts VALUES("7883","1","2016-05-26 12:15:29","2016-05-26 12:15:29","[mk_page_section bg_image=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/juevers_homepage_header.jpg\" bg_color=\"rgba(10,10,10,0.01)\" bg_position=\"right center\" bg_repeat=\"no-repeat\" bg_stretch=\"true\" enable_3d=\"true\" bg_gradient=\"left_top\" video_color_mask=\"#000000\" gr_end=\"rgba(0,0,0,0.55)\" video_opacity=\"1\" full_height=\"true\" skip_arrow=\"true\" top_shape_color=\"#ffffff\" bottom_shape_color=\"#ffffff\" el_class=\"custom-jueves-gradient-bg\" sidebar=\"sidebar-1\"][vc_column width=\"1/2\"][mk_padding_divider visibility=\"visible-sm\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_tablet=\"15\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]weight loss[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h1\" color=\"#ffffff\" size=\"56\" force_font_size=\"true\" size_tablet=\"40\" size_phone=\"30\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"12.6\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]tips &amp; ideas[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"one_fourth\" align=\"left\" thin_single_color=\"#a7fd51\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"15\" visibility=\"hidden-sm\"][vc_column_text disable_pattern=\"false\" animation=\"bottom-to-top\"]<span style=\"color: #e2e2e2;\">Lorem ipsum dolor sit amet conse ctetur suspen disse efficitur sollic itudin nibh solli citudin quis mattis.</span>[/vc_column_text][mk_padding_divider size=\"60\" visibility=\"visible-sm\"][/vc_column][vc_column width=\"1/2\"][/vc_column][/mk_page_section][vc_row fullwidth=\"true\" fullwidth_content=\"false\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title color=\"#000000\" size=\"42\" force_font_size=\"true\" size_tablet=\"35\" size_phone=\"25\" font_weight=\"bold\" font_style=\"normal\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" align=\"center\" el_class=\"custom-jueves-heading\"]This is a <em>Diet</em> Lifestyle.[/mk_fancy_title][vc_column_text disable_pattern=\"false\" align=\"center\" animation=\"left-to-right\"]<span style=\"color: #999999;\">Lorem ipsum dolor sit amet.</span>[/vc_column_text][mk_padding_divider][vc_row_inner animation=\"bottom-to-top\"][vc_column_inner width=\"1/3\"][mk_icon_box2 icon_size=\"48\" icon=\"mk-li-like\" icon_color=\"#ffffff\" icon_background_color=\"#e3e3e3\" icon_hover_color=\"#ffffff\" icon_hover_background_color=\"#7ed321\" title=\"Exercise\" title_weight=\"bold\" title_color=\"#0a0a0a\" title_top_padding=\"25\" title_bottom_padding=\"15\" description_color=\"rgba(0,0,0,0.6)\" read_more_url=\"#\" el_class=\"custom-jueves-icon-box\"]Lorem ipsum dolor sit amet consec tetur adipi scing elitomo suspeno endisse efficitur sollici tudin nibh euismod tempor turpis ferm entum vitae fusce convallis aliquam.[/mk_icon_box2][mk_padding_divider visibility=\"visible-sm\"][/vc_column_inner][vc_column_inner width=\"1/3\"][mk_icon_box2 icon_size=\"48\" icon=\"mk-moon-heart-broken\" icon_color=\"#ffffff\" icon_background_color=\"#e3e3e3\" icon_hover_color=\"#ffffff\" icon_hover_background_color=\"#7ed321\" title=\"Heart Risks\" title_weight=\"bold\" title_color=\"#0a0a0a\" title_top_padding=\"25\" title_bottom_padding=\"15\" description_color=\"rgba(0,0,0,0.6)\" read_more_url=\"#\" el_class=\"custom-jueves-icon-box\"]Lorem ipsum dolor sit amet consec tetur adipi scing elitomo suspeno endisse efficitur sollici tudin nibh euismod tempor turpis ferm entum vitae fusce convallis aliquam.[/mk_icon_box2][mk_padding_divider visibility=\"visible-sm\"][/vc_column_inner][vc_column_inner width=\"1/3\"][mk_icon_box2 icon_size=\"48\" icon=\"mk-li-food\" icon_color=\"#ffffff\" icon_background_color=\"#e3e3e3\" icon_hover_color=\"#ffffff\" icon_hover_background_color=\"#7ed321\" title=\"Meal Plan\" title_weight=\"bold\" title_color=\"#0a0a0a\" title_top_padding=\"25\" title_bottom_padding=\"15\" description_color=\"rgba(0,0,0,0.6)\" read_more_url=\"#\" el_class=\"custom-jueves-icon-box\"]Lorem ipsum dolor sit amet consec tetur adipi scing elitomo suspeno endisse efficitur sollici tudin nibh euismod tempor turpis ferm entum vitae fusce convallis aliquam.[/mk_icon_box2][/vc_column_inner][/vc_row_inner][mk_padding_divider][mk_button dimension=\"outline\" corner_style=\"full_rounded\" size=\"medium\" url=\"#\" align=\"center\" button_custom_width=\"250\" el_class=\"custom-jueves-btn\" outline_skin=\"custom\" outline_active_text_color=\"#000000\" outline_hover_bg_color=\"#000000\" outline_hover_color=\"#ffffff\"]DISCOVER MORE[/mk_button][mk_padding_divider size=\"140\"][/vc_column][/vc_row][mk_page_section layout_structure=\"half_right\" bg_image=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/home-layout-r.jpg\" bg_color=\"#9cd361\" bg_stretch=\"true\" full_width=\"true\"][vc_column][mk_padding_divider size=\"200\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_tablet=\"15\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]Summer is[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h3\" color=\"#ffffff\" size=\"56\" force_font_size=\"true\" size_tablet=\"30\" size_phone=\"25\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"12.6\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]Coming[/mk_fancy_title][vc_column_text disable_pattern=\"false\" animation=\"left-to-right\"]<span style=\"color: #ffffff;\">Lorem ipsum dolor sit amet conse adipiscing elitomo susdisse efficitur sollicitudin nibhon euismod derico.</span>[/vc_column_text][mk_button dimension=\"flat\" size=\"medium\" url=\"#\" margin_bottom=\"0\" animation=\"bottom-to-top\" el_class=\"custom-jueves-btn\" bg_color=\"#9cd361\" btn_hover_bg=\"#9cd361\" btn_hover_txt_color=\"rgba(255,255,255,0.8)\"]LEARN MORE[/mk_button][mk_padding_divider size=\"200\"][/vc_column][/mk_page_section][mk_page_section layout_structure=\"half_left\" bg_image=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/home_layout_left.jpg\" bg_color=\"#f4f4f4\" bg_stretch=\"true\" full_width=\"true\"][vc_column][mk_padding_divider size=\"200\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#0a0a0a\" size=\"30\" force_font_size=\"true\" size_tablet=\"20\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"right-to-left\"]Refresh[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h3\" color=\"#000000\" size=\"56\" force_font_size=\"true\" size_tablet=\"30\" size_phone=\"25\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"12.6\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"right-to-left\"]Yourself[/mk_fancy_title][vc_column_text disable_pattern=\"false\" animation=\"left-to-right\"]<span style=\"color: #222222;\">Lorem ipsum dolor sit amet conse adipiscing elitomo susdisse efficitur sollicitudin nibhon euismod derico.</span>[/vc_column_text][mk_button dimension=\"flat\" size=\"medium\" url=\"#\" margin_bottom=\"0\" animation=\"bottom-to-top\" el_class=\"custom-jueves-btn\" bg_color=\"#f4f4f4\" btn_hover_bg=\"#f4f4f4\" text_color=\"dark\" btn_hover_txt_color=\"rgba(0,0,0,0.6)\"]LEARN MORE[/mk_button][mk_padding_divider size=\"200\"][/vc_column][/mk_page_section][mk_page_section sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title tag_name=\"h4\" color=\"#0a0a0a\" size=\"30\" force_font_size=\"true\" size_tablet=\"20\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"60\" font_family=\"Montserrat\" font_type=\"google\" align=\"center\" animation=\"bottom-to-top\"]testimonials[/mk_fancy_title][mk_testimonials][mk_padding_divider size=\"140\"][/vc_column][/mk_page_section][mk_page_section bg_image=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/ask_question_bg.jpg\" bg_stretch=\"true\" enable_3d=\"true\" video_color_mask=\"#9cd361\" video_opacity=\"0.9\" padding_top=\"80\" padding_bottom=\"80\" sidebar=\"sidebar-1\"][vc_column width=\"2/3\"][mk_fancy_title tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_phone=\"20\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_top=\"20\" margin_bottom=\"10\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]questions?[/mk_fancy_title][vc_column_text disable_pattern=\"false\"]<span style=\"color: #ffffff;\">For more information about our services, please visit contact page.</span>[/vc_column_text][/vc_column][vc_column width=\"1/3\"][mk_padding_divider size=\"15\"][mk_image src=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/06/arrow-go.svg\" image_size=\"full\" link=\"http://demos.artbees.net/jupiter5/jueves/contact/\" target=\"_blank\" align=\"center\" margin_bottom=\"5\"][/vc_column][/mk_page_section]","Home","","inherit","closed","closed","","7-revision-v1","","","2016-05-26 12:15:29","2016-05-26 12:15:29","","7","http://thelighthousefoundation.didone.nl/thelighthousefoundation/2016/05/26/7-revision-v1/","0","revision","","0");
INSERT INTO wpcf_posts VALUES("7884","1","2016-05-26 12:16:58","2016-05-26 12:16:58","[mk_page_section bg_image=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/jueves_about_header.jpg\" bg_color=\"rgba(10,10,10,0.01)\" bg_position=\"left center\" bg_stretch=\"true\" enable_3d=\"true\" bg_gradient=\"left_top\" video_color_mask=\"rgba(0,0,0,0.8)\" gr_end=\"rgba(0,0,0,0.35)\" video_opacity=\"1\" top_shape_color=\"#ffffff\" has_bottom_shape_divider=\"true\" bottom_shape_size=\"small\" bottom_shape_color=\"#ffffff\" el_class=\"custom-jueves-gradient-bg\" sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\" visibility=\"hidden-sm\"][mk_padding_divider size=\"100\"][mk_fancy_title tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_tablet=\"15\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]\r\n<p class=\"p1\"><span class=\"s1\">For sake of your</span></p>\r\n[/mk_fancy_title][mk_fancy_title strip_tags=\"true\" tag_name=\"h1\" color=\"#ffffff\" size=\"56\" force_font_size=\"true\" size_tablet=\"40\" size_phone=\"30\" font_weight=\"bold\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"12.6\" margin_bottom=\"0\" font_family=\"Montserrat\" font_type=\"google\" animation=\"left-to-right\"]fitness[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"one_fourth\" align=\"left\" thin_single_color=\"#a7fd51\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"120\" visibility=\"hidden-sm\"][/vc_column][/mk_page_section][mk_page_section][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title tag_name=\"h3\" color=\"#000000\" size=\"22\" font_weight=\"400\" txt_transform=\"uppercase\" letter_spacing=\"2.4\" margin_bottom=\"0\" font_family=\"none\" responsive_align=\"left\"]About Us[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"custom_width\" custom_width=\"70\" align=\"left\" thin_single_color=\"#a9a9a9\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"40\"][vc_column_text]Lorem ipsum dolor sit amet conse ctetur adipiscing elit sed eget fringilla lacus phasellus eget elit cursus elementum ligula vitae cursus libero non lorem posuere viverra enim eget pretium felis aenean tristique mollis lorem ut tempus proin finibus massa et metus sagittis pharetra proin facilisis efficitur dictum suspen disse et gravida diam nam velit luctus vel nulla sit amet dictum euismod urna duis ultrices quis leo vel rhoncus aenean cursus aliquam ultricies integer.[/vc_column_text][mk_padding_divider size=\"120\"][/vc_column][/mk_page_section][mk_page_section bg_color=\"#f9f9f9\" sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title tag_name=\"h3\" color=\"#000000\" size=\"22\" font_weight=\"400\" txt_transform=\"uppercase\" letter_spacing=\"2.4\" margin_bottom=\"0\" font_family=\"none\" responsive_align=\"left\"]Our Team[/mk_fancy_title][mk_divider style=\"thin_solid\" divider_width=\"custom_width\" custom_width=\"70\" align=\"left\" thin_single_color=\"#a9a9a9\" thickness=\"7\" margin_top=\"0\" margin_bottom=\"40\"][mk_employees column=\"4\" rounded_image=\"false\" count=\"4\"][mk_padding_divider size=\"80\"][/vc_column][/mk_page_section][mk_page_section sidebar=\"sidebar-1\"][vc_column][mk_padding_divider size=\"140\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#0a0a0a\" size=\"30\" force_font_size=\"true\" size_tablet=\"20\" size_phone=\"15\" line_height=\"0\" font_weight=\"400\" font_style=\"normal\" txt_transform=\"uppercase\" letter_spacing=\"6.7\" margin_bottom=\"60\" font_family=\"Montserrat\" font_type=\"google\" align=\"center\" animation=\"bottom-to-top\"]testimonials[/mk_fancy_title][mk_testimonials][mk_padding_divider size=\"140\"][/vc_column][/mk_page_section][mk_page_section bg_image=\"http://demos.artbees.net/jupiter5/jueves/wp-content/uploads/sites/112/2016/05/ask_question_bg.jpg\" bg_stretch=\"true\" enable_3d=\"true\" video_color_mask=\"#9cd361\" video_opacity=\"0.9\" padding_top=\"80\" padding_bottom=\"80\" sidebar=\"sidebar-1\"][vc_column width=\"2/3\"][mk_fancy_title strip_tags=\"true\" tag_name=\"h4\" color=\"#ffffff\" size=\"30\" force_font_size=\"true\" size_phone=\"20\" line_height=\"0\" font