

CREATE TABLE `wpcf_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `wpcf_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_comments VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2018-11-16 13:49:58","2018-11-16 13:49:58","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.","0","1","","","0","0");



CREATE TABLE `wpcf_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `wpcf_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_options VALUES("1","siteurl","http://thelighthousefoundation.didone.nl/thelighthousefoundation","yes");
INSERT INTO wpcf_options VALUES("2","home","http://thelighthousefoundation.didone.nl/thelighthousefoundation","yes");
INSERT INTO wpcf_options VALUES("3","blogname","The Lighthouse Foundation","yes");
INSERT INTO wpcf_options VALUES("4","blogdescription","The Lighthouse Foundation","yes");
INSERT INTO wpcf_options VALUES("5","users_can_register","0","yes");
INSERT INTO wpcf_options VALUES("6","admin_email","admin@thelighthousefoundation.didone.nl","yes");
INSERT INTO wpcf_options VALUES("7","start_of_week","1","yes");
INSERT INTO wpcf_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO wpcf_options VALUES("9","use_smilies","1","yes");
INSERT INTO wpcf_options VALUES("10","require_name_email","1","yes");
INSERT INTO wpcf_options VALUES("11","comments_notify","1","yes");
INSERT INTO wpcf_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO wpcf_options VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO wpcf_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO wpcf_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO wpcf_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO wpcf_options VALUES("17","mailserver_port","110","yes");
INSERT INTO wpcf_options VALUES("18","default_category","1","yes");
INSERT INTO wpcf_options VALUES("19","default_comment_status","open","yes");
INSERT INTO wpcf_options VALUES("20","default_ping_status","open","yes");
INSERT INTO wpcf_options VALUES("21","default_pingback_flag","1","yes");
INSERT INTO wpcf_options VALUES("22","posts_per_page","10","yes");
INSERT INTO wpcf_options VALUES("23","date_format","F j, Y","yes");
INSERT INTO wpcf_options VALUES("24","time_format","g:i a","yes");
INSERT INTO wpcf_options VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wpcf_options VALUES("26","comment_moderation","0","yes");
INSERT INTO wpcf_options VALUES("27","moderation_notify","1","yes");
INSERT INTO wpcf_options VALUES("28","permalink_structure","/{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}year{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}/{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}monthnum{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}/{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}day{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}/{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}postname{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}/","yes");
INSERT INTO wpcf_options VALUES("29","rewrite_rules","a:353:{s:7:\"team/?$\";s:29:\"index.php?post_type=employees\";s:37:\"team/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=employees&feed=$matches[1]\";s:32:\"team/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=employees&feed=$matches[1]\";s:24:\"team/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=employees&paged=$matches[1]\";s:12:\"faq-items/?$\";s:23:\"index.php?post_type=faq\";s:42:\"faq-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=faq&feed=$matches[1]\";s:37:\"faq-items/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=faq&feed=$matches[1]\";s:29:\"faq-items/page/([0-9]{1,})/?$\";s:41:\"index.php?post_type=faq&paged=$matches[1]\";s:13:\"news-posts/?$\";s:24:\"index.php?post_type=news\";s:43:\"news-posts/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=news&feed=$matches[1]\";s:38:\"news-posts/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=news&feed=$matches[1]\";s:30:\"news-posts/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=news&paged=$matches[1]\";s:18:\"portfolio-posts/?$\";s:29:\"index.php?post_type=portfolio\";s:48:\"portfolio-posts/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:43:\"portfolio-posts/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:35:\"portfolio-posts/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:9:\"albums/?$\";s:31:\"index.php?post_type=photo_album\";s:39:\"albums/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=photo_album&feed=$matches[1]\";s:34:\"albums/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=photo_album&feed=$matches[1]\";s:26:\"albums/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=photo_album&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:35:\"clients/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"clients/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"clients/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"clients/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"clients/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"clients/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"clients/([^/]+)/embed/?$\";s:40:\"index.php?clients=$matches[1]&embed=true\";s:28:\"clients/([^/]+)/trackback/?$\";s:34:\"index.php?clients=$matches[1]&tb=1\";s:36:\"clients/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?clients=$matches[1]&paged=$matches[2]\";s:43:\"clients/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?clients=$matches[1]&cpage=$matches[2]\";s:32:\"clients/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?clients=$matches[1]&page=$matches[2]\";s:24:\"clients/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"clients/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"clients/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"clients/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"clients/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"clients/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"animated-columns/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"animated-columns/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"animated-columns/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"animated-columns/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"animated-columns/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"animated-columns/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"animated-columns/([^/]+)/embed/?$\";s:49:\"index.php?animated-columns=$matches[1]&embed=true\";s:37:\"animated-columns/([^/]+)/trackback/?$\";s:43:\"index.php?animated-columns=$matches[1]&tb=1\";s:45:\"animated-columns/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?animated-columns=$matches[1]&paged=$matches[2]\";s:52:\"animated-columns/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?animated-columns=$matches[1]&cpage=$matches[2]\";s:41:\"animated-columns/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?animated-columns=$matches[1]&page=$matches[2]\";s:33:\"animated-columns/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"animated-columns/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"animated-columns/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"animated-columns/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"animated-columns/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"animated-columns/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"edge/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"edge/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"edge/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"edge/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"edge/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"edge/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"edge/([^/]+)/embed/?$\";s:37:\"index.php?edge=$matches[1]&embed=true\";s:25:\"edge/([^/]+)/trackback/?$\";s:31:\"index.php?edge=$matches[1]&tb=1\";s:33:\"edge/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?edge=$matches[1]&paged=$matches[2]\";s:40:\"edge/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?edge=$matches[1]&cpage=$matches[2]\";s:29:\"edge/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?edge=$matches[1]&page=$matches[2]\";s:21:\"edge/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"edge/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"edge/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"edge/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"edge/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"edge/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:42:\"index.php?employees=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:36:\"index.php?employees=$matches[1]&tb=1\";s:45:\"team/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?employees=$matches[1]&feed=$matches[2]\";s:40:\"team/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?employees=$matches[1]&feed=$matches[2]\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?employees=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?employees=$matches[1]&cpage=$matches[2]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?employees=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"employees_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?employees_category=$matches[1]&feed=$matches[2]\";s:54:\"employees_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?employees_category=$matches[1]&feed=$matches[2]\";s:35:\"employees_category/([^/]+)/embed/?$\";s:51:\"index.php?employees_category=$matches[1]&embed=true\";s:47:\"employees_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?employees_category=$matches[1]&paged=$matches[2]\";s:29:\"employees_category/([^/]+)/?$\";s:40:\"index.php?employees_category=$matches[1]\";s:37:\"faq-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"faq-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"faq-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"faq-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"faq-items/([^/]+)/embed/?$\";s:36:\"index.php?faq=$matches[1]&embed=true\";s:30:\"faq-items/([^/]+)/trackback/?$\";s:30:\"index.php?faq=$matches[1]&tb=1\";s:50:\"faq-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?faq=$matches[1]&feed=$matches[2]\";s:45:\"faq-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?faq=$matches[1]&feed=$matches[2]\";s:38:\"faq-items/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?faq=$matches[1]&paged=$matches[2]\";s:45:\"faq-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:43:\"index.php?faq=$matches[1]&cpage=$matches[2]\";s:34:\"faq-items/([^/]+)(?:/([0-9]+))?/?$\";s:42:\"index.php?faq=$matches[1]&page=$matches[2]\";s:26:\"faq-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"faq-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"faq-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"faq-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:48:\"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:29:\"faq_category/([^/]+)/embed/?$\";s:45:\"index.php?faq_category=$matches[1]&embed=true\";s:41:\"faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq_category=$matches[1]&paged=$matches[2]\";s:23:\"faq_category/([^/]+)/?$\";s:34:\"index.php?faq_category=$matches[1]\";s:38:\"news-posts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"news-posts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"news-posts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"news-posts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"news-posts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"news-posts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"news-posts/([^/]+)/embed/?$\";s:37:\"index.php?news=$matches[1]&embed=true\";s:31:\"news-posts/([^/]+)/trackback/?$\";s:31:\"index.php?news=$matches[1]&tb=1\";s:51:\"news-posts/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?news=$matches[1]&feed=$matches[2]\";s:46:\"news-posts/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?news=$matches[1]&feed=$matches[2]\";s:39:\"news-posts/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?news=$matches[1]&paged=$matches[2]\";s:46:\"news-posts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?news=$matches[1]&cpage=$matches[2]\";s:35:\"news-posts/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?news=$matches[1]&page=$matches[2]\";s:27:\"news-posts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"news-posts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"news-posts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"news-posts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"news-posts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"news-posts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"news_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?news_category=$matches[1]&feed=$matches[2]\";s:49:\"news_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?news_category=$matches[1]&feed=$matches[2]\";s:30:\"news_category/([^/]+)/embed/?$\";s:46:\"index.php?news_category=$matches[1]&embed=true\";s:42:\"news_category/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?news_category=$matches[1]&paged=$matches[2]\";s:24:\"news_category/([^/]+)/?$\";s:35:\"index.php?news_category=$matches[1]\";s:43:\"portfolio-posts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"portfolio-posts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"portfolio-posts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-posts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-posts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"portfolio-posts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"portfolio-posts/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:36:\"portfolio-posts/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:56:\"portfolio-posts/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-posts/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:44:\"portfolio-posts/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:51:\"portfolio-posts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:40:\"portfolio-posts/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:32:\"portfolio-posts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"portfolio-posts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"portfolio-posts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-posts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-posts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"portfolio-posts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:35:\"pricing/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"pricing/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"pricing/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"pricing/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"pricing/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"pricing/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"pricing/([^/]+)/embed/?$\";s:40:\"index.php?pricing=$matches[1]&embed=true\";s:28:\"pricing/([^/]+)/trackback/?$\";s:34:\"index.php?pricing=$matches[1]&tb=1\";s:36:\"pricing/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?pricing=$matches[1]&paged=$matches[2]\";s:43:\"pricing/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?pricing=$matches[1]&cpage=$matches[2]\";s:32:\"pricing/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?pricing=$matches[1]&page=$matches[2]\";s:24:\"pricing/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"pricing/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"pricing/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"pricing/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"pricing/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"pricing/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"tab_slider/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"tab_slider/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"tab_slider/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tab_slider/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tab_slider/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"tab_slider/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"tab_slider/([^/]+)/embed/?$\";s:43:\"index.php?tab_slider=$matches[1]&embed=true\";s:31:\"tab_slider/([^/]+)/trackback/?$\";s:37:\"index.php?tab_slider=$matches[1]&tb=1\";s:39:\"tab_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?tab_slider=$matches[1]&paged=$matches[2]\";s:46:\"tab_slider/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?tab_slider=$matches[1]&cpage=$matches[2]\";s:35:\"tab_slider/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?tab_slider=$matches[1]&page=$matches[2]\";s:27:\"tab_slider/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"tab_slider/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"tab_slider/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tab_slider/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tab_slider/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"tab_slider/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"testimonial_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial_category=$matches[1]&feed=$matches[2]\";s:56:\"testimonial_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial_category=$matches[1]&feed=$matches[2]\";s:37:\"testimonial_category/([^/]+)/embed/?$\";s:53:\"index.php?testimonial_category=$matches[1]&embed=true\";s:49:\"testimonial_category/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?testimonial_category=$matches[1]&paged=$matches[2]\";s:31:\"testimonial_category/([^/]+)/?$\";s:42:\"index.php?testimonial_category=$matches[1]\";s:34:\"albums/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"albums/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"albums/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"albums/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"albums/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"albums/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"albums/([^/]+)/embed/?$\";s:44:\"index.php?photo_album=$matches[1]&embed=true\";s:27:\"albums/([^/]+)/trackback/?$\";s:38:\"index.php?photo_album=$matches[1]&tb=1\";s:47:\"albums/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?photo_album=$matches[1]&feed=$matches[2]\";s:42:\"albums/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?photo_album=$matches[1]&feed=$matches[2]\";s:35:\"albums/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?photo_album=$matches[1]&paged=$matches[2]\";s:42:\"albums/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?photo_album=$matches[1]&cpage=$matches[2]\";s:31:\"albums/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?photo_album=$matches[1]&page=$matches[2]\";s:23:\"albums/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"albums/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"albums/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"albums/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"albums/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"albums/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"photo_album_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?photo_album_category=$matches[1]&feed=$matches[2]\";s:56:\"photo_album_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?photo_album_category=$matches[1]&feed=$matches[2]\";s:37:\"photo_album_category/([^/]+)/embed/?$\";s:53:\"index.php?photo_album_category=$matches[1]&embed=true\";s:49:\"photo_album_category/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?photo_album_category=$matches[1]&paged=$matches[2]\";s:31:\"photo_album_category/([^/]+)/?$\";s:42:\"index.php?photo_album_category=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:39:\"mkhb_header/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"mkhb_header/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"mkhb_header/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"mkhb_header/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"mkhb_header/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"mkhb_header/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"mkhb_header/([^/]+)/embed/?$\";s:44:\"index.php?mkhb_header=$matches[1]&embed=true\";s:32:\"mkhb_header/([^/]+)/trackback/?$\";s:38:\"index.php?mkhb_header=$matches[1]&tb=1\";s:40:\"mkhb_header/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?mkhb_header=$matches[1]&paged=$matches[2]\";s:47:\"mkhb_header/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?mkhb_header=$matches[1]&cpage=$matches[2]\";s:36:\"mkhb_header/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?mkhb_header=$matches[1]&page=$matches[2]\";s:28:\"mkhb_header/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"mkhb_header/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"mkhb_header/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"mkhb_header/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"mkhb_header/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"mkhb_header/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}","yes");
INSERT INTO wpcf_options VALUES("30","hack_file","0","yes");
INSERT INTO wpcf_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO wpcf_options VALUES("32","moderation_keys","","no");
INSERT INTO wpcf_options VALUES("33","active_plugins","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("34","category_base","","yes");
INSERT INTO wpcf_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wpcf_options VALUES("36","comment_max_links","2","yes");
INSERT INTO wpcf_options VALUES("37","gmt_offset","0","yes");
INSERT INTO wpcf_options VALUES("38","default_email_category","1","yes");
INSERT INTO wpcf_options VALUES("39","recently_edited","","no");
INSERT INTO wpcf_options VALUES("40","template","jupiter","yes");
INSERT INTO wpcf_options VALUES("41","stylesheet","jupiter-child","yes");
INSERT INTO wpcf_options VALUES("42","comment_whitelist","1","yes");
INSERT INTO wpcf_options VALUES("43","blacklist_keys","","no");
INSERT INTO wpcf_options VALUES("44","comment_registration","0","yes");
INSERT INTO wpcf_options VALUES("45","html_type","text/html","yes");
INSERT INTO wpcf_options VALUES("46","use_trackback","0","yes");
INSERT INTO wpcf_options VALUES("47","default_role","subscriber","yes");
INSERT INTO wpcf_options VALUES("48","db_version","38590","yes");
INSERT INTO wpcf_options VALUES("49","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wpcf_options VALUES("50","upload_path","","yes");
INSERT INTO wpcf_options VALUES("51","blog_public","1","yes");
INSERT INTO wpcf_options VALUES("52","default_link_category","2","yes");
INSERT INTO wpcf_options VALUES("53","show_on_front","posts","yes");
INSERT INTO wpcf_options VALUES("54","tag_base","","yes");
INSERT INTO wpcf_options VALUES("55","show_avatars","1","yes");
INSERT INTO wpcf_options VALUES("56","avatar_rating","G","yes");
INSERT INTO wpcf_options VALUES("57","upload_url_path","","yes");
INSERT INTO wpcf_options VALUES("58","thumbnail_size_w","150","yes");
INSERT INTO wpcf_options VALUES("59","thumbnail_size_h","150","yes");
INSERT INTO wpcf_options VALUES("60","thumbnail_crop","1","yes");
INSERT INTO wpcf_options VALUES("61","medium_size_w","300","yes");
INSERT INTO wpcf_options VALUES("62","medium_size_h","300","yes");
INSERT INTO wpcf_options VALUES("63","avatar_default","mystery","yes");
INSERT INTO wpcf_options VALUES("64","large_size_w","1024","yes");
INSERT INTO wpcf_options VALUES("65","large_size_h","1024","yes");
INSERT INTO wpcf_options VALUES("66","image_default_link_type","none","yes");
INSERT INTO wpcf_options VALUES("67","image_default_size","","yes");
INSERT INTO wpcf_options VALUES("68","image_default_align","","yes");
INSERT INTO wpcf_options VALUES("69","close_comments_for_old_posts","0","yes");
INSERT INTO wpcf_options VALUES("70","close_comments_days_old","14","yes");
INSERT INTO wpcf_options VALUES("71","thread_comments","1","yes");
INSERT INTO wpcf_options VALUES("72","thread_comments_depth","5","yes");
INSERT INTO wpcf_options VALUES("73","page_comments","0","yes");
INSERT INTO wpcf_options VALUES("74","comments_per_page","50","yes");
INSERT INTO wpcf_options VALUES("75","default_comments_page","newest","yes");
INSERT INTO wpcf_options VALUES("76","comment_order","asc","yes");
INSERT INTO wpcf_options VALUES("77","sticky_posts","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("78","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("79","widget_text","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("80","widget_rss","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("81","uninstall_plugins","a:0:{}","no");
INSERT INTO wpcf_options VALUES("82","timezone_string","","yes");
INSERT INTO wpcf_options VALUES("83","page_for_posts","0","yes");
INSERT INTO wpcf_options VALUES("84","page_on_front","0","yes");
INSERT INTO wpcf_options VALUES("85","default_post_format","0","yes");
INSERT INTO wpcf_options VALUES("86","link_manager_enabled","0","yes");
INSERT INTO wpcf_options VALUES("87","finished_splitting_shared_terms","1","yes");
INSERT INTO wpcf_options VALUES("88","site_icon","0","yes");
INSERT INTO wpcf_options VALUES("89","medium_large_size_w","768","yes");
INSERT INTO wpcf_options VALUES("90","medium_large_size_h","0","yes");
INSERT INTO wpcf_options VALUES("91","wp_page_for_privacy_policy","3","yes");
INSERT INTO wpcf_options VALUES("92","show_comments_cookies_opt_in","0","yes");
INSERT INTO wpcf_options VALUES("93","initial_db_version","38590","yes");
INSERT INTO wpcf_options VALUES("94","wpcf_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO wpcf_options VALUES("95","fresh_site","1","yes");
INSERT INTO wpcf_options VALUES("96","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("97","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("98","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("99","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("100","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("101","sidebars_widgets","a:19:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}s:9:\"sidebar-9\";a:0:{}s:10:\"sidebar-10\";a:0:{}s:10:\"sidebar-11\";a:0:{}s:10:\"sidebar-12\";a:0:{}s:10:\"sidebar-13\";a:0:{}s:10:\"sidebar-14\";a:0:{}s:10:\"sidebar-15\";a:0:{}s:10:\"sidebar-16\";a:0:{}s:10:\"sidebar-17\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO wpcf_options VALUES("102","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("103","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("104","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("105","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("106","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("107","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("108","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("109","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("110","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("111","cron","a:8:{i:1542383398;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1542385413;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c9059feef497c200e69cb9956a81f005\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5;}}}}i:1542385570;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"686c8315be36c96dc00d0d7ed3656b43\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:6;}}}}i:1542386651;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"d63aca0b7e6237c7964320bd7fc95644\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:7;}}}}i:1542387015;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"60fda3b54003017dc64a0c492471bbfe\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:8;}}}}i:1542419398;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1542462652;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wpcf_options VALUES("112","theme_mods_twentyseventeen","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1542379518;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO wpcf_options VALUES("130","_site_transient_timeout_community-events-6c859e3da379e62d6c7b623bf412e2d8","1542419454","no");
INSERT INTO wpcf_options VALUES("189","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1542379820;s:7:\"checked\";a:5:{s:13:\"jupiter-child\";s:0:\"\";s:7:\"jupiter\";s:5:\"6.1.2\";s:13:\"twentyfifteen\";s:3:\"2.0\";s:15:\"twentyseventeen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","no");
INSERT INTO wpcf_options VALUES("124","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/nl_NL/wordpress-4.9.8.zip\";s:6:\"locale\";s:5:\"nl_NL\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/nl_NL/wordpress-4.9.8.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.8\";s:7:\"version\";s:5:\"4.9.8\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1542379815;s:15:\"version_checked\";s:5:\"4.9.8\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO wpcf_options VALUES("148","_transient_timeout_plugin_slugs","1542465812","no");
INSERT INTO wpcf_options VALUES("146","_transient_is_multi_author","0","yes");
INSERT INTO wpcf_options VALUES("127","_site_transient_timeout_browser_33aa4f9e9e7c043bc50ebd9a38c97fa8","1542981052","no");
INSERT INTO wpcf_options VALUES("128","_site_transient_browser_33aa4f9e9e7c043bc50ebd9a38c97fa8","a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"70.0.3538.102\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no");
INSERT INTO wpcf_options VALUES("143","_site_transient_timeout_theme_roots","1542381615","no");
INSERT INTO wpcf_options VALUES("144","_site_transient_theme_roots","a:7:{s:8:\"__MACOSX\";s:7:\"/themes\";s:13:\"jupiter-child\";s:7:\"/themes\";s:7:\"jupiter\";s:7:\"/themes\";s:5:\"tiwaz\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}","no");
INSERT INTO wpcf_options VALUES("122","WPLANG","nl_NL","yes");
INSERT INTO wpcf_options VALUES("131","_site_transient_community-events-6c859e3da379e62d6c7b623bf412e2d8","a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"86.83.123.0\";}s:6:\"events\";a:5:{i:0;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:57:\"Meetup Haarlem - Voor iedereen die de naam WordPress kent\";s:3:\"url\";s:65:\"https://www.meetup.com/Haarlem-WordPress-Meetup/events/255163751/\";s:6:\"meetup\";s:24:\"Haarlem WordPress Meetup\";s:10:\"meetup_url\";s:48:\"https://www.meetup.com/Haarlem-WordPress-Meetup/\";s:4:\"date\";s:19:\"2018-11-19 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:20:\"Haarlem, Netherlands\";s:7:\"country\";s:2:\"nl\";s:8:\"latitude\";d:52.3968119999999970559656503610312938690185546875;s:9:\"longitude\";d:4.65691100000000002268052412546239793300628662109375;}}i:1;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:41:\"WordPress MeetUp Utrecht 22 november 2018\";s:3:\"url\";s:65:\"https://www.meetup.com/WordPress-Meetup-Utrecht/events/255479563/\";s:6:\"meetup\";s:24:\"WordPress Meetup Utrecht\";s:10:\"meetup_url\";s:48:\"https://www.meetup.com/WordPress-Meetup-Utrecht/\";s:4:\"date\";s:19:\"2018-11-22 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:20:\"Utrecht, Netherlands\";s:7:\"country\";s:2:\"nl\";s:8:\"latitude\";d:52.064255000000002837623469531536102294921875;s:9:\"longitude\";d:5.10852400000000006485834092018194496631622314453125;}}i:2;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:14:\"WordCamp Lille\";s:3:\"url\";s:31:\"https://2018.lille.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2018-12-07 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:5:\"Lille\";s:7:\"country\";s:2:\"FR\";s:8:\"latitude\";d:50.63747289999999878773451200686395168304443359375;s:9:\"longitude\";d:3.060204999999999841975295566953718662261962890625;}}i:3;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:80:\"Wij zijn op zoek naar interessante sprekers, ben / weet jij iemand, let us know!\";s:3:\"url\";s:71:\"https://www.meetup.com/WordPress-Meetup-Heerhugowaard/events/249416398/\";s:6:\"meetup\";s:30:\"WordPress Meetup Heerhugowaard\";s:10:\"meetup_url\";s:54:\"https://www.meetup.com/WordPress-Meetup-Heerhugowaard/\";s:4:\"date\";s:19:\"2018-12-12 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:26:\"Heerhugowaard, Netherlands\";s:7:\"country\";s:2:\"nl\";s:8:\"latitude\";d:52.6681439999999980727807269431650638580322265625;s:9:\"longitude\";d:4.82080600000000014659917724202387034893035888671875;}}i:4;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:77:\"Hoe maak je je website toegankelijk en hoe gebruik je Advanced Custom Fields?\";s:3:\"url\";s:64:\"https://www.meetup.com/Leiden-WordPress-Meetup/events/254812707/\";s:6:\"meetup\";s:23:\"Leiden WordPress Meetup\";s:10:\"meetup_url\";s:47:\"https://www.meetup.com/Leiden-WordPress-Meetup/\";s:4:\"date\";s:19:\"2018-12-12 19:15:00\";s:8:\"location\";a:4:{s:8:\"location\";s:23:\"Leiderdorp, Netherlands\";s:7:\"country\";s:2:\"nl\";s:8:\"latitude\";d:52.1651200000000017098500393331050872802734375;s:9:\"longitude\";d:4.517464000000000368117980542592704296112060546875;}}}}","no");
INSERT INTO wpcf_options VALUES("132","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1542419455","no");
INSERT INTO wpcf_options VALUES("133","_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Nov 2018 01:11:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-beta5-43907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/11/wordpress-5-0-beta-5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 16 Nov 2018 01:09:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6250\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"WordPress 5.0 Beta 5 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test this WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4738:\"\n<p>WordPress 5.0 Beta 5 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>There are two ways to test this WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta5.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p><strong>Reminder: the WordPress 5.0 release date has changed</strong>. It is now scheduled for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 27</a>, and we need your help to get there. Here are some of the big issues that we’ve fixed since Beta 4:</p>\n\n\n\n<h2>Block Editor</h2>\n\n\n\n<p>The block editor has been updated to match the <a href=\"https://make.wordpress.org/core/2018/11/15/whats-new-in-gutenberg-15th-november-2/\">Gutenberg 4.4 release</a>, the major changes  include:</p>\n\n\n\n<ul><li>&nbsp;A <a href=\"https://github.com/WordPress/gutenberg/pull/11874\">permalink panel has been added to the document sidebar</a> to make it easier to find.</li><li>Editor document panels can now be <a href=\"https://github.com/WordPress/gutenberg/pull/11802\">programmatically removed</a>.</li><li>The uploading indicator for images and galleries has been replaced with a&nbsp;<a href=\"https://github.com/WordPress/gutenberg/pull/11876\">spinner and faded out image</a>.</li><li>The text and code editing blocks will now <a href=\"https://github.com/WordPress/gutenberg/pull/11750\">use the full width of the editor</a>.</li><li>Image handling has been improved. Images now  take up the right amount of space for <a href=\"https://github.com/WordPress/gutenberg/pull/11846\">themes with wider editors</a> (like Twenty Nineteen).<br></li><li>Hover styles are now <a href=\"https://github.com/WordPress/gutenberg/pull/10333\">correctly disabled for mobile devices</a>.</li><li>The i18n module has been refactored to benefit from <a href=\"https://github.com/WordPress/gutenberg/pull/11493\">significant performance gains</a>.</li></ul>\n\n\n\n<p>Additionally, there have been some pesky bugs fixed:</p>\n\n\n\n<ul><li>Better handling for <a href=\"https://github.com/WordPress/gutenberg/pull/11590\">links without an href</a> attribute, which were showing as <code>undefined</code>.</li><li>Japanese text (double byte characters) are <a href=\"https://github.com/WordPress/gutenberg/pull/11908\">now usable in the list block</a>.</li><li>Better handling for different text encodings (e.g. emoji) within a block <a href=\"https://github.com/WordPress/gutenberg/pull/11771\">in block validation</a>.</li></ul>\n\n\n\n<p>A full list of changes can be found in the <a href=\"https://make.wordpress.org/core/2018/11/15/whats-new-in-gutenberg-15th-november-2/\">Gutenberg 4.4 release post</a>.<br></p>\n\n\n\n<h2>PHP 7.3 Support</h2>\n\n\n\n<p>The final known PHP 7.3 compatibility issue has been fixed. You can brush up on what you need to know about PHP 7.3 and WordPress by checking out the <a href=\"https://make.wordpress.org/core/2018/10/15/wordpress-and-php-7-3/\">developer note on the Make WordPress Core blog</a>.<br></p>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>Work on making Twenty Nineteen ready for prime time continues on its <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>. This update includes <a href=\"https://core.trac.wordpress.org/changeset/43904\">a host of tweaks and bug fixes</a>, including:</p>\n\n\n\n<ul><li>Add <code>.button</code> class support.</li><li>Fix editor font-weights for headings.</li><li>Improve support for sticky toolbars in the editor.</li><li>Improve text-selection custom colors for better contrast and legibility.</li><li>Fix editor to prevent Gutenberg&#8217;s meta boxes area from overlapping the content.</li></ul>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;</p>\n\n\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6250\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/11/wordpress-5-0-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 Nov 2018 01:27:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6241\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"WordPress 5.0 Beta 4 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test the WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3700:\"\n<p>WordPress 5.0 Beta 4 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta4.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p><strong>The WordPress 5.0 release date has changed</strong>, it is now scheduled for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 27</a>, and we need your help to get there. Here are some of the big issues that we’ve fixed since Beta 3:</p>\n\n\n\n<h2>Block Editor</h2>\n\n\n\n<p>The block editor has been updated to match the <a href=\"https://make.wordpress.org/core/2018/11/12/whats-new-in-gutenberg-12th-november/\">Gutenberg 4.3 release</a>, the major changes  include:</p>\n\n\n\n<ul><li>An <a href=\"https://github.com/WordPress/gutenberg/pull/7718\">Annotations API</a>, allowing plugins to add  contextual data as you write.</li><li>More consistent keyboard navigation between blocks, as well as back-and-forth between different areas of the interface.</li><li>Improved accessibility, with additional  labelling and speech announcements.</li></ul>\n\n\n\n<p>Additionally, there have been some bugs fixed that popped up in beta 3:</p>\n\n\n\n<ul><li>Better support for plugins that have more advanced meta box usage.</li><li>Script concatenation is now supported.</li><li>Ajax calls could occasionally cause PHP errors.</li></ul>\n\n\n\n<h2>Internationalisation</h2>\n\n\n\n<p>We&#8217;ve added an API for translating your plugin and theme strings in JavaScript files! The block editor is now using this, and you can start using it, too. Check out the <a href=\"https://make.wordpress.org/core/2018/11/09/new-javascript-i18n-support-in-wordpress/\">developer note</a>&nbsp;to get started.</p>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>Twenty Nineteen is being polished over on its <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>. This update includes <a href=\"https://core.trac.wordpress.org/changeset/43892\">a host of tweaks and bug fixes</a>, including:</p>\n\n\n\n<ul><li>Menus now  properly support keyboard and touch interactions.</li><li>A footer menu has been added for secondary page links.</li><li>Improved backwards compatibility with older versions of WordPress.</li></ul>\n\n\n\n<h2>Default Themes</h2>\n\n\n\n<p>All of the older default themes—from Twenty Ten through to Twenty Seventeen—have polished  styling in the block editor.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English?&nbsp;<a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a>&nbsp;</p>\n\n\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>International-<br>isation is a word with<br>many syllables.</em></p>\n\n\n\n<p><em>Meta boxes are<br>the original style block.<br>Old is new again.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6241\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/11/wordpress-5-0-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2018 00:20:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6236\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"WordPress 5.0 Beta 3 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test the WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3198:\"\n<p>WordPress 5.0 Beta 3 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta3.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big issues that we&#8217;ve fixed since Beta 2:</p>\n\n\n\n<h2>Block Editor</h2>\n\n\n\n<p>The block editor has been updated to include all of the features and bug fixes from the upcoming <a href=\"https://make.wordpress.org/core/2018/10/31/whats-new-in-gutenberg-31st-october-2/\">Gutenberg 4.2 release</a>. Additionally, there are some newer bug fixes and features, such as:</p>\n\n\n\n<ul><li>Adding support for the &#8220;Custom Fields&#8221; meta box.</li><li>Improving the reliability of REST API requests.</li><li>A myriad of minor tweaks and improvements.</li></ul>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>Twenty Nineteen has been updated from its <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>, this version is full of new goodies to check out:</p>\n\n\n\n<ul><li>Adds support for Selective Refresh Widgets in the Customiser.</li><li>Adds support for Responsive Embeds.</li><li>Tweaks to improve readability and functionality on mobile devices.</li><li>Fixes nested blocks appearing wider than they should be.</li><li>Fixes some errors in older PHP versions, and in IE11.</li></ul>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> </p>\n\n\n\n<p>If you&#8217;re able to contribute with coding or testing changes, we have <a href=\"https://make.wordpress.org/core/2018/11/02/upcoming-5-0-bug-scrubs/\">a multitude of bug scrubs</a> scheduled this week, we&#8217;d love to have as many people as we can ensuring all bugs reported get the attention they deserve.</p>\n\n\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>WordPress Five Point Oh<br>is just two short weeks away.<br>Thank you for helping!</em> <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f496.png\" alt=\"💖\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><em><br></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6236\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Quarterly Updates | Q3 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/11/quarterly-updates-q3-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Nov 2018 16:46:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6206\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s listed representatives. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:14629:\"\n<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.</em></p>\n\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/audrasjb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>audrasjb</a>, <a href=\'https://profiles.wordpress.org/arush/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>arush</a></li>\n<li><strong>Priority</strong>: Work on authoring a manual for assistive technology users on Gutenberg, led by Claire Brotherton (<a href=\'https://profiles.wordpress.org/abrightclearweb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>abrightclearweb</a>). Continue to work on improving the overall user experience in Gutenberg. Update and organize the WP A11y handbook.</li>\n<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. Still over 100 outstanding issues, and developing the Gutenberg AT manual helps expose additional issues. The announcement of an accessibility focus on 4.9.9 derailed our planning for Gutenberg in September with minimal productivity, as that goal was quickly withdrawn from the schedule.</li>\n<li><strong>Big Win</strong>: Getting focus constraint implemented in popovers and similar components in Gutenberg.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: @danielbachhuber, <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a></li>\n<li><strong>Priority</strong>: Current priority is v2.1.0 of WP-CLI, to polish the major refactoring v2.0.0 introduced. You can <a href=\"https://make.wordpress.org/cli/good-first-issues/\">join in or follow progress</a> on their site.</li>\n<li><strong>Struggle</strong>: Getting enough contributors to make peer-review possible/manageable.</li>\n<li><strong>Big Win</strong>: The major refactoring of v2 was mostly without any negative impacts on existing installs. It provided substantial improvements to maintainability including: faster and more reliable testing, more straight-forward changes to individual packages, and simpler contributor on-boarding.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/hlashbrooke/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hlashbrooke</a></li>\n<li><strong>Priority</strong>: Supporting contributors of all levels via: monthly <a href=\"https://make.wordpress.org/community/2018/10/08/announcement-monthly-chat-for-wordcamp-organisers/\">WordCamp Organizers chat</a>, better onboarding with a translated <a href=\"https://make.wordpress.org/community/2017/08/11/global-community-team-welcome-pack/\">welcome pack</a>, and Contribution Drive documentation.</li>\n<li><strong>Struggle</strong>: Fewer contributors than usual.</li>\n<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/community/2018/09/21/meetup-application-vetting-sprint-26-27-september/\">Meetup Vetting Sprint</a>! </li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a></li>\n<li><strong>Priority</strong>: Continued preparation for the 5.0 release cycle and Gutenberg.</li>\n<li><strong>Struggle</strong>: Identifying tasks for first time contributors, as well as for new-to-JS contributors.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/boemedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>boemedia</a>, <a href=\'https://profiles.wordpress.org/joshuawold/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joshuawold</a>, <a href=\'https://profiles.wordpress.org/mizejewski/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mizejewski</a></li>\n<li><strong>Priority</strong>: Preparing for WordPress 5.0 and continuing to work on better onboarding practices.</li>\n<li><strong>Struggle</strong>: Identifying tasks for contributor days, especially for small- to medium-sized tasks that can be fit into a single day.</li>\n<li><strong>Big Win</strong>: Regular contributions are starting to build up.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/kenshino/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kenshino</a></li>\n<li><strong>Priority</strong>: Getting HelpHub out before WordPress 5.0&#8217;s launch to make sure Gutenberg User Docs have a permanent position to reside</li>\n<li><strong>Struggle</strong>: Getting the documentation from HelpHub into WordPress.org/support is more manual than initially anticipated.</li>\n<li><strong>Big Win</strong>: Had a good discussion with the Gutenberg team about their docs and how WordPress.org expects documentation to be distributed (via DevHub, Make and HelpHub). Getting past the code blocks to release HelpHub (soon)</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/mikeschroder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mikeschroder</a>, <a href=\'https://profiles.wordpress.org/jadonn/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jadonn</a></li>\n<li><strong>Priority</strong>: Helping Gutenberg land well at hosts for users in 5.0.</li>\n<li><strong>Struggle</strong>: Short time frame with few resources to accomplish priority items.</li>\n<li><strong>Big Win</strong>: Preparing Try Gutenberg support guide for hosts during the rollout and good reception from users following it.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bridgetwillard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bridgetwillard</a></li>\n<li><strong>Priority</strong>: Continuing to write and publish case studies from the community.</li>\n<li><strong>Big Win</strong>: Onboarding guide is going well and is currently being <a href=\"https://translate.wordpress.org/projects/meta/get-involved\">translated</a>.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/tellyworth/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tellyworth</a>, <a href=\'https://profiles.wordpress.org/coffee2code/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>coffee2code</a></li>\n<li><strong>Priority</strong>: Support for other teams in the lead up to, and the follow-up of, the release of WP 5.0. ETA is the WP 5.0 release date (Nov 19) and thereafter, unless it gets bumped to next quarter.</li>\n<li><strong>Struggle</strong>: Maintaining momentum on tickets (still).</li>\n<li><strong>Big Win</strong>: Launch of front-end demo of Gutenberg on https://wordpress.org/gutenberg/</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/elibud/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>elibud</a></li>\n<li><strong>Priority</strong>: Have an alpha version of Gutenberg in the WordPress apps, ETA end of year 2018.</li>\n<li><strong>Struggle</strong>: Unfamiliar tech stack and the goal of reusing as much of Gutenberg-web&#8217;s code as possible.</li>\n<li><strong>Big Win</strong>: Running mobile tests on web&#8217;s PRs.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/ipstenu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ipstenu</a></li>\n<li><strong>Priority</strong>: Cleaning up &#8216;inactive&#8217; users, which was supposed to be complete but some work preparing for 5.0 was necessary.</li>\n<li><strong>Struggles</strong>: Devnotes are lacking for the upcoming release which slows progress.</li>\n<li><strong>Big Win</strong>: No backlog even though a lot were out!</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/petya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>petya</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a>, <a href=\'https://profiles.wordpress.org/chantalc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chantalc</a>, <a href=\'https://profiles.wordpress.org/deconf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>deconf</a>, <a href=\'https://profiles.wordpress.org/casiepa/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>casiepa</a></li>\n<li><strong>Priority</strong>: Help re-activating inactive locale teams.</li>\n<li><strong>Struggle</strong>: Many GTEs are having a hard time keeping up with incoming translation <a href=\"https://make.wordpress.org/polyglots/?resolved=unresolved&amp;tags=editor-requests\">validation and PTE requests</a>.</li>\n<li><strong>Big Win</strong>: Made some progress in locale research and reassigning new GTEs.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/clorith/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clorith</a></li>\n<li><strong>Priority:</strong> Preparing for the upcoming 5.0 release</li>\n<li><strong>Struggle</strong>: Finding a good balance between how much we want to help people and how much we are able to help people. Also, contributor recruitment (always a crowd favorite!)</li>\n<li><strong>Big Win</strong>: How well the team, on a global level, has managed to maintain a good flow of user engagement through support.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/acosmin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>acosmin</a>, <a href=\'https://profiles.wordpress.org/rabmalin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rabmalin</a>, <a href=\'https://profiles.wordpress.org/thinkupthemes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thinkupthemes</a>, <a href=\'https://profiles.wordpress.org/williampatton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>williampatton</a></li>\n<li><strong>Priority</strong>: Implementing the Theme Sniffer plugin on WordPress.org which is one step forward towards automation. ETA early 2019</li>\n<li><strong>Struggle</strong>: Not having so many contributors/reviewers.</li>\n<li><strong>Big Win</strong>: Implementing <a href=\"https://make.wordpress.org/themes/2018/10/25/new-requirements/\">multiple requirements</a> into our review flow, like screenshots and readme.txt requirements.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<p><!-- /wp:list --><!-- wp:heading --></p>\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n<p><!-- /wp:heading --><!-- wp:list --></p>\n<ul>\n<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bethsoderberg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bethsoderberg</a>, <a href=\'https://profiles.wordpress.org/juliek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>juliek</a></li>\n<li><strong>Priority:</strong> Getting the learn.wordpress.org site designed, developed, and being able to publish lesson plans to it.</li>\n<li><strong>Struggle:</strong> Getting contributors onboard and continually contributing. Part of that is related to the learn.wordpress.org site. People like to see their contributions.</li>\n<li><strong>Big Win</strong>: We have our new workflow and tools in place. We are also streamlining that process to help things go from idea to publication more quickly.</li>\n</ul>\n<p><!-- /wp:list --><!-- wp:paragraph --></p>\n<p><em>Interested in updates from the last quarter? You can find those here: <a href=\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\">https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/</a></em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6206\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"The Month in WordPress: October 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/11/the-month-in-wordpress-october-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Nov 2018 08:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6230\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:331:\"Teams across the WordPress project are working hard to make sure everything is ready for the upcoming release of WordPress 5.0. Find out what’s going on and how you can get involved. The Plan for WordPress 5.0 Early this month, the planned release schedule was announced for WordPress 5.0, which was updated a few weeks [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8116:\"\n<p>Teams across the WordPress project are working hard to make sure everything is ready for the upcoming release of WordPress 5.0. Find out what’s going on and how you can get involved.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>The Plan for WordPress 5.0</h2>\n\n\n\n<p>Early this month, <a href=\"https://make.wordpress.org/core/2018/10/03/proposed-wordpress-5-0-scope-and-schedule/\">the planned release schedule was announced</a> for WordPress 5.0, which was <a href=\"https://make.wordpress.org/core/2018/10/31/wordpress-5-0-schedule-updates/\">updated</a> a few weeks later. WordPress 5.0 is a highly anticipated release, as it’s the official &nbsp;launch of Gutenberg &#8212; the new block editor for WordPress Core. For more detail, check out this <a href=\"https://make.wordpress.org/core/2018/10/12/granular-timeline/\">&nbsp;granular timeline</a>.<br></p>\n\n\n\n<p>Along with the planned release schedule, <a href=\'https://profiles.wordpress.org/matt/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>matt</a>, who is heading up this release, <a href=\"https://make.wordpress.org/core/2018/10/03/a-plan-for-5-0/\">announced leads for critical focuses on the project</a>, including <a href=\'https://profiles.wordpress.org/matveb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>matveb</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/laurelfulford/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>laurelfulford</a>, <a href=\'https://profiles.wordpress.org/allancole/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>allancole</a>, <a href=\'https://profiles.wordpress.org/lonelyvegan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>lonelyvegan</a>, <a href=\'https://profiles.wordpress.org/omarreiss/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>omarreiss</a>, <a href=\'https://profiles.wordpress.org/antpb/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>antpb</a>, <a href=\'https://profiles.wordpress.org/pento/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>pento</a>, <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, <a href=\'https://profiles.wordpress.org/danielbachhuber/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>danielbachhuber</a>, and <a href=\'https://profiles.wordpress.org/mcsf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mcsf</a>.<br></p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-2/\">WordPress 5.0 is currently in its second beta phase</a> and will soon move to the release candidate status. Help test this release right now by installing the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester plugin</a> on your site.<br></p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. You can also help out by <a href=\"https://make.wordpress.org/test/\">testing</a> or <a href=\"https://make.wordpress.org/polyglots/2018/10/24/wordpress-5-0-gutenberg-and-twenty-nineteen/\">translating</a> the release into a local language.</p>\n\n\n\n<h2>New Editor for WordPress Core</h2>\n\n\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/10/31/whats-new-in-gutenberg-31st-october-2/\">The latest release</a> is feature complete, meaning that all further development on it will be to improve existing features and fix outstanding bugs.<br></p>\n\n\n\n<p>Some have raised concerns about Gutenberg’s accessibility, prompting the development team <a href=\"https://make.wordpress.org/core/2018/10/18/regarding-accessibility-in-gutenberg/\">to detail some areas</a> in which the new editor is accessible. To help improve things further, the team has made <a href=\"https://make.wordpress.org/core/2018/10/19/call-for-testers-community-gutenberg-accessibility-tests/\">a public call for accessibility testers</a> to assist.<br></p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg\">the Gutenberg tag</a> on the Core team blog and join the #core-editor channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>. Read <a href=\"https://make.wordpress.org/test/2018/10/19/gutenberg-needs-testing-areas/\">this guide</a> to find areas where you can have the most impact.</p>\n\n\n\n<h2>Migrating HelpHub to WordPress.org</h2>\n\n\n\n<p>HelpHub is an ongoing project to move all of WordPress’ user documentation from the <a href=\"https://codex.wordpress.org/\">Codex</a> to the <a href=\"https://wordpress.org/support/\">WordPress Support portal</a>.<br></p>\n\n\n\n<p>HelpHub has been developed on <a href=\"https://wp-helphub.com/\">a separate staging server</a> and it’s now time to migrate the new documentation to its home on WordPress.org. The plan is to have everything moved over &nbsp;before WordPress 5.0 is released, so that all the new documentation will be available on the new platform from the start.<br></p>\n\n\n\n<p>The HelpHub team has published <a href=\"https://make.wordpress.org/docs/2018/11/01/call-for-volunteers-helphub-migration/\">a call for volunteers</a> to help with the migration. If you would like to get involved, join the #docs channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>, and contact <a href=\'https://profiles.wordpress.org/atachibana/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>atachibana</a> to get started.</p>\n\n\n\n<h2>A New Default Theme for WordPress</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">A brand new default theme &#8212; Twenty Nineteen &#8212; has been announced</a>&nbsp;with development being led by <a href=\'https://profiles.wordpress.org/allancole/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>allancole</a>. The theme is packaged with WordPress 5.0, so it will be following the same release schedule as Core.<br></p>\n\n\n\n<p>The new theme is designed to integrate seamlessly with Gutenberg and showcase how you can build a theme alongside the new block editor and take advantage of the creative freedom that it offers.<br></p>\n\n\n\n<p>Want to help build Twenty Nineteen? Join in on <a href=\"https://github.com/WordPress/twentynineteen\">the theme’s GitHub repo</a> and join the #core-themes channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.<br></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>The Support team are putting together more formal <a href=\"https://github.com/Clorith/wporg-support-guidelines\">Support Guidelines</a> for the WordPress Support Forums.</li><li>The group focused on privacy tools in Core <a href=\"https://make.wordpress.org/core/2018/10/11/whats-new-in-core-privacy/\">has released some details</a> on the work they have been doing recently, with a roadmap for their plans over the next few months.</li><li>The Core team <a href=\"https://make.wordpress.org/core/2018/10/15/wordpress-and-php-7-3/\">released an update</a> about how WordPress will be compatible with PHP 7.3.</li><li>The Theme Review Team have published <a href=\"https://make.wordpress.org/themes/2018/10/25/new-requirements/\">some new requirements</a> regarding child themes, readme files and trusted authors in the Theme Directory.</li><li>The WordCamp Europe team <a href=\"https://make.wordpress.org/community/2018/10/23/progressive-web-app-for-wordcamps/\">are working on a PWA service</a> for all WordCamp websites.</li></ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6230\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Oct 2018 05:04:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6222\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:359:\"WordPress 5.0 Beta 2 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version. There are two ways to test the WordPress 5.0 Beta: try the&#160;WordPress Beta Tester&#160;plugin (you’ll want “bleeding edge nightlies”), or [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2228:\"\n<p>WordPress 5.0 Beta 2 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version.</p>\n\n\n\n<p>There are two ways to test the WordPress 5.0 Beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta2.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big issues that we fixed since Beta 1:</p>\n\n\n\n<h2>Block Editor</h2>\n\n\n\n<p>We&#8217;ve updated to the latest version of the block editor from the Gutenberg plugin, which includes the new <a href=\"https://github.com/WordPress/gutenberg/pull/10209\">Format API</a>, embedding improvements, and <a href=\"https://github.com/WordPress/gutenberg/milestone/71\">a variety of bug fixes</a>.</p>\n\n\n\n<p>Meta boxes had a few bugs, and they weren&#8217;t showing at all in the block editor, so we&#8217;ve fixed and polished there.</p>\n\n\n\n<h2>Internationalisation</h2>\n\n\n\n<p>We&#8217;ve added support for <a href=\"https://core.trac.wordpress.org/ticket/45103\">registering and loading JavaScript translation files</a>.</p>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>The <a href=\"https://github.com/WordPress/twentynineteen\">Twenty Nineteen repository</a> is a hive of activity, there have been a stack of minor bugs clean up, and some notable additions:</p>\n\n\n\n<ul><li>There&#8217;s now a widget area in the page footer.</li><li>Navigation submenus have been implemented for mobile devices.</li><li>Customiser options have been added for changing the theme colours and feature image filters.</li></ul>\n\n\n\n<h2>Everything Else</h2>\n\n\n\n<p>The REST API has a couple of bug fixes and performance improvements. PHP 7.3 compatibility has been improved.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>We&#8217;re fixing the bugs:<br>All the ones you&#8217;ve reported.<br>Some that we&#8217;ve found, too.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6222\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.0 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2018/10/wordpress-5-0-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Oct 2018 21:59:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"5.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6209\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:312:\"WordPress 5.0 Beta 1 is now available! This software is still in development,&#160;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version, and if you are using an existing test site be sure to update the Gutenberg plugin to v4.1. There are [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Gary Pendergast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3734:\"\n<p>WordPress 5.0 Beta 1 is now available!</p>\n\n\n\n<p><strong>This software is still in development,</strong>&nbsp;so we don’t recommend you run it on a production site. Consider setting up a test site to play with the new version, and if you are using an existing test site be sure to update the Gutenberg plugin to v4.1. </p>\n\n\n\n<p>There are two ways to test the WordPress 5.0 beta: try the&nbsp;<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a>&nbsp;plugin (you’ll want “bleeding edge nightlies”), or you can&nbsp;<a href=\"https://wordpress.org/wordpress-5.0-beta1.zip\">download the beta here</a>&nbsp;(zip).</p>\n\n\n\n<p>WordPress 5.0 is slated for release on&nbsp;<a href=\"https://make.wordpress.org/core/5-0/\">November 19</a>, and we need your help to get there. Here are some of the big items to test so we can find as many bugs as possible in the coming weeks.</p>\n\n\n\n<h2>The Block Editor</h2>\n\n\n\n<p>The new Gutenberg block editor is now the default post editor!</p>\n\n\n\n<p>The block editor provides a modern, media-rich editing experience. You can create flexible, beautiful content without writing a single line of code, or you can dive into the <a href=\"https://wordpress.org/gutenberg/handbook/\">modern programming APIs</a> that the block editor provides.</p>\n\n\n\n<p>Even before you install WordPress 5.0, you can <a href=\"https://wordpress.org/gutenberg/\">try the block editor here</a>.</p>\n\n\n\n<p>Of course, we recognise you might not be ready for this change quite yet. If that&#8217;s the case, you can install the <a href=\"https://wordpress.org/plugins/classic-editor/\">Classic Editor plugin</a> now, which will keep the editor you&#8217;re familiar with as the default, even after you upgrade to WordPress 5.0.</p>\n\n\n\n<h2>Twenty Nineteen</h2>\n\n\n\n<p>Along with the new block editor, we have a new default theme, called Twenty Nineteen, which takes advantage of the new features the block editor provides.</p>\n\n\n\n<p>You can read more about Twenty Nineteen in its <a href=\"https://make.wordpress.org/core/2018/10/16/introducing-twenty-nineteen/\">introduction post</a>, and follow along with development over on the <a href=\"https://github.com/WordPress/twentynineteen\">GitHub repository</a>.</p>\n\n\n\n<h2>Default Themes</h2>\n\n\n\n<p>Of course, we couldn&#8217;t release a beautiful new default theme, and leave all of our old ones behind. All the way back to Twenty Ten, we&#8217;ve updated every default them to look good in the new block editor.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> <strong>A known issue</strong>: the block autocompleter fails for blocks whose names contain  characters in non-Latin scripts. Adding blocks via the plus sign works, and this bug is fixed in the Gutenberg 4.1 plugin. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p><strong><em>If you think you’ve found a bug</em></strong><em>, you can post to the&nbsp;</em><a href=\"https://wordpress.org/support/forum/alphabeta\"><em>Alpha/Beta area</em></a><em>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;</em><a href=\"https://make.wordpress.org/core/reports/\"><em>file one on WordPress Trac</em></a><em>, where you can also find&nbsp;</em><a href=\"https://core.trac.wordpress.org/tickets/major\"><em>a list of known bugs</em></a><em>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>Minor bug fixes<br>Add up one by one by one<br>Then you change the world</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6209\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"The Month in WordPress: September 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wordpress.org/news/2018/10/the-month-in-wordpress-september-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 01 Oct 2018 12:01:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6203\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"The new WordPress editor continues to be a major focus for all WordPress contribution teams. Read on to find out some more about their work, as well as everything else that has been happening around the community this past month. Further Enhancements to the New WordPress Editor Active development continues on Gutenberg, the new editing [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4632:\"\n<p>The new WordPress editor continues to be a major focus for all WordPress contribution teams. Read on to find out some more about their work, as well as everything else that has been happening around the community this past month.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Enhancements to the New WordPress Editor</h2>\n\n\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/09/21/whats-new-in-gutenberg/\">The latest update for the editor</a> includes great new features, such as reusable content blocks, a dark editor style, export and import of templates, and much more. In addition, the Gutenberg team has published <a href=\"https://make.wordpress.org/core/2018/09/26/an-update-on-gutenberg-tasks/\">a comprehensive guide</a> to the features currently included in the editor.<br /></p>\n\n\n\n<p>Users can test Gutenberg right now by installing <a href=\"https://wordpress.org/plugins/gutenberg/\">the plugin</a>, which currently has over 450,000 active installs according to the new <a href=\"https://gutenstats.blog/\">Gutenberg in Numbers</a> site. Along with that, <a href=\"https://wordpress.org/gutenberg/handbook/reference/faq/\">the Gutenberg Handbook</a> has some very useful information about how to use and develop for the new editor.<br /></p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">the #gutenberg tag on the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Work Begins on WordPress 5.0</h2>\n\n\n\n<p>After initially announcing a minor v4.9.9 release, <a href=\"https://make.wordpress.org/core/2018/09/28/dev-chat-summary-september-26th-4-9-9-week-7/\">the Core team has shifted their focus to the next major release</a> — v5.0. One of the primary factors for this change is that Gutenberg is nearly ready to be considered for merging into Core, with the goal to complete the merge in v5.0.<br /></p>\n\n\n\n<p>To maintain flexibility in the development process the final timelines are not yet determined, allowing work already done for v4.9.9 to be moved to v5.0 if needed. Ensuring that WordPress is compatible with the upcoming PHP 7.3 release is a high priority for the Core team. Once a final decision is made, the details will be announced on <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>.<br /></p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow the Core team blog and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.<br /></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>The Community Team has some great updates on <a href=\"https://make.wordpress.org/community/2018/09/25/wordcamp-incubator-2018-update-thread-september-edition/\">the progress of the current WordCamp Incubator Program</a>.</li><li>A team inside the Drupal community <a href=\"https://drupalgutenberg.org/\">is working on integrating Gutenberg into their CMS</a>.</li><li>There is a current discussion among community organizers about <a href=\"https://make.wordpress.org/community/2018/09/17/proposal-to-increase-the-maximum-ticket-price-for-wordcamps/\">plans to increase the maximum ticket price for WordCamps</a>.</li><li>The Mobile Team <a href=\"https://make.wordpress.org/updates/2018/09/25/mobile-team-update-september-25th/\">is looking for people</a> to grow the beta program for testing the iOS and Android mobile apps.</li><li>The Diversity Outreach Speaker Training group <a href=\"https://make.wordpress.org/community/2018/09/13/input-requested-building-a-diverse-speaker-roster-document/\">is looking for feedback</a> on their document to assist WordPress Meetups and WordCamps in building diverse speaker rosters.</li><li>The Theme Team <a href=\"https://make.wordpress.org/themes/2018/09/26/new-requirement-regarding-affiliate-links/\">has updated their rules</a> regarding sponsored and affiliate links inside themes added to the Theme Directory.</li><li>Meetup organizers <a href=\"https://make.wordpress.org/community/2018/09/25/meetup-organiser-badge-assignments/\">are now able to receive a WordPress.org profile badge</a> for their community work.</li></ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em><br /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6203\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"The Month in WordPress: August 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2018/09/the-month-in-wordpress-august-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Sep 2018 11:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6191\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:355:\"Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August. WordPress 4.9.8 is Released WordPress 4.9.8 was [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5589:\"\n<p>Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 4.9.8 is Released</h2>\n\n\n\n<p><a href=\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\">WordPress 4.9.8 was released</a> at the beginning of the month. While this was a maintenance release fixing 46 bugs, it was significant for Core development because it made a point of highlighting Gutenberg — the new WordPress editor that is currently in development (more on that below).<br /></p>\n\n\n\n<p>This release also included some important updates to the privacy tools that were added to Core earlier this year.<br /></p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n\n\n<h2>New WordPress Editor Development Continues</h2>\n\n\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/08/31/whats-new-in-gutenberg-31st-august/\">The latest version</a> features a number of important user experience improvements, including a new unified toolbar and support for a more focussed writing mode.<br /></p>\n\n\n\n<p>Users can test Gutenberg right now by installing <a href=\"https://wordpress.org/plugins/gutenberg/\">the plugin</a>, which currently has nearly 300,000 active installs. Along with that, <a href=\"https://wordpress.org/gutenberg/handbook/reference/faq/\">the Gutenberg Handbook</a> has some very useful information about how to use and develop for the new editor.<br /></p>\n\n\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">the #gutenberg tag on the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Planning Begins for the Next Global WordPress Translation Day</h2>\n\n\n\n<p>The Global WordPress Translation Day is a 24-hour event held online and all across the world. It is designed to bring communities together to translate WordPress into their local languages, and to help them connect with other communities doing the same thing.<br /></p>\n\n\n\n<p>There have been three Translation Days since April 2016, and <a href=\"https://make.wordpress.org/polyglots/2018/08/29/global-wordpress-translation-day-4-preliminary-planning/\">the fourth edition is in the planning stages now</a>. The Polyglots team, who organizes these events, is currently looking for input on the date, format, and content for the event and would love some feedback from the community.<br /></p>\n\n\n\n<p>Want to get involved in translating WordPress into your own language? Follow <a href=\"https://make.wordpress.org/polyglots/\">the Polyglots team blog</a> and join the #polyglots channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.<br /></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li><a href=\"https://wordpress.org/support/upgrade-php/\">The Update PHP page on WordPress.org</a> has been revised and improved to make the reasons for upgrading more clear.</li><li>The Mobile team is looking for people to help test the latest versions of the <a href=\"https://make.wordpress.org/mobile/2018/08/29/call-for-testing-wordpress-for-android-10-8/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2018/08/28/call-for-testing-wordpress-for-ios-10-8/\">iOS</a> apps for WordPress.</li><li><a href=\"https://wordbits.io/\">WordBits</a> is a innovative new platform for publishing WordPress-based code snippets with the ability to download each snippet as a working plugin.</li><li>The Community Team <a href=\"https://make.wordpress.org/community/2018/08/27/wordcamp-incubator-2018-update-thread-august-edition/\">has some updates</a> about how things are going with this year’s WordCamp Incubator program.</li><li>The WordPress Support Forums <a href=\"https://make.wordpress.org/support/2018/08/august-16th-support-team-meeting-summary/\">now include a feature</a> allowing forum volunteers to easily report a post to the moderators for a follow-up.</li><li>WordCamp Kochi, India <a href=\"https://2018.kochi.wordcamp.org/wordcamp-kochi-2018-is-postponed-to-november-3rd-2018-saturday/\">has unfortunately had to postpone their event</a> due to floods in the region.</li><li><a href=\"http://www.wpglossary.net/\">WP Glossary</a> is a new site that offers helpful definitions of words that you could encounter when using WordPress.</li><li>A few WordPress community members <a href=\"https://make.wordpress.org/community/2018/08/13/in-the-words-of-the/\">have started a working group</a> to tackle the idea of building diverse WordPress  communities all across the world.</li><li>A new <a href=\"https://editorblockswp.com/library/\">Gutenberg Block Library</a> is available, listing the details of the many blocks available for the new editor.</li></ul>\n\n\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6191\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.9.8 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2018 21:25:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme. Following are the highlights of what is now available. “Try Gutenberg” callout Most users will now be presented with a notice in their WordPress dashboard. This “Try Gutenberg” [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Paul Biron\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10398:\"<p>We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme.</p>\n<p><span style=\"font-weight: 400\">Following are the highlights of what is now available.</span></p>\n<h2>“Try Gutenberg” callout</h2>\n<p><span style=\"font-weight: 400\">Most users will now be presented with a notice in their WordPress dashboard. This </span>“Try Gutenberg” is an opportunity for users to use the Gutenberg block editor before it is released in WordPress 5.0.</p>\n<p><img class=\"alignnone wp-image-6168 size-full\" src=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=632{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}2C392&#038;ssl=1\" alt=\"\" width=\"632\" height=\"392\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=2528&amp;ssl=1 2528w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=300{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}2C186&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=768{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}2C476&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=1024{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}2C634&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>In WordPress 4.9.8, the callout will be shown to the following users:</p>\n<ul>\n<li>If Gutenberg <em>is not</em> installed or activated, the callout will be shown to Admin users on single sites, and Super Admin users on multisites.</li>\n<li>If Gutenberg <em>is</em> installed and activated, the callout will be shown to Contributor users and above.</li>\n<li>If the Classic Editor plugin is installed and activated, the callout will be hidden for all users.</li>\n</ul>\n<p class=\"entry-title\"><span style=\"font-weight: 400\">You can learn more by reading  </span><a href=\"https://make.wordpress.org/core/2018/08/02/try-gutenberg-callout-in-wordpress-4-9-8/\">“Try Gutenberg” Callout in WordPress 4.9.8</a>.</p>\n<h2>Privacy fixes/enhancements</h2>\n<p>This release includes 18 Privacy fixes focused on ensuring consistency and flexibility in the new personal data tools <span style=\"font-weight: 400\">that were </span>added in 4.9.6, including:</p>\n<ul>\n<li>The type of request being confirmed is now included in the subject line for all privacy confirmation emails.</li>\n<li>Improved consistency with site name being used for privacy emails in multisite.</li>\n<li>Pagination for Privacy request admin screens can now be adjusted.</li>\n<li>Increased the test coverage for several core privacy functions.</li>\n</ul>\n<p><a href=\"https://make.wordpress.org/core/2018/08/02/wordpress-4-9-8/\">This post has more information about all of the issues fixed in 4.9.8 if you&#8217;d like to learn more</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.8</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n<p>Thank you to everyone who contributed to WordPress 4.9.8:</p>\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">Abdullah Ramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/allendav/\">Allen Snook</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewtaylor-1/\">Andrew Taylor</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chrislema/\">Chris Lema</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danieltj/\">Daniel James</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dontstealmyfish/\">dontstealmyfish</a>, <a href=\"https://profiles.wordpress.org/dyrer/\">dyrer</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/gm_alex/\">GM_Alex</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/joshuawold/\">JoshuaWold</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">kjellr</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/michelleweber/\">michelleweber</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/xpertone/\">Muhammad Kashif</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a>, <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/rafsuntaskin/\">Rafsun Chowdhury</a>, <a href=\"https://profiles.wordpress.org/redcastor/\">redcastor</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/pross/\">Simon Prosser</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/spyderbytes/\">spyderbytes</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/timbowesohft/\">timbowesohft</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/usmankhalid/\">Usman Khalid</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 16 Nov 2018 13:50:59 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Fri, 16 Nov 2018 01:11:43 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20130911073210\";}","no");
INSERT INTO wpcf_options VALUES("134","_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1542419455","no");
INSERT INTO wpcf_options VALUES("135","_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1542376255","no");
INSERT INTO wpcf_options VALUES("136","can_compress_scripts","1","no");
INSERT INTO wpcf_options VALUES("137","_transient_timeout_feed_26b0d8e18ed25a5313e8c7eb9c687d1b","1542419455","no");
INSERT INTO wpcf_options VALUES("138","_transient_feed_26b0d8e18ed25a5313e8c7eb9c687d1b","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Nederlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://nl.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jul 2018 08:05:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"nl\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-beta5-43907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"WordCamps in Nederland in 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://nl.wordpress.org/2018/01/10/wordcamps-in-nederland-in-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://nl.wordpress.org/2018/01/10/wordcamps-in-nederland-in-2018/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Jan 2018 10:11:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=854\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:415:\"Beste WordCamp Nederland liefhebber, Zoals je mogelijk hebt kunnen zien moesten wij, als organisatie achter WordCamp Nederland, eerst 3 andere WordCamps in Nederland &#8220;laten gebeuren&#8221; voordat we weer een WordCamp Nederland mochten organiseren. Als WordPress Community hebben we hier werk van gemaakt. WordCamp Nijmegen en WordCamp Utrecht staan ondertussen al als twee succesvolle WordCamps die [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2255:\"<p>Beste WordCamp Nederland liefhebber,</p>\n<p>Zoals je mogelijk hebt kunnen zien moesten wij, als organisatie achter WordCamp Nederland, eerst 3 andere WordCamps in Nederland &#8220;laten gebeuren&#8221; <a href=\"https://nl.wordpress.org/2017/06/15/toch-toekomst-voor-wordcamp-nederland/\" target=\"_blank\" rel=\"noopener noreferrer\">voordat we weer een WordCamp Nederland mochten organiseren</a>.</p>\n<p>Als WordPress Community hebben we hier werk van gemaakt. WordCamp Nijmegen en WordCamp Utrecht staan ondertussen al als twee succesvolle WordCamps die in de geschiedenisboeken.</p>\n<p>Maar daar stopt het niet. We hebben ook in 2018 al een aantal WordCamps op de planning staan. Dit zijn de twee die er op dit moment in de agenda staan:</p>\n<p><a href=\"https://2018.noordnederland.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">WordCamp Noord-Nederland</a> in Drachten, 9 en 10 feb. <a href=\"https://2018.noordnederland.wordcamp.org/tickets/\" target=\"_blank\" rel=\"noopener noreferrer\">Tickets koop je hier</a>.</p>\n<p><a href=\"https://rotterdam.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">WordCamp Rotterdam</a> in, je raadt het nooit, Rotterdam. 23 &amp; 24 maart. <a href=\"https://2018.rotterdam.wordcamp.org/tickets/\" target=\"_blank\" rel=\"noopener noreferrer\">Tickets vind je hier</a>.</p>\n<p>Daarnaast zijn <a href=\"https://utrecht.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">WordCamp Utrecht</a> en <a href=\"https://nijmegen.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">WordCamp Nijmegen</a> alweer voorzichtig bezig met een planning. En uiteraard moeten we onze zuiderburen niet vergeten: WordCamp Antwerp gaat voor de tweede keer alweer los <a href=\"https://antwerp.wordcamp.org\" target=\"_blank\" rel=\"noopener noreferrer\">op 2 &amp; 3 maart 2018</a>.</p>\n<p>Al met al zul je de komende tijd steeds meer lokale WordCamps voorbij zien komen. Uiteraard komt er ook weer een WordCamp Nederland aan, maar we wachten nog even met het definitieve plannen hiervan.</p>\n<p>Zodra we meer weten laten we het jullie weten.</p>\n<p><strong>Update 6 juli 2018:</strong> <a href=\"https://nl.wordpress.org/team/2018/07/06/wordcamps-in-nederland-onze-ervaringen/\">WordCamps in Nederland &#8211; onze ervaringen</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://nl.wordpress.org/2018/01/10/wordcamps-in-nederland-in-2018/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Nederlanders krijgen commitrechten op WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://nl.wordpress.org/2017/12/12/nederlanders-krijgen-commitrechten-op-wordpress-core/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"https://nl.wordpress.org/2017/12/12/nederlanders-krijgen-commitrechten-op-wordpress-core/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Dec 2017 08:42:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Nieuws\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=833\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:416:\"WordPress is een Open Source software-project. Dat betekent dat iedereen de broncode van WordPress kan bekijken en suggesties voor verbetering kan aandragen. Gebruikers maken WordPress daarom niet alleen voor elkaar, maar vooral ook met elkaar. Hoewel iedereen verbeteringen kan aandragen, is het daadwerkelijk toevoegen van code aan WordPress voorbehouden aan een vrij selecte groep ervaren WordPressers. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Taco Verdonschot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2973:\"<p>WordPress is een Open Source software-project. Dat betekent dat iedereen de broncode van WordPress kan bekijken en suggesties voor verbetering kan aandragen. Gebruikers maken WordPress daarom niet alleen voor elkaar, maar vooral ook met elkaar.</p>\n<p>Hoewel iedereen verbeteringen kan aandragen, is het daadwerkelijk toevoegen van code aan WordPress voorbehouden aan een vrij selecte groep ervaren WordPressers. Om dit te kunnen doen heb je zogenaamde commitrechten nodig. Je krijgt deze rechten niet zomaar, want het betekent dat je WordPress voor alle gebruikers kan aanpassen. Het gebeurt dus niet vaak dat er nieuwe committers (mensen met commitrechten) worden toegevoegd aan het project.<span id=\"more-833\"></span></p>\n<p>Extra bijzonder is het daarom dat maar liefst twee Nederlanders commitrechten hebben gekregen in de afgelopen 10 dagen. We zetten ze daarom graag even in het zonnetje.</p>\n<h3>Juliette Reinders Folmer</h3>\n<p><a href=\"https://profiles.wordpress.org/jrf\">Juliette</a> is geen onbekende in de WordPress community. Ze werkt al sinds 2004 met PHP en al sinds 2010 met WordPress, en heeft zeer actief bijgedragen aan diverse plugins en aan WordPress zelf. De afgelopen periode heeft Juliette zich vooral ingezet om te zorgen dat WordPress voldoet aan de WordPress codestandaard. Dit is een set afspraken die WordPress-ontwikkelaars hebben gemaakt over wat goede code is. Haar project zorgt ervoor dat meer dan 60.000 foutmeldingen en waarschuwingen in één klap worden opgelost. Indrukwekkend feit, deze ene patch (verbetering aan de software) heeft meer dan 25{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76} van alle regels code in WordPress gewijzigd!<br />\nMeer weten? Op <a href=\"https://nijmegen.wordcamp.org\">WordCamp Nijmegen</a> heeft Juliette over deze patch gesproken. Je kan haar presentatie terugkijken op <a href=\"https://wordpress.tv/2017/10/14/juliette-reinders-folmer-the-biggest-wp-core-patch-ever/\">wordpress.tv</a>.</p>\n<h3>Anton Timmermans</h3>\n<p>Ook <a href=\"https://profiles.wordpress.org/atimmer\">Anton</a> loopt al lange tijd rond in het WordPress-wereldje. In 2012 ontdekte Anton WordPress, en nog geen jaar later werd zijn eerste verbetering (patch) toegevoegd aan WordPress. De afgelopen tijd heeft zich, samen met zijn collega&#8217;s van <a href=\"https://yoast.com\">Yoast</a>, ingezet voor het verbeteren van de JavaScript documentatie in WordPress. Hierdoor is het voor andere ontwikkelaars makkelijker om de JavaScript-code van WordPress te begrijpen en er op in te haken.</p>\n<h3>Zelf ook bijdragen?</h3>\n<p>Wil je zelf ook bijdragen aan het verbeteren van WordPress? Dat kan! Op <a href=\"https://make.wordpress.org\">make.wordpress.org</a> vind je een overzicht van de gebieden waarin je kan bijdragen. Elk team heeft een eigen &#8216;Getting started&#8217; sectie in hun handboek. Voor WordPress core kan je deze bijvoorbeeld vinden op <a href=\"https://make.wordpress.org/core/handbook/about/getting-started-at-a-contributor-day/\">Getting started</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://nl.wordpress.org/2017/12/12/nederlanders-krijgen-commitrechten-op-wordpress-core/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 4.9 is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://nl.wordpress.org/2017/11/16/wordpress-4-9-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2017/11/16/wordpress-4-9-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Nov 2017 22:23:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=858\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:425:\"Met trots kunnen we melden dat WordPress 4.9 is vrijgegeven. WordPress 4.9 zal je ontwerp workflow vloeiend maken en je beschermen voor programmeerfouten. Belangrijke verbeteringen voor de Customizer, Foutcontrole en meer! 🎉 Welkom bij de verbeterde Customizer. Een verbeterde workflow met concept ontwerpen, ontwerpvergrendeling en voorbeeldlinks. En nog meer. Met syntaxmarkering en foutcontrole wordt het nog [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8185:\"<p>Met trots kunnen we melden dat WordPress 4.9 is vrijgegeven. WordPress 4.9 zal je ontwerp workflow vloeiend maken en je beschermen voor programmeerfouten.</p>\n<h2>Belangrijke verbeteringen voor de Customizer, Foutcontrole en meer! <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<p>Welkom bij de verbeterde Customizer. Een verbeterde workflow met concept ontwerpen, ontwerpvergrendeling en voorbeeldlinks. En nog meer. Met syntaxmarkering en foutcontrole wordt het nog makkelijk een site te ontwikkelen. En als klap op de vuurpijl is er een nieuwe galerij widget geïntroduceerd en zijn er diverse verbeteringen doorgevoerd aan themabeheer.<span id=\"more-858\"></span></p>\n<p><img class=\"alignnone size-full\" src=\"https://s.w.org/images/core/4.9/banner.svg\" width=\"1200\" height=\"600\" /></p>\n<h2>Verbeterde workflow Customizer</h2>\n<h3>Concept ontwerpaanpassingen inplannen</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/draft-and-schedule.svg\" alt=\"\" />Ja, je hebt het goed gelezen. Net zoals je concept berichten kunt opstellen, aanpassen en inplannen voor publicatie op een voor jou geschikt moment, kun je wijzigingen aan het ontwerp van je site nu zo plannen dat ze gepubliceerd worden wanneer jij dat wilt.</p>\n<h3>Samenwerken met conceptontwerp voorbeeldlinks</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/design-preview-links.svg\" alt=\"\" />Feedback nodig op voorgestelde site ontwerp wijzigingen? WordPress 4.9 geeft je een voorbeeld link die je naar je team en klanten kan sturen, zodat je feedback kan verzamelen en verwerken alvorens je je wijzigingen live zet. Dat is fijn samenwerken!</p>\n<h3>Ontwerpvergrendeling om wijzigingen te bewaken</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/locking.svg\" alt=\"\" />Heb je het ooit meegemaakt dat twee ontwikkelaars bij het project kwamen en elkaar verweten hun mooie aanpassingen te hebben overschreven? WordPress 4.9. ontwerpvergrendeling (vergelijkbaar met berichtvergrendeling) beschermd het concept ontwerp zodat niemand anders wijzigingen kan maken en alle het harde werk overschrijft.</p>\n<h3>Een melding om je werk te beschermen</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/prompt.svg\" alt=\"\" />Was je even niet bij je bureau voordat je het nieuwe concept ontwerp had opgeslagen? Geen zorgen, WordPress 4.9 zal je bij terugkeer vriendelijk vragen of je je wijzigingen wilt opslaan.</p>\n<h2>Codeverbeteringen</h2>\n<p>&nbsp;</p>\n<h3>Syntaxmarkering en foutcontrole? Ja, graag!</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/syntax-highlighting.svg\" alt=\"\" />Er is een weergaveprobleem, maar je kan maar niet vinden wat er fout is met de door jouw fantastisch geschreven CSS. Met syntaxmarkering en foutcontrole voor CSS en aangepaste HTML is het nog makkelijker geworden om fouten te vinden. Gegarandeerd eenvoudiger om fouten snel te verhelpen door eenvoudig de code te scannen.</p>\n<h3>Sandbox voor veiligheid</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/sandbox.svg\" alt=\"\" />Het gevreesde witte scherm. Je zal het kunnen voorkomen als je werkt met thema&#8217;s en plugin code, omdat WordPress 4.9 je zal waarschuwen alvorens een fout te bewaren. Je zal &#8217;s nachts beter slapen.</p>\n<h3>Waarschuwing: potentieel gevaar opkomst!</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/warning.svg\" alt=\"\" />Tijdens het direct bewerken van thema&#8217;s en plugins, zal WordPress 4.9 je vriendelijk waarschuwen dat dit een potentieel gevaar is. Een aanbeveling zal worden gegeven een backup te maken van je bestanden voordat je deze opslaat. Hierdoor worden wijzigingen niet overschreven bij een volgende update. Neem deze veilige route. Je toekomstige, je team en klanten zullen je dankbaar zijn voor deze beslissing.</p>\n<h2>Nog meer widget verbeteringen</h2>\n<h3>De nieuwe galerij widget</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/gallery-widget.svg\" alt=\"\" />Een extra verbetering aan de media aanpassingen die in WordPress 4.8 is uitgekomen. Nu is het mogelijk een galerij toe te voegen via widget. Fantastisch!</p>\n<h3>Druk op een knop, media toevoegen</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/media-button.svg\" alt=\"\" />Wil je media toevoegen aan je tekst-widget? Voeg afbeeldingen, video en audio direct in de widget met je tekst, met de simpele maar handige Voeg media toe knop.</p>\n<h2>Verbeteringen voor site-ontwikkeling</h2>\n<h3>Verbeterde themawisseling</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/theme-switching.svg\" alt=\"\" />Bij het wijzigen van een thema denken widgets soms dat ze zomaar van locatie kunnen verspringen. Verbeteringen in WordPress 4.9 zorgen er nu voor dat er een duidelijker menu en widget beheer wanneer je een nieuwe thema selecteert. Ook is mogelijk om eenvoudig een voorbeeld te tonen van geïnstalleerde thema&#8217;s of om een thema te downloaden, installeren en voorbeeld te tonen. Wel zo gemakkelijk om eerst een voorbeeld te bekijken voordat je deze activeert.</p>\n<h3>Betere menu instructies = Minder verwarring</h3>\n<p><img class=\"alignright\" src=\"https://s.w.org/images/core/4.9/menu-flow.svg\" alt=\"\" />Vond je de stappen om een nieuw menu te creëren verwarrend? Wellicht niet meer! We hebben de gebruikersinterface voor het maken van menu&#8217;s verbeterd zodat dit een stuk makkelijker gaat. Deze nieuwe update zal je hierin begeleiden.</p>\n<h2>Een handje meehelpen aan Gutenberg <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f91d.png\" alt=\"🤝\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<p><img class=\"alignnone size-full\" src=\"https://s.w.org/images/core/4.9/gutenberg.svg\" width=\"1200\" height=\"600\" /><br />\nWordPress werkt aan een nieuwe manier om je inhoud te creëren en beheren en we stellen je hulp op prijs. Geïnteresseerd om een <a href=\"https://wordpress.org/plugins/gutenberg/\">vroege tester</a> te zijn of meehelpen met het Gutenberg project? <a href=\"https://github.com/WordPress/gutenberg\">Bijdragen op GitHub</a>.</p>\n<h2>Ontwikkelaarsgeluk <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<h3><a href=\"https://make.wordpress.org/core/2017/11/01/improvements-to-the-customize-js-api-in-4-9/\">Customizer JS API verbeteringen</a></h3>\n<p>Er zijn diverse verbeteringen doorgevoerd aan de Customizer JS API in WordPress 4.9. Deze verbeteringen verwijderen diverse pijnpunten en maken het net zo makkelijk om mee te werken als de PHP API. Er zijn ook nieuwe standaarden, zoals: controle templates, een datum/tijd controle en een sectie/paneel notificatie toegevoegd. <a href=\"https://make.wordpress.org/core/2017/11/01/improvements-to-the-customize-js-api-in-4-9/\">Bekijk de hele lijst met verbeteringen.</a></p>\n<h3><a href=\"https://make.wordpress.org/core/2017/10/22/code-editing-improvements-in-wordpress-4-9/\">CodeMirror beschikbaar voor gebruik in je thema&#8217;s en plugins</a></h3>\n<p>We hebben een nieuwe codebewerkingsbibliotheek geïntroduceerd, CodeMirror, voor gebruik binnen WordPress. Gebruik het om iedere geschreven code, zoals CSS of JavaScript, binnen je plugins te verbeteren.</p>\n<h3><a href=\"https://make.wordpress.org/core/2017/10/30/mediaelement-upgrades-in-wordpress-4-9/\">MediaElement.js bijgewerkt naar 4.2.6</a></h3>\n<p>WordPress 4.9 bevat een bijgewerkte versie van MediaElement.js. Afhankelijkheden met jQuery zijn verwijderd, toegankelijkheid is verbeterd, gebruikersinterface is gemoderniseerd en veel bugs zijn gerepareerd.</p>\n<h3><a href=\"https://make.wordpress.org/core/2017/10/15/improvements-for-roles-and-capabilities-in-4-9/\">Verbeteringen aan rollen en rechten</a></h3>\n<p>Nieuwe eigenschappen zijn geïntroduceerd die het beheer van plugins en vertaalbestanden verfijnd mogelijk maken. Daarnaast is het siteschakelproces in multi-site nauwkeurig afgesteld om de beschikbare rollen en eigenschappen op een meer betrouwbare en coherente manier bij te werken.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://nl.wordpress.org/2017/11/16/wordpress-4-9-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Toch toekomst voor WordCamp Nederland!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://nl.wordpress.org/2017/06/15/toch-toekomst-voor-wordcamp-nederland/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://nl.wordpress.org/2017/06/15/toch-toekomst-voor-wordcamp-nederland/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 15 Jun 2017 14:33:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Algemeen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=754\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:349:\"Terugblik Op 30 maart dit jaar publiceerden we een bericht over het einde van WordCamp Nederland. Zoals velen van jullie hebben gemerkt heeft dat online geleid tot een stevige discussie. Vanuit de hele wereld ontvingen we berichten dat mensen het oneens waren met de beslissingen van het Global Community Team. Nu, een aantal maanden later [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Taco Verdonschot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5484:\"<h2>Terugblik</h2>\n<p>Op 30 maart dit jaar publiceerden we een bericht over het einde van WordCamp Nederland. Zoals velen van jullie hebben gemerkt heeft dat online geleid tot een stevige discussie. Vanuit de hele wereld ontvingen we berichten dat mensen het oneens waren met de beslissingen van het Global Community Team. Nu, een aantal maanden later kijken we graag terug op wat er is gebeurd.<span id=\"more-754\"></span></p>\n<p>Als eerste willen we duidelijk maken dat er geen ‘wij’ en ‘zij’ is. We hebben altijd hetzelfde doel nagestreefd, namelijk de groei van de Nederlandse WordPress Community. Onze onenigheid ging slechts over juiste manier om dit te bereiken. Het Global Community Team was er van overtuigd dat het organiseren van meerdere lokale evenementen de juiste richting was, terwijl de WordCamp Nederland organisatie het laten groeien van de WordCamp Nederland zag als beste manier. Uiteindelijk besloot het Global Community Team dat WCNL 2017 niet door kon gaan.</p>\n<p>In de emotie van die beslissing hebben zowel de WCNL organisatie als het Global Community Team op het scherpst van de snede gecommuniceerd. Nu, een aantal maanden later, zijn we allemaal afgekoeld en hebben we een goed gesprek gehad over hoe we gezamenlijk verder kunnen.</p>\n<h2>Community Summit</h2>\n<p>Tijdens de Community Summit laaide het gesprek over regionale WordCamps opnieuw op. Ook hebben we hier gesproken over het verschil tussen regionale WordCamps en grote evenementen zoals WordCamp Europe. In een zeer open gesprek hebben we gesproken over de zorgen aan beide zijden, zoals geografie, het gevoel dat het niet laten doorgaan van WordCamp Nederland afbreuk deed aan de community, en ook dat de alternatieven niet duidelijk genoeg zijn gecommuniceerd.</p>\n<h2>De toekomst van WordCamps in Nederland</h2>\n<p>Het Global Community Team was erg duidelijk dat de huidige situatie (zonder WCNL) niet definitief is. Het nut van het verbieden van WCNL dit jaar is om een kans te creeren voor meer lokale teams om te proberen een evenement in hun eigen stad te organiseren. WordCamp Nederland kan absoluut weer opnieuw plaats gaan vinden. Om opnieuw toestemming te krijgen om WCNL te organiseren moeten we laten zien dat we gezonde lokale communities hebben. Dit wordt afgemeten aan het aantal Meetups en WordCamps.</p>\n<p>Kort gezegd, het Global Community Team heeft bevestigd dat we WordCamp Nederland opnieuw georganiseerd mag worden zodra we 3 verschillende, succesvolle WordCamps neerzetten in Nederland.</p>\n<p>Opmerking voor alle andere communities die dit bericht lezen: Omdat WordPress een wereldwijd project is worden deze richtlijnen opgesteld voor individuele situaties. Het aantal evenementen in een gebied kan verschillen, afhankelijk van de lokale situatie. Wil je ook een regionale WordCamp organiseren, neem dan contact op met het Global Community Team.</p>\n<p>&nbsp;</p>\n<hr />\n<p><em>[Below you&#8217;ll find the translation of the text above]</em></p>\n<h2>Looking back</h2>\n<p>On March 30th this year, we published a post about WordCamp The Netherlands not being organized anymore. As many of you know, it sparked quite a bit of discussion. From all over the world we received messages that people disagreed with the decisions made by Global Community Team. Now, a few months later we would like to look back on what happened.</p>\n<p>First of all, there’s no ‘us’ versus ‘them’. We’ve always had the same goals in mind, yet disagreed on the way to move the Dutch WordPress community forward. Global Community Team felt that we should move to more local WordCamps while the WCNL organization felt that WordCamp The Netherlands was the right way. In the end, Global Community Team decided WCNL 2017 wasn’t going to happen.</p>\n<p>In the emotion of that decision, both the WCNL organization and Global Community Team may have been a bit harsh in their communication. Now, a few months later things calmed down and we’ve been talking about a way forward together.</p>\n<h2>Community Summit</h2>\n<p>At the WordPress Community Summit, the conversation around regional WordCamps came up and we discussed the differences between regional events and large-scale events like WordCamp EU. We were able to communicate openly about the concerns on both sides including geography, the feeling that stopping WordCamp Netherlands was destructive, and also the fact that the alternatives communicated were not as clear as they could have been.</p>\n<h2>The future of WordCamps in The Netherlands</h2>\n<p>People from the Global Community Team were clear at the summit that this isn’t the final solution. The purpose of having no WordCamp Netherlands this year is to create the opportunity for more organizing teams to try having an event in their area. WordCamp The Netherlands can be organized again in the near future. To get permission again, we’ll have to show that we have healthy local communities. This is measured by the number of Meetups and WordCamps.</p>\n<p>Long story short, the Global Community Team confirmed that we have to have 3 different successful WordCamps in The Netherlands to qualify for a WordCamp The Netherlands again.</p>\n<p>Note for all other communities reading this post: Because WordPress is a global project, these guidelines are on a case by case basis. The number of events for any given area would depend on the local situation. Contact the Global Community Team if you’re interested in having your own regional WordCamp!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://nl.wordpress.org/2017/06/15/toch-toekomst-voor-wordcamp-nederland/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 4.8 is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://nl.wordpress.org/2017/06/08/wordpress-4-8-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2017/06/08/wordpress-4-8-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 08 Jun 2017 16:22:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=749\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"Een update met jou in de hoofdrol WordPress 4.8 voegt enkele fantastische nieuwe eigenschappen toe. Stap snel over voor een nog intuïtievere versie van WordPress. Al lijken sommige vernieuwingen klein, ze zijn gemaakt door honderden mensen met jou in gedachten. Maak je klaar voor nieuwe features die je zult verwelkomen als een oude vriend: verbeteringen [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7352:\"<h2>Een update met jou in de hoofdrol</h2>\n<p class=\"lead-description\">WordPress 4.8 voegt enkele fantastische nieuwe eigenschappen toe. Stap snel over voor een nog intuïtievere versie van WordPress.</p>\n<p>Al lijken sommige vernieuwingen klein, ze zijn gemaakt door honderden mensen met <em>jou</em> in gedachten. Maak je klaar voor nieuwe features die je zult verwelkomen als een oude vriend: verbeteringen aan links, <em>drie</em> nieuwe mediawigets voor afbeeldingen, audio en video, een verbeterde tekst widget die visueel bewerken ondersteunt, en een verbeterde nieuwssectie in je dashboard met informatie over WordPress evenementen die binnenkort bij jou in de buurt plaatsvinden.</p>\n<hr />\n<h2>Fantastische widget vernieuwingen</h2>\n<div class=\"headline-feature one-col\">\n<div class=\"col\"><img src=\"https://s.w.org/images/core/4.8/widgets-with-all-four-mobile_w_685.png\" alt=\"\" /></div>\n</div>\n<div class=\"feature-section two-col\">\n<div class=\"col\">\n<h3>Afbeeldingswidget</h3>\n<p>Een afbeelding toevoegen aan een widget is nu een eenvoudige taak die te doen is zonder kennis van code voor elke WordPress gebruiker. Je afbeelding eenvoudig toevoegen vanuit de widget instellingen. Probeer eens een foto van jezelf of van je nieuwste avonturen in het weekend — en zie hem als vanzelf verschijnen.</p>\n</div>\n<div class=\"col\">\n<h3>Videowidget</h3>\n<p>Een welkomstvideo is een geweldige manier om je website een menselijk gezicht te geven. Je kunt nu een video uit de mediabibliotheek toevoegen aan een sidebar op je site met de nieuwe video widget. Gebruik de videowidget om in een welkomstvideo de website bij je bezoekers te introduceren of promoot je nieuwste en beste inhoud.</p>\n</div>\n<div class=\"col\">\n<h3>Audiowidget</h3>\n<p>Ben jij een podcaster, muzikant of fanatieke blogger? Het toevoegen van een widget met je audiobestand is nog nooit zo eenvoudig geweest. Upload je audiobestand naar de mediabibliotheek, ga naar de widgetinstellingen, selecteer je bestand en je bent klaar voor luisteraars. Dit is ook een fantastische oplossing om welkomstbericht te tonen.</p>\n</div>\n<div class=\"col\">\n<h3>Richtekst widget</h3>\n<p>Deze nieuwe eigenschap is een echt paradepaardje. Rich-tekst bewerken is nu standaard voor tekstwidgets. Voeg ergens een widget toe en maak de tekst op zoals je wilt. Maak lijsten, maak tekst italic en voeg eenvoudig en snel links toe. Veel plezier met je nieuwe opmaakmogelijkheden en zie wat je snel voor elkaar kunt krijgen.</p>\n</div>\n</div>\n<hr />\n<div class=\"feature-section two-col\">\n<div class=\"col\">\n<h3>Link verbeteringen</h3>\n<p>Heb je ooit geprobeerd om een link bij te werken of de tekst naast een link te wijzigen? En het lukte niet om het goed te krijgen? Wanneer je tekst volgend op de link bewerkt, krijgt de nieuwe tekst ook de link. Of als je de tekst in de link bewerkt eindig je met tekst die niet gelinkt is. Dit kan heel frustrerend zijn! Maar met de nieuwe eigenschap link afbakening wordt het proces gestroomlijnd en zullen je links goed werken. Je zult er blij mee zijn. We beloven het</p>\n</div>\n<div class=\"col\">\n<div class=\"wp-video\">\n<div id=\"mep_0\" class=\"mejs-container svg wp-video-shortcode mejs-video\" role=\"application\">\n<div class=\"mejs-inner\">\n<div class=\"mejs-controls\">\n<div class=\"mejs-button mejs-fullscreen-button\"></div>\n</div>\n<div class=\"mejs-clear\"></div>\n</div>\n</div>\n</div>\n</div>\n</div>\n<hr />\n<div class=\"feature-section two-col\">\n<div class=\"col\">\n<h3>Dichtstbijzijnde WordPress evenementen</h3>\n<p>Wist je dat WordPress een bloeiende offline community heeft met groepen die regelmatig bijeenkomen in meer dan 400 steden rond de wereld? WordPress vestigt nu je aandacht op de events die je helpen om door te gaan met verbeteren van je WordPress vaardigheden, vrienden te ontmoeten en natuurlijk om te publiceren!</p>\n<p>Dit is snel een van onze favoriete eigenschappen aan het worden. Terwijl je bezig bent in het dashboard (omdat je updates draait en berichten schrijft, toch?) worden alle WordCamps en WordPress Meetups getoond — bij jou in de buurt — die binnenkort plaatsvinden.</p>\n<p>Meedoen aan de community helpt je om je WordPress vaardigheden te verbeteren en te netwerken met personen die je anders niet zou tegenkomen. Je kunt eenvoudig lokale evenementen vinden door in te loggen op het dashboard en daar de nieuwe evenementen en nieuws widget bekijken.</p>\n</div>\n<div class=\"col\"><img class=\"size-full wp-image-751 aligncenter\" src=\"https://nl.wordpress.org/files/2017/06/WordPress-evenementen-nieuws-widget.png\" alt=\"\" width=\"618\" height=\"378\" srcset=\"https://nl.wordpress.org/files/2017/06/WordPress-evenementen-nieuws-widget.png 618w, https://nl.wordpress.org/files/2017/06/WordPress-evenementen-nieuws-widget-300x183.png 300w\" sizes=\"(max-width: 618px) 100vw, 618px\" /></div>\n</div>\n<hr />\n<div class=\"changelog\">\n<h2>Zelfs nog meer ontwikkelaarsgeluk <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<div class=\"under-the-hood three-col\">\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/17/cleaner-headings-in-the-admin-screens/\">Verbeterde toegankelijkheid admin paneel headings</a></h3>\n<p>Nieuwe CSS-regels betekent dat externe inhoud (zoals “Nieuwe toevoegen” links) niet meer toegevoegd moet worden in de admin headings. Deze panel-headings verbeteren de toegankelijkheid voor diegene die gebruik maken van hulpmiddelen.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/22/removal-of-core-embedding-support-for-wmv-and-wma-file-formats/\">Verwijderen van ondersteuning voor WMV en WMA bestanden</a></h3>\n<p>Omdat minder en minder browsers ondersteuning bieden voor Silverlight zijn bestandsformaten die de Silverlightplugin nodig hebben verwijderd. Bestanden worden nog steeds getoond als download link, maar worden niet meer automatisch ingevoegd.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/22/multisite-focused-changes-in-4-8/\">Multisite Updates</a></h3>\n<p>Nieuwe capabilities zijn geïntroduceerd in 4.8. met het oog op het verwijderen van aanroepen naar <code>is_super_admin()</code>. Verder zijn er nieuwe hooks en tweaks toegevoegd om precies het aantal sites en gebruikers per netwerk te controleren.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/23/addition-of-tinymce-to-the-text-widget/\">Text-Editor JavaScript API</a></h3>\n<p>Met het toevoegen van TinyMCE aan de tekstwidget in 4.8 komt een nieuwe JavaScript API die de editor activeert na het laden van de pagina. Dit kan worden gebruikt om de editor te activeren voor elk tekstvak waarbij je de knoppen en functies kan configureren. Geweldig voor pluginauteurs.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2017/05/26/media-widgets-for-images-video-and-audio/\">Mediawidgets API</a></h3>\n<p>De introductie van een nieuwe basis mediawidget REST API schema voor 4.8. biedt mogelijkheden voor meer mediawidgets (zoals galerijen of afspeellijsten) in de toekomst. De drie nieuwe mediawidgets worden ondersteund door een gedeelde class die zorg draagt voor de interactie met de mediamodel. Deze class maakt het ook eenvoudiger om nieuwe mediawidgets te maken and plaveit de weg voor nog meer.</p>\n</div>\n</div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://nl.wordpress.org/2017/06/08/wordpress-4-8-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"Het einde van WordCamp The Netherlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://nl.wordpress.org/2017/03/30/het-einde-van-wordcamp-the-netherlands/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://nl.wordpress.org/2017/03/30/het-einde-van-wordcamp-the-netherlands/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Mar 2017 07:30:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=731\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:190:\"Op het WordPress NL teamblog wordt in een uitgebreide blog uitgelegd waarom er (voorlopig) geen WordCamp The Netherlands meer georganiseerd mag worden. Het einde van WordCamp The Netherlands\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcel Bootsman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:780:\"<p>Op het WordPress NL teamblog wordt in een uitgebreide blog uitgelegd waarom er (voorlopig) geen WordCamp The Netherlands meer georganiseerd mag worden.</p>\n<blockquote class=\"wp-embedded-content\" data-secret=\"w0H3F05tfB\"><p><a href=\"https://nl.wordpress.org/team/2017/03/30/het-einde-van-wordcamp-the-netherlands/\">Het einde van WordCamp The Netherlands</a></p></blockquote>\n<p><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\" src=\"https://nl.wordpress.org/team/2017/03/30/het-einde-van-wordcamp-the-netherlands/embed/#?secret=w0H3F05tfB\" data-secret=\"w0H3F05tfB\" width=\"600\" height=\"338\" title=\"&#8220;Het einde van WordCamp The Netherlands&#8221; &#8212; Team NL\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://nl.wordpress.org/2017/03/30/het-einde-van-wordcamp-the-netherlands/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordCamp The Netherlands 2017\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://nl.wordpress.org/2017/02/17/wordcamp-the-netherlands-2017/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://nl.wordpress.org/2017/02/17/wordcamp-the-netherlands-2017/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Feb 2017 08:36:16 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=708\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:326:\"Op 14 februari was de kickoff meeting voor WordCamp The Netherlands 2017. Het nieuwe team We starten met een nieuw, groter team. Vorig jaar hebben we gemerkt dat er behoorlijk veel druk op het team lag, en dat er voor sommige aandachtsgebieden extra mensen nodig waren. We gaan dat aanpakken door naast de leads, ook [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Marcel Bootsman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3061:\"<p>Op 14 februari was de kickoff meeting voor WordCamp The Netherlands 2017.</p>\n<h2>Het nieuwe team</h2>\n<p>We starten met een nieuw, groter team. Vorig jaar hebben we gemerkt dat er behoorlijk veel druk op het team lag, en dat er voor sommige aandachtsgebieden extra mensen nodig waren. We gaan dat aanpakken door naast de leads, ook deputies aan te stellen (Nadat zij zich uiteraard bij ons hadden gemeld om mee te gaan helpen met de organisatie). Deze deputies helpen de leads waar nodig en worden actief betrokken bij beslissingen. Met de hulp van de deputies is ons team completer en kunnen we meer werk verzetten.</p>\n<h3>Leads:</h3>\n<ul>\n<li>Hoofdverantwoordelijke &#8211; Marcel Bootsman</li>\n<li>Design &amp; communicatie &#8211; Luc Princen</li>\n<li>Swag &amp; Goodies &#8211; Wendy Weel</li>\n<li>Sprekerselectie &#8211; Barry Kooij</li>\n<li>Sponsoring &#8211; Taco Verdonschot</li>\n<li>Vrijwilligers &#8211; Sjoerd Blom</li>\n<li>Locaties &#8211; Benoit Gütz</li>\n<li>Ervaringsdeskundige &#8211; Remkus de Vries</li>\n</ul>\n<h3>Deputies</h3>\n<ul>\n<li>DTP &#8211; Kelly Eekhof</li>\n<li>Webdesign &#8211; Thomas van der Westen</li>\n<li>Communicatie &#8211; Ines van Essen</li>\n<li>Goodies &#8211; Karin Bronwasser</li>\n<li>Sprekerselectie &#8211; Peter Luit</li>\n<li>Sponsoring &#8211; Mark Gruntjes</li>\n</ul>\n<h2>Wat hebben we besproken?</h2>\n<p>In de meeting hebben we, na een korte introductieronde, besproken welke rollen iedereen heeft en wat de verantwoordelijkheden zijn. Verder hebben we besproken dat de komende maanden elke twee weken een meeting zal plaatsvinden en dat de leads bij elke vergadering aanwezig zijn. Dit om de groep met aanwezigen tijdens de vergaderingen klein te houden, wat zorgt voor efficiënte vergaderingen. Vooraf maken we een planning waarbij vergaderingen een onderwerp krijgen, en daarbij worden dan ook de deputies uitgenodigd. Notulen van de vergaderingen zullen gemaakt worden door de leads, op rotatie-basis.</p>\n<h2>Tools</h2>\n<p>Om de vergaderingen soepel te laten verlopen gebruiken we Zoom. Met deze videoconferencedienst kunnen we met een gratis account 40 minuten vergaderen. Voldoende om alles te bespreken, en als er meer tijd nodig is, starten we gewoon een nieuwe.  Voor projectmanagement gebruiken we Trello. Met Trello heeft iedereen inzage in alles wat we besluiten/plannen. Slack wordt gebruikt voor groepschat en het stellen van vragen binnen het team</p>\n<h2>Locatie en datum</h2>\n<p>Op dit moment hebben we nog geen  locatie en datum. Na een hele mooie editie in de Jaarbeurs in 2016, willen we toch kijken of er misschien een andere locatie geschikt is. Zeker niet omdat we ontevreden zijn over de Jaarbeurs, integendeel zelfs.</p>\n<h2>Aantal bezoekers</h2>\n<p>Vorig jaar zijn we flink gegroeid qua aantal verkochte tickets. Dit jaar willen we weer een beetje groeien maar zo&#8217;n grote groei als vorig jaar is lastig te evenaren. Zodra we meer weten, laten we het hier weten.</p>\n<p>Mocht je naar aanleiding van dit bericht vragen of suggesties hebben, laat dan een reactie achter.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://nl.wordpress.org/2017/02/17/wordcamp-the-netherlands-2017/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"WordCamp Nijmegen zoekt organisatoren!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://nl.wordpress.org/2017/02/08/wordcamp-nijmegen-zoekt-organisatoren/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://nl.wordpress.org/2017/02/08/wordcamp-nijmegen-zoekt-organisatoren/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Feb 2017 08:29:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"WC024\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=685\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:362:\"Beste WordPressers, In 2014 zijn Gijs Hovens (Savvii) en ondergetekende gestart met de WordPress Meetup in Nijmegen. Al snel sloot Linus Wiggers zich aan bij de organisatie en de laatste jaren hebben we gezamenlijk de 3-maandelijkse WordPress Meetup georganiseerd in Nijmegen. En dat zullen we blijven doen. WordCamp Nijmegen! Toch is het ook tijd voor [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Taco Verdonschot\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3055:\"<p>Beste WordPressers,</p>\n<p>In 2014 zijn Gijs Hovens (Savvii) en ondergetekende gestart met de <a href=\"https://www.meetup.com/WordPress-Meetup-Nijmegen/\" target=\"_blank\">WordPress Meetup in Nijmegen</a>. Al snel sloot Linus Wiggers zich aan bij de organisatie en de laatste jaren hebben we gezamenlijk de 3-maandelijkse WordPress Meetup georganiseerd in Nijmegen. En dat zullen we blijven doen.</p>\n<p><strong>WordCamp Nijmegen!</strong><br />\nToch is het ook tijd voor een volgende stap. En als je al een succesvolle WordPress Meetup hebt, dan is de logische volgende stap een eigen WordCamp. Inderdaad. Een conferentie over alles rond WordPress in ons eigen Nijmegen.</p>\n<p>Je zal begrijpen dat het organiseren van een WordCamp nog meer tijd kost dan het organiseren van een meetup. Daarom is de eerste stap van de organisatie het vormen van een organisatieteam van 5 of 6 personen. Vervolgens gaan we op zoek naar een locatie en zodra dat rond is kan het échte plannen beginnen.</p>\n<p><strong>Organisatoren gezocht</strong><br />\nHet organisatieteam zal zich bezig houden met het zoeken van een geschikte locatie, het vinden van sponsoren, het vinden van sprekers en vrijwilligers, het (laten) maken van swag, het communiceren met bezoekers en media, en het maken van een prachtige WordCamp website. Kortom, er is veel te doen!</p>\n<p>Daarom wil ik je uitnodigen om je aan te melden als organisator. Dat kan via het contactformulier op <a href=\"https://2017.nijmegen.wordcamp.org/\" target=\"_blank\">https://2017.nijmegen.wordcamp.org/</a>. Een kort berichtje met je contactgegevens en een toelichting wat je zou willen doen en waarom je daar geschikt voor bent is genoeg.</p>\n<p>Je hebt <strong><em>tot en met 28 februari</em></strong> om je aan te melden, zodat we op 1 maart het team kunnen formeren.</p>\n<p>Ter informatie: omdat WordCamp Nijmegen een lokaal evenement is krijgen geïnteresseerden die in het 024-gebied wonen, bij gelijke geschiktheid, voorrang.</p>\n<p><strong>UPDATE: zie ook <a href=\"https://nl.wordpress.org/team/2017/02/13/wordcamp-nijmegen/\">https://nl.wordpress.org/team/2017/02/13/wordcamp-nijmegen/</a></strong></p>\n<p><strong>Geschatte tijdsinvestering</strong><br />\nDe organisatie van WordCamp Nijmegen kost natuurlijk tijd. Ik verwacht dat je in de aanloopfase ongeveer 1 uur per week kwijt bent. In de weken voor de conferentie zal dat oplopen en de laatste week ben je waarschijnlijk bijna full-time met WordCamp Nijmegen bezig.</p>\n<p>Mijn ervaring leert dat het erg prettig is als je werkgever achter je keuze staat en je toestaat om (een deel van) je werktijd te gebruiken voor de organisatie.</p>\n<p><strong>Vragen?</strong><br />\nVul het contactformulier op <a href=\"https://2017.nijmegen.wordcamp.org/\" target=\"_blank\">https://2017.nijmegen.wordcamp.org/</a> in, of stuur een e-mail naar <a href=\"mailto:nijmegen@wordcamp.org\">nijmegen@wordcamp.org</a></p>\n<p>Hopelijk tot binnenkort,<br />\nTaco Verdonschot</p>\n<p>E-mail: <a href=\"mailto:nijmegen@wordcamp.org\" target=\"_blank\">nijmegen@wordcamp.org</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://nl.wordpress.org/2017/02/08/wordcamp-nijmegen-zoekt-organisatoren/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n\n\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"WordPress 4.7 is vrijgegeven\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://nl.wordpress.org/2016/12/06/wordpress-4-7-is-vrijgegeven/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://nl.wordpress.org/2016/12/06/wordpress-4-7-is-vrijgegeven/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 06 Dec 2016 21:22:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=661\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:411:\"Zojuist is WordPress 4.7 vrijgegeven. WordPress 4.7 zit bomvol verbeteringen van bestaande features en introduceert ook het nieuwe standaard thema voor 2017. We introduceren Twenty Seventeen Een volledig nieuw standaard thema brengt jouw site tot leven met uitgelichte afbeeldingen en video headers. Twenty Seventeen focust op bedrijfswebsites en heeft een aanpasbare hoofdpagina met meerdere secties. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:61:\"https://nl.wordpress.org/files/2016/12/starter-content-v1.mp4\";s:6:\"length\";s:7:\"1635917\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://nl.wordpress.org/files/2016/12/edit-shortcuts-v1.mp4\";s:6:\"length\";s:7:\"1195621\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:58:\"https://nl.wordpress.org/files/2016/12/header-video-v1.mp4\";s:6:\"length\";s:7:\"1546685\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Remkus de Vries\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:9569:\"<p>Zojuist is WordPress 4.7 vrijgegeven. WordPress 4.7 zit bomvol verbeteringen van bestaande features en introduceert ook het nieuwe standaard thema voor 2017.</p>\n<h2>We introduceren Twenty Seventeen</h2>\n<p class=\"lead-description\">Een volledig nieuw standaard thema brengt jouw site tot leven met uitgelichte afbeeldingen en video headers.<img class=\"aligncenter size-full wp-image-662\" src=\"https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058.jpg\" alt=\"\" width=\"1058\" height=\"595\" srcset=\"https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058.jpg 1058w, https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058-300x169.jpg 300w, https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058-768x432.jpg 768w, https://nl.wordpress.org/files/2016/12/twenty-seventeen-1058-1024x576.jpg 1024w\" sizes=\"(max-width: 1058px) 100vw, 1058px\" /></p>\n<p class=\"lead-description\">Twenty Seventeen focust op bedrijfswebsites en heeft een aanpasbare hoofdpagina met meerdere secties. Personaliseer met widgets, menu&#8217;s, social media menu&#8217;s, een logo, aangepaste kleuren en meer. Ons standaard thema voor 2017 werkt goed in veel talen, op elk apparaat en voor een breed spectrum aan gebruikers.</p>\n<h2>Jouw site, jouw manier</h2>\n<p class=\"lead-description\">WordPress 4.7 voegt nieuwe functies toe aan de customizer om je te helpen door de initiële setup van een thema te komen, met non-destructieve live voorbeelden van al je wijzigingen in één ononderbroken workflow.</p>\n<h3>Thema starter inhoud</h3>\n<p>Om je te helpen met het wijzigen van individuele thema&#8217;s, is er een solide basis beschikbaar via de start-inhoud bij het aanpassen van jouw site. Dit gaat van een eenvoudige bedrijfsinformatie widget tot het leveren van een voorbeeldmenu met sociale media iconen of het aanmaken van een statische pagina met mooie afbeeldingen. Maak je geen zorgen, niets zal worden getoond op je live site totdat jij klaar bent om je initiële thema aanpassingen te publiceren.</p>\n<div style=\"width: 612px;\" class=\"wp-video\"><!--[if lt IE 9]><script>document.createElement(\'video\');</script><![endif]-->\n<video class=\"wp-video-shortcode\" id=\"video-661-1\" width=\"612\" height=\"335\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://nl.wordpress.org/files/2016/12/starter-content-v1.mp4?_=1\" /><a href=\"https://nl.wordpress.org/files/2016/12/starter-content-v1.mp4\">https://nl.wordpress.org/files/2016/12/starter-content-v1.mp4</a></video></div>\n<h3>Bewerk snelkoppelingen</h3>\n<div style=\"width: 612px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-661-2\" width=\"612\" height=\"353\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://nl.wordpress.org/files/2016/12/edit-shortcuts-v1.mp4?_=2\" /><a href=\"https://nl.wordpress.org/files/2016/12/edit-shortcuts-v1.mp4\">https://nl.wordpress.org/files/2016/12/edit-shortcuts-v1.mp4</a></video></div>\n<p>Zichtbare iconen worden getoond om aan te geven welke delen van jouw site aangepast kunnen worden tijdens het live voorbeeld. Klik op de link om direct met bewerken te beginnen. Samen met de start-inhoud wordt het nog makkelijker om je site snel te wijzigen.</p>\n<h3>Video headers</h3>\n<div style=\"width: 612px;\" class=\"wp-video\"><video class=\"wp-video-shortcode\" id=\"video-661-3\" width=\"612\" height=\"353\" preload=\"metadata\" controls=\"controls\"><source type=\"video/mp4\" src=\"https://nl.wordpress.org/files/2016/12/header-video-v1.mp4?_=3\" /><a href=\"https://nl.wordpress.org/files/2016/12/header-video-v1.mp4\">https://nl.wordpress.org/files/2016/12/header-video-v1.mp4</a></video></div>\n<p>Soms is een grote sfeervideo als bewegende kopafbeelding precies wat je nodig hebt om je producten te laten zien; ga je gang en probeer het uit met Twenty Seventeen. Heb je video-inspiratie nodig? Zoek maar eens naar sites die videoheaders beschikbaar hebben om te downloaden en gebruiken.</p>\n<h3>Makkelijker menu&#8217;s maken</h3>\n<p><img class=\"size-full wp-image-666 aligncenter\" src=\"https://nl.wordpress.org/files/2016/12/nav-menus-536.jpg\" alt=\"\" width=\"536\" height=\"282\" srcset=\"https://nl.wordpress.org/files/2016/12/nav-menus-536.jpg 536w, https://nl.wordpress.org/files/2016/12/nav-menus-536-300x158.jpg 300w\" sizes=\"(max-width: 536px) 100vw, 536px\" />Veel menu&#8217;s voor sites hebben links naar de pagina&#8217;s van je site, maar wat gebeurt er wanneer je er nog geen hebt? Nu kan je nieuwe pagina&#8217;s toevoegen terwijl je menu&#8217;s bouwt zonder dat je de customizer hoeft te verlaten en je de wijzigingen kwijt bent. Zodra je de wijzigingen hebt gepubliceerd staan de nieuwe pagina&#8217;s klaar om gevuld te worden.</p>\n<h3>Aangepaste CSS</h3>\n<p><img class=\"size-full wp-image-667 aligncenter\" src=\"https://nl.wordpress.org/files/2016/12/css-547.jpg\" alt=\"\" width=\"547\" height=\"288\" srcset=\"https://nl.wordpress.org/files/2016/12/css-547.jpg 547w, https://nl.wordpress.org/files/2016/12/css-547-300x158.jpg 300w\" sizes=\"(max-width: 547px) 100vw, 547px\" />Soms heb je een alleen een paar visuele veranderingen nodig om je site perfect te maken. WordPress 4.7 geeft je de mogelijkheid om aangepaste CSS toe te voegen en direct te zien wat voor effect deze aanpassingen op je site hebben. Het live voorbeeld laat je snel werken zonder steeds je pagina te moeten herladen.</p>\n<h3>PDF miniatuurvoorbeeld</h3>\n<p><img class=\"size-full wp-image-668 aligncenter\" src=\"https://nl.wordpress.org/files/2016/12/pdf-516.jpg\" alt=\"\" width=\"516\" height=\"272\" srcset=\"https://nl.wordpress.org/files/2016/12/pdf-516.jpg 516w, https://nl.wordpress.org/files/2016/12/pdf-516-300x158.jpg 300w\" sizes=\"(max-width: 516px) 100vw, 516px\" />Het beheren van jouw documenten is nog makkelijker geworden met WordPress 4.7. Na het uploaden van PDF&#8217;s wordt er ook een thumbnail gegenereerd zodat het eenvoudiger is om de documenten te onderscheiden.</p>\n<h3>Dashboard in jouw taal</h3>\n<p><img class=\"size-full wp-image-669 aligncenter\" src=\"https://nl.wordpress.org/files/2016/12/language-568.jpg\" alt=\"\" width=\"568\" height=\"299\" srcset=\"https://nl.wordpress.org/files/2016/12/language-568.jpg 568w, https://nl.wordpress.org/files/2016/12/language-568-300x158.jpg 300w\" sizes=\"(max-width: 568px) 100vw, 568px\" />Omdat jouw site in één taal is, betekent niet dat iedereen die helpt de site te beheren ook deze taal wil gebruiken in de admin. In de gebruikersprofielen zijn er meer talen beschikbaar gekomen om de gebruikerstaal in te stellen.</p>\n<h2>Introductie van REST API inhoud endpoints</h2>\n<p class=\"lead-description\">WordPress 4.7 komt met REST API endpoints voor berichten, reacties, termen, gebruikers, meta en instellingen.</p>\n<p><img class=\"aligncenter size-full wp-image-670\" src=\"https://nl.wordpress.org/files/2016/12/api-1559.jpg\" alt=\"\" width=\"1559\" height=\"505\" srcset=\"https://nl.wordpress.org/files/2016/12/api-1559.jpg 1559w, https://nl.wordpress.org/files/2016/12/api-1559-300x97.jpg 300w, https://nl.wordpress.org/files/2016/12/api-1559-768x249.jpg 768w, https://nl.wordpress.org/files/2016/12/api-1559-1024x332.jpg 1024w\" sizes=\"(max-width: 1559px) 100vw, 1559px\" /></p>\n<p>Inhoud endpoints leveren machine-leesbare externe toegang tot jouw WordPress site met een overzichtelijke, standaard-gedreven interface die ruimte biedt voor nieuwe en innovatieve methoden voor interacties van sites via plugins, thema&#8217;s, apps en nog meer. Klaar om te starten met het ontwikkelen? <a href=\"https://developer.wordpress.org/rest-api/reference/\">Bekijk en lees de REST API documentatie.</a></p>\n<div class=\"changelog\">\n<h2>Zelfs nog meer ontwikkelaars geluk <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f60a.png\" alt=\"😊\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>\n<div class=\"under-the-hood three-col\">\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2016/11/03/post-type-templates-in-4-7/\">Berichttype templates</a></h3>\n<p>Door het openstellen van de pagina template eigenschappen voor alle berichttypes beschikken thema ontwikkelaars over nog meer flexibiliteit met de WordPress template hiërarchie.</p>\n</div>\n<div class=\"col\">\n<h3>Meer thema API hulpmiddelen</h3>\n<p>WordPress 4.7 bevat <a href=\"https://make.wordpress.org/core/2016/09/09/new-functions-hooks-and-behaviour-for-theme-developers-in-wordpress-4-7/\">nieuwe functies, hooks en gedrag</a> voor thema ontwikkelaars.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2016/10/04/custom-bulk-actions/\">Aangepaste bulk acties</a></h3>\n<p>Lijsttabellen, nu met meer dan alleen bulk bewerken en verwijderen.</p>\n</div>\n</div>\n<div class=\"under-the-hood three-col\">\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2016/09/08/wp_hook-next-generation-actions-and-filters/\"><code>WP_Hook</code></a></h3>\n<p>De code verantwoordelijk voor de acties en filters is aangepast en gemoderniseerd. Verder zijn er diverse bugs opgelost.</p>\n</div>\n<div class=\"col\">\n<h3>Registratie API instellingen</h3>\n<p><code>register_setting()</code> <a href=\"https://make.wordpress.org/core/2016/10/26/registering-your-settings-in-wordpress-4-7/\">is verbeterd</a> door toevoeging van type, beschrijving en REST API zichtbaarheid.</p>\n</div>\n<div class=\"col\">\n<h3><a href=\"https://make.wordpress.org/core/2016/10/12/customize-changesets-technical-design-decisions/\">Aangepaste changesets</a></h3>\n<p>Aangepaste changesets maken wijzigingen in de customizer robuust, net zoals automatisch opgeslagen concepten. Ook levert het nieuwe eigenschappen zoals inhoud om te starten.</p>\n</div>\n</div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://nl.wordpress.org/2016/12/06/wordpress-4-7-is-vrijgegeven/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:48:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Doe met ons mee op Global WordPress Translation Day!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://nl.wordpress.org/2016/10/26/doe-met-ons-mee-op-global-wordpress-translation-day/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://nl.wordpress.org/2016/10/26/doe-met-ons-mee-op-global-wordpress-translation-day/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Oct 2016 10:44:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Vertaling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"meetup\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"vertaling\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://nl.wordpress.org/?p=652\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:402:\"Het WordPress Polyglots team organiseert een tweede Global WordPress Translation Day op 12 november 2016. Iedereen is uitgenodigd om mee te doen – waar ook ter wereld! Vertalen is één van de makkelijkste manieren om bij te dragen aan WordPress. Global WordPress Translation Day is je kans om meer te weten te komen over het vertalen van WordPress, ontmoet mensen van over de hele [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chantal Coolsma\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3624:\"<p>Het WordPress Polyglots team organiseert een tweede <a href=\"https://wptranslationday.org/\">Global WordPress Translation Day</a> op 12 november 2016. Iedereen is uitgenodigd om mee te doen – waar ook ter wereld!</p>\n<p>Vertalen is één van de makkelijkste manieren om bij te dragen aan WordPress. Global WordPress Translation Day is je kans om meer te weten te komen over het vertalen van WordPress, ontmoet mensen van over de hele wereld en help <a href=\"https://make.wordpress.org/polyglots/teams\">WordPress vertalen in meer dan 160 talen</a>.</p>\n<h3>Doe met ons mee op 12 november waar ook ter wereld</h3>\n<p>De vertaaldag start op zaterdag 12 november 2016 om 0:00 UTC en duurt 24 uur. <a href=\"http://arewemeetingyet.com/UTC/2016-11-12/00:00/Global{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}20WordPress{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}20Translation{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}20Day{a0b611944c3a7a064277fdaf860925d9f037b2ce4307d82cf5cbb9178b02ce76}202\">Bekijk welke tijd dat voor jou is!</a> Je kan meedoen vanaf het begin of op ieder moment dat jou het beste uitkomt die dag.</p>\n<h3>Wat doen we?</h3>\n<p>Locale contributor meetups worden over de hele wereld georganiseerd en zijn een goede manier om mee te doen. <a href=\"https://www.google.com/maps/d/viewer?mid=12Gni4JMfShyWHPqGNwh5-PMneMM&amp;usp=sharing\">Kijk op deze kaart</a> of er al een locale meetup bij jou in de buurt is. Kan je er geen vinden? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Organiseer een locale meetup!</a></p>\n<p>Doe op het zelfde moment mee met de <a href=\"https://www.crowdcast.io/e/gwtd2/register\">community voor 24 uur live-gestreamde, remote sessies</a> in verschillende talen. Sessies gaan over lokalisatie en bijdragen aan jouw taal.</p>\n<h3>Voor wie is het?</h3>\n<p>Of je nieuw bent als vertaler of een ervaren vertaalredacteur, de vertaaldag is er voor <i>jou</i>. Ontwikkelaars zullen ook genieten van de onderwerpen van ervaren contributors, of je nu leert over internationalisatie of meer vertalers voor je thema&#8217;s en plugins wilt vinden. Er is een sessie voor iedereen!</p>\n<h3>Doe mee</h3>\n<p>Mee doen is makkelijk! Op 12 november, in jouw tijdzone, <a href=\"https://translate.wordpress.org/\">vertaal WordPress</a> of je favoriete plugins en thema&#8217;s in je eigen taal, terwijl je gedurende de dag live-sessies volgt.</p>\n<p>Wil je meer doen? <a href=\"https://make.wordpress.org/polyglots/2016/09/22/global-wordpress-translation-day-2-on-november-12th-2016/\">Meld je locale meetup</a> en nodig je locale community uit om samen te vertalen op 12 november. Meetups kunnen formeel of informeel zijn – pak je laptop, neem een paar vrienden mee en ga naar een café in de buurt, om een uurtje of twee te vertalen.</p>\n<p>En als je heel veel zin hebt, help WordPress vertalen naar emoji! Jazeker, we hebben een vertaling van WordPress in emoji! <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f30e.png\" alt=\"🌎\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f30d.png\" alt=\"🌍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f30f.png\" alt=\"🌏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n<h3>Vragen?</h3>\n<p>Als je vragen hebt, het polyglots team en de meetup organizers zijn te vinden in het <a href=\"http://wordpress.slack.com/messages/polyglots/\">#polyglots kanaal op Slack</a> en helpen je graag! (Meld je aan voor Slack via <a href=\"https://chat.wordpress.org/\">chat.wordpress.org</a>.)</p>\n<p>Via de <a href=\"https://wptranslationday.org/\">officiële website</a> kun je je aanmelden voor het evenement.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://nl.wordpress.org/2016/10/26/doe-met-ons-mee-op-global-wordpress-translation-day/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:30:\"https://nl.wordpress.org/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Fri, 16 Nov 2018 13:50:59 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Thu, 19 Jul 2018 08:05:41 GMT\";s:4:\"link\";s:61:\"<https://nl.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20130911073210\";}","no");
INSERT INTO wpcf_options VALUES("139","_transient_timeout_feed_mod_26b0d8e18ed25a5313e8c7eb9c687d1b","1542419455","no");
INSERT INTO wpcf_options VALUES("140","_transient_feed_mod_26b0d8e18ed25a5313e8c7eb9c687d1b","1542376255","no");
INSERT INTO wpcf_options VALUES("141","_transient_timeout_dash_v2_12fb51b99c5dfec05835445e04f970a4","1542419455","no");
INSERT INTO wpcf_options VALUES("142","_transient_dash_v2_12fb51b99c5dfec05835445e04f970a4","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2018/11/wordpress-5-0-beta-5/\'>WordPress 5.0 Beta 5</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://nl.wordpress.org/2018/01/10/wordcamps-in-nederland-in-2018/\'>WordCamps in Nederland in 2018</a></li><li><a class=\'rsswidget\' href=\'https://nl.wordpress.org/2017/12/12/nederlanders-krijgen-commitrechten-op-wordpress-core/\'>Nederlanders krijgen commitrechten op WordPress</a></li><li><a class=\'rsswidget\' href=\'https://nl.wordpress.org/2017/11/16/wordpress-4-9-is-vrijgegeven/\'>WordPress 4.9 is vrijgegeven</a></li></ul></div>","no");
INSERT INTO wpcf_options VALUES("149","_transient_plugin_slugs","a:2:{i:0;s:19:\"akismet/akismet.php\";i:1;s:9:\"hello.php\";}","no");
INSERT INTO wpcf_options VALUES("150","recently_activated","a:0:{}","yes");
INSERT INTO wpcf_options VALUES("153","current_theme","Jupiter Child Theme","yes");
INSERT INTO wpcf_options VALUES("154","theme_mods_jupiter","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1542379820;s:4:\"data\";a:18:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}s:9:\"sidebar-9\";a:0:{}s:10:\"sidebar-10\";a:0:{}s:10:\"sidebar-11\";a:0:{}s:10:\"sidebar-12\";a:0:{}s:10:\"sidebar-13\";a:0:{}s:10:\"sidebar-14\";a:0:{}s:10:\"sidebar-15\";a:0:{}s:10:\"sidebar-16\";a:0:{}s:10:\"sidebar-17\";a:0:{}}}}","yes");
INSERT INTO wpcf_options VALUES("155","theme_switched","","yes");
INSERT INTO wpcf_options VALUES("156","mk_jupiter_theme_current_version","6.1.2","yes");
INSERT INTO wpcf_options VALUES("157","jupiter-data-tracking-hash","b4ef74e7ae3d285eaf39698d42891861","yes");
INSERT INTO wpcf_options VALUES("158","Jupiter_options_build","5beed92d44d63","yes");
INSERT INTO wpcf_options VALUES("159","mk_tour","a:1:{s:4:\"list\";a:1:{s:5:\"intro\";a:1:{s:5:\"state\";b:0;}}}","yes");
INSERT INTO wpcf_options VALUES("160","artbees_header_builder_db_version","2","yes");
INSERT INTO wpcf_options VALUES("161","widget_contact_form","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("162","widget_contact_info","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("163","widget_gmap","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("164","widget_social","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("165","widget_subnav","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("166","widget_testimonial_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("167","widget_twitter","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("168","widget_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("169","widget_flickr","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("170","widget_instagram","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("171","widget_news_feed_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("172","widget_mini_slidshow_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpcf_options VALUES("192","_site_transient_update_plugins","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1542379821;s:8:\"response\";a:1:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"4.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.4.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:3:\"5.0\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:1:{s:9:\"hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907\";s:2:\"1x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342\";}s:11:\"banners_rtl\";a:0:{}}}}","no");
INSERT INTO wpcf_options VALUES("193","_transient_mk_jupiter_theme_version","","yes");
INSERT INTO wpcf_options VALUES("174","_transient_timeout_mk_jupiter_theme_version","1542466222","no");
INSERT INTO wpcf_options VALUES("175","jupiter-data-tracking","no","yes");
INSERT INTO wpcf_options VALUES("176","artbees_api_key","1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d","yes");
INSERT INTO wpcf_options VALUES("177","mk_last_survey_check","2018-11-16 14:47:09","yes");
INSERT INTO wpcf_options VALUES("179","_transient_timeout_mk_request_user_info_1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d","1542383230","no");
INSERT INTO wpcf_options VALUES("180","_transient_mk_request_user_info_1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d","a:3:{s:6:\"status\";b:0;s:7:\"message\";s:40:\"API key verified but not VIP and master.\";s:19:\"purchase_key_object\";a:19:{s:2:\"id\";s:6:\"131108\";s:7:\"user_id\";s:5:\"66306\";s:12:\"purchase_key\";s:36:\"2f02bc61-695b-4ca9-a0ab-fff462d11df9\";s:7:\"api_key\";s:64:\"1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d\";s:10:\"product_id\";s:7:\"5177775\";s:8:\"validity\";s:1:\"0\";s:5:\"buyer\";s:15:\"MH1990Amsterdam\";s:9:\"is_active\";s:1:\"1\";s:6:\"domain\";s:33:\"thelighthousefoundation.didone.nl\";s:10:\"alexa_rank\";s:1:\"0\";s:11:\"create_date\";s:19:\"2018-04-08 09:12:30\";s:10:\"added_date\";s:19:\"2018-04-09 18:41:26\";s:12:\"last_checked\";s:19:\"2018-04-09 18:41:26\";s:11:\"is_verified\";s:1:\"0\";s:15:\"supported_until\";s:19:\"2018-10-08 00:12:30\";s:16:\"extended_support\";s:1:\"0\";s:20:\"generated_by_user_id\";N;s:9:\"is_master\";s:1:\"0\";s:4:\"user\";a:11:{s:2:\"ID\";s:5:\"66306\";s:10:\"user_login\";s:24:\"misjahermans90@gmail.com\";s:9:\"user_pass\";s:34:\"$P$BUUT43RRCWhoz/nKiUlb8k13TDftEa.\";s:13:\"user_nicename\";s:23:\"misjahermans90gmail-com\";s:10:\"user_email\";s:24:\"misjahermans90@gmail.com\";s:8:\"user_url\";s:0:\"\";s:15:\"user_registered\";s:19:\"2018-04-09 15:39:35\";s:19:\"user_activation_key\";s:0:\"\";s:11:\"user_status\";s:1:\"0\";s:12:\"display_name\";s:13:\"Misja Hermans\";s:12:\"purchasekeys\";a:1:{i:0;a:18:{s:2:\"id\";s:6:\"131108\";s:7:\"user_id\";s:5:\"66306\";s:12:\"purchase_key\";s:36:\"2f02bc61-695b-4ca9-a0ab-fff462d11df9\";s:7:\"api_key\";s:64:\"1afb6ffe1f25626522d3d0a358dcbc22f4b3051b291643d87c6276e1bb9ab97d\";s:10:\"product_id\";s:7:\"5177775\";s:8:\"validity\";s:1:\"0\";s:5:\"buyer\";s:15:\"MH1990Amsterdam\";s:9:\"is_active\";s:1:\"1\";s:6:\"domain\";s:33:\"thelighthousefoundation.didone.nl\";s:10:\"alexa_rank\";s:1:\"0\";s:11:\"create_date\";s:19:\"2018-04-08 09:12:30\";s:10:\"added_date\";s:19:\"2018-04-09 18:41:26\";s:12:\"last_checked\";s:19:\"2018-04-09 18:41:26\";s:11:\"is_verified\";s:1:\"0\";s:15:\"supported_until\";s:19:\"2018-10-08 00:12:30\";s:16:\"extended_support\";s:1:\"0\";s:20:\"generated_by_user_id\";N;s:9:\"is_master\";s:1:\"0\";}}}}}","no");
INSERT INTO wpcf_options VALUES("181","mk_atp_user","1","yes");
INSERT INTO wpcf_options VALUES("183","Jupiter_options","a:430:{s:10:\"skin_color\";s:7:\"#f97352\";s:12:\"smoothscroll\";s:4:\"true\";s:14:\"pages_comments\";s:5:\"false\";s:9:\"go_to_top\";s:4:\"true\";s:13:\"retina_images\";s:4:\"true\";s:17:\"responsive_images\";s:4:\"true\";s:20:\"image_resize_quality\";s:3:\"100\";s:11:\"svg_support\";s:5:\"false\";s:26:\"fullscreen_nav_logo_margin\";s:3:\"125\";s:4:\"logo\";s:0:\"\";s:17:\"light_header_logo\";s:0:\"\";s:18:\"sticky_header_logo\";s:0:\"\";s:15:\"responsive_logo\";s:0:\"\";s:11:\"footer_logo\";s:0:\"\";s:14:\"custom_favicon\";s:0:\"\";s:11:\"iphone_icon\";s:0:\"\";s:18:\"iphone_icon_retina\";s:0:\"\";s:9:\"ipad_icon\";s:0:\"\";s:16:\"ipad_icon_retina\";s:0:\"\";s:9:\"preloader\";s:5:\"false\";s:16:\"retina_preloader\";s:5:\"false\";s:14:\"preloader_logo\";s:0:\"\";s:20:\"preloader_icon_color\";s:7:\"#7c7c7c\";s:18:\"preloader_bg_color\";s:4:\"#fff\";s:23:\"section_preloader_color\";s:4:\"#fff\";s:19:\"preloader_animation\";s:10:\"ball_pulse\";s:21:\"disable_quick_contact\";s:4:\"true\";s:23:\"quick_contact_on_single\";s:4:\"true\";s:21:\"captcha_quick_contact\";s:4:\"true\";s:19:\"quick_contact_email\";s:39:\"admin@thelighthousefoundation.didone.nl\";s:19:\"quick_contact_title\";s:10:\"Contact Us\";s:18:\"quick_contact_desc\";s:89:\"We\'re not around right now. But you can send us an email and we\'ll get back to you, asap.\";s:20:\"twitter_consumer_key\";s:0:\"\";s:23:\"twitter_consumer_secret\";s:0:\"\";s:20:\"twitter_access_token\";s:0:\"\";s:27:\"twitter_access_token_secret\";s:0:\"\";s:17:\"mailchimp_api_key\";s:0:\"\";s:17:\"mailchimp_list_id\";s:0:\"\";s:15:\"mailchimp_optin\";s:5:\"false\";s:19:\"google_maps_api_key\";s:0:\"\";s:9:\"analytics\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:31:\"background_selector_orientation\";s:17:\"full_width_layout\";s:10:\"grid_width\";s:4:\"1140\";s:13:\"content_width\";s:2:\"73\";s:18:\"content_responsive\";s:3:\"960\";s:20:\"responsive_nav_width\";s:4:\"1140\";s:19:\"stick_template_page\";s:5:\"false\";s:11:\"body_border\";s:5:\"false\";s:21:\"body_border_thickness\";s:2:\"50\";s:17:\"body_border_color\";s:4:\"#fff\";s:29:\"body_border_on_mobile_devices\";s:5:\"false\";s:24:\"page_title_expand_header\";s:4:\"true\";s:24:\"boxed_layout_shadow_size\";s:0:\"\";s:29:\"boxed_layout_shadow_intensity\";s:0:\"\";s:18:\"general_backgounds\";s:0:\"\";s:20:\"bg_panel_image_style\";s:8:\"no-image\";s:15:\"bg_panel_upload\";s:0:\"\";s:20:\"bg_panel_color_style\";s:6:\"single\";s:14:\"bg_panel_color\";s:0:\"\";s:16:\"bg_panel_color_2\";s:0:\"\";s:21:\"grandient_color_style\";s:6:\"linear\";s:21:\"grandient_color_angle\";s:8:\"vertical\";s:15:\"bg_panel_repeat\";s:0:\"\";s:19:\"bg_panel_attachment\";s:0:\"\";s:17:\"bg_panel_position\";s:0:\"\";s:13:\"bg_panel_size\";s:5:\"false\";s:10:\"body_color\";s:4:\"#fff\";s:19:\"body_color_gradient\";s:6:\"single\";s:12:\"body_color_2\";s:0:\"\";s:25:\"body_color_gradient_style\";s:6:\"linear\";s:25:\"body_color_gradient_angle\";s:8:\"vertical\";s:10:\"body_image\";s:0:\"\";s:9:\"body_size\";s:5:\"false\";s:13:\"body_position\";s:0:\"\";s:15:\"body_attachment\";s:0:\"\";s:11:\"body_repeat\";s:0:\"\";s:11:\"body_source\";s:8:\"no-image\";s:10:\"page_color\";s:4:\"#fff\";s:19:\"page_color_gradient\";s:6:\"single\";s:12:\"page_color_2\";s:0:\"\";s:25:\"page_color_gradient_style\";s:6:\"linear\";s:25:\"page_color_gradient_angle\";s:8:\"vertical\";s:10:\"page_image\";s:0:\"\";s:9:\"page_size\";s:5:\"false\";s:13:\"page_position\";s:0:\"\";s:15:\"page_attachment\";s:0:\"\";s:11:\"page_repeat\";s:0:\"\";s:11:\"page_source\";s:8:\"no-image\";s:12:\"header_color\";s:4:\"#fff\";s:21:\"header_color_gradient\";s:6:\"single\";s:14:\"header_color_2\";s:0:\"\";s:27:\"header_color_gradient_style\";s:6:\"linear\";s:27:\"header_color_gradient_angle\";s:8:\"vertical\";s:12:\"header_image\";s:0:\"\";s:11:\"header_size\";s:5:\"false\";s:15:\"header_position\";s:0:\"\";s:17:\"header_attachment\";s:0:\"\";s:13:\"header_repeat\";s:0:\"\";s:13:\"header_source\";s:8:\"no-image\";s:12:\"banner_color\";s:7:\"#f7f7f7\";s:21:\"banner_color_gradient\";s:6:\"single\";s:14:\"banner_color_2\";s:0:\"\";s:27:\"banner_color_gradient_style\";s:6:\"linear\";s:27:\"banner_color_gradient_angle\";s:8:\"vertical\";s:12:\"banner_image\";s:0:\"\";s:11:\"banner_size\";s:4:\"true\";s:15:\"banner_position\";s:0:\"\";s:17:\"banner_attachment\";s:0:\"\";s:13:\"banner_repeat\";s:0:\"\";s:13:\"banner_source\";s:8:\"no-image\";s:12:\"footer_color\";s:7:\"#3d4045\";s:21:\"footer_color_gradient\";s:6:\"single\";s:14:\"footer_color_2\";s:0:\"\";s:27:\"footer_color_gradient_style\";s:6:\"linear\";s:27:\"footer_color_gradient_angle\";s:8:\"vertical\";s:12:\"footer_image\";s:0:\"\";s:11:\"footer_size\";s:5:\"false\";s:15:\"footer_position\";s:0:\"\";s:17:\"footer_attachment\";s:0:\"\";s:13:\"footer_repeat\";s:0:\"\";s:13:\"footer_source\";s:8:\"no-image\";s:11:\"body_weight\";i:400;s:14:\"body_font_size\";s:2:\"14\";s:16:\"body_line_height\";s:4:\"1.66\";s:15:\"body_text_color\";s:7:\"#777777\";s:7:\"a_color\";s:7:\"#2e2e2e\";s:13:\"a_color_hover\";s:7:\"#f97352\";s:12:\"strong_color\";s:7:\"#f97352\";s:6:\"p_size\";s:2:\"16\";s:13:\"p_line_height\";s:4:\"1.66\";s:7:\"p_color\";s:7:\"#777777\";s:20:\"headings_line_height\";s:3:\"1.3\";s:9:\"h1_weight\";i:600;s:12:\"h1_transform\";s:9:\"uppercase\";s:7:\"h1_size\";s:2:\"36\";s:8:\"h1_color\";s:7:\"#404040\";s:9:\"h2_weight\";i:600;s:12:\"h2_transform\";s:9:\"uppercase\";s:7:\"h2_size\";s:2:\"30\";s:8:\"h2_color\";s:7:\"#404040\";s:9:\"h3_weight\";i:600;s:12:\"h3_transform\";s:9:\"uppercase\";s:7:\"h3_size\";s:2:\"24\";s:8:\"h3_color\";s:7:\"#404040\";s:9:\"h4_weight\";i:600;s:12:\"h4_transform\";s:9:\"uppercase\";s:7:\"h4_size\";s:2:\"18\";s:8:\"h4_color\";s:7:\"#404040\";s:9:\"h5_weight\";i:600;s:12:\"h5_transform\";s:9:\"uppercase\";s:7:\"h5_size\";s:2:\"16\";s:8:\"h5_color\";s:7:\"#404040\";s:9:\"h6_weight\";i:600;s:12:\"h6_transform\";s:9:\"uppercase\";s:7:\"h6_size\";s:2:\"14\";s:8:\"h6_color\";s:7:\"#404040\";s:21:\"header_layout_builder\";s:16:\"pre_built_header\";s:18:\"theme_header_style\";s:1:\"1\";s:14:\"secondary_menu\";s:10:\"fullscreen\";s:18:\"header_burger_size\";s:5:\"small\";s:23:\"seondary_header_for_all\";s:5:\"false\";s:18:\"vertical_menu_anim\";s:1:\"1\";s:26:\"vertical_header_logo_align\";s:6:\"center\";s:28:\"vertical_header_logo_padding\";s:2:\"10\";s:21:\"vertical_header_align\";s:4:\"left\";s:23:\"vertical_menu_copyright\";s:41:\"Copyright All Rights Reserved &copy; 2017\";s:11:\"header_grid\";s:4:\"true\";s:16:\"hide_header_logo\";s:4:\"true\";s:14:\"logo_in_middle\";s:5:\"false\";s:15:\"hide_header_nav\";s:4:\"true\";s:22:\"header_search_location\";s:17:\"fullscreen_search\";s:22:\"header_start_tour_text\";s:0:\"\";s:22:\"header_start_tour_page\";s:0:\"\";s:15:\"start_tour_size\";s:2:\"14\";s:13:\"loggedin_menu\";s:0:\"\";s:13:\"header_height\";s:2:\"90\";s:17:\"res_header_height\";s:2:\"90\";s:14:\"header_opacity\";s:1:\"1\";s:27:\"header_btn_border_thickness\";s:1:\"1\";s:19:\"header_border_color\";s:7:\"#ededed\";s:16:\"start_tour_color\";s:4:\"#333\";s:19:\"header_burger_color\";s:0:\"\";s:17:\"main_nav_bg_color\";s:0:\"\";s:14:\"main_nav_hover\";s:1:\"5\";s:19:\"main_nav_top_weight\";i:600;s:19:\"main_menu_transform\";s:9:\"uppercase\";s:17:\"main_nav_top_size\";s:2:\"13\";s:27:\"main_nav_top_letter_spacing\";s:0:\"\";s:19:\"main_nav_item_space\";s:2:\"20\";s:23:\"main_nav_top_text_color\";s:7:\"#444444\";s:23:\"main_nav_top_hover_skin\";s:7:\"#f97352\";s:28:\"main_nav_top_hover_txt_color\";s:4:\"#fff\";s:19:\"main_nav_sub_weight\";i:400;s:22:\"main_nav_sub_transform\";s:9:\"uppercase\";s:17:\"main_nav_sub_size\";s:2:\"12\";s:27:\"main_nav_sub_letter_spacing\";s:1:\"1\";s:23:\"main_nav_sub_text_color\";s:7:\"#b3b3b3\";s:29:\"main_nav_sub_text_color_hover\";s:7:\"#ffffff\";s:27:\"main_nav_sub_hover_bg_color\";s:0:\"\";s:29:\"main_nav_sub_border_top_color\";s:7:\"#f97352\";s:21:\"main_nav_sub_bg_color\";s:7:\"#333333\";s:23:\"main_nav_sub_icon_color\";s:7:\"#e0e0e0\";s:14:\"nav_sub_shadow\";s:5:\"false\";s:26:\"sub_level_box_border_color\";s:0:\"\";s:18:\"main_nav_sub_width\";s:3:\"230\";s:25:\"main_nav_mega_title_color\";s:7:\"#ffffff\";s:23:\"mega_menu_divider_color\";s:0:\"\";s:22:\"header_social_location\";s:0:\"\";s:27:\"header_social_networks_site\";s:0:\"\";s:26:\"header_social_networks_url\";s:0:\"\";s:28:\"header_social_networks_style\";s:6:\"circle\";s:16:\"header_icon_size\";s:5:\"small\";s:19:\"header_social_color\";s:7:\"#999999\";s:25:\"header_social_hover_color\";s:4:\"#ccc\";s:27:\"header_social_bg_main_color\";s:7:\"#232323\";s:22:\"header_social_bg_color\";s:7:\"#232323\";s:26:\"header_social_border_color\";s:7:\"#999999\";s:16:\"header_mobile_bg\";s:0:\"\";s:20:\"responsive_nav_color\";s:4:\"#fff\";s:29:\"header_mobile_search_input_bg\";s:0:\"\";s:32:\"header_mobile_search_input_color\";s:0:\"\";s:24:\"responsive_nav_txt_color\";s:7:\"#444444\";s:19:\"header_sticky_style\";s:5:\"fixed\";s:20:\"sticky_header_offset\";s:6:\"header\";s:20:\"header_scroll_height\";s:2:\"55\";s:21:\"header_sticky_opacity\";s:1:\"1\";s:26:\"sticky_header_border_color\";s:0:\"\";s:13:\"dash_bg_color\";s:4:\"#444\";s:25:\"dash_top_menu_text_weight\";i:600;s:23:\"dash_top_menu_transform\";s:9:\"uppercase\";s:23:\"dash_top_menu_text_size\";s:2:\"13\";s:19:\"dash_nav_link_color\";s:4:\"#fff\";s:25:\"dash_nav_link_hover_color\";s:4:\"#fff\";s:23:\"dash_nav_bg_hover_color\";s:0:\"\";s:25:\"dash_sub_menu_text_weight\";i:400;s:23:\"dash_sub_menu_transform\";s:9:\"uppercase\";s:23:\"dash_sub_menu_text_size\";s:2:\"12\";s:17:\"dash_title_weight\";s:6:\"bolder\";s:20:\"dash_title_transform\";s:9:\"uppercase\";s:15:\"dash_title_size\";s:2:\"14\";s:16:\"dash_title_color\";s:4:\"#fff\";s:16:\"dash_text_weight\";i:400;s:14:\"dash_text_size\";s:2:\"12\";s:15:\"dash_text_color\";s:4:\"#eee\";s:16:\"dash_links_color\";s:7:\"#fafafa\";s:22:\"dash_links_hover_color\";s:0:\"\";s:19:\"fullscreen_nav_logo\";s:4:\"dark\";s:26:\"fullscreen_nav_mobile_logo\";s:4:\"dark\";s:33:\"fullscreen_nav_mobile_logo_custom\";s:0:\"\";s:23:\"fullscreen_nav_bg_color\";s:4:\"#444\";s:25:\"fullscreen_close_btn_skin\";s:5:\"light\";s:31:\"fullscreen_nav_menu_font_weight\";s:6:\"bolder\";s:34:\"fullscreen_nav_menu_text_transform\";s:9:\"uppercase\";s:29:\"fullscreen_nav_menu_font_size\";s:2:\"16\";s:34:\"fullscreen_nav_menu_letter_spacing\";s:0:\"\";s:26:\"fullscreen_nav_menu_gutter\";s:2:\"25\";s:25:\"fullscreen_nav_link_color\";s:4:\"#fff\";s:29:\"fullscreen_nav_link_hov_color\";s:4:\"#444\";s:32:\"fullscreen_nav_link_hov_bg_color\";s:4:\"#fff\";s:18:\"enable_header_date\";s:5:\"false\";s:22:\"header_toolbar_tagline\";s:0:\"\";s:20:\"header_toolbar_login\";s:4:\"true\";s:24:\"header_toolbar_subscribe\";s:5:\"false\";s:20:\"header_toolbar_email\";s:0:\"\";s:20:\"header_toolbar_phone\";s:0:\"\";s:17:\"header_toolbar_bg\";s:7:\"#ffffff\";s:24:\"header_mobile_toolbar_bg\";s:0:\"\";s:27:\"header_toolbar_border_color\";s:0:\"\";s:30:\"header_toolbar_search_input_bg\";s:0:\"\";s:24:\"header_toolbar_txt_color\";s:7:\"#999999\";s:25:\"header_toolbar_link_color\";s:7:\"#999999\";s:31:\"header_toolbar_search_input_txt\";s:7:\"#c7c7c7\";s:27:\"header_mobile_toolbar_color\";s:0:\"\";s:32:\"header_mobile_toolbar_link_color\";s:0:\"\";s:35:\"header_toolbar_social_network_color\";s:7:\"#999999\";s:34:\"header_mobile_toolbar_social_color\";s:0:\"\";s:17:\"page_title_global\";s:4:\"true\";s:19:\"banner_border_color\";s:7:\"#ededed\";s:21:\"page_introduce_weight\";i:400;s:20:\"page_title_transform\";s:9:\"uppercase\";s:25:\"page_introduce_title_size\";s:2:\"20\";s:35:\"page_introduce_title_letter_spacing\";s:1:\"2\";s:16:\"page_title_color\";s:7:\"#4d4d4d\";s:17:\"page_title_shadow\";s:5:\"false\";s:28:\"page_introduce_subtitle_size\";s:2:\"14\";s:33:\"page_introduce_subtitle_transform\";s:4:\"none\";s:19:\"page_subtitle_color\";s:7:\"#a3a3a3\";s:18:\"disable_breadcrumb\";s:4:\"true\";s:15:\"breadcrumb_skin\";s:4:\"dark\";s:5:\"fonts\";a:1:{i:0;a:6:{s:4:\"type\";s:3:\"all\";s:10:\"fontFamily\";s:0:\"\";s:8:\"elements\";a:1:{i:0;s:4:\"body\";}s:6:\"subset\";s:0:\"\";s:12:\"currentField\";s:10:\"font-alert\";s:7:\"default\";s:4:\"true\";}}s:14:\"disable_footer\";s:4:\"true\";s:21:\"footer_disable_mobile\";s:5:\"false\";s:12:\"boxed_footer\";s:4:\"true\";s:11:\"footer_type\";s:1:\"1\";s:14:\"footer_columns\";s:1:\"4\";s:20:\"footer_top_thickness\";s:0:\"\";s:23:\"footer_top_border_color\";s:0:\"\";s:13:\"footer_gutter\";s:1:\"2\";s:22:\"footer_wrapper_padding\";s:2:\"30\";s:27:\"footer_widget_margin_bottom\";s:2:\"40\";s:19:\"footer_title_weight\";s:6:\"bolder\";s:22:\"footer_title_transform\";s:9:\"uppercase\";s:17:\"footer_title_size\";s:2:\"14\";s:18:\"footer_title_color\";s:4:\"#fff\";s:18:\"footer_text_weight\";i:400;s:16:\"footer_text_size\";s:2:\"14\";s:17:\"footer_text_color\";s:7:\"#808080\";s:18:\"footer_links_color\";s:7:\"#999999\";s:24:\"footer_links_hover_color\";s:0:\"\";s:18:\"disable_sub_footer\";s:4:\"true\";s:17:\"enable_footer_nav\";s:4:\"true\";s:9:\"copyright\";s:41:\"Copyright All Rights Reserved &copy; 2017\";s:19:\"sub_footer_bg_color\";s:7:\"#43474d\";s:14:\"copyright_size\";s:2:\"11\";s:24:\"copyright_letter_spacing\";s:1:\"1\";s:25:\"sub_footer_nav_copy_color\";s:7:\"#8c8e91\";s:15:\"custom_sidebars\";s:0:\"\";s:20:\"sidebar_title_weight\";s:6:\"bolder\";s:23:\"sidebar_title_transform\";s:9:\"uppercase\";s:18:\"sidebar_title_size\";s:2:\"14\";s:19:\"sidebar_title_color\";s:7:\"#333333\";s:19:\"sidebar_text_weight\";i:400;s:17:\"sidebar_text_size\";s:2:\"14\";s:18:\"sidebar_text_color\";s:7:\"#999999\";s:19:\"sidebar_links_color\";s:7:\"#999999\";s:25:\"sidebar_links_hover_color\";s:0:\"\";s:18:\"search_page_layout\";s:5:\"right\";s:17:\"search_page_title\";s:6:\"Search\";s:23:\"search_disable_subtitle\";s:4:\"true\";s:13:\"single_layout\";s:4:\"full\";s:17:\"single_blog_style\";s:7:\"compact\";s:28:\"single_bold_hero_full_height\";s:4:\"true\";s:29:\"single_disable_featured_image\";s:4:\"true\";s:23:\"bold_single_hero_height\";s:3:\"800\";s:28:\"single_featured_image_height\";s:3:\"300\";s:20:\"blog_single_img_crop\";s:4:\"true\";s:17:\"blog_single_title\";s:4:\"true\";s:14:\"blog_prev_next\";s:4:\"true\";s:28:\"blog_prev_next_same_category\";s:4:\"true\";s:27:\"enable_single_related_posts\";s:4:\"true\";s:20:\"blog_single_comments\";s:4:\"true\";s:18:\"enable_blog_author\";s:4:\"true\";s:18:\"single_blog_social\";s:4:\"true\";s:19:\"blog_heading_weight\";i:600;s:22:\"blog_heading_transform\";s:0:\"\";s:17:\"blog_heading_size\";s:0:\"\";s:18:\"blog_heading_color\";s:0:\"\";s:18:\"blog_body_h1_color\";s:0:\"\";s:18:\"blog_body_h2_color\";s:0:\"\";s:18:\"blog_body_h3_color\";s:0:\"\";s:18:\"blog_body_h4_color\";s:0:\"\";s:18:\"blog_body_h5_color\";s:0:\"\";s:18:\"blog_body_h6_color\";s:0:\"\";s:16:\"blog_body_weight\";i:400;s:19:\"blog_body_font_size\";s:0:\"\";s:21:\"blog_body_line_height\";s:0:\"\";s:15:\"blog_body_color\";s:0:\"\";s:17:\"blog_body_a_color\";s:0:\"\";s:23:\"blog_body_a_color_hover\";s:0:\"\";s:26:\"blog_body_strong_tag_color\";s:0:\"\";s:19:\"single_meta_section\";s:4:\"true\";s:18:\"diable_single_tags\";s:4:\"true\";s:19:\"archive_page_layout\";s:5:\"right\";s:18:\"archive_loop_style\";s:6:\"modern\";s:18:\"archive_page_title\";s:8:\"Archives\";s:24:\"archive_disable_subtitle\";s:4:\"true\";s:25:\"archive_blog_image_height\";s:3:\"350\";s:17:\"archive_blog_meta\";s:4:\"true\";s:24:\"archive_pagination_style\";s:1:\"1\";s:27:\"news_disable_featured_image\";s:4:\"true\";s:26:\"news_featured_image_height\";s:3:\"340\";s:9:\"news_slug\";s:10:\"news-posts\";s:23:\"portfolio_single_layout\";s:4:\"full\";s:29:\"Portfolio_single_image_height\";s:3:\"500\";s:21:\"single_portfolio_cats\";s:5:\"false\";s:30:\"enable_portfolio_similar_posts\";s:4:\"true\";s:19:\"portfolio_next_prev\";s:4:\"true\";s:33:\"portfolio_prev_next_same_category\";s:4:\"true\";s:24:\"enable_portfolio_comment\";s:5:\"false\";s:23:\"single_portfolio_social\";s:4:\"true\";s:14:\"portfolio_slug\";s:15:\"portfolio-posts\";s:18:\"portfolio_cat_slug\";s:18:\"portfolio_category\";s:24:\"stick_template_portfolio\";s:5:\"false\";s:24:\"archive_portfolio_layout\";s:5:\"right\";s:23:\"archive_portfolio_style\";s:7:\"classic\";s:30:\"archive_portfolio_image_height\";s:3:\"400\";s:24:\"archive_portfolio_column\";s:1:\"3\";s:34:\"archive_portfolio_pagination_style\";s:1:\"1\";s:15:\"shop_customizer\";s:5:\"false\";s:20:\"shop_archive_columns\";s:7:\"default\";s:19:\"woocommerce_catalog\";s:5:\"false\";s:23:\"woo_category_image_size\";s:4:\"crop\";s:31:\"woocommerce_category_page_title\";s:4:\"Shop\";s:29:\"woocommerce_use_product_title\";s:5:\"false\";s:30:\"woocommerce_use_category_title\";s:5:\"false\";s:37:\"woocommerce_use_category_filter_title\";s:5:\"false\";s:13:\"shopping_cart\";s:4:\"true\";s:19:\"add_cart_responsive\";s:4:\"true\";s:19:\"woo_loop_image_size\";s:4:\"crop\";s:19:\"woo_loop_img_height\";s:3:\"300\";s:26:\"woocommerce_loop_show_desc\";s:5:\"false\";s:35:\"woocommerce_loop_enable_love_button\";s:4:\"true\";s:25:\"woocommerce_single_layout\";s:4:\"full\";s:32:\"woocommerce_single_product_title\";s:4:\"true\";s:20:\"woo_single_prev_next\";s:4:\"true\";s:27:\"woo_prev_next_same_category\";s:4:\"true\";s:33:\"woocommerce_single_social_network\";s:4:\"true\";s:9:\"minify-js\";s:4:\"true\";s:10:\"minify-css\";s:4:\"true\";s:25:\"move-shortcode-css-footer\";s:4:\"true\";s:17:\"remove-js-css-ver\";s:4:\"true\";s:15:\"global_lazyload\";s:4:\"true\";s:19:\"portfolio-post-type\";s:4:\"true\";s:14:\"news-post-type\";s:4:\"true\";s:13:\"faq-post-type\";s:4:\"true\";s:21:\"photo_album-post-type\";s:4:\"true\";s:17:\"pricing-post-type\";s:4:\"true\";s:17:\"clients-post-type\";s:4:\"true\";s:19:\"employees-post-type\";s:4:\"true\";s:21:\"testimonial-post-type\";s:4:\"true\";s:26:\"animated-columns-post-type\";s:4:\"true\";s:14:\"edge-post-type\";s:4:\"true\";s:20:\"tab_slider-post-type\";s:4:\"true\";s:19:\"slideshow-post-type\";s:5:\"false\";s:24:\"banner_builder-post-type\";s:5:\"false\";s:10:\"custom_css\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:20:\"theme_export_options\";s:0:\"\";s:20:\"theme_import_options\";s:0:\"\";}","yes");
INSERT INTO wpcf_options VALUES("184","global_assets_timestamp","1542379799","yes");
INSERT INTO wpcf_options VALUES("185","mk_theme_options_css_file","","yes");
INSERT INTO wpcf_options VALUES("186","jupiter_theme_version","6.1.2","yes");
INSERT INTO wpcf_options VALUES("187","Jupiter_options_imported","false","yes");
INSERT INTO wpcf_options VALUES("191","theme_mods_jupiter-child","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}}","yes");



CREATE TABLE `wpcf_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_postmeta VALUES("1","2","_wp_page_template","default");
INSERT INTO wpcf_postmeta VALUES("2","3","_wp_page_template","default");
INSERT INTO wpcf_postmeta VALUES("3","5","_wp_attached_file","2018/11/tiwaz.zip");
INSERT INTO wpcf_postmeta VALUES("4","5","_wp_attachment_context","upgrader");
INSERT INTO wpcf_postmeta VALUES("5","6","_wp_attached_file","2018/11/orthosie.zip");
INSERT INTO wpcf_postmeta VALUES("6","6","_wp_attachment_context","upgrader");



CREATE TABLE `wpcf_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_posts VALUES("1","1","2018-11-16 13:49:58","2018-11-16 13:49:58","Welcome to WordPress. This is your first post. Edit or delete it, then start writing!","Hello world!","","publish","open","open","","hello-world","","","2018-11-16 13:49:58","2018-11-16 13:49:58","","0","http://thelighthousefoundation.didone.nl/thelighthousefoundation/?p=1","0","post","","1");
INSERT INTO wpcf_posts VALUES("2","1","2018-11-16 13:49:58","2018-11-16 13:49:58","This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!","Sample Page","","publish","closed","open","","sample-page","","","2018-11-16 13:49:58","2018-11-16 13:49:58","","0","http://thelighthousefoundation.didone.nl/thelighthousefoundation/?page_id=2","0","page","","0");
INSERT INTO wpcf_posts VALUES("3","1","2018-11-16 13:49:58","2018-11-16 13:49:58","<h2>Who we are</h2><p>Our website address is: http://thelighthousefoundation.didone.nl/thelighthousefoundation.</p><h2>What personal data we collect and why we collect it</h2><h3>Comments</h3><p>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><h3>Media</h3><p>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><h3>Contact forms</h3><h3>Cookies</h3><p>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><p>If you have an account and you log in to this site, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><h3>Embedded content from other websites</h3><p>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><h3>Analytics</h3><h2>Who we share your data with</h2><h2>How long we retain your data</h2><p>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><h2>What rights you have over your data</h2><p>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><h2>Where we send your data</h2><p>Visitor comments may be checked through an automated spam detection service.</p><h2>Your contact information</h2><h2>Additional information</h2><h3>How we protect your data</h3><h3>What data breach procedures we have in place</h3><h3>What third parties we receive data from</h3><h3>What automated decision making and/or profiling we do with user data</h3><h3>Industry regulatory disclosure requirements</h3>","Privacy Policy","","draft","closed","open","","privacy-policy","","","2018-11-16 13:49:58","2018-11-16 13:49:58","","0","http://thelighthousefoundation.didone.nl/thelighthousefoundation/?page_id=3","0","page","","0");
INSERT INTO wpcf_posts VALUES("4","1","2018-11-16 13:50:52","0000-00-00 00:00:00","","Automatische concepten","","auto-draft","open","open","","","","","2018-11-16 13:50:52","0000-00-00 00:00:00","","0","http://thelighthousefoundation.didone.nl/thelighthousefoundation/?p=4","0","post","","0");
INSERT INTO wpcf_posts VALUES("5","1","2018-11-16 14:23:33","2018-11-16 14:23:33","http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2018/11/tiwaz.zip","tiwaz.zip","","private","open","closed","","tiwaz-zip","","","2018-11-16 14:23:33","2018-11-16 14:23:33","","0","http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2018/11/tiwaz.zip","0","attachment","","0");
INSERT INTO wpcf_posts VALUES("6","1","2018-11-16 14:26:10","2018-11-16 14:26:10","http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2018/11/orthosie.zip","orthosie.zip","","private","open","closed","","orthosie-zip","","","2018-11-16 14:26:10","2018-11-16 14:26:10","","0","http://thelighthousefoundation.didone.nl/thelighthousefoundation/wp-content/uploads/2018/11/orthosie.zip","0","attachment","","0");



CREATE TABLE `wpcf_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_term_relationships VALUES("1","1","0");



CREATE TABLE `wpcf_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_term_taxonomy VALUES("1","1","category","","0","1");



CREATE TABLE `wpcf_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `wpcf_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpcf_terms VALUES("1","Uncategorized","uncategorized","0");

